/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.images.util;

import java.io.IOException;
import java.io.InputStream;

public class FastByteArrayInputStream
extends InputStream {
    protected byte[] buf = null;
    protected int count = 0;
    protected int pos = 0;
    protected int mark = 0;

    public FastByteArrayInputStream(byte[] buf) {
        this.buf = buf;
        this.count = buf.length;
    }

    public FastByteArrayInputStream(byte[] buf, int count) {
        this.buf = buf;
        this.count = count;
    }

    @Override
    public final int available() {
        return this.count - this.pos;
    }

    @Override
    public final int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public final int read(byte[] b, int off, int len) {
        if (this.pos >= this.count) {
            return -1;
        }
        int avail = this.count - this.pos;
        if (len > avail) {
            len = avail;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public final long skip(long n) {
        long k = this.count - this.pos;
        if (n < k) {
            k = n < 0L ? 0L : n;
        }
        this.pos = (int)((long)this.pos + k);
        return k;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    @Override
    public synchronized void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() throws IOException {
    }
}

