/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.images.util;

import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class CodeTimer {
    private static String EOL = System.getProperty("line.separator");
    private String _description;
    private List<Long> _times;
    private long _startCounter;
    private long _endCounter;
    private long _frequency;
    private Writer _writer = null;

    public CodeTimer(String description) {
        this._description = description;
        this._times = new ArrayList<Long>();
        this._startCounter = System.nanoTime();
        this._frequency = 1000000000L;
        this._writer = new OutputStreamWriter(System.out);
    }

    public void start() {
        this._startCounter = System.nanoTime();
    }

    public void reset() {
        this._times = new ArrayList<Long>();
        this._startCounter = System.nanoTime();
    }

    public void stop() {
        this.stop(false, false, null);
    }

    public void stop(boolean printelapsed) {
        this.stop(printelapsed, false, null);
    }

    public void stop(boolean printelapsed, boolean asdouble) {
        this.stop(printelapsed, asdouble, null);
    }

    public void stop(boolean printelapsed, boolean asdouble, String auxmsg) {
        this._endCounter = System.nanoTime();
        String msg = null;
        if (printelapsed && (msg = asdouble ? String.format("%s: %f ms%s", this._description, this.getElapsedMillisDouble(), auxmsg == null ? "" : " (" + auxmsg + ")") : String.format("%s: %d ms%s", this._description, this.getElapsedMillis(), auxmsg == null ? "" : " (" + auxmsg + ")")) != null && this._writer != null) {
            this.writeln(msg);
        }
        this._times.add(this.getElapsedMillis());
    }

    public String getDescription() {
        return this._description;
    }

    public long getElapsedMillis() {
        double elapsed = (double)(this._endCounter - this._startCounter) / (double)this._frequency * 1000.0;
        return (long)elapsed;
    }

    public double getElapsedMillisDouble() {
        return (double)(this._endCounter - this._startCounter) / (double)this._frequency * 1000.0;
    }

    public long getAverage() {
        return this.getAverage(false);
    }

    private void writeln(String msg) {
        try {
            this._writer.write(msg + EOL);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                this._writer.flush();
            }
            catch (Exception exception) {}
        }
    }

    public long getAverage(boolean dump) {
        long avg;
        long total = 0L;
        for (Long l : this._times) {
            total += l.longValue();
        }
        long l = avg = this._times.size() == 0 ? 0L : total / (long)this._times.size();
        if (dump && this._writer != null) {
            this.writeln("Average : " + avg);
        }
        return avg;
    }

    public List<Long> getElapsedTimes() {
        return this._times;
    }
}

