/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.images.metadata;

import au.org.ala.images.metadata.AbstractMetadataParser;
import au.org.ala.images.metadata.ImageMetadataExtractor;
import au.org.ala.images.metadata.MP3MetadataParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;

public class MetadataExtractor {
    private static List<AbstractMetadataParser> _REGISTRY = new ArrayList<AbstractMetadataParser>();

    private static void register(AbstractMetadataParser parser) {
        _REGISTRY.add(parser);
    }

    public Map<String, String> readMetadata(File file) throws IOException {
        return this.readMetadata(FileUtils.readFileToByteArray((File)file), file.getName());
    }

    public Map<String, String> readMetadata(byte[] bytes, String filename) {
        String contentType;
        HashMap<String, String> map = new HashMap<String, String>();
        if (bytes != null && bytes.length > 0 && StringUtils.isNotEmpty((String)(contentType = this.detectContentType(bytes, filename)))) {
            for (AbstractMetadataParser p : _REGISTRY) {
                Matcher m = p.getContentTypePattern().matcher(contentType);
                if (!m.matches()) continue;
                p.extractMetadata(bytes, map);
                break;
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String detectContentType(byte[] bytes, String filename) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        BufferedInputStream bis = new BufferedInputStream(bais);
        try {
            AutoDetectParser parser = new AutoDetectParser();
            Detector detector = parser.getDetector();
            Metadata md = new Metadata();
            if (filename != null) {
                md.add("resourceName", filename);
            }
            MediaType mediaType = detector.detect((InputStream)bis, md);
            String string = mediaType.toString();
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                ((InputStream)bais).close();
                ((InputStream)bis).close();
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        return null;
    }

    static {
        MetadataExtractor.register(new ImageMetadataExtractor());
        MetadataExtractor.register(new MP3MetadataParser());
    }
}

