/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.images.metadata;

import au.org.ala.images.metadata.AbstractMetadataParser;
import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageMetadataExtractor
extends AbstractMetadataParser {
    protected Logger logger = LoggerFactory.getLogger((String)"ImageMetadataExtractor");

    @Override
    public Pattern getContentTypePattern() {
        return Pattern.compile("^image/(.*)$");
    }

    @Override
    public void extractMetadata(byte[] bytes, Map<String, String> md) {
        BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(bytes));
        try {
            Metadata metadata = ImageMetadataReader.readMetadata((InputStream)bis, (long)bytes.length);
            for (Directory directory : metadata.getDirectories()) {
                for (Tag tag : directory.getTags()) {
                    String value;
                    String key = tag.getTagName();
                    if (md.containsKey(key)) {
                        key = String.format("%s (%s)", tag.getTagName(), tag.getDirectoryName());
                    }
                    if (StringUtils.isNotEmpty((String)(value = directory.getDescription(tag.getTagType()))) && value.startsWith("[") && value.endsWith("bytes]")) {
                        byte[] tagBytes = directory.getByteArray(tag.getTagType());
                        value = Base64.encodeBase64String((byte[])tagBytes);
                    }
                    md.put(key, value);
                }
            }
        }
        catch (Exception ex) {
            this.logger.debug(ex.getMessage(), (Throwable)ex);
        }
    }
}

