/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.images.util;

import au.org.ala.images.util.DefaultImageReaderSelectionStrategy;
import au.org.ala.images.util.FastByteArrayInputStream;
import au.org.ala.images.util.ImageReaderSelectionStrategy;
import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.jpeg.JpegDirectory;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ImageReaderUtils {
    public static ImageReader findCompatibleImageReader(byte[] imageBytes) {
        return ImageReaderUtils.findCompatibleImageReader(imageBytes, new DefaultImageReaderSelectionStrategy());
    }

    public static ImageReader findCompatibleImageReader(byte[] imageBytes, ImageReaderSelectionStrategy selectionStrategy) {
        try {
            FastByteArrayInputStream fbis = new FastByteArrayInputStream(imageBytes);
            ImageInputStream iis = ImageIO.createImageInputStream(fbis);
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            ArrayList<ImageReader> candidates = new ArrayList<ImageReader>();
            while (iter.hasNext()) {
                ImageReader candidate = iter.next();
                try {
                    fbis = new FastByteArrayInputStream(imageBytes);
                    iis = ImageIO.createImageInputStream(fbis);
                    iis.mark();
                    candidate.setInput(iis);
                    int height = candidate.getHeight(0);
                    candidates.add(candidate);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ImageReader result = null;
            if (selectionStrategy != null) {
                result = selectionStrategy.selectImageReader(candidates);
            } else if (candidates.size() > 0) {
                result = candidates.get(0);
            }
            try {
                if (result != null) {
                    result.setInput(ImageReaderUtils.rotate(imageBytes));
                    return result;
                }
            }
            catch (IOException ioex) {
                throw new RuntimeException(ioex);
            }
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex);
        }
        return null;
    }

    public static ImageInputStream rotate(byte[] imageBytes) throws IOException {
        try {
            BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(imageBytes));
            Metadata metadata = ImageMetadataReader.readMetadata((InputStream)bis, (long)imageBytes.length);
            Collection exifIFD0 = metadata.getDirectoriesOfType(ExifIFD0Directory.class);
            JpegDirectory jpegDirectory = (JpegDirectory)metadata.getFirstDirectoryOfType(JpegDirectory.class);
            if (jpegDirectory == null || exifIFD0.isEmpty()) {
                FastByteArrayInputStream fbis = new FastByteArrayInputStream(imageBytes);
                return ImageIO.createImageInputStream(fbis);
            }
            int orientation = ((ExifIFD0Directory)exifIFD0.iterator().next()).getInt(274);
            int width = jpegDirectory.getImageWidth();
            int height = jpegDirectory.getImageHeight();
            AffineTransform affineTransform = new AffineTransform();
            switch (orientation) {
                case 1: {
                    break;
                }
                case 2: {
                    affineTransform.scale(-1.0, 1.0);
                    affineTransform.translate(-width, 0.0);
                    break;
                }
                case 3: {
                    affineTransform.translate(width, height);
                    affineTransform.rotate(Math.PI);
                    break;
                }
                case 4: {
                    affineTransform.scale(1.0, -1.0);
                    affineTransform.translate(0.0, -height);
                    break;
                }
                case 5: {
                    affineTransform.rotate(-1.5707963267948966);
                    affineTransform.scale(-1.0, 1.0);
                    break;
                }
                case 6: {
                    affineTransform.translate(height, 0.0);
                    affineTransform.rotate(1.5707963267948966);
                    break;
                }
                case 7: {
                    affineTransform.scale(-1.0, 1.0);
                    affineTransform.translate(-height, 0.0);
                    affineTransform.translate(0.0, width);
                    affineTransform.rotate(4.71238898038469);
                    break;
                }
                case 8: {
                    affineTransform.translate(0.0, width);
                    affineTransform.rotate(4.71238898038469);
                    break;
                }
            }
            BufferedInputStream bis2 = new BufferedInputStream(new ByteArrayInputStream(imageBytes));
            BufferedImage originalImage = ImageIO.read(bis2);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
            BufferedImage destinationImage = new BufferedImage(originalImage.getHeight(), originalImage.getWidth(), originalImage.getType());
            destinationImage = affineTransformOp.filter(originalImage, destinationImage);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)destinationImage, "jpg", baos);
            baos.flush();
            byte[] imageInByte = baos.toByteArray();
            baos.close();
            FastByteArrayInputStream fbis = new FastByteArrayInputStream(imageInByte);
            return ImageIO.createImageInputStream(fbis);
        }
        catch (Exception e) {
            FastByteArrayInputStream fbis = new FastByteArrayInputStream(imageBytes);
            return ImageIO.createImageInputStream(fbis);
        }
    }
}

