/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.images.tiling;

import au.org.ala.images.tiling.ImageTiler;
import au.org.ala.images.tiling.ImageTilerConfig;
import au.org.ala.images.tiling.ImageTilerResults;
import java.io.File;

public class LocalTiler {
    public static void main(String[] args) {
        String filename;
        File f;
        if (args.length != 1) {
            LocalTiler.usage();
            System.exit(0);
        }
        if (!(f = new File(filename = args[0])).exists()) {
            LocalTiler.error(String.format("Invalid file name: %s", filename));
        }
        File dest = new File(f.getParentFile().getAbsolutePath() + "/tiles");
        dest.mkdirs();
        ImageTilerConfig config = new ImageTilerConfig();
        ImageTiler tiler = new ImageTiler(config);
        try {
            ImageTilerResults results = tiler.tileImage(f, dest);
            if (results.getZoomLevels() == 0) {
                System.out.println("Tiling failed!");
            } else {
                System.out.println(String.format("Tiling completed (%d zoom levels)", results.getZoomLevels()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("LocalTiler <filename>");
    }

    private static void error(String message) {
        System.err.println(message);
        System.exit(-1);
    }
}

