/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.images.thumb;

import au.org.ala.images.thumb.ThumbDefinition;
import au.org.ala.images.thumb.ThumbnailingResult;
import au.org.ala.images.util.ImageReaderUtils;
import au.org.ala.images.util.ImageUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageThumbnailer {
    private static final int MAX_THUMB_SIZE = 1024;

    protected File createThumbnailFile(File parent, String name) {
        return new File(String.format("%s/%s", parent.getAbsolutePath(), name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ThumbnailingResult> generateThumbnails(byte[] imageBytes, File destinationDirectory, List<ThumbDefinition> thumbDefs) throws IOException {
        ImageReader reader = ImageReaderUtils.findCompatibleImageReader(imageBytes);
        ArrayList<ThumbnailingResult> results = new ArrayList<ThumbnailingResult>();
        if (reader != null) {
            BufferedImage thumbSrc;
            ImageReadParam imageParams = reader.getDefaultReadParam();
            int height = reader.getHeight(0);
            int width = reader.getWidth(0);
            if (height > 1024 || width > 1024) {
                int ratio = height > width ? height / 1024 : width / 1024;
                imageParams.setSourceSubsampling(ratio, ratio == 0 ? 1 : ratio, 0, 0);
                thumbSrc = reader.read(0, imageParams);
                thumbSrc = ImageUtils.scaleWidth(thumbSrc, 1024);
            } else {
                thumbSrc = reader.read(0);
                thumbSrc = ImageUtils.scaleWidth(thumbSrc, 1024);
            }
            if (thumbSrc != null) {
                for (ThumbDefinition thumbDef : thumbDefs) {
                    BufferedImage thumbImage;
                    File thumbFile = this.createThumbnailFile(destinationDirectory, thumbDef.getName());
                    Color backgroundColor = thumbDef.getBackgroundColor();
                    int size = thumbDef.getMaximumDimension();
                    boolean isPNG = false;
                    BufferedImage scaledThumb = ImageUtils.scaleWidth(thumbSrc, size);
                    int thumbHeight = scaledThumb.getHeight();
                    int thumbWidth = scaledThumb.getWidth();
                    Graphics g = null;
                    try {
                        if (!thumbDef.isSquare()) {
                            thumbImage = new BufferedImage(scaledThumb.getWidth(), scaledThumb.getHeight(), 5);
                            g = thumbImage.getGraphics();
                            g.drawImage(scaledThumb, 0, 0, null);
                        } else {
                            if (backgroundColor == null) {
                                isPNG = true;
                                thumbImage = new BufferedImage(size, size, 6);
                                g = thumbImage.getGraphics();
                            } else {
                                thumbImage = new BufferedImage(size, size, 5);
                                g = thumbImage.getGraphics();
                                g.setColor(backgroundColor);
                                g.fillRect(0, 0, size, size);
                            }
                            if (thumbHeight < size) {
                                int top = size / 2 - thumbHeight / 2;
                                g.drawImage(scaledThumb, 0, top, null);
                            } else if (thumbWidth < size) {
                                int left = size / 2 - thumbWidth / 2;
                                g.drawImage(scaledThumb, left, 0, null);
                            } else {
                                g.drawImage(scaledThumb, 0, 0, null);
                            }
                        }
                    }
                    finally {
                        if (g != null) {
                            g.dispose();
                        }
                    }
                    if (thumbImage == null) continue;
                    ImageIO.write((RenderedImage)thumbImage, isPNG ? "PNG" : "JPG", thumbFile);
                    results.add(new ThumbnailingResult(thumbImage.getWidth(), thumbImage.getHeight(), thumbDef.isSquare(), thumbDef.getName()));
                }
            }
        } else {
            System.err.println("No image readers for image ${imageIdentifier}!");
        }
        return results;
    }
}

