/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.images.metadata;

import au.org.ala.images.metadata.AbstractMetadataParser;
import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageMetadataExtractor
extends AbstractMetadataParser {
    @Override
    public Pattern getContentTypePattern() {
        return Pattern.compile("^image/(.*)$");
    }

    @Override
    public void extractMetadata(byte[] bytes, Map<String, String> md) {
        BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(bytes));
        try {
            Metadata metadata = ImageMetadataReader.readMetadata((BufferedInputStream)bis, (boolean)false);
            for (Directory directory : metadata.getDirectories()) {
                for (Tag tag : directory.getTags()) {
                    String value;
                    String key = tag.getTagName();
                    if (md.containsKey(key)) {
                        key = String.format("%s (%s)", tag.getTagName(), tag.getDirectoryName());
                    }
                    if (StringUtils.isNotEmpty((String)(value = directory.getDescription(tag.getTagType()))) && value.startsWith("[") && value.endsWith("bytes]")) {
                        byte[] tagBytes = directory.getByteArray(tag.getTagType());
                        value = Base64.encodeBase64String((byte[])tagBytes);
                    }
                    md.put(key, value);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

