/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import java.util.Collection;
import org.codehaus.groovy.grails.plugins.springsecurity.WebExpressionConfigAttribute;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.WebSecurityExpressionHandler;
import org.springframework.util.Assert;

public class WebExpressionVoter
implements AccessDecisionVoter {
    private WebSecurityExpressionHandler _expressionHandler;

    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        Assert.notNull((Object)authentication, (String)"authentication cannot be null");
        Assert.notNull((Object)object, (String)"object cannot be null");
        Assert.notNull(attributes, (String)"attributes cannot be null");
        WebExpressionConfigAttribute weca = this.findConfigAttribute(attributes);
        if (weca == null) {
            return 0;
        }
        FilterInvocation fi = (FilterInvocation)object;
        EvaluationContext ctx = this._expressionHandler.createEvaluationContext(authentication, fi);
        return ExpressionUtils.evaluateAsBoolean((Expression)weca.getAuthorizeExpression(), (EvaluationContext)ctx) ? 1 : -1;
    }

    private WebExpressionConfigAttribute findConfigAttribute(Collection<ConfigAttribute> attributes) {
        for (ConfigAttribute attribute : attributes) {
            if (!(attribute instanceof WebExpressionConfigAttribute)) continue;
            return (WebExpressionConfigAttribute)attribute;
        }
        return null;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute instanceof WebExpressionConfigAttribute;
    }

    public boolean supports(Class<?> clazz) {
        return clazz.isAssignableFrom(FilterInvocation.class);
    }

    public void setExpressionHandler(WebSecurityExpressionHandler expressionHandler) {
        this._expressionHandler = expressionHandler;
    }
}

