/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import grails.util.Environment;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.plugins.springsecurity.ReflectionUtils;
import org.codehaus.groovy.grails.plugins.springsecurity.SecurityFilterPosition;
import org.codehaus.groovy.grails.plugins.springsecurity.SecurityRequestHolder;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.authentication.switchuser.SwitchUserGrantedAuthority;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SpringSecurityUtils {
    private static ConfigObject _securityConfig;
    private static GrailsApplication _application;
    private static final Map<String, Object> _context;
    private static final String VOTER_NAMES_KEY = "VOTER_NAMES";
    private static final String PROVIDER_NAMES_KEY = "PROVIDER_NAMES";
    private static final String LOGOUT_HANDLER_NAMES_KEY = "LOGOUT_HANDLER_NAMES";
    private static final String ORDERED_FILTERS_KEY = "ORDERED_FILTERS";
    private static final String CONFIGURED_ORDERED_FILTERS_KEY = "CONFIGURED_ORDERED_FILTERS";
    public static final String AJAX_HEADER = "X-Requested-With";
    @Deprecated
    public static final Map<Integer, String> ORDERED_FILTERS;
    @Deprecated
    public static final SortedMap<Integer, Filter> CONFIGURED_ORDERED_FILTERS;
    @Deprecated
    public static final List<String> VOTER_NAMES;
    @Deprecated
    public static final List<String> PROVIDER_NAMES;
    @Deprecated
    public static final List<String> LOGOUT_HANDLER_NAMES;
    public static final String NO_ROLE = "ROLE_NO_ROLES";

    private SpringSecurityUtils() {
    }

    public static void setApplication(GrailsApplication application) {
        _application = application;
        SpringSecurityUtils.initializeContext();
    }

    public static Set<String> authoritiesToRoles(Object authorities) {
        HashSet<String> roles = new HashSet<String>();
        for (Object authority : ReflectionUtils.asList((Object)authorities)) {
            String authorityName = ((GrantedAuthority)authority).getAuthority();
            if (null == authorityName) {
                throw new IllegalArgumentException("Cannot process GrantedAuthority objects which return null from getAuthority() - attempting to process " + authority);
            }
            roles.add(authorityName);
        }
        return roles;
    }

    public static Collection<GrantedAuthority> getPrincipalAuthorities() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return Collections.emptyList();
        }
        Collection authorities = authentication.getAuthorities();
        if (authorities == null) {
            return Collections.emptyList();
        }
        ArrayList<GrantedAuthority> copy = new ArrayList<GrantedAuthority>(authorities);
        Iterator iter = copy.iterator();
        while (iter.hasNext()) {
            if (!((GrantedAuthority)iter.next()).getAuthority().equals("ROLE_NO_ROLES")) continue;
            iter.remove();
        }
        return copy;
    }

    public static List<GrantedAuthority> parseAuthoritiesString(String roleNames) {
        ArrayList<GrantedAuthority> requiredAuthorities = new ArrayList<GrantedAuthority>();
        for (String auth : StringUtils.commaDelimitedListToStringArray((String)roleNames)) {
            if ((auth = auth.trim()).length() <= 0) continue;
            requiredAuthorities.add((GrantedAuthority)new GrantedAuthorityImpl(auth));
        }
        return requiredAuthorities;
    }

    public static Set<String> retainAll(Object granted, Object required) {
        Set grantedRoles = SpringSecurityUtils.authoritiesToRoles((Object)granted);
        Set requiredRoles = SpringSecurityUtils.authoritiesToRoles((Object)required);
        grantedRoles.retainAll(requiredRoles);
        return grantedRoles;
    }

    public static boolean ifAllGranted(String roles) {
        Collection inferred = SpringSecurityUtils.findInferredAuthorities((Collection)SpringSecurityUtils.getPrincipalAuthorities());
        return inferred.containsAll(SpringSecurityUtils.parseAuthoritiesString((String)roles));
    }

    public static boolean ifNotGranted(String roles) {
        Collection inferred = SpringSecurityUtils.findInferredAuthorities((Collection)SpringSecurityUtils.getPrincipalAuthorities());
        Set grantedCopy = SpringSecurityUtils.retainAll((Object)inferred, (Object)SpringSecurityUtils.parseAuthoritiesString((String)roles));
        return grantedCopy.isEmpty();
    }

    public static boolean ifAnyGranted(String roles) {
        Collection inferred = SpringSecurityUtils.findInferredAuthorities((Collection)SpringSecurityUtils.getPrincipalAuthorities());
        Set grantedCopy = SpringSecurityUtils.retainAll((Object)inferred, (Object)SpringSecurityUtils.parseAuthoritiesString((String)roles));
        return !grantedCopy.isEmpty();
    }

    public static synchronized ConfigObject getSecurityConfig() {
        if (_securityConfig == null) {
            SpringSecurityUtils.reloadSecurityConfig();
        }
        return _securityConfig;
    }

    public static void setSecurityConfig(ConfigObject config) {
        _securityConfig = config;
    }

    public static synchronized void resetSecurityConfig() {
        _securityConfig = null;
    }

    public static synchronized void loadSecondaryConfig(String className) {
        SpringSecurityUtils.mergeConfig((ConfigObject)SpringSecurityUtils.getSecurityConfig(), (String)className);
    }

    public static void reloadSecurityConfig() {
        SpringSecurityUtils.mergeConfig((ConfigObject)ReflectionUtils.getSecurityConfig(), (String)"DefaultSecurityConfig");
    }

    public static boolean isAjax(HttpServletRequest request) {
        String ajaxHeaderName = (String)ReflectionUtils.getConfigProperty((String)"ajaxHeader");
        if (request.getHeader(ajaxHeaderName) != null) {
            return true;
        }
        if ("true".equals(request.getParameter("ajax"))) {
            return true;
        }
        SavedRequest savedRequest = (SavedRequest)request.getSession().getAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY");
        if (savedRequest != null) {
            return !savedRequest.getHeaderValues(ajaxHeaderName).isEmpty();
        }
        return false;
    }

    public static void registerProvider(String beanName) {
        SpringSecurityUtils.getProviderNames().add(0, beanName);
    }

    public static synchronized List<String> getProviderNames() {
        return (List)SpringSecurityUtils.getFromContext((String)"PROVIDER_NAMES");
    }

    public static void registerLogoutHandler(String beanName) {
        SpringSecurityUtils.getLogoutHandlerNames().add(0, beanName);
    }

    public static synchronized List<String> getLogoutHandlerNames() {
        return (List)SpringSecurityUtils.getFromContext((String)"LOGOUT_HANDLER_NAMES");
    }

    public static void registerVoter(String beanName) {
        SpringSecurityUtils.getVoterNames().add(0, beanName);
    }

    public static List<String> getVoterNames() {
        return (List)SpringSecurityUtils.getFromContext((String)"VOTER_NAMES");
    }

    public static void registerFilter(String beanName, SecurityFilterPosition order) {
        SpringSecurityUtils.registerFilter((String)beanName, (int)order.getOrder());
    }

    public static void registerFilter(String beanName, int order) {
        String oldName = (String)SpringSecurityUtils.getOrderedFilters().get(order);
        if (oldName != null) {
            throw new IllegalArgumentException("Cannot register filter '" + beanName + "' at position " + order + "; '" + oldName + "' is already registered in that position");
        }
        SpringSecurityUtils.getOrderedFilters().put(order, beanName);
    }

    public static Map<Integer, String> getOrderedFilters() {
        return (Map)SpringSecurityUtils.getFromContext((String)"ORDERED_FILTERS");
    }

    public static void clientRegisterFilter(String beanName, SecurityFilterPosition order) {
        SpringSecurityUtils.clientRegisterFilter((String)beanName, (int)order.getOrder());
    }

    public static void clientRegisterFilter(String beanName, int order) {
        Filter oldFilter = (Filter)SpringSecurityUtils.getConfiguredOrderedFilters().get(order);
        if (oldFilter != null) {
            throw new IllegalArgumentException("Cannot register filter '" + beanName + "' at position " + order + "; '" + oldFilter + "' is already registered in that position");
        }
        Filter filter = (Filter)SpringSecurityUtils.getBean((String)beanName);
        SpringSecurityUtils.getConfiguredOrderedFilters().put(order, filter);
        FilterChainProxy filterChain = (FilterChainProxy)SpringSecurityUtils.getBean((String)"springSecurityFilterChain");
        filterChain.setFilterChainMap(Collections.singletonMap(filterChain.getMatcher().getUniversalMatchPattern(), new ArrayList(SpringSecurityUtils.getConfiguredOrderedFilters().values())));
    }

    public static SortedMap<Integer, Filter> getConfiguredOrderedFilters() {
        return (SortedMap)SpringSecurityUtils.getFromContext((String)"CONFIGURED_ORDERED_FILTERS");
    }

    public static boolean isSwitched() {
        return SpringSecurityUtils.ifAllGranted((String)"ROLE_PREVIOUS_ADMINISTRATOR");
    }

    public static String getSwitchedUserOriginalUsername() {
        if (SpringSecurityUtils.isSwitched()) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            for (GrantedAuthority auth : authentication.getAuthorities()) {
                if (!(auth instanceof SwitchUserGrantedAuthority)) continue;
                return ((SwitchUserGrantedAuthority)auth).getSource().getName();
            }
        }
        return null;
    }

    public static String getSecurityConfigType() {
        return SpringSecurityUtils.getSecurityConfig().get((Object)"securityConfigType").toString();
    }

    public static void reauthenticate(String username, String password) {
        UserDetailsService userDetailsService = (UserDetailsService)SpringSecurityUtils.getBean((String)"userDetailsService");
        UserCache userCache = (UserCache)SpringSecurityUtils.getBean((String)"userCache");
        UserDetails userDetails = userDetailsService.loadUserByUsername(username);
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)(password == null ? userDetails.getPassword() : password), userDetails.getAuthorities()));
        userCache.removeUserFromCache(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doWithAuth(Closure closure) {
        boolean set = false;
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            HttpSession httpSession = SecurityRequestHolder.getRequest().getSession(false);
            SecurityContext context = null;
            if (httpSession != null && (context = (SecurityContext)httpSession.getAttribute("SPRING_SECURITY_CONTEXT")) != null) {
                SecurityContextHolder.setContext((SecurityContext)context);
                set = true;
            }
        }
        try {
            Object object = closure.call();
            return object;
        }
        finally {
            if (set) {
                SecurityContextHolder.clearContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doWithAuth(String username, Closure closure) {
        Authentication previousAuth = SecurityContextHolder.getContext().getAuthentication();
        SpringSecurityUtils.reauthenticate((String)username, null);
        try {
            Object object = closure.call();
            return object;
        }
        finally {
            if (previousAuth == null) {
                SecurityContextHolder.clearContext();
            } else {
                SecurityContextHolder.getContext().setAuthentication(previousAuth);
            }
        }
    }

    private static void mergeConfig(ConfigObject currentConfig, String className) {
        ConfigObject secondaryConfig;
        GroovyClassLoader classLoader = new GroovyClassLoader(SpringSecurityUtils.class.getClassLoader());
        ConfigSlurper slurper = new ConfigSlurper(Environment.getCurrent().getName());
        try {
            secondaryConfig = slurper.parse(classLoader.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        _securityConfig = SpringSecurityUtils.mergeConfig((ConfigObject)currentConfig, (ConfigObject)((ConfigObject)secondaryConfig.getProperty("security")));
        ReflectionUtils.setSecurityConfig((ConfigObject)_securityConfig);
    }

    private static ConfigObject mergeConfig(ConfigObject currentConfig, ConfigObject secondary) {
        ConfigObject config = new ConfigObject();
        if (secondary == null) {
            config.putAll((Map)currentConfig);
        } else {
            config.putAll(secondary.merge(currentConfig));
        }
        return config;
    }

    private static Collection<GrantedAuthority> findInferredAuthorities(Collection<GrantedAuthority> granted) {
        RoleHierarchy roleHierarchy = (RoleHierarchy)SpringSecurityUtils.getBean((String)"roleHierarchy");
        Collection reachable = roleHierarchy.getReachableGrantedAuthorities(granted);
        if (reachable == null) {
            return Collections.emptyList();
        }
        return reachable;
    }

    private static <T> T getBean(String name) {
        return (T)_application.getMainContext().getBean(name);
    }

    private static Object createDelegate(String configKey, Class<?> interfaceClass, Class<?> implClass) {
        try {
            SpringSecurityUtils.storeInContext((String)configKey, implClass.newInstance());
        }
        catch (InstantiationException impossible) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return Proxy.newProxyInstance(implClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static void initializeContext() {
        SpringSecurityUtils.getVoterNames().clear();
        SpringSecurityUtils.getVoterNames().add("authenticatedVoter");
        SpringSecurityUtils.getVoterNames().add("roleVoter");
        SpringSecurityUtils.getVoterNames().add("webExpressionVoter");
        SpringSecurityUtils.getLogoutHandlerNames().clear();
        SpringSecurityUtils.getLogoutHandlerNames().add("rememberMeServices");
        SpringSecurityUtils.getLogoutHandlerNames().add("securityContextLogoutHandler");
        SpringSecurityUtils.getProviderNames().clear();
        SpringSecurityUtils.getProviderNames().add("daoAuthenticationProvider");
        SpringSecurityUtils.getProviderNames().add("anonymousAuthenticationProvider");
        SpringSecurityUtils.getProviderNames().add("rememberMeAuthenticationProvider");
        SpringSecurityUtils.getOrderedFilters().clear();
        SpringSecurityUtils.getConfiguredOrderedFilters().clear();
    }

    private static Object getFromContext(String key) {
        return _context.get(key);
    }

    private static void storeInContext(String key, Object value) {
        _context.put(key, value);
    }

    static /* synthetic */ Object access$000(String x0) {
        return SpringSecurityUtils.getFromContext((String)x0);
    }

    static {
        _context = new HashMap();
        ORDERED_FILTERS = (Map)SpringSecurityUtils.createDelegate((String)"ORDERED_FILTERS", Map.class, HashMap.class);
        CONFIGURED_ORDERED_FILTERS = (SortedMap)SpringSecurityUtils.createDelegate((String)"CONFIGURED_ORDERED_FILTERS", SortedMap.class, TreeMap.class);
        VOTER_NAMES = (List)SpringSecurityUtils.createDelegate((String)"VOTER_NAMES", List.class, ArrayList.class);
        PROVIDER_NAMES = (List)SpringSecurityUtils.createDelegate((String)"PROVIDER_NAMES", List.class, ArrayList.class);
        LOGOUT_HANDLER_NAMES = (List)SpringSecurityUtils.createDelegate((String)"LOGOUT_HANDLER_NAMES", List.class, ArrayList.class);
    }
}

