/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import groovy.lang.Closure;
import org.codehaus.groovy.grails.plugins.springsecurity.SpringSecurityUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.access.event.AbstractAuthorizationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.web.authentication.switchuser.AuthenticationSwitchUserEvent;

public class SecurityEventListener
implements ApplicationListener<ApplicationEvent>,
ApplicationContextAware {
    private ApplicationContext _applicationContext;

    public void onApplicationEvent(ApplicationEvent e) {
        if (e instanceof AbstractAuthenticationEvent) {
            if (e instanceof InteractiveAuthenticationSuccessEvent) {
                this.call(e, "onInteractiveAuthenticationSuccessEvent");
            } else if (e instanceof AbstractAuthenticationFailureEvent) {
                this.call(e, "onAbstractAuthenticationFailureEvent");
            } else if (e instanceof AuthenticationSuccessEvent) {
                this.call(e, "onAuthenticationSuccessEvent");
            } else if (e instanceof AuthenticationSwitchUserEvent) {
                this.call(e, "onAuthenticationSwitchUserEvent");
            }
        } else if (e instanceof AbstractAuthorizationEvent) {
            this.call(e, "onAuthorizationEvent");
        }
    }

    private void call(ApplicationEvent e, String closureName) {
        Object closure = SpringSecurityUtils.getSecurityConfig().get((Object)closureName);
        if (closure instanceof Closure) {
            ((Closure)closure).call(new Object[]{e, this._applicationContext});
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }
}

