/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.groovy.grails.plugins.springsecurity.AbstractFilterInvocationDefinition;
import org.codehaus.groovy.grails.plugins.springsecurity.ReflectionUtils;
import org.springframework.security.web.FilterInvocation;

public class RequestmapFilterInvocationDefinition
extends AbstractFilterInvocationDefinition {
    private boolean _initialized;

    protected String determineUrl(FilterInvocation filterInvocation) {
        HttpServletRequest request = filterInvocation.getHttpRequest();
        String requestUrl = request.getRequestURI().substring(request.getContextPath().length());
        return this.lowercaseAndStripQuerystring(requestUrl);
    }

    protected void initialize() {
        if (this._initialized) {
            return;
        }
        try {
            this.reset();
            this._initialized = true;
        }
        catch (RuntimeException e) {
            this._log.warn("Exception initializing; this is ok if it's at startup and due to GORM not being initialized yet since the first web request will re-initialize. Error message is: " + e.getMessage());
        }
    }

    public synchronized void reset() {
        Map data = this.loadRequestmaps();
        this.resetConfigs();
        for (Map.Entry entry : data.entrySet()) {
            this.compileAndStoreMapping((String)entry.getKey(), this.split((String)entry.getValue()));
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace("configs: " + this.getConfigAttributeMap());
        }
    }

    protected Map<String, String> loadRequestmaps() {
        HashMap<String, String> data = new HashMap<String, String>();
        for (Object requestmap : ReflectionUtils.loadAllRequestmaps()) {
            String urlPattern = ReflectionUtils.getRequestmapUrl(requestmap);
            String configAttribute = ReflectionUtils.getRequestmapConfigAttribute(requestmap);
            data.put(urlPattern, configAttribute);
        }
        return data;
    }
}

