/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.plugins.springsecurity.MutableLogoutFilter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

public class MutableLogoutFilter
extends LogoutFilter {
    private final LogoutSuccessHandler _logoutSuccessHandler;
    private List<LogoutHandler> _handlers;

    public MutableLogoutFilter(LogoutSuccessHandler logoutSuccessHandler) {
        super(logoutSuccessHandler, new LogoutHandler[]{new DummyLogoutHandler(null)});
        this._logoutSuccessHandler = logoutSuccessHandler;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.requiresLogout(request, response)) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Logging out user '" + auth + "' and transferring to logout destination"));
            }
            for (LogoutHandler handler : this._handlers) {
                handler.logout(request, response, auth);
            }
            this._logoutSuccessHandler.onLogoutSuccess(request, response, auth);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void setHandlers(List<LogoutHandler> handlers) {
        this._handlers = handlers;
    }
}

