/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.plugins.springsecurity.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.util.IpAddressMatcher;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

public class IpAddressFilter
extends GenericFilterBean {
    private final Logger _log = LoggerFactory.getLogger(this.getClass());
    private final AntPathMatcher _pathMatcher = new AntPathMatcher();
    private Map<String, List<String>> _restrictions;
    private static final String IPV4_LOOPBACK = "127.0.0.1";
    private static final String IPV6_LOOPBACK = "0:0:0:0:0:0:0:1";

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (!this.isAllowed(request)) {
            response.sendError(404);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected void initFilterBean() {
        Assert.notNull((Object)this._restrictions, (String)"ipRestrictions map is required");
    }

    public void setIpRestrictions(Map<String, Object> restrictions) {
        this._restrictions = ReflectionUtils.splitMap(restrictions);
    }

    private boolean isAllowed(HttpServletRequest request) {
        Collection matching;
        String ip = request.getRemoteAddr();
        if (IPV4_LOOPBACK.equals(ip) || IPV6_LOOPBACK.equals(ip)) {
            return true;
        }
        String uri = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (!StringUtils.hasLength((String)uri)) {
            uri = request.getRequestURI();
            if (!request.getContextPath().equals("/") && uri.startsWith(request.getContextPath())) {
                uri = uri.substring(request.getContextPath().length());
            }
        }
        if ((matching = this.findMatchingRules(uri)).isEmpty()) {
            return true;
        }
        for (Map.Entry entry : matching) {
            for (String ipPattern : (List)entry.getValue()) {
                if (!new IpAddressMatcher(ipPattern).matches(request)) continue;
                return true;
            }
        }
        this._log.warn("disallowed request " + uri + " from " + ip);
        return false;
    }

    private Collection<Map.Entry<String, List<String>>> findMatchingRules(String uri) {
        ArrayList<Map.Entry<String, List<String>>> matching = new ArrayList<Map.Entry<String, List<String>>>();
        for (Map.Entry entry : this._restrictions.entrySet()) {
            String uriPattern = (String)entry.getKey();
            if (!this._pathMatcher.match(uriPattern, uri)) continue;
            matching.add(entry);
        }
        return matching;
    }
}

