/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.groovy.grails.plugins.springsecurity.AbstractFilterInvocationDefinition;
import org.codehaus.groovy.grails.plugins.springsecurity.ReflectionUtils;
import org.springframework.security.web.FilterInvocation;

public class InterceptUrlMapFilterInvocationDefinition
extends AbstractFilterInvocationDefinition {
    private boolean _initialized;

    protected String determineUrl(FilterInvocation filterInvocation) {
        HttpServletRequest request = filterInvocation.getHttpRequest();
        String requestUrl = request.getRequestURI().substring(request.getContextPath().length());
        return this.lowercaseAndStripQuerystring(requestUrl);
    }

    protected void initialize() {
        if (this._initialized) {
            return;
        }
        this.reset();
    }

    protected boolean stopAtFirstMatch() {
        return true;
    }

    public void reset() {
        Object map = ReflectionUtils.getConfigProperty((String)"interceptUrlMap");
        if (!(map instanceof Map)) {
            this._log.warn("interceptUrlMap config property isn't a Map");
            return;
        }
        this.resetConfigs();
        Map data = ReflectionUtils.splitMap((Map)((Map)map));
        for (Map.Entry entry : data.entrySet()) {
            this.compileAndStoreMapping((String)entry.getKey(), (List)entry.getValue());
        }
        this._initialized = true;
    }
}

