/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.channel.InsecureChannelProcessor;
import org.springframework.util.Assert;

public class HeaderCheckInsecureChannelProcessor
extends InsecureChannelProcessor {
    private String headerName;
    private String headerValue;

    public void decide(FilterInvocation invocation, Collection<ConfigAttribute> config) throws IOException, ServletException {
        Assert.isTrue((invocation != null && config != null ? 1 : 0) != 0, (String)"Nulls cannot be provided");
        for (ConfigAttribute attribute : config) {
            if (!this.supports(attribute) || !this.headerValue.equals(invocation.getHttpRequest().getHeader(this.headerName))) continue;
            this.getEntryPoint().commence(invocation.getRequest(), invocation.getResponse());
        }
    }

    public void setHeaderName(String name) {
        this.headerName = name;
    }

    public void setHeaderValue(String value) {
        this.headerValue = value;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.hasLength((String)this.headerName, (String)"Header name is required");
        Assert.hasLength((String)this.headerValue, (String)"Header value is required");
    }
}

