/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import grails.util.GrailsUtil;
import java.util.Collection;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.plugins.springsecurity.DummyRequestCreator;
import org.codehaus.groovy.grails.plugins.springsecurity.DummyResponseCreator;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.DefaultWebInvocationPrivilegeEvaluator;
import org.springframework.util.Assert;

public class GrailsWebInvocationPrivilegeEvaluator
extends DefaultWebInvocationPrivilegeEvaluator {
    private static final FilterChain DUMMY_CHAIN = new /* Unavailable Anonymous Inner Class!! */;
    private static final HttpServletResponse DUMMY_RESPONSE = DummyResponseCreator.createInstance();
    private AbstractSecurityInterceptor _interceptor;

    public GrailsWebInvocationPrivilegeEvaluator(AbstractSecurityInterceptor interceptor) {
        super(interceptor);
        this._interceptor = interceptor;
    }

    public boolean isAllowed(String contextPath, String uri, String method, Authentication authentication) {
        Assert.notNull((Object)uri, (String)"uri parameter is required");
        if (contextPath == null) {
            contextPath = "/ctxpath";
        }
        FilterInvocation fi = this.createFilterInvocation(contextPath, uri, method);
        Collection attrs = this._interceptor.obtainSecurityMetadataSource().getAttributes((Object)fi);
        if (attrs == null) {
            return !this._interceptor.isRejectPublicInvocations();
        }
        if (authentication == null) {
            return false;
        }
        try {
            this._interceptor.getAccessDecisionManager().decide(authentication, (Object)fi, attrs);
            return true;
        }
        catch (AccessDeniedException unauthorized) {
            if (logger.isDebugEnabled()) {
                GrailsUtil.deepSanitize((Throwable)unauthorized);
                logger.debug((Object)(fi + " denied for " + authentication), (Throwable)unauthorized);
            }
            return false;
        }
    }

    protected FilterInvocation createFilterInvocation(String contextPath, String uri, String method) {
        Assert.hasText((String)uri, (String)"URI required");
        return new FilterInvocation((ServletRequest)DummyRequestCreator.createInstance((String)contextPath, (String)method, (String)(contextPath + uri)), (ServletResponse)DUMMY_RESPONSE, DUMMY_CHAIN);
    }
}

