/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;

public class DefaultPreAuthenticationChecks
implements UserDetailsChecker {
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public void check(UserDetails user) {
        if (!user.isAccountNonLocked()) {
            this.log.debug("User account is locked");
            throw new LockedException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.locked", "User account is locked"), (Object)user);
        }
        if (!user.isEnabled()) {
            this.log.debug("User account is disabled");
            throw new DisabledException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.disabled", "User is disabled"), (Object)user);
        }
        if (!user.isAccountNonExpired()) {
            this.log.debug("User account is expired");
            throw new AccountExpiredException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.expired", "User account has expired"), (Object)user);
        }
    }
}

