/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.RequestKey;
import org.springframework.security.web.util.UrlMatcher;
import org.springframework.util.Assert;

public class ChannelFilterInvocationSecurityMetadataSourceFactoryBean
implements FactoryBean<FilterInvocationSecurityMetadataSource>,
InitializingBean {
    private UrlMatcher _urlMatcher;
    private Map<String, String> _definition;
    private DefaultFilterInvocationSecurityMetadataSource _source;

    public FilterInvocationSecurityMetadataSource getObject() {
        return this._source;
    }

    public Class<DefaultFilterInvocationSecurityMetadataSource> getObjectType() {
        return DefaultFilterInvocationSecurityMetadataSource.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this._definition, (String)"definition map is required");
        Assert.notNull((Object)this._urlMatcher, (String)"urlMatcher is required");
        this._source = new DefaultFilterInvocationSecurityMetadataSource(this._urlMatcher, this.buildMap());
    }

    protected LinkedHashMap<RequestKey, Collection<ConfigAttribute>> buildMap() {
        LinkedHashMap<RequestKey, Collection<ConfigAttribute>> map = new LinkedHashMap<RequestKey, Collection<ConfigAttribute>>();
        for (Map.Entry entry : this._definition.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null) {
                throw new IllegalArgumentException("The rule for URL '" + value + "' cannot be null");
            }
            if (!("ANY_CHANNEL".equals(value = value.trim()) || "REQUIRES_SECURE_CHANNEL".equals(value) || "REQUIRES_INSECURE_CHANNEL".equals(value))) {
                throw new IllegalArgumentException("The rule for URL '" + value + "' must be one of REQUIRES_SECURE_CHANNEL, REQUIRES_INSECURE_CHANNEL, or ANY_CHANNEL");
            }
            map.put(new RequestKey((String)entry.getKey()), SecurityConfig.createSingleAttributeList((String)value));
        }
        return map;
    }

    public void setUrlMatcher(UrlMatcher urlMatcher) {
        this._urlMatcher = urlMatcher;
    }

    public void setDefinition(Map<String, String> definition) {
        this._definition = definition;
    }
}

