/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import java.util.Collection;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.vote.AbstractAccessDecisionManager;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;

public class AuthenticatedVetoableDecisionManager
extends AbstractAccessDecisionManager {
    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        boolean authenticatedVotersGranted = this.checkAuthenticatedVoters(authentication, object, configAttributes);
        boolean otherVotersGranted = this.checkOtherVoters(authentication, object, configAttributes);
        if (!authenticatedVotersGranted && !otherVotersGranted) {
            this.checkAllowIfAllAbstainDecisions();
        }
    }

    private boolean checkAuthenticatedVoters(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) {
        boolean grant = false;
        for (AccessDecisionVoter voter : this.getDecisionVoters()) {
            if (!(voter instanceof AuthenticatedVoter)) continue;
            int result = voter.vote(authentication, object, configAttributes);
            switch (result) {
                case 1: {
                    grant = true;
                    break;
                }
                case -1: {
                    this.deny();
                    break;
                }
            }
        }
        return grant;
    }

    private boolean checkOtherVoters(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) {
        int denyCount = 0;
        for (AccessDecisionVoter voter : this.getDecisionVoters()) {
            if (voter instanceof AuthenticatedVoter) continue;
            int result = voter.vote(authentication, object, configAttributes);
            switch (result) {
                case 1: {
                    return true;
                }
                case -1: {
                    ++denyCount;
                    break;
                }
            }
        }
        if (denyCount > 0) {
            this.deny();
        }
        return false;
    }

    private void deny() {
        throw new AccessDeniedException(this.messages.getMessage("AbstractAccessDecisionManager.accessDenied", "Access is denied"));
    }
}

