/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import grails.plugins.springsecurity.Secured;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.WordUtils;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsControllerClass;
import org.codehaus.groovy.grails.plugins.springsecurity.AbstractFilterInvocationDefinition;
import org.codehaus.groovy.grails.web.context.ServletContextHolder;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMappingsHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.security.web.FilterInvocation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AnnotationFilterInvocationDefinition
extends AbstractFilterInvocationDefinition {
    private static final List<String> ANNOTATION_CLASS_NAMES = Arrays.asList(Secured.class.getName(), org.springframework.security.access.annotation.Secured.class.getName());
    private UrlMappingsHolder _urlMappingsHolder;
    private GrailsApplication _application;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String determineUrl(FilterInvocation filterInvocation) {
        HttpServletRequest request = filterInvocation.getHttpRequest();
        HttpServletResponse response = filterInvocation.getHttpResponse();
        GrailsWebRequest existingRequest = WebUtils.retrieveGrailsWebRequest();
        String requestUrl = request.getRequestURI().substring(request.getContextPath().length());
        String url = null;
        try {
            GrailsWebRequest grailsRequest = new GrailsWebRequest(request, response, ServletContextHolder.getServletContext());
            WebUtils.storeGrailsWebRequest((GrailsWebRequest)grailsRequest);
            Map savedParams = this.copyParams(grailsRequest);
            for (UrlMappingInfo mapping : this._urlMappingsHolder.matchAll(requestUrl)) {
                this.configureMapping(mapping, grailsRequest, savedParams);
                url = this.findGrailsUrl(mapping);
                if (url == null) continue;
                break;
            }
        }
        finally {
            if (existingRequest == null) {
                WebUtils.clearGrailsWebRequest();
            } else {
                WebUtils.storeGrailsWebRequest((GrailsWebRequest)existingRequest);
            }
        }
        if (!StringUtils.hasLength(url)) {
            url = requestUrl;
        }
        return this.lowercaseAndStripQuerystring(url);
    }

    protected String findGrailsUrl(UrlMappingInfo mapping) {
        String controllerName;
        String uri = mapping.getURI();
        if (StringUtils.hasLength((String)uri)) {
            return uri;
        }
        String actionName = mapping.getActionName();
        if (!StringUtils.hasLength((String)actionName)) {
            actionName = "";
        }
        if (this.isController(controllerName = mapping.getControllerName(), actionName)) {
            if (!StringUtils.hasLength((String)actionName) || "null".equals(actionName)) {
                actionName = "index";
            }
            return ("/" + controllerName + "/" + actionName).trim();
        }
        return null;
    }

    private boolean isController(String controllerName, String actionName) {
        return this._application.getArtefactForFeature("Controller", (Object)("/" + controllerName + "/" + actionName)) != null;
    }

    private void configureMapping(UrlMappingInfo mapping, GrailsWebRequest grailsRequest, Map<String, Object> savedParams) {
        GrailsParameterMap params = grailsRequest.getParams();
        params.clear();
        params.putAll(savedParams);
        mapping.configure(grailsRequest);
    }

    private Map<String, Object> copyParams(GrailsWebRequest grailsRequest) {
        return new HashMap<String, Object>((Map<String, Object>)grailsRequest.getParams());
    }

    public void initialize(Map<String, Collection<String>> staticRules, UrlMappingsHolder urlMappingsHolder, GrailsClass[] controllerClasses) {
        HashMap actionRoleMap = new HashMap();
        HashMap classRoleMap = new HashMap();
        Assert.notNull(staticRules, (String)"staticRules map is required");
        Assert.notNull((Object)urlMappingsHolder, (String)"urlMappingsHolder is required");
        this.resetConfigs();
        this._urlMappingsHolder = urlMappingsHolder;
        for (GrailsClass controllerClass : controllerClasses) {
            this.findControllerAnnotations((GrailsControllerClass)controllerClass, actionRoleMap, classRoleMap);
        }
        this.compileActionMap(actionRoleMap);
        this.compileClassMap(classRoleMap);
        this.compileStaticRules(staticRules);
        if (this._log.isTraceEnabled()) {
            this._log.trace("configs: " + this.getConfigAttributeMap());
        }
    }

    private void compileActionMap(Map<String, Map<String, Set<String>>> map) {
        for (Map.Entry<String, Map<String, Set<String>>> controllerEntry : map.entrySet()) {
            String controllerName = controllerEntry.getKey();
            Map<String, Set<String>> actionRoles = controllerEntry.getValue();
            for (Map.Entry<String, Set<String>> actionEntry : actionRoles.entrySet()) {
                String actionName = actionEntry.getKey();
                Set<String> tokens = actionEntry.getValue();
                this.storeMapping(controllerName, actionName, tokens, false);
                if (!actionName.endsWith("Flow")) continue;
                this.storeMapping(controllerName, actionName.substring(0, actionName.length() - 4), tokens, false);
            }
        }
    }

    private void compileClassMap(Map<String, Set<String>> classRoleMap) {
        for (Map.Entry<String, Set<String>> entry : classRoleMap.entrySet()) {
            String controllerName = entry.getKey();
            Set<String> tokens = entry.getValue();
            this.storeMapping(controllerName, null, tokens, false);
        }
    }

    private void compileStaticRules(Map<String, Collection<String>> staticRules) {
        for (Map.Entry<String, Collection<String>> entry : staticRules.entrySet()) {
            String pattern = entry.getKey();
            Collection<String> tokens = entry.getValue();
            this.storeMapping(pattern, null, tokens, true);
        }
    }

    private void storeMapping(String controllerNameOrPattern, String actionName, Collection<String> tokens, boolean isPattern) {
        String fullPattern;
        if (isPattern) {
            fullPattern = controllerNameOrPattern;
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append('/').append(controllerNameOrPattern);
            if (actionName != null) {
                sb.append('/').append(actionName);
            }
            sb.append("/**");
            fullPattern = sb.toString();
        }
        Collection configAttributes = this.buildConfigAttributes(tokens);
        Object key = this.getUrlMatcher().compile(fullPattern);
        Collection replaced = this.storeMapping(key, configAttributes);
        if (replaced != null) {
            this._log.warn("replaced rule for '" + key + "' with tokens " + replaced + " with tokens " + configAttributes);
        }
    }

    private void findControllerAnnotations(GrailsControllerClass controllerClass, Map<String, Map<String, Set<String>>> actionRoleMap, Map<String, Set<String>> classRoleMap) {
        Map annotatedClosureNames;
        Class clazz = controllerClass.getClazz();
        String controllerName = WordUtils.uncapitalize((String)controllerClass.getName());
        Annotation annotation = this.findAnnotation(clazz.getAnnotations());
        if (annotation != null) {
            classRoleMap.put(controllerName, this.asSet(this.getValue(annotation)));
        }
        if ((annotatedClosureNames = this.findActionRoles(clazz)) != null) {
            actionRoleMap.put(controllerName, annotatedClosureNames);
        }
    }

    private Map<String, Set<String>> findActionRoles(Class<?> clazz) {
        Annotation annotation;
        HashMap<String, Set<String>> actionRoles = new HashMap<String, Set<String>>();
        for (Field field : clazz.getDeclaredFields()) {
            annotation = this.findAnnotation(field.getAnnotations());
            if (annotation == null) continue;
            actionRoles.put(field.getName(), this.asSet(this.getValue(annotation)));
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            annotation = this.findAnnotation(accessibleObject.getAnnotations());
            if (annotation == null) continue;
            actionRoles.put(((Method)accessibleObject).getName(), this.asSet(this.getValue(annotation)));
        }
        return actionRoles;
    }

    private Annotation findAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!ANNOTATION_CLASS_NAMES.contains(annotation.annotationType().getName())) continue;
            return annotation;
        }
        return null;
    }

    private String[] getValue(Annotation annotation) {
        if (annotation instanceof Secured) {
            return ((Secured)annotation).value();
        }
        return ((org.springframework.security.access.annotation.Secured)annotation).value();
    }

    private Set<String> asSet(String[] strings) {
        HashSet<String> set = new HashSet<String>();
        for (String string : strings) {
            set.add(string);
        }
        return set;
    }

    public void setApplication(GrailsApplication application) {
        this._application = application;
    }
}

