/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.plugins.springsecurity.SpringSecurityUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.RequestCache;

public class AjaxAwareAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    private String _ajaxSuccessUrl;
    private RequestCache _requestCache;

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        if (SpringSecurityUtils.isAjax((HttpServletRequest)request)) {
            return this._ajaxSuccessUrl;
        }
        return super.determineTargetUrl(request, response);
    }

    public void setAjaxSuccessUrl(String ajaxSuccessUrl) {
        this._ajaxSuccessUrl = ajaxSuccessUrl;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        super.onAuthenticationSuccess(request, response, authentication);
        this._requestCache.removeRequest(request, response);
    }

    public void setRequestCache(RequestCache requestCache) {
        super.setRequestCache(requestCache);
        this._requestCache = requestCache;
    }
}

