/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.plugins.springsecurity.SpringSecurityUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.ExceptionMappingAuthenticationFailureHandler;
import org.springframework.util.Assert;

public class AjaxAwareAuthenticationFailureHandler
extends ExceptionMappingAuthenticationFailureHandler
implements InitializingBean {
    private String _ajaxAuthenticationFailureUrl;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        if (SpringSecurityUtils.isAjax((HttpServletRequest)request)) {
            this.saveException(request, exception);
            this.getRedirectStrategy().sendRedirect(request, response, this._ajaxAuthenticationFailureUrl);
        } else {
            super.onAuthenticationFailure(request, response, exception);
        }
    }

    public void setAjaxAuthenticationFailureUrl(String url) {
        this._ajaxAuthenticationFailureUrl = url;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this._ajaxAuthenticationFailureUrl, (String)"ajaxAuthenticationFailureUrl is required");
    }
}

