/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.plugins.springsecurity.SpringSecurityUtils;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.util.Assert;

public class AjaxAwareAuthenticationEntryPoint
extends LoginUrlAuthenticationEntryPoint {
    private String ajaxLoginFormUrl;

    protected String determineUrlToUseForThisRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) {
        if (this.ajaxLoginFormUrl != null && SpringSecurityUtils.isAjax((HttpServletRequest)request)) {
            return this.ajaxLoginFormUrl;
        }
        return this.getLoginFormUrl();
    }

    public void setAjaxLoginFormUrl(String url) {
        Assert.isTrue((url == null || url.startsWith("/") ? 1 : 0) != 0, (String)"ajaxLoginFormUrl must begin with '/'");
        this.ajaxLoginFormUrl = url;
    }
}

