/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.plugins.springsecurity.SpringSecurityUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.util.Assert;

public class AjaxAwareAccessDeniedHandler
implements AccessDeniedHandler,
InitializingBean {
    private String errorPage;
    private String ajaxErrorPage;
    private PortResolver portResolver;
    private AuthenticationTrustResolver authenticationTrustResolver;

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException e) throws IOException, ServletException {
        boolean ajaxError;
        if (e != null && this.isLoggedIn() && this.authenticationTrustResolver.isRememberMe(this.getAuthentication())) {
            request.getSession().setAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY", (Object)new DefaultSavedRequest(request, this.portResolver));
        }
        if (response.isCommitted()) {
            return;
        }
        boolean bl = ajaxError = this.ajaxErrorPage != null && SpringSecurityUtils.isAjax((HttpServletRequest)request);
        if (this.errorPage == null && !ajaxError) {
            response.sendError(403, e.getMessage());
            return;
        }
        boolean includePort = true;
        String scheme = request.getScheme();
        String serverName = request.getServerName();
        int serverPort = this.portResolver.getServerPort((ServletRequest)request);
        String contextPath = request.getContextPath();
        boolean inHttp = "http".equals(scheme.toLowerCase());
        boolean inHttps = "https".equals(scheme.toLowerCase());
        if (inHttp && serverPort == 80) {
            includePort = false;
        } else if (inHttps && serverPort == 443) {
            includePort = false;
        }
        String redirectUrl = scheme + "://" + serverName + (includePort ? ":" + serverPort : "") + contextPath;
        if (ajaxError) {
            redirectUrl = redirectUrl + this.ajaxErrorPage;
        } else if (this.errorPage != null) {
            redirectUrl = redirectUrl + this.errorPage;
        }
        response.sendRedirect(response.encodeRedirectURL(redirectUrl));
    }

    private Authentication getAuthentication() {
        return SecurityContextHolder.getContext() == null ? null : SecurityContextHolder.getContext().getAuthentication();
    }

    private boolean isLoggedIn() {
        Authentication authentication = this.getAuthentication();
        if (authentication == null) {
            return false;
        }
        return !this.authenticationTrustResolver.isAnonymous(authentication);
    }

    public void setErrorPage(String page) {
        Assert.isTrue((page == null || page.startsWith("/") ? 1 : 0) != 0, (String)"ErrorPage must begin with '/'");
        this.errorPage = page;
    }

    public void setAjaxErrorPage(String page) {
        Assert.isTrue((page == null || page.startsWith("/") ? 1 : 0) != 0, (String)"Ajax ErrorPage must begin with '/'");
        this.ajaxErrorPage = page;
    }

    public void setPortResolver(PortResolver resolver) {
        this.portResolver = resolver;
    }

    public void setAuthenticationTrustResolver(AuthenticationTrustResolver resolver) {
        this.authenticationTrustResolver = resolver;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.portResolver, (String)"portResolver is required");
        Assert.notNull((Object)this.authenticationTrustResolver, (String)"authenticationTrustResolver is required");
    }
}

