/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.springsecurity;

import grails.util.GrailsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.grails.plugins.springsecurity.WebExpressionConfigAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.Expression;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.WebSecurityExpressionHandler;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.AntUrlPathMatcher;
import org.springframework.security.web.util.UrlMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractFilterInvocationDefinition
implements FilterInvocationSecurityMetadataSource,
InitializingBean {
    private UrlMatcher _urlMatcher;
    private boolean _rejectIfNoRule;
    private boolean _stripQueryStringFromUrls = true;
    private RoleVoter _roleVoter;
    private AuthenticatedVoter _authenticatedVoter;
    private WebSecurityExpressionHandler _expressionHandler;
    private final Map<Object, Collection<ConfigAttribute>> _compiled = new LinkedHashMap();
    protected final Logger _log = LoggerFactory.getLogger(this.getClass());
    protected static final Collection<ConfigAttribute> DENY = Collections.emptyList();

    public void reset() throws Exception {
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        Collection configAttributes;
        Assert.isTrue((object != null && this.supports(object.getClass()) ? 1 : 0) != 0, (String)"Object must be a FilterInvocation");
        FilterInvocation filterInvocation = (FilterInvocation)object;
        String url = this.determineUrl(filterInvocation);
        try {
            configAttributes = this.findConfigAttributes(url);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (configAttributes == null && this._rejectIfNoRule) {
            return DENY;
        }
        return configAttributes;
    }

    protected abstract String determineUrl(FilterInvocation var1);

    protected boolean stopAtFirstMatch() {
        return false;
    }

    private Collection<ConfigAttribute> findConfigAttributes(String url) throws Exception {
        this.initialize();
        Collection configAttributes = null;
        Object configAttributePattern = null;
        boolean stopAtFirstMatch = this.stopAtFirstMatch();
        for (Map.Entry entry : this._compiled.entrySet()) {
            Object pattern = entry.getKey();
            if (!this._urlMatcher.pathMatchesUrl(pattern, url) || configAttributes != null && !this._urlMatcher.pathMatchesUrl(configAttributePattern, (String)pattern)) continue;
            configAttributes = (Collection)entry.getValue();
            configAttributePattern = pattern;
            if (this._log.isTraceEnabled()) {
                this._log.trace("new candidate for '" + url + "': '" + pattern + "':" + configAttributes);
            }
            if (!stopAtFirstMatch) continue;
            break;
        }
        if (this._log.isTraceEnabled()) {
            if (configAttributes == null) {
                this._log.trace("no config for '" + url + "'");
            } else {
                this._log.trace("config for '" + url + "' is '" + configAttributePattern + "':" + configAttributes);
            }
        }
        return configAttributes;
    }

    protected void initialize() throws Exception {
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        try {
            this.initialize();
        }
        catch (Exception e) {
            GrailsUtil.deepSanitize((Throwable)e);
            this._log.error(e.getMessage(), (Throwable)e);
        }
        HashSet all = new HashSet();
        for (Collection configs : this._compiled.values()) {
            all.addAll(configs);
        }
        return Collections.unmodifiableCollection(all);
    }

    public void setUrlMatcher(UrlMatcher urlMatcher) {
        this._urlMatcher = urlMatcher;
        this._stripQueryStringFromUrls = this._urlMatcher instanceof AntUrlPathMatcher;
    }

    public void setRejectIfNoRule(boolean reject) {
        this._rejectIfNoRule = reject;
    }

    protected String lowercaseAndStripQuerystring(String url) {
        int firstQuestionMarkIndex;
        String fixed = url;
        if (this.getUrlMatcher().requiresLowerCaseUrl()) {
            fixed = fixed.toLowerCase();
        }
        if (this._stripQueryStringFromUrls && (firstQuestionMarkIndex = fixed.indexOf("?")) != -1) {
            fixed = fixed.substring(0, firstQuestionMarkIndex);
        }
        return fixed;
    }

    protected UrlMatcher getUrlMatcher() {
        return this._urlMatcher;
    }

    public Map<Object, Collection<ConfigAttribute>> getConfigAttributeMap() {
        return Collections.unmodifiableMap(this._compiled);
    }

    protected List<String> split(String value) {
        if (!value.startsWith("ROLE_") && !value.startsWith("IS_")) {
            return Collections.singletonList(value);
        }
        String[] parts = StringUtils.commaDelimitedListToStringArray((String)value);
        ArrayList<String> cleaned = new ArrayList<String>();
        for (String part : parts) {
            if ((part = part.trim()).length() <= 0) continue;
            cleaned.add(part);
        }
        return cleaned;
    }

    protected void compileAndStoreMapping(String pattern, List<String> tokens) {
        Collection configAttributes;
        Object key = this.getUrlMatcher().compile(pattern);
        Collection replaced = this.storeMapping(key, Collections.unmodifiableCollection(configAttributes = this.buildConfigAttributes(tokens)));
        if (replaced != null) {
            this._log.warn("replaced rule for '" + key + "' with roles " + replaced + " with roles " + configAttributes);
        }
    }

    protected Collection<ConfigAttribute> buildConfigAttributes(Collection<String> tokens) {
        HashSet<ConfigAttribute> configAttributes = new HashSet<ConfigAttribute>();
        for (String token : tokens) {
            SecurityConfig config = new SecurityConfig(token);
            if (this.supports((ConfigAttribute)config)) {
                configAttributes.add((ConfigAttribute)config);
                continue;
            }
            Expression expression = this._expressionHandler.getExpressionParser().parseExpression(token);
            configAttributes.add((ConfigAttribute)new WebExpressionConfigAttribute(expression));
        }
        return configAttributes;
    }

    protected boolean supports(ConfigAttribute config) {
        return this.supports(config, (AccessDecisionVoter)this._roleVoter) || this.supports(config, (AccessDecisionVoter)this._authenticatedVoter) || config.getAttribute().startsWith("RUN_AS");
    }

    private boolean supports(ConfigAttribute config, AccessDecisionVoter voter) {
        return voter != null && voter.supports(config);
    }

    protected Collection<ConfigAttribute> storeMapping(Object key, Collection<ConfigAttribute> configAttributes) {
        return this._compiled.put(key, configAttributes);
    }

    protected void resetConfigs() {
        this._compiled.clear();
    }

    public Collection<ConfigAttribute> findMatchingAttributes(String url) {
        for (Map.Entry entry : this._compiled.entrySet()) {
            if (!this._urlMatcher.pathMatchesUrl(entry.getKey(), url)) continue;
            return (Collection)entry.getValue();
        }
        return Collections.emptyList();
    }

    public void setRoleVoter(RoleVoter voter) {
        this._roleVoter = voter;
    }

    protected RoleVoter getRoleVoter() {
        return this._roleVoter;
    }

    public void setAuthenticatedVoter(AuthenticatedVoter voter) {
        this._authenticatedVoter = voter;
    }

    protected AuthenticatedVoter getAuthenticatedVoter() {
        return this._authenticatedVoter;
    }

    public void setExpressionHandler(WebSecurityExpressionHandler handler) {
        this._expressionHandler = handler;
    }

    protected WebSecurityExpressionHandler getExpressionHandler() {
        return this._expressionHandler;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this._urlMatcher, (String)"url matcher is required");
    }
}

