/*
 * Decompiled with CFR 0.152.
 */
package grails.plugins.springsecurity;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.core.codec.Hex;
import org.springframework.util.Assert;

public class DigestAuthPasswordEncoder
implements PasswordEncoder,
InitializingBean {
    private String _realm;

    public String encodePassword(String rawPass, Object salt) {
        Assert.notNull((Object)salt, (String)"Salt is required and must be the username");
        String username = salt.toString();
        return this.md5Hex(username + ":" + this._realm + ":" + rawPass);
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        return encPass != null && rawPass != null ? rawPass.equals(encPass) : false;
    }

    public void setRealm(String realm) {
        this._realm = realm;
    }

    public void afterPropertiesSet() {
        Assert.hasLength((String)this._realm, (String)"realm is required");
    }

    private String md5Hex(String s) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No MD5 algorithm available!");
        }
        return new String(Hex.encode((byte[])digest.digest(s.getBytes())));
    }
}

