/*
 * Decompiled with CFR 0.152.
 */
package grails.plugins.springsecurity;

import org.codehaus.groovy.grails.plugins.springsecurity.ReflectionUtils;
import org.mindrot.jbcrypt.BCrypt;
import org.springframework.dao.DataAccessException;
import org.springframework.security.authentication.encoding.PasswordEncoder;

public class BCryptPasswordEncoder
implements PasswordEncoder {
    public String encodePassword(String rawPassword, Object ignoredSalt) throws DataAccessException {
        Integer logRounds = (Integer)ReflectionUtils.getConfigProperty((String)"password.bcrypt.logrounds");
        return BCrypt.hashpw((String)rawPassword, (String)BCrypt.gensalt((int)logRounds));
    }

    public boolean isPasswordValid(String encodedPassword, String rawPassword, Object ignoredSalt) throws DataAccessException {
        return BCrypt.checkpw((String)rawPassword, (String)encodedPassword);
    }
}

