//# sourceMappingURL=jsoneditor-minimalist.js.map
/*
 jsoneditor.js

 @brief
 JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 It has various modes such as a tree editor, a code editor, and a plain text
 editor.

 Supported browsers: Chrome, Firefox, Safari, Opera, Internet Explorer 8+

 @license
 Licensed under the Apache License, Version 2.0 (the "License"); you may not
 use this file except in compliance with the License. You may obtain a copy
 of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 License for the specific language governing permissions and limitations under
 the License.

 Copyright (c) 2011-2021 Jos de Jong, http://jsoneditoronline.org

 @author  Jos de Jong, <wjosdejong@gmail.com>
 @version 9.3.0
 @date    2021-04-01
 Selectr 2.4.0
 https://github.com/Mobius1/Selectr

 Released under the MIT license
*/
var process=process||{env:{NODE_ENV:"development"}};
(function(N,Q){"object"===typeof exports&&"object"===typeof module?module.exports=Q():"function"===typeof define&&define.amd?define([],Q):"object"===typeof exports?exports.JSONEditor=Q():N.JSONEditor=Q()})(self,function(){return function(){function N(w){var n=X[w];if(void 0!==n)return n.exports;n=X[w]={exports:{}};Q[w].call(n.exports,n,n.exports,N);return n.exports}var Q={897:function(w,n,d){function r(e,d){for(var t=0;t<d.length;t++){var p=d[t];p.enumerable=p.enumerable||!1;p.configurable=!0;"value"in
p&&(p.writable=!0);Object.defineProperty(e,p.key,p)}}function x(e,d,t){d&&r(e.prototype,d);t&&r(e,t);return e}d.d(n,{x:function(){return l}});var e=d(602),A=d(791),p=d(907),l=function(){function d(e,t){function D(b,g,a){a.forEach(function(a){if("separator"===a.type){var c=document.createElement("div");c.className="jsoneditor-separator";var u=document.createElement("li");u.appendChild(c);b.appendChild(u)}else{var e={};c=document.createElement("li");b.appendChild(c);u=document.createElement("button");
u.type="button";u.className=a.className;e.button=u;a.title&&(u.title=a.title);a.click&&(u.onclick=function(c){c.preventDefault();l.hide();a.click()});c.appendChild(u);if(a.submenu){var d=document.createElement("div");d.className="jsoneditor-icon";u.appendChild(d);d=document.createElement("div");d.className="jsoneditor-text"+(a.click?"":" jsoneditor-right-margin");d.appendChild(document.createTextNode(a.text));u.appendChild(d);if(a.click){u.className+=" jsoneditor-default";u=document.createElement("button");
u.type="button";e.buttonExpand=u;u.className="jsoneditor-expand";d=document.createElement("div");d.className="jsoneditor-expand";u.appendChild(d);c.appendChild(u);a.submenuTitle&&(u.title=a.submenuTitle);var m=u}else d=document.createElement("div"),d.className="jsoneditor-expand",u.appendChild(d),m=u;m.onclick=function(a){a.preventDefault();l._onExpandItem(e);m.focus()};u=[];e.subItems=u;d=document.createElement("ul");e.ul=d;d.className="jsoneditor-menu";d.style.height="0";c.appendChild(d);D(d,u,
a.submenu)}else c=document.createElement("div"),c.className="jsoneditor-icon",u.appendChild(c),c=document.createElement("div"),c.className="jsoneditor-text",c.appendChild(document.createTextNode((0,p.Iu)(a.text))),u.appendChild(c);g.push(e)}})}if(!(this instanceof d))throw new TypeError("Cannot call a class as a function");this.dom={};var l=this,x=this.dom;this.anchor=void 0;this.items=e;this.eventListeners={};this.selection=void 0;this.onClose=t?t.close:void 0;this.limitHeight=t?t.limitHeight:!1;
t=document.createElement("div");t.className="jsoneditor-contextmenu-root";x.root=t;var v=document.createElement("div");v.className="jsoneditor-contextmenu";x.menu=v;t.appendChild(v);t=document.createElement("ul");t.className="jsoneditor-menu";v.appendChild(t);x.list=t;x.items=[];v=document.createElement("button");v.type="button";x.focusButton=v;x=document.createElement("li");x.style.overflow="hidden";x.style.height="0";x.appendChild(v);t.appendChild(x);D(t,this.dom.items,e);this.maxHeight=0;e.forEach(function(b){l.maxHeight=
Math.max(l.maxHeight,24*(e.length+(b.submenu?b.submenu.length:0)))})}x(d,[{key:"_getVisibleButtons",value:function(){var e=[],d=this;this.dom.items.forEach(function(t){e.push(t.button);t.buttonExpand&&e.push(t.buttonExpand);t.subItems&&t===d.expandedItem&&t.subItems.forEach(function(d){e.push(d.button);d.buttonExpand&&e.push(d.buttonExpand)})});return e}},{key:"show",value:function(p,t,l){this.hide();var D=!0,x=p.parentNode,v=p.getBoundingClientRect(),b=x.getBoundingClientRect();x=t.getBoundingClientRect();
var g=this;this.dom.absoluteAnchor=(0,e.w)(p,t,function(){g.hide()});v.bottom+this.maxHeight<x.bottom||v.top-this.maxHeight>x.top&&(D=!1);t=l?0:v.top-b.top;D?(l=p.offsetHeight,this.dom.menu.style.left="0",this.dom.menu.style.top=t+l+"px",this.dom.menu.style.bottom=""):(this.dom.menu.style.left="0",this.dom.menu.style.top="",this.dom.menu.style.bottom="0px");this.limitHeight&&(this.dom.list.style.maxHeight=(D?x.bottom-v.bottom-10:v.top-x.top-10)+"px",this.dom.list.style.overflowY="auto");this.dom.absoluteAnchor.appendChild(this.dom.root);
this.selection=(0,A.getSelection)();this.anchor=p;setTimeout(function(){g.dom.focusButton.focus()},0);d.visibleMenu&&d.visibleMenu.hide();d.visibleMenu=this}},{key:"hide",value:function(){this.dom.absoluteAnchor&&(this.dom.absoluteAnchor.destroy(),delete this.dom.absoluteAnchor);if(this.dom.root.parentNode&&(this.dom.root.parentNode.removeChild(this.dom.root),this.onClose))this.onClose();d.visibleMenu===this&&(d.visibleMenu=void 0)}},{key:"_onExpandItem",value:function(e){var d=this,p=e===this.expandedItem,
l=this.expandedItem;l&&(l.ul.style.height="0",l.ul.style.padding="",setTimeout(function(){d.expandedItem!==l&&(l.ul.style.display="",(0,A.removeClassName)(l.ul.parentNode,"jsoneditor-selected"))},300),this.expandedItem=void 0);if(!p){var x=e.ul;x.style.display="block";x.clientHeight;setTimeout(function(){if(d.expandedItem===e){for(var t=0,b=0;b<x.childNodes.length;b++)t+=x.childNodes[b].clientHeight;x.style.height=t+"px";x.style.padding="5px 10px"}},0);(0,A.addClassName)(x.parentNode,"jsoneditor-selected");
this.expandedItem=e}}},{key:"_onKeyDown",value:function(e){var d=e.target,p=e.which,l=!1;27===p?(this.selection&&(0,A.setSelection)(this.selection),this.anchor&&this.anchor.focus(),this.hide(),l=!0):9===p?e.shiftKey?(p=this._getVisibleButtons(),d=p.indexOf(d),0===d&&(p[p.length-1].focus(),l=!0)):(p=this._getVisibleButtons(),d=p.indexOf(d),d===p.length-1&&(p[0].focus(),l=!0)):37===p?("jsoneditor-expand"===d.className&&(p=this._getVisibleButtons(),d=p.indexOf(d),(l=p[d-1])&&l.focus()),l=!0):38===p?
(p=this._getVisibleButtons(),d=p.indexOf(d),(l=p[d-1])&&"jsoneditor-expand"===l.className&&(l=p[d-2]),l||(l=p[p.length-1]),l&&l.focus(),l=!0):39===p?(p=this._getVisibleButtons(),d=p.indexOf(d),(l=p[d+1])&&"jsoneditor-expand"===l.className&&l.focus(),l=!0):40===p&&(p=this._getVisibleButtons(),d=p.indexOf(d),(l=p[d+1])&&"jsoneditor-expand"===l.className&&(l=p[d+2]),l||(l=p[0]),l&&l.focus(),l=!0);l&&(e.stopPropagation(),e.preventDefault())}}]);return d}();l.visibleMenu=void 0},436:function(w,n,d){function r(e,
d){for(var p=0;p<d.length;p++){var x=d[p];x.enumerable=x.enumerable||!1;x.configurable=!0;"value"in x&&(x.writable=!0);Object.defineProperty(e,x.key,x)}}function x(e,d,l){d&&r(e.prototype,d);l&&r(e,l);return e}d.d(n,{Q:function(){return e}});var e=function(){function e(d){if(!(this instanceof e))throw new TypeError("Cannot call a class as a function");this.errorTableVisible=d.errorTableVisible;this.onToggleVisibility=d.onToggleVisibility;this.onFocusLine=d.onFocusLine||function(){};this.onChangeHeight=
d.onChangeHeight;this.dom={};d=document.createElement("div");d.className="jsoneditor-validation-errors-container";this.dom.validationErrorsContainer=d;var p=document.createElement("div");p.style.display="none";p.className="jsoneditor-additional-errors fadein";p.textContent="Scroll for more \u25bf";this.dom.additionalErrorsIndication=p;d.appendChild(p);d=document.createElement("span");d.className="jsoneditor-validation-error-icon";d.style.display="none";this.dom.validationErrorIcon=d;d=document.createElement("span");
d.className="jsoneditor-validation-error-count";d.style.display="none";this.dom.validationErrorCount=d;this.dom.parseErrorIndication=document.createElement("span");this.dom.parseErrorIndication.className="jsoneditor-parse-error-icon";this.dom.parseErrorIndication.style.display="none"}x(e,[{key:"getErrorTable",value:function(){return this.dom.validationErrorsContainer}},{key:"getErrorCounter",value:function(){return this.dom.validationErrorCount}},{key:"getWarningIcon",value:function(){return this.dom.validationErrorIcon}},
{key:"getErrorIcon",value:function(){return this.dom.parseErrorIndication}},{key:"toggleTableVisibility",value:function(){this.errorTableVisible=!this.errorTableVisible;this.onToggleVisibility(this.errorTableVisible)}},{key:"setErrors",value:function(e,d){var p=this;this.dom.validationErrors&&(this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors),this.dom.validationErrors=null,this.dom.additionalErrorsIndication.style.display="none");if(this.errorTableVisible&&0<e.length){var l=
document.createElement("div");l.className="jsoneditor-validation-errors";var t=document.createElement("table");t.className="jsoneditor-text-errors";l.appendChild(t);var x=document.createElement("tbody");t.appendChild(x);e.forEach(function(e){if(!isNaN(e.line))var l=e.line;else if(e.dataPath){var t=d.find(function(a){return a.path===e.dataPath});t&&(l=t.line+1)}t=document.createElement("tr");t.className=isNaN(l)?"":"jump-to-line";t.className="error"===e.type?t.className+" parse-error":t.className+
" validation-error";var b=document.createElement("td"),g=document.createElement("button");g.className="jsoneditor-schema-error";b.appendChild(g);t.appendChild(b);b=document.createElement("td");b.style="white-space: nowrap;";b.textContent=isNaN(l)?"":"Ln "+l;t.appendChild(b);"string"===typeof e?(b=document.createElement("td"),b.colSpan=2,g=document.createElement("pre"),g.appendChild(document.createTextNode(e)),b.appendChild(g),t.appendChild(b)):(b=document.createElement("td"),b.appendChild(document.createTextNode(e.dataPath||
"")),t.appendChild(b),b=document.createElement("td"),g=document.createElement("pre"),g.appendChild(document.createTextNode(e.message)),b.appendChild(g),t.appendChild(b));t.onclick=function(){p.onFocusLine(l)};x.appendChild(t)});this.dom.validationErrors=l;this.dom.validationErrorsContainer.appendChild(l);this.dom.additionalErrorsIndication.title=e.length+" errors total";this.dom.validationErrorsContainer.clientHeight<this.dom.validationErrorsContainer.scrollHeight?(this.dom.additionalErrorsIndication.style.display=
"block",this.dom.validationErrorsContainer.onscroll=function(){p.dom.additionalErrorsIndication.style.display=0<p.dom.validationErrorsContainer.clientHeight&&0===p.dom.validationErrorsContainer.scrollTop?"block":"none"}):this.dom.validationErrorsContainer.onscroll=void 0;this.onChangeHeight(this.dom.validationErrorsContainer.clientHeight+(this.dom.statusBar?this.dom.statusBar.clientHeight:0))}else this.onChangeHeight(0);l=e.filter(function(e){return"error"!==e.type}).length;0<l?(this.dom.validationErrorCount.style.display=
"inline",this.dom.validationErrorCount.innerText=l,this.dom.validationErrorCount.onclick=this.toggleTableVisibility.bind(this),this.dom.validationErrorIcon.style.display="inline",this.dom.validationErrorIcon.title=l+" schema validation error(s) found",this.dom.validationErrorIcon.onclick=this.toggleTableVisibility.bind(this)):(this.dom.validationErrorCount.style.display="none",this.dom.validationErrorIcon.style.display="none");e.some(function(e){return"error"===e.type})?(e=e[0].line,this.dom.parseErrorIndication.style.display=
"block",this.dom.parseErrorIndication.title=isNaN(e)?"parse error - check that the json is valid":"parse error on line "+e,this.dom.parseErrorIndication.onclick=this.toggleTableVisibility.bind(this)):this.dom.parseErrorIndication.style.display="none"}}]);return e}()},474:function(w,n,d){function r(e,d){for(var l=0;l<d.length;l++){var p=d[l];p.enumerable=p.enumerable||!1;p.configurable=!0;"value"in p&&(p.writable=!0);Object.defineProperty(e,p.key,p)}}function x(e,d,l){d&&r(e.prototype,d);l&&r(e,l);
return e}d.d(n,{R:function(){return e}});var e=function(){function e(d){if(!(this instanceof e))throw new TypeError("Cannot call a class as a function");this.target=d.target||null;if(!this.target)throw Error('FocusTracker constructor called without a "target" to track.');this.onFocus="function"===typeof d.onFocus?d.onFocus:null;this.onBlur="function"===typeof d.onBlur?d.onBlur:null;this._onClick=this._onEvent.bind(this);this._onKeyUp=function(e){9!==e.which&&9!==e.keyCode||this._onEvent(e)}.bind(this);
this.focusFlag=!1;this.firstEventFlag=!0;if(this.onFocus||this.onBlur)document.addEventListener("click",this._onClick),document.addEventListener("keyup",this._onKeyUp)}x(e,[{key:"destroy",value:function(){document.removeEventListener("click",this._onClick);document.removeEventListener("keyup",this._onKeyUp);this._onEvent({target:document.body})}},{key:"_onEvent",value:function(e){e=e.target;if(e===this.target||this.target.contains(e)||this.target.contains(document.activeElement)){if(!this.focusFlag){if(this.onFocus)this.onFocus({type:"focus",
target:this.target});this.focusFlag=!0}}else if(this.focusFlag||this.firstEventFlag){if(this.onBlur)this.onBlur({type:"blur",target:this.target});this.focusFlag=!1;this.firstEventFlag&&(this.firstEventFlag=!1)}}}]);return e}()},161:function(w,n,d){function r(b,a,c){if(!(this instanceof r))throw Error('JSONEditor constructor called without "new".');var h=D();if(-1!==h&&9>h)throw Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");a&&(a.error&&(console.warn('Option "error" has been renamed to "onError"'),
a.onError=a.error,delete a.error),a.change&&(console.warn('Option "change" has been renamed to "onChange"'),a.onChange=a.change,delete a.change),a.editable&&(console.warn('Option "editable" has been renamed to "onEditable"'),a.onEditable=a.editable,delete a.editable),a.onChangeJSON&&("text"===a.mode||"code"===a.mode||a.modes&&(-1!==a.modes.indexOf("text")||-1!==a.modes.indexOf("code")))&&console.warn('Option "onChangeJSON" is not applicable to modes "text" and "code". Use "onChangeText" or "onChange" instead.'),
a&&Object.keys(a).forEach(function(a){-1===r.VALID_OPTIONS.indexOf(a)&&console.warn('Unknown option "'+a+'". This option will be ignored')}));arguments.length&&this._create(b,a,c)}n=d(170);var x=d(37),e=d(38).treeModeMixins,A=d(956).textModeMixins,p=d(341).previewModeMixins,l=d(791),I=l.clear,F=l.extend,t=l.getInnerText,D=l.getInternetExplorerVersion,G=l.parse;l=d(744).tryRequireAjv;var J=d(558).showTransformModal,v=d(210).showSortModal,b=l();"undefined"===typeof Promise&&console.error("Promise undefined. Please load a Promise polyfill in the browser in order to use JSONEditor");
r.modes={};r.prototype.DEBOUNCE_INTERVAL=150;r.VALID_OPTIONS="ajv schema schemaRefs templates ace theme autocomplete onChange onChangeJSON onChangeText onEditable onError onEvent onModeChange onNodeName onValidate onCreateMenu onSelectionChange onTextSelectionChange onClassName onFocus onBlur colorPicker onColorPicker timestampTag timestampFormat escapeUnicode history search mode modes name indentation sortObjectKeys navigationBar statusBar mainMenuBar languages language enableSort enableTransform limitDragging maxVisibleChilds onValidationError modalAnchor popupAnchor createQuery executeQuery queryDescription".split(" ");
r.prototype._create=function(b,a,c){this.container=b;this.options=a||{};this.json=c||{};this.setMode(this.options.mode||this.options.modes&&this.options.modes[0]||"tree")};r.prototype.destroy=function(){};r.prototype.set=function(b){this.json=b};r.prototype.get=function(){return this.json};r.prototype.setText=function(b){this.json=G(b)};r.prototype.getText=function(){return JSON.stringify(this.json)};r.prototype.setName=function(b){this.options||(this.options={});this.options.name=b};r.prototype.getName=
function(){return this.options&&this.options.name};r.prototype.setMode=function(b){if(b!==this.options.mode||!this.create){var a=this.container,c=F({},this.options),h=c.mode;c.mode=b;var g=r.modes[b];if(g)try{var e="text"===g.data;var d=this.getName();var m=this[e?"getText":"get"]();this.destroy();I(this);F(this,g.mixin);this.create(a,c);this.setName(d);this[e?"setText":"set"](m);if("function"===typeof g.load)try{g.load.call(this)}catch(H){console.error(H)}if("function"===typeof c.onModeChange&&b!==
h)try{c.onModeChange(b,h)}catch(H){console.error(H)}}catch(H){this._onError(H)}else throw Error('Unknown mode "'+c.mode+'"');}};r.prototype.getMode=function(){return this.options.mode};r.prototype._onError=function(b){if(this.options&&"function"===typeof this.options.onError)this.options.onError(b);else throw b;};r.prototype.setSchema=function(g,a){if(g){try{if(this.options.ajv)var c=this.options.ajv;else c=b({allErrors:!0,verbose:!0,schemaId:"auto",$data:!0}),c.addMetaSchema(d(Object(function(){var a=
Error("Cannot find module 'ajv/lib/refs/json-schema-draft-04.json'");a.code="MODULE_NOT_FOUND";throw a;}()))),c.addMetaSchema(d(Object(function(){var a=Error("Cannot find module 'ajv/lib/refs/json-schema-draft-06.json'");a.code="MODULE_NOT_FOUND";throw a;}())))}catch(u){console.warn("Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.")}if(c){if(a){for(var h in a)c.removeSchema(h),
a[h]&&c.addSchema(a[h],h);this.options.schemaRefs=a}this.validateSchema=c.compile(g);this.options.schema=g;this.validate()}}else this.validateSchema=null,this.options.schema=null,this.options.schemaRefs=null,this.validate();this.refresh()};r.prototype.validate=function(){};r.prototype.refresh=function(){};r.registerMode=function(b){var a;if(Array.isArray(b))for(a=0;a<b.length;a++)r.registerMode(b[a]);else{if(!("mode"in b))throw Error('Property "mode" missing');if(!("mixin"in b))throw Error('Property "mixin" missing');
if(!("data"in b))throw Error('Property "data" missing');var c=b.mode;if(c in r.modes)throw Error('Mode "'+c+'" already registered');if("function"!==typeof b.mixin.create)throw Error('Required function "create" missing on mixin');var h=["setMode","registerMode","modes"];for(a=0;a<h.length;a++){var g=h[a];if(g in b.mixin)throw Error('Reserved property "'+g+'" not allowed in mixin');}r.modes[c]=b}};r.registerMode(e);r.registerMode(A);r.registerMode(p);r.ace=n;r.Ajv=b;r.VanillaPicker=x;r.showTransformModal=
J;r.showSortModal=v;r.getInnerText=t;r["default"]=r;w.exports=r},617:function(w,n,d){function r(e,d){for(var l=0;l<d.length;l++){var p=d[l];p.enumerable=p.enumerable||!1;p.configurable=!0;"value"in p&&(p.writable=!0);Object.defineProperty(e,p.key,p)}}function x(e,d,p){d&&r(e.prototype,d);p&&r(e,p);return e}d.d(n,{x:function(){return p}});var e=d(897),A=d(907),p=function(){function d(p,l,t,x){if(!(this instanceof d))throw new TypeError("Cannot call a class as a function");for(var r={code:{text:(0,
A.Iu)("modeCodeText"),title:(0,A.Iu)("modeCodeTitle"),click:function(){x("code")}},form:{text:(0,A.Iu)("modeFormText"),title:(0,A.Iu)("modeFormTitle"),click:function(){x("form")}},text:{text:(0,A.Iu)("modeTextText"),title:(0,A.Iu)("modeTextTitle"),click:function(){x("text")}},tree:{text:(0,A.Iu)("modeTreeText"),title:(0,A.Iu)("modeTreeTitle"),click:function(){x("tree")}},view:{text:(0,A.Iu)("modeViewText"),title:(0,A.Iu)("modeViewTitle"),click:function(){x("view")}},preview:{text:(0,A.Iu)("modePreviewText"),
title:(0,A.Iu)("modePreviewTitle"),click:function(){x("preview")}}},n=[],v=0;v<l.length;v++){var b=l[v],g=r[b];if(!g)throw Error('Unknown mode "'+b+'"');g.className="jsoneditor-type-modes"+(t===b?" jsoneditor-selected":"");n.push(g)}l=r[t];if(!l)throw Error('Unknown mode "'+t+'"');t=l.text;var a=document.createElement("button");a.type="button";a.className="jsoneditor-modes jsoneditor-separator";a.textContent=t+" \u25be";a.title=(0,A.Iu)("modeEditorTitle");a.onclick=function(){(new e.x(n)).show(a,
p)};t=document.createElement("div");t.className="jsoneditor-modes";t.style.position="relative";t.appendChild(a);p.appendChild(t);this.dom={container:p,box:a,frame:t}}x(d,[{key:"focus",value:function(){this.dom.box.focus()}},{key:"destroy",value:function(){this.dom&&this.dom.frame&&this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame);this.dom=null}}]);return d}()},170:function(w,n,d){if(window.ace)var r=window.ace;else try{r=d(Object(function(){var e=Error("Cannot find module 'ace-builds/src-noconflict/ace'");
e.code="MODULE_NOT_FOUND";throw e;}()));d(Object(function(){var e=Error("Cannot find module 'ace-builds/src-noconflict/mode-json'");e.code="MODULE_NOT_FOUND";throw e;}()));d(Object(function(){var e=Error("Cannot find module 'ace-builds/src-noconflict/ext-searchbox'");e.code="MODULE_NOT_FOUND";throw e;}()));var x=d(Object(function(){var e=Error("Cannot find module '../generated/worker-json-data-url'");e.code="MODULE_NOT_FOUND";throw e;}()));r.config.setModuleUrl("ace/mode/json_worker",x)}catch(e){}w.exports=
r},864:function(){window.ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(w,n,d){n.isDark=!1;n.cssClass="ace-jsoneditor";n.cssText='.ace-jsoneditor .ace_gutter {\nbackground: #ebebeb;\ncolor: #333\n}\n\n.ace-jsoneditor.ace_editor {\nfont-family: "dejavu sans mono", "droid sans mono", consolas, monaco, "lucida console", "courier new", courier, monospace, sans-serif;\nline-height: 1.3;\nbackground-color: #fff;\n}\n.ace-jsoneditor .ace_print-margin {\nwidth: 1px;\nbackground: #e8e8e8\n}\n.ace-jsoneditor .ace_scroller {\nbackground-color: #FFFFFF\n}\n.ace-jsoneditor .ace_text-layer {\ncolor: gray\n}\n.ace-jsoneditor .ace_variable {\ncolor: #1a1a1a\n}\n.ace-jsoneditor .ace_cursor {\nborder-left: 2px solid #000000\n}\n.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {\nborder-left: 0px;\nborder-bottom: 1px solid #000000\n}\n.ace-jsoneditor .ace_marker-layer .ace_selection {\nbackground: lightgray\n}\n.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {\nbox-shadow: 0 0 3px 0px #FFFFFF;\nborder-radius: 2px\n}\n.ace-jsoneditor .ace_marker-layer .ace_step {\nbackground: rgb(255, 255, 0)\n}\n.ace-jsoneditor .ace_marker-layer .ace_bracket {\nmargin: -1px 0 0 -1px;\nborder: 1px solid #BFBFBF\n}\n.ace-jsoneditor .ace_marker-layer .ace_active-line {\nbackground: #FFFBD1\n}\n.ace-jsoneditor .ace_gutter-active-line {\nbackground-color : #dcdcdc\n}\n.ace-jsoneditor .ace_marker-layer .ace_selected-word {\nborder: 1px solid lightgray\n}\n.ace-jsoneditor .ace_invisible {\ncolor: #BFBFBF\n}\n.ace-jsoneditor .ace_keyword,\n.ace-jsoneditor .ace_meta,\n.ace-jsoneditor .ace_support.ace_constant.ace_property-value {\ncolor: #AF956F\n}\n.ace-jsoneditor .ace_keyword.ace_operator {\ncolor: #484848\n}\n.ace-jsoneditor .ace_keyword.ace_other.ace_unit {\ncolor: #96DC5F\n}\n.ace-jsoneditor .ace_constant.ace_language {\ncolor: darkorange\n}\n.ace-jsoneditor .ace_constant.ace_numeric {\ncolor: red\n}\n.ace-jsoneditor .ace_constant.ace_character.ace_entity {\ncolor: #BF78CC\n}\n.ace-jsoneditor .ace_invalid {\ncolor: #FFFFFF;\nbackground-color: #FF002A;\n}\n.ace-jsoneditor .ace_fold {\nbackground-color: #AF956F;\nborder-color: #000000\n}\n.ace-jsoneditor .ace_storage,\n.ace-jsoneditor .ace_support.ace_class,\n.ace-jsoneditor .ace_support.ace_function,\n.ace-jsoneditor .ace_support.ace_other,\n.ace-jsoneditor .ace_support.ace_type {\ncolor: #C52727\n}\n.ace-jsoneditor .ace_string {\ncolor: green\n}\n.ace-jsoneditor .ace_comment {\ncolor: #BCC8BA\n}\n.ace-jsoneditor .ace_entity.ace_name.ace_tag,\n.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {\ncolor: #606060\n}\n.ace-jsoneditor .ace_markup.ace_underline {\ntext-decoration: underline\n}\n.ace-jsoneditor .ace_indent-guide {\nbackground: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y\n}';
w("../lib/dom").importCssString(n.cssText,n.cssClass)})},589:function(w,n){w=function(){var d={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",
18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(d,e,r,p,l,n,w){e=n.length-1;switch(l){case 1:this.$=d.replace(/\\(\\|")/g,"$1").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"\t").replace(/\\v/g,"\v").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(d);break;case 3:this.$=null;break;case 4:this.$=!0;
break;case 5:this.$=!1;break;case 6:return this.$=n[e-1];case 13:this.$={};break;case 14:this.$=n[e-1];break;case 15:this.$=[n[e-2],n[e]];break;case 16:this.$={};this.$[n[e][0]]=n[e][1];break;case 17:this.$=n[e-2];n[e-2][n[e][0]]=n[e][1];break;case 18:this.$=[];break;case 19:this.$=n[e-1];break;case 20:this.$=[n[e]];break;case 21:this.$=n[e-2],n[e-2].push(n[e])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,
7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,
8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,
6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(d,e){throw Error(d);},parse:function(d){function e(){var a=x.lexer.lex()||1;"number"!==typeof a&&(a=x.symbols_[a]||a);return a}var x=this,p=[0],l=[null],n=[],r=this.table,t="",D=0,w=0,J=0;this.lexer.setInput(d);this.lexer.yy=this.yy;this.yy.lexer=this.lexer;"undefined"==typeof this.lexer.yylloc&&(this.lexer.yylloc=
{});d=this.lexer.yylloc;n.push(d);"function"===typeof this.yy.parseError&&(this.parseError=this.yy.parseError);for(var v,b,g,a,c={},h,u;;){g=p[p.length-1];this.defaultActions[g]?a=this.defaultActions[g]:(null==v&&(v=e()),a=r[g]&&r[g][v]);if("undefined"===typeof a||!a.length||!a[0]){if(!J){b=[];for(h in r[g])this.terminals_[h]&&2<h&&b.push("'"+this.terminals_[h]+"'");var M="";M=this.lexer.showPosition?"Parse error on line "+(D+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+b.join(", ")+", got '"+
this.terminals_[v]+"'":"Parse error on line "+(D+1)+": Unexpected "+(1==v?"end of input":"'"+(this.terminals_[v]||v)+"'");this.parseError(M,{text:this.lexer.match,token:this.terminals_[v]||v,line:this.lexer.yylineno,loc:d,expected:b})}if(3==J){if(1==v)throw Error(M||"Parsing halted.");w=this.lexer.yyleng;t=this.lexer.yytext;D=this.lexer.yylineno;d=this.lexer.yylloc;v=e()}for(;!((2).toString()in r[g]);){if(0==g)throw Error(M||"Parsing halted.");p.length-=2;--l.length;--n.length;g=p[p.length-1]}b=v;
v=2;g=p[p.length-1];a=r[g]&&r[g][2];J=3}if(a[0]instanceof Array&&1<a.length)throw Error("Parse Error: multiple actions possible at state: "+g+", token: "+v);switch(a[0]){case 1:p.push(v);l.push(this.lexer.yytext);n.push(this.lexer.yylloc);p.push(a[1]);v=null;b?(v=b,b=null):(w=this.lexer.yyleng,t=this.lexer.yytext,D=this.lexer.yylineno,d=this.lexer.yylloc,0<J&&J--);break;case 2:u=this.productions_[a[1]][1];c.$=l[l.length-u];c._$={first_line:n[n.length-(u||1)].first_line,last_line:n[n.length-1].last_line,
first_column:n[n.length-(u||1)].first_column,last_column:n[n.length-1].last_column};g=this.performAction.call(c,t,w,D,this.yy,a[1],l,n);if("undefined"!==typeof g)return g;u&&(p=p.slice(0,-2*u),l=l.slice(0,-1*u),n=n.slice(0,-1*u));p.push(this.productions_[a[1]][0]);l.push(c.$);n.push(c._$);a=r[p[p.length-2]][p[p.length-1]];p.push(a);break;case 3:return!0}}}},r=function(){return{EOF:1,parseError:function(d,e){if(this.yy.parseError)this.yy.parseError(d,e);else throw Error(d);},setInput:function(d){this._input=
d;this._more=this._less=this.done=!1;this.yylineno=this.yyleng=0;this.yytext=this.matched=this.match="";this.conditionStack=["INITIAL"];this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0};return this},input:function(){var d=this._input[0];this.yytext+=d;this.yyleng++;this.match+=d;this.matched+=d;d.match(/\n/)&&this.yylineno++;this._input=this._input.slice(1);return d},unput:function(d){this._input=d+this._input;return this},more:function(){this._more=!0;return this},less:function(d){this._input=
this.match.slice(d)+this._input},pastInput:function(){var d=this.matched.substr(0,this.matched.length-this.match.length);return(20<d.length?"...":"")+d.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var d=this.match;20>d.length&&(d+=this._input.substr(0,20-d.length));return(d.substr(0,20)+(20<d.length?"...":"")).replace(/\n/g,"")},showPosition:function(){var d=this.pastInput(),e=Array(d.length+1).join("-");return d+this.upcomingInput()+"\n"+e+"^"},next:function(){if(this.done)return this.EOF;
this._input||(this.done=!0);var d;this._more||(this.match=this.yytext="");for(var e=this._currentRules(),n=0;n<e.length;n++)if((d=this._input.match(this.rules[e[n]]))&&(!p||d[0].length>p[0].length)){var p=d;var l=n;if(!this.options.flex)break}if(p){if(d=p[0].match(/\n.*/g))this.yylineno+=d.length;this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:d?d[d.length-1].length-1:this.yylloc.last_column+p[0].length};this.yytext+=p[0];this.match+=
p[0];this.yyleng=this.yytext.length;this._more=!1;this._input=this._input.slice(p[0].length);this.matched+=p[0];p=this.performAction.call(this,this.yy,this,e[l],this.conditionStack[this.conditionStack.length-1]);this.done&&this._input&&(this.done=!1);if(p)return p}else{if(""===this._input)return this.EOF;this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})}},lex:function(){var d=this.next();return"undefined"!==
typeof d?d:this.lex()},begin:function(d){this.conditionStack.push(d)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(d){this.begin(d)},options:{},performAction:function(d,e,n,p){switch(n){case 1:return 6;case 2:return e.yytext=e.yytext.substr(1,e.yyleng-2),4;case 3:return 17;case 4:return 18;
case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},rules:[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],conditions:{INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}}}}();
d.lexer=r;return d}();n.parser=w;n.parse=w.parse.bind(w)},879:function(w){function n(b,g){return b.hasOwnProperty(g)&&(!0===b[g]||b[g].length)}function d(b,g,a){b.parentNode?b.parentNode.parentNode||g.appendChild(b.parentNode):g.appendChild(b);e.removeClass(b,"excluded");a||(b.textContent+="")}var r={defaultSelected:!0,width:"auto",disabled:!1,searchable:!0,clearable:!1,sortSelected:!1,allowDeselect:!1,closeOnScroll:!1,nativeDropdown:!1,placeholder:"Select an option...",taggable:!1,tagPlaceholder:"Enter a tag..."},
x=function(){};x.prototype={on:function(b,g){this._events=this._events||{};this._events[b]=this._events[b]||[];this._events[b].push(g)},off:function(b,g){this._events=this._events||{};!1!==b in this._events&&this._events[b].splice(this._events[b].indexOf(g),1)},emit:function(b){this._events=this._events||{};if(!1!==b in this._events)for(var g=0;g<this._events[b].length;g++)this._events[b][g].apply(this,Array.prototype.slice.call(arguments,1))}};x.mixin=function(b){for(var g=["on","off","emit"],a=
0;a<g.length;a++)"function"===typeof b?b.prototype[g[a]]=x.prototype[g[a]]:b[g[a]]=x.prototype[g[a]];return b};var e={extend:function(b,g){g=g||{};for(var a in b)b.hasOwnProperty(a)&&(g.hasOwnProperty(a)||(g[a]=b[a]));return g},each:function(b,g,a){if("[object Object]"===Object.prototype.toString.call(b))for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&g.call(a,c,b[c],b);else{c=0;for(var h=b.length;c<h;c++)g.call(a,c,b[c],b)}},createElement:function(b,g){var a=document;b=a.createElement(b);
if(g&&"[object Object]"===Object.prototype.toString.call(g))for(var c in g)if(c in b)b[c]=g[c];else if("html"===c)b.textContent=g[c];else if("text"===c){var h=a.createTextNode(g[c]);b.appendChild(h)}else b.setAttribute(c,g[c]);return b},hasClass:function(b,g){if(b)return b.classList?b.classList.contains(g):!!b.className&&!!b.className.match(new RegExp("(\\s|^)"+g+"(\\s|$)"))},addClass:function(b,g){e.hasClass(b,g)||(b.classList?b.classList.add(g):b.className=b.className.trim()+" "+g)},removeClass:function(b,
g){e.hasClass(b,g)&&(b.classList?b.classList.remove(g):b.className=b.className.replace(new RegExp("(^|\\s)"+g.split(" ").join("|")+"(\\s|$)","gi")," "))},closest:function(b,g){return b&&b!==document.body&&(g(b)?b:e.closest(b.parentNode,g))},isInt:function(b){return"number"===typeof b&&isFinite(b)&&Math.floor(b)===b},debounce:function(b,g,a){var c;return function(){var h=this,u=arguments,d=a&&!c;clearTimeout(c);c=setTimeout(function(){c=null;a||b.apply(h,u)},g);d&&b.apply(h,u)}},rect:function(b,g){var a=
window;b=b.getBoundingClientRect();var c=g?a.pageXOffset:0;g=g?a.pageYOffset:0;return{bottom:b.bottom+g,height:b.height,left:b.left+c,right:b.right+c,top:b.top+g,width:b.width}},includes:function(b,g){return-1<b.indexOf(g)},truncate:function(b){for(;b.firstChild;)b.removeChild(b.firstChild)}},A=function(){if(this.items.length){var b=document.createDocumentFragment();if(this.config.pagination){var g=this.pages.slice(0,this.pageIndex);e.each(g,function(a,c){e.each(c,function(a,c){d(c,b,this.customOption)},
this)},this)}else e.each(this.items,function(a,c){d(c,b,this.customOption)},this);b.childElementCount&&(e.removeClass(this.items[this.navIndex],"active"),this.navIndex=b.querySelector(".selectr-option").idx,e.addClass(this.items[this.navIndex],"active"));this.tree.appendChild(b)}},p=function(b){this.container.contains(b.target)||!this.opened&&!e.hasClass(this.container,"notice")||this.close()},l=function(b,g){g=this.customOption?this.config.renderOption(g||b):b.textContent;g=e.createElement("li",
{"class":"selectr-option",html:g,role:"treeitem","aria-selected":!1});g.idx=b.idx;this.items.push(g);b.defaultSelected&&this.defaultSelected.push(b.idx);b.disabled&&(g.disabled=!0,e.addClass(g,"disabled"));return g},I=function(){this.requiresPagination=this.config.pagination&&0<this.config.pagination;n(this.config,"width")&&(e.isInt(this.config.width)?this.width=this.config.width+"px":"auto"===this.config.width?this.width="100%":e.includes(this.config.width,"%")&&(this.width=this.config.width));this.container=
e.createElement("div",{"class":"selectr-container"});this.config.customClass&&e.addClass(this.container,this.config.customClass);this.mobileDevice?e.addClass(this.container,"selectr-mobile"):e.addClass(this.container,"selectr-desktop");this.el.tabIndex=-1;this.config.nativeDropdown||this.mobileDevice?e.addClass(this.el,"selectr-visible"):e.addClass(this.el,"selectr-hidden");this.selected=e.createElement("div",{"class":"selectr-selected",disabled:this.disabled,tabIndex:1,"aria-expanded":!1});this.label=
e.createElement(this.el.multiple?"ul":"span",{"class":"selectr-label"});var b=e.createElement("div",{"class":"selectr-options-container"});this.tree=e.createElement("ul",{"class":"selectr-options",role:"tree","aria-hidden":!0,"aria-expanded":!1});this.notice=e.createElement("div",{"class":"selectr-notice"});this.el.setAttribute("aria-hidden",!0);this.disabled&&(this.el.disabled=!0);this.el.multiple&&(e.addClass(this.label,"selectr-tags"),e.addClass(this.container,"multiple"),this.tags=[],this.selectedValues=
this.getSelectedProperties("value"),this.selectedIndexes=this.getSelectedProperties("idx"));this.selected.appendChild(this.label);this.config.clearable&&(this.selectClear=e.createElement("button",{"class":"selectr-clear",type:"button"}),this.container.appendChild(this.selectClear),e.addClass(this.container,"clearable"));if(this.config.taggable){var g=e.createElement("li",{"class":"input-tag"});this.input=e.createElement("input",{"class":"selectr-tag-input",placeholder:this.config.tagPlaceholder,tagIndex:0,
autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"});g.appendChild(this.input);this.label.appendChild(g);e.addClass(this.container,"taggable");this.tagSeperators=[","];this.config.tagSeperators&&(this.tagSeperators=this.tagSeperators.concat(this.config.tagSeperators))}this.config.searchable&&(this.input=e.createElement("input",{"class":"selectr-input",tagIndex:-1,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",
type:"search"}),this.inputClear=e.createElement("button",{"class":"selectr-input-clear",type:"button"}),this.inputContainer=e.createElement("div",{"class":"selectr-input-container"}),this.inputContainer.appendChild(this.input),this.inputContainer.appendChild(this.inputClear),b.appendChild(this.inputContainer));b.appendChild(this.notice);b.appendChild(this.tree);this.items=[];this.options=[];this.el.options.length&&(this.options=[].slice.call(this.el.options));var a=!1,c=0;this.el.children.length&&
e.each(this.el.children,function(b,h){"OPTGROUP"===h.nodeName?(a=e.createElement("ul",{"class":"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+h.label+"</li>"}),e.each(h.children,function(h,b){b.idx=c;a.appendChild(l.call(this,b,a));c++},this)):(h.idx=c,l.call(this,h),c++)},this);if(this.config.data&&Array.isArray(this.config.data)){this.data=[];var h=!1,u;a=!1;c=0;e.each(this.config.data,function(b,g){n(g,"children")?(h=e.createElement("optgroup",{label:g.text}),a=e.createElement("ul",
{"class":"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+g.text+"</li>"}),e.each(g.children,function(b,g){u=new Option(g.text,g.value,!1,g.hasOwnProperty("selected")&&!0===g.selected);u.disabled=n(g,"disabled");this.options.push(u);h.appendChild(u);u.idx=c;a.appendChild(l.call(this,u,g));this.data[c]=g;c++},this)):(u=new Option(g.text,g.value,!1,g.hasOwnProperty("selected")&&!0===g.selected),u.disabled=n(g,"disabled"),this.options.push(u),u.idx=c,l.call(this,u,g),this.data[c]=
g,c++)},this)}this.setSelected(!0);for(var d=this.navIndex=0;d<this.items.length;d++)if(g=this.items[d],!e.hasClass(g,"disabled")){e.addClass(g,"active");this.navIndex=d;break}this.requiresPagination&&(this.pageIndex=1,this.paginate());this.container.appendChild(this.selected);this.container.appendChild(b);this.placeEl=e.createElement("div",{"class":"selectr-placeholder"});this.setPlaceholder();this.selected.appendChild(this.placeEl);this.disabled&&this.disable();this.el.parentNode.insertBefore(this.container,
this.el);this.container.appendChild(this.el)},F=function(b){b=b||window.event;if(this.items.length&&this.opened&&e.includes([13,38,40],b.which)){b.preventDefault();if(13===b.which)return this.config.taggable&&0<this.input.value.length?!1:this.change(this.navIndex);var g=this.items[this.navIndex];switch(b.which){case 38:var a=0;0<this.navIndex&&this.navIndex--;break;case 40:a=1,this.navIndex<this.items.length-1&&this.navIndex++}for(this.navigating=!0;e.hasClass(this.items[this.navIndex],"disabled")||
e.hasClass(this.items[this.navIndex],"excluded");)if(a?this.navIndex++:this.navIndex--,this.searching)if(this.navIndex>this.tree.lastElementChild.idx){this.navIndex=this.tree.lastElementChild.idx;break}else if(this.navIndex<this.tree.firstElementChild.idx){this.navIndex=this.tree.firstElementChild.idx;break}b=e.rect(this.items[this.navIndex]);a?(0===this.navIndex?this.tree.scrollTop=0:b.top+b.height>this.optsRect.top+this.optsRect.height&&(this.tree.scrollTop+=b.top+b.height-(this.optsRect.top+this.optsRect.height)),
this.navIndex===this.tree.childElementCount-1&&this.requiresPagination&&G.call(this)):0===this.navIndex?this.tree.scrollTop=0:0>b.top-this.optsRect.top&&(this.tree.scrollTop+=b.top-this.optsRect.top);g&&e.removeClass(g,"active");e.addClass(this.items[this.navIndex],"active")}else this.navigating=!1},t=function(b){var g=this,a=document.createDocumentFragment(),c=this.options[b.idx],h=this.data?this.data[b.idx]:c;h=this.customSelected?this.config.renderSelection(h):c.textContent;h=e.createElement("li",
{"class":"selectr-tag",html:h});var u=e.createElement("button",{"class":"selectr-tag-remove",type:"button"});h.appendChild(u);h.idx=b.idx;h.tag=c.value;this.tags.push(h);if(this.config.sortSelected){b=this.tags.slice();var d=function(a,c){a.replace(/(\d+)|(\D+)/g,function(a,h,b){c.push([h||Infinity,b||""])})};b.sort(function(a,c){var h=[],b=[];if(!0===g.config.sortSelected){var u=a.tag;var e=c.tag}else"text"===g.config.sortSelected&&(u=a.textContent,e=c.textContent);d(u,h);for(d(e,b);h.length&&b.length;)if(a=
h.shift(),c=b.shift(),a=a[0]-c[0]||a[1].localeCompare(c[1]))return a;return h.length-b.length});e.each(b,function(c,h){a.appendChild(h)});this.label.textContent=""}else a.appendChild(h);this.config.taggable?this.label.insertBefore(a,this.input.parentNode):this.label.appendChild(a)},D=function(b){var g=!1;e.each(this.tags,function(a,c){c.idx===b.idx&&(g=c)},this);g&&(this.label.removeChild(g),this.tags.splice(this.tags.indexOf(g),1))},G=function(){var b=this.tree;if(b.scrollTop>=b.scrollHeight-b.offsetHeight&&
this.pageIndex<this.pages.length){var g=document.createDocumentFragment();e.each(this.pages[this.pageIndex],function(a,c){d(c,g,this.customOption)},this);b.appendChild(g);this.pageIndex++;this.emit("selectr.paginate",{items:this.items.length,total:this.data.length,page:this.pageIndex,pages:this.pages.length})}},J=function(){if(this.config.searchable||this.config.taggable)this.input.value=null,this.searching=!1,this.config.searchable&&e.removeClass(this.inputContainer,"active"),e.hasClass(this.container,
"notice")&&(e.removeClass(this.container,"notice"),e.addClass(this.container,"open"),this.input.focus()),e.each(this.items,function(b,g){e.removeClass(g,"excluded");this.customOption||(g.textContent+="")},this)},v=function(b,g){g=g||{};if(!b)throw Error("You must supply either a HTMLSelectElement or a CSS3 selector string.");this.el=b;"string"===typeof b&&(this.el=document.querySelector(b));if(null===this.el)throw Error("The element you passed to Selectr can not be found.");if("select"!==this.el.nodeName.toLowerCase())throw Error("The element you passed to Selectr is not a HTMLSelectElement.");
this.render(g)};v.prototype.render=function(b){if(!this.rendered){this.config=e.extend(r,b);this.originalType=this.el.type;this.originalIndex=this.el.tabIndex;this.defaultSelected=[];this.originalOptionCount=this.el.options.length;if(this.config.multiple||this.config.taggable)this.el.multiple=!0;this.disabled=n(this.config,"disabled");this.opened=!1;this.config.taggable&&(this.config.searchable=!1);this.mobileDevice=this.navigating=!1;/Android|webOS|iPhone|iPad|BlackBerry|Windows Phone|Opera Mini|IEMobile|Mobile/i.test(navigator.userAgent)&&
(this.mobileDevice=!0);this.customOption=this.config.hasOwnProperty("renderOption")&&"function"===typeof this.config.renderOption;this.customSelected=this.config.hasOwnProperty("renderSelection")&&"function"===typeof this.config.renderSelection;x.mixin(this);I.call(this);this.bindEvents();this.update();this.optsRect=e.rect(this.tree);this.rendered=!0;this.el.multiple||(this.el.selectedIndex=this.selectedIndex);var g=this;setTimeout(function(){g.emit("selectr.init")},20)}};v.prototype.getSelected=
function(){return this.el.querySelectorAll("option:checked")};v.prototype.getSelectedProperties=function(b){var g=this.getSelected();return[].slice.call(g).map(function(a){return a[b]}).filter(function(a){return null!==a&&void 0!==a})};v.prototype.bindEvents=function(){var b=this;this.events={};this.events.dismiss=p.bind(this);this.events.navigate=F.bind(this);this.events.reset=this.reset.bind(this);if(this.config.nativeDropdown||this.mobileDevice){this.container.addEventListener("touchstart",function(a){a.changedTouches[0].target===
b.el&&b.toggle()});(this.config.nativeDropdown||this.mobileDevice)&&this.container.addEventListener("click",function(a){a.preventDefault();a.stopPropagation();a.target===b.el&&b.toggle()});var g=function(a,c){var h=[];a=a.slice(0);for(var b,g=0;g<c.length;g++)b=a.indexOf(c[g]),-1<b?a.splice(b,1):h.push(c[g]);return[h,a]};this.el.addEventListener("change",function(a){b.el.multiple?(a=b.getSelectedProperties("idx"),a=g(b.selectedIndexes,a),e.each(a[0],function(a,h){b.select(h)},b),e.each(a[1],function(a,
h){b.deselect(h)},b)):-1<b.el.selectedIndex&&b.select(b.el.selectedIndex)})}this.config.nativeDropdown&&this.container.addEventListener("keydown",function(a){"Enter"===a.key&&b.selected===document.activeElement&&(b.toggle(),setTimeout(function(){b.el.focus()},200))});this.selected.addEventListener("click",function(a){b.disabled||b.toggle();a.preventDefault();a.stopPropagation()});this.label.addEventListener("click",function(a){e.hasClass(a.target,"selectr-tag-remove")&&b.deselect(a.target.parentNode.idx)});
this.selectClear&&this.selectClear.addEventListener("click",this.clear.bind(this));this.tree.addEventListener("mousedown",function(a){a.preventDefault()});this.tree.addEventListener("click",function(a){a.preventDefault();a.stopPropagation();(a=e.closest(a.target,function(a){return a&&e.hasClass(a,"selectr-option")}))&&!e.hasClass(a,"disabled")&&(e.hasClass(a,"selected")?(b.el.multiple||!b.el.multiple&&b.config.allowDeselect)&&b.deselect(a.idx):b.select(a.idx),b.opened&&!b.el.multiple&&b.close())});
this.tree.addEventListener("mouseover",function(a){e.hasClass(a.target,"selectr-option")&&!e.hasClass(a.target,"disabled")&&(e.removeClass(b.items[b.navIndex],"active"),e.addClass(a.target,"active"),b.navIndex=[].slice.call(b.items).indexOf(a.target))});this.config.searchable&&(this.input.addEventListener("focus",function(a){b.searching=!0}),this.input.addEventListener("blur",function(a){b.searching=!1}),this.input.addEventListener("keyup",function(a){b.search();b.config.taggable||(this.value.length?
e.addClass(this.parentNode,"active"):e.removeClass(this.parentNode,"active"))}),this.inputClear.addEventListener("click",function(a){b.input.value=null;J.call(b);b.tree.childElementCount||A.call(b)}));this.config.taggable&&this.input.addEventListener("keyup",function(a){b.search();if(b.config.taggable&&this.value.length){var c=this.value.trim();if(13===a.which||e.includes(b.tagSeperators,a.key))e.each(b.tagSeperators,function(a,b){c=c.replace(b,"")}),b.add({value:c,text:c,selected:!0},!0)?(b.close(),
J.call(b)):(this.value="",b.setMessage("That tag is already in use."))}});this.update=e.debounce(function(){b.opened&&b.config.closeOnScroll&&b.close();b.width&&(b.container.style.width=b.width);b.invert()},50);this.requiresPagination&&(this.paginateItems=e.debounce(function(){G.call(this)},50),this.tree.addEventListener("scroll",this.paginateItems.bind(this)));document.addEventListener("click",this.events.dismiss);window.addEventListener("keydown",this.events.navigate);window.addEventListener("resize",
this.update);window.addEventListener("scroll",this.update);this.el.form&&this.el.form.addEventListener("reset",this.events.reset)};v.prototype.setSelected=function(b){this.config.data||this.el.multiple||!this.el.options.length||(0!==this.el.selectedIndex||this.el.options[0].defaultSelected||this.config.defaultSelected||(this.el.selectedIndex=-1),this.selectedIndex=this.el.selectedIndex,-1<this.selectedIndex&&this.select(this.selectedIndex));this.config.multiple&&"select-one"===this.originalType&&
!this.config.data&&this.el.options[0].selected&&!this.el.options[0].defaultSelected&&(this.el.options[0].selected=!1);e.each(this.options,function(a,c){c.selected&&c.defaultSelected&&this.select(c.idx)},this);this.config.selectedValue&&this.setValue(this.config.selectedValue);if(this.config.data){!this.el.multiple&&this.config.defaultSelected&&0>this.el.selectedIndex&&this.select(0);var g=0;e.each(this.config.data,function(a,c){n(c,"children")?e.each(c.children,function(a,c){c.hasOwnProperty("selected")&&
!0===c.selected&&this.select(g);g++},this):(c.hasOwnProperty("selected")&&!0===c.selected&&this.select(g),g++)},this)}};v.prototype.destroy=function(){this.rendered&&(this.emit("selectr.destroy"),"select-one"===this.originalType&&(this.el.multiple=!1),this.config.data&&(this.el.textContent=""),e.removeClass(this.el,"selectr-hidden"),this.el.form&&e.off(this.el.form,"reset",this.events.reset),e.off(document,"click",this.events.dismiss),e.off(document,"keydown",this.events.navigate),e.off(window,"resize",
this.update),e.off(window,"scroll",this.update),this.container.parentNode.replaceChild(this.el,this.container),this.rendered=!1)};v.prototype.change=function(b){var g=this.items[b],a=this.options[b];a.disabled||(a.selected&&e.hasClass(g,"selected")?this.deselect(b):this.select(b),this.opened&&!this.el.multiple&&this.close())};v.prototype.select=function(b){var g=this.items[b],a=[].slice.call(this.el.options),c=this.options[b];if(this.el.multiple){if(e.includes(this.selectedIndexes,b))return!1;if(this.config.maxSelections&&
this.tags.length===this.config.maxSelections)return this.setMessage("A maximum of "+this.config.maxSelections+" items can be selected.",!0),!1;this.selectedValues.push(c.value);this.selectedIndexes.push(b);t.call(this,g)}else{var h=this.data?this.data[b]:c;this.label.textContent=this.customSelected?this.config.renderSelection(h):c.textContent;this.selectedValue=c.value;this.selectedIndex=b;e.each(this.options,function(a,c){var h=this.items[a];a!==b&&(h&&e.removeClass(h,"selected"),c.selected=!1,c.removeAttribute("selected"))},
this)}e.includes(a,c)||this.el.add(c);g.setAttribute("aria-selected",!0);e.addClass(g,"selected");e.addClass(this.container,"has-selected");c.selected=!0;c.setAttribute("selected","");this.emit("selectr.change",c);this.emit("selectr.select",c)};v.prototype.deselect=function(b,g){var a=this.items[b],c=this.options[b];if(this.el.multiple)g=this.selectedIndexes.indexOf(b),this.selectedIndexes.splice(g,1),g=this.selectedValues.indexOf(c.value),this.selectedValues.splice(g,1),D.call(this,a),this.tags.length||
e.removeClass(this.container,"has-selected");else{if(!g&&!this.config.clearable&&!this.config.allowDeselect)return!1;this.label.textContent="";this.selectedValue=null;this.el.selectedIndex=this.selectedIndex=-1;e.removeClass(this.container,"has-selected")}this.items[b].setAttribute("aria-selected",!1);e.removeClass(this.items[b],"selected");c.selected=!1;c.removeAttribute("selected");this.emit("selectr.change",null);this.emit("selectr.deselect",c)};v.prototype.setValue=function(b){var g=Array.isArray(b);
g||(b=b.toString().trim());if(!this.el.multiple&&g)return!1;e.each(this.options,function(a,c){(g&&e.includes(b.toString(),c.value)||c.value===b)&&this.change(c.idx)},this)};v.prototype.getValue=function(b,g){if(this.el.multiple)if(b){if(this.selectedIndexes.length){var a={values:[]};e.each(this.selectedIndexes,function(c,b){b=this.options[b];a.values[c]={value:b.value,text:b.textContent}},this)}}else a=this.selectedValues.slice();else if(b){var c=this.options[this.selectedIndex];a={value:c.value,
text:c.textContent}}else a=this.selectedValue;b&&g&&(a=JSON.stringify(a));return a};v.prototype.add=function(b,g){if(b){this.data=this.data||[];this.items=this.items||[];this.options=this.options||[];if(Array.isArray(b))e.each(b,function(a,c){this.add(c,g)},this);else if("[object Object]"===Object.prototype.toString.call(b)){if(g){var a=!1;e.each(this.options,function(c,g){g.value.toLowerCase()===b.value.toLowerCase()&&(a=!0)});if(a)return!1}var c=e.createElement("option",b);this.data.push(b);this.options.push(c);
c.idx=0<this.options.length?this.options.length-1:0;l.call(this,c);b.selected&&this.select(c.idx);return c}this.setPlaceholder();this.config.pagination&&this.paginate();return!0}};v.prototype.remove=function(b){var g=[];Array.isArray(b)?e.each(b,function(a,h){e.isInt(h)?g.push(this.getOptionByIndex(h)):"string"===typeof b&&g.push(this.getOptionByValue(h))},this):e.isInt(b)?g.push(this.getOptionByIndex(b)):"string"===typeof b&&g.push(this.getOptionByValue(b));if(g.length){var a;e.each(g,function(c,
b){a=b.idx;this.el.remove(b);this.options.splice(a,1);(c=this.items[a].parentNode)&&c.removeChild(this.items[a]);this.items.splice(a,1);e.each(this.options,function(a,c){c.idx=a;this.items[a].idx=a},this)},this);this.setPlaceholder();this.config.pagination&&this.paginate()}};v.prototype.removeAll=function(){this.clear(!0);e.each(this.el.options,function(b,g){this.el.remove(g)},this);e.truncate(this.tree);this.items=[];this.options=[];this.data=[];this.navIndex=0;this.requiresPagination&&(this.requiresPagination=
!1,this.pageIndex=1,this.pages=[]);this.setPlaceholder()};v.prototype.search=function(b){if(!this.navigating){b=b||this.input.value;var g=document.createDocumentFragment();this.removeMessage();e.truncate(this.tree);if(1<b.length)if(e.each(this.options,function(a,h){a=this.items[h.idx];if(e.includes(h.textContent.toLowerCase(),b.toLowerCase())&&!h.disabled){if(d(a,g,this.customOption),e.removeClass(a,"excluded"),!this.customOption){a.textContent="";h=h.textContent;var c=(new RegExp(b,"i")).exec(h);
if(c){var M=c.index;c=c.index+c[0].length;h={before:h.substring(0,M),match:h.substring(M,c),after:h.substring(c)}}else h=null;h&&(a.appendChild(document.createTextNode(h.before)),M=document.createElement("span"),M.className="selectr-match",M.appendChild(document.createTextNode(h.match)),a.appendChild(M),a.appendChild(document.createTextNode(h.after)))}}else e.addClass(a,"excluded")},this),g.childElementCount){var a=g.firstElementChild;e.removeClass(this.items[this.navIndex],"active");this.navIndex=
a.idx;e.addClass(a,"active")}else this.config.taggable||this.setMessage("no results.");else A.call(this);this.tree.appendChild(g)}};v.prototype.toggle=function(){this.disabled||(this.opened?this.close():this.open())};v.prototype.open=function(){var b=this;if(!this.options.length)return!1;this.opened||this.emit("selectr.open");this.opened=!0;this.mobileDevice||this.config.nativeDropdown?(e.addClass(this.container,"native-open"),this.config.data&&e.each(this.options,function(b,a){this.el.add(a)},this)):
(e.addClass(this.container,"open"),A.call(this),this.invert(),this.tree.scrollTop=0,e.removeClass(this.container,"notice"),this.selected.setAttribute("aria-expanded",!0),this.tree.setAttribute("aria-hidden",!1),this.tree.setAttribute("aria-expanded",!0),this.config.searchable&&!this.config.taggable&&setTimeout(function(){b.input.focus();b.input.tabIndex=0},10))};v.prototype.close=function(){this.opened&&this.emit("selectr.close");this.opened=!1;if(this.mobileDevice||this.config.nativeDropdown)e.removeClass(this.container,
"native-open");else{var b=e.hasClass(this.container,"notice");this.config.searchable&&!b&&(this.input.blur(),this.input.tabIndex=-1,this.searching=!1);b&&(e.removeClass(this.container,"notice"),this.notice.textContent="");e.removeClass(this.container,"open");e.removeClass(this.container,"native-open");this.selected.setAttribute("aria-expanded",!1);this.tree.setAttribute("aria-hidden",!0);this.tree.setAttribute("aria-expanded",!1);e.truncate(this.tree);J.call(this)}};v.prototype.enable=function(){this.disabled=
!1;this.el.disabled=!1;this.selected.tabIndex=this.originalIndex;this.el.multiple&&e.each(this.tags,function(b,g){g.lastElementChild.tabIndex=0});e.removeClass(this.container,"selectr-disabled")};v.prototype.disable=function(b){b||(this.el.disabled=!0);this.selected.tabIndex=-1;this.el.multiple&&e.each(this.tags,function(b,a){a.lastElementChild.tabIndex=-1});this.disabled=!0;e.addClass(this.container,"selectr-disabled")};v.prototype.reset=function(){this.disabled||(this.clear(),this.setSelected(!0),
e.each(this.defaultSelected,function(b,g){this.select(g)},this),this.emit("selectr.reset"))};v.prototype.clear=function(b){this.el.multiple?this.selectedIndexes.length&&(b=this.selectedIndexes.slice(),e.each(b,function(b,a){this.deselect(a)},this)):-1<this.selectedIndex&&this.deselect(this.selectedIndex,b);this.emit("selectr.clear")};v.prototype.serialise=function(b){var g=[];e.each(this.options,function(a,c){var b={value:c.value,text:c.textContent};c.selected&&(b.selected=!0);c.disabled&&(b.disabled=
!0);g[a]=b});return b?JSON.stringify(g):g};v.prototype.serialize=function(b){return this.serialise(b)};v.prototype.setPlaceholder=function(b){b=b||this.config.placeholder||this.el.getAttribute("placeholder");this.options.length||(b="No options available");this.placeEl.textContent=b};v.prototype.paginate=function(){if(this.items.length){var b=this;return this.pages=this.items.map(function(g,a){return 0===a%b.config.pagination?b.items.slice(a,a+b.config.pagination):null}).filter(function(b){return b})}};
v.prototype.setMessage=function(b,g){g&&this.close();e.addClass(this.container,"notice");this.notice.textContent=b};v.prototype.removeMessage=function(){e.removeClass(this.container,"notice");this.notice.textContent=""};v.prototype.invert=function(){var b=e.rect(this.selected);b.top+b.height+this.tree.parentNode.offsetHeight>window.innerHeight?(e.addClass(this.container,"inverted"),this.isInverted=!0):(e.removeClass(this.container,"inverted"),this.isInverted=!1);this.optsRect=e.rect(this.tree)};v.prototype.getOptionByIndex=
function(b){return this.options[b]};v.prototype.getOptionByValue=function(b){for(var g=!1,a=0,c=this.options.length;a<c;a++)if(this.options[a].value.trim()===b.toString().trim()){g=this.options[a];break}return g};w.exports=v},188:function(w,n,d){d.d(n,{qD:function(){return r},EX:function(){return x},WF:function(){return e},oW:function(){return A}});var r=document.body,x=10485760,e=2E4,A=2147483648},602:function(w,n,d){function r(d,n,p){function e(){if(v&&v.parentNode){v.parentNode.removeChild(v);
for(var b in D)if(Object.prototype.hasOwnProperty.call(D,b)){var a=D[b];a&&(0,x.removeEventListener)(t,b,a);delete D[b]}"function"===typeof p&&p(d)}}function r(b){b=b.target;b!==v&&!(0,x.isChildOf)(b,v)&&e()}var w=3<arguments.length&&void 0!==arguments[3]?arguments[3]:!1,t="function"===typeof d.getRootNode?d.getRootNode():window,D={},A=d.getBoundingClientRect(),J=n.getBoundingClientRect(),v=document.createElement("div");v.className="jsoneditor-anchor";v.style.position="absolute";v.style.left=A.left-
J.left+"px";v.style.top=A.top-J.top+"px";v.style.width=A.width-2+"px";v.style.height=A.height-2+"px";v.style.boxSizing="border-box";n.appendChild(v);D.mousedown=(0,x.addEventListener)(t,"mousedown",r);D.mousewheel=(0,x.addEventListener)(t,"mousewheel",r);if(w){var b=null;v.onmouseover=function(){clearTimeout(b);b=null};v.onmouseout=function(){b||(b=setTimeout(e,200))}}v.destroy=e;return v}d.d(n,{w:function(){return r}});var x=d(791)},907:function(w,n,d){function r(d){if(d){var e=A.find(function(e){return e===
d});e?F=e:console.error("Language not found")}}function x(d){if(d){var e=function(e){A.find(function(d){return d===e})||A.push(e);p[e]=Object.assign({},p[l],p[e],d[e])},t;for(t in d)e(t)}}function e(d,e,n){n||(n=F);d=p[n][d]||p[l][d]||d;if(e)for(var t in e)d=d.replace("${"+t+"}",e[t]);return d}d.d(n,{m0:function(){return r},cC:function(){return x},Iu:function(){return e}});w=d(987);d.n(w);var A="en pt-BR zh-CN tr ja fr-FR de ru".split(" "),p={en:{array:"Array",auto:"Auto",appendText:"Append",appendTitle:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",
appendSubmenuTitle:"Select the type of the field to be appended",appendTitleAuto:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascending",ascendingTitle:"Sort the childs of this ${type} in ascending order",actionsMenu:"Click to open the actions menu (Ctrl+M)",cannotParseFieldError:"Cannot parse field into JSON",cannotParseValueError:"Cannot parse value into JSON",collapseAll:"Collapse all fields",compactTitle:"Compact JSON data, remove all whitespaces (Ctrl+Shift+I)",descending:"Descending",
descendingTitle:"Sort the childs of this ${type} in descending order",drag:"Drag to move this field (Alt+Shift+Arrows)",duplicateKey:"duplicate key",duplicateText:"Duplicate",duplicateTitle:"Duplicate selected fields (Ctrl+D)",duplicateField:"Duplicate this field (Ctrl+D)",duplicateFieldError:"Duplicate field name",empty:"empty",expandAll:"Expand all fields",expandTitle:"Click to expand/collapse this field (Ctrl+E). \nCtrl+Click to expand/collapse including all childs.",formatTitle:"Format JSON data, with proper indentation and line feeds (Ctrl+I)",
insert:"Insert",insertTitle:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",insertSub:"Select the type of the field to be inserted",object:"Object",ok:"Ok",redo:"Redo (Ctrl+Shift+Z)",removeText:"Remove",removeTitle:"Remove selected fields (Ctrl+Del)",removeField:"Remove this field (Ctrl+Del)",repairTitle:"Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",searchTitle:"Search fields and values",searchNextResultTitle:"Next result (Enter)",
searchPreviousResultTitle:"Previous result (Shift + Enter)",selectNode:"Select a node...",showAll:"show all",showMore:"show more",showMoreStatus:"displaying ${visibleChilds} of ${totalChilds} items.",sort:"Sort",sortTitle:"Sort the childs of this ${type}",sortTitleShort:"Sort contents",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",
sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"String",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",extract:"Extract",extractTitle:"Extract this ${type}",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",
transformPreviewLabel:"Preview",type:"Type",typeTitle:"Change the type of this field",openUrl:"Ctrl+Click or Ctrl+Enter to open url in new window",undo:"Undo last action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Field type "object". An object contains an unordered set of key/value pairs.',arrayType:'Field type "array". An array contains an ordered collection of values.',
stringType:'Field type "string". Field type is not determined from the value, but always returned as string.',modeEditorTitle:"Switch Editor Mode",modeCodeText:"Code",modeCodeTitle:"Switch to code highlighter",modeFormText:"Form",modeFormTitle:"Switch to form editor",modeTextText:"Text",modeTextTitle:"Switch to plain text editor",modeTreeText:"Tree",modeTreeTitle:"Switch to tree editor",modeViewText:"View",modeViewTitle:"Switch to tree view",modePreviewText:"Preview",modePreviewTitle:"Switch to preview mode",
examples:"Examples","default":"Default",containsInvalidProperties:"Contains invalid properties",containsInvalidItems:"Contains invalid items"},"zh-CN":{array:"\u6570\u7ec4",auto:"\u81ea\u52a8",appendText:"\u8ffd\u52a0",appendTitle:"\u5728\u6b64\u5b57\u6bb5\u540e\u8ffd\u52a0\u4e00\u4e2a\u7c7b\u578b\u4e3a\u201cauto\u201d\u7684\u65b0\u5b57\u6bb5 (Ctrl+Shift+Ins)",appendSubmenuTitle:"\u9009\u62e9\u8981\u8ffd\u52a0\u7684\u5b57\u6bb5\u7c7b\u578b",appendTitleAuto:"\u8ffd\u52a0\u7c7b\u578b\u4e3a\u201cauto\u201d\u7684\u65b0\u5b57\u6bb5 (Ctrl+Shift+Ins)",
ascending:"\u5347\u5e8f",ascendingTitle:"\u5347\u5e8f\u6392\u5217${type}\u7684\u5b50\u8282\u70b9",actionsMenu:"\u70b9\u51fb\u6253\u5f00\u52a8\u4f5c\u83dc\u5355(Ctrl+M)",cannotParseFieldError:"\u65e0\u6cd5\u5c06\u5b57\u6bb5\u89e3\u6790\u4e3aJSON",cannotParseValueError:"\u65e0\u6cd5\u5c06\u503c\u89e3\u6790\u4e3aJSON",collapseAll:"\u7f29\u8fdb\u6240\u6709\u5b57\u6bb5",compactTitle:"\u538b\u7f29JSON\u6570\u636e\uff0c\u5220\u9664\u6240\u6709\u7a7a\u683c (Ctrl+Shift+I)",descending:"\u964d\u5e8f",descendingTitle:"\u964d\u5e8f\u6392\u5217${type}\u7684\u5b50\u8282\u70b9",
drag:"\u62d6\u62fd\u79fb\u52a8\u8be5\u8282\u70b9(Alt+Shift+Arrows)",duplicateKey:"\u91cd\u590d\u952e",duplicateText:"\u590d\u5236",duplicateTitle:"\u590d\u5236\u9009\u4e2d\u5b57\u6bb5(Ctrl+D)",duplicateField:"\u590d\u5236\u8be5\u5b57\u6bb5(Ctrl+D)",duplicateFieldError:"\u91cd\u590d\u7684\u5b57\u6bb5\u540d\u79f0",empty:"\u6e05\u7a7a",expandAll:"\u5c55\u5f00\u6240\u6709\u5b57\u6bb5",expandTitle:"\u70b9\u51fb \u5c55\u5f00/\u6536\u7f29 \u8be5\u5b57\u6bb5(Ctrl+E). \nCtrl+Click \u5c55\u5f00/\u6536\u7f29 \u5305\u542b\u6240\u6709\u5b50\u8282\u70b9.",
formatTitle:"\u4f7f\u7528\u9002\u5f53\u7684\u7f29\u8fdb\u548c\u6362\u884c\u7b26\u683c\u5f0f\u5316JSON\u6570\u636e (Ctrl+I)",insert:"\u63d2\u5165",insertTitle:"\u5728\u6b64\u5b57\u6bb5\u524d\u63d2\u5165\u7c7b\u578b\u4e3a\u201cauto\u201d\u7684\u65b0\u5b57\u6bb5 (Ctrl+Ins)",insertSub:"\u9009\u62e9\u8981\u63d2\u5165\u7684\u5b57\u6bb5\u7c7b\u578b",object:"\u5bf9\u8c61",ok:"Ok",redo:"\u91cd\u505a (Ctrl+Shift+Z)",removeText:"\u79fb\u9664",removeTitle:"\u79fb\u9664\u9009\u4e2d\u5b57\u6bb5 (Ctrl+Del)",removeField:"\u79fb\u9664\u8be5\u5b57\u6bb5 (Ctrl+Del)",
repairTitle:"\u4fee\u590dJSON\uff1a\u4fee\u590d\u5f15\u53f7\u548c\u8f6c\u4e49\u7b26\uff0c\u5220\u9664\u6ce8\u91ca\u548cJSONP\u8868\u793a\u6cd5\uff0c\u5c06JavaScript\u5bf9\u8c61\u8f6c\u6362\u4e3aJSON\u3002",selectNode:"\u9009\u62e9\u4e00\u4e2a\u8282\u70b9...",showAll:"\u5c55\u793a\u5168\u90e8",showMore:"\u5c55\u793a\u66f4\u591a",showMoreStatus:"\u663e\u793a${totalChilds}\u7684${visibleChilds}\u9879\u76ee.",sort:"\u6392\u5e8f",sortTitle:"\u6392\u5e8f${type}\u7684\u5b50\u8282\u70b9",sortTitleShort:"\u5185\u5bb9\u6392\u5e8f",
sortFieldLabel:"\u5b57\u6bb5\uff1a",sortDirectionLabel:"\u65b9\u5411\uff1a",sortFieldTitle:"\u9009\u62e9\u7528\u4e8e\u5bf9\u6570\u7ec4\u6216\u5bf9\u8c61\u6392\u5e8f\u7684\u5d4c\u5957\u5b57\u6bb5",sortAscending:"\u5347\u5e8f\u6392\u5e8f",sortAscendingTitle:"\u6309\u7167\u8be5\u5b57\u6bb5\u5347\u5e8f\u6392\u5e8f",sortDescending:"\u964d\u5e8f\u6392\u5e8f",sortDescendingTitle:"\u6309\u7167\u8be5\u5b57\u6bb5\u964d\u5e8f\u6392\u5e8f",string:"\u5b57\u7b26\u4e32",transform:"\u53d8\u6362",transformTitle:"\u7b5b\u9009\uff0c\u6392\u5e8f\uff0c\u6216\u8005\u8f6c\u6362${type}\u7684\u5b50\u8282\u70b9",
transformTitleShort:"\u7b5b\u9009\uff0c\u6392\u5e8f\uff0c\u6216\u8005\u8f6c\u6362\u5185\u5bb9",extract:"\u63d0\u53d6",extractTitle:"\u63d0\u53d6\u8fd9\u4e2a ${type}",transformQueryTitle:"\u8f93\u5165JMESPath\u67e5\u8be2",transformWizardLabel:"\u5411\u5bfc",transformWizardFilter:"\u7b5b\u9009",transformWizardSortBy:"\u6392\u5e8f",transformWizardSelectFields:"\u9009\u62e9\u5b57\u6bb5",transformQueryLabel:"\u67e5\u8be2",transformPreviewLabel:"\u9884\u89c8",type:"\u7c7b\u578b",typeTitle:"\u66f4\u6539\u5b57\u6bb5\u7c7b\u578b",
openUrl:"Ctrl+Click \u6216\u8005 Ctrl+Enter \u5728\u65b0\u7a97\u53e3\u6253\u5f00\u94fe\u63a5",undo:"\u64a4\u9500\u4e0a\u6b21\u52a8\u4f5c (Ctrl+Z)",validationCannotMove:"\u65e0\u6cd5\u5c06\u5b57\u6bb5\u79fb\u5165\u5176\u5b50\u8282\u70b9",autoType:'\u5b57\u6bb5\u7c7b\u578b "auto". \u5b57\u6bb5\u7c7b\u578b\u7531\u503c\u81ea\u52a8\u786e\u5b9a \u53ef\u4ee5\u4e3a string\uff0cnumber\uff0cboolean\uff0c\u6216\u8005 null.',objectType:'\u5b57\u6bb5\u7c7b\u578b "object". \u5bf9\u8c61\u5305\u542b\u4e00\u7ec4\u65e0\u5e8f\u7684\u952e/\u503c\u5bf9.',
arrayType:'\u5b57\u6bb5\u7c7b\u578b "array". \u6570\u7ec4\u5305\u542b\u503c\u7684\u6709\u5e8f\u96c6\u5408.',stringType:'\u5b57\u6bb5\u7c7b\u578b "string". \u5b57\u6bb5\u7c7b\u578b\u7531\u503c\u81ea\u52a8\u786e\u5b9a\uff0c\u4f46\u59cb\u7ec8\u4f5c\u4e3a\u5b57\u7b26\u4e32\u8fd4\u56de.',modeCodeText:"\u4ee3\u7801",modeCodeTitle:"\u5207\u6362\u81f3\u4ee3\u7801\u9ad8\u4eae",modeFormText:"\u8868\u5355",modeFormTitle:"\u5207\u6362\u81f3\u8868\u5355\u7f16\u8f91",modeTextText:"\u6587\u672c",modeTextTitle:"\u5207\u6362\u81f3\u6587\u672c\u7f16\u8f91",
modeTreeText:"\u6811",modeTreeTitle:"\u5207\u6362\u81f3\u6811\u7f16\u8f91",modeViewText:"\u89c6\u56fe",modeViewTitle:"\u5207\u6362\u81f3\u6811\u89c6\u56fe",modePreviewText:"\u9884\u89c8",modePreviewTitle:"\u5207\u6362\u81f3\u9884\u89c8\u6a21\u5f0f",examples:"\u4f8b\u5b50","default":"\u7f3a\u7701",containsInvalidProperties:"\u5305\u542b\u65e0\u6548\u7684\u5c5e\u6027",containsInvalidItems:"\u5305\u542b\u65e0\u6548\u9879\u76ee"},"pt-BR":{array:"Lista",auto:"Automatico",appendText:"Adicionar",appendTitle:"Adicionar novo campo com tipo 'auto' depois deste campo (Ctrl+Shift+Ins)",
appendSubmenuTitle:"Selecione o tipo do campo a ser adicionado",appendTitleAuto:"Adicionar novo campo com tipo 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendente",ascendingTitle:"Organizar filhor do tipo ${type} em crescente",actionsMenu:"Clique para abrir o menu de a\u00e7\u00f5es (Ctrl+M)",cannotParseFieldError:"N\u00e3o \u00e9 poss\u00edvel analisar o campo no JSON",cannotParseValueError:"N\u00e3o \u00e9 poss\u00edvel analisar o valor em JSON",collapseAll:"Fechar todos campos",compactTitle:"Dados JSON compactos, remova todos os espa\u00e7os em branco (Ctrl+Shift+I)",
descending:"Descendente",descendingTitle:"Organizar o filhos do tipo ${type} em decrescente",duplicateKey:"chave duplicada",drag:"Arraste para mover este campo (Alt+Shift+Arrows)",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos selecionados (Ctrl+D)",duplicateField:"Duplicar este campo (Ctrl+D)",duplicateFieldError:"Nome do campo duplicado",empty:"vazio",expandAll:"Expandir todos campos",expandTitle:"Clique para expandir/encolher este campo (Ctrl+E). \nCtrl+Click para expandir/encolher incluindo todos os filhos.",
formatTitle:"Formate dados JSON, com recuo e feeds de linha adequados (Ctrl+I)",insert:"Inserir",insertTitle:"Inserir um novo campo do tipo 'auto' antes deste campo (Ctrl+Ins)",insertSub:"Selecionar o tipo de campo a ser inserido",object:"Objeto",ok:"Ok",redo:"Refazer (Ctrl+Shift+Z)",removeText:"Remover",removeTitle:"Remover campos selecionados (Ctrl+Del)",removeField:"Remover este campo (Ctrl+Del)",repairTitle:"Repare JSON: corrija aspas e caracteres de escape, remova coment\u00e1rios e nota\u00e7\u00e3o JSONP, transforme objetos JavaScript em JSON.",
selectNode:"Selecione um n\u00f3dulo...",showAll:"mostrar todos",showMore:"mostrar mais",showMoreStatus:"exibindo ${visibleChilds} de ${totalChilds} itens.",sort:"Organizar",sortTitle:"Organizar os filhos deste ${type}",sortTitleShort:"Organizar os filhos",sortFieldLabel:"Campo:",sortDirectionLabel:"Dire\u00e7\u00e3o:",sortFieldTitle:"Selecione um campo filho pelo qual ordenar o array ou objeto",sortAscending:"Ascendente",sortAscendingTitle:"Ordenar o campo selecionado por ordem ascendente",sortDescending:"Descendente",
sortDescendingTitle:"Ordenar o campo selecionado por ordem descendente",string:"Texto",transform:"Transformar",transformTitle:"Filtrar, ordenar ou transformar os filhos deste ${type}",transformTitleShort:"Filtrar, ordenar ou transformar conte\u00fados",transformQueryTitle:"Insira uma express\u00e3o JMESPath",transformWizardLabel:"Assistente",transformWizardFilter:"Filtro",transformWizardSortBy:"Ordenar por",transformWizardSelectFields:"Selecionar campos",transformQueryLabel:"Express\u00e3o",transformPreviewLabel:"Visualizar",
type:"Tipo",typeTitle:"Mudar o tipo deste campo",openUrl:"Ctrl+Click ou Ctrl+Enter para abrir link em nova janela",undo:"Desfazer \u00faltimo a\u00e7\u00e3o (Ctrl+Z)",validationCannotMove:"N\u00e3o pode mover um campo como filho dele mesmo",autoType:'Campo do tipo "auto". O tipo do campo \u00e9 determinao automaticamente a partir do seu valor e pode ser texto, n\u00famero, verdade/falso ou nulo.',objectType:'Campo do tipo "objeto". Um objeto cont\u00e9m uma lista de pares com chave e valor.',arrayType:'Campo do tipo "lista". Uma lista contem uma cole\u00e7\u00e3o de valores ordenados.',
stringType:'Campo do tipo "string". Campo do tipo nao \u00e9 determinado atrav\u00e9s do seu valor, mas sempre retornara um texto.',examples:"Exemplos","default":"Revelia",containsInvalidProperties:"Cont\u00e9m propriedades inv\u00e1lidas",containsInvalidItems:"Cont\u00e9m itens inv\u00e1lidos"},tr:{array:"Dizin",auto:"Otomatik",appendText:"Ekle",appendTitle:"Bu alan\u0131n alt\u0131na 'otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",appendSubmenuTitle:"Eklenecek alan\u0131n tipini se\u00e7",
appendTitleAuto:"'Otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",ascending:"Artan",ascendingTitle:"${type}'\u0131n alt tiplerini artan d\u00fczende s\u0131rala",actionsMenu:"Aksiyon men\u00fcs\u00fcn\u00fc a\u00e7mak i\u00e7in t\u0131klay\u0131n (Ctrl+M)",collapseAll:"T\u00fcm alanlar\u0131 kapat",descending:"Azalan",descendingTitle:"${type}'\u0131n alt tiplerini azalan d\u00fczende s\u0131rala",drag:"Bu alan\u0131 ta\u015f\u0131mak i\u00e7in s\u00fcr\u00fckleyin (Alt+Shift+Arrows)",duplicateKey:"Var olan anahtar",
duplicateText:"A\u015fa\u011f\u0131ya kopyala",duplicateTitle:"Se\u00e7ili alanlardan bir daha olu\u015ftur (Ctrl+D)",duplicateField:"Bu alandan bir daha olu\u015ftur (Ctrl+D)",duplicateFieldError:"Duplicate field name",cannotParseFieldError:"Alan JSON'a ayr\u0131\u015ft\u0131r\u0131lam\u0131yor",cannotParseValueError:"JSON'a de\u011fer ayr\u0131\u015ft\u0131r\u0131lam\u0131yor",empty:"bo\u015f",expandAll:"T\u00fcm alanlar\u0131 a\u00e7",expandTitle:"Bu alan\u0131 a\u00e7mak/kapatmak i\u00e7in t\u0131kla (Ctrl+E). \nAlt alanlarda dahil t\u00fcm alanlar\u0131 a\u00e7mak i\u00e7in Ctrl+Click ",
insert:"Ekle",insertTitle:"Bu alan\u0131n \u00fcst\u00fcne 'otomatik' tipinde yeni bir alan ekle (Ctrl+Ins)",insertSub:"Araya eklenecek alan\u0131n tipini se\u00e7",object:"Nesne",ok:"Tamam",redo:"Yeniden yap (Ctrl+Shift+Z)",removeText:"Kald\u0131r",removeTitle:"Se\u00e7ilen alanlar\u0131 kald\u0131r (Ctrl+Del)",removeField:"Bu alan\u0131 kald\u0131r (Ctrl+Del)",selectNode:"Bir nesne se\u00e7...",showAll:"t\u00fcm\u00fcn\u00fc g\u00f6ster",showMore:"daha fazla g\u00f6ster",showMoreStatus:"${totalChilds} alan\u0131n ${visibleChilds} alt alanlar\u0131 g\u00f6steriliyor",
sort:"S\u0131rala",sortTitle:"${type}'\u0131n alt alanlar\u0131n\u0131 s\u0131rala",sortTitleShort:"\u0130\u00e7erikleri s\u0131rala",sortFieldLabel:"Alan:",sortDirectionLabel:"Y\u00f6n:",sortFieldTitle:"Diziyi veya nesneyi s\u0131ralamak i\u00e7in i\u00e7 i\u00e7e ge\u00e7mi\u015f alan\u0131 se\u00e7in",sortAscending:"Artan",sortAscendingTitle:"Se\u00e7ili alan\u0131 artan d\u00fczende s\u0131rala",sortDescending:"Azalan",sortDescendingTitle:"Se\u00e7ili alan\u0131 azalan d\u00fczende s\u0131rala",
string:"Karakter Dizisi",transform:"D\u00f6n\u00fc\u015ft\u00fcr",transformTitle:"${type}'\u0131n alt alanlar\u0131n\u0131 filtrele, s\u0131rala veya d\u00f6n\u00fc\u015ft\u00fcr",transformTitleShort:"\u0130\u00e7erikleri filterele, s\u0131rala veya d\u00f6n\u00fc\u015ft\u00fcr",transformQueryTitle:"JMESPath sorgusu gir",transformWizardLabel:"Sihirbaz",transformWizardFilter:"Filtre",transformWizardSortBy:"S\u0131rala",transformWizardSelectFields:"Alanlar\u0131 se\u00e7",transformQueryLabel:"Sorgu",
transformPreviewLabel:"\u00d6nizleme",type:"Tip",typeTitle:"Bu alan\u0131n tipini de\u011fi\u015ftir",openUrl:"URL'i yeni bir pencerede a\u00e7mak i\u00e7in Ctrl+Click veya Ctrl+Enter",undo:"Son de\u011fi\u015fikli\u011fi geri al (Ctrl+Z)",validationCannotMove:"Alt alan olarak ta\u015f\u0131nam\u0131yor",autoType:'Alan tipi "otomatik". Alan t\u00fcr\u00fc otomatik olarak de\u011ferden belirlenirve bir dize, say\u0131, boolean veya null olabilir.',objectType:'Alan tipi "nesne". Bir nesne, s\u0131ralanmam\u0131\u015f bir anahtar / de\u011fer \u00e7ifti k\u00fcmesi i\u00e7erir.',
arrayType:'Alan tipi "dizi". Bir dizi, d\u00fczenli de\u011ferler koleksiyonu i\u00e7erir.',stringType:'Alan tipi "karakter dizisi". Alan t\u00fcr\u00fc de\u011ferden belirlenmez,ancak her zaman karakter dizisi olarak d\u00f6nd\u00fcr\u00fcl\u00fcr.',modeCodeText:"Kod",modeCodeTitle:"Kod vurgulay\u0131c\u0131ya ge\u00e7",modeFormText:"Form",modeFormTitle:"Form d\u00fczenleyiciye ge\u00e7",modeTextText:"Metin",modeTextTitle:"D\u00fcz metin d\u00fczenleyiciye ge\u00e7",modeTreeText:"A\u011fa\u00e7",
modeTreeTitle:"A\u011fa\u00e7 d\u00fczenleyiciye ge\u00e7",modeViewText:"G\u00f6r\u00fcn\u00fcm",modeViewTitle:"A\u011fa\u00e7 g\u00f6r\u00fcn\u00fcm\u00fcne ge\u00e7",examples:"\u00d6rnekler","default":"Varsay\u0131lan",containsInvalidProperties:"Ge\u00e7ersiz \u00f6zellikler i\u00e7eriyor",containsInvalidItems:"Ge\u00e7ersiz \u00f6\u011feler i\u00e7eriyor"},ja:{array:"\u914d\u5217",auto:"\u30aa\u30fc\u30c8",appendText:"\u8ffd\u52a0",appendTitle:'\u6b21\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306b"\u30aa\u30fc\u30c8"\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u8ffd\u52a0 (Ctrl+Shift+Ins)',
appendSubmenuTitle:"\u8ffd\u52a0\u3059\u308b\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u578b\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044",appendTitleAuto:'"\u30aa\u30fc\u30c8"\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u8ffd\u52a0 (Ctrl+Shift+Ins)',ascending:"\u6607\u9806",ascendingTitle:"${type}\u306e\u5b50\u8981\u7d20\u3092\u6607\u9806\u306b\u4e26\u3079\u66ff\u3048",actionsMenu:"\u30af\u30ea\u30c3\u30af\u3057\u3066\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30cb\u30e5\u30fc\u3092\u958b\u304f (Ctrl+M)",
collapseAll:"\u3059\u3079\u3066\u3092\u6298\u308a\u305f\u305f\u3080",descending:"\u964d\u9806",descendingTitle:"${type}\u306e\u5b50\u8981\u7d20\u3092\u964d\u9806\u306b\u4e26\u3079\u66ff\u3048",drag:"\u30c9\u30e9\u30c3\u30b0\u3057\u3066\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u79fb\u52d5 (Alt+Shift+Arrows)",duplicateKey:"\u8907\u88fd\u30ad\u30fc",duplicateText:"\u8907\u88fd",duplicateTitle:"\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u8907\u88fd (Ctrl+D)",duplicateField:"\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u8907\u88fd (Ctrl+D)",
duplicateFieldError:"\u30d5\u30a3\u30fc\u30eb\u30c9\u540d\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059",cannotParseFieldError:"JSON\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u89e3\u6790\u3067\u304d\u307e\u305b\u3093",cannotParseValueError:"JSON\u306e\u5024\u3092\u89e3\u6790\u3067\u304d\u307e\u305b\u3093",empty:"\u7a7a",expandAll:"\u3059\u3079\u3066\u3092\u5c55\u958b",expandTitle:"\u30af\u30ea\u30c3\u30af\u3057\u3066\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u5c55\u958b/\u6298\u308a\u305f\u305f\u3080 (Ctrl+E). \nCtrl+Click \u3067\u3059\u3079\u3066\u306e\u5b50\u8981\u7d20\u3092\u5c55\u958b/\u6298\u308a\u305f\u305f\u3080",
insert:"\u633f\u5165",insertTitle:"\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u524d\u306b\u65b0\u3057\u3044\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u633f\u5165 (Ctrl+Ins)",insertSub:"\u633f\u5165\u3059\u308b\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u578b\u3092\u9078\u629e",object:"\u30aa\u30d6\u30b8\u30a7\u30af\u30c8",ok:"\u5b9f\u884c",redo:"\u3084\u308a\u76f4\u3059 (Ctrl+Shift+Z)",removeText:"\u524a\u9664",removeTitle:"\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u524a\u9664 (Ctrl+Del)",
removeField:"\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u524a\u9664 (Ctrl+Del)",selectNode:"\u30ce\u30fc\u30c9\u3092\u9078\u629e...",showAll:"\u3059\u3079\u3066\u3092\u8868\u793a",showMore:"\u3082\u3063\u3068\u898b\u308b",showMoreStatus:"${totalChilds}\u500b\u306e\u30a2\u30a4\u30c6\u30e0\u306e\u3046\u3061 ${visibleChilds}\u500b\u3092\u8868\u793a\u3057\u3066\u3044\u307e\u3059\u3002",sort:"\u4e26\u3079\u66ff\u3048",sortTitle:"${type}\u306e\u5b50\u8981\u7d20\u3092\u4e26\u3079\u66ff\u3048",
sortTitleShort:"\u4e26\u3079\u66ff\u3048",sortFieldLabel:"\u30d5\u30a3\u30fc\u30eb\u30c9:",sortDirectionLabel:"\u9806\u5e8f:",sortFieldTitle:"\u914d\u5217\u307e\u305f\u306f\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u4e26\u3073\u66ff\u3048\u308b\u305f\u3081\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u9078\u629e",sortAscending:"\u6607\u9806",sortAscendingTitle:"\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u6607\u9806\u306b\u4e26\u3073\u66ff\u3048",sortDescending:"\u964d\u9806",sortDescendingTitle:"\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u964d\u9806\u306b\u4e26\u3073\u66ff\u3048",
string:"\u6587\u5b57\u5217",transform:"\u5909\u63db",transformTitle:"${type}\u306e\u5b50\u8981\u7d20\u3092\u30d5\u30a3\u30eb\u30bf\u30fc\u30fb\u4e26\u3073\u66ff\u3048\u30fb\u5909\u63db\u3059\u308b",transformTitleShort:"\u5185\u5bb9\u3092\u30d5\u30a3\u30eb\u30bf\u30fc\u30fb\u4e26\u3073\u66ff\u3048\u30fb\u5909\u63db\u3059\u308b",extract:"\u62bd\u51fa",extractTitle:"${type}\u3092\u62bd\u51fa",transformQueryTitle:"JMESPath\u30af\u30a8\u30ea\u3092\u5165\u529b",transformWizardLabel:"\u30a6\u30a3\u30b6\u30fc\u30c9",
transformWizardFilter:"\u30d5\u30a3\u30eb\u30bf\u30fc",transformWizardSortBy:"\u4e26\u3073\u66ff\u3048",transformWizardSelectFields:"\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u9078\u629e",transformQueryLabel:"\u30af\u30a8\u30ea",transformPreviewLabel:"\u30d7\u30ec\u30d3\u30e5\u30fc",type:"\u578b",typeTitle:"\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u578b\u3092\u5909\u66f4",openUrl:"Ctrl+Click \u307e\u305f\u306f Ctrl+Enter \u3067 \u65b0\u898f\u30a6\u30a3\u30f3\u30c9\u30a6\u3067URL\u3092\u958b\u304f",
undo:"\u5143\u306b\u623b\u3059 (Ctrl+Z)",validationCannotMove:"\u5b50\u8981\u7d20\u306b\u79fb\u52d5\u3067\u304d\u307e\u305b\u3093 ",autoType:"\u30aa\u30fc\u30c8\uff1a \u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u578b\u306f\u5024\u304b\u3089\u81ea\u52d5\u7684\u306b\u6c7a\u5b9a\u3055\u308c\u307e\u3059\u3002 (\u6587\u5b57\u5217\u30fb\u6570\u5024\u30fb\u30d6\u30fc\u30eb\u30fbnull)",objectType:"\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\uff1a \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u9806\u5e8f\u304c\u6c7a\u307e\u3063\u3066\u3044\u306a\u3044\u30ad\u30fc\u3068\u5024\u306e\u30da\u30a2\u7d44\u307f\u5408\u308f\u305b\u3067\u3059\u3002",
arrayType:"\u914d\u5217\uff1a \u914d\u5217\u306f\u9806\u5e8f\u304c\u6c7a\u307e\u3063\u3066\u3044\u308b\u5024\u306e\u96c6\u5408\u4f53\u3067\u3059\u3002",stringType:"\u6587\u5b57\u5217\uff1a \u30d5\u30a3\u30fc\u30eb\u30c9\u578b\u306f\u5024\u304b\u3089\u6c7a\u5b9a\u3055\u308c\u307e\u305b\u3093\u304c\u3001\u5e38\u306b\u6587\u5b57\u5217\u3068\u3057\u3066\u8fd4\u3055\u308c\u307e\u3059\u3002",modeCodeText:"\u30b3\u30fc\u30c9\u30e2\u30fc\u30c9",modeCodeTitle:"\u30cf\u30a4\u30e9\u30a4\u30c8\u30e2\u30fc\u30c9\u306b\u5207\u308a\u66ff\u3048",
modeFormText:"\u30d5\u30a9\u30fc\u30e0\u30e2\u30fc\u30c9",modeFormTitle:"\u30d5\u30a9\u30fc\u30e0\u30e2\u30fc\u30c9\u306b\u5207\u308a\u66ff\u3048",modeTextText:"\u30c6\u30ad\u30b9\u30c8\u30e2\u30fc\u30c9",modeTextTitle:"\u30c6\u30ad\u30b9\u30c8\u30e2\u30fc\u30c9\u306b\u5207\u308a\u66ff\u3048",modeTreeText:"\u30c4\u30ea\u30fc\u30e2\u30fc\u30c9",modeTreeTitle:"\u30c4\u30ea\u30fc\u30e2\u30fc\u30c9\u306b\u5207\u308a\u66ff\u3048",modeViewText:"\u30d3\u30e5\u30fc\u30e2\u30fc\u30c9",modeViewTitle:"\u30d3\u30e5\u30fc\u30e2\u30fc\u30c9\u306b\u5207\u308a\u66ff\u3048",
modePreviewText:"\u30d7\u30ec\u30d3\u30e5\u30fc",modePreviewTitle:"\u30d7\u30ec\u30d3\u30e5\u30fc\u306b\u5207\u308a\u66ff\u3048",examples:"\u4f8b","default":"\u30c7\u30d5\u30a9\u30eb\u30c8",containsInvalidProperties:"\u7121\u52b9\u306a\u30d7\u30ed\u30d1\u30c6\u30a3\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059",containsInvalidItems:"\u7121\u52b9\u306a\u30a2\u30a4\u30c6\u30e0\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059"},"fr-FR":{array:"Liste",auto:"Auto",appendText:"Ajouter",appendTitle:"Ajouter un champ de type 'auto' apr\u00e8s ce champ (Ctrl+Shift+Ins)",
appendSubmenuTitle:"S\u00e9lectionner le type du champ \u00e0 ajouter",appendTitleAuto:"Ajouter un champ de type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendant",ascendingTitle:"Trier les enfants de ce ${type} par ordre ascendant",actionsMenu:"Ouvrir le menu des actions (Ctrl+M)",collapseAll:"Regrouper",descending:"Descendant",descendingTitle:"Trier les enfants de ce ${type} par ordre descendant",drag:"D\u00e9placer (Alt+Shift+Arrows)",duplicateKey:"Dupliquer la cl\u00e9",duplicateText:"Dupliquer",
duplicateTitle:"Dupliquer les champs s\u00e9lectionn\u00e9s (Ctrl+D)",duplicateField:"Dupliquer ce champ (Ctrl+D)",duplicateFieldError:"Dupliquer le nom de champ",cannotParseFieldError:"Champ impossible \u00e0 parser en JSON",cannotParseValueError:"Valeur impossible \u00e0 parser en JSON",empty:"vide",expandAll:"\u00c9tendre",expandTitle:"\u00c9tendre/regrouper ce champ (Ctrl+E). \nCtrl+Click pour \u00e9tendre/regrouper avec tous les champs.",insert:"Ins\u00e9rer",insertTitle:"Ins\u00e9rer un champ de type 'auto' avant ce champ (Ctrl+Ins)",
insertSub:"S\u00e9lectionner le type de champ \u00e0 ins\u00e9rer",object:"Objet",ok:"Ok",redo:"Rejouer (Ctrl+Shift+Z)",removeText:"Supprimer",removeTitle:"Supprimer les champs s\u00e9lectionn\u00e9s (Ctrl+Del)",removeField:"Supprimer ce champ (Ctrl+Del)",searchTitle:"Rechercher champs et valeurs",searchNextResultTitle:"R\u00e9sultat suivant (Enter)",searchPreviousResultTitle:"R\u00e9sultat pr\u00e9c\u00e9dent (Shift + Enter)",selectNode:"S\u00e9lectionner un n\u0153ud...",showAll:"voir tout",showMore:"voir plus",
showMoreStatus:"${visibleChilds} \u00e9l\u00e9ments affich\u00e9s de ${totalChilds}.",sort:"Trier",sortTitle:"Trier les champs de ce ${type}",sortTitleShort:"Trier",sortFieldLabel:"Champ:",sortDirectionLabel:"Direction:",sortFieldTitle:"S\u00e9lectionner les champs permettant de trier les listes et objet",sortAscending:"Ascendant",sortAscendingTitle:"Trier les champs s\u00e9lectionn\u00e9s par ordre ascendant",sortDescending:"Descendant",sortDescendingTitle:"Trier les champs s\u00e9lectionn\u00e9s par ordre descendant",
string:"Cha\u00eene",transform:"Transformer",transformTitle:"Filtrer, trier, or transformer les enfants de ce ${type}",transformTitleShort:"Filtrer, trier ou transformer le contenu",extract:"Extraire",extractTitle:"Extraire ce ${type}",transformQueryTitle:"Saisir une requ\u00eate JMESPath",transformWizardLabel:"Assistant",transformWizardFilter:"Filtrer",transformWizardSortBy:"Trier par",transformWizardSelectFields:"S\u00e9lectionner les champs",transformQueryLabel:"Requ\u00eate",transformPreviewLabel:"Pr\u00e9visualisation",
type:"Type",typeTitle:"Changer le type de ce champ",openUrl:"Ctrl+Click ou Ctrl+Enter pour ouvrir l'url dans une autre fen\u00eatre",undo:"Annuler la derni\u00e8re action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Champe de type "auto". Ce type de champ est automatiquement d\u00e9termin\u00e9 en fonction de la valeur et peut \u00eatre de type "cha\u00eene", "nombre", "bool\u00e9en" ou null.',objectType:'Champ de type "objet". Un objet contient un ensemble non ordonn\u00e9 de paires cl\u00e9/valeur.',
arrayType:'Champ de type "liste". Une liste contient une collection ordonn\u00e9e de valeurs.',stringType:'Champ de type "cha\u00eene". Ce type de champ n\'est pas d\u00e9termin\u00e9 en fonction de la valeur, mais retourne syst\u00e9matiquement une cha\u00eene de caract\u00e8res.',modeEditorTitle:"Changer mode d'\u00e9dition",modeCodeText:"Code",modeCodeTitle:"Activer surlignage code",modeFormText:"Formulaire",modeFormTitle:"Activer formulaire",modeTextText:"Texte",modeTextTitle:"Activer \u00e9diteur texte",
modeTreeText:"Arbre",modeTreeTitle:"Activer \u00e9diteur arbre",modeViewText:"Lecture seule",modeViewTitle:"Activer vue arbre",modePreviewText:"Pr\u00e9visualisation",modePreviewTitle:"Activer mode pr\u00e9visualiser",examples:"Exemples","default":"D\u00e9faut",containsInvalidProperties:"Contient des propri\u00e9t\u00e9s non valides",containsInvalidItems:"Contient des \u00e9l\u00e9ments invalides"},de:{array:"Auflistung",auto:"Auto",appendText:"anh\u00e4ngen",appendTitle:"F\u00fcgen Sie nach diesem Feld ein neues Feld mit dem Typ 'auto' ein (Strg+Umschalt+Ein)",
appendSubmenuTitle:"W\u00e4hlen Sie den Typ des neuen Feldes",appendTitleAuto:"Ein neues Feld vom Typ 'auto' hinzuf\u00fcgen (Strg+Umschalt+Ein)",ascending:"Aufsteigend",ascendingTitle:"Sortieren Sie die Elemente dieses ${type} in aufsteigender Reihenfolge",actionsMenu:"Klicken Sie zum \u00d6ffnen des Aktionsmen\u00fcs (Strg+M)",cannotParseFieldError:"Feld kann nicht in JSON geparst werden",cannotParseValueError:"Wert kann nicht in JSON geparst werden",collapseAll:"Alle Felder zuklappen",compactTitle:"JSON-Daten verdichten, alle Leerzeichen entfernen (Strg+Umschalt+\\)",
descending:"Absteigend",descendingTitle:"Sortieren Sie die Elemente dieses ${type} in absteigender Reihenfolge",drag:"Ziehen, um dieses Feld zu verschieben (Alt+Umschalt+Pfeile)",duplicateKey:"Doppelter Schl\u00fcssel",duplicateText:"Duplikat",duplicateTitle:"Ausgew\u00e4hlte Felder duplizieren (Strg+D)",duplicateField:"Dieses Feld duplizieren (Strg+D)",duplicateFieldError:"Doppelter Feldname",empty:"leer",expandAll:"Alle Felder anzeigen",expandTitle:"Klicken Sie, um dieses Feld zu erweitern/zu kollabieren (Strg+E). \nStrg+Klicken Sie, um dieses Feld einschlie\u00dflich aller Elemente zu erweitern/zu kollabieren.",
formatTitle:"JSON-Daten mit korrekter Einr\u00fcckung und Zeilenvorsch\u00fcben formatieren (Strg+\\)",insert:"einf\u00fcgen",insertTitle:"F\u00fcgen Sie vor diesem Feld ein neues Feld mit dem Typ 'auto' ein (Strg+Einfg)",insertSub:"W\u00e4hlen Sie den Typ des neuen Feldes",object:"Objekt",ok:"Ok",redo:"Wiederholen (Strg+Umschalt+Z)",removeText:"entfernen",removeTitle:"Ausgew\u00e4hlte Felder entfernen (Strg+Entf)",removeField:"Dieses Feld entfernen (Strg+Entf)",repairTitle:"JSON reparieren: Anf\u00fchrungszeichen und Escape-Zeichen korrigieren, Kommentare und JSONP-Notation entfernen, JavaScript-Objekte in JSON umwandeln.",
searchTitle:"Suchfelder und Werte",searchNextResultTitle:"N\u00e4chstes Ergebnis (Enter)",searchPreviousResultTitle:"Vorheriges Ergebnis (Umschalt + Eingabe)",selectNode:"W\u00e4hlen Sie einen Knoten aus...",showAll:"alle anzeigen",showMore:"mehr anzeigen",showMoreStatus:"Anzeige von ${visibleChilds} von ${totalChilds}-Elementen.",sort:"Sortieren",sortTitle:"Sortieren Sie die Elemente dieses ${type}",sortTitleShort:"Inhalt sortieren",sortFieldLabel:"Feld:",sortDirectionLabel:"Richtung:",sortFieldTitle:"W\u00e4hlen Sie das verschachtelte Feld, nach dem das Array oder Objekt sortiert werden soll.",
sortAscending:"Aufsteigend",sortAscendingTitle:"Sortieren Sie das ausgew\u00e4hlte Feld in aufsteigender Reihenfolge",sortDescending:"Absteigend",sortDescendingTitle:"Sortieren Sie das ausgew\u00e4hlte Feld in absteigender Reihenfolge",string:"Zeichenfolge",transform:"Verwandeln",transformTitle:"Die Elemente dieses ${type} filtern, sortieren oder transformieren",transformTitleShort:"Inhalte filtern, sortieren oder transformieren",extract:"Auszug",extractTitle:"Extrahieren Sie diesen ${type}",transformQueryTitle:"Eine JMESPath-Abfrage eingeben",
transformWizardLabel:"Zauberer",transformWizardFilter:"Filter",transformWizardSortBy:"Sortieren nach",transformWizardSelectFields:"Felder ausw\u00e4hlen",transformQueryLabel:"Anfrage",transformPreviewLabel:"Vorschau",type:"Geben Sie  ein.",typeTitle:"\u00c4ndern Sie den Typ dieses Feldes",openUrl:"Strg+Klicken oder Strg+Eingabe, um die URL in einem neuen Fenster zu \u00f6ffnen",undo:"Letzte Aktion r\u00fcckg\u00e4ngig machen (Strg+Z)",validationCannotMove:"Kann ein Feld nicht in ein Kind seiner selbst verschieben",
autoType:'Feldtyp "auto". Der Feldtyp wird automatisch aus dem Wert bestimmt und kann ein String, eine Zahl, boolesch oder null sein.',objectType:'Feldtyp "Objekt". Ein Objekt enth\u00e4lt eine ungeordnete Menge von Schl\u00fcssel/Wert-Paaren.',arrayType:'Feldtyp "Array". Ein Array enth\u00e4lt eine geordnete Sammlung von Werten.',stringType:'Feldtyp "Zeichenfolge". Der Feldtyp wird nicht aus dem Wert bestimmt, sondern immer als Zeichenfolge zur\u00fcckgegeben.',modeEditorTitle:"Editor-Modus umschalten",
modeCodeText:"Code",modeCodeTitle:"Umschalten auf Code-Highlighter",modeFormText:"Formular",modeFormTitle:"Zum Formular-Editor wechseln",modeTextText:"Text",modeTextTitle:"Zum Editor f\u00fcr einfachen Text wechseln",modeTreeText:"Baum",modeTreeTitle:"Zum Baum-Editor wechseln",modeViewText:"Siehe",modeViewTitle:"Zur Baumansicht wechseln",modePreviewText:"Vorschau",modePreviewTitle:"In den Vorschau-Modus wechseln",examples:"Beispiele","default":"Standardm\u00e4\u00dfig",containsInvalidProperties:"Enth\u00e4lt ung\u00fcltige Eigenschaften",
containsInvalidItems:"Enth\u00e4lt ung\u00fcltige Elemente"},ru:{array:"\u041c\u0430\u0441\u0441\u0438\u0432",auto:"\u0410\u0432\u0442\u043e",appendText:"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c",appendTitle:"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u043e\u0435 \u043f\u043e\u043b\u0435 \u0441 \u0442\u0438\u043f\u043e\u043c '\u0430\u0432\u0442\u043e' \u043f\u043e\u0441\u043b\u0435 \u044d\u0442\u043e\u0433\u043e \u043f\u043e\u043b\u044f (Ctrl+Shift+Ins)",appendSubmenuTitle:"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0442\u0438\u043f \u043f\u043e\u043b\u044f \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f",
appendTitleAuto:"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u043e\u0435 \u043f\u043e\u043b\u0435 \u0441 \u0442\u0438\u043f\u043e\u043c '\u0430\u0432\u0442\u043e' (Ctrl+Shift+Ins)",ascending:"\u041f\u043e \u0432\u043e\u0437\u0440\u0430\u0441\u0442\u0430\u043d\u0438\u044e",ascendingTitle:"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c ${type} \u043f\u043e \u0432\u043e\u0437\u0440\u0430\u0441\u0442\u0430\u043d\u0438\u044e",actionsMenu:"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0434\u043b\u044f \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u043c\u0435\u043d\u044e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439 (Ctrl+M)",
cannotParseFieldError:"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u043b\u0435 \u0432 JSON",cannotParseValueError:"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432 JSON",collapseAll:"\u0421\u0432\u0435\u0440\u043d\u0443\u0442\u044c \u0432\u0441\u0435",
compactTitle:"\u041c\u0438\u043d\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f JSON (Ctrl+Shift+I)",descending:"\u041f\u043e \u0443\u0431\u044b\u0432\u0430\u043d\u0438\u044e",descendingTitle:"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c ${type} \u043f\u043e \u0443\u0431\u044b\u0432\u0430\u043d\u0438\u044e",drag:"\u041f\u043e\u0442\u044f\u043d\u0438\u0442\u0435 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0438\u044f \u044d\u0442\u043e\u0433\u043e \u043f\u043e\u043b\u044f (Alt+Shift+Arrows)",
duplicateKey:"\u043f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0438\u0439\u0441\u044f \u043a\u043b\u044e\u0447",duplicateText:"\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c",duplicateTitle:"\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043b\u0435\u0439 (Ctrl+D)",duplicateField:"\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u043b\u0435 (Ctrl+D)",duplicateFieldError:"\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f \u043f\u043e\u043b\u044f",
empty:"\u043f\u0443\u0441\u0442\u043e\u0439",expandAll:"\u0420\u0430\u0437\u0432\u0435\u0440\u043d\u0443\u0442\u044c \u0432\u0441\u0435",expandTitle:"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0434\u043b\u044f \u0440\u0430\u0441\u043a\u0440\u044b\u0442\u0438\u044f/\u0441\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u043e\u043b\u044f (Ctrl+E)\n\u0438\u043b\u0438 Ctrl+Click \u0434\u043b\u044f \u0440\u0430\u0441\u043a\u0440\u044b\u0442\u0438\u044f/\u0441\u043a\u0440\u044b\u0442\u0438\u044f \u0432\u0441\u0435\u0445 \u043f\u043e\u0442\u043e\u043c\u043a\u043e\u0432.",
formatTitle:"\u0424\u043e\u0440\u043c\u0430\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 JSON (Ctrl+I)",insert:"\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c",insertTitle:"\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u043e\u0435 \u043f\u043e\u043b\u0435 \u0441 \u0442\u0438\u043f\u043e\u043c '\u0430\u0432\u0442\u043e' \u043f\u0435\u0440\u0435\u0434 \u044d\u0442\u0438\u043c \u043f\u043e\u043b\u0435\u043c (Ctrl+Ins)",insertSub:"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0442\u0438\u043f \u043f\u043e\u043b\u044f \u0434\u043b\u044f \u0432\u0441\u0442\u0430\u0432\u043a\u0438",
object:"\u041e\u0431\u044a\u0435\u043a\u0442",ok:"\u041e\u041a",redo:"\u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u044c (Ctrl+Shift+Z)",removeText:"\u0423\u0434\u0430\u043b\u0438\u0442\u044c",removeTitle:"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u043b\u044f (Ctrl+Del)",removeField:"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043e\u043b\u0435 (Ctrl+Del)",repairTitle:"\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 JSON: \u0438\u0441\u043f\u0440\u0430\u0432\u044c\u0442\u0435 \u043a\u0430\u0432\u044b\u0447\u043a\u0438 \u0438 escape-\u0441\u0438\u043c\u0432\u043e\u043b\u044b, \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0438 \u0438 \u043d\u043e\u0442\u0430\u0446\u0438\u044e JSONP, \u043c\u043e\u0434\u0438\u0444\u0438\u0446\u0438\u0440\u0443\u0439\u0442\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b JavaScript \u0432 JSON.",
searchTitle:"\u041f\u043e\u0438\u0441\u043a",searchNextResultTitle:"\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 (Enter)",searchPreviousResultTitle:"\u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 (Shift + Enter)",selectNode:"\u0412\u044b\u0431\u043e\u0440 \u0443\u0437\u043b\u0430...",showAll:"\u043f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0432\u0441\u0435",showMore:"\u0431\u043e\u043b\u044c\u0448\u0435",
showMoreStatus:"${visibleChilds} \u0438\u0437 ${totalChilds}",sort:"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430",sortTitle:"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u043f\u043e\u0442\u043e\u043c\u043a\u043e\u0432 \u0442\u0438\u043f\u0430 ${type}",sortTitleShort:"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e",sortFieldLabel:"\u041f\u043e\u043b\u0435:",sortDirectionLabel:"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435:",
sortFieldTitle:"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u043b\u0435 \u0434\u043b\u044f \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u0438\u043b\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430",sortAscending:"\u041f\u043e \u0432\u043e\u0437\u0440\u0430\u0441\u0442\u0430\u043d\u0438\u044e",sortAscendingTitle:"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u044f \u043f\u043e \u0432\u043e\u0437\u0440\u0430\u0441\u0442\u0430\u043d\u0438\u044e",
sortDescending:"\u041f\u043e \u0443\u0431\u044b\u0432\u0430\u043d\u0438\u044e",sortDescendingTitle:"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u044f \u043f\u043e \u0443\u0431\u044b\u0432\u0430\u043d\u0438\u044e",string:"\u0421\u0442\u0440\u043e\u043a\u0430",transform:"\u041c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f",transformTitle:"\u0424\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u044f, \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0438\u043b\u0438 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u0442\u0438\u043f\u0430 ${type}",
transformTitleShort:"\u0424\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u044f, \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0438\u043b\u0438 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445",extract:"\u0418\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u0435",extractTitle:"\u0418\u0437\u0432\u043b\u0435\u0447\u044c \u0442\u0438\u043f ${type}",transformQueryTitle:"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 JMESpath \u0437\u0430\u043f\u0440\u043e\u0441",
transformWizardLabel:"\u041c\u0430\u0441\u0442\u0435\u0440",transformWizardFilter:"\u0424\u0438\u043b\u044c\u0442\u0440",transformWizardSortBy:"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430",transformWizardSelectFields:"\u041f\u043e\u043b\u044f",transformQueryLabel:"\u0417\u0430\u043f\u0440\u043e\u0441",transformPreviewLabel:"\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440",type:"\u0422\u0438\u043f",typeTitle:"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0438\u043f \u044d\u0442\u043e\u0433\u043e \u043f\u043e\u043b\u044f",
openUrl:"Ctrl+Click \u0438\u043b\u0438 Ctrl+Enter \u0434\u043b\u044f \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f url \u0432 \u043d\u043e\u0432\u043e\u043c \u043e\u043a\u043d\u0435",undo:"\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c (Ctrl+Z)",validationCannotMove:"\u041f\u043e\u043b\u0435 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u043e \u0432 \u043f\u043e\u0442\u043e\u043c\u043a\u0430",autoType:"\u0422\u0438\u043f \u043f\u043e\u043b\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044e \u0438 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u043e\u0439, \u0447\u0438\u0441\u043b\u043e\u043c, \u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u043c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u043c \u0438\u043b\u0438 null.",
objectType:"\u041e\u0431\u044a\u0435\u043a\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0443\u043f\u043e\u0440\u044f\u0434\u043e\u0447\u0435\u043d\u043d\u044b\u0439 \u043d\u0430\u0431\u043e\u0440 \u043f\u0430\u0440 \u043a\u043b\u044e\u0447/\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.",arrayType:"\u041c\u0430\u0441\u0441\u0438\u0432 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0443\u043f\u043e\u0440\u044f\u0434\u043e\u0447\u0435\u043d\u043d\u044b\u0439 \u043d\u0430\u0431\u043e\u0440 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439.",
stringType:"\u0422\u0438\u043f \u043f\u043e\u043b\u044f \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f \u0438\u0437 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f, \u043d\u043e \u0432\u0441\u0435\u0433\u0434\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u0442\u0441\u044f \u043a\u0430\u043a \u0441\u0442\u0440\u043e\u043a\u0430.",modeEditorTitle:"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0440\u0435\u0436\u0438\u043c\u0430 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430",
modeCodeText:"\u041a\u043e\u0434",modeCodeTitle:"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432 \u0440\u0435\u0436\u0438\u043c \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430 \u043a\u043e\u0434\u0430",modeFormText:"\u0424\u043e\u0440\u043c\u0430",modeFormTitle:"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432 \u0440\u0435\u0436\u0438\u043c \u0444\u043e\u0440\u043c\u044b",modeTextText:"\u0422\u0435\u043a\u0441\u0442",modeTextTitle:"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432 \u0440\u0435\u0436\u0438\u043c \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430 \u0442\u0435\u043a\u0441\u0442\u0430",
modeTreeText:"\u0414\u0435\u0440\u0435\u0432\u043e",modeTreeTitle:"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432 \u0440\u0435\u0436\u0438\u043c \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430 \u0434\u0435\u0440\u0435\u0432\u0430",modeViewText:"\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u0434\u0435\u0440\u0435\u0432\u0430",modeViewTitle:"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432 \u0440\u0435\u0436\u0438\u043c \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430 \u0434\u0435\u0440\u0435\u0432\u0430",
modePreviewText:"\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440",modePreviewTitle:"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432 \u0440\u0435\u0436\u0438\u043c \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430",examples:"\u041f\u0440\u0438\u043c\u0435\u0440\u044b","default":"\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e",containsInvalidProperties:"\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430",
containsInvalidItems:"\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b"}},l="en",I="undefined"!==typeof navigator?navigator.language||navigator.userLanguage:void 0,F=A.find(function(d){return d===I})||l},56:function(w,n,d){function r(d,e){var p=e.sort,l=e.filter;e=e.projection;var n="";if(l){var r="@"!==l.field?["0"].concat((0,A.parsePath)("."+l.field)):["0"];d="string"===typeof(0,
A.get)(d,r)?l.value:(0,A.parseString)(l.value);n+="[? "+l.field+" "+l.relation+" `"+JSON.stringify(d)+"`]"}else n+=Array.isArray(d)?"[*]":"@";p&&(n="desc"===p.direction?n+(" | reverse(sort_by(@, &"+p.field+"))"):n+(" | sort_by(@, &"+p.field+")"));e&&("]"!==n[n.length-1]&&(n+=" | [*]"),1===e.fields.length?n+="."+e.fields[0]:1<e.fields.length&&(n+=".{"+e.fields.map(function(d){var e=d.split(".");return e[e.length-1]+": "+d}).join(", ")+"}"));return n}function x(d,l){return e().search(d,l)}d.d(n,{r:function(){return r},
J:function(){return x}});w=d(156);var e=d.n(w),A=d(791)},987:function(){"undefined"!==typeof Element&&function(){function w(n){"remove"in n||Object.defineProperty(n,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){void 0!==this.parentNode&&this.parentNode.removeChild(this)}})}"undefined"!==typeof window.Element&&w(window.Element.prototype);"undefined"!==typeof window.CharacterData&&w(window.CharacterData.prototype);"undefined"!==typeof window.DocumentType&&w(window.DocumentType.prototype)}();
Array.prototype.findIndex||Object.defineProperty(Array.prototype,"findIndex",{value:function(w){for(var n=0;n<this.length;n++)if(w.call(this,this[n],n,this))return n;return-1},configurable:!0,writable:!0});Array.prototype.find||Object.defineProperty(Array.prototype,"find",{value:function(w){return this[this.findIndex(w)]},configurable:!0,writable:!0});String.prototype.trim||(String.prototype.trim=function(){return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")})},341:function(w,n,d){function r(b,
a){for(var c=0;c<a.length;c++){var h=a[c];h.enumerable=h.enumerable||!1;h.configurable=!0;"value"in h&&(h.writable=!0);Object.defineProperty(b,h.key,h)}}function x(b,a,c){a&&r(b.prototype,a);c&&r(b,c);return b}d.r(n);d.d(n,{previewModeMixins:function(){return b}});w=d(664);var e=d.n(w),A=d(188),p=d(436),l=d(474),I=function(){function b(a,c,h){if(!(this instanceof b))throw new TypeError("Cannot call a class as a function");this.onChange=a;this.calculateItemSize=c||function(){return 1};this.limit=h;
this.items=[];this.index=-1}x(b,[{key:"add",value:function(a){for(;this._calculateHistorySize()>this.limit&&1<this.items.length;)this.items.shift(),this.index--;this.items=this.items.slice(0,this.index+1);this.items.push(a);this.index++;this.onChange()}},{key:"_calculateHistorySize",value:function(){var a=this.calculateItemSize,c=0;this.items.forEach(function(b){c+=a(b)});return c}},{key:"undo",value:function(){if(this.canUndo())return this.index--,this.onChange(),this.items[this.index]}},{key:"redo",
value:function(){if(this.canRedo())return this.index++,this.onChange(),this.items[this.index]}},{key:"canUndo",value:function(){return 0<this.index}},{key:"canRedo",value:function(){return this.index<this.items.length-1}},{key:"clear",value:function(){this.items=[];this.index=-1;this.onChange()}}]);return b}(),F=d(907),t=d(56),D=d(617),G=d(210),J=d(558);w=d(956);var v=d(791);d=w.textModeMixins[0].mixin;w={create:function(b){var a=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};"undefined"===
typeof a.statusBar&&(a.statusBar=!0);a.mainMenuBar=!1!==a.mainMenuBar;a.enableSort=!1!==a.enableSort;a.enableTransform=!1!==a.enableTransform;a.createQuery=a.createQuery||t.r;a.executeQuery=a.executeQuery||t.J;this.options=a;this.indentation="number"===typeof a.indentation?Number(a.indentation):2;(0,F.cC)(this.options.languages);(0,F.m0)(this.options.language);this.mode="preview";var c=this;this.container=b;this.dom={};this.json=void 0;this.text="";this._debouncedValidate=(0,v.debounce)(this.validate.bind(this),
this.DEBOUNCE_INTERVAL);this.width=b.clientWidth;this.height=b.clientHeight;this.frame=document.createElement("div");this.frame.className="jsoneditor jsoneditor-mode-preview";this.frame.onclick=function(a){a.preventDefault()};this.frameFocusTracker=new l.R({target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null});this.content=document.createElement("div");this.content.className="jsoneditor-outer";this.dom.busy=document.createElement("div");this.dom.busy.className="jsoneditor-busy";
this.dom.busyContent=document.createElement("span");this.dom.busyContent.textContent="busy...";this.dom.busy.appendChild(this.dom.busyContent);this.content.appendChild(this.dom.busy);this.dom.previewContent=document.createElement("pre");this.dom.previewContent.className="jsoneditor-preview";this.dom.previewText=document.createTextNode("");this.dom.previewContent.appendChild(this.dom.previewText);this.content.appendChild(this.dom.previewContent);if(this.options.mainMenuBar){(0,v.addClassName)(this.content,
"has-main-menu-bar");this.menu=document.createElement("div");this.menu.className="jsoneditor-menu";this.frame.appendChild(this.menu);var h=document.createElement("button");h.type="button";h.className="jsoneditor-format";h.title=(0,F.Iu)("formatTitle");this.menu.appendChild(h);h.onclick=function(){c.executeWithBusyMessage(function(){try{c.format()}catch(u){c._onError(u)}},"formatting...")};h=document.createElement("button");h.type="button";h.className="jsoneditor-compact";h.title=(0,F.Iu)("compactTitle");
this.menu.appendChild(h);h.onclick=function(){c.executeWithBusyMessage(function(){try{c.compact()}catch(u){c._onError(u)}},"compacting...")};this.options.enableSort&&(h=document.createElement("button"),h.type="button",h.className="jsoneditor-sort",h.title=(0,F.Iu)("sortTitleShort"),h.onclick=function(){c._showSortModal()},this.menu.appendChild(h));this.options.enableTransform&&(h=document.createElement("button"),h.type="button",h.title=(0,F.Iu)("transformTitleShort"),h.className="jsoneditor-transform",
h.onclick=function(){c._showTransformModal()},this.dom.transform=h,this.menu.appendChild(h));h=document.createElement("button");h.type="button";h.className="jsoneditor-repair";h.title=(0,F.Iu)("repairTitle");this.menu.appendChild(h);h.onclick=function(){void 0===c.json&&c.executeWithBusyMessage(function(){try{c.repair()}catch(u){c._onError(u)}},"repairing...")};!1!==this.options.history&&(this.history=new I(function(){c.dom.undo.disabled=!c.history.canUndo();c.dom.redo.disabled=!c.history.canRedo()},
function(a){return 2*a.text.length},A.oW),h=document.createElement("button"),h.type="button",h.className="jsoneditor-undo jsoneditor-separator",h.title=(0,F.Iu)("undo"),h.onclick=function(){var a=c.history.undo();a&&c._applyHistory(a)},this.menu.appendChild(h),this.dom.undo=h,h=document.createElement("button"),h.type="button",h.className="jsoneditor-redo",h.title=(0,F.Iu)("redo"),h.onclick=function(){var a=c.history.redo();a&&c._applyHistory(a)},this.menu.appendChild(h),this.dom.redo=h,this.history.onChange());
this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new D.x(this.menu,this.options.modes,this.options.mode,function(a){c.setMode(a);c.modeSwitcher.focus()}))}this.errorTable=new p.Q({errorTableVisible:!0,onToggleVisibility:function(){c.validate()},onFocusLine:null,onChangeHeight:function(a){a=a+(c.dom.statusBar?c.dom.statusBar.clientHeight:0)+1;c.content.style.marginBottom=-a+"px";c.content.style.paddingBottom=a+"px"}});this.frame.appendChild(this.content);this.frame.appendChild(this.errorTable.getErrorTable());
this.container.appendChild(this.frame);a.statusBar&&((0,v.addClassName)(this.content,"has-status-bar"),a=document.createElement("div"),this.dom.statusBar=a,a.className="jsoneditor-statusbar",this.frame.appendChild(a),this.dom.fileSizeInfo=document.createElement("span"),this.dom.fileSizeInfo.className="jsoneditor-size-info",this.dom.fileSizeInfo.innerText="",a.appendChild(this.dom.fileSizeInfo),this.dom.arrayInfo=document.createElement("span"),this.dom.arrayInfo.className="jsoneditor-size-info",this.dom.arrayInfo.innerText=
"",a.appendChild(this.dom.arrayInfo),a.appendChild(this.errorTable.getErrorCounter()),a.appendChild(this.errorTable.getWarningIcon()),a.appendChild(this.errorTable.getErrorIcon()));this._renderPreview();this.setSchema(this.options.schema,this.options.schemaRefs)},_renderPreview:function(){var b=this.getText();this.dom.previewText.nodeValue=(0,v.limitCharacters)(b,A.WF);this.dom.fileSizeInfo&&(this.dom.fileSizeInfo.innerText="Size: "+(0,v.formatSize)(b.length));this.dom.arrayInfo&&(Array.isArray(this.json)?
this.dom.arrayInfo.innerText="Array: "+this.json.length+" items":this.dom.arrayInfo.innerText="")},_onChange:function(){this._debouncedValidate();if(this.options.onChange)try{this.options.onChange()}catch(g){console.error("Error in onChange callback: ",g)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(g){console.error("Error in onChangeJSON callback: ",g)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(g){console.error("Error in onChangeText callback: ",
g)}},_showSortModal:function(){var b=this;this.executeWithBusyMessage(function(){var a=b.options.modalAnchor||A.qD,c=b.get();b._renderPreview();(0,G.showSortModal)(a,c,function(a){b.executeWithBusyMessage(function(){if(Array.isArray(c)){var h=(0,v.sort)(c,a.path,a.direction);b.sortedBy=a;b._setAndFireOnChange(h)}(0,v.isObject)(c)&&(h=(0,v.sortObjectKeys)(c,a.direction),b.sortedBy=a,b._setAndFireOnChange(h))},"sorting...")},b.sortedBy)},"parsing...")},_showTransformModal:function(){var b=this;this.executeWithBusyMessage(function(){var a=
b.options,c=a.createQuery,h=a.executeQuery,d=a.modalAnchor;a=a.queryDescription;var g=b.get();b._renderPreview();(0,J.showTransformModal)({container:d||A.qD,json:g,queryDescription:a,createQuery:c,executeQuery:h,onTransform:function(a){b.executeWithBusyMessage(function(){var c=h(g,a);b._setAndFireOnChange(c)},"transforming...")}})},"parsing...")},destroy:function(){this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame);this.modeSwitcher&&(this.modeSwitcher.destroy(),
this.modeSwitcher=null);this._debouncedValidate=null;this.history&&(this.history.clear(),this.history=null);this.frameFocusTracker.destroy()},compact:function(){var b=this.get(),a=JSON.stringify(b);this._setTextAndFireOnChange(a,b)},format:function(){var b=this.get(),a=JSON.stringify(b,null,this.indentation);this._setTextAndFireOnChange(a,b)},repair:function(){var b=this.getText();try{var a=e()(b);this._setTextAndFireOnChange(a)}catch(c){}},focus:function(){this.dom.transform.focus()},set:function(b){this.history&&
this.history.clear();this._set(b)},update:function(b){this._set(b)},_set:function(b){this.text=void 0;this.json=b;this._renderPreview();this._pushHistory();this._debouncedValidate()},_setAndFireOnChange:function(b){this._set(b);this._onChange()},get:function(){if(void 0===this.json){var b=this.getText();this.json=(0,v.parse)(b)}return this.json},getText:function(){void 0===this.text&&(this.text=JSON.stringify(this.json,null,this.indentation),!0===this.options.escapeUnicode&&(this.text=(0,v.escapeUnicodeChars)(this.text)));
return this.text},setText:function(b){this.history&&this.history.clear();this._setText(b)},updateText:function(b){this.getText()!==b&&this._setText(b)},_setText:function(b,a){this.text=!0===this.options.escapeUnicode?(0,v.escapeUnicodeChars)(b):b;this.json=a;this._renderPreview();if(void 0===this.json){var c=this;this.executeWithBusyMessage(function(){try{c.json=c.get(),c._renderPreview(),c._pushHistory()}catch(h){}},"parsing...")}else this._pushHistory();this._debouncedValidate()},_setTextAndFireOnChange:function(b,
a){this._setText(b,a);this._onChange()},_applyHistory:function(b){this.json=b.json;this.text=b.text;this._renderPreview();this._debouncedValidate()},_pushHistory:function(){this.history&&this.history.add({text:this.text,json:this.json})},executeWithBusyMessage:function(b,a){if(this.getText().length>A.EX){var c=this;(0,v.addClassName)(c.frame,"busy");c.dom.busyContent.innerText=a;setTimeout(function(){b();(0,v.removeClassName)(c.frame,"busy");c.dom.busyContent.innerText=""},100)}else b()}};w.validate=
d.validate;w._renderErrors=d._renderErrors;var b=[{mode:"preview",mixin:w,data:"json"}]},210:function(w,n,d){function r(d,l,n,r){var p=Array.isArray(l)?(0,A.getChildPaths)(l):[""],w=r&&r.path&&(0,A.contains)(p,r.path)?r.path:p[0],G=r&&r.direction||"asc";l='<div class="pico-modal-contents"><div class="pico-modal-header">'+(0,e.Iu)("sort")+"</div><form><table><tbody><tr>  <td>"+(0,e.Iu)("sortFieldLabel")+' </td>  <td class="jsoneditor-modal-input">  <div class="jsoneditor-select-wrapper">    <select id="field" title="'+
(0,e.Iu)("sortFieldTitle")+'">    </select>  </div>  </td></tr><tr>  <td>'+(0,e.Iu)("sortDirectionLabel")+' </td>  <td class="jsoneditor-modal-input">  <div id="direction" class="jsoneditor-button-group"><input type="button" value="'+(0,e.Iu)("sortAscending")+'" title="'+(0,e.Iu)("sortAscendingTitle")+'" data-value="asc" class="jsoneditor-button-first jsoneditor-button-asc"/><input type="button" value="'+(0,e.Iu)("sortDescending")+'" title="'+(0,e.Iu)("sortDescendingTitle")+'" data-value="desc" class="jsoneditor-button-last jsoneditor-button-desc"/>  </div>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+
(0,e.Iu)("ok")+'" /></td></tr></tbody></table></form></div>';x()({parent:d,content:l,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-sort"}).afterCreate(function(d){function e(a){c.value=a;c.className="jsoneditor-button-group jsoneditor-button-group-value-"+c.value}var b=d.modalElem().querySelector("form"),g=d.modalElem().querySelector("#ok"),a=d.modalElem().querySelector("#field"),c=d.modalElem().querySelector("#direction");
p.forEach(function(c){var b=document.createElement("option");var h=""===c?"@":"."===c[0]?c.slice(1):c;b.text=h;b.value=c;a.appendChild(b)});a.value=w||p[0];e(G||"asc");c.onclick=function(a){e(a.target.getAttribute("data-value"))};g.onclick=function(b){b.preventDefault();b.stopPropagation();d.close();n({path:a.value,direction:c.value})};b&&(b.onsubmit=g.onclick)}).afterClose(function(d){d.destroy()}).show()}d.r(n);d.d(n,{showSortModal:function(){return r}});w=d(483);var x=d.n(w),e=d(907),A=d(791)},
558:function(w,n,d){function r(d){"@babel/helpers - typeof";r="function"===typeof Symbol&&"symbol"===typeof Symbol.iterator?function(d){return typeof d}:function(d){return d&&"function"===typeof Symbol&&d.constructor===Symbol&&d!==Symbol.prototype?"symbol":typeof d};return r(d)}function x(d,e,p,l){if("boolean"===typeof d||d instanceof Boolean||null===d||"number"===typeof d||d instanceof Number||"string"===typeof d||d instanceof String||d instanceof Date)return JSON.stringify(d);if(Array.isArray(d)){a:{for(var b=
e?p+e:void 0,g=e?"[\n":"[",a=0;a<d.length;a++){var c=d[a];e&&(g+=b);g="undefined"!==typeof c&&"function"!==typeof c?g+x(c,e,b,l):g+"null";a<d.length-1&&(g+=e?",\n":",");if(g.length>l){d=g+"...";break a}}d=g+(e?"\n"+p+"]":"]")}return d}if(d&&"object"===r(d)){a:if(b=e?p+e:void 0,g=!0,a=e?"{\n":"{","function"===typeof d.toJSON)d=x(d.toJSON(),e,p,l);else{for(c in d)if(Object.prototype.hasOwnProperty.call(d,c)){var h=d[c];g?g=!1:a+=e?",\n":",";a+=e?b+'"'+c+'": ':'"'+c+'":';a+=x(h,e,b,l);if(a.length>l){d=
a+"...";break a}}d=a+(e?"\n"+p+"}":"}")}return d}}function e(d){var e=d.container,n=d.json,r=d.queryDescription;r=void 0===r?t:r;var b=d.createQuery,g=d.executeQuery,a=d.onTransform;d='<label class="pico-modal-contents"><div class="pico-modal-header">'+(0,l.Iu)("transform")+"</div><p>"+r+'</p><div class="jsoneditor-jmespath-label">'+(0,l.Iu)("transformWizardLabel")+' </div><div id="wizard" class="jsoneditor-jmespath-block jsoneditor-jmespath-wizard">  <table class="jsoneditor-jmespath-wizard-table">    <tbody>      <tr>        <th>'+
(0,l.Iu)("transformWizardFilter")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-filter-field" >            <select id="filterField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-relation" >            <select id="filterRelation">              <option value="==">==</option>              <option value="!=">!=</option>              <option value="<">&lt;</option>              <option value="<=">&lt;=</option>              <option value=">">&gt;</option>              <option value=">=">&gt;=</option>            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-value" >            <input type="text" class="value" placeholder="value..." id="filterValue" />          </div>        </td>      </tr>      <tr>        <th>'+
(0,l.Iu)("transformWizardSortBy")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-sort-field">            <select id="sortField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-sort-order" >            <select id="sortOrder">              <option value="asc">Ascending</option>              <option value="desc">Descending</option>            </select>          </div>        </td>      </tr>      <tr id="selectFieldsPart">        <th>'+
(0,l.Iu)("transformWizardSelectFields")+'</th>        <td class="jsoneditor-jmespath-filter">          <select class="jsoneditor-jmespath-select-fields" id="selectFields" multiple></select>        </td>      </tr>    </tbody>  </table></div><div class="jsoneditor-jmespath-label">'+(0,l.Iu)("transformQueryLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="query"             rows="4"             autocomplete="off"             autocorrect="off"             autocapitalize="off"             spellcheck="false"            title="'+
(0,l.Iu)("transformQueryTitle")+'">[*]</textarea></div><div class="jsoneditor-jmespath-label">'+(0,l.Iu)("transformPreviewLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="preview"       class="jsoneditor-transform-preview"      readonly> </textarea></div><div class="jsoneditor-jmespath-block jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+(0,l.Iu)("ok")+'" autofocus /></div></div>';A()({parent:e,content:d,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",
opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-transform",focus:!1}).afterCreate(function(c){function h(a){return""===a?"@":"."===a[0]?a.slice(1):a}function d(a,c){try{L.value=b(a,c),r.disabled=!1,V()}catch(W){a='Error: an error happened when executing "createQuery": '+(W.message||W.toString()),L.value="",r.disabled=!0,B.className="jsoneditor-transform-preview jsoneditor-error",B.value=a}}function e(){var a={};t.value&&v.value&&y.value&&(a.filter={field:t.value,relation:v.value,value:y.value});
q.value&&w.value&&(a.sort={field:q.value,direction:w.value});if(A.value){for(var c=[],b=0;b<A.options.length;b++)A.options[b].selected&&c.push(A.options[b].value);a.projection={fields:c}}d(n,a)}var l=c.modalElem(),m=l.querySelector("#wizard"),r=l.querySelector("#ok"),t=l.querySelector("#filterField"),v=l.querySelector("#filterRelation"),y=l.querySelector("#filterValue"),q=l.querySelector("#sortField"),w=l.querySelector("#sortOrder"),A=l.querySelector("#selectFields"),L=l.querySelector("#query"),B=
l.querySelector("#preview");Array.isArray(n)||(m.style.fontStyle="italic",m.textContent="(wizard not available for objects, only for arrays)");(0,I.getChildPaths)(n).forEach(function(a){a=h(a);var c=document.createElement("option");c.text=a;c.value=a;t.appendChild(c);c=document.createElement("option");c.text=a;c.value=a;q.appendChild(c)});m=(0,I.getChildPaths)(n,!0).filter(function(a){return""!==a});if(0<m.length)m.forEach(function(a){a=h(a);var c=document.createElement("option");c.text=a;c.value=
a;A.appendChild(c)});else if(m=l.querySelector("#selectFieldsPart"))m.style.display="none";m=new (p())(t,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."});var D=new (p())(v,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"compare..."}),O=new (p())(q,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),J=new (p())(w,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"order..."}),G=new (p())(A,{multiple:!0,clearable:!0,defaultSelected:!1,
placeholder:"select fields..."});m.on("selectr.change",e);D.on("selectr.change",e);y.oninput=e;O.on("selectr.change",e);J.on("selectr.change",e);G.on("selectr.change",e);l.querySelector(".pico-modal-contents").onclick=function(a){"A"!==a.target.nodeName&&a.preventDefault()};var V=(0,I.debounce)(function(){try{var a=g(n,L.value);B.className="jsoneditor-transform-preview";for(var c=F.WF,b=2,C="";0<b--;)C+=" ";var k=x(a,C,"",c);var f=k.length>c?("number"===typeof c?k.slice(0,c):k)+"...":k;B.value=f;
r.disabled=!1}catch(E){B.className="jsoneditor-transform-preview jsoneditor-error",B.value=E.toString(),r.disabled=!0}},300);L.oninput=V;r.onclick=function(b){b.preventDefault();b.stopPropagation();c.close();a(L.value)};d(n,{});setTimeout(function(){L.select();L.focus();L.selectionStart=3;L.selectionEnd=3})}).afterClose(function(a){a.destroy()}).show()}d.r(n);d.d(n,{showTransformModal:function(){return e}});w=d(483);var A=d.n(w);w=d(879);var p=d.n(w),l=d(907),I=d(791),F=d(188),t='Enter a <a href="http://jmespath.org" target="_blank">JMESPath</a> query to filter, sort, or transform the JSON data.<br/>To learn JMESPath, go to <a href="http://jmespath.org/tutorial.html" target="_blank">the interactive tutorial</a>.'},
956:function(w,n,d){function r(a,b){if(!b)return Promise.resolve([]);try{var c=b(a);return((0,g.isPromise)(c)?c:Promise.resolve(c)).then(function(a){return Array.isArray(a)?a.filter(function(a){var c=(0,g.isValidValidationError)(a);c||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',a);return c}).map(function(a){return{dataPath:(0,g.stringifyPath)(a.path),message:a.message,type:"customValidation"}}):[]})}catch(M){return Promise.reject(M)}}
function x(a){"@babel/helpers - typeof";x="function"===typeof Symbol&&"symbol"===typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&"function"===typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?"symbol":typeof a};return x(a)}function e(){try{this.format()}catch(c){}}d.r(n);d.d(n,{textModeMixins:function(){return a}});w=d(664);var A=d.n(w);w=d(170);var p=d.n(w),l=d(188),I=d(436),F=d(474),t=d(907),D=d(56),G=d(617),J=d(210),v=d(558),b=d(49),g=d(791);d={create:function(a){var c=
this,d=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};"undefined"===typeof d.statusBar&&(d.statusBar=!0);d.mainMenuBar=!1!==d.mainMenuBar;d.enableSort=!1!==d.enableSort;d.enableTransform=!1!==d.enableTransform;d.createQuery=d.createQuery||D.r;d.executeQuery=d.executeQuery||D.J;this.options=d;this.indentation="number"===typeof d.indentation?Number(d.indentation):2;(0,t.cC)(this.options.languages);(0,t.m0)(this.options.language);var e=d.ace?d.ace:p();this.mode="code"===d.mode?"code":"text";
"code"===this.mode&&"undefined"===typeof e&&(this.mode="text",console.warn("Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`."));this.theme=d.theme||"ace/theme/jsoneditor";"ace/theme/jsoneditor"===this.theme&&e&&(0,b.O)();if(d.onTextSelectionChange)this.onTextSelectionChange(d.onTextSelectionChange);var l=this;this.container=a;this.dom={};this.textarea=this.aceEditor=void 0;this.validateSchema=
null;this.annotations=[];this.lastSchemaErrors=void 0;this._debouncedValidate=(0,g.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL);this.width=a.clientWidth;this.height=a.clientHeight;this.frame=document.createElement("div");this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode;this.frame.onclick=function(a){a.preventDefault()};this.frame.onkeydown=function(a){l._onKeyDown(a)};this.frameFocusTracker=new F.R({target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||
null});this.content=document.createElement("div");this.content.className="jsoneditor-outer";if(this.options.mainMenuBar){(0,g.addClassName)(this.content,"has-main-menu-bar");this.menu=document.createElement("div");this.menu.className="jsoneditor-menu";this.frame.appendChild(this.menu);var m=document.createElement("button");m.type="button";m.className="jsoneditor-format";m.title=(0,t.Iu)("formatTitle");this.menu.appendChild(m);m.onclick=function(){try{l.format(),l._onChange()}catch(y){l._onError(y)}};
m=document.createElement("button");m.type="button";m.className="jsoneditor-compact";m.title=(0,t.Iu)("compactTitle");this.menu.appendChild(m);m.onclick=function(){try{l.compact(),l._onChange()}catch(y){l._onError(y)}};this.options.enableSort&&(m=document.createElement("button"),m.type="button",m.className="jsoneditor-sort",m.title=(0,t.Iu)("sortTitleShort"),m.onclick=function(){l._showSortModal()},this.menu.appendChild(m));this.options.enableTransform&&(m=document.createElement("button"),m.type="button",
m.title=(0,t.Iu)("transformTitleShort"),m.className="jsoneditor-transform",m.onclick=function(){l._showTransformModal()},this.menu.appendChild(m));m=document.createElement("button");m.type="button";m.className="jsoneditor-repair";m.title=(0,t.Iu)("repairTitle");this.menu.appendChild(m);m.onclick=function(){try{l.repair(),l._onChange()}catch(y){l._onError(y)}};"code"===this.mode&&(m=document.createElement("button"),m.type="button",m.className="jsoneditor-undo jsoneditor-separator",m.title=(0,t.Iu)("undo"),
m.onclick=function(){c.aceEditor.getSession().getUndoManager().undo()},this.menu.appendChild(m),this.dom.undo=m,m=document.createElement("button"),m.type="button",m.className="jsoneditor-redo",m.title=(0,t.Iu)("redo"),m.onclick=function(){c.aceEditor.getSession().getUndoManager().redo()},this.menu.appendChild(m),this.dom.redo=m);this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new G.x(this.menu,this.options.modes,this.options.mode,function(a){l.setMode(a);l.modeSwitcher.focus()}));
if("code"===this.mode){var n=document.createElement("a");n.appendChild(document.createTextNode("powered by ace"));n.href="https://ace.c9.io/";n.target="_blank";n.className="jsoneditor-poweredBy";n.onclick=function(){window.open(n.href,n.target,"noopener")};this.menu.appendChild(n)}}m={};m=this.options.onEditable&&x("function"===this.options.onEditable)&&!this.options.onEditable(m);this.frame.appendChild(this.content);this.container.appendChild(this.frame);if("code"===this.mode){this.editorDom=document.createElement("div");
this.editorDom.style.height="100%";this.editorDom.style.width="100%";this.content.appendChild(this.editorDom);e=e.edit(this.editorDom);var r=e.getSession();e.$blockScrolling=Infinity;e.setTheme(this.theme);e.setOptions({readOnly:m});e.setShowPrintMargin(!1);e.setFontSize("13px");r.setMode("ace/mode/json");r.setTabSize(this.indentation);r.setUseSoftTabs(!0);r.setUseWrapMode(!0);var v=r.setAnnotations;r.setAnnotations=function(a){v.call(this,a&&a.length?a:l.annotations)};e.commands.bindKey("Ctrl-L",
null);e.commands.bindKey("Command-L",null);e.commands.bindKey("Ctrl-\\",null);e.commands.bindKey("Command-\\",null);e.commands.bindKey("Ctrl-Shift-\\",null);e.commands.bindKey("Command-Shift-\\",null);this.aceEditor=e;e.on("change",this._onChange.bind(this));e.on("changeSelection",this._onSelect.bind(this))}else e=document.createElement("textarea"),e.className="jsoneditor-text",e.spellcheck=!1,this.content.appendChild(e),this.textarea=e,this.textarea.readOnly=m,null===this.textarea.oninput?this.textarea.oninput=
this._onChange.bind(this):this.textarea.onchange=this._onChange.bind(this),e.onselect=this._onSelect.bind(this),e.onmousedown=this._onMouseDown.bind(this),e.onblur=this._onBlur.bind(this);this._updateHistoryButtons();this.errorTable=new I.Q({errorTableVisible:"text"===this.mode,onToggleVisibility:function(){l.validate()},onFocusLine:function(a){l.isFocused=!0;isNaN(a)||l.setTextSelection({row:a,column:1},{row:a,column:1E3})},onChangeHeight:function(a){a=a+(l.dom.statusBar?l.dom.statusBar.clientHeight:
0)+1;l.content.style.marginBottom=-a+"px";l.content.style.paddingBottom=a+"px"}});this.frame.appendChild(this.errorTable.getErrorTable());d.statusBar&&((0,g.addClassName)(this.content,"has-status-bar"),this.curserInfoElements={},d=document.createElement("div"),this.dom.statusBar=d,d.className="jsoneditor-statusbar",this.frame.appendChild(d),m=document.createElement("span"),m.className="jsoneditor-curserinfo-label",m.innerText="Ln:",e=document.createElement("span"),e.className="jsoneditor-curserinfo-val",
e.innerText="1",d.appendChild(m),d.appendChild(e),m=document.createElement("span"),m.className="jsoneditor-curserinfo-label",m.innerText="Col:",r=document.createElement("span"),r.className="jsoneditor-curserinfo-val",r.innerText="1",d.appendChild(m),d.appendChild(r),this.curserInfoElements.colVal=r,this.curserInfoElements.lnVal=e,e=document.createElement("span"),e.className="jsoneditor-curserinfo-label",e.innerText="characters selected",e.style.display="none",m=document.createElement("span"),m.className=
"jsoneditor-curserinfo-count",m.innerText="0",m.style.display="none",this.curserInfoElements.countLabel=e,this.curserInfoElements.countVal=m,d.appendChild(m),d.appendChild(e),d.appendChild(this.errorTable.getErrorCounter()),d.appendChild(this.errorTable.getWarningIcon()),d.appendChild(this.errorTable.getErrorIcon()));this.setSchema(this.options.schema,this.options.schemaRefs)},_onChange:function(){var a=this;if(!this.onChangeDisabled){setTimeout(function(){return a._updateHistoryButtons()});this._debouncedValidate();
if(this.options.onChange)try{this.options.onChange()}catch(h){console.error("Error in onChange callback: ",h)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(h){console.error("Error in onChangeText callback: ",h)}}},_updateHistoryButtons:function(){if(this.aceEditor&&this.dom.undo&&this.dom.redo){var a=this.aceEditor.getSession().getUndoManager();a&&a.hasUndo&&a.hasRedo&&(this.dom.undo.disabled=!a.hasUndo(),this.dom.redo.disabled=!a.hasRedo())}},_showSortModal:function(){var a=
this,b=this.options.modalAnchor||l.qD,d=this.get();(0,J.showSortModal)(b,d,function(c){if(Array.isArray(d)){var b=(0,g.sort)(d,c.path,c.direction);a.sortedBy=c;a.update(b)}(0,g.isObject)(d)&&(b=(0,g.sortObjectKeys)(d,c.direction),a.sortedBy=c,a.update(b))},a.sortedBy)},_showTransformModal:function(){var a=this,b=this.options,d=b.modalAnchor,e=b.createQuery,g=b.executeQuery;b=b.queryDescription;var m=this.get();(0,v.showTransformModal)({container:d||l.qD,json:m,queryDescription:b,createQuery:e,executeQuery:g,
onTransform:function(c){c=g(m,c);a.update(c)}})},_onSelect:function(){this._updateCursorInfo();this._emitSelectionChange()},_onKeyDown:function(a){var c=!1;73===(a.which||a.keyCode)&&a.ctrlKey&&(a.shiftKey?this.compact():this.format(),this._onChange(),c=!0);c&&(a.preventDefault(),a.stopPropagation());this._updateCursorInfo();this._emitSelectionChange()},_onMouseDown:function(){this._updateCursorInfo();this._emitSelectionChange()},_onBlur:function(){var a=this;setTimeout(function(){a.isFocused||(a._updateCursorInfo(),
a._emitSelectionChange());a.isFocused=!1})},_updateCursorInfo:function(){function a(){b.curserInfoElements.countVal.innerText!==p&&(b.curserInfoElements.countVal.innerText=p,b.curserInfoElements.countVal.style.display=p?"inline":"none",b.curserInfoElements.countLabel.style.display=p?"inline":"none");b.curserInfoElements.lnVal.innerText=l;b.curserInfoElements.colVal.innerText=m}var b=this;if(this.textarea)setTimeout(function(){var c=(0,g.getInputSelection)(b.textarea);c.startIndex!==c.endIndex&&(p=
c.endIndex-c.startIndex);p&&b.cursorInfo&&b.cursorInfo.line===c.end.row&&b.cursorInfo.column===c.end.column?(l=c.start.row,m=c.start.column):(l=c.end.row,m=c.end.column);b.cursorInfo={line:l,column:m,count:p};b.options.statusBar&&a()},0);else if(this.aceEditor&&this.curserInfoElements){var d=this.aceEditor.getCursorPosition(),e=this.aceEditor.getSelectedText();var l=d.row+1;var m=d.column+1;var p=e.length;b.cursorInfo={line:l,column:m,count:p};this.options.statusBar&&a()}},_emitSelectionChange:function(){if(this._selectionChangedHandler){var a=
this.getTextSelection();this._selectionChangedHandler(a.start,a.end,a.text)}},_refreshAnnotations:function(){var a=this.aceEditor&&this.aceEditor.getSession();if(a){var b=a.getAnnotations().filter(function(a){return"error"===a.type});a.setAnnotations(b)}},destroy:function(){this.aceEditor&&(this.aceEditor.destroy(),this.aceEditor=null);this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame);this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=
null);this._debouncedValidate=this.textarea=null;this.frameFocusTracker.destroy()},compact:function(){var a=this.get();a=JSON.stringify(a);this.updateText(a)},format:function(){var a=this.get();a=JSON.stringify(a,null,this.indentation);this.updateText(a)},repair:function(){var a=this.getText();try{var b=A()(a);this.updateText(b)}catch(u){}},focus:function(){this.textarea&&this.textarea.focus();this.aceEditor&&this.aceEditor.focus()},resize:function(){this.aceEditor&&this.aceEditor.resize(!1)},set:function(a){this.setText(JSON.stringify(a,
null,this.indentation))},update:function(a){this.updateText(JSON.stringify(a,null,this.indentation))},get:function(){var a=this.getText();return(0,g.parse)(a)},getText:function(){return this.textarea?this.textarea.value:this.aceEditor?this.aceEditor.getValue():""},_setText:function(a,b){var c=this;a=!0===this.options.escapeUnicode?(0,g.escapeUnicodeChars)(a):a;this.textarea&&(this.textarea.value=a);if(this.aceEditor){this.onChangeDisabled=!0;this.aceEditor.setValue(a,-1);this.onChangeDisabled=!1;
if(b){var d=this;setTimeout(function(){d.aceEditor&&d.aceEditor.session.getUndoManager().reset()})}setTimeout(function(){return c._updateHistoryButtons()})}this._debouncedValidate()},setText:function(a){this._setText(a,!0)},updateText:function(a){this.getText()!==a&&this._setText(a,!1)},validate:function(){var a=this,b=[],d=[];try{var e=this.get();this.validateSchema&&(this.validateSchema(e)||(b=this.validateSchema.errors.map(function(a){a.type="validation";return(0,g.improveSchemaError)(a)})));this.validationSequence=
(this.validationSequence||0)+1;var l=this,m=this.validationSequence;r(e,this.options.onValidate).then(function(c){m===l.validationSequence&&(c=b.concat(d).concat(c),l._renderErrors(c),"function"===typeof a.options.onValidationError&&((0,g.isValidationErrorChanged)(c,a.lastSchemaErrors)&&a.options.onValidationError.call(a,c),a.lastSchemaErrors=c))})["catch"](function(a){console.error("Custom validation function did throw an error",a)})}catch(K){if(this.getText()){e=/\w*line\s*(\d+)\w*/g.exec(K.message);
var p;e&&(p=+e[1]);d=[{type:"error",message:K.message.replace(/\n/g,"<br>"),line:p}]}this._renderErrors(d);"function"===typeof this.options.onValidationError&&((0,g.isValidationErrorChanged)(d,this.lastSchemaErrors)&&this.options.onValidationError.call(this,d),this.lastSchemaErrors=d)}},_renderErrors:function(a){var b=this.getText(),c=[];a.reduce(function(a,b){"string"===typeof b.dataPath&&-1===a.indexOf(b.dataPath)&&a.push(b.dataPath);return a},c);b=(0,g.getPositionForPath)(b,c);this.aceEditor&&
(this.annotations=b.map(function(b){var c=a.filter(function(a){return a.dataPath===b.path}),d=c.map(function(a){return a.message}).join("\n");return d?{row:b.line,column:b.column,text:"Schema validation error"+(1!==c.length?"s":"")+": \n"+d,type:"warning",source:"jsoneditor"}:{}}),this._refreshAnnotations());this.errorTable.setErrors(a,b);this.aceEditor&&this.aceEditor.resize(!1)},getTextSelection:function(){var a={};if(this.textarea){var b=(0,g.getInputSelection)(this.textarea);this.cursorInfo&&
this.cursorInfo.line===b.end.row&&this.cursorInfo.column===b.end.column?(a.start=b.end,a.end=b.start):a=b;return{start:a.start,end:a.end,text:this.textarea.value.substring(b.startIndex,b.endIndex)}}if(this.aceEditor){var d=this.aceEditor.getSelection();b=this.aceEditor.getSelectedText();var e=d.getRange();d=d.getSelectionLead();d.row===e.end.row&&d.column===e.end.column?a=e:(a.start=e.end,a.end=e.start);return{start:{row:a.start.row+1,column:a.start.column+1},end:{row:a.end.row+1,column:a.end.column+
1},text:b}}},onTextSelectionChange:function(a){"function"===typeof a&&(this._selectionChangedHandler=(0,g.debounce)(a,this.DEBOUNCE_INTERVAL))},setTextSelection:function(a,b){if(a&&b)if(this.textarea){var c=(0,g.getIndexForPosition)(this.textarea,a.row,a.column);b=(0,g.getIndexForPosition)(this.textarea,b.row,b.column);if(-1<c&&-1<b){if(this.textarea.setSelectionRange)this.textarea.focus(),this.textarea.setSelectionRange(c,b);else if(this.textarea.createTextRange){var d=this.textarea.createTextRange();
d.collapse(!0);d.moveEnd("character",b);d.moveStart("character",c);d.select()}c=(this.textarea.value.match(/\n/g)||[]).length+1;a=this.textarea.scrollHeight/c*a.row;this.textarea.scrollTop=a>this.textarea.clientHeight?a-this.textarea.clientHeight/2:0}}else this.aceEditor&&(this.aceEditor.selection.setRange({start:{row:a.row-1,column:a.column-1},end:{row:b.row-1,column:b.column-1}}),this.aceEditor.scrollToLine(a.row-1,!0))}};var a=[{mode:"text",mixin:d,data:"text",load:e},{mode:"code",mixin:d,data:"text",
load:e}]},38:function(w,n,d){function r(a){function k(a){if(document.createRange){var k=document.createRange();k.selectNodeContents(a);k.collapse(!1);a=window.getSelection();a.removeAllRanges();a.addRange(k)}else document.selection&&(k=document.body.createTextRange(),k.moveToElementText(a),k.collapse(!1),k.select())}function f(a){void 0===e&&(e=document.createElement("span"),e.style.visibility="hidden",e.style.position="fixed",e.style.outline="0",e.style.margin="0",e.style.padding="0",e.style.border=
"0",e.style.left="0",e.style.whiteSpace="pre",e.style.fontSize=b,e.style.fontFamily=c,e.style.fontWeight="normal",document.body.appendChild(e));e.textContent=a;return e.getBoundingClientRect().right}a=a||{};a.filter=a.filter||"start";a.trigger=a.trigger||"keydown";a.confirmKeys=a.confirmKeys||[39,35,9];a.caseSensitive=a.caseSensitive||!1;var b="",c="",d=document.createElement("div");d.style.position="relative";d.style.outline="0";d.style.border="0";d.style.margin="0";d.style.padding="0";var C=document.createElement("div");
C.className="autocomplete dropdown";C.style.position="absolute";C.style.visibility="hidden";var e,g,u={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},startFrom:0,options:[],element:null,elementHint:null,elementStyle:null,wrapper:d,show:function(a,k,f){var E=this;this.startFrom=k;this.wrapper.remove();this.elementHint&&(this.elementHint.remove(),this.elementHint=null);""===b&&(b=window.getComputedStyle(a).getPropertyValue("font-size"));""===c&&(c=window.getComputedStyle(a).getPropertyValue("font-family"));
C.style.marginLeft="0";C.style.marginTop=a.getBoundingClientRect().height+"px";this.options=f.map(String);this.element!==a&&(this.element=a,this.elementStyle={zIndex:this.element.style.zIndex,position:this.element.style.position,backgroundColor:this.element.style.backgroundColor,borderColor:this.element.style.borderColor});this.element.style.zIndex=3;this.element.style.position="relative";this.element.style.backgroundColor="transparent";this.element.style.borderColor="transparent";this.elementHint=
a.cloneNode();this.elementHint.className="autocomplete hint";this.elementHint.style.zIndex=2;this.elementHint.style.position="absolute";this.elementHint.onfocus=function(){E.element.focus()};this.element.addEventListener&&(this.element.removeEventListener("keydown",m),this.element.addEventListener("keydown",m,!1),this.element.removeEventListener("blur",p),this.element.addEventListener("blur",p,!1));d.appendChild(this.elementHint);d.appendChild(C);a.parentElement.appendChild(d);this.repaint(a)},setText:function(a){this.element.innerText=
a},getText:function(){return this.element.innerText},hideDropDown:function(){this.wrapper.remove();this.elementHint&&(this.elementHint.remove(),this.elementHint=null,l.hide(),this.element.style.zIndex=this.elementStyle.zIndex,this.element.style.position=this.elementStyle.position,this.element.style.backgroundColor=this.elementStyle.backgroundColor,this.element.style.borderColor=this.elementStyle.borderColor)},repaint:function(k){var b=k.innerText;b=b.replace("\n","");k=this.options.length;var E=b.substring(this.startFrom);
g=b.substring(0,this.startFrom);for(b=0;b<k;b++){var c=this.options[b];if(!a.caseSensitive&&0===c.toLowerCase().indexOf(E.toLowerCase())||a.caseSensitive&&0===c.indexOf(E)){this.elementHint.innerText=g+E+c.substring(E.length);this.elementHint.realInnerText=g+c;break}}C.style.left=f(g)+"px";l.refresh(E,this.options);this.elementHint.style.width=f(this.elementHint.innerText)+10+"px";"hidden"!==C.style.visibility&&(this.elementHint.style.width=f(this.elementHint.innerText)+C.clientWidth+"px")}},l=function(k,
f){var b=[],E=0,c=-1,d=function(){this.style.backgroundColor="#ddd"},C=function(){this.style.backgroundColor=""},e=function(){T.hide();T.onmouseselection(this.__hint,T.rs)},T={rs:f,hide:function(){k.style.visibility="hidden"},refresh:function(f,c){k.style.visibility="hidden";E=0;k.textContent="";var g=window.innerHeight||document.documentElement.clientHeight,ia=k.parentNode.getBoundingClientRect(),u=ia.top-6;g=g-ia.bottom-6;b=[];var la="function"===typeof a.filter?a.filter:h[a.filter];b=(la?c.filter(function(k){return la(a.caseSensitive?
f:f.toLowerCase(),a.caseSensitive?k:k.toLowerCase(),a)}):[]).map(function(a){var b=document.createElement("div");b.className="item";b.onmouseover=d;b.onmouseout=C;b.onmousedown=e;b.__hint=a;b.textContent="";b.appendChild(document.createTextNode(a.substring(0,f.length)));var E=document.createElement("b");E.appendChild(document.createTextNode(a.substring(f.length)));b.appendChild(E);k.appendChild(b);return b});0===b.length||1===b.length&&(f.toLowerCase()===b[0].__hint.toLowerCase()&&!a.caseSensitive||
f===b[0].__hint&&a.caseSensitive)||2>b.length||(T.highlight(0),u>3*g?(k.style.maxHeight=u+"px",k.style.top="",k.style.bottom="100%"):(k.style.top="100%",k.style.bottom="",k.style.maxHeight=g+"px"),k.style.visibility="visible")},highlight:function(a){-1!==c&&b[c]&&(b[c].className="item");b[a].className="item hover";c=a},move:function(a){if("hidden"===k.style.visibility)return"";if(-1===E+a||E+a===b.length)return b[E].__hint;E+=a;T.highlight(E);return b[E].__hint},onmouseselection:function(){}};return T}(C,
u),m=function(f){f=f||window.event;var b=f.keyCode;if(null!=this.elementHint&&33!==b&&34!==b)if(27===b)u.hideDropDown(),u.element.focus(),f.preventDefault(),f.stopPropagation();else{var E=this.element.innerText;E=E.replace("\n","");if(0<=a.confirmKeys.indexOf(b)){if(9===b&&0===this.elementHint.innerText.length)u.onTab();0<this.elementHint.innerText.length&&this.element.innerText!==this.elementHint.realInnerText&&(this.element.innerText=this.elementHint.realInnerText,u.hideDropDown(),k(this.element),
9===b&&(u.element.focus(),f.preventDefault(),f.stopPropagation()))}else if(13===b)if(0===this.elementHint.innerText.length)u.onEnter();else b="hidden"===C.style.visibility,l.hide(),b?(u.hideDropDown(),u.element.focus(),u.onEnter()):(this.element.innerText=this.elementHint.realInnerText,u.hideDropDown(),k(this.element),f.preventDefault(),f.stopPropagation());else if(40===b){b=E.substring(this.startFrom);E=l.move(1);if(""===E)u.onArrowDown();this.elementHint.innerText=g+b+E.substring(b.length);this.elementHint.realInnerText=
g+E;f.preventDefault();f.stopPropagation()}else if(38===b){b=E.substring(this.startFrom);E=l.move(-1);if(""===E)u.onArrowUp();this.elementHint.innerText=g+b+E.substring(b.length);this.elementHint.realInnerText=g+E;f.preventDefault();f.stopPropagation()}}}.bind(u),p=function(a){u.hideDropDown()};l.onmouseselection=function(a,f){f.element.innerText=f.elementHint.innerText=g+a;f.hideDropDown();window.setTimeout(function(){f.element.focus();k(f.element)},1)};return u}function x(a,k){for(var f=0;f<k.length;f++){var b=
k[f];b.enumerable=b.enumerable||!1;b.configurable=!0;"value"in b&&(b.writable=!0);Object.defineProperty(a,b.key,b)}}function e(a,k,f){k&&x(a.prototype,k);f&&x(a,f);return a}function A(a,k){var f;if("undefined"===typeof Symbol||null==a[Symbol.iterator]){if(Array.isArray(a)||(f=p(a))||k&&a&&"number"===typeof a.length){f&&(a=f);var b=0;k=function(){};return{s:k,n:function(){return b>=a.length?{done:!0}:{done:!1,value:a[b++]}},e:function(a){throw a;},f:k}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}var c=!0,d=!1,C;return{s:function(){f=a[Symbol.iterator]()},n:function(){var a=f.next();c=a.done;return a},e:function(a){d=!0;C=a},f:function(){try{if(!c&&null!=f["return"])f["return"]()}finally{if(d)throw C;}}}}function p(a,k){if(a){if("string"===typeof a)return l(a,k);var f=Object.prototype.toString.call(a).slice(8,-1);"Object"===f&&a.constructor&&(f=a.constructor.name);if("Map"===f||"Set"===f)return Array.from(a);if("Arguments"===f||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(f))return l(a,
k)}}function l(a,k){if(null==k||k>a.length)k=a.length;for(var f=0,b=Array(k);f<k;f++)b[f]=a[f];return b}function I(a){"@babel/helpers - typeof";I="function"===typeof Symbol&&"symbol"===typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&"function"===typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?"symbol":typeof a};return I(a)}function F(a,k){for(var f=0;f<k.length;f++){var b=k[f];b.enumerable=b.enumerable||!1;b.configurable=!0;"value"in b&&(b.writable=!0);Object.defineProperty(a,
b.key,b)}}function t(a,k,f){k&&F(a.prototype,k);f&&F(a,f);return a}function D(a){return a.getInternalPath()}function G(a){return a.getField()}function J(a,k){for(var f=0;f<k.length;f++){var b=k[f];b.enumerable=b.enumerable||!1;b.configurable=!0;"value"in b&&(b.writable=!0);Object.defineProperty(a,b.key,b)}}function v(a,k,f){k&&J(a.prototype,k);f&&J(a,f);return a}function b(a,k){for(var f=0;f<k.length;f++){var b=k[f];b.enumerable=b.enumerable||!1;b.configurable=!0;"value"in b&&(b.writable=!0);Object.defineProperty(a,
b.key,b)}}function g(a,k,f){k&&b(a.prototype,k);f&&b(a,f);return a}function a(a,k){for(var f=0;f<k.length;f++){var b=k[f];b.enumerable=b.enumerable||!1;b.configurable=!0;"value"in b&&(b.writable=!0);Object.defineProperty(a,b.key,b)}}function c(b,k,f){k&&a(b.prototype,k);f&&a(b,f);return b}d.r(n);d.d(n,{treeModeMixins:function(){return W}});var h={start:function(a,k,f){return 0===k.indexOf(a)},contain:function(a,k,f){return-1<k.indexOf(a)}},u=d(897),M=d(474),S=function(){function a(){if(!(this instanceof
a))throw new TypeError("Cannot call a class as a function");this.locked=!1}e(a,[{key:"highlight",value:function(a){this.locked||(this.node!==a&&(this.node&&this.node.setHighlight(!1),this.node=a,this.node.setHighlight(!0)),this._cancelUnhighlight())}},{key:"unhighlight",value:function(){if(!this.locked){var a=this;this.node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){a.node.setHighlight(!1);a.node=void 0;a.unhighlightTimer=void 0},0))}}},{key:"_cancelUnhighlight",value:function(){this.unhighlightTimer&&
(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)}},{key:"lock",value:function(){this.locked=!0}},{key:"unlock",value:function(){this.locked=!1}}]);return a}(),m=d(907),H=d(56),K=d(617);w=d(233);var z=d.n(w),y=d(602),q=d(791),P=d(210),aa=d(558),L=d(188),B=function(){function a(k,f){if(!(this instanceof a))throw new TypeError("Cannot call a class as a function");this.editor=k;this.dom={};this.expanded=!1;f&&f instanceof Object?(this.setField(f.field,f.fieldEditable),"value"in f&&this.setValue(f.value,
f.type),"internalValue"in f&&this.setInternalValue(f.internalValue)):(this.setField(""),this.setValue(null));this._debouncedOnChangeValue=(0,q.debounce)(this._onChangeValue.bind(this),a.prototype.DEBOUNCE_INTERVAL);this._debouncedOnChangeField=(0,q.debounce)(this._onChangeField.bind(this),a.prototype.DEBOUNCE_INTERVAL);this.visibleChilds=this.getMaxVisibleChilds()}t(a,[{key:"getMaxVisibleChilds",value:function(){return this.editor&&this.editor.options&&this.editor.options.maxVisibleChilds?this.editor.options.maxVisibleChilds:
ba}},{key:"_updateEditability",value:function(){this.editable={field:!0,value:!0};if(this.editor&&(this.editable.field="tree"===this.editor.options.mode,this.editable.value="view"!==this.editor.options.mode,("tree"===this.editor.options.mode||"form"===this.editor.options.mode)&&"function"===typeof this.editor.options.onEditable)){var a=this.editor.options.onEditable({field:this.field,value:this.value,path:this.getPath()});"boolean"===typeof a?(this.editable.field=a,this.editable.value=a):"object"===
I(a)&&null!==a?("boolean"===typeof a.field&&(this.editable.field=a.field),"boolean"===typeof a.value&&(this.editable.value=a.value)):(console.error("Invalid return value for function onEditable.","Actual value:",a,".","Either a boolean or object { field: boolean, value: boolean } expected."),this.editable.field=!1,this.editable.value=!1)}}},{key:"getPath",value:function(){for(var a=this,f=[];a;){var b=a.getName();void 0!==b&&f.unshift(b);a=a.parent}return f}},{key:"getInternalPath",value:function(){for(var a=
this,f=[];a;)a.parent&&f.unshift(a.getIndex()),a=a.parent;return f}},{key:"getName",value:function(){return this.parent?"array"!==this.parent.type?this.field:this.index:void 0}},{key:"findNodeByPath",value:function(a){if(a){if(0===a.length)return this;if(a.length&&this.childs&&this.childs.length)for(var f=0;f<this.childs.length;++f)if(""+a[0]===""+this.childs[f].getName())return this.childs[f].findNodeByPath(a.slice(1))}}},{key:"findNodeByInternalPath",value:function(a){if(a){for(var f=this,k=0;k<
a.length&&f;k++)f=f.childs[a[k]];return f}}},{key:"serialize",value:function(){return{value:this.getValue(),path:this.getPath()}}},{key:"findNode",value:function(a){var f=(0,q.parsePath)(a),k=this;for(a=function(){var a=f.shift();if("number"===typeof a){if("array"!==k.type)throw Error("Cannot get child node at index "+a+": node is no array");k=k.childs[a]}else{if("object"!==k.type)throw Error("Cannot get child node "+a+": node is no object");k=k.childs.filter(function(k){return k.field===a})[0]}};k&&
0<f.length;)a();return k}},{key:"findParents",value:function(){for(var a=[],f=this.parent;f;)a.unshift(f),f=f.parent;return a}},{key:"setError",value:function(a,f){this.error=a;this.errorChild=f;this.dom&&this.dom.tr&&this.updateError()}},{key:"updateError",value:function(){var a=this,f=this.fieldError||this.valueError||this.error,b=this.dom.tdError;if(f&&this.dom&&this.dom.tr){(0,q.addClassName)(this.dom.tr,"jsoneditor-validation-error");b||(b=document.createElement("td"),this.dom.tdError=b,this.dom.tdValue.parentNode.appendChild(b));
var c=document.createElement("button");c.type="button";c.className="jsoneditor-button jsoneditor-schema-error";var d=function(){delete a.dom.popupAnchor},e=function(k){var b=a.editor.frame;a.dom.popupAnchor=(0,y.w)(c,a.editor.getPopupAnchor(),d,k);k=c.getBoundingClientRect();b=120<b.getBoundingClientRect().width-k.x?"jsoneditor-above":"jsoneditor-left";k=document.createElement("div");k.className="jsoneditor-popover "+b;k.appendChild(document.createTextNode(f.message));a.dom.popupAnchor.appendChild(k)};
c.onmouseover=function(){a.dom.popupAnchor||e(!0)};c.onfocus=function(){a.dom.popupAnchor&&a.dom.popupAnchor.destroy();e(!1)};c.onblur=function(){a.dom.popupAnchor&&a.dom.popupAnchor.destroy()};var h=this.errorChild;h&&(c.onclick=function(){h.findParents().forEach(function(a){a.expand(!1)});h.scrollTo(function(){h.focus()})});for(;b.firstChild;)b.removeChild(b.firstChild);b.appendChild(c)}else this.dom.tr&&(0,q.removeClassName)(this.dom.tr,"jsoneditor-validation-error"),b&&(this.dom.tdError.parentNode.removeChild(this.dom.tdError),
delete this.dom.tdError)}},{key:"getIndex",value:function(){if(this.parent){var a=this.parent.childs.indexOf(this);return-1!==a?a:null}return-1}},{key:"setParent",value:function(a){this.parent=a}},{key:"setField",value:function(a,f){this.previousField=this.field=a;this.fieldEditable=!0===f}},{key:"getField",value:function(){void 0===this.field&&this._getDomField();return this.field}},{key:"setValue",value:function(k,f){var b=this.childs;this.type=this._getType(k);if(f&&f!==this.type)if("string"===
f&&"auto"===this.type)this.type=f;else throw Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+f+'"');if("array"===this.type){this.childs||(this.childs=[]);for(f=0;f<k.length;f++){var c=k[f];if(void 0!==c&&!(c instanceof Function))if(f<this.childs.length){var d=this.childs[f];d.fieldEditable=!1;d.index=f;d.setValue(c)}else d=new a(this.editor,{value:c}),c=f<this.getMaxVisibleChilds(),this.appendChild(d,c,!1)}for(f=this.childs.length;f>=k.length;f--)this.removeChild(this.childs[f],
!1)}else if("object"===this.type){this.childs||(this.childs=[]);for(f=this.childs.length-1;0<=f;f--)Object.prototype.hasOwnProperty.call(k,this.childs[f].field)||this.removeChild(this.childs[f],!1);f=0;for(d in k)if(Object.prototype.hasOwnProperty.call(k,d)){c=k[d];if(void 0!==c&&!(c instanceof Function)){var e=this.findChildByProperty(d);e?(e.setField(d,!0),e.setValue(c)):(c=new a(this.editor,{field:d,value:c}),e=f<this.getMaxVisibleChilds(),this.appendChild(c,e,!1))}f++}this.value="";!0===this.editor.options.sortObjectKeys&&
this.sort([],"asc",!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=k;Array.isArray(b)!==Array.isArray(this.childs)&&this.recreateDom();this.updateDom({updateIndexes:!0});this.previousValue=this.value}},{key:"setInternalValue",value:function(k){var f,b=this.childs;this.type=k.type;if("array"===k.type){this.childs||(this.childs=[]);for(f=0;f<k.childs.length;f++){var c=k.childs[f];if(void 0!==c&&!(c instanceof Function))if(f<this.childs.length){var d=
this.childs[f];d.fieldEditable=!1;d.index=f;d.setInternalValue(c)}else d=new a(this.editor,{internalValue:c}),c=f<this.getMaxVisibleChilds(),this.appendChild(d,c,!1)}for(d=this.childs.length;d>=k.childs.length;d--)this.removeChild(this.childs[d],!1)}else if("object"===k.type){this.childs||(this.childs=[]);for(f=0;f<k.childs.length;f++)c=k.childs[f],void 0===c||c instanceof Function||(f<this.childs.length?(d=this.childs[f],delete d.index,d.setField(c.field,!0),d.setInternalValue(c.value)):(d=new a(this.editor,
{field:c.field,internalValue:c.value}),c=f<this.getMaxVisibleChilds(),this.appendChild(d,c,!1)));for(d=this.childs.length;d>=k.childs.length;d--)this.removeChild(this.childs[d],!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=k.value;Array.isArray(b)!==Array.isArray(this.childs)&&this.recreateDom();this.updateDom({updateIndexes:!0});this.previousValue=this.value}},{key:"recreateDom",value:function(){if(this.dom&&this.dom.tr&&this.dom.tr.parentNode){var a=
this._detachFromDom();this.clearDom();this._attachToDom(a)}else this.clearDom()}},{key:"getValue",value:function(){if("array"===this.type){var a=[];this.childs.forEach(function(f){a.push(f.getValue())});return a}if("object"===this.type){var f={};this.childs.forEach(function(a){f[a.getField()]=a.getValue()});return f}void 0===this.value&&this._getDomValue();return this.value}},{key:"getInternalValue",value:function(){if("array"===this.type)return{type:this.type,childs:this.childs.map(function(a){return a.getInternalValue()})};
if("object"===this.type)return{type:this.type,childs:this.childs.map(function(a){return{field:a.getField(),value:a.getInternalValue()}})};void 0===this.value&&this._getDomValue();return{type:this.type,value:this.value}}},{key:"getLevel",value:function(){return this.parent?this.parent.getLevel()+1:0}},{key:"getNodePath",value:function(){var a=this.parent?this.parent.getNodePath():[];a.push(this);return a}},{key:"clone",value:function(){var k=new a(this.editor);k.type=this.type;k.field=this.field;k.fieldInnerText=
this.fieldInnerText;k.fieldEditable=this.fieldEditable;k.previousField=this.previousField;k.value=this.value;k.valueInnerText=this.valueInnerText;k.previousValue=this.previousValue;k.expanded=this.expanded;k.visibleChilds=this.visibleChilds;if(this.childs){var f=[];this.childs.forEach(function(a){a=a.clone();a.setParent(k);f.push(a)});k.childs=f}else k.childs=void 0;return k}},{key:"expand",value:function(a){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-expanded"),
this.showChilds(),!1!==a&&this.childs.forEach(function(f){f.expand(a)}),this.updateDom({recurse:!1}))}},{key:"collapse",value:function(a){this.childs&&(this.hideChilds(),!1!==a&&this.childs.forEach(function(f){f.collapse(a)}),this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-collapsed"),this.expanded=!1,this.updateDom({recurse:!1}))}},{key:"showChilds",value:function(){if(this.childs&&this.expanded){var a=this.dom.tr,f=a?a.parentNode:void 0;if(f){var b=this.getAppendDom();
b.parentNode||((a=a.nextSibling)?f.insertBefore(b,a):f.appendChild(b));b=Math.min(this.childs.length,this.visibleChilds);a=this._getNextTr();for(var c=0;c<b;c++){var d=this.childs[c];d.getDom().parentNode||f.insertBefore(d.getDom(),a);d.showChilds()}b=this.getShowMoreDom();a=this._getNextTr();b.parentNode||f.insertBefore(b,a);this.showMore.updateDom()}}}},{key:"_getNextTr",value:function(){if(this.showMore&&this.showMore.getDom().parentNode)return this.showMore.getDom();if(this.append&&this.append.getDom().parentNode)return this.append.getDom()}},
{key:"hide",value:function(a){var f=this.dom.tr,k=f?f.parentNode:void 0;k&&k.removeChild(f);this.dom.popupAnchor&&this.dom.popupAnchor.destroy();this.hideChilds(a)}},{key:"hideChilds",value:function(a){if(this.childs&&this.expanded){var f=this.getAppendDom();f.parentNode&&f.parentNode.removeChild(f);this.childs.forEach(function(a){a.hide()});f=this.getShowMoreDom();f.parentNode&&f.parentNode.removeChild(f);if(!a||a.resetVisibleChilds)this.visibleChilds=this.getMaxVisibleChilds()}}},{key:"_updateCssClassName",
value:function(){if(this.dom.field&&this.editor&&this.editor.options&&"function"===typeof this.editor.options.onClassName&&this.dom.tree){(0,q.removeAllClassNames)(this.dom.tree);var a=this.editor.options.onClassName({path:this.getPath(),field:this.field,value:this.value})||"";(0,q.addClassName)(this.dom.tree,"jsoneditor-values "+a)}}},{key:"recursivelyUpdateCssClassesOnNodes",value:function(){this._updateCssClassName();if(Array.isArray(this.childs))for(var a=0;a<this.childs.length;a++)this.childs[a].recursivelyUpdateCssClassesOnNodes()}},
{key:"expandTo",value:function(){for(var a=this.parent;a;)a.expanded||a.expand(),a=a.parent}},{key:"appendChild",value:function(a,f,b){if(this._hasChilds()){a.setParent(this);a.fieldEditable="object"===this.type;"array"===this.type&&(a.index=this.childs.length);"object"===this.type&&void 0===a.field&&a.setField("");this.childs.push(a);if(this.expanded&&!1!==f){f=a.getDom();var k=this._getNextTr(),c=k?k.parentNode:void 0;k&&c&&c.insertBefore(f,k);a.showChilds();this.visibleChilds++}!1!==b&&(this.updateDom({updateIndexes:!0}),
a.updateDom({recurse:!0}))}}},{key:"moveBefore",value:function(a,f,b){if(this._hasChilds()){var k=this.dom.tr?this.dom.tr.parentNode:void 0;if(k){var c=document.createElement("tr");c.style.height=k.clientHeight+"px";k.appendChild(c)}a.parent&&a.parent.removeChild(a);f instanceof O||!f?this.childs.length+1>this.visibleChilds?this.insertBefore(a,this.childs[this.visibleChilds-1],b):this.appendChild(a,!0,b):this.insertBefore(a,f,b);k&&c&&k.removeChild(c)}}},{key:"insertBefore",value:function(a,f,b){if(this._hasChilds()){this.visibleChilds++;
"object"===this.type&&void 0===a.field&&a.setField("");if(f===this.append)a.setParent(this),a.fieldEditable="object"===this.type,this.childs.push(a);else{var k=this.childs.indexOf(f);if(-1===k)throw Error("Node not found");a.setParent(this);a.fieldEditable="object"===this.type;this.childs.splice(k,0,a)}if(this.expanded){k=a.getDom();var c=(f=f.getDom())?f.parentNode:void 0;f&&c&&c.insertBefore(k,f);a.showChilds();this.showChilds()}!1!==b&&(this.updateDom({updateIndexes:!0}),a.updateDom({recurse:!0}))}}},
{key:"insertAfter",value:function(a,f){this._hasChilds()&&(f=this.childs.indexOf(f),(f=this.childs[f+1])?this.insertBefore(a,f):this.appendChild(a))}},{key:"search",value:function(a,f){Array.isArray(f)||(f=[]);var b=a?a.toLowerCase():void 0;delete this.searchField;delete this.searchValue;if(void 0!==this.field&&f.length<=this.MAX_SEARCH_RESULTS){var k=String(this.field).toLowerCase().indexOf(b);-1!==k&&(this.searchField=!0,f.push({node:this,elem:"field"}));this._updateDomField()}this._hasChilds()?
this.childs&&this.childs.forEach(function(b){b.search(a,f)}):void 0!==this.value&&f.length<=this.MAX_SEARCH_RESULTS&&(k=String(this.value).toLowerCase().indexOf(b),-1!==k&&(this.searchValue=!0,f.push({node:this,elem:"value"})),this._updateDomValue());return f}},{key:"scrollTo",value:function(a){this.expandPathToNode();this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,a)}},{key:"expandPathToNode",value:function(){for(var a=this;a&&a.parent;){for(var f="array"===a.parent.type?
a.index:a.parent.childs.indexOf(a);a.parent.visibleChilds<f+1;)a.parent.visibleChilds+=this.getMaxVisibleChilds();a.parent.expand(!1);a=a.parent}}},{key:"focus",value:function(b){a.focusElement=b;if(this.dom.tr&&this.dom.tr.parentNode){var f=this.dom;switch(b){case "drag":f.drag?f.drag.focus():f.menu.focus();break;case "menu":f.menu.focus();break;case "expand":this._hasChilds()?f.expand.focus():f.field&&this.fieldEditable?(f.field.focus(),(0,q.selectContentEditable)(f.field)):f.value&&!this._hasChilds()?
(f.value.focus(),(0,q.selectContentEditable)(f.value)):f.menu.focus();break;case "field":f.field&&this.fieldEditable?(f.field.focus(),(0,q.selectContentEditable)(f.field)):f.value&&!this._hasChilds()?(f.value.focus(),(0,q.selectContentEditable)(f.value)):this._hasChilds()?f.expand.focus():f.menu.focus();break;default:f.select?f.select.focus():f.value&&!this._hasChilds()?(f.value.focus(),(0,q.selectContentEditable)(f.value)):f.field&&this.fieldEditable?(f.field.focus(),(0,q.selectContentEditable)(f.field)):
this._hasChilds()?f.expand.focus():f.menu.focus()}}}},{key:"containsNode",value:function(a){if(this===a)return!0;var f=this.childs;if(f)for(var b=0,k=f.length;b<k;b++)if(f[b].containsNode(a))return!0;return!1}},{key:"removeChild",value:function(a,f){if(this.childs){var b=this.childs.indexOf(a);if(-1!==b)return b<this.visibleChilds&&this.expanded&&this.visibleChilds--,a.hide(),delete a.searchField,delete a.searchValue,a=this.childs.splice(b,1)[0],a.parent=null,!1!==f&&this.updateDom({updateIndexes:!0}),
a}}},{key:"_remove",value:function(a){this.removeChild(a)}},{key:"changeType",value:function(a){var f=this.type;if(f!==a){if("string"!==a&&"auto"!==a||"string"!==f&&"auto"!==f){var b=this._detachFromDom();this.clearDom();this.type=a;if("object"===a){if(this.childs||(this.childs=[]),this.childs.forEach(function(a){a.clearDom();delete a.index;a.fieldEditable=!0;void 0===a.field&&(a.field="")}),"string"===f||"auto"===f)this.expanded=!0}else if("array"===a){if(this.childs||(this.childs=[]),this.childs.forEach(function(a,
f){a.clearDom();a.fieldEditable=!1;a.index=f}),"string"===f||"auto"===f)this.expanded=!0}else this.expanded=!1;this._attachToDom(b)}else this.type=a;if("auto"===a||"string"===a)this.value="string"===a?String(this.value):(0,q.parseString)(String(this.value)),this.focus();this.updateDom({updateIndexes:!0})}}},{key:"deepEqual",value:function(a){var f;if("array"===this.type){if(!Array.isArray(a)||this.childs.length!==a.length)return!1;for(f=0;f<this.childs.length;f++)if(!this.childs[f].deepEqual(a[f]))return!1}else if("object"===
this.type){if("object"!==I(a)||!a)return!1;var b=Object.keys(a);if(this.childs.length!==b.length)return!1;for(f=0;f<b.length;f++){var k=this.childs[f];if(k.field!==b[f]||!k.deepEqual(a[k.field]))return!1}}else if(this.value!==a)return!1;return!0}},{key:"_getDomValue",value:function(){this._clearValueError();this.dom.value&&"array"!==this.type&&"object"!==this.type&&(this.valueInnerText=(0,q.getInnerText)(this.dom.value),""===this.valueInnerText&&""!==this.dom.value.innerHTML&&(this.dom.value.textContent=
""));if(void 0!==this.valueInnerText)try{if("string"===this.type)var a=this._unescapeHTML(this.valueInnerText);else{var f=this._unescapeHTML(this.valueInnerText);a=(0,q.parseString)(f)}a!==this.value&&(this.value=a,this._debouncedOnChangeValue())}catch(E){this._setValueError((0,m.Iu)("cannotParseValueError"))}}},{key:"_setValueError",value:function(a){this.valueError={message:a};this.updateError()}},{key:"_clearValueError",value:function(){this.valueError&&(this.valueError=null,this.updateError())}},
{key:"_setFieldError",value:function(a){this.fieldError={message:a};this.updateError()}},{key:"_clearFieldError",value:function(){this.fieldError&&(this.fieldError=null,this.updateError())}},{key:"_onChangeValue",value:function(){var a=this.editor.getDomSelection();if(a.range){var f=(0,q.textDiff)(String(this.value),String(this.previousValue));a.range.startOffset=f.start;a.range.endOffset=f.end}f=this.editor.getDomSelection();if(f.range){var b=(0,q.textDiff)(String(this.previousValue),String(this.value));
f.range.startOffset=b.start;f.range.endOffset=b.end}this.editor._onAction("editValue",{path:this.getInternalPath(),oldValue:this.previousValue,newValue:this.value,oldSelection:a,newSelection:f});this.previousValue=this.value}},{key:"_onChangeField",value:function(){var a=this.editor.getDomSelection(),f=this.previousField||"";if(a.range){var b=(0,q.textDiff)(this.field,f);a.range.startOffset=b.start;a.range.endOffset=b.end}b=this.editor.getDomSelection();b.range&&(f=(0,q.textDiff)(f,this.field),b.range.startOffset=
f.start,b.range.endOffset=f.end);this.editor._onAction("editField",{parentPath:this.parent.getInternalPath(),index:this.getIndex(),oldValue:this.previousField,newValue:this.field,oldSelection:a,newSelection:b});this.previousField=this.field}},{key:"_updateDomValue",value:function(){var a=this.dom.value;if(a){var f=["jsoneditor-value"],b=this.value,c="auto"===this.type?(0,q.getType)(b):this.type,d="string"===c&&(0,q.isUrl)(b);f.push("jsoneditor-"+c);d&&f.push("jsoneditor-url");""===String(this.value)&&
"array"!==this.type&&"object"!==this.type&&f.push("jsoneditor-empty");this.searchValueActive&&f.push("jsoneditor-highlight-active");this.searchValue&&f.push("jsoneditor-highlight");a.className=f.join(" ");a.title="array"===c||"object"===c?this.type+" containing "+(this.childs?this.childs.length:0)+" items":d&&this.editable.value?(0,m.Iu)("openUrl"):"";"boolean"===c&&this.editable.value?(this.dom.checkbox||(this.dom.checkbox=document.createElement("input"),this.dom.checkbox.type="checkbox",this.dom.tdCheckbox=
document.createElement("td"),this.dom.tdCheckbox.className="jsoneditor-tree",this.dom.tdCheckbox.appendChild(this.dom.checkbox),this.dom.tdValue.parentNode.insertBefore(this.dom.tdCheckbox,this.dom.tdValue)),this.dom.checkbox.checked=this.value):this.dom.tdCheckbox&&(this.dom.tdCheckbox.parentNode.removeChild(this.dom.tdCheckbox),delete this.dom.tdCheckbox,delete this.dom.checkbox);if(this["enum"]&&this.editable.value){if(!this.dom.select){this.dom.select=document.createElement("select");this.id=
this.field+"_"+(new Date).getUTCMilliseconds();this.dom.select.id=this.id;this.dom.select.name=this.dom.select.id;f=document.createElement("option");f.value="";f.textContent="--";this.dom.select.appendChild(f);for(f=0;f<this["enum"].length;f++)c=document.createElement("option"),c.value=this["enum"][f],c.textContent=this["enum"][f],this.dom.select.appendChild(c);this.dom.tdSelect=document.createElement("td");this.dom.tdSelect.className="jsoneditor-tree";this.dom.tdSelect.appendChild(this.dom.select);
this.dom.tdValue.parentNode.insertBefore(this.dom.tdSelect,this.dom.tdValue)}this.dom.select.value=-1!==this["enum"].indexOf(this.value)?this.value:"";!this.schema||Object.prototype.hasOwnProperty.call(this.schema,"oneOf")||Object.prototype.hasOwnProperty.call(this.schema,"anyOf")||Object.prototype.hasOwnProperty.call(this.schema,"allOf")?delete this.valueFieldHTML:(this.valueFieldHTML=this.dom.tdValue.innerHTML,this.dom.tdValue.style.visibility="hidden",this.dom.tdValue.textContent="")}else this.dom.tdSelect&&
(this.dom.tdSelect.parentNode.removeChild(this.dom.tdSelect),delete this.dom.tdSelect,delete this.dom.select,this.dom.tdValue.innerHTML=this.valueFieldHTML,this.dom.tdValue.style.visibility="",delete this.valueFieldHTML);this.editable.value&&this.editor.options.colorPicker&&"string"===typeof b&&(0,q.isValidColor)(b)?(this.dom.color||(this.dom.color=document.createElement("div"),this.dom.color.className="jsoneditor-color",this.dom.tdColor=document.createElement("td"),this.dom.tdColor.className="jsoneditor-tree",
this.dom.tdColor.appendChild(this.dom.color),this.dom.tdValue.parentNode.insertBefore(this.dom.tdColor,this.dom.tdValue)),(0,q.addClassName)(this.dom.value,"jsoneditor-color-value"),this.dom.color.style.backgroundColor=b):this._deleteDomColor();if(this._showTimestampTag()){this.dom.date||(this.dom.date=document.createElement("div"),this.dom.date.className="jsoneditor-date",this.dom.value.parentNode.appendChild(this.dom.date));f=null;"function"===typeof this.editor.options.timestampFormat&&(f=this.editor.options.timestampFormat({field:this.field,
value:this.value,path:this.getPath()}));if(f){for(;this.dom.date.firstChild;)this.dom.date.removeChild(this.dom.date.firstChild);this.dom.date.appendChild(document.createTextNode(f))}else this.dom.date.textContent=(new Date(b)).toISOString();this.dom.date.title=(new Date(b)).toString()}else this.dom.date&&(this.dom.date.parentNode.removeChild(this.dom.date),delete this.dom.date);(0,q.stripFormatting)(a);this._updateDomDefault()}}},{key:"_deleteDomColor",value:function(){this.dom.color&&(this.dom.tdColor.parentNode.removeChild(this.dom.tdColor),
delete this.dom.tdColor,delete this.dom.color,(0,q.removeClassName)(this.dom.value,"jsoneditor-color-value"))}},{key:"_updateDomField",value:function(){var a=this.dom.field;if(a){var f=(0,q.makeFieldTooltip)(this.schema,this.editor.options.language);f&&(a.title=f);""===String(this.field)&&this.parent&&"array"!==this.parent.type?(0,q.addClassName)(a,"jsoneditor-empty"):(0,q.removeClassName)(a,"jsoneditor-empty");this.searchFieldActive?(0,q.addClassName)(a,"jsoneditor-highlight-active"):(0,q.removeClassName)(a,
"jsoneditor-highlight-active");this.searchField?(0,q.addClassName)(a,"jsoneditor-highlight"):(0,q.removeClassName)(a,"jsoneditor-highlight");(0,q.stripFormatting)(a)}}},{key:"_getDomField",value:function(a){this._clearFieldError();this.dom.field&&this.fieldEditable&&(this.fieldInnerText=(0,q.getInnerText)(this.dom.field),""===this.fieldInnerText&&""!==this.dom.field.innerHTML&&(this.dom.field.textContent=""));if(void 0!==this.fieldInnerText)try{var f=this._unescapeHTML(this.fieldInnerText),b=this.parent.getFieldNames(this);
-1===b.indexOf(f)?f!==this.field&&(this.field=f,this._debouncedOnChangeField()):a?(f=(0,q.findUniqueName)(f,b),f!==this.field&&(this.field=f,this._debouncedOnChangeField())):this._setFieldError((0,m.Iu)("duplicateFieldError"))}catch(T){this._setFieldError((0,m.Iu)("cannotParseFieldError"))}}},{key:"_updateDomDefault",value:function(){if(this.schema&&void 0!==this.schema["default"]&&!this._hasChilds()){var a=this.dom.select?this.dom.select:this.dom.value;a&&(this.value===this.schema["default"]?(a.title=
(0,m.Iu)("default"),(0,q.addClassName)(a,"jsoneditor-is-default"),(0,q.removeClassName)(a,"jsoneditor-is-not-default")):(a.removeAttribute("title"),(0,q.removeClassName)(a,"jsoneditor-is-default"),(0,q.addClassName)(a,"jsoneditor-is-not-default")))}}},{key:"_showTimestampTag",value:function(){if("number"!==typeof this.value)return!1;var a=this.editor.options.timestampTag;return"function"===typeof a?(a=a({field:this.field,value:this.value,path:this.getPath()}),"boolean"===typeof a?a:(0,q.isTimestamp)(this.field,
this.value)):!0===a?(0,q.isTimestamp)(this.field,this.value):!1}},{key:"clearDom",value:function(){this.dom={}}},{key:"getDom",value:function(){var a=this.dom;if(a.tr)return a.tr;this._updateEditability();a.tr=document.createElement("tr");a.tr.node=this;if("tree"===this.editor.options.mode){var f=document.createElement("td");if(this.editable.field&&this.parent){var b=document.createElement("button");b.type="button";a.drag=b;b.className="jsoneditor-button jsoneditor-dragarea";b.title=(0,m.Iu)("drag");
f.appendChild(b)}a.tr.appendChild(f);f=document.createElement("td");b=document.createElement("button");b.type="button";a.menu=b;b.className="jsoneditor-button jsoneditor-contextmenu-button";b.title=(0,m.Iu)("actionsMenu");f.appendChild(a.menu);a.tr.appendChild(f)}f=document.createElement("td");a.tr.appendChild(f);a.tree=this._createDomTree();f.appendChild(a.tree);this.updateDom({updateIndexes:!0});return a.tr}},{key:"isVisible",value:function(){return this.dom&&this.dom.tr&&this.dom.tr.parentNode||
!1}},{key:"isDescendantOf",value:function(a){for(var b=this.parent;b;){if(b===a)return!0;b=b.parent}return!1}},{key:"_createDomField",value:function(){return document.createElement("div")}},{key:"setHighlight",value:function(a){this.dom.tr&&(a?(0,q.addClassName)(this.dom.tr,"jsoneditor-highlight"):(0,q.removeClassName)(this.dom.tr,"jsoneditor-highlight"),this.append&&this.append.setHighlight(a),this.childs&&this.childs.forEach(function(b){b.setHighlight(a)}))}},{key:"setSelected",value:function(a,
b){this.selected=a;this.dom.tr&&(a?(0,q.addClassName)(this.dom.tr,"jsoneditor-selected"):(0,q.removeClassName)(this.dom.tr,"jsoneditor-selected"),b?(0,q.addClassName)(this.dom.tr,"jsoneditor-first"):(0,q.removeClassName)(this.dom.tr,"jsoneditor-first"),this.append&&this.append.setSelected(a),this.showMore&&this.showMore.setSelected(a),this.childs&&this.childs.forEach(function(b){b.setSelected(a)}))}},{key:"updateValue",value:function(a){this.previousValue=this.value=a;this.valueError=void 0;this.updateDom()}},
{key:"updateField",value:function(a){this.previousField=this.field=a;this.fieldError=void 0;this.updateDom()}},{key:"updateDom",value:function(b){var f=this.dom.tree;f&&(f.style.marginLeft=24*this.getLevel()+"px");if(f=this.dom.field){this.fieldEditable?(f.contentEditable=this.editable.field,f.spellcheck=!1,f.className="jsoneditor-field"):(f.contentEditable=!1,f.className="jsoneditor-readonly");var c=void 0!==this.index?this.index:void 0!==this.field?this.field:(c=this.editor.options.schema?a._findSchema(this.editor.options.schema,
this.editor.options.schemaRefs||{},this.getPath()):void 0)&&c.title?c.title:this._hasChilds()?this.type:"";c=this._escapeHTML(c);if(document.activeElement!==f||c!==this._unescapeHTML((0,q.getInnerText)(f)))f.innerHTML=c;this._updateSchema()}if(f=this.dom.value)if("array"===this.type||"object"===this.type)this.updateNodeName();else if(c=this._escapeHTML(this.value),document.activeElement!==f||c!==this._unescapeHTML((0,q.getInnerText)(f)))f.innerHTML=c;if(f=this.dom.tr)"array"===this.type||"object"===
this.type?((0,q.addClassName)(f,"jsoneditor-expandable"),this.expanded?((0,q.addClassName)(f,"jsoneditor-expanded"),(0,q.removeClassName)(f,"jsoneditor-collapsed")):((0,q.addClassName)(f,"jsoneditor-collapsed"),(0,q.removeClassName)(f,"jsoneditor-expanded"))):((0,q.removeClassName)(f,"jsoneditor-expandable"),(0,q.removeClassName)(f,"jsoneditor-expanded"),(0,q.removeClassName)(f,"jsoneditor-collapsed"));this._updateDomField();this._updateDomValue();b&&!0===b.updateIndexes&&this._updateDomIndexes();
b&&!0===b.recurse&&this.childs&&this.childs.forEach(function(a){a.updateDom(b)});this.error&&this.updateError();this.append&&this.append.updateDom();this.showMore&&this.showMore.updateDom();this._updateCssClassName()}},{key:"_updateSchema",value:function(){this.editor&&this.editor.options&&((this.schema=this.editor.options.schema?a._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):null)?this["enum"]=a._findEnum(this.schema):delete this["enum"])}},{key:"_updateDomIndexes",
value:function(){var a=this.childs;this.dom.value&&a&&("array"===this.type?a.forEach(function(a,b){a.index=b;if(a=a.dom.field)a.textContent=b}):"object"===this.type&&a.forEach(function(a){void 0!==a.index&&(delete a.index,void 0===a.field&&(a.field=""))}))}},{key:"_createDomValue",value:function(){if("array"===this.type){var a=document.createElement("div");a.textContent="[...]"}else"object"===this.type?(a=document.createElement("div"),a.textContent="{...}"):(!this.editable.value&&(0,q.isUrl)(this.value)?
(a=document.createElement("a"),a.href=this.value):(a=document.createElement("div"),a.contentEditable=this.editable.value,a.spellcheck=!1),a.innerHTML=this._escapeHTML(this.value));return a}},{key:"_createDomExpandButton",value:function(){var a=document.createElement("button");a.type="button";this._hasChilds()?(a.className=this.expanded?"jsoneditor-button jsoneditor-expanded":"jsoneditor-button jsoneditor-collapsed",a.title=(0,m.Iu)("expandTitle")):(a.className="jsoneditor-button jsoneditor-invisible",
a.title="");return a}},{key:"_createDomTree",value:function(){var a=this.dom,b=document.createElement("table"),c=document.createElement("tbody");b.style.borderCollapse="collapse";b.className="jsoneditor-values";b.appendChild(c);var d=document.createElement("tr");c.appendChild(d);c=document.createElement("td");c.className="jsoneditor-tree";d.appendChild(c);a.expand=this._createDomExpandButton();c.appendChild(a.expand);a.tdExpand=c;c=document.createElement("td");c.className="jsoneditor-tree";d.appendChild(c);
a.field=this._createDomField();c.appendChild(a.field);a.tdField=c;c=document.createElement("td");c.className="jsoneditor-tree";d.appendChild(c);"object"!==this.type&&"array"!==this.type&&(c.appendChild(document.createTextNode(":")),c.className="jsoneditor-separator");a.tdSeparator=c;c=document.createElement("td");c.className="jsoneditor-tree";d.appendChild(c);a.value=this._createDomValue();c.appendChild(a.value);a.tdValue=c;return b}},{key:"onEvent",value:function(a){var b=a.type,c=a.target||a.srcElement,
k=this.dom,d=this,e=this._hasChilds();if(c===k.drag||c===k.menu)"mouseover"===b?this.editor.highlighter.highlight(this):"mouseout"===b&&this.editor.highlighter.unhighlight();if("click"===b&&c===k.menu){var h=d.editor.highlighter;h.highlight(d);h.lock();(0,q.addClassName)(k.menu,"jsoneditor-selected");this.showContextMenu(k.menu,function(){(0,q.removeClassName)(k.menu,"jsoneditor-selected");h.unlock();h.unhighlight()})}"click"===b&&c===k.expand&&e&&this._onExpand(a.ctrlKey);"click"!==b||a.target!==
d.dom.tdColor&&a.target!==d.dom.color||this._showColorPicker();"change"===b&&c===k.checkbox&&(this.dom.value.textContent=String(!this.value),this._getDomValue(),this._updateDomDefault());"change"===b&&c===k.select&&(this.dom.value.innerHTML=this._escapeHTML(k.select.value),this._getDomValue(),this._updateDomValue());var C=k.value;if(c===C)switch(b){case "blur":case "change":this._getDomValue();this._clearValueError();this._updateDomValue();var g=this._escapeHTML(this.value);g!==this._unescapeHTML((0,
q.getInnerText)(C))&&(C.innerHTML=g);break;case "input":this._getDomValue();this._updateDomValue();break;case "keydown":case "mousedown":this.editor.selection=this.editor.getDomSelection();break;case "click":a.ctrlKey&&this.editable.value&&(0,q.isUrl)(this.value)&&(a.preventDefault(),window.open(this.value,"_blank","noopener"));break;case "keyup":this._getDomValue();this._updateDomValue();break;case "cut":case "paste":setTimeout(function(){d._getDomValue();d._updateDomValue()},1)}g=k.field;if(c===
g)switch(b){case "blur":this._getDomField(!0);this._updateDomField();var u=this._escapeHTML(this.field);u!==this._unescapeHTML((0,q.getInnerText)(g))&&(g.innerHTML=u);break;case "input":this._getDomField();this._updateSchema();this._updateDomField();this._updateDomValue();break;case "keydown":case "mousedown":this.editor.selection=this.editor.getDomSelection();break;case "keyup":this._getDomField();this._updateDomField();break;case "cut":case "paste":setTimeout(function(){d._getDomField();d._updateDomField()},
1)}(u=k.tree)&&c===u.parentNode&&"click"===b&&!a.hasMoved&&((void 0!==a.offsetX?a.offsetX<24*(this.getLevel()+1):a.pageX<(0,q.getAbsoluteLeft)(k.tdSeparator))||e?g&&((0,q.setEndOfContentEditable)(g),g.focus()):C&&!this["enum"]&&((0,q.setEndOfContentEditable)(C),C.focus()));(c!==k.tdExpand||e)&&c!==k.tdField&&c!==k.tdSeparator||"click"!==b||a.hasMoved||!g||((0,q.setEndOfContentEditable)(g),g.focus());if("keydown"===b)this.onKeyDown(a);"function"===typeof this.editor.options.onEvent&&this._onEvent(a)}},
{key:"_onEvent",value:function(a){var b=a.target,c=b===this.dom.value||b===this.dom.checkbox||b===this.dom.select;if(b===this.dom.field||c)b={field:this.getField(),path:this.getPath()},c&&!this._hasChilds()&&(b.value=this.getValue()),this.editor.options.onEvent(b,a)}},{key:"onKeyDown",value:function(b){var f=b.which||b.keyCode,c=b.target||b.srcElement,k=b.ctrlKey,d=b.shiftKey,e=b.altKey,h=!1,C,g="tree"===this.editor.options.mode,u=0<this.editor.multiselection.nodes.length?this.editor.multiselection.nodes:
[this],l=u[0];var m=u[u.length-1];if(13===f)c===this.dom.value?this.editable.value&&!b.ctrlKey||!(0,q.isUrl)(this.value)||(window.open(this.value,"_blank","noopener"),h=!0):c===this.dom.expand&&this._hasChilds()&&(this._onExpand(b.ctrlKey),c.focus(),h=!0);else if(68===f)k&&g&&(a.onDuplicate(u),h=!0);else if(69===f)k&&(this._onExpand(d),c.focus(),h=!0);else if(77===f&&g)k&&(this.showContextMenu(c),h=!0);else if(46===f&&g)k&&(a.onRemove(u),h=!0);else if(45===f&&g)k&&!d?(this._onInsertBefore(),h=!0):
k&&d&&(this._onInsertAfter(),h=!0);else if(35===f)e&&((h=this._lastNode())&&h.focus(a.focusElement||this._getElementName(c)),h=!0);else if(36===f)e&&((h=this._firstNode())&&h.focus(a.focusElement||this._getElementName(c)),h=!0);else if(37===f)if(e&&!d)(c=this._previousElement(c))&&this.focus(this._getElementName(c)),h=!0;else{if(e&&d&&g&&(k=m.expanded?(f=m.getAppendDom())?f.nextSibling:void 0:m.getDom().nextSibling,k)){f=a.getNodeFromTarget(k);k=k.nextSibling;var p=a.getNodeFromTarget(k);if(f&&f instanceof
O&&1!==m.parent.childs.length&&p&&p.parent){f=this.editor.getDomSelection();k=l.parent;m=k.childs[m.getIndex()+1]||k.append;d=l.getIndex();e=p.getIndex();g=k.getInternalPath();var n=p.parent.getInternalPath();u.forEach(function(a){p.parent.moveBefore(a,p)});this.focus(a.focusElement||this._getElementName(c));this.editor._onAction("moveNodes",{count:u.length,fieldNames:u.map(G),oldParentPath:k.getInternalPath(),newParentPath:l.parent.getInternalPath(),oldIndex:m.getIndex(),newIndex:l.getIndex(),oldIndexRedo:d,
newIndexRedo:e,oldParentPathRedo:g,newParentPathRedo:n,oldSelection:f,newSelection:this.editor.getDomSelection()})}}}else if(38===f)if(e&&!d){if(C=this._previousNode())this.editor.deselect(!0),C.focus(a.focusElement||this._getElementName(c));h=!0}else if(!e&&k&&d&&g){if(C=this._previousNode())c=this.editor.multiselection,c.start=c.start||this,c.end=C,c=this.editor._findTopLevelNodes(c.start,c.end),this.editor.select(c),C.focus("field");h=!0}else e&&d&&g&&((C=l._previousNode())&&C.parent&&(f=this.editor.getDomSelection(),
k=l.parent,m=k.childs[m.getIndex()+1]||k.append,d=l.getIndex(),e=C.getIndex(),g=k.getInternalPath(),n=C.parent.getInternalPath(),u.forEach(function(a){C.parent.moveBefore(a,C)}),this.focus(a.focusElement||this._getElementName(c)),this.editor._onAction("moveNodes",{count:u.length,fieldNames:u.map(G),oldParentPath:k.getInternalPath(),newParentPath:l.parent.getInternalPath(),oldIndex:m.getIndex(),newIndex:l.getIndex(),oldIndexRedo:d,newIndexRedo:e,oldParentPathRedo:g,newParentPathRedo:n,oldSelection:f,
newSelection:this.editor.getDomSelection()})),h=!0);else if(39===f)e&&!d?((c=this._nextElement(c))&&this.focus(this._getElementName(c)),h=!0):e&&d&&g&&(f=l.getDom().previousSibling)&&(C=a.getNodeFromTarget(f))&&C.parent&&!C.isVisible()&&(f=this.editor.getDomSelection(),k=l.parent,m=k.childs[m.getIndex()+1]||k.append,d=l.getIndex(),e=C.getIndex(),g=k.getInternalPath(),n=C.parent.getInternalPath(),u.forEach(function(a){C.parent.moveBefore(a,C)}),this.focus(a.focusElement||this._getElementName(c)),this.editor._onAction("moveNodes",
{count:u.length,fieldNames:u.map(G),oldParentPath:k.getInternalPath(),newParentPath:l.parent.getInternalPath(),oldIndex:m.getIndex(),newIndex:l.getIndex(),oldIndexRedo:d,newIndexRedo:e,oldParentPathRedo:g,newParentPathRedo:n,oldSelection:f,newSelection:this.editor.getDomSelection()}));else if(40===f)if(e&&!d){if(f=this._nextNode())this.editor.deselect(!0),f.focus(a.focusElement||this._getElementName(c));h=!0}else if(!e&&k&&d&&g){if(f=this._nextNode())c=this.editor.multiselection,c.start=c.start||
this,c.end=f,c=this.editor._findTopLevelNodes(c.start,c.end),this.editor.select(c),f.focus("field");h=!0}else if(e&&d&&g){(f=m.expanded?m.append?m.append._nextNode():void 0:m._nextNode())&&!f.isVisible()&&(f=f.parent.showMore);f&&f instanceof O&&(f=m);var r=f&&(f._nextNode()||f.parent.append);r&&r.parent&&(f=this.editor.getDomSelection(),k=l.parent,m=k.childs[m.getIndex()+1]||k.append,d=l.getIndex(),e=r.getIndex(),g=k.getInternalPath(),n=r.parent.getInternalPath(),u.forEach(function(a){r.parent.moveBefore(a,
r)}),this.focus(a.focusElement||this._getElementName(c)),this.editor._onAction("moveNodes",{count:u.length,fieldNames:u.map(G),oldParentPath:k.getInternalPath(),newParentPath:l.parent.getInternalPath(),oldParentPathRedo:g,newParentPathRedo:n,oldIndexRedo:d,newIndexRedo:e,oldIndex:m.getIndex(),newIndex:l.getIndex(),oldSelection:f,newSelection:this.editor.getDomSelection()}));h=!0}h&&(b.preventDefault(),b.stopPropagation())}},{key:"_onExpand",value:function(a){if(a){var b=this.dom.tr.parentNode;var c=
b.parentNode;var k=c.scrollTop;c.removeChild(b)}this.expanded?this.collapse(a):this.expand(a);a&&(c.appendChild(b),c.scrollTop=k)}},{key:"_showColorPicker",value:function(){if("function"===typeof this.editor.options.onColorPicker&&this.dom.color){var a=this;a._deleteDomColor();a.updateDom();var b=(0,y.w)(this.dom.color,this.editor.getPopupAnchor());this.editor.options.onColorPicker(b,this.value,function(b){"string"===typeof b&&b!==a.value&&(a._deleteDomColor(),a.value=b,a.updateDom(),a._debouncedOnChangeValue())})}}},
{key:"getFieldNames",value:function(a){return"object"===this.type?this.childs.filter(function(b){return b!==a}).map(function(a){return a.field}):[]}},{key:"_onInsertBefore",value:function(b,f,c){var k=this.editor.getDomSelection();b=new a(this.editor,{field:void 0!==b?b:"",value:void 0!==f?f:"",type:c});b.expand(!0);f=this.getInternalPath();this.parent.insertBefore(b,this);this.editor.highlighter.unhighlight();b.focus("field");c=this.editor.getDomSelection();this.editor._onAction("insertBeforeNodes",
{nodes:[b],paths:[b.getInternalPath()],beforePath:f,parentPath:this.parent.getInternalPath(),oldSelection:k,newSelection:c})}},{key:"_onInsertAfter",value:function(b,f,c){var k=this.editor.getDomSelection();b=new a(this.editor,{field:void 0!==b?b:"",value:void 0!==f?f:"",type:c});b.expand(!0);this.parent.insertAfter(b,this);this.editor.highlighter.unhighlight();b.focus("field");f=this.editor.getDomSelection();this.editor._onAction("insertAfterNodes",{nodes:[b],paths:[b.getInternalPath()],afterPath:this.getInternalPath(),
parentPath:this.parent.getInternalPath(),oldSelection:k,newSelection:f})}},{key:"_onAppend",value:function(b,f,c){var k=this.editor.getDomSelection();b=new a(this.editor,{field:void 0!==b?b:"",value:void 0!==f?f:"",type:c});b.expand(!0);this.parent.appendChild(b);this.editor.highlighter.unhighlight();b.focus("field");f=this.editor.getDomSelection();this.editor._onAction("appendNodes",{nodes:[b],paths:[b.getInternalPath()],parentPath:this.parent.getInternalPath(),oldSelection:k,newSelection:f})}},
{key:"_onChangeType",value:function(a){var b=this.type;if(a!==b){var c=this.editor.getDomSelection();this.changeType(a);var k=this.editor.getDomSelection();this.editor._onAction("changeType",{path:this.getInternalPath(),oldType:b,newType:a,oldSelection:c,newSelection:k})}}},{key:"sort",value:function(a,b){var f=2<arguments.length&&void 0!==arguments[2]?arguments[2]:!0;"string"===typeof a&&(a=(0,q.parsePath)(a));if(this._hasChilds()){this.hideChilds();var c=this.childs;this.childs=this.childs.concat();
var k="desc"===b?-1:1;"object"===this.type?this.childs.sort(function(a,b){return k*z()(a.field,b.field)}):this.childs.sort(function(b,f){b=b.getNestedChild(a);f=f.getNestedChild(a);if(!b)return k;if(!f)return-k;b=b.value;f=f.value;return"string"!==typeof b&&"string"!==typeof f?b>f?k:b<f?-k:0:k*z()(b,f)});this._updateDomIndexes();this.showChilds();!0===f&&this.editor._onAction("sort",{path:this.getInternalPath(),oldChilds:c,newChilds:this.childs})}}},{key:"update",value:function(a){var b=this.getInternalValue();
this.setValue(a);this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:b,newValue:this.getInternalValue()})}},{key:"_detachFromDom",value:function(){var a=this.dom.tr?this.dom.tr.parentNode:void 0;var b=(b=this.expanded?this.getAppendDom():this.getDom())&&b.parentNode?b.nextSibling:void 0;this.hide({resetVisibleChilds:!1});return{table:a,nextTr:b}}},{key:"_attachToDom",value:function(a){a.table&&(a.nextTr?a.table.insertBefore(this.getDom(),a.nextTr):a.table.appendChild(this.getDom()));
this.expanded&&this.showChilds()}},{key:"transform",value:function(a){if(this._hasChilds()){this.hideChilds();try{var b=this.getInternalValue(),c=this.getValue(),k=this.editor.options.executeQuery(c,a);this.setValue(k);var d=this.getInternalValue();this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:b,newValue:d});this.showChilds()}catch(R){this.showChilds(),this.editor._onError(R)}}}},{key:"extract",value:function(){this.editor.node.hideChilds();this.hideChilds();try{var a=this.editor.node.getInternalValue();
this.editor._setRoot(this);var b=this.editor.node.getInternalValue();this.editor._onAction("transform",{path:this.editor.node.getInternalPath(),oldValue:a,newValue:b})}catch(E){this.editor._onError(E)}finally{this.updateDom({recurse:!0}),this.showChilds()}}},{key:"getNestedChild",value:function(a){for(var b=0,c=this;c&&b<a.length;)c=c.findChildByProperty(a[b]),b++;return c}},{key:"findChildByProperty",value:function(a){if("object"===this.type)return this.childs.find(function(b){return b.field===a})}},
{key:"getAppendDom",value:function(){this.append||(this.append=new O(this.editor),this.append.setParent(this));return this.append.getDom()}},{key:"getShowMoreDom",value:function(){this.showMore||(this.showMore=new ca(this.editor,this));return this.showMore.getDom()}},{key:"nextSibling",value:function(){var a=this.parent.childs.indexOf(this);return this.parent.childs[a+1]||this.parent.append}},{key:"_previousNode",value:function(){var b=null,f=this.getDom();if(f&&f.parentNode){do f=f.previousSibling,
b=a.getNodeFromTarget(f);while(f&&b&&b instanceof O&&!b.isVisible())}return b}},{key:"_nextNode",value:function(){var b=null,f=this.getDom();if(f&&f.parentNode){do f=f.nextSibling,b=a.getNodeFromTarget(f);while(f&&b&&b instanceof O&&!b.isVisible())}return b}},{key:"_firstNode",value:function(){var b=null,f=this.getDom();f&&f.parentNode&&(b=a.getNodeFromTarget(f.parentNode.firstChild));return b}},{key:"_lastNode",value:function(){var b=null,f=this.getDom();if(f&&f.parentNode)for(f=f.parentNode.lastChild,
b=a.getNodeFromTarget(f);f&&b&&!b.isVisible();)f=f.previousSibling,b=a.getNodeFromTarget(f);return b}},{key:"_previousElement",value:function(a){var b=this.dom;switch(a){case b.value:if(this.fieldEditable)return b.field;case b.field:if(this._hasChilds())return b.expand;case b.expand:return b.menu;case b.menu:if(b.drag)return b.drag;default:return null}}},{key:"_nextElement",value:function(a){var b=this.dom;switch(a){case b.drag:return b.menu;case b.menu:if(this._hasChilds())return b.expand;case b.expand:if(this.fieldEditable)return b.field;
case b.field:if(!this._hasChilds())return b.value;default:return null}}},{key:"_getElementName",value:function(a){var b=this;return Object.keys(this.dom).find(function(c){return b.dom[c]===a})}},{key:"_hasChilds",value:function(){return"array"===this.type||"object"===this.type}},{key:"addTemplates",value:function(a,b){var c=this,f=c.editor.options.templates;if(null!=f){f.length&&a.push({type:"separator"});var d=function(a,b){c._onAppend(a,b)},k=function(a,b){c._onInsertBefore(a,b)};f.forEach(function(c){a.push({text:c.text,
className:c.className||"jsoneditor-type-object",title:c.title,click:b?d.bind(this,c.field,c.value):k.bind(this,c.field,c.value)})})}}},{key:"showContextMenu",value:function(b,c){var f=this,d=[];this.editable.value&&d.push({text:(0,m.Iu)("type"),title:(0,m.Iu)("typeTitle"),className:"jsoneditor-type-"+this.type,submenu:[{text:(0,m.Iu)("auto"),className:"jsoneditor-type-auto"+("auto"===this.type?" jsoneditor-selected":""),title:(0,m.Iu)("autoType"),click:function(){f._onChangeType("auto")}},{text:(0,
m.Iu)("array"),className:"jsoneditor-type-array"+("array"===this.type?" jsoneditor-selected":""),title:(0,m.Iu)("arrayType"),click:function(){f._onChangeType("array")}},{text:(0,m.Iu)("object"),className:"jsoneditor-type-object"+("object"===this.type?" jsoneditor-selected":""),title:(0,m.Iu)("objectType"),click:function(){f._onChangeType("object")}},{text:(0,m.Iu)("string"),className:"jsoneditor-type-string"+("string"===this.type?" jsoneditor-selected":""),title:(0,m.Iu)("stringType"),click:function(){f._onChangeType("string")}}]});
this._hasChilds()&&(this.editor.options.enableSort&&d.push({text:(0,m.Iu)("sort"),title:(0,m.Iu)("sortTitle",{type:this.type}),className:"jsoneditor-sort-asc",click:function(){f.showSortModal()}}),this.editor.options.enableTransform&&d.push({text:(0,m.Iu)("transform"),title:(0,m.Iu)("transformTitle",{type:this.type}),className:"jsoneditor-transform",click:function(){f.showTransformModal()}}),this.parent&&d.push({text:(0,m.Iu)("extract"),title:(0,m.Iu)("extractTitle",{type:this.type}),className:"jsoneditor-extract",
click:function(){f.extract()}}));if(this.parent&&this.parent._hasChilds()){d.length&&d.push({type:"separator"});var k=f.parent.childs;f===k[k.length-1]&&(k=[{text:(0,m.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,m.Iu)("autoType"),click:function(){f._onAppend("","","auto")}},{text:(0,m.Iu)("array"),className:"jsoneditor-type-array",title:(0,m.Iu)("arrayType"),click:function(){f._onAppend("",[])}},{text:(0,m.Iu)("object"),className:"jsoneditor-type-object",title:(0,m.Iu)("objectType"),click:function(){f._onAppend("",
{})}},{text:(0,m.Iu)("string"),className:"jsoneditor-type-string",title:(0,m.Iu)("stringType"),click:function(){f._onAppend("","","string")}}],f.addTemplates(k,!0),d.push({text:(0,m.Iu)("appendText"),title:(0,m.Iu)("appendTitle"),submenuTitle:(0,m.Iu)("appendSubmenuTitle"),className:"jsoneditor-append",click:function(){f._onAppend("","","auto")},submenu:k}));k=[{text:(0,m.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,m.Iu)("autoType"),click:function(){f._onInsertBefore("","","auto")}},{text:(0,
m.Iu)("array"),className:"jsoneditor-type-array",title:(0,m.Iu)("arrayType"),click:function(){f._onInsertBefore("",[])}},{text:(0,m.Iu)("object"),className:"jsoneditor-type-object",title:(0,m.Iu)("objectType"),click:function(){f._onInsertBefore("",{})}},{text:(0,m.Iu)("string"),className:"jsoneditor-type-string",title:(0,m.Iu)("stringType"),click:function(){f._onInsertBefore("","","string")}}];f.addTemplates(k,!1);d.push({text:(0,m.Iu)("insert"),title:(0,m.Iu)("insertTitle"),submenuTitle:(0,m.Iu)("insertSub"),
className:"jsoneditor-insert",click:function(){f._onInsertBefore("","","auto")},submenu:k});this.editable.field&&(d.push({text:(0,m.Iu)("duplicateText"),title:(0,m.Iu)("duplicateField"),className:"jsoneditor-duplicate",click:function(){a.onDuplicate(f)}}),d.push({text:(0,m.Iu)("removeText"),title:(0,m.Iu)("removeField"),className:"jsoneditor-remove",click:function(){a.onRemove(f)}}))}this.editor.options.onCreateMenu&&(k=f.getPath(),d=this.editor.options.onCreateMenu(d,{type:"single",path:k,paths:[k]}));
(new u.x(d,{close:c})).show(b,this.editor.getPopupAnchor())}},{key:"showSortModal",value:function(){var a=this,b=this.editor.options.modalAnchor||L.qD,c=this.getValue();(0,P.showSortModal)(b,c,function(b){var c=b.path;c=(0,q.parsePath)(c);a.sortedBy=b;a.sort(c,b.direction)},a.sortedBy)}},{key:"showTransformModal",value:function(){var a=this,b=this.editor.options,c=b.modalAnchor,d=b.createQuery,e=b.executeQuery;b=b.queryDescription;var h=this.getValue();(0,aa.showTransformModal)({container:c||L.qD,
json:h,queryDescription:b,createQuery:d,executeQuery:e,onTransform:function(b){a.transform(b)}})}},{key:"_getType",value:function(a){return a instanceof Array?"array":a instanceof Object?"object":"string"===typeof a&&"string"!==typeof(0,q.parseString)(a)?"string":"auto"}},{key:"_escapeHTML",value:function(a){if("string"!==typeof a)return String(a);a=String(a).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/ {2}/g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;");a=
JSON.stringify(a);a=a.substring(1,a.length-1);!0===this.editor.options.escapeUnicode&&(a=(0,q.escapeUnicodeChars)(a));return a}},{key:"_unescapeHTML",value:function(a){a='"'+this._escapeJSON(a)+'"';return(0,q.parse)(a).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ").replace(/&amp;/g,"&")}},{key:"_escapeJSON",value:function(a){for(var b="",c=0;c<a.length;){var d=a.charAt(c);if("\n"===d)b+="\\n";else if("\\"===d){b+=d;c++;d=a.charAt(c);if(""===d||-1==='"\\/bfnrtu'.indexOf(d))b+=
"\\";b+=d}else b='"'===d?b+'\\"':b+d;c++}return b}},{key:"updateNodeName",value:function(){var a=this.childs?this.childs.length:0;if("object"===this.type||"array"===this.type){if(this.editor.options.onNodeName)try{var b=this.editor.options.onNodeName({path:this.getPath(),size:a,type:this.type})}catch(E){console.error("Error in onNodeName callback: ",E)}this.dom.value.textContent="object"===this.type?"{"+(b||a)+"}":"["+(b||a)+"]"}}},{key:"recursivelyUpdateNodeName",value:function(){if(this.expanded&&
(this.updateNodeName(),"undefined"!==this.childs))for(var a in this.childs)this.childs[a].recursivelyUpdateNodeName()}}]);return a}();B.prototype.DEBOUNCE_INTERVAL=150;B.prototype.MAX_SEARCH_RESULTS=999;var ba=100;B.focusElement=void 0;B.select=function(a){setTimeout(function(){(0,q.selectContentEditable)(a)},0)};B.onDragStart=function(a,b){if(!Array.isArray(a))return B.onDragStart([a],b);if(0!==a.length){var c=a[0],d=a[a.length-1],k=c.parent,e=B.getNodeFromTarget(b.target),h=c.editor;e=(0,q.getAbsoluteTop)(e.dom.tr)-
(0,q.getAbsoluteTop)(c.dom.tr);h.mousemove||(h.mousemove=(0,q.addEventListener)(b.view,"mousemove",function(b){B.onDrag(a,b)}));h.mouseup||(h.mouseup=(0,q.addEventListener)(b.view,"mouseup",function(b){B.onDragEnd(a,b)}));h.highlighter.lock();h.drag={oldCursor:document.body.style.cursor,oldSelection:h.getDomSelection(),oldPaths:a.map(D),oldParent:k,oldNextNode:k.childs[d.getIndex()+1]||k.append,oldParentPathRedo:k.getInternalPath(),oldIndexRedo:c.getIndex(),mouseX:b.pageX,offsetY:e,level:c.getLevel()};
document.body.style.cursor="move";b.preventDefault()}};B.onDrag=function(a,b){if(!Array.isArray(a))return B.onDrag([a],b);if(0!==a.length){var c=a[0].editor,d=b.pageY-c.drag.offsetY,k=b.pageX,e,h=!1,C=a[0];var g=C.dom.tr;var u=(0,q.getAbsoluteTop)(g);var l=g.offsetHeight;if(d<u){u=g;do{u=u.previousSibling;var m=B.getNodeFromTarget(u);var p=u?(0,q.getAbsoluteTop)(u):0}while(u&&d<p);m&&!m.parent&&(m=void 0);m||(u=(g=g.parentNode.firstChild)?g.nextSibling:void 0,m=B.getNodeFromTarget(u),m===C&&(m=void 0));
m&&m.isVisible()&&(p=(u=m.dom.tr)?(0,q.getAbsoluteTop)(u):0,d>p+l&&(m=void 0));!m||!1!==c.options.limitDragging&&m.parent!==a[0].parent||(a.forEach(function(a){m.parent.moveBefore(a,m)}),h=!0)}else if(g=a[a.length-1],e=(l=g.expanded&&g.append?g.append.getDom():g.dom.tr)?l.nextSibling:void 0){var n=(0,q.getAbsoluteTop)(e);do{var r=B.getNodeFromTarget(e);e&&(p=e.nextSibling?(0,q.getAbsoluteTop)(e.nextSibling):0,p=e?p-n:0,r&&r.parent.childs.length===a.length&&r.parent.childs[a.length-1]===g&&(u+=27),
e=e.nextSibling)}while(e&&d>u+p);if(r&&r.parent){p=c.drag.level+Math.round((k-c.drag.mouseX)/24/2);n=r.getLevel();for(u=r.dom.tr&&r.dom.tr.previousSibling;n<p&&u;){m=B.getNodeFromTarget(u);if(!a.some(function(a){return a===m||m.isDescendantOf(a)}))if(m instanceof O)if(n=m.parent.childs,n.length!==a.length||n[a.length-1]!==g)r=B.getNodeFromTarget(u),n=r.getLevel();else break;else break;u=u.previousSibling}r instanceof O&&!r.isVisible()&&r.parent.showMore.isVisible()&&(r=r._nextNode());r&&(!1===c.options.limitDragging||
r.parent===a[0].parent)&&r.dom.tr&&r.dom.tr!==l.nextSibling&&(a.forEach(function(a){r.parent.moveBefore(a,r)}),h=!0)}}h&&(c.drag.mouseX=k,c.drag.level=C.getLevel());c.startAutoScroll(d);b.preventDefault()}};B.onDragEnd=function(a,b){if(!Array.isArray(a))return B.onDrag([a],b);if(0!==a.length){var c=a[0],d=c.editor;c&&c.dom.menu&&c.dom.menu.focus();var k=d.drag.oldParent.getInternalPath(),e=c.parent.getInternalPath(),h=d.drag.oldParent===c.parent,g=d.drag.oldNextNode.getIndex();c=c.getIndex();var C=
d.drag.oldParentPathRedo,u=d.drag.oldIndexRedo,m=h&&u<c?c+a.length:c;h&&u===c||d._onAction("moveNodes",{count:a.length,fieldNames:a.map(G),oldParentPath:k,newParentPath:e,oldIndex:g,newIndex:c,oldIndexRedo:u,newIndexRedo:m,oldParentPathRedo:C,newParentPathRedo:null,oldSelection:d.drag.oldSelection,newSelection:d.getDomSelection()});document.body.style.cursor=d.drag.oldCursor;d.highlighter.unlock();a.forEach(function(a){a.updateDom();b.target!==a.dom.drag&&b.target!==a.dom.menu&&d.highlighter.unhighlight()});
delete d.drag;d.mousemove&&((0,q.removeEventListener)(b.view,"mousemove",d.mousemove),delete d.mousemove);d.mouseup&&((0,q.removeEventListener)(b.view,"mouseup",d.mouseup),delete d.mouseup);d.stopAutoScroll();b.preventDefault()}};B._findEnum=function(a){if(a["enum"])return a["enum"];if(a=a.oneOf||a.anyOf||a.allOf)if(a=a.filter(function(a){return a["enum"]}),0<a.length)return a[0]["enum"];return null};B._findSchema=function(a,b,c){var f=3<arguments.length&&void 0!==arguments[3]?arguments[3]:a,d=c.slice(1,
c.length),k=c[0],e=A(f.oneOf||f.anyOf||f.allOf||[f]),h;try{for(e.s();!(h=e.n()).done;){f=h.value;if("$ref"in f&&"string"===typeof f.$ref){var g,C=f.$ref;if(C in b)f=b[C];else if(C.startsWith("#/")){var u=C.substring(2).split("/");f=a;var m=A(u),l;try{for(m.s();!(l=m.n()).done;){var n=l.value;if(n in f)f=f[n];else throw Error("Unable to resovle reference ".concat(C));}}catch(U){m.e(U)}finally{m.f()}}else{if(1===(null===(g=C.match(/#\//g))||void 0===g?void 0:g.length)){var r=C.split("#/"),q,t;f=r;var v=
Array.isArray(f)?f:void 0;if(!(t=v))if(v=void 0,"undefined"!==typeof Symbol&&Symbol.iterator in Object(r)){f=[];k=!0;h=!1;g=void 0;try{for(var x=r[Symbol.iterator]();!(k=(v=x.next()).done)&&(f.push(v.value),2!==f.length);k=!0);}catch(U){h=!0,g=U}finally{try{if(!k&&null!=x["return"])x["return"]()}finally{if(h)throw g;}}t=f}else t=void 0;if(!(q=t||p(r,2)))throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
var y=q;var M=y[0],w=y[1];if(M in b){var z=b[M],P={$ref:"#/".concat(w)};return B._findSchema(z,b,d,P)}}throw Error("Unable to resolve reference ".concat(C));}}if(void 0===k)return f;if("string"===typeof k){if("object"===I(f.properties)&&null!==f.properties&&k in f.properties)return f=f.properties[k],B._findSchema(a,b,d,f);if("object"===I(f.patternProperties)&&null!==f.patternProperties)for(var H in f.patternProperties)if(k.match(H))return f=f.patternProperties[H],B._findSchema(a,b,d,f);if("object"===
I(f.additionalProperties))return f=f.additionalProperties,B._findSchema(a,b,d,f)}else if("number"===typeof k&&"object"===I(f.items)&&null!==f.items)return f=f.items,B._findSchema(a,b,d,f)}}catch(U){e.e(U)}finally{e.f()}return null};B.onRemove=function(a){if(!Array.isArray(a))return B.onRemove([a]);if(a&&0<a.length){var b=a[0],c=b.parent,d=b.editor;b=b.getIndex();d.highlighter.unhighlight();var e=d.getDomSelection();B.blurNodes(a);var h=d.getDomSelection(),g=a.map(D);a.forEach(function(a){a.parent._remove(a)});
d._onAction("removeNodes",{nodes:a,paths:g,parentPath:c.getInternalPath(),index:b,oldSelection:e,newSelection:h})}};B.onDuplicate=function(a){if(!Array.isArray(a))return B.onDuplicate([a]);if(a&&0<a.length){var b=a[a.length-1],c=b.parent,d=b.editor;d.deselect(d.multiselection.nodes);var e=d.getDomSelection(),h=b,g=a.map(function(a){var b=a.clone();if("object"===a.parent.type){var f=a.parent.getFieldNames();b.field=(0,q.findUniqueName)(a.field,f)}c.insertAfter(b,h);return h=b});1===a.length?"object"===
g[0].parent.type?(g[0].dom.field.innerHTML=a[0]._escapeHTML(a[0].field),g[0].focus("field")):g[0].focus():d.select(g);var C=d.getDomSelection();d._onAction("duplicateNodes",{paths:a.map(D),clonePaths:g.map(D),afterPath:b.getInternalPath(),parentPath:c.getInternalPath(),oldSelection:e,newSelection:C})}};B.getNodeFromTarget=function(a){for(;a;){if(a.node)return a.node;a=a.parentNode}};B.targetIsColorPicker=function(a){var b=B.getNodeFromTarget(a);if(b)for(a=a&&a.parentNode;a;){if(a===b.dom.color)return!0;
a=a.parentNode}return!1};B.blurNodes=function(a){if(Array.isArray(a)){var b=a[0],c=b.parent;b=b.getIndex();c.childs[b+a.length]?c.childs[b+a.length].focus():c.childs[b-1]?c.childs[b-1].focus():c.focus()}else B.blurNodes([a])};var O=function(a){function b(a){this.editor=a;this.dom={}}b.prototype=new a;b.prototype.getDom=function(){var a=this.dom;if(a.tr)return a.tr;this._updateEditability();var b=document.createElement("tr");b.className="jsoneditor-append";b.node=this;a.tr=b;if("tree"===this.editor.options.mode){a.tdDrag=
document.createElement("td");var c=document.createElement("td");a.tdMenu=c;var d=document.createElement("button");d.type="button";d.className="jsoneditor-button jsoneditor-contextmenu-button";d.title="Click to open the actions menu (Ctrl+M)";a.menu=d;c.appendChild(a.menu)}c=document.createElement("td");d=document.createElement("div");d.appendChild(document.createTextNode("("+(0,m.Iu)("empty")+")"));d.className="jsoneditor-readonly";c.appendChild(d);a.td=c;a.text=d;this.updateDom();return b};b.prototype.getPath=
function(){return null};b.prototype.getIndex=function(){return null};b.prototype.updateDom=function(a){a=this.dom;var b=a.td;b&&(b.style.paddingLeft=24*this.getLevel()+26+"px");var c=a.text;c&&(c.firstChild.nodeValue="("+(0,m.Iu)("empty")+" "+this.parent.type+")");c=a.tr;this.isVisible()?a.tr.firstChild||(a.tdDrag&&c.appendChild(a.tdDrag),a.tdMenu&&c.appendChild(a.tdMenu),c.appendChild(b)):a.tr.firstChild&&(a.tdDrag&&c.removeChild(a.tdDrag),a.tdMenu&&c.removeChild(a.tdMenu),c.removeChild(b))};b.prototype.isVisible=
function(){return 0===this.parent.childs.length};b.prototype.showContextMenu=function(a,b){var c=this,f=[{text:(0,m.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,m.Iu)("autoType"),click:function(){c._onAppend("","","auto")}},{text:(0,m.Iu)("array"),className:"jsoneditor-type-array",title:(0,m.Iu)("arrayType"),click:function(){c._onAppend("",[])}},{text:(0,m.Iu)("object"),className:"jsoneditor-type-object",title:(0,m.Iu)("objectType"),click:function(){c._onAppend("",{})}},{text:(0,m.Iu)("string"),
className:"jsoneditor-type-string",title:(0,m.Iu)("stringType"),click:function(){c._onAppend("","","string")}}];c.addTemplates(f,!0);f=[{text:(0,m.Iu)("appendText"),title:(0,m.Iu)("appendTitleAuto"),submenuTitle:(0,m.Iu)("appendSubmenuTitle"),className:"jsoneditor-insert",click:function(){c._onAppend("","","auto")},submenu:f}];if(this.editor.options.onCreateMenu){var d=c.parent.getPath();f=this.editor.options.onCreateMenu(f,{type:"append",path:d,paths:[d]})}(new u.x(f,{close:b})).show(a,this.editor.getPopupAnchor())};
b.prototype.onEvent=function(a){var b=a.type,c=a.target||a.srcElement,f=this.dom;c===f.menu&&("mouseover"===b?this.editor.highlighter.highlight(this.parent):"mouseout"===b&&this.editor.highlighter.unhighlight());if("click"===b&&c===f.menu){var d=this.editor.highlighter;d.highlight(this.parent);d.lock();(0,q.addClassName)(f.menu,"jsoneditor-selected");this.showContextMenu(f.menu,function(){(0,q.removeClassName)(f.menu,"jsoneditor-selected");d.unlock();d.unhighlight()})}if("keydown"===b)this.onKeyDown(a)};
return b}(B),ca=function(a){function b(a,b){this.editor=a;this.parent=b;this.dom={}}b.prototype=new a;b.prototype.getDom=function(){if(this.dom.tr)return this.dom.tr;this._updateEditability();if(!this.dom.tr){var a=this,b=this.parent,c=document.createElement("a");c.appendChild(document.createTextNode((0,m.Iu)("showMore")));c.href="#";c.onclick=function(c){b.visibleChilds=Math.floor(b.visibleChilds/b.getMaxVisibleChilds()+1)*b.getMaxVisibleChilds();a.updateDom();b.showChilds();c.preventDefault();return!1};
var d=document.createElement("a");d.appendChild(document.createTextNode((0,m.Iu)("showAll")));d.href="#";d.onclick=function(c){b.visibleChilds=Infinity;a.updateDom();b.showChilds();c.preventDefault();return!1};var e=document.createElement("div"),k=document.createTextNode(this._getShowMoreText());e.className="jsoneditor-show-more";e.appendChild(k);e.appendChild(c);e.appendChild(document.createTextNode(". "));e.appendChild(d);e.appendChild(document.createTextNode(". "));c=document.createElement("td");
c.appendChild(e);d=document.createElement("tr");"tree"===this.editor.options.mode&&(d.appendChild(document.createElement("td")),d.appendChild(document.createElement("td")));d.appendChild(c);d.className="jsoneditor-show-more";this.dom.tr=d;this.dom.moreContents=e;this.dom.moreText=k}this.updateDom();return this.dom.tr};b.prototype.updateDom=function(a){this.isVisible()?(this.dom.tr.node=this.parent.childs[this.parent.visibleChilds],this.dom.tr.parentNode||(a=this.parent._getNextTr())&&a.parentNode.insertBefore(this.dom.tr,
a),this.dom.moreText.nodeValue=this._getShowMoreText(),this.dom.moreContents.style.marginLeft=24*(this.getLevel()+1)+"px"):this.dom.tr&&this.dom.tr.parentNode&&this.dom.tr.parentNode.removeChild(this.dom.tr)};b.prototype._getShowMoreText=function(){return(0,m.Iu)("showMoreStatus",{visibleChilds:this.parent.visibleChilds,totalChilds:this.parent.childs.length})+" "};b.prototype.isVisible=function(){return this.parent.expanded&&this.parent.childs.length>this.parent.visibleChilds};b.prototype.onEvent=
function(a){if("keydown"===a.type)this.onKeyDown(a)};return b}(B),da=function(){function a(b){function c(a){return b.node.findNodeByInternalPath(a)}if(!(this instanceof a))throw new TypeError("Cannot call a class as a function");this.editor=b;this.history=[];this.index=-1;this.clear();this.actions={editField:{undo:function(a){c(a.parentPath).childs[a.index].updateField(a.oldValue)},redo:function(a){c(a.parentPath).childs[a.index].updateField(a.newValue)}},editValue:{undo:function(a){c(a.path).updateValue(a.oldValue)},
redo:function(a){c(a.path).updateValue(a.newValue)}},changeType:{undo:function(a){c(a.path).changeType(a.oldType)},redo:function(a){c(a.path).changeType(a.newType)}},appendNodes:{undo:function(a){var b=c(a.parentPath);a.paths.map(c).forEach(function(a){b.removeChild(a)})},redo:function(a){var b=c(a.parentPath);a.nodes.forEach(function(a){b.appendChild(a)})}},insertBeforeNodes:{undo:function(a){var b=c(a.parentPath);a.paths.map(c).forEach(function(a){b.removeChild(a)})},redo:function(a){var b=c(a.parentPath),
f=c(a.beforePath);a.nodes.forEach(function(a){b.insertBefore(a,f)})}},insertAfterNodes:{undo:function(a){var b=c(a.parentPath);a.paths.map(c).forEach(function(a){b.removeChild(a)})},redo:function(a){var b=c(a.parentPath),f=c(a.afterPath);a.nodes.forEach(function(a){b.insertAfter(a,f);f=a})}},removeNodes:{undo:function(a){var b=c(a.parentPath),f=b.childs[a.index]||b.append;a.nodes.forEach(function(a){b.insertBefore(a,f)})},redo:function(a){var b=c(a.parentPath);a.paths.map(c).forEach(function(a){b.removeChild(a)})}},
duplicateNodes:{undo:function(a){var b=c(a.parentPath);a.clonePaths.map(c).forEach(function(a){b.removeChild(a)})},redo:function(a){var b=c(a.parentPath),f=c(a.afterPath);a.paths.map(c).forEach(function(a){var c=a.clone();if("object"===b.type){var d=b.getFieldNames();c.field=(0,q.findUniqueName)(a.field,d)}b.insertAfter(c,f);f=c})}},moveNodes:{undo:function(a){var b=c(a.oldParentPath),f=c(a.newParentPath),d=b.childs[a.oldIndex]||b.append;f.childs.slice(a.newIndex,a.newIndex+a.count).forEach(function(c,
f){c.field=a.fieldNames[f];b.moveBefore(c,d)});null===a.newParentPathRedo&&(a.newParentPathRedo=f.getInternalPath())},redo:function(a){var b=c(a.oldParentPathRedo),f=c(a.newParentPathRedo),d=f.childs[a.newIndexRedo]||f.append;b.childs.slice(a.oldIndexRedo,a.oldIndexRedo+a.count).forEach(function(b,c){b.field=a.fieldNames[c];f.moveBefore(b,d)})}},sort:{undo:function(a){var b=c(a.path);b.hideChilds();b.childs=a.oldChilds;b.updateDom({updateIndexes:!0});b.showChilds()},redo:function(a){var b=c(a.path);
b.hideChilds();b.childs=a.newChilds;b.updateDom({updateIndexes:!0});b.showChilds()}},transform:{undo:function(a){c(a.path).setInternalValue(a.oldValue)},redo:function(a){c(a.path).setInternalValue(a.newValue)}}}}v(a,[{key:"onChange",value:function(){}},{key:"add",value:function(a,b){this.index++;this.history[this.index]={action:a,params:b,timestamp:new Date};this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1);this.onChange()}},{key:"clear",value:function(){this.history=
[];this.index=-1;this.onChange()}},{key:"canUndo",value:function(){return 0<=this.index}},{key:"canRedo",value:function(){return this.index<this.history.length-1}},{key:"undo",value:function(){if(this.canUndo()){var a=this.history[this.index];if(a){var b=this.actions[a.action];if(b&&b.undo){if(b.undo(a.params),a.params.oldSelection)try{this.editor.setDomSelection(a.params.oldSelection)}catch(E){console.error(E)}}else console.error(Error('unknown action "'+a.action+'"'))}this.index--;this.onChange()}}},
{key:"redo",value:function(){if(this.canRedo()){this.index++;var a=this.history[this.index];if(a){var b=this.actions[a.action];if(b&&b.redo){if(b.redo(a.params),a.params.newSelection)try{this.editor.setDomSelection(a.params.newSelection)}catch(E){console.error(E)}}else console.error(Error('unknown action "'+a.action+'"'))}this.onChange()}}},{key:"destroy",value:function(){this.editor=null;this.history=[];this.index=-1}}]);return a}(),V=function(){function a(b,c){if(!(this instanceof a))throw new TypeError("Cannot call a class as a function");
var f=this;this.editor=b;this.timeout=void 0;this.delay=200;this.lastText=void 0;this.results=null;this.dom={};this.dom.container=c;b=document.createElement("div");this.dom.wrapper=b;b.className="jsoneditor-search";c.appendChild(b);c=document.createElement("div");this.dom.results=c;c.className="jsoneditor-results";b.appendChild(c);c=document.createElement("div");this.dom.input=c;c.className="jsoneditor-frame";c.title=(0,m.Iu)("searchTitle");b.appendChild(c);b=document.createElement("button");b.type=
"button";b.className="jsoneditor-refresh";c.appendChild(b);var d=document.createElement("input");d.type="text";this.dom.search=d;d.oninput=function(a){f._onDelayedSearch(a)};d.onchange=function(a){f._onSearch()};d.onkeydown=function(a){f._onKeyDown(a)};d.onkeyup=function(a){f._onKeyUp(a)};b.onclick=function(a){d.select()};c.appendChild(d);b=document.createElement("button");b.type="button";b.title=(0,m.Iu)("searchNextResultTitle");b.className="jsoneditor-next";b.onclick=function(){f.next()};c.appendChild(b);
b=document.createElement("button");b.type="button";b.title=(0,m.Iu)("searchPreviousResultTitle");b.className="jsoneditor-previous";b.onclick=function(){f.previous()};c.appendChild(b)}g(a,[{key:"next",value:function(a){if(this.results){var b=null!==this.resultIndex?this.resultIndex+1:0;b>this.results.length-1&&(b=0);this._setActiveResult(b,a)}}},{key:"previous",value:function(a){if(this.results){var b=this.results.length-1,c=null!==this.resultIndex?this.resultIndex-1:b;0>c&&(c=b);this._setActiveResult(c,
a)}}},{key:"_setActiveResult",value:function(a,b){if(this.activeResult){var c=this.activeResult.node;"field"===this.activeResult.elem?delete c.searchFieldActive:delete c.searchValueActive;c.updateDom()}if(this.results&&this.results[a]){this.resultIndex=a;var f=this.results[this.resultIndex].node,d=this.results[this.resultIndex].elem;"field"===d?f.searchFieldActive=!0:f.searchValueActive=!0;this.activeResult=this.results[this.resultIndex];f.updateDom();f.scrollTo(function(){b&&f.focus(d)})}else this.activeResult=
this.resultIndex=void 0}},{key:"_clearDelay",value:function(){void 0!==this.timeout&&(clearTimeout(this.timeout),delete this.timeout)}},{key:"_onDelayedSearch",value:function(a){this._clearDelay();var b=this;this.timeout=setTimeout(function(a){b._onSearch()},this.delay)}},{key:"_onSearch",value:function(a){this._clearDelay();var b=this.dom.search.value;b=0<b.length?b:void 0;if(b!==this.lastText||a){this.lastText=b;this.results=this.editor.search(b);a=this.results[0]?this.results[0].node.MAX_SEARCH_RESULTS:
Infinity;var c=0;if(this.activeResult)for(var d=0;d<this.results.length;d++)if(this.results[d].node===this.activeResult.node){c=d;break}this._setActiveResult(c,!1);void 0!==b?(b=this.results.length,this.dom.results.textContent=0===b?"no\u00a0results":1===b?"1\u00a0result":b>a?a+"+\u00a0results":b+"\u00a0results"):this.dom.results.textContent=""}}},{key:"_onKeyDown",value:function(a){var b=a.which;27===b?(this.dom.search.value="",this._onSearch(),a.preventDefault(),a.stopPropagation()):13===b&&(a.ctrlKey?
this._onSearch(!0):a.shiftKey?this.previous():this.next(),a.preventDefault(),a.stopPropagation())}},{key:"_onKeyUp",value:function(a){var b=a.keyCode;27!==b&&13!==b&&this._onDelayedSearch(a)}},{key:"clear",value:function(){this.dom.search.value="";this._onSearch()}},{key:"forceSearch",value:function(){this._onSearch(!0)}},{key:"isEmpty",value:function(){return""===this.dom.search.value}},{key:"destroy",value:function(){this.editor=null;this.dom.container.removeChild(this.dom.wrapper);this.activeResult=
this.results=this.dom=null;this._clearDelay()}}]);return a}(),Z=function(){function a(b,c){if(!(this instanceof a))throw new TypeError("Cannot call a class as a function");b&&(this.root=c,this.path=document.createElement("div"),this.path.className="jsoneditor-treepath",this.path.setAttribute("tabindex",0),this.contentMenuClicked=!1,b.appendChild(this.path),this.reset())}c(a,[{key:"reset",value:function(){this.path.textContent=(0,m.Iu)("selectNode")}},{key:"setPath",value:function(a){function b(a){e.contentMenuClicked=
!1;(0,q.addClassName)(e.path,"show-all");e.path.style.width=e.path.parentNode.getBoundingClientRect().width-10+"px";e.path.onblur=function(){e.contentMenuClicked?(e.contentMenuClicked=!1,e.path.focus()):((0,q.removeClassName)(e.path,"show-all"),e.path.onblur=void 0,e.path.style.width="",e.setPath(a))}}function c(a){this.selectionCallback&&this.selectionCallback(a)}function d(a,b){this.contextMenuCallback&&this.contextMenuCallback(a,b)}var e=this;this.path.textContent="";a&&a.length&&a.forEach(function(f,
h){var k=document.createElement("span");k.className="jsoneditor-treepath-element";k.innerText=f.name;k.onclick=c.bind(e,f);e.path.appendChild(k);if(f.children.length){var g=document.createElement("span");g.className="jsoneditor-treepath-seperator";g.textContent="\u25ba";g.onclick=function(){e.contentMenuClicked=!0;var b=[];f.children.forEach(function(c){b.push({text:c.name,className:"jsoneditor-type-modes"+(a[h+1]+1&&a[h+1].name===c.name?" jsoneditor-selected":""),click:d.bind(e,f,c.name)})});(new u.x(b,
{limitHeight:!0})).show(g,e.root,!0)};e.path.appendChild(g)}h===a.length-1&&(k=(g||k).getBoundingClientRect().right,e.path.offsetWidth<k&&(e.path.scrollLeft=k),e.path.scrollLeft&&(k=document.createElement("span"),k.className="jsoneditor-treepath-show-all-btn",k.title="show all path",k.textContent="...",k.onclick=b.bind(e,a),e.path.insertBefore(k,e.path.firstChild)))})}},{key:"onSectionSelected",value:function(a){"function"===typeof a&&(this.selectionCallback=a)}},{key:"onContextMenuItemSelected",
value:function(a){"function"===typeof a&&(this.contextMenuCallback=a)}}]);return a}();w=d(37);var Y=d.n(w);d={create:function(a,b){if(!a)throw Error("No container element provided.");this.container=a;this.dom={};this.highlighter=new S;this.selection=void 0;this.multiselection={nodes:[]};this.validateSchema=null;this.validationSequence=0;this.errorNodes=[];this.lastSchemaErrors=void 0;this.focusTarget=this.node=null;this._setOptions(b);b.autocomplete&&(this.autocomplete=r(b.autocomplete));this.options.history&&
"view"!==this.options.mode&&(this.history=new da(this));this._createFrame();this._createTable()},destroy:function(){this.frame&&this.container&&this.frame.parentNode===this.container&&(this.container.removeChild(this.frame),this.frame=null);this.dom=this.container=null;this.clear();this._debouncedValidate=this.validateSchema=this.errorNodes=this.multiselection=this.selection=this.focusTarget=this.node=null;this.history&&(this.history.destroy(),this.history=null);this.searchBox&&(this.searchBox.destroy(),
this.searchBox=null);this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null);this.frameFocusTracker.destroy()},_setOptions:function(a){var b=this;this.options={search:!0,history:!0,mode:"tree",name:void 0,schema:null,schemaRefs:null,autocomplete:null,navigationBar:!0,mainMenuBar:!0,limitDragging:!1,onSelectionChange:null,colorPicker:!0,onColorPicker:function(a,b,c){if(Y()){var d=a.getBoundingClientRect().top;d=300>(0,q.getWindow)(a).innerHeight-d&&300<d;(new (Y())({parent:a,color:b,
popup:d?"top":"bottom",onDone:function(a){a=1===a.rgba[3]?a.hex.substr(0,7):a.hex;c(a)}})).show()}else console.warn("Cannot open color picker: the `vanilla-picker` library is not included in the bundle. Either use the full bundle or implement your own color picker using `onColorPicker`.")},timestampTag:!0,timestampFormat:null,createQuery:H.r,executeQuery:H.J,onEvent:null,enableSort:!0,enableTransform:!0};a&&(Object.keys(a).forEach(function(c){b.options[c]=a[c]}),null==a.limitDragging&&null!=a.schema&&
(this.options.limitDragging=!0));this.setSchema(this.options.schema,this.options.schemaRefs);this._debouncedValidate=(0,q.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL);if(a.onSelectionChange)this.onSelectionChange(a.onSelectionChange);(0,m.cC)(this.options.languages);(0,m.m0)(this.options.language)},set:function(a){a instanceof Function||void 0===a?this.clear():(this.content.removeChild(this.table),a=new B(this,{field:this.options.name,value:a}),this._setRoot(a),this.validate(),this.node.expand(!1),
this.content.appendChild(this.table));this.history&&this.history.clear();this.searchBox&&this.searchBox.clear()},update:function(a){if(!this.node.deepEqual(a)){var b=this.getSelection();this.onChangeDisabled=!0;this.node.update(a);this.onChangeDisabled=!1;this.validate();this.searchBox&&!this.searchBox.isEmpty()&&this.searchBox.forceSearch();if(b&&b.start&&b.end){a=this.node.findNodeByPath(b.start.path);var c=this.node.findNodeByPath(b.end.path);a&&c?this.setSelection(b.start,b.end):this.setSelection({},
{})}else this.setSelection({},{})}},get:function(){if(this.node)return this.node.getValue()},getText:function(){return JSON.stringify(this.get())},setText:function(a){try{this.set((0,q.parse)(a))}catch(k){a=(0,q.tryJsonRepair)(a),this.set((0,q.parse)(a))}},updateText:function(a){try{this.update((0,q.parse)(a))}catch(k){a=(0,q.tryJsonRepair)(a),this.update((0,q.parse)(a))}},setName:function(a){this.options.name=a;this.node&&this.node.updateField(this.options.name)},getName:function(){return this.options.name},
focus:function(){var a=this.scrollableContent.querySelector("[contenteditable=true]");a?a.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(a=this.frame.querySelector("button"))&&a.focus()},clear:function(){this.node&&(this.node.hide(),delete this.node);this.treePath&&this.treePath.reset()},_setRoot:function(a){this.clear();this.node=a;a.setParent(null);a.setField(this.getName(),!1);delete a.index;this.tbody.appendChild(a.getDom())},search:function(a){this.node?
(this.content.removeChild(this.table),a=this.node.search(a),this.content.appendChild(this.table)):a=[];return a},expandAll:function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},collapseAll:function(){this.node&&(this.content.removeChild(this.table),this.node.collapse(),this.content.appendChild(this.table))},_onAction:function(a,b){this.history&&this.history.add(a,b);this._onChange()},_onChange:function(){if(!this.onChangeDisabled){this.selection=
this.getDomSelection();this._debouncedValidate();if(this.treePath){var a=this.node&&this.selection?this.node.findNodeByInternalPath(this.selection.path):this.multiselection?this.multiselection.nodes[0]:void 0;a?this._updateTreePath(a.getNodePath()):this.treePath.reset()}if(this.options.onChange)try{this.options.onChange()}catch(k){console.error("Error in onChange callback: ",k)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(k){console.error("Error in onChangeJSON callback: ",
k)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(k){console.error("Error in onChangeText callback: ",k)}this.options.onClassName&&this.node.recursivelyUpdateCssClassesOnNodes();if(this.options.onNodeName&&this.node.childs)try{this.node.recursivelyUpdateNodeName()}catch(k){console.error("Error in onNodeName callback: ",k)}}},validate:function(){var a=this,b=this.node;if(b){var c=b.getValue(),d=[];this.validateSchema&&(this.validateSchema(c)||(d=this.validateSchema.errors.map(function(a){return(0,
q.improveSchemaError)(a)}).map(function(a){return{node:b.findNode(a.dataPath),error:a,type:"validation"}}).filter(function(a){return null!=a.node})));try{this.validationSequence++;var e=this,h=this.validationSequence;this._validateCustom(c).then(function(b){h===e.validationSequence&&(b=[].concat(d,b||[]),e._renderValidationErrors(b),"function"===typeof a.options.onValidationError&&((0,q.isValidationErrorChanged)(b,a.lastSchemaErrors)&&a.options.onValidationError.call(a,b),a.lastSchemaErrors=b))})["catch"](function(a){console.error(a)})}catch(R){console.error(R)}}},
_renderValidationErrors:function(a){this.errorNodes&&this.errorNodes.forEach(function(a){a.setError(null)});this.errorNodes=a.reduce(function(a,b){return b.node.findParents().filter(function(b){return!a.some(function(a){return a[0]===b})}).map(function(a){return[a,b.node]}).concat(a)},[]).map(function(a){return{node:a[0],child:a[1],error:{message:"object"===a[0].type?(0,m.Iu)("containsInvalidProperties"):(0,m.Iu)("containsInvalidItems")}}}).concat(a).map(function(a){a.node.setError(a.error,a.child);
return a.node})},_validateCustom:function(a){try{if(this.options.onValidate){var b=this.node,c=this.options.onValidate(a);return((0,q.isPromise)(c)?c:Promise.resolve(c)).then(function(a){return Array.isArray(a)?a.filter(function(a){var b=(0,q.isValidValidationError)(a);b||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',a);return b}).map(function(a){try{var c=a&&a.path?b.findNodeByPath(a.path):null}catch(R){}c||
console.warn("Ignoring validation error: node not found. Path:",a.path,"Error:",a);return{node:c,error:a,type:"customValidation"}}).filter(function(a){return a&&a.node&&a.error&&a.error.message}):null})}}catch(E){return Promise.reject(E)}return Promise.resolve(null)},refresh:function(){this.node&&this.node.updateDom({recurse:!0})},startAutoScroll:function(a){var b=this,c=this.scrollableContent,d=(0,q.getAbsoluteTop)(c),e=c.clientHeight,h=d+e;(this.autoScrollStep=a<d+24&&0<c.scrollTop?(d+24-a)/3:a>
h-24&&e+c.scrollTop<c.scrollHeight?(h-24-a)/3:void 0)?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){b.autoScrollStep?c.scrollTop-=b.autoScrollStep:b.stopAutoScroll()},50)):this.stopAutoScroll()},stopAutoScroll:function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer);this.autoScrollStep&&delete this.autoScrollStep},setDomSelection:function(a){if(a)if("scrollTop"in a&&this.scrollableContent&&(this.scrollableContent.scrollTop=a.scrollTop),
a.paths){var b=this;a=a.paths.map(function(a){return b.node.findNodeByInternalPath(a)});this.select(a)}else{var c=a.path?this.node.findNodeByInternalPath(a.path):null,d=c&&a.domName?c.dom[a.domName]:null;a.range&&d?(a=Object.assign({},a.range,{container:d}),(0,q.setSelectionOffset)(a)):c&&c.focus()}},getDomSelection:function(){var a=B.getNodeFromTarget(this.focusTarget),b=this.focusTarget,c=a?Object.keys(a.dom).find(function(c){return a.dom[c]===b}):null,d=(0,q.getSelectionOffset)();d&&"DIV"!==d.container.nodeName&&
(d=null);d&&d.container!==b&&(d=null);d&&delete d.container;return{path:a?a.getInternalPath():null,domName:c,range:d,paths:0<this.multiselection.length?this.multiselection.nodes.map(function(a){return a.getInternalPath()}):null,scrollTop:this.scrollableContent?this.scrollableContent.scrollTop:0}},scrollTo:function(a,b){var c=this.scrollableContent;if(c){var d=this;d.animateTimeout&&(clearTimeout(d.animateTimeout),delete d.animateTimeout);d.animateCallback&&(d.animateCallback(!1),delete d.animateCallback);
var e=c.clientHeight,h=Math.min(Math.max(a-e/4,0),c.scrollHeight-e);(function ea(){var a=h-c.scrollTop;3<Math.abs(a)?(c.scrollTop+=a/3,d.animateCallback=b,d.animateTimeout=setTimeout(ea,50)):(b&&b(!0),c.scrollTop=h,delete d.animateTimeout,delete d.animateCallback)})()}else b&&b(!1)},_createFrame:function(){function a(a){b._onEvent&&b._onEvent(a)}this.frame=document.createElement("div");this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode;this.container.appendChild(this.frame);this.contentOuter=
document.createElement("div");this.contentOuter.className="jsoneditor-outer";var b=this;this.frameFocusTracker=new M.R({target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null});this.frame.onclick=function(b){var c=b.target;a(b);"BUTTON"===c.nodeName&&b.preventDefault()};this.frame.oninput=a;this.frame.onchange=a;this.frame.onkeydown=a;this.frame.onkeyup=a;this.frame.oncut=a;this.frame.onpaste=a;this.frame.onmousedown=a;this.frame.onmouseup=a;this.frame.onmouseover=a;
this.frame.onmouseout=a;(0,q.addEventListener)(this.frame,"focus",a,!0);(0,q.addEventListener)(this.frame,"blur",a,!0);this.frame.onfocusin=a;this.frame.onfocusout=a;if(this.options.mainMenuBar){(0,q.addClassName)(this.contentOuter,"has-main-menu-bar");this.menu=document.createElement("div");this.menu.className="jsoneditor-menu";this.frame.appendChild(this.menu);var c=document.createElement("button");c.type="button";c.className="jsoneditor-expand-all";c.title=(0,m.Iu)("expandAll");c.onclick=function(){b.expandAll()};
this.menu.appendChild(c);c=document.createElement("button");c.type="button";c.title=(0,m.Iu)("collapseAll");c.className="jsoneditor-collapse-all";c.onclick=function(){b.collapseAll()};this.menu.appendChild(c);this.options.enableSort&&(c=document.createElement("button"),c.type="button",c.className="jsoneditor-sort",c.title=(0,m.Iu)("sortTitleShort"),c.onclick=function(){b.node.showSortModal()},this.menu.appendChild(c));this.options.enableTransform&&(c=document.createElement("button"),c.type="button",
c.title=(0,m.Iu)("transformTitleShort"),c.className="jsoneditor-transform",c.onclick=function(){b.node.showTransformModal()},this.menu.appendChild(c));if(this.history){var d=document.createElement("button");d.type="button";d.className="jsoneditor-undo jsoneditor-separator";d.title=(0,m.Iu)("undo");d.onclick=function(){b._onUndo()};this.menu.appendChild(d);this.dom.undo=d;var e=document.createElement("button");e.type="button";e.className="jsoneditor-redo";e.title=(0,m.Iu)("redo");e.onclick=function(){b._onRedo()};
this.menu.appendChild(e);this.dom.redo=e;this.history.onChange=function(){d.disabled=!b.history.canUndo();e.disabled=!b.history.canRedo()};this.history.onChange()}if(this.options&&this.options.modes&&this.options.modes.length){var h=this;this.modeSwitcher=new K.x(this.menu,this.options.modes,this.options.mode,function(a){h.setMode(a);h.modeSwitcher.focus()})}this.options.search&&(this.searchBox=new V(this,this.menu))}this.options.navigationBar&&(this.navBar=document.createElement("div"),this.navBar.className=
"jsoneditor-navigation-bar nav-bar-empty",this.frame.appendChild(this.navBar),this.treePath=new Z(this.navBar,this.getPopupAnchor()),this.treePath.onSectionSelected(this._onTreePathSectionSelected.bind(this)),this.treePath.onContextMenuItemSelected(this._onTreePathMenuItemSelected.bind(this)))},_onUndo:function(){this.history&&(this.history.undo(),this._onChange())},_onRedo:function(){this.history&&(this.history.redo(),this._onChange())},_onEvent:function(a){if(!B.targetIsColorPicker(a.target)){var b=
B.getNodeFromTarget(a.target);"keydown"===a.type&&this._onKeyDown(a);b&&"focus"===a.type&&(this.focusTarget=a.target,this.options.autocomplete&&"focus"===this.options.autocomplete.trigger&&this._showAutoComplete(a.target));"mousedown"===a.type&&this._startDragDistance(a);"mousemove"!==a.type&&"mouseup"!==a.type&&"click"!==a.type||this._updateDragDistance(a);if(b&&this.options&&this.options.navigationBar&&b&&("keydown"===a.type||"mousedown"===a.type)){var c=this;setTimeout(function(){c._updateTreePath(b.getNodePath())})}if(b&&
b.selected){if("click"===a.type){if(a.target===b.dom.menu){this.showContextMenu(a.target);return}a.hasMoved||this.deselect()}if("mousedown"===a.type)B.onDragStart(this.multiselection.nodes,a)}else if("mousedown"===a.type&&(0,q.hasParentNode)(a.target,this.content))if(this.deselect(),b&&a.target===b.dom.drag)B.onDragStart(b,a);else(!b||a.target!==b.dom.field&&a.target!==b.dom.value&&a.target!==b.dom.select)&&this._onMultiSelectStart(a);if(b)b.onEvent(a)}},_updateTreePath:function(a){function b(a){return a.parent?
"array"===a.parent.type?a.index:a.field:a.field||a.type}if(a&&a.length){(0,q.removeClassName)(this.navBar,"nav-bar-empty");var c=[];a.forEach(function(a){var d={name:b(a),node:a,children:[]};a.childs&&a.childs.length&&a.childs.forEach(function(a){d.children.push({name:b(a),node:a})});c.push(d)});this.treePath.setPath(c)}else(0,q.addClassName)(this.navBar,"nav-bar-empty")},_onTreePathSectionSelected:function(a){a&&a.node&&(a.node.expandTo(),a.node.focus())},_onTreePathMenuItemSelected:function(a,b){a&&
a.children.length&&(a=a.children.find(function(a){return a.name===b}))&&a.node&&(this._updateTreePath(a.node.getNodePath()),a.node.expandTo(),a.node.focus())},_startDragDistance:function(a){this.dragDistanceEvent={initialTarget:a.target,initialPageX:a.pageX,initialPageY:a.pageY,dragDistance:0,hasMoved:!1}},_updateDragDistance:function(a){this.dragDistanceEvent||this._startDragDistance(a);var b=a.pageX-this.dragDistanceEvent.initialPageX,c=a.pageY-this.dragDistanceEvent.initialPageY;this.dragDistanceEvent.dragDistance=
Math.sqrt(b*b+c*c);this.dragDistanceEvent.hasMoved=this.dragDistanceEvent.hasMoved||10<this.dragDistanceEvent.dragDistance;a.dragDistance=this.dragDistanceEvent.dragDistance;a.hasMoved=this.dragDistanceEvent.hasMoved;return a.dragDistance},_onMultiSelectStart:function(a){var b=B.getNodeFromTarget(a.target);if("tree"===this.options.mode&&void 0===this.options.onEditable){this.multiselection={start:b||null,end:null,nodes:[]};this._startDragDistance(a);var c=this;this.mousemove||(this.mousemove=(0,q.addEventListener)(a.view,
"mousemove",function(a){c._onMultiSelect(a)}));this.mouseup||(this.mouseup=(0,q.addEventListener)(a.view,"mouseup",function(a){c._onMultiSelectEnd(a)}));a.preventDefault()}},_onMultiSelect:function(a){a.preventDefault();this._updateDragDistance(a);if(a.hasMoved){if(a=B.getNodeFromTarget(a.target))null==this.multiselection.start&&(this.multiselection.start=a),this.multiselection.end=a;this.deselect();a=this.multiselection.start;var b=this.multiselection.end||this.multiselection.start;a&&b&&(this.multiselection.nodes=
this._findTopLevelNodes(a,b),this.multiselection.nodes&&this.multiselection.nodes.length&&(a=this.multiselection.nodes[0],this.multiselection.start===a||this.multiselection.start.isDescendantOf(a)?this.multiselection.direction="down":this.multiselection.direction="up"),this.select(this.multiselection.nodes))}},_onMultiSelectEnd:function(a){var b=this.multiselection.nodes[0];b&&b.dom.menu&&b.dom.menu.focus();this.multiselection.start=null;this.multiselection.end=null;this.mousemove&&((0,q.removeEventListener)(a.view,
"mousemove",this.mousemove),delete this.mousemove);this.mouseup&&((0,q.removeEventListener)(a.view,"mouseup",this.mouseup),delete this.mouseup)},deselect:function(a){var b=!!this.multiselection.nodes.length;this.multiselection.nodes.forEach(function(a){a.setSelected(!1)});this.multiselection.nodes=[];a&&(this.multiselection.start=null,this.multiselection.end=null);b&&this._selectionChangedHandler&&this._selectionChangedHandler()},select:function(a){if(!Array.isArray(a))return this.select([a]);if(a){this.deselect();
this.multiselection.nodes=a.slice(0);var b=a[0];a.forEach(function(a){a.expandPathToNode();a.setSelected(!0,a===b)});this._selectionChangedHandler&&(a=this.getSelection(),this._selectionChangedHandler(a.start,a.end))}},_findTopLevelNodes:function(a,b){a=a.getNodePath();for(var c=b.getNodePath(),d=0;d<a.length&&a[d]===c[d];)d++;b=a[d-1];a=a[d];c=c[d];a&&c||(b.parent?(c=a=b,b=b.parent):(a=b.childs[0],c=b.childs[b.childs.length-1]));return b&&a&&c?(a=b.childs.indexOf(a),c=b.childs.indexOf(c),b.childs.slice(Math.min(a,
c),Math.max(a,c)+1)):[]},_showAutoComplete:function(a){var b=B.getNodeFromTarget(a),c="";0<=a.className.indexOf("jsoneditor-value")&&(c="value");0<=a.className.indexOf("jsoneditor-field")&&(c="field");if(""!==c){var d=this;setTimeout(function(){if(b&&("focus"===d.options.autocomplete.trigger||0<a.innerText.length)){var f=d.options.autocomplete.getOptions(a.innerText,b.getPath(),c,b.editor);if(null===f)d.autocomplete.hideDropDown();else if("function"===typeof f.then)f.then(function(b){null===b?d.autocomplete.hideDropDown():
b.options?d.autocomplete.show(a,b.startFrom,b.options):d.autocomplete.show(a,0,b)})["catch"](function(a){console.error(a)});else f.options?d.autocomplete.show(a,f.startFrom,f.options):d.autocomplete.show(a,0,f)}else d.autocomplete.hideDropDown()},50)}},_onKeyDown:function(a){var b=a.which||a.keyCode,c=a.altKey,d=a.ctrlKey,e=a.metaKey,h=a.shiftKey,g=!1,u=this.focusTarget;if(9===b){var m=this;setTimeout(function(){m.focusTarget!==u&&(0,q.selectContentEditable)(m.focusTarget)},0)}if(this.searchBox)if(d&&
70===b)this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),g=!0;else if(114===b||d&&71===b)h?this.searchBox.previous(!0):this.searchBox.next(!0),g=!0;this.history&&(d&&!h&&90===b?(this._onUndo(),g=!0):d&&h&&90===b&&(this._onRedo(),g=!0));!this.options.autocomplete||g||d||c||e||1!==a.key.length&&8!==b&&46!==b||(g=!1,this._showAutoComplete(a.target));g&&(a.preventDefault(),a.stopPropagation())},_createTable:function(){this.options.navigationBar&&(0,q.addClassName)(this.contentOuter,
"has-nav-bar");this.scrollableContent=document.createElement("div");this.scrollableContent.className="jsoneditor-tree";this.contentOuter.appendChild(this.scrollableContent);this.content=document.createElement("div");this.content.className="jsoneditor-tree-inner";this.scrollableContent.appendChild(this.content);this.table=document.createElement("table");this.table.className="jsoneditor-tree";this.content.appendChild(this.table);this.colgroupContent=document.createElement("colgroup");if("tree"===this.options.mode){var a=
document.createElement("col");a.width="24px";this.colgroupContent.appendChild(a)}a=document.createElement("col");a.width="24px";this.colgroupContent.appendChild(a);a=document.createElement("col");this.colgroupContent.appendChild(a);this.table.appendChild(this.colgroupContent);this.tbody=document.createElement("tbody");this.table.appendChild(this.tbody);this.frame.appendChild(this.contentOuter)},showContextMenu:function(a,b){var c=[],d=this.multiselection.nodes.slice();c.push({text:(0,m.Iu)("duplicateText"),
title:(0,m.Iu)("duplicateTitle"),className:"jsoneditor-duplicate",click:function(){B.onDuplicate(d)}});c.push({text:(0,m.Iu)("remove"),title:(0,m.Iu)("removeTitle"),className:"jsoneditor-remove",click:function(){B.onRemove(d)}});if(this.options.onCreateMenu){var e=d.map(function(a){return a.getPath()});c=this.options.onCreateMenu(c,{type:"multiple",path:e[0],paths:e})}(new u.x(c,{close:b})).show(a,this.getPopupAnchor())},getPopupAnchor:function(){return this.options.popupAnchor||this.frame},getSelection:function(){var a=
{start:null,end:null};if(this.multiselection.nodes&&this.multiselection.nodes.length&&this.multiselection.nodes.length){var b=this.multiselection.nodes[0],c=this.multiselection.nodes[this.multiselection.nodes.length-1];"down"===this.multiselection.direction?(a.start=b.serialize(),a.end=c.serialize()):(a.start=c.serialize(),a.end=b.serialize())}return a},onSelectionChange:function(a){"function"===typeof a&&(this._selectionChangedHandler=(0,q.debounce)(a,this.DEBOUNCE_INTERVAL))},setSelection:function(a,
b){a&&a.dom&&a.range&&(console.warn("setSelection/getSelection usage for text selection is deprecated and should not be used, see documentation for supported selection options"),this.setDomSelection(a));a=this._getNodeInstancesByRange(a,b);a.forEach(function(a){a.expandTo()});this.select(a)},_getNodeInstancesByRange:function(a,b){var c;if(a&&a.path){var d=this.node.findNodeByPath(a.path);b&&b.path&&(c=this.node.findNodeByPath(b.path))}var e=[];if(d instanceof B)if(c instanceof B&&c!==d)if(d.parent===
c.parent){d.getIndex()<c.getIndex()?(a=d,b=c):(a=c,b=d);e.push(a);do a=a.nextSibling(),e.push(a);while(a&&a!==b)}else e=this._findTopLevelNodes(d,c);else e.push(d);return e},getNodesByRange:function(a,b){var c=[];this._getNodeInstancesByRange(a,b).forEach(function(a){c.push(a.serialize())});return c}};var W=[{mode:"tree",mixin:d,data:"json"},{mode:"view",mixin:d,data:"json"},{mode:"form",mixin:d,data:"json"}]},744:function(w,n,d){n.tryRequireAjv=function(){try{var d=Error("Cannot find module 'ajv'");
d.code="MODULE_NOT_FOUND";throw d;}catch(x){}}},49:function(w,n,d){n.O=function(){try{d(864)}catch(r){console.error(r)}}},791:function(w,n,d){function r(a){"@babel/helpers - typeof";r="function"===typeof Symbol&&"symbol"===typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&"function"===typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?"symbol":typeof a};return r(a)}function x(a){try{return JSON.parse(a)}catch(ma){throw p(a),ma;}}function e(a){try{return wa()(a)}catch(ma){return a}}
function A(a){return a.replace(/[\u007F-\uFFFF]/g,function(a){return"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})}function p(a){"undefined"!==typeof ja?ja.parse(a):JSON.parse(a)}function l(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c]);return a}function I(a){for(var b in a)Object.prototype.hasOwnProperty.call(a,b)&&delete a[b];return a}function F(a){return null===a?"null":void 0===a?"undefined":a instanceof Number||"number"===typeof a?"number":a instanceof String||
"string"===typeof a?"string":a instanceof Boolean||"boolean"===typeof a?"boolean":a instanceof RegExp?"regexp":D(a)?"array":"object"}function t(a){return("string"===typeof a||a instanceof String)&&U.test(a)}function D(a){return"[object Array]"===Object.prototype.toString.call(a)}function G(a){return a.ownerDocument.defaultView}function J(a){return a.getBoundingClientRect().left+window.pageXOffset||document.scrollLeft||0}function v(a){return a.getBoundingClientRect().top+window.pageYOffset||document.scrollTop||
0}function b(a,b){var c=a.className.split(" ");-1===c.indexOf(b)&&(c.push(b),a.className=c.join(" "))}function g(a){a.className=""}function a(a,b){var c=a.className.split(" ");b=c.indexOf(b);-1!==b&&(c.splice(b,1),a.className=c.join(" "))}function c(a){a=a.childNodes;for(var b=0,d=a.length;b<d;b++){var f=a[b];f.style&&f.removeAttribute("style");var e=f.attributes;if(e)for(var h=e.length-1;0<=h;h--){var g=e[h];!0===g.specified&&f.removeAttribute(g.name)}c(f)}}function h(a){if(document.createRange){var b=
document.createRange();b.selectNodeContents(a);b.collapse(!1);a=window.getSelection();a.removeAllRanges();a.addRange(b)}}function u(a){if(a&&"DIV"===a.nodeName&&window.getSelection&&document.createRange){var b=document.createRange();b.selectNodeContents(a);a=window.getSelection();a.removeAllRanges();a.addRange(b)}}function M(){if(window.getSelection){var a=window.getSelection();if(a.getRangeAt&&a.rangeCount)return a.getRangeAt(0)}return null}function S(a){if(a&&window.getSelection){var b=window.getSelection();
b.removeAllRanges();b.addRange(a)}}function m(){var a=M();return a&&"startOffset"in a&&"endOffset"in a&&a.startContainer&&a.startContainer===a.endContainer?{startOffset:a.startOffset,endOffset:a.endOffset,container:a.startContainer.parentNode}:null}function H(a){if(document.createRange&&window.getSelection&&window.getSelection()){var b=document.createRange();a.container.firstChild||a.container.appendChild(document.createTextNode(""));b.setStart(a.container.firstChild,a.startOffset);b.setEnd(a.container.firstChild,
a.endOffset);S(b)}}function K(a,b){void 0===b&&(b={_text:"",flush:function(){var a=this._text;this._text="";return a},set:function(a){this._text=a}});if(a.nodeValue)return a=a.nodeValue.replace(/\s*\n\s*/g,""),""!==a?b.flush()+a:"";if(a.hasChildNodes()){a=a.childNodes;for(var c="",d=0,f=a.length;d<f;d++){var e=a[d];if("DIV"===e.nodeName||"P"===e.nodeName){var h=a[d-1];(h=h?h.nodeName:void 0)&&"DIV"!==h&&"P"!==h&&"BR"!==h&&(""!==c&&(c+="\n"),b.flush());c+=K(e,b);b.set("\n")}else"BR"===e.nodeName?(c+=
b.flush(),b.set("\n")):c+=K(e,b)}return c}return""}function z(a,b){for(a=a?a.parentNode:void 0;a;){if(a===b)return!0;a=a.parentNode}return!1}function y(){if(-1===ha){var a=-1;"undefined"!==typeof navigator&&"Microsoft Internet Explorer"===navigator.appName&&null!=/MSIE ([0-9]+[.0-9]+)/.exec(navigator.userAgent)&&(a=parseFloat(RegExp.$1));ha=a}return ha}function q(){return"undefined"!==typeof navigator&&-1!==navigator.userAgent.indexOf("Firefox")}function P(a,b,c,d){if(a.addEventListener)return void 0===
d&&(d=!1),"mousewheel"===b&&q()&&(b="DOMMouseScroll"),a.addEventListener(b,c,d),c;if(a.attachEvent)return d=function(){return c.call(a,window.event)},a.attachEvent("on"+b,d),d}function aa(a,b,c,d){a.removeEventListener?(void 0===d&&(d=!1),"mousewheel"===b&&q()&&(b="DOMMouseScroll"),a.removeEventListener(b,c,d)):a.detachEvent&&a.detachEvent("on"+b,c)}function L(a,b){for(a=a.parentNode;a;){if(a===b)return!0;a=a.parentNode}return!1}function B(a){function b(){for(var b="";void 0!==a[f]&&/[\w$]/.test(a[f]);)b+=
a[f],f++;if(""===b)throw Error("Invalid JSON path: property name expected at index "+f);return b}function c(b){for(var c="";void 0!==a[f]&&a[f]!==b;)c+=a[f],f++;if(a[f]!==b)throw Error("Invalid JSON path: unexpected end, character "+b+" expected");return c}for(var d=[],f=0;void 0!==a[f];)if("."===a[f])f++,d.push(b());else if("["===a[f]){f++;if("'"===a[f]||'"'===a[f]){var e=a[f];f++;d.push(c(e));if(a[f]!==e)throw Error("Invalid JSON path: closing quote ' expected at index "+f);f++}else{e=c("]").trim();
if(0===e.length)throw Error("Invalid JSON path: array value expected at index "+f);e="*"===e?e:JSON.parse(e);d.push(e)}if("]"!==a[f])throw Error("Invalid JSON path: closing bracket ] expected at index "+f);f++}else throw Error('Invalid JSON path: unexpected character "'+a[f]+'" at index '+f);return d}function ba(a){return a.map(function(a){return"number"===typeof a?"["+a+"]":"string"===typeof a&&a.match(/^[A-Za-z0-9_$]+$/)?"."+a:'["'+a+'"]'}).join("")}function O(a){if("enum"===a.keyword&&Array.isArray(a.schema)){var b=
a.schema;if(b){b=b.map(function(a){return JSON.stringify(a)});if(5<b.length){var c=["("+(b.length-5)+" more...)"];b=b.slice(0,5);b.push(c)}a.message="should be equal to one of: "+b.join(", ")}}"additionalProperties"===a.keyword&&(a.message="should NOT have additional property: "+a.params.additionalProperty);return a}function ca(a){return a&&"function"===typeof a.then&&"function"===typeof a["catch"]}function da(a){return"object"===r(a)&&Array.isArray(a.path)&&"string"===typeof a.message}function V(a,
b,c){c=void 0!==c?c:0;return b.left-c>=a.left&&b.right+c<=a.right&&b.top-c>=a.top&&b.bottom+c<=a.bottom}function Z(a,b,c){var d;return function(){var f=this,e=arguments,h=c&&!d;clearTimeout(d);d=setTimeout(function(){d=null;c||a.apply(f,e)},b);h&&a.apply(f,e)}}function Y(a,b){for(var c=b.length,d=0,f=a.length,e=b.length;b.charAt(d)===a.charAt(d)&&d<c;)d++;for(;b.charAt(e-1)===a.charAt(f-1)&&e>d&&0<f;)e--,f--;return{start:d,end:e}}function W(a){function b(b){var c=a.value.substring(0,b);b=(c.match(/\n/g)||
[]).length+1;c=c.length-c.lastIndexOf("\n");return{row:b,column:c}}var c=0,d=0,f;if("number"===typeof a.selectionStart&&"number"===typeof a.selectionEnd)c=a.selectionStart,d=a.selectionEnd;else if((f=document.selection.createRange())&&f.parentElement()===a){var e=a.value.length;var h=a.value.replace(/\r\n/g,"\n");d=a.createTextRange();d.moveToBookmark(f.getBookmark());f=a.createTextRange();f.collapse(!1);-1<d.compareEndPoints("StartToEnd",f)?c=d=e:(c=-d.moveStart("character",-e),c+=h.slice(0,c).split("\n").length-
1,-1<d.compareEndPoints("EndToEnd",f)?d=e:(d=-d.moveEnd("character",-e),d+=h.slice(0,d).split("\n").length-1))}return{startIndex:c,endIndex:d,start:b(c),end:b(d)}}function C(a,b,c){a=a.value||"";return 0<b&&0<c?(a=a.split("\n",b),b=Math.min(a.length,b),c=Math.min(a[b-1].length,c-1),c=1===b?c:c+1,a.slice(0,b-1).join("\n").length+c):-1}function k(a,b){var c=[];if(!b||!b.length)return c;try{var d=xa.parse(a)}catch(Aa){return c}b.forEach(function(a){var b=B(a);b=f(b);(b=d.pointers[b])&&c.push({path:a,
line:b.key?b.key.line:b.value?b.value.line:0,column:b.key?b.key.column:b.value?b.value.column:0})});return c}function f(a){return a.map(function(a){return"/"+String(a).replace(/~/g,"~0").replace(/\//g,"~1")}).join("")}function E(a){var b=document.createElement("div");b.style.color=a;return b.style.color.split(/\s+/).join("").toLowerCase()||null}function N(a){return!!E(a)}function Q(a,b){if(!a)return"";var c="";a.title&&(c+=a.title);a.description&&(0<c.length&&(c+="\n"),c+=a.description);a["default"]&&
(0<c.length&&(c+="\n\n"),c+=(0,ka.Iu)("default",void 0,b)+"\n",c+=JSON.stringify(a["default"],null,2));Array.isArray(a.examples)&&0<a.examples.length&&(0<c.length&&(c+="\n\n"),c+=(0,ka.Iu)("examples",void 0,b)+"\n",a.examples.forEach(function(b,d){c+=JSON.stringify(b,null,2);d!==a.examples.length-1&&(c+="\n")}));return c}function R(a,b){for(var c=0;c<b.length&&void 0!==a&&null!==a;c++)a=a[b[c]];return a}function ea(a,b){for(var c=a=a.replace(/ \(copy( \d+)?\)$/,""),d=1;-1!==b.indexOf(c);)c=a+" (copy"+
(1<d?" "+d:"")+")",d++;return c}function X(a,b){function c(a,b,d,f){if(!Array.isArray(a)&&!fa(a)||f)b[d||""]=!0;fa(a)&&Object.keys(a).forEach(function(e){c(a[e],b,d+"."+e,f)})}var d={};if(Array.isArray(a))for(var f=Math.min(a.length,ya),e=0;e<f;e++)c(a[e],d,"",b);else d[""]=!0;return Object.keys(d).sort()}function ta(a,b,c){var d=b&&"."!==b?B(b):[],f="desc"===c?-1:1;a=a.slice();a.sort(function(a,b){a=R(a,d);b=R(b,d);return f*(a>b?1:a<b?-1:0)});return a}function sa(a,b){var c="desc"===b?-1:1,d={};
Object.keys(a).sort(function(a,b){return c*va()(a,b)}).forEach(function(b){d[b]=a[b]});return d}function qa(a){if(""===a)return"";var b=a.toLowerCase();if("null"===b)return null;if("true"===b)return!0;if("false"===b)return!1;b=Number(a);var c=parseFloat(a);return isNaN(b)||isNaN(c)?a:b}function ra(a,b){return"number"===typeof b&&b>za&&isFinite(b)&&Math.floor(b)===b&&!isNaN((new Date(b)).valueOf())}function na(a){if(900>a)return a.toFixed()+" B";a/=1E3;if(900>a)return a.toFixed(1)+" KB";a/=1E3;if(900>
a)return a.toFixed(1)+" MB";a/=1E3;return 900>a?a.toFixed(1)+" GB":(a/1E3).toFixed(1)+" TB"}function oa(a,b){return a.length<=b?a:a.slice(0,b)+"..."}function fa(a){return"object"===r(a)&&null!==a&&!Array.isArray(a)}function pa(a,b){return-1!==a.indexOf(b)}function ua(a,b){if(!b&&!a)return!1;if(b&&!a||!b&&a||b.length!==a.length)return!0;for(var c=function(c){var d=void 0;d="error"===a[c].type?b.find(function(b){return b.line===a[c].line}):b.find(function(b){return b.dataPath===a[c].dataPath&&b.schemaPath===
a[c].schemaPath});if(!d)return{v:!0}},d=0;d<a.length;++d){var f=c(d);if("object"===r(f))return f.v}return!1}d.r(n);d.d(n,{parse:function(){return x},tryJsonRepair:function(){return e},escapeUnicodeChars:function(){return A},validate:function(){return p},extend:function(){return l},clear:function(){return I},getType:function(){return F},isUrl:function(){return t},isArray:function(){return D},getWindow:function(){return G},getAbsoluteLeft:function(){return J},getAbsoluteTop:function(){return v},addClassName:function(){return b},
removeAllClassNames:function(){return g},removeClassName:function(){return a},stripFormatting:function(){return c},setEndOfContentEditable:function(){return h},selectContentEditable:function(){return u},getSelection:function(){return M},setSelection:function(){return S},getSelectionOffset:function(){return m},setSelectionOffset:function(){return H},getInnerText:function(){return K},hasParentNode:function(){return z},getInternetExplorerVersion:function(){return y},isFirefox:function(){return q},addEventListener:function(){return P},
removeEventListener:function(){return aa},isChildOf:function(){return L},parsePath:function(){return B},stringifyPath:function(){return ba},improveSchemaError:function(){return O},isPromise:function(){return ca},isValidValidationError:function(){return da},insideRect:function(){return V},debounce:function(){return Z},textDiff:function(){return Y},getInputSelection:function(){return W},getIndexForPosition:function(){return C},getPositionForPath:function(){return k},compileJSONPointer:function(){return f},
getColorCSS:function(){return E},isValidColor:function(){return N},makeFieldTooltip:function(){return Q},get:function(){return R},findUniqueName:function(){return ea},getChildPaths:function(){return X},sort:function(){return ta},sortObjectKeys:function(){return sa},parseString:function(){return qa},isTimestamp:function(){return ra},formatSize:function(){return na},limitCharacters:function(){return oa},isObject:function(){return fa},contains:function(){return pa},isValidationErrorChanged:function(){return ua}});
w=d(987);d.n(w);w=d(233);var va=d.n(w);w=d(664);var wa=d.n(w),ja=d(589),xa=d(26),ka=d(907),ya=1E4,za=9466848E5,U=/^https?:\/\/\S+$/,ha=-1},37:function(w,n,d){if(window.Picker)var r=window.Picker;else try{var x=Error("Cannot find module 'vanilla-picker'");x.code="MODULE_NOT_FOUND";throw x;}catch(e){}w.exports=r},233:function(w){w.exports=function x(d,r){var e=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,w=/(^[ ]*|[ ]*$)/g,p=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,
l=/^0x[0-9a-f]+$/i,I=/^0/,F=function(d){return x.insensitive&&(""+d).toLowerCase()||""+d};d=F(d).replace(w,"")||"";w=F(r).replace(w,"")||"";r=d.replace(e,"\x00$1\x00").replace(/\0$/,"").replace(/^\0/,"").split("\x00");e=w.replace(e,"\x00$1\x00").replace(/\0$/,"").replace(/^\0/,"").split("\x00");d=parseInt(d.match(l),16)||1!==r.length&&d.match(p)&&Date.parse(d);if(p=parseInt(w.match(l),16)||d&&w.match(p)&&Date.parse(w)||null){if(d<p)return-1;if(d>p)return 1}d=0;for(w=Math.max(r.length,e.length);d<
w;d++){p=!(r[d]||"").match(I)&&parseFloat(r[d])||r[d]||0;l=!(e[d]||"").match(I)&&parseFloat(e[d])||e[d]||0;if(isNaN(p)!==isNaN(l))return isNaN(p)?1:-1;typeof p!==typeof l&&(p+="",l+="");if(p<l)return-1;if(p>l)return 1}return 0}},156:function(w,n){(function(d){function n(a){return null!==a?"[object Array]"===Object.prototype.toString.call(a):!1}function w(a){return null!==a?"[object Object]"===Object.prototype.toString.call(a):!1}function e(a,b){if(a===b)return!0;if(Object.prototype.toString.call(a)!==
Object.prototype.toString.call(b))return!1;if(!0===n(a)){if(a.length!==b.length)return!1;for(var c=0;c<a.length;c++)if(!1===e(a[c],b[c]))return!1;return!0}if(!0===w(a)){c={};for(var d in a)if(hasOwnProperty.call(a,d)){if(!1===e(a[d],b[d]))return!1;c[d]=!0}for(var g in b)if(hasOwnProperty.call(b,g)&&!0!==c[g])return!1;return!0}return!1}function A(a){if(""===a||!1===a||null===a||n(a)&&0===a.length)return!0;if(w(a)){for(var b in a)if(a.hasOwnProperty(b))return!1;return!0}return!1}function p(a){return"0"<=
a&&"9">=a||"-"===a}function l(a){return"a"<=a&&"z">=a||"A"<=a&&"Z">=a||"0"<=a&&"9">=a||"_"===a}function I(){}function F(){}function t(a){this.runtime=a}function D(a){this._interpreter=a;this.functionTable={abs:{_func:this._functionAbs,_signature:[{types:[0]}]},avg:{_func:this._functionAvg,_signature:[{types:[8]}]},ceil:{_func:this._functionCeil,_signature:[{types:[0]}]},contains:{_func:this._functionContains,_signature:[{types:[2,3]},{types:[1]}]},ends_with:{_func:this._functionEndsWith,_signature:[{types:[2]},
{types:[2]}]},floor:{_func:this._functionFloor,_signature:[{types:[0]}]},length:{_func:this._functionLength,_signature:[{types:[2,3,4]}]},map:{_func:this._functionMap,_signature:[{types:[6]},{types:[3]}]},max:{_func:this._functionMax,_signature:[{types:[8,9]}]},merge:{_func:this._functionMerge,_signature:[{types:[4],variadic:!0}]},max_by:{_func:this._functionMaxBy,_signature:[{types:[3]},{types:[6]}]},sum:{_func:this._functionSum,_signature:[{types:[8]}]},starts_with:{_func:this._functionStartsWith,
_signature:[{types:[2]},{types:[2]}]},min:{_func:this._functionMin,_signature:[{types:[8,9]}]},min_by:{_func:this._functionMinBy,_signature:[{types:[3]},{types:[6]}]},type:{_func:this._functionType,_signature:[{types:[1]}]},keys:{_func:this._functionKeys,_signature:[{types:[4]}]},values:{_func:this._functionValues,_signature:[{types:[4]}]},sort:{_func:this._functionSort,_signature:[{types:[9,8]}]},sort_by:{_func:this._functionSortBy,_signature:[{types:[3]},{types:[6]}]},join:{_func:this._functionJoin,
_signature:[{types:[2]},{types:[9]}]},reverse:{_func:this._functionReverse,_signature:[{types:[2,3]}]},to_array:{_func:this._functionToArray,_signature:[{types:[1]}]},to_string:{_func:this._functionToString,_signature:[{types:[1]}]},to_number:{_func:this._functionToNumber,_signature:[{types:[1]}]},not_null:{_func:this._functionNotNull,_signature:[{types:[1],variadic:!0}]}}}var G="function"===typeof String.prototype.trimLeft?function(a){return a.trimLeft()}:function(a){return a.match(/^\s*(.*)/)[1]};
var J={".":"Dot","*":"Star",",":"Comma",":":"Colon","{":"Lbrace","}":"Rbrace","]":"Rbracket","(":"Lparen",")":"Rparen","@":"Current"},v={"<":!0,">":!0,"=":!0,"!":!0},b={" ":!0,"\t":!0,"\n":!0};I.prototype={tokenize:function(a){var c=[];this._current=0;for(var d,e;this._current<a.length;)if(d=a[this._current],"a"<=d&&"z">=d||"A"<=d&&"Z">=d||"_"===d)d=this._current,e=this._consumeUnquotedIdentifier(a),c.push({type:"UnquotedIdentifier",value:e,start:d});else if(void 0!==J[a[this._current]])c.push({type:J[a[this._current]],
value:a[this._current],start:this._current}),this._current++;else if(p(a[this._current]))d=this._consumeNumber(a),c.push(d);else if("["===a[this._current])d=this._consumeLBracket(a),c.push(d);else if('"'===a[this._current])d=this._current,e=this._consumeQuotedIdentifier(a),c.push({type:"QuotedIdentifier",value:e,start:d});else if("'"===a[this._current])d=this._current,e=this._consumeRawStringLiteral(a),c.push({type:"Literal",value:e,start:d});else if("`"===a[this._current])d=this._current,e=this._consumeLiteral(a),
c.push({type:"Literal",value:e,start:d});else if(void 0!==v[a[this._current]])c.push(this._consumeOperator(a));else if(void 0!==b[a[this._current]])this._current++;else if("&"===a[this._current])d=this._current,this._current++,"&"===a[this._current]?(this._current++,c.push({type:"And",value:"&&",start:d})):c.push({type:"Expref",value:"&",start:d});else if("|"===a[this._current])d=this._current,this._current++,"|"===a[this._current]?(this._current++,c.push({type:"Or",value:"||",start:d})):c.push({type:"Pipe",
value:"|",start:d});else throw a=Error("Unknown character:"+a[this._current]),a.name="LexerError",a;return c},_consumeUnquotedIdentifier:function(a){var b=this._current;for(this._current++;this._current<a.length&&l(a[this._current]);)this._current++;return a.slice(b,this._current)},_consumeQuotedIdentifier:function(a){var b=this._current;this._current++;for(var d=a.length;'"'!==a[this._current]&&this._current<d;){var e=this._current;"\\"!==a[e]||"\\"!==a[e+1]&&'"'!==a[e+1]?e++:e+=2;this._current=
e}this._current++;return JSON.parse(a.slice(b,this._current))},_consumeRawStringLiteral:function(a){var b=this._current;this._current++;for(var d=a.length;"'"!==a[this._current]&&this._current<d;){var e=this._current;"\\"!==a[e]||"\\"!==a[e+1]&&"'"!==a[e+1]?e++:e+=2;this._current=e}this._current++;return a.slice(b+1,this._current-1).replace("\\'","'")},_consumeNumber:function(a){var b=this._current;this._current++;for(var d=a.length;p(a[this._current])&&this._current<d;)this._current++;return{type:"Number",
value:parseInt(a.slice(b,this._current)),start:b}},_consumeLBracket:function(a){var b=this._current;this._current++;return"?"===a[this._current]?(this._current++,{type:"Filter",value:"[?",start:b}):"]"===a[this._current]?(this._current++,{type:"Flatten",value:"[]",start:b}):{type:"Lbracket",value:"[",start:b}},_consumeOperator:function(a){var b=this._current,d=a[b];this._current++;if("!"===d)return"="===a[this._current]?(this._current++,{type:"NE",value:"!=",start:b}):{type:"Not",value:"!",start:b};
if("<"===d)return"="===a[this._current]?(this._current++,{type:"LTE",value:"<=",start:b}):{type:"LT",value:"<",start:b};if(">"===d)return"="===a[this._current]?(this._current++,{type:"GTE",value:">=",start:b}):{type:"GT",value:">",start:b};if("="===d&&"="===a[this._current])return this._current++,{type:"EQ",value:"==",start:b}},_consumeLiteral:function(a){this._current++;for(var b=this._current,d=a.length;"`"!==a[this._current]&&this._current<d;){var e=this._current;"\\"!==a[e]||"\\"!==a[e+1]&&"`"!==
a[e+1]?e++:e+=2;this._current=e}a=G(a.slice(b,this._current));a=a.replace("\\`","`");a=this._looksLikeJSON(a)?JSON.parse(a):JSON.parse('"'+a+'"');this._current++;return a},_looksLikeJSON:function(a){var b=["true","false","null"];if(""===a)return!1;if(0<='[{"'.indexOf(a[0])||0<=b.indexOf(a))return!0;if(0<="-0123456789".indexOf(a[0]))try{return JSON.parse(a),!0}catch(h){return!1}else return!1}};var g={EOF:0,UnquotedIdentifier:0,QuotedIdentifier:0,Rbracket:0,Rparen:0,Comma:0,Rbrace:0,Number:0,Current:0,
Expref:0,Pipe:1,Or:2,And:3,EQ:5,GT:5,LT:5,GTE:5,LTE:5,NE:5,Flatten:9,Star:20,Filter:21,Dot:40,Not:45,Lbrace:50,Lbracket:55,Lparen:60};F.prototype={parse:function(a){this._loadTokens(a);this.index=0;a=this.expression(0);if("EOF"!==this._lookahead(0))throw a=this._lookaheadToken(0),a=Error("Unexpected token type: "+a.type+", value: "+a.value),a.name="ParserError",a;return a},_loadTokens:function(a){var b=(new I).tokenize(a);b.push({type:"EOF",value:"",start:a.length});this.tokens=b},expression:function(a){var b=
this._lookaheadToken(0);this._advance();b=this.nud(b);for(var d=this._lookahead(0);a<g[d];)this._advance(),b=this.led(d,b),d=this._lookahead(0);return b},_lookahead:function(a){return this.tokens[this.index+a].type},_lookaheadToken:function(a){return this.tokens[this.index+a]},_advance:function(){this.index++},nud:function(a){switch(a.type){case "Literal":return{type:"Literal",value:a.value};case "UnquotedIdentifier":return{type:"Field",name:a.value};case "QuotedIdentifier":a={type:"Field",name:a.value};
if("Lparen"===this._lookahead(0))throw Error("Quoted identifier not allowed for function names.");return a;case "Not":var b=this.expression(g.Not);return{type:"NotExpression",children:[b]};case "Star":return a={type:"Identity"},b="Rbracket"===this._lookahead(0)?{type:"Identity"}:this._parseProjectionRHS(g.Star),{type:"ValueProjection",children:[a,b]};case "Filter":return this.led(a.type,{type:"Identity"});case "Lbrace":return this._parseMultiselectHash();case "Flatten":return a={type:"Flatten",children:[{type:"Identity"}]},
b=this._parseProjectionRHS(g.Flatten),{type:"Projection",children:[a,b]};case "Lbracket":return"Number"===this._lookahead(0)||"Colon"===this._lookahead(0)?(b=this._parseIndexExpression(),this._projectIfSlice({type:"Identity"},b)):"Star"===this._lookahead(0)&&"Rbracket"===this._lookahead(1)?(this._advance(),this._advance(),b=this._parseProjectionRHS(g.Star),{type:"Projection",children:[{type:"Identity"},b]}):this._parseMultiselectList();case "Current":return{type:"Current"};case "Expref":return a=
this.expression(g.Expref),{type:"ExpressionReference",children:[a]};case "Lparen":for(b=[];"Rparen"!==this._lookahead(0);)"Current"===this._lookahead(0)?(a={type:"Current"},this._advance()):a=this.expression(0),b.push(a);this._match("Rparen");return b[0];default:this._errorToken(a)}},led:function(a,b){switch(a){case "Dot":a=g.Dot;if("Star"!==this._lookahead(0))return a=this._parseDotRHS(a),{type:"Subexpression",children:[b,a]};this._advance();a=this._parseProjectionRHS(a);return{type:"ValueProjection",
children:[b,a]};case "Pipe":return a=this.expression(g.Pipe),{type:"Pipe",children:[b,a]};case "Or":return a=this.expression(g.Or),{type:"OrExpression",children:[b,a]};case "And":return a=this.expression(g.And),{type:"AndExpression",children:[b,a]};case "Lparen":b=b.name;a=[];for(var c;"Rparen"!==this._lookahead(0);)"Current"===this._lookahead(0)?(c={type:"Current"},this._advance()):c=this.expression(0),"Comma"===this._lookahead(0)&&this._match("Comma"),a.push(c);this._match("Rparen");return{type:"Function",
name:b,children:a};case "Filter":return c=this.expression(0),this._match("Rbracket"),a="Flatten"===this._lookahead(0)?{type:"Identity"}:this._parseProjectionRHS(g.Filter),{type:"FilterProjection",children:[b,a,c]};case "Flatten":return b={type:"Flatten",children:[b]},a=this._parseProjectionRHS(g.Flatten),{type:"Projection",children:[b,a]};case "EQ":case "NE":case "GT":case "GTE":case "LT":case "LTE":return this._parseComparator(b,a);case "Lbracket":a=this._lookaheadToken(0);if("Number"===a.type||
"Colon"===a.type)return a=this._parseIndexExpression(),this._projectIfSlice(b,a);this._match("Star");this._match("Rbracket");a=this._parseProjectionRHS(g.Star);return{type:"Projection",children:[b,a]};default:this._errorToken(this._lookaheadToken(0))}},_match:function(a){if(this._lookahead(0)===a)this._advance();else{var b=this._lookaheadToken(0);a=Error("Expected "+a+", got: "+b.type);a.name="ParserError";throw a;}},_errorToken:function(a){a=Error("Invalid token ("+a.type+'): "'+a.value+'"');a.name=
"ParserError";throw a;},_parseIndexExpression:function(){if("Colon"===this._lookahead(0)||"Colon"===this._lookahead(1))return this._parseSliceExpression();var a={type:"Index",value:this._lookaheadToken(0).value};this._advance();this._match("Rbracket");return a},_projectIfSlice:function(a,b){a={type:"IndexExpression",children:[a,b]};return"Slice"===b.type?{type:"Projection",children:[a,this._parseProjectionRHS(g.Star)]}:a},_parseSliceExpression:function(){for(var a=[null,null,null],b=0,d=this._lookahead(0);"Rbracket"!==
d&&3>b;){if("Colon"===d)b++,this._advance();else if("Number"===d)a[b]=this._lookaheadToken(0).value,this._advance();else throw a=this._lookahead(0),a=Error("Syntax error, unexpected token: "+a.value+"("+a.type+")"),a.name="Parsererror",a;d=this._lookahead(0)}this._match("Rbracket");return{type:"Slice",children:a}},_parseComparator:function(a,b){var c=this.expression(g[b]);return{type:"Comparator",name:b,children:[a,c]}},_parseDotRHS:function(a){var b=this._lookahead(0);if(0<=["UnquotedIdentifier",
"QuotedIdentifier","Star"].indexOf(b))return this.expression(a);if("Lbracket"===b)return this._match("Lbracket"),this._parseMultiselectList();if("Lbrace"===b)return this._match("Lbrace"),this._parseMultiselectHash()},_parseProjectionRHS:function(a){if(10>g[this._lookahead(0)])a={type:"Identity"};else if("Lbracket"===this._lookahead(0))a=this.expression(a);else if("Filter"===this._lookahead(0))a=this.expression(a);else if("Dot"===this._lookahead(0))this._match("Dot"),a=this._parseDotRHS(a);else throw a=
this._lookaheadToken(0),a=Error("Sytanx error, unexpected token: "+a.value+"("+a.type+")"),a.name="ParserError",a;return a},_parseMultiselectList:function(){for(var a=[];"Rbracket"!==this._lookahead(0);){var b=this.expression(0);a.push(b);if("Comma"===this._lookahead(0)&&(this._match("Comma"),"Rbracket"===this._lookahead(0)))throw Error("Unexpected token Rbracket");}this._match("Rbracket");return{type:"MultiSelectList",children:a}},_parseMultiselectHash:function(){for(var a=[],b=["UnquotedIdentifier",
"QuotedIdentifier"],d,e;;){d=this._lookaheadToken(0);if(0>b.indexOf(d.type))throw Error("Expecting an identifier token, got: "+d.type);d=d.value;this._advance();this._match("Colon");e=this.expression(0);d={type:"KeyValuePair",name:d,value:e};a.push(d);if("Comma"===this._lookahead(0))this._match("Comma");else if("Rbrace"===this._lookahead(0)){this._match("Rbrace");break}}return{type:"MultiSelectHash",children:a}}};t.prototype={search:function(a,b){return this.visit(a,b)},visit:function(a,b){var c;
switch(a.type){case "Field":return null===b?null:w(b)?(a=b[a.name],void 0===a?null:a):null;case "Subexpression":var d=this.visit(a.children[0],b);for(c=1;c<a.children.length;c++)if(d=this.visit(a.children[1],d),null===d)return null;return d;case "IndexExpression":return c=this.visit(a.children[0],b),a=this.visit(a.children[1],c);case "Index":if(!n(b))return null;a=a.value;0>a&&(a=b.length+a);d=b[a];void 0===d&&(d=null);return d;case "Slice":if(!n(b))return null;a=a.children.slice(0);d=this.computeSliceParams(b.length,
a);c=d[0];a=d[1];var g=d[2];d=[];if(0<g)for(;c<a;c+=g)d.push(b[c]);else for(;c>a;c+=g)d.push(b[c]);return d;case "Projection":g=this.visit(a.children[0],b);if(!n(g))return null;d=[];for(c=0;c<g.length;c++)b=this.visit(a.children[1],g[c]),null!==b&&d.push(b);return d;case "ValueProjection":g=this.visit(a.children[0],b);if(!w(g))return null;d=[];c=g;b=Object.keys(c);g=[];for(var l=0;l<b.length;l++)g.push(c[b[l]]);for(c=0;c<g.length;c++)b=this.visit(a.children[1],g[c]),null!==b&&d.push(b);return d;case "FilterProjection":g=
this.visit(a.children[0],b);if(!n(g))return null;d=[];l=[];for(c=0;c<g.length;c++){var m=this.visit(a.children[2],g[c]);A(m)||d.push(g[c])}for(c=0;c<d.length;c++)b=this.visit(a.children[1],d[c]),null!==b&&l.push(b);return l;case "Comparator":c=this.visit(a.children[0],b);b=this.visit(a.children[1],b);switch(a.name){case "EQ":d=e(c,b);break;case "NE":d=!e(c,b);break;case "GT":d=c>b;break;case "GTE":d=c>=b;break;case "LT":d=c<b;break;case "LTE":d=c<=b;break;default:throw Error("Unknown comparator: "+
a.name);}return d;case "Flatten":a=this.visit(a.children[0],b);if(!n(a))return null;d=[];for(c=0;c<a.length;c++)b=a[c],n(b)?d.push.apply(d,b):d.push(b);return d;case "Identity":return b;case "MultiSelectList":if(null===b)return null;d=[];for(c=0;c<a.children.length;c++)d.push(this.visit(a.children[c],b));return d;case "MultiSelectHash":if(null===b)return null;d={};for(c=0;c<a.children.length;c++)g=a.children[c],d[g.name]=this.visit(g.value,b);return d;case "OrExpression":return m=this.visit(a.children[0],
b),A(m)&&(m=this.visit(a.children[1],b)),m;case "AndExpression":return c=this.visit(a.children[0],b),!0===A(c)?c:this.visit(a.children[1],b);case "NotExpression":return c=this.visit(a.children[0],b),A(c);case "Literal":return a.value;case "Pipe":return c=this.visit(a.children[0],b),this.visit(a.children[1],c);case "Current":return b;case "Function":d=[];for(c=0;c<a.children.length;c++)d.push(this.visit(a.children[c],b));return this.runtime.callFunction(a.name,d);case "ExpressionReference":return a=
a.children[0],a.jmespathType="Expref",a;default:throw Error("Unknown node type: "+a.type);}},computeSliceParams:function(a,b){var c=b[0],d=b[1];b=b[2];var e=[null,null,null];if(null===b)b=1;else if(0===b)throw a=Error("Invalid slice, step cannot be 0"),a.name="RuntimeError",a;var g=0>b?!0:!1;c=null===c?g?a-1:0:this.capSliceRange(a,c,b);d=null===d?g?-1:a:this.capSliceRange(a,d,b);e[0]=c;e[1]=d;e[2]=b;return e},capSliceRange:function(a,b,d){0>b?(b+=a,0>b&&(b=0>d?-1:0)):b>=a&&(b=0>d?a-1:a);return b}};
D.prototype={callFunction:function(a,b){var c=this.functionTable[a];if(void 0===c)throw Error("Unknown function: "+a+"()");this._validateArgs(a,b,c._signature);return c._func.call(this,b)},_validateArgs:function(a,b,d){if(d[d.length-1].variadic){if(b.length<d.length){var c=1===d.length?" argument":" arguments";throw Error("ArgumentError: "+a+"() takes at least"+d.length+c+" but received "+b.length);}}else if(b.length!==d.length)throw c=1===d.length?" argument":" arguments",Error("ArgumentError: "+
a+"() takes "+d.length+c+" but received "+b.length);for(var e,g,h=0;h<d.length;h++){g=!1;c=d[h].types;e=this._getTypeName(b[h]);for(var l=0;l<c.length;l++)if(this._typeMatches(e,c[l],b[h])){g=!0;break}if(!g)throw Error("TypeError: "+a+"() expected argument "+(h+1)+" to be type "+c+" but received type "+e+" instead.");}},_typeMatches:function(a,b,d){if(1===b)return!0;if(9===b||8===b||3===b){if(3===b)return 3===a;if(3===a){var c;8===b?c=0:9===b&&(c=2);for(a=0;a<d.length;a++)if(!this._typeMatches(this._getTypeName(d[a]),
c,d[a]))return!1;return!0}}else return a===b},_getTypeName:function(a){switch(Object.prototype.toString.call(a)){case "[object String]":return 2;case "[object Number]":return 0;case "[object Array]":return 3;case "[object Boolean]":return 5;case "[object Null]":return 7;case "[object Object]":return"Expref"===a.jmespathType?6:4}},_functionStartsWith:function(a){return 0===a[0].lastIndexOf(a[1])},_functionEndsWith:function(a){var b=a[0];a=a[1];return-1!==b.indexOf(a,b.length-a.length)},_functionReverse:function(a){if(2===
this._getTypeName(a[0])){a=a[0];for(var b="",d=a.length-1;0<=d;d--)b+=a[d];return b}a=a[0].slice(0);a.reverse();return a},_functionAbs:function(a){return Math.abs(a[0])},_functionCeil:function(a){return Math.ceil(a[0])},_functionAvg:function(a){var b=0;a=a[0];for(var d=0;d<a.length;d++)b+=a[d];return b/a.length},_functionContains:function(a){return 0<=a[0].indexOf(a[1])},_functionFloor:function(a){return Math.floor(a[0])},_functionLength:function(a){return w(a[0])?Object.keys(a[0]).length:a[0].length},
_functionMap:function(a){var b=[],d=this._interpreter,e=a[0];a=a[1];for(var g=0;g<a.length;g++)b.push(d.visit(e,a[g]));return b},_functionMerge:function(a){for(var b={},d=0;d<a.length;d++){var e=a[d],g;for(g in e)b[g]=e[g]}return b},_functionMax:function(a){if(0<a[0].length){if(0===this._getTypeName(a[0][0]))return Math.max.apply(Math,a[0]);a=a[0];for(var b=a[0],d=1;d<a.length;d++)0>b.localeCompare(a[d])&&(b=a[d]);return b}return null},_functionMin:function(a){if(0<a[0].length){if(0===this._getTypeName(a[0][0]))return Math.min.apply(Math,
a[0]);a=a[0];for(var b=a[0],d=1;d<a.length;d++)0>a[d].localeCompare(b)&&(b=a[d]);return b}return null},_functionSum:function(a){var b=0;a=a[0];for(var d=0;d<a.length;d++)b+=a[d];return b},_functionType:function(a){switch(this._getTypeName(a[0])){case 0:return"number";case 2:return"string";case 3:return"array";case 4:return"object";case 5:return"boolean";case 6:return"expref";case 7:return"null"}},_functionKeys:function(a){return Object.keys(a[0])},_functionValues:function(a){a=a[0];for(var b=Object.keys(a),
d=[],e=0;e<b.length;e++)d.push(a[b[e]]);return d},_functionJoin:function(a){return a[1].join(a[0])},_functionToArray:function(a){return 3===this._getTypeName(a[0])?a[0]:[a[0]]},_functionToString:function(a){return 2===this._getTypeName(a[0])?a[0]:JSON.stringify(a[0])},_functionToNumber:function(a){var b=this._getTypeName(a[0]);return 0===b?a[0]:2!==b||(a=+a[0],isNaN(a))?null:a},_functionNotNull:function(a){for(var b=0;b<a.length;b++)if(7!==this._getTypeName(a[b]))return a[b];return null},_functionSort:function(a){a=
a[0].slice(0);a.sort();return a},_functionSortBy:function(a){var b=a[0].slice(0);if(0===b.length)return b;var d=this._interpreter,e=a[1],g=this._getTypeName(d.visit(e,b[0]));if(0>[0,2].indexOf(g))throw Error("TypeError");var l=this;a=[];for(var m=0;m<b.length;m++)a.push([m,b[m]]);a.sort(function(a,b){var c=d.visit(e,a[1]),h=d.visit(e,b[1]);if(l._getTypeName(c)!==g)throw Error("TypeError: expected "+g+", received "+l._getTypeName(c));if(l._getTypeName(h)!==g)throw Error("TypeError: expected "+g+", received "+
l._getTypeName(h));return c>h?1:c<h?-1:a[0]-b[0]});for(m=0;m<a.length;m++)b[m]=a[m][1];return b},_functionMaxBy:function(a){var b=a[0];a=this.createKeyFunction(a[1],[0,2]);for(var d=-Infinity,e,g,l=0;l<b.length;l++)g=a(b[l]),g>d&&(d=g,e=b[l]);return e},_functionMinBy:function(a){var b=a[0];a=this.createKeyFunction(a[1],[0,2]);for(var d=Infinity,e,g,l=0;l<b.length;l++)g=a(b[l]),g<d&&(d=g,e=b[l]);return e},createKeyFunction:function(a,b){var c=this,d=this._interpreter;return function(e){e=d.visit(a,
e);if(0>b.indexOf(c._getTypeName(e)))throw e="TypeError: expected one of "+b+", received "+c._getTypeName(e),Error(e);return e}}};d.tokenize=function(a){return(new I).tokenize(a)};d.compile=function(a){return(new F).parse(a)};d.search=function(a,b){var c=new F,d=new D,e=new t(d);d._interpreter=e;b=c.parse(b);return e.search(b,a)};d.strictDeepEqual=e})(n)},26:function(w,n){function d(b){return 0<=p.indexOf(typeof b)}function r(b){b=b.replace(l,"\\$&").replace(F,"\\f").replace(I,"\\b").replace(t,"\\n").replace(D,
"\\r").replace(G,"\\t");return'"'+b+'"'}function x(b){return b.replace(J,"~0").replace(v,"~1")}var e={b:"\b",f:"\f",n:"\n",r:"\r",t:"\t",'"':'"',"/":"/","\\":"\\"},A="a".charCodeAt();n.parse=function(b,d,a){function c(a,d){g();r(a,"value",t());var e=n();switch(e){case "t":p("rue");var h=!0;break;case "f":p("alse");h=!1;break;case "n":p("ull");h=null;break;case '"':h=l();break;case "[":g();h=[];e=0;if("]"!=n())for(B--,L--;;){h.push(c(a+"/"+e));g();var q=n();if("]"==q)break;","!=q&&w();g();e++}break;
case "{":g();h={};if("}"!=n())for(B--,L--;;){e=t();'"'!=n()&&w();q=l();var u=a+"/"+x(q);r(u,"key",e);r(u,"keyEnd",t());g();":"!=n()&&w();g();h[q]=c(u);g();e=n();if("}"==e)break;","!=e&&w();g()}break;default:if(B--,L--,0<="-0123456789".indexOf(e)){h="";e=!0;"-"==b[B]&&(h+=n());h+="0"==b[B]?n():m();"."==b[B]&&(h+=n()+m(),e=!1);if("e"==b[B]||"E"==b[B]){h+=n();if("+"==b[B]||"-"==b[B])h+=n();h+=m();e=!1}q=+h;h=F&&e&&(q>Number.MAX_SAFE_INTEGER||q<Number.MIN_SAFE_INTEGER)?BigInt(h):q}else v()}r(a,"valueEnd",
t());g();d&&B<b.length&&v();return h}function g(){a:for(;B<b.length;){switch(b[B]){case " ":L++;break;case "\t":L+=4;break;case "\r":L=0;break;case "\n":L=0;D++;break;default:break a}B++}}function l(){for(var a="",b;b=n(),'"'!=b;)if("\\"==b)if(b=n(),b in e)a+=e[b];else if("u"==b){b=4;for(var c=0;b--;){c<<=4;var d=n().toLowerCase();"a"<=d&&"f">=d?c+=d.charCodeAt()-A+10:"0"<=d&&"9">=d?c+=+d:w()}b=String.fromCharCode(c);a+=b}else w();else a+=b;return a}function p(a){for(var b=0;b<a.length;b++)n()!==
a[b]&&w()}function n(){q();var a=b[B];B++;L++;return a}function m(){for(var a="";"0"<=b[B]&&"9">=b[B];)a+=n();if(a.length)return a;q();v()}function r(a,b,c){P[a]=P[a]||{};P[a][b]=c}function t(){return{line:D,column:L,pos:B}}function v(){throw new SyntaxError("Unexpected token "+b[B]+" in JSON at position "+B);}function w(){B--;L--;v()}function q(){if(B>=b.length)throw new SyntaxError("Unexpected end of JSON input");}var P={},D=0,L=0,B=0,F=a&&a.bigint&&"undefined"!=typeof BigInt;return{data:c("",!0),
pointers:P}};n.stringify=function(b,e,a){function c(a,b,e){function h(){if(a.length){g("[");for(var h=b+1,m=0;m<a.length;m++){m&&g(",");l(h);var p=d(a[m])?a[m]:null;c(p,h,e+"/"+m)}l(b);g("]")}else g("[]")}function m(){var h=Object.keys(a);if(h.length){g("{");for(var m=b+1,n=0;n<h.length;n++){var q=h[n],k=a[q];if(d(k)){n&&g(",");var f=e+"/"+x(q);l(m);p(f,"key");g(r(q));p(f,"keyEnd");g(":");t&&g(" ");c(k,m,f)}}l(b);g("}")}else g("{}")}function n(h){if(a.size){g("{");for(var m=b+1,n=!0,q=a.entries(),
k=q.next();!k.done;){var f=k.value;k=f[0];f=h?!0:f[1];if(d(f)){n||g(",");n=!1;var u=e+"/"+x(k);l(m);p(u,"key");g(r(k));p(u,"keyEnd");g(":");t&&g(" ");c(f,m,u)}k=q.next()}l(b);g("}")}else g("{}")}p(e,"value");switch(typeof a){case "number":case "bigint":case "boolean":g(""+a);break;case "string":g(r(a));break;case "object":null===a?g("null"):"function"==typeof a.toJSON?g(r(a.toJSON())):Array.isArray(a)?h():L?a.constructor.BYTES_PER_ELEMENT?h():a instanceof Map?n():a instanceof Set?n(!0):m():m()}p(e,
"valueEnd")}function g(a){A+=a.length;D+=a.length;w+=a}function l(a){if(t){w+="\n"+Array(a+1).join(t);q++;for(A=0;a--;)n?(q+=n,A=v):A+=v,D+=m;D+=1}}function p(a,b){y[a]=y[a]||{};y[a][b]={line:q,column:A,pos:D}}if(d(b)){var n=0,m,t="object"==typeof a?a.space:a;switch(typeof t){case "number":t=(e=10<t?10:0>t?0:Math.floor(t))&&Array(e+1).join(" ");var v=m=e;break;case "string":t=t.slice(0,10);for(e=v=m=0;e<t.length;e++){switch(t[e]){case " ":v++;break;case "\t":v+=4;break;case "\r":v=0;break;case "\n":v=
0;n++;break;default:throw Error("whitespace characters not allowed in JSON");}m++}break;default:t=void 0}var w="",y={},q=0,A=0,D=0,L=a&&a.es6&&"function"==typeof Map;c(b,0,"");return{json:w,pointers:y}}};var p=["number","bigint","boolean","string","object"],l=/"|\\/g,I=/[\b]/g,F=/\f/g,t=/\n/g,D=/\r/g,G=/\t/g,J=/~/g,v=/\//g},664:function(w){!function(n,d){w.exports=d()}(this,function(){function n(a,b){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");
this.message=a+" (char "+b+")";this.char=b;this.stack=Error().stack}function d(a){return" "===a||"\t"===a||"\n"===a||"\r"===a}function r(a){return"\u00a0"===a||"\u2000"<=a&&"\u200a">=a||"\u202f"===a||"\u205f"===a||"\u3000"===a}function w(a){return!0===J[a]}function e(a){return!0===v[a]}function A(a,b){b=a.lastIndexOf(b);return-1!==b?a.substring(0,b)+a.substring(b+1):a}function p(a,b){var c=a.length;if(!d(a[c-1]))return a+b;for(;d(a[c-1]);)c--;return a.substring(0,c)+b+a.substring(c)}function l(){K++;
z=m.charAt(K)}function I(){l();"\\"===z&&l()}function F(){return 0===q&&("["===y||"{"===y)||2===q||1===q||3===q}function t(){H+=y;q=6;y="";if(c[z])q=0,y=z,l();else if(a.test(z)||"-"===z){if(q=1,"-"===z){if(y+=z,l(),!a.test(z))throw new n("Invalid number, digit expected",K);}else"0"===z&&(y+=z,l());for(;a.test(z);)y+=z,l();if("."===z){if(y+=z,l(),!a.test(z))throw new n("Invalid number, digit expected",K);for(;a.test(z);)y+=z,l()}if("e"===z||"E"===z){if(y+=z,l(),"+"!==z&&"-"!==z||(y+=z,l()),!a.test(z))throw new n("Invalid number, digit expected",
K);for(;a.test(z);)y+=z,l()}}else"\\"===z&&'"'===m.charAt(K+1)?(l(),D(I)):D(l);if(4===q){for(var b=y,d="",e=0;e<b.length;e++){var g=b[e];d+=r(g)?" ":g}y=d;t()}5===q&&(q=6,y="",t())}function D(c){if(!0===J[p=z]||!0===v[p]){var p=!0===J[z]?"'":!0===v[z]?'"':z,t=w(z)?w:e;y+='"';q=2;for(c();""!==z&&!t(z);)if("\\"===z)if(c(),void 0!==h[z])y+="\\"+z,c();else if("u"===z){y+="\\u";c();for(var x=0;4>x;x++){if(A=z,!g.test(A))throw new n("Invalid unicode character",K-y.length);y+=z;c()}}else{if("'"!==z)throw new n('Invalid escape character "\\'+
z+'"',K);y+="'";c()}else u[z]?y+=u[z]:y+='"'===z?'\\"':z,c();if((!0===J[z]?"'":!0===v[z]?'"':z)!==p)throw new n("End of string expected",K-y.length);return y+='"',void c()}var A;if(b.test(z))for(q=3;b.test(z)||a.test(z)||"$"===z;)y+=z,l();else{if(d(z)||r(z))for(q=4;d(z)||r(z);)y+=z,l();else{if("/"!==z||"*"!==m[K+1]){if("/"!==z||"/"!==m[K+1]){for(q=6;""!==z;)y+=z,l();throw new n('Syntax error in part "'+y+'"',K-y.length);}for(q=5;""!==z&&"\n"!==z;)y+=z,l()}else{for(q=5;""!==z&&("*"!==z||"*"===z&&"/"!==
m[K+1]);)y+=z,l();"*"===z&&"/"===m[K+1]&&(y+=z,l(),y+=z,l())}!0}!0}!0}function G(){if(0!==q||"{"!==y)!function(){if(0!==q||"["!==y)!function(){if(2!==q)(1!==q?function(){if(3!==q)throw new n(""===y?"Unexpected end of json string":"Value expected",K-y.length);if(M[y])t();else{if(S[y])return y=S[y],t();var a=y,b=H.length;if(y="",t(),0===q&&"("===y)return y="",t(),G(),0===q&&")"===y&&(y="",t(),0===q&&";"===y&&(y="",t()));var c=H;a='"'.concat(a);for(H=c.substring(0,b)+a+c.substring(b);3===q||1===q;)t();
H+='"'}}:t)();else for(t();0===q&&"+"===y;){var a;y="";t();2===q&&(a=H.lastIndexOf('"'),H=H.substring(0,a)+y.substring(1),y="",t())}}();else if(t(),0!==q||"]"!==y){for(;;)if(G(),0===q&&","===y){if(t(),0===q&&"]"===y){H=A(H,",");break}}else{if(!F())break;H=p(H,",")}0===q&&"]"===y?t():H=p(H,"]")}else t()}();else if(t(),0!==q||"}"!==y){for(;;){if(3!==q&&1!==q||(q=2,y='"'.concat(y,'"')),2!==q)throw new n("Object key expected",K-y.length);if(t(),0===q&&":"===y)t();else{if(!F())throw new n("Colon expected",
K-y.length);H=p(H,":")}if(G(),0===q&&","===y){if(t(),0===q&&"}"===y){H=A(H,",");break}}else{if(2!==q&&1!==q&&3!==q)break;H=p(H,",")}}0===q&&"}"===y?t():H=p(H,"}")}else t()}(n.prototype=Error()).constructor=Error;var J={"'":!0,"\u2018":!0,"\u2019":!0,"`":!0,"\u00b4":!0},v={'"':!0,"\u201c":!0,"\u201d":!0},b=/^[a-zA-Z_]$/,g=/^[0-9a-fA-F]$/,a=/^[0-9]$/,c={"":!0,"{":!0,"}":!0,"[":!0,"]":!0,":":!0,",":!0,"(":!0,")":!0,";":!0,"+":!0},h={'"':'"',"\\":"\\","/":"/",b:"\b",f:"\f",n:"\n",r:"\r",t:"\t"},u={"\b":"\\b",
"\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"},M={null:"null",true:"true",false:"false"},S={None:"null",True:"true",False:"false"},m="",H="",K=0,z="",y="",q=6;return function(a){if(H="",K=0,z=(m=a).charAt(0),y="",q=6,t(),a=0===q&&"{"===y,G(),""===y)return H;if(a&&F()){for(a="";F();)a+=H=p(H,","),H="",G();return"[\n".concat(a).concat(H,"\n]")}throw new n("Unexpected characters",K-y.length);}})},483:function(w,n){var d,r,x;(function(e,A){!(r=[],d=A,x="function"===typeof d?d.apply(n,r):d,void 0!==x&&(w.exports=
x))})(this,function(){function d(b){return"object"===typeof Node?b instanceof Node:b&&"object"===typeof b&&"number"===typeof b.nodeType}function n(){var b=[];return{watch:b.push.bind(b),trigger:function(d,a){var c=!0;a={detail:a,preventDefault:function(){c=!1}};for(var e=0;e<b.length;e++)b[e](d,a);return c}}}function p(b){this.elem=b}function l(b,d){return p.make(b("parent")).clazz("pico-overlay").clazz(b("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",
width:"100%",zIndex:1E4}).stylize(b("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){b("overlayClose",!0)&&d()})}function r(b,d){var a=b("width","auto");"number"===typeof a&&(a=""+a+"px");var c=b("modalId","pico-"+G++);return p.make(b("parent")).clazz("pico-content").clazz(b("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:a,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)",
"-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(b("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(b("content")).attr("id",c).attr("role","dialog").attr("aria-labelledby",b("ariaLabelledBy")).attr("aria-describedby",b("ariaDescribedBy",c)).onClick(function(a){(new p(a.target)).anyAncestor(function(a){return/\bpico-close\b/.test(a.elem.className)})&&d()})}function w(b){return function(){return b().elem}}
function t(b,d){function a(a){return"none"===window.getComputedStyle(a).display||(a.msMatchesSelector||a.webkitMatchesSelector||a.matches).call(a,":disabled")||a.hasAttribute("contenteditable")?!1:a.hasAttribute("tabindex")||(a.msMatchesSelector||a.webkitMatchesSelector||a.matches).call(a,"input,select,textarea,button,a[href],area[href],iframe")}function c(b){b=b.getElementsByTagName("*");for(var c=0;c<b.length;c++)if(a(b[c]))return b[c]}var e;b.beforeShow(function(){e=document.activeElement});b.afterShow(function(){if(d()){var a=
c(b.modalElem());a&&a.focus()}});b.afterClose(function(){d()&&e&&e.focus();e=null});v.watch(function(e){if(d()&&b.isVisible()){var g=c(b.modalElem());a:{var h=b.modalElem().getElementsByTagName("*");for(var l=h.length;l--;)if(a(h[l])){h=h[l];break a}h=void 0}(e.shiftKey?g:h)===document.activeElement&&((e.shiftKey?h:g).focus(),e.preventDefault())}})}function x(b,d){var a,c=new p(document.body);b.beforeShow(function(){a=c.elem.style.overflow;d()&&c.stylize({overflow:"hidden"})});b.afterClose(function(){c.stylize({overflow:a})})}
p.make=function(b,d){"string"===typeof b&&(b=document.querySelector(b));d=document.createElement(d||"div");(b||document.body).appendChild(d);return new p(d)};p.prototype={child:function(b){return p.make(this.elem,b)},stylize:function(b){b=b||{};"undefined"!==typeof b.opacity&&(b.filter="alpha(opacity="+100*b.opacity+")");for(var d in b)b.hasOwnProperty(d)&&(this.elem.style[d]=b[d]);return this},clazz:function(b){this.elem.className+=" "+b;return this},html:function(b){d(b)?this.elem.appendChild(b):
this.elem.innerHTML=b;return this},onClick:function(b){this.elem.addEventListener("click",b);return this},destroy:function(){this.elem.parentNode.removeChild(this.elem)},hide:function(){this.elem.style.display="none"},show:function(){this.elem.style.display="block"},attr:function(b,d){void 0!==d&&this.elem.setAttribute(b,d);return this},anyAncestor:function(b){for(var d=this.elem;d;){if(b(new p(d)))return!0;d=d.parentNode}return!1},isVisible:function(){return"none"!==window.getComputedStyle(this.elem).display}};
var G=1,J=n(),v=n();document.documentElement.addEventListener("keydown",function(b){var d=b.which||b.keyCode;27===d?J.trigger():9===d&&v.trigger(b)});return function(b){function e(a,c){a=b[a];"function"===typeof a&&(a=a(c));return void 0===a?c:a}function a(a){y().hide();z().hide();F.trigger(G,a)}function c(b){D.trigger(G,b)&&a(b)}function h(a){return function(){a.apply(this,arguments);return G}}function p(a,b){if(!I){var d=r(e,c),g=l(e,c);var h=e("closeButton",!0)?d.child("button").html(e("closeHtml",
"&#xD7;")).clazz("pico-close").clazz(e("closeClass","")).stylize(e("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",e("close-label","Close")):void 0;I={modal:d,overlay:g,close:h};v.trigger(G,b)}return I[a]}if("string"===typeof b||d(b))b={content:b};var v=n(),A=n(),m=n(),D=n(),F=n(),z=p.bind(window,"modal"),y=p.bind(window,
"overlay"),q=p.bind(window,"close"),I;var G={modalElem:w(z),closeElem:w(q),overlayElem:w(y),buildDom:h(p.bind(null,null)),isVisible:function(){return!!(I&&z&&z().isVisible())},show:function(a){A.trigger(G,a)&&(y().show(),q(),z().show(),m.trigger(G,a));return this},close:h(c),forceClose:h(a),destroy:function(){z().destroy();y().destroy();y=z=q=void 0},options:function(a){Object.keys(a).map(function(c){b[c]=a[c]})},afterCreate:h(v.watch),beforeShow:h(A.watch),afterShow:h(m.watch),beforeClose:h(D.watch),
afterClose:h(F.watch)};t(G,e.bind(null,"focus",!0));x(G,e.bind(null,"bodyOverflow",!0));J.watch(function(){e("escCloses",!0)&&G.isVisible()&&G.close()});return G}})}},X={};!function(){N.n=function(w){var n=w&&w.__esModule?function(){return w["default"]}:function(){return w};N.d(n,{a:n});return n}}();!function(){N.d=function(w,n){for(var d in n)N.o(n,d)&&!N.o(w,d)&&Object.defineProperty(w,d,{enumerable:!0,get:n[d]})}}();!function(){N.o=function(w,n){return Object.prototype.hasOwnProperty.call(w,n)}}();
!function(){N.r=function(w){"undefined"!==typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(w,Symbol.toStringTag,{value:"Module"});Object.defineProperty(w,"__esModule",{value:!0})}}();return N(161)}()});