//# sourceMappingURL=jsoneditor.js.map
/*
 URI.js v4.4.1 (c) 2011 Gary Court. License: http://github.com/garycourt/uri-js  jsoneditor.js

 @brief
 JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 It has various modes such as a tree editor, a code editor, and a plain text
 editor.

 Supported browsers: Chrome, Firefox, Safari, Opera, Internet Explorer 8+

 @license
 Licensed under the Apache License, Version 2.0 (the "License"); you may not
 use this file except in compliance with the License. You may obtain a copy
 of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 License for the specific language governing permissions and limitations under
 the License.

 Copyright (c) 2011-2021 Jos de Jong, http://jsoneditoronline.org

 @author  Jos de Jong, <wjosdejong@gmail.com>
 @version 9.3.0
 @date    2021-04-01
 Selectr 2.4.0
 https://github.com/Mobius1/Selectr

 Released under the MIT license
 vanilla-picker v2.11.2
 https://vanilla-picker.js.org

 Copyright 2017-2021 Andreas Borgen (https://github.com/Sphinxxxx), Adam Brooks (https://github.com/dissimulate)
 Released under the ISC license.
*/
var process=process||{env:{NODE_ENV:"development"}};
(function(W,fa){"object"===typeof exports&&"object"===typeof module?module.exports=fa():"function"===typeof define&&define.amd?define([],fa):"object"===typeof exports?exports.JSONEditor=fa():W.JSONEditor=fa()})(self,function(){return function(){function W(y){var e=va[y];if(void 0!==e)return e.exports;e=va[y]={id:y,loaded:!1,exports:{}};fa[y].call(e.exports,e,e.exports,W);e.loaded=!0;return e.exports}var fa={6835:function(y){y.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-07/schema#","$id":"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#","description":"Meta-schema for $data reference (JSON Schema extension proposal)","type":"object","required":["$data"],"properties":{"$data":{"type":"string","anyOf":[{"format":"relative-json-pointer"},{"format":"json-pointer"}]}},"additionalProperties":false}')},2689:function(y){y.exports=
JSON.parse('{"id":"http://json-schema.org/draft-04/schema#","$schema":"http://json-schema.org/draft-04/schema#","description":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"positiveInteger":{"type":"integer","minimum":0},"positiveIntegerDefault0":{"allOf":[{"$ref":"#/definitions/positiveInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"minItems":1,"uniqueItems":true}},"type":"object","properties":{"id":{"type":"string"},"$schema":{"type":"string"},"title":{"type":"string"},"description":{"type":"string"},"default":{},"multipleOf":{"type":"number","minimum":0,"exclusiveMinimum":true},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"boolean","default":false},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"boolean","default":false},"maxLength":{"$ref":"#/definitions/positiveInteger"},"minLength":{"$ref":"#/definitions/positiveIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"anyOf":[{"type":"boolean"},{"$ref":"#"}],"default":{}},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":{}},"maxItems":{"$ref":"#/definitions/positiveInteger"},"minItems":{"$ref":"#/definitions/positiveIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"maxProperties":{"$ref":"#/definitions/positiveInteger"},"minProperties":{"$ref":"#/definitions/positiveIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"anyOf":[{"type":"boolean"},{"$ref":"#"}],"default":{}},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"enum":{"type":"array","minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"dependencies":{"exclusiveMaximum":["maximum"],"exclusiveMinimum":["minimum"]},"default":{}}')},
1030:function(y){y.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-06/schema#","$id":"http://json-schema.org/draft-06/schema#","title":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"nonNegativeInteger":{"type":"integer","minimum":0},"nonNegativeIntegerDefault0":{"allOf":[{"$ref":"#/definitions/nonNegativeInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"uniqueItems":true,"default":[]}},"type":["object","boolean"],"properties":{"$id":{"type":"string","format":"uri-reference"},"$schema":{"type":"string","format":"uri"},"$ref":{"type":"string","format":"uri-reference"},"title":{"type":"string"},"description":{"type":"string"},"default":{},"examples":{"type":"array","items":{}},"multipleOf":{"type":"number","exclusiveMinimum":0},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"number"},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"number"},"maxLength":{"$ref":"#/definitions/nonNegativeInteger"},"minLength":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"$ref":"#"},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":{}},"maxItems":{"$ref":"#/definitions/nonNegativeInteger"},"minItems":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"contains":{"$ref":"#"},"maxProperties":{"$ref":"#/definitions/nonNegativeInteger"},"minProperties":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"$ref":"#"},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"propertyNames":{"$ref":"#"},"const":{},"enum":{"type":"array","minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"default":{}}')},
38:function(y){y.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-07/schema#","$id":"http://json-schema.org/draft-07/schema#","title":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"nonNegativeInteger":{"type":"integer","minimum":0},"nonNegativeIntegerDefault0":{"allOf":[{"$ref":"#/definitions/nonNegativeInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"uniqueItems":true,"default":[]}},"type":["object","boolean"],"properties":{"$id":{"type":"string","format":"uri-reference"},"$schema":{"type":"string","format":"uri"},"$ref":{"type":"string","format":"uri-reference"},"$comment":{"type":"string"},"title":{"type":"string"},"description":{"type":"string"},"default":true,"readOnly":{"type":"boolean","default":false},"examples":{"type":"array","items":true},"multipleOf":{"type":"number","exclusiveMinimum":0},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"number"},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"number"},"maxLength":{"$ref":"#/definitions/nonNegativeInteger"},"minLength":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"$ref":"#"},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":true},"maxItems":{"$ref":"#/definitions/nonNegativeInteger"},"minItems":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"contains":{"$ref":"#"},"maxProperties":{"$ref":"#/definitions/nonNegativeInteger"},"minProperties":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"$ref":"#"},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"propertyNames":{"format":"regex"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"propertyNames":{"$ref":"#"},"const":true,"enum":{"type":"array","items":true,"minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"contentMediaType":{"type":"string"},"contentEncoding":{"type":"string"},"if":{"$ref":"#"},"then":{"$ref":"#"},"else":{"$ref":"#"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"default":true}')},
897:function(y,e,h){function b(b,a){for(var c=0;c<a.length;c++){var f=a[c];f.enumerable=f.enumerable||!1;f.configurable=!0;"value"in f&&(f.writable=!0);Object.defineProperty(b,f.key,f)}}function r(d,a,c){a&&b(d.prototype,a);c&&b(d,c);return d}h.d(e,{x:function(){return g}});var t=h(2602),k=h(9791),x=h(7907),g=function(){function b(a,c){function f(a,c,b){b.forEach(function(b){if("separator"===b.type){var l=document.createElement("div");l.className="jsoneditor-separator";var n=document.createElement("li");
n.appendChild(l);a.appendChild(n)}else{var v={};l=document.createElement("li");a.appendChild(l);n=document.createElement("button");n.type="button";n.className=b.className;v.button=n;b.title&&(n.title=b.title);b.click&&(n.onclick=function(a){a.preventDefault();d.hide();b.click()});l.appendChild(n);if(b.submenu){var g=document.createElement("div");g.className="jsoneditor-icon";n.appendChild(g);g=document.createElement("div");g.className="jsoneditor-text"+(b.click?"":" jsoneditor-right-margin");g.appendChild(document.createTextNode(b.text));
n.appendChild(g);if(b.click){n.className+=" jsoneditor-default";n=document.createElement("button");n.type="button";v.buttonExpand=n;n.className="jsoneditor-expand";g=document.createElement("div");g.className="jsoneditor-expand";n.appendChild(g);l.appendChild(n);b.submenuTitle&&(n.title=b.submenuTitle);var w=n}else g=document.createElement("div"),g.className="jsoneditor-expand",n.appendChild(g),w=n;w.onclick=function(a){a.preventDefault();d._onExpandItem(v);w.focus()};n=[];v.subItems=n;g=document.createElement("ul");
v.ul=g;g.className="jsoneditor-menu";g.style.height="0";l.appendChild(g);f(g,n,b.submenu)}else l=document.createElement("div"),l.className="jsoneditor-icon",n.appendChild(l),l=document.createElement("div"),l.className="jsoneditor-text",l.appendChild(document.createTextNode((0,x.Iu)(b.text))),n.appendChild(l);c.push(v)}})}if(!(this instanceof b))throw new TypeError("Cannot call a class as a function");this.dom={};var d=this,g=this.dom;this.anchor=void 0;this.items=a;this.eventListeners={};this.selection=
void 0;this.onClose=c?c.close:void 0;this.limitHeight=c?c.limitHeight:!1;c=document.createElement("div");c.className="jsoneditor-contextmenu-root";g.root=c;var p=document.createElement("div");p.className="jsoneditor-contextmenu";g.menu=p;c.appendChild(p);c=document.createElement("ul");c.className="jsoneditor-menu";p.appendChild(c);g.list=c;g.items=[];p=document.createElement("button");p.type="button";g.focusButton=p;g=document.createElement("li");g.style.overflow="hidden";g.style.height="0";g.appendChild(p);
c.appendChild(g);f(c,this.dom.items,a);this.maxHeight=0;a.forEach(function(c){d.maxHeight=Math.max(d.maxHeight,24*(a.length+(c.submenu?c.submenu.length:0)))})}r(b,[{key:"_getVisibleButtons",value:function(){var a=[],c=this;this.dom.items.forEach(function(b){a.push(b.button);b.buttonExpand&&a.push(b.buttonExpand);b.subItems&&b===c.expandedItem&&b.subItems.forEach(function(c){a.push(c.button);c.buttonExpand&&a.push(c.buttonExpand)})});return a}},{key:"show",value:function(a,c,f){this.hide();var d=!0,
g=a.parentNode,p=a.getBoundingClientRect(),l=g.getBoundingClientRect();g=c.getBoundingClientRect();var u=this;this.dom.absoluteAnchor=(0,t.w)(a,c,function(){u.hide()});p.bottom+this.maxHeight<g.bottom||p.top-this.maxHeight>g.top&&(d=!1);c=f?0:p.top-l.top;d?(f=a.offsetHeight,this.dom.menu.style.left="0",this.dom.menu.style.top=c+f+"px",this.dom.menu.style.bottom=""):(this.dom.menu.style.left="0",this.dom.menu.style.top="",this.dom.menu.style.bottom="0px");this.limitHeight&&(this.dom.list.style.maxHeight=
(d?g.bottom-p.bottom-10:p.top-g.top-10)+"px",this.dom.list.style.overflowY="auto");this.dom.absoluteAnchor.appendChild(this.dom.root);this.selection=(0,k.getSelection)();this.anchor=a;setTimeout(function(){u.dom.focusButton.focus()},0);b.visibleMenu&&b.visibleMenu.hide();b.visibleMenu=this}},{key:"hide",value:function(){this.dom.absoluteAnchor&&(this.dom.absoluteAnchor.destroy(),delete this.dom.absoluteAnchor);if(this.dom.root.parentNode&&(this.dom.root.parentNode.removeChild(this.dom.root),this.onClose))this.onClose();
b.visibleMenu===this&&(b.visibleMenu=void 0)}},{key:"_onExpandItem",value:function(a){var c=this,b=a===this.expandedItem,d=this.expandedItem;d&&(d.ul.style.height="0",d.ul.style.padding="",setTimeout(function(){c.expandedItem!==d&&(d.ul.style.display="",(0,k.removeClassName)(d.ul.parentNode,"jsoneditor-selected"))},300),this.expandedItem=void 0);if(!b){var g=a.ul;g.style.display="block";g.clientHeight;setTimeout(function(){if(c.expandedItem===a){for(var b=0,l=0;l<g.childNodes.length;l++)b+=g.childNodes[l].clientHeight;
g.style.height=b+"px";g.style.padding="5px 10px"}},0);(0,k.addClassName)(g.parentNode,"jsoneditor-selected");this.expandedItem=a}}},{key:"_onKeyDown",value:function(a){var c=a.target,b=a.which,d=!1;27===b?(this.selection&&(0,k.setSelection)(this.selection),this.anchor&&this.anchor.focus(),this.hide(),d=!0):9===b?a.shiftKey?(b=this._getVisibleButtons(),c=b.indexOf(c),0===c&&(b[b.length-1].focus(),d=!0)):(b=this._getVisibleButtons(),c=b.indexOf(c),c===b.length-1&&(b[0].focus(),d=!0)):37===b?("jsoneditor-expand"===
c.className&&(b=this._getVisibleButtons(),c=b.indexOf(c),(d=b[c-1])&&d.focus()),d=!0):38===b?(b=this._getVisibleButtons(),c=b.indexOf(c),(d=b[c-1])&&"jsoneditor-expand"===d.className&&(d=b[c-2]),d||(d=b[b.length-1]),d&&d.focus(),d=!0):39===b?(b=this._getVisibleButtons(),c=b.indexOf(c),(d=b[c+1])&&"jsoneditor-expand"===d.className&&d.focus(),d=!0):40===b&&(b=this._getVisibleButtons(),c=b.indexOf(c),(d=b[c+1])&&"jsoneditor-expand"===d.className&&(d=b[c+2]),d||(d=b[0]),d&&d.focus(),d=!0);d&&(a.stopPropagation(),
a.preventDefault())}}]);return b}();g.visibleMenu=void 0},6436:function(y,e,h){function b(b,e){for(var g=0;g<e.length;g++){var d=e[g];d.enumerable=d.enumerable||!1;d.configurable=!0;"value"in d&&(d.writable=!0);Object.defineProperty(b,d.key,d)}}function r(e,x,g){x&&b(e.prototype,x);g&&b(e,g);return e}h.d(e,{Q:function(){return t}});var t=function(){function b(e){if(!(this instanceof b))throw new TypeError("Cannot call a class as a function");this.errorTableVisible=e.errorTableVisible;this.onToggleVisibility=
e.onToggleVisibility;this.onFocusLine=e.onFocusLine||function(){};this.onChangeHeight=e.onChangeHeight;this.dom={};e=document.createElement("div");e.className="jsoneditor-validation-errors-container";this.dom.validationErrorsContainer=e;var g=document.createElement("div");g.style.display="none";g.className="jsoneditor-additional-errors fadein";g.textContent="Scroll for more \u25bf";this.dom.additionalErrorsIndication=g;e.appendChild(g);e=document.createElement("span");e.className="jsoneditor-validation-error-icon";
e.style.display="none";this.dom.validationErrorIcon=e;e=document.createElement("span");e.className="jsoneditor-validation-error-count";e.style.display="none";this.dom.validationErrorCount=e;this.dom.parseErrorIndication=document.createElement("span");this.dom.parseErrorIndication.className="jsoneditor-parse-error-icon";this.dom.parseErrorIndication.style.display="none"}r(b,[{key:"getErrorTable",value:function(){return this.dom.validationErrorsContainer}},{key:"getErrorCounter",value:function(){return this.dom.validationErrorCount}},
{key:"getWarningIcon",value:function(){return this.dom.validationErrorIcon}},{key:"getErrorIcon",value:function(){return this.dom.parseErrorIndication}},{key:"toggleTableVisibility",value:function(){this.errorTableVisible=!this.errorTableVisible;this.onToggleVisibility(this.errorTableVisible)}},{key:"setErrors",value:function(b,g){var d=this;this.dom.validationErrors&&(this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors),this.dom.validationErrors=null,this.dom.additionalErrorsIndication.style.display=
"none");if(this.errorTableVisible&&0<b.length){var a=document.createElement("div");a.className="jsoneditor-validation-errors";var c=document.createElement("table");c.className="jsoneditor-text-errors";a.appendChild(c);var f=document.createElement("tbody");c.appendChild(f);b.forEach(function(a){if(!isNaN(a.line))var c=a.line;else if(a.dataPath){var b=g.find(function(c){return c.path===a.dataPath});b&&(c=b.line+1)}b=document.createElement("tr");b.className=isNaN(c)?"":"jump-to-line";b.className="error"===
a.type?b.className+" parse-error":b.className+" validation-error";var l=document.createElement("td"),u=document.createElement("button");u.className="jsoneditor-schema-error";l.appendChild(u);b.appendChild(l);l=document.createElement("td");l.style="white-space: nowrap;";l.textContent=isNaN(c)?"":"Ln "+c;b.appendChild(l);"string"===typeof a?(l=document.createElement("td"),l.colSpan=2,u=document.createElement("pre"),u.appendChild(document.createTextNode(a)),l.appendChild(u),b.appendChild(l)):(l=document.createElement("td"),
l.appendChild(document.createTextNode(a.dataPath||"")),b.appendChild(l),l=document.createElement("td"),u=document.createElement("pre"),u.appendChild(document.createTextNode(a.message)),l.appendChild(u),b.appendChild(l));b.onclick=function(){d.onFocusLine(c)};f.appendChild(b)});this.dom.validationErrors=a;this.dom.validationErrorsContainer.appendChild(a);this.dom.additionalErrorsIndication.title=b.length+" errors total";this.dom.validationErrorsContainer.clientHeight<this.dom.validationErrorsContainer.scrollHeight?
(this.dom.additionalErrorsIndication.style.display="block",this.dom.validationErrorsContainer.onscroll=function(){d.dom.additionalErrorsIndication.style.display=0<d.dom.validationErrorsContainer.clientHeight&&0===d.dom.validationErrorsContainer.scrollTop?"block":"none"}):this.dom.validationErrorsContainer.onscroll=void 0;this.onChangeHeight(this.dom.validationErrorsContainer.clientHeight+(this.dom.statusBar?this.dom.statusBar.clientHeight:0))}else this.onChangeHeight(0);a=b.filter(function(a){return"error"!==
a.type}).length;0<a?(this.dom.validationErrorCount.style.display="inline",this.dom.validationErrorCount.innerText=a,this.dom.validationErrorCount.onclick=this.toggleTableVisibility.bind(this),this.dom.validationErrorIcon.style.display="inline",this.dom.validationErrorIcon.title=a+" schema validation error(s) found",this.dom.validationErrorIcon.onclick=this.toggleTableVisibility.bind(this)):(this.dom.validationErrorCount.style.display="none",this.dom.validationErrorIcon.style.display="none");b.some(function(a){return"error"===
a.type})?(b=b[0].line,this.dom.parseErrorIndication.style.display="block",this.dom.parseErrorIndication.title=isNaN(b)?"parse error - check that the json is valid":"parse error on line "+b,this.dom.parseErrorIndication.onclick=this.toggleTableVisibility.bind(this)):this.dom.parseErrorIndication.style.display="none"}}]);return b}()},2474:function(y,e,h){function b(b,e){for(var g=0;g<e.length;g++){var d=e[g];d.enumerable=d.enumerable||!1;d.configurable=!0;"value"in d&&(d.writable=!0);Object.defineProperty(b,
d.key,d)}}function r(e,x,g){x&&b(e.prototype,x);g&&b(e,g);return e}h.d(e,{R:function(){return t}});var t=function(){function b(e){if(!(this instanceof b))throw new TypeError("Cannot call a class as a function");this.target=e.target||null;if(!this.target)throw Error('FocusTracker constructor called without a "target" to track.');this.onFocus="function"===typeof e.onFocus?e.onFocus:null;this.onBlur="function"===typeof e.onBlur?e.onBlur:null;this._onClick=this._onEvent.bind(this);this._onKeyUp=function(b){9!==
b.which&&9!==b.keyCode||this._onEvent(b)}.bind(this);this.focusFlag=!1;this.firstEventFlag=!0;if(this.onFocus||this.onBlur)document.addEventListener("click",this._onClick),document.addEventListener("keyup",this._onKeyUp)}r(b,[{key:"destroy",value:function(){document.removeEventListener("click",this._onClick);document.removeEventListener("keyup",this._onKeyUp);this._onEvent({target:document.body})}},{key:"_onEvent",value:function(b){b=b.target;if(b===this.target||this.target.contains(b)||this.target.contains(document.activeElement)){if(!this.focusFlag){if(this.onFocus)this.onFocus({type:"focus",
target:this.target});this.focusFlag=!0}}else if(this.focusFlag||this.firstEventFlag){if(this.onBlur)this.onBlur({type:"blur",target:this.target});this.focusFlag=!1;this.firstEventFlag&&(this.firstEventFlag=!1)}}}]);return b}()},3161:function(y,e,h){function b(a,c,l){if(!(this instanceof b))throw Error('JSONEditor constructor called without "new".');var d=f();if(-1!==d&&9>d)throw Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");c&&(c.error&&(console.warn('Option "error" has been renamed to "onError"'),
c.onError=c.error,delete c.error),c.change&&(console.warn('Option "change" has been renamed to "onChange"'),c.onChange=c.change,delete c.change),c.editable&&(console.warn('Option "editable" has been renamed to "onEditable"'),c.onEditable=c.editable,delete c.editable),c.onChangeJSON&&("text"===c.mode||"code"===c.mode||c.modes&&(-1!==c.modes.indexOf("text")||-1!==c.modes.indexOf("code")))&&console.warn('Option "onChangeJSON" is not applicable to modes "text" and "code". Use "onChangeText" or "onChange" instead.'),
c&&Object.keys(c).forEach(function(a){-1===b.VALID_OPTIONS.indexOf(a)&&console.warn('Unknown option "'+a+'". This option will be ignored')}));arguments.length&&this._create(a,c,l)}e=h(8170);var r=h(8037),t=h(8038).treeModeMixins,k=h(5956).textModeMixins,x=h(341).previewModeMixins,g=h(9791),d=g.clear,a=g.extend,c=g.getInnerText,f=g.getInternetExplorerVersion,w=g.parse;g=h(2744).tryRequireAjv;var m=h(2558).showTransformModal,p=h(6210).showSortModal,l=g();"undefined"===typeof Promise&&console.error("Promise undefined. Please load a Promise polyfill in the browser in order to use JSONEditor");
b.modes={};b.prototype.DEBOUNCE_INTERVAL=150;b.VALID_OPTIONS="ajv schema schemaRefs templates ace theme autocomplete onChange onChangeJSON onChangeText onEditable onError onEvent onModeChange onNodeName onValidate onCreateMenu onSelectionChange onTextSelectionChange onClassName onFocus onBlur colorPicker onColorPicker timestampTag timestampFormat escapeUnicode history search mode modes name indentation sortObjectKeys navigationBar statusBar mainMenuBar languages language enableSort enableTransform limitDragging maxVisibleChilds onValidationError modalAnchor popupAnchor createQuery executeQuery queryDescription".split(" ");
b.prototype._create=function(a,c,b){this.container=a;this.options=c||{};this.json=b||{};this.setMode(this.options.mode||this.options.modes&&this.options.modes[0]||"tree")};b.prototype.destroy=function(){};b.prototype.set=function(a){this.json=a};b.prototype.get=function(){return this.json};b.prototype.setText=function(a){this.json=w(a)};b.prototype.getText=function(){return JSON.stringify(this.json)};b.prototype.setName=function(a){this.options||(this.options={});this.options.name=a};b.prototype.getName=
function(){return this.options&&this.options.name};b.prototype.setMode=function(c){if(c!==this.options.mode||!this.create){var l=this.container,f=a({},this.options),q=f.mode;f.mode=c;var n=b.modes[c];if(n)try{var g="text"===n.data;var m=this.getName();var u=this[g?"getText":"get"]();this.destroy();d(this);a(this,n.mixin);this.create(l,f);this.setName(m);this[g?"setText":"set"](u);if("function"===typeof n.load)try{n.load.call(this)}catch(H){console.error(H)}if("function"===typeof f.onModeChange&&c!==
q)try{f.onModeChange(c,q)}catch(H){console.error(H)}}catch(H){this._onError(H)}else throw Error('Unknown mode "'+f.mode+'"');}};b.prototype.getMode=function(){return this.options.mode};b.prototype._onError=function(a){if(this.options&&"function"===typeof this.options.onError)this.options.onError(a);else throw a;};b.prototype.setSchema=function(a,c){if(a){try{if(this.options.ajv)var b=this.options.ajv;else b=l({allErrors:!0,verbose:!0,schemaId:"auto",$data:!0}),b.addMetaSchema(h(2689)),b.addMetaSchema(h(1030))}catch(n){console.warn("Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.")}if(b){if(c){for(var d in c)b.removeSchema(d),
c[d]&&b.addSchema(c[d],d);this.options.schemaRefs=c}this.validateSchema=b.compile(a);this.options.schema=a;this.validate()}}else this.validateSchema=null,this.options.schema=null,this.options.schemaRefs=null,this.validate();this.refresh()};b.prototype.validate=function(){};b.prototype.refresh=function(){};b.registerMode=function(a){var c;if(Array.isArray(a))for(c=0;c<a.length;c++)b.registerMode(a[c]);else{if(!("mode"in a))throw Error('Property "mode" missing');if(!("mixin"in a))throw Error('Property "mixin" missing');
if(!("data"in a))throw Error('Property "data" missing');var l=a.mode;if(l in b.modes)throw Error('Mode "'+l+'" already registered');if("function"!==typeof a.mixin.create)throw Error('Required function "create" missing on mixin');var d=["setMode","registerMode","modes"];for(c=0;c<d.length;c++){var n=d[c];if(n in a.mixin)throw Error('Reserved property "'+n+'" not allowed in mixin');}b.modes[l]=a}};b.registerMode(t);b.registerMode(k);b.registerMode(x);b.ace=e;b.Ajv=l;b.VanillaPicker=r;b.showTransformModal=
m;b.showSortModal=p;b.getInnerText=c;b["default"]=b;y.exports=b},6617:function(y,e,h){function b(b,d){for(var a=0;a<d.length;a++){var c=d[a];c.enumerable=c.enumerable||!1;c.configurable=!0;"value"in c&&(c.writable=!0);Object.defineProperty(b,c.key,c)}}function r(g,d,a){d&&b(g.prototype,d);a&&b(g,a);return g}h.d(e,{x:function(){return x}});var t=h(897),k=h(7907),x=function(){function b(d,a,c,f){if(!(this instanceof b))throw new TypeError("Cannot call a class as a function");for(var g={code:{text:(0,
k.Iu)("modeCodeText"),title:(0,k.Iu)("modeCodeTitle"),click:function(){f("code")}},form:{text:(0,k.Iu)("modeFormText"),title:(0,k.Iu)("modeFormTitle"),click:function(){f("form")}},text:{text:(0,k.Iu)("modeTextText"),title:(0,k.Iu)("modeTextTitle"),click:function(){f("text")}},tree:{text:(0,k.Iu)("modeTreeText"),title:(0,k.Iu)("modeTreeTitle"),click:function(){f("tree")}},view:{text:(0,k.Iu)("modeViewText"),title:(0,k.Iu)("modeViewTitle"),click:function(){f("view")}},preview:{text:(0,k.Iu)("modePreviewText"),
title:(0,k.Iu)("modePreviewTitle"),click:function(){f("preview")}}},m=[],e=0;e<a.length;e++){var l=a[e],u=g[l];if(!u)throw Error('Unknown mode "'+l+'"');u.className="jsoneditor-type-modes"+(c===l?" jsoneditor-selected":"");m.push(u)}a=g[c];if(!a)throw Error('Unknown mode "'+c+'"');c=a.text;var v=document.createElement("button");v.type="button";v.className="jsoneditor-modes jsoneditor-separator";v.textContent=c+" \u25be";v.title=(0,k.Iu)("modeEditorTitle");v.onclick=function(){(new t.x(m)).show(v,
d)};c=document.createElement("div");c.className="jsoneditor-modes";c.style.position="relative";c.appendChild(v);d.appendChild(c);this.dom={container:d,box:v,frame:c}}r(b,[{key:"focus",value:function(){this.dom.box.focus()}},{key:"destroy",value:function(){this.dom&&this.dom.frame&&this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame);this.dom=null}}]);return b}()},8170:function(y,e,h){if(window.ace)var b=window.ace;else try{b=h(6225);h(4091);h(3330);var r=h(7923);b.config.setModuleUrl("ace/mode/json_worker",
r)}catch(t){}y.exports=b},4864:function(){window.ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(y,e,h){e.isDark=!1;e.cssClass="ace-jsoneditor";e.cssText='.ace-jsoneditor .ace_gutter {\nbackground: #ebebeb;\ncolor: #333\n}\n\n.ace-jsoneditor.ace_editor {\nfont-family: "dejavu sans mono", "droid sans mono", consolas, monaco, "lucida console", "courier new", courier, monospace, sans-serif;\nline-height: 1.3;\nbackground-color: #fff;\n}\n.ace-jsoneditor .ace_print-margin {\nwidth: 1px;\nbackground: #e8e8e8\n}\n.ace-jsoneditor .ace_scroller {\nbackground-color: #FFFFFF\n}\n.ace-jsoneditor .ace_text-layer {\ncolor: gray\n}\n.ace-jsoneditor .ace_variable {\ncolor: #1a1a1a\n}\n.ace-jsoneditor .ace_cursor {\nborder-left: 2px solid #000000\n}\n.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {\nborder-left: 0px;\nborder-bottom: 1px solid #000000\n}\n.ace-jsoneditor .ace_marker-layer .ace_selection {\nbackground: lightgray\n}\n.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {\nbox-shadow: 0 0 3px 0px #FFFFFF;\nborder-radius: 2px\n}\n.ace-jsoneditor .ace_marker-layer .ace_step {\nbackground: rgb(255, 255, 0)\n}\n.ace-jsoneditor .ace_marker-layer .ace_bracket {\nmargin: -1px 0 0 -1px;\nborder: 1px solid #BFBFBF\n}\n.ace-jsoneditor .ace_marker-layer .ace_active-line {\nbackground: #FFFBD1\n}\n.ace-jsoneditor .ace_gutter-active-line {\nbackground-color : #dcdcdc\n}\n.ace-jsoneditor .ace_marker-layer .ace_selected-word {\nborder: 1px solid lightgray\n}\n.ace-jsoneditor .ace_invisible {\ncolor: #BFBFBF\n}\n.ace-jsoneditor .ace_keyword,\n.ace-jsoneditor .ace_meta,\n.ace-jsoneditor .ace_support.ace_constant.ace_property-value {\ncolor: #AF956F\n}\n.ace-jsoneditor .ace_keyword.ace_operator {\ncolor: #484848\n}\n.ace-jsoneditor .ace_keyword.ace_other.ace_unit {\ncolor: #96DC5F\n}\n.ace-jsoneditor .ace_constant.ace_language {\ncolor: darkorange\n}\n.ace-jsoneditor .ace_constant.ace_numeric {\ncolor: red\n}\n.ace-jsoneditor .ace_constant.ace_character.ace_entity {\ncolor: #BF78CC\n}\n.ace-jsoneditor .ace_invalid {\ncolor: #FFFFFF;\nbackground-color: #FF002A;\n}\n.ace-jsoneditor .ace_fold {\nbackground-color: #AF956F;\nborder-color: #000000\n}\n.ace-jsoneditor .ace_storage,\n.ace-jsoneditor .ace_support.ace_class,\n.ace-jsoneditor .ace_support.ace_function,\n.ace-jsoneditor .ace_support.ace_other,\n.ace-jsoneditor .ace_support.ace_type {\ncolor: #C52727\n}\n.ace-jsoneditor .ace_string {\ncolor: green\n}\n.ace-jsoneditor .ace_comment {\ncolor: #BCC8BA\n}\n.ace-jsoneditor .ace_entity.ace_name.ace_tag,\n.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {\ncolor: #606060\n}\n.ace-jsoneditor .ace_markup.ace_underline {\ntext-decoration: underline\n}\n.ace-jsoneditor .ace_indent-guide {\nbackground: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y\n}';
y("../lib/dom").importCssString(e.cssText,e.cssClass)})},6589:function(y,e){y=function(){var e={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",
18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(b,e,k,x,g,d,a){e=d.length-1;switch(g){case 1:this.$=b.replace(/\\(\\|")/g,"$1").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"\t").replace(/\\v/g,"\v").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(b);break;case 3:this.$=null;break;case 4:this.$=!0;
break;case 5:this.$=!1;break;case 6:return this.$=d[e-1];case 13:this.$={};break;case 14:this.$=d[e-1];break;case 15:this.$=[d[e-2],d[e]];break;case 16:this.$={};this.$[d[e][0]]=d[e][1];break;case 17:this.$=d[e-2];d[e-2][d[e][0]]=d[e][1];break;case 18:this.$=[];break;case 19:this.$=d[e-1];break;case 20:this.$=[d[e]];break;case 21:this.$=d[e-2],d[e-2].push(d[e])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,
7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,
8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,
6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(b,e){throw Error(b);},parse:function(b){function e(){var a=r.lexer.lex()||1;"number"!==typeof a&&(a=r.symbols_[a]||a);return a}var r=this,x=[0],g=[null],d=[],a=this.table,c="",f=0,w=0,m=0;this.lexer.setInput(b);this.lexer.yy=this.yy;this.yy.lexer=this.lexer;"undefined"==typeof this.lexer.yylloc&&(this.lexer.yylloc=
{});b=this.lexer.yylloc;d.push(b);"function"===typeof this.yy.parseError&&(this.parseError=this.yy.parseError);for(var p,l,u,v,A={},q,n;;){u=x[x.length-1];this.defaultActions[u]?v=this.defaultActions[u]:(null==p&&(p=e()),v=a[u]&&a[u][p]);if("undefined"===typeof v||!v.length||!v[0]){if(!m){l=[];for(q in a[u])this.terminals_[q]&&2<q&&l.push("'"+this.terminals_[q]+"'");var J="";J=this.lexer.showPosition?"Parse error on line "+(f+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+l.join(", ")+", got '"+
this.terminals_[p]+"'":"Parse error on line "+(f+1)+": Unexpected "+(1==p?"end of input":"'"+(this.terminals_[p]||p)+"'");this.parseError(J,{text:this.lexer.match,token:this.terminals_[p]||p,line:this.lexer.yylineno,loc:b,expected:l})}if(3==m){if(1==p)throw Error(J||"Parsing halted.");w=this.lexer.yyleng;c=this.lexer.yytext;f=this.lexer.yylineno;b=this.lexer.yylloc;p=e()}for(;!((2).toString()in a[u]);){if(0==u)throw Error(J||"Parsing halted.");x.length-=2;--g.length;--d.length;u=x[x.length-1]}l=p;
p=2;u=x[x.length-1];v=a[u]&&a[u][2];m=3}if(v[0]instanceof Array&&1<v.length)throw Error("Parse Error: multiple actions possible at state: "+u+", token: "+p);switch(v[0]){case 1:x.push(p);g.push(this.lexer.yytext);d.push(this.lexer.yylloc);x.push(v[1]);p=null;l?(p=l,l=null):(w=this.lexer.yyleng,c=this.lexer.yytext,f=this.lexer.yylineno,b=this.lexer.yylloc,0<m&&m--);break;case 2:n=this.productions_[v[1]][1];A.$=g[g.length-n];A._$={first_line:d[d.length-(n||1)].first_line,last_line:d[d.length-1].last_line,
first_column:d[d.length-(n||1)].first_column,last_column:d[d.length-1].last_column};u=this.performAction.call(A,c,w,f,this.yy,v[1],g,d);if("undefined"!==typeof u)return u;n&&(x=x.slice(0,-2*n),g=g.slice(0,-1*n),d=d.slice(0,-1*n));x.push(this.productions_[v[1]][0]);g.push(A.$);d.push(A._$);v=a[x[x.length-2]][x[x.length-1]];x.push(v);break;case 3:return!0}}}},b=function(){return{EOF:1,parseError:function(b,e){if(this.yy.parseError)this.yy.parseError(b,e);else throw Error(b);},setInput:function(b){this._input=
b;this._more=this._less=this.done=!1;this.yylineno=this.yyleng=0;this.yytext=this.matched=this.match="";this.conditionStack=["INITIAL"];this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0};return this},input:function(){var b=this._input[0];this.yytext+=b;this.yyleng++;this.match+=b;this.matched+=b;b.match(/\n/)&&this.yylineno++;this._input=this._input.slice(1);return b},unput:function(b){this._input=b+this._input;return this},more:function(){this._more=!0;return this},less:function(b){this._input=
this.match.slice(b)+this._input},pastInput:function(){var b=this.matched.substr(0,this.matched.length-this.match.length);return(20<b.length?"...":"")+b.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var b=this.match;20>b.length&&(b+=this._input.substr(0,20-b.length));return(b.substr(0,20)+(20<b.length?"...":"")).replace(/\n/g,"")},showPosition:function(){var b=this.pastInput(),e=Array(b.length+1).join("-");return b+this.upcomingInput()+"\n"+e+"^"},next:function(){if(this.done)return this.EOF;
this._input||(this.done=!0);var b;this._more||(this.match=this.yytext="");for(var e=this._currentRules(),k=0;k<e.length;k++)if((b=this._input.match(this.rules[e[k]]))&&(!x||b[0].length>x[0].length)){var x=b;var g=k;if(!this.options.flex)break}if(x){if(b=x[0].match(/\n.*/g))this.yylineno+=b.length;this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:b?b[b.length-1].length-1:this.yylloc.last_column+x[0].length};this.yytext+=x[0];this.match+=
x[0];this.yyleng=this.yytext.length;this._more=!1;this._input=this._input.slice(x[0].length);this.matched+=x[0];x=this.performAction.call(this,this.yy,this,e[g],this.conditionStack[this.conditionStack.length-1]);this.done&&this._input&&(this.done=!1);if(x)return x}else{if(""===this._input)return this.EOF;this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})}},lex:function(){var b=this.next();return"undefined"!==
typeof b?b:this.lex()},begin:function(b){this.conditionStack.push(b)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(b){this.begin(b)},options:{},performAction:function(b,e,k,x){switch(k){case 1:return 6;case 2:return e.yytext=e.yytext.substr(1,e.yyleng-2),4;case 3:return 17;case 4:return 18;
case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},rules:[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],conditions:{INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}}}}();
e.lexer=b;return e}();e.parser=y;e.parse=y.parse.bind(y)},3879:function(y){function e(a,c){return a.hasOwnProperty(c)&&(!0===a[c]||a[c].length)}function h(a,c,b){a.parentNode?a.parentNode.parentNode||c.appendChild(a.parentNode):c.appendChild(a);t.removeClass(a,"excluded");b||(a.textContent+="")}var b={defaultSelected:!0,width:"auto",disabled:!1,searchable:!0,clearable:!1,sortSelected:!1,allowDeselect:!1,closeOnScroll:!1,nativeDropdown:!1,placeholder:"Select an option...",taggable:!1,tagPlaceholder:"Enter a tag..."},
r=function(){};r.prototype={on:function(a,c){this._events=this._events||{};this._events[a]=this._events[a]||[];this._events[a].push(c)},off:function(a,c){this._events=this._events||{};!1!==a in this._events&&this._events[a].splice(this._events[a].indexOf(c),1)},emit:function(a){this._events=this._events||{};if(!1!==a in this._events)for(var c=0;c<this._events[a].length;c++)this._events[a][c].apply(this,Array.prototype.slice.call(arguments,1))}};r.mixin=function(a){for(var c=["on","off","emit"],b=
0;b<c.length;b++)"function"===typeof a?a.prototype[c[b]]=r.prototype[c[b]]:a[c[b]]=r.prototype[c[b]];return a};var t={extend:function(a,c){c=c||{};for(var b in a)a.hasOwnProperty(b)&&(c.hasOwnProperty(b)||(c[b]=a[b]));return c},each:function(a,c,b){if("[object Object]"===Object.prototype.toString.call(a))for(var l in a)Object.prototype.hasOwnProperty.call(a,l)&&c.call(b,l,a[l],a);else{l=0;for(var d=a.length;l<d;l++)c.call(b,l,a[l],a)}},createElement:function(a,c){var b=document;a=b.createElement(a);
if(c&&"[object Object]"===Object.prototype.toString.call(c))for(var l in c)if(l in a)a[l]=c[l];else if("html"===l)a.textContent=c[l];else if("text"===l){var d=b.createTextNode(c[l]);a.appendChild(d)}else a.setAttribute(l,c[l]);return a},hasClass:function(a,c){if(a)return a.classList?a.classList.contains(c):!!a.className&&!!a.className.match(new RegExp("(\\s|^)"+c+"(\\s|$)"))},addClass:function(a,c){t.hasClass(a,c)||(a.classList?a.classList.add(c):a.className=a.className.trim()+" "+c)},removeClass:function(a,
c){t.hasClass(a,c)&&(a.classList?a.classList.remove(c):a.className=a.className.replace(new RegExp("(^|\\s)"+c.split(" ").join("|")+"(\\s|$)","gi")," "))},closest:function(a,c){return a&&a!==document.body&&(c(a)?a:t.closest(a.parentNode,c))},isInt:function(a){return"number"===typeof a&&isFinite(a)&&Math.floor(a)===a},debounce:function(a,c,b){var d;return function(){var l=this,n=arguments,f=b&&!d;clearTimeout(d);d=setTimeout(function(){d=null;b||a.apply(l,n)},c);f&&a.apply(l,n)}},rect:function(a,c){var b=
window;a=a.getBoundingClientRect();var d=c?b.pageXOffset:0;c=c?b.pageYOffset:0;return{bottom:a.bottom+c,height:a.height,left:a.left+d,right:a.right+d,top:a.top+c,width:a.width}},includes:function(a,c){return-1<a.indexOf(c)},truncate:function(a){for(;a.firstChild;)a.removeChild(a.firstChild)}},k=function(){if(this.items.length){var a=document.createDocumentFragment();if(this.config.pagination){var c=this.pages.slice(0,this.pageIndex);t.each(c,function(c,b){t.each(b,function(c,b){h(b,a,this.customOption)},
this)},this)}else t.each(this.items,function(c,b){h(b,a,this.customOption)},this);a.childElementCount&&(t.removeClass(this.items[this.navIndex],"active"),this.navIndex=a.querySelector(".selectr-option").idx,t.addClass(this.items[this.navIndex],"active"));this.tree.appendChild(a)}},x=function(a){this.container.contains(a.target)||!this.opened&&!t.hasClass(this.container,"notice")||this.close()},g=function(a,c){c=this.customOption?this.config.renderOption(c||a):a.textContent;c=t.createElement("li",
{"class":"selectr-option",html:c,role:"treeitem","aria-selected":!1});c.idx=a.idx;this.items.push(c);a.defaultSelected&&this.defaultSelected.push(a.idx);a.disabled&&(c.disabled=!0,t.addClass(c,"disabled"));return c},d=function(){this.requiresPagination=this.config.pagination&&0<this.config.pagination;e(this.config,"width")&&(t.isInt(this.config.width)?this.width=this.config.width+"px":"auto"===this.config.width?this.width="100%":t.includes(this.config.width,"%")&&(this.width=this.config.width));this.container=
t.createElement("div",{"class":"selectr-container"});this.config.customClass&&t.addClass(this.container,this.config.customClass);this.mobileDevice?t.addClass(this.container,"selectr-mobile"):t.addClass(this.container,"selectr-desktop");this.el.tabIndex=-1;this.config.nativeDropdown||this.mobileDevice?t.addClass(this.el,"selectr-visible"):t.addClass(this.el,"selectr-hidden");this.selected=t.createElement("div",{"class":"selectr-selected",disabled:this.disabled,tabIndex:1,"aria-expanded":!1});this.label=
t.createElement(this.el.multiple?"ul":"span",{"class":"selectr-label"});var a=t.createElement("div",{"class":"selectr-options-container"});this.tree=t.createElement("ul",{"class":"selectr-options",role:"tree","aria-hidden":!0,"aria-expanded":!1});this.notice=t.createElement("div",{"class":"selectr-notice"});this.el.setAttribute("aria-hidden",!0);this.disabled&&(this.el.disabled=!0);this.el.multiple&&(t.addClass(this.label,"selectr-tags"),t.addClass(this.container,"multiple"),this.tags=[],this.selectedValues=
this.getSelectedProperties("value"),this.selectedIndexes=this.getSelectedProperties("idx"));this.selected.appendChild(this.label);this.config.clearable&&(this.selectClear=t.createElement("button",{"class":"selectr-clear",type:"button"}),this.container.appendChild(this.selectClear),t.addClass(this.container,"clearable"));if(this.config.taggable){var c=t.createElement("li",{"class":"input-tag"});this.input=t.createElement("input",{"class":"selectr-tag-input",placeholder:this.config.tagPlaceholder,tagIndex:0,
autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"});c.appendChild(this.input);this.label.appendChild(c);t.addClass(this.container,"taggable");this.tagSeperators=[","];this.config.tagSeperators&&(this.tagSeperators=this.tagSeperators.concat(this.config.tagSeperators))}this.config.searchable&&(this.input=t.createElement("input",{"class":"selectr-input",tagIndex:-1,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",
type:"search"}),this.inputClear=t.createElement("button",{"class":"selectr-input-clear",type:"button"}),this.inputContainer=t.createElement("div",{"class":"selectr-input-container"}),this.inputContainer.appendChild(this.input),this.inputContainer.appendChild(this.inputClear),a.appendChild(this.inputContainer));a.appendChild(this.notice);a.appendChild(this.tree);this.items=[];this.options=[];this.el.options.length&&(this.options=[].slice.call(this.el.options));var b=!1,d=0;this.el.children.length&&
t.each(this.el.children,function(a,c){"OPTGROUP"===c.nodeName?(b=t.createElement("ul",{"class":"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+c.label+"</li>"}),t.each(c.children,function(a,c){c.idx=d;b.appendChild(g.call(this,c,b));d++},this)):(c.idx=d,g.call(this,c),d++)},this);if(this.config.data&&Array.isArray(this.config.data)){this.data=[];var f=!1,n;b=!1;d=0;t.each(this.config.data,function(a,c){e(c,"children")?(f=t.createElement("optgroup",{label:c.text}),b=t.createElement("ul",
{"class":"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+c.text+"</li>"}),t.each(c.children,function(a,c){n=new Option(c.text,c.value,!1,c.hasOwnProperty("selected")&&!0===c.selected);n.disabled=e(c,"disabled");this.options.push(n);f.appendChild(n);n.idx=d;b.appendChild(g.call(this,n,c));this.data[d]=c;d++},this)):(n=new Option(c.text,c.value,!1,c.hasOwnProperty("selected")&&!0===c.selected),n.disabled=e(c,"disabled"),this.options.push(n),n.idx=d,g.call(this,n,c),this.data[d]=
c,d++)},this)}this.setSelected(!0);for(var m=this.navIndex=0;m<this.items.length;m++)if(c=this.items[m],!t.hasClass(c,"disabled")){t.addClass(c,"active");this.navIndex=m;break}this.requiresPagination&&(this.pageIndex=1,this.paginate());this.container.appendChild(this.selected);this.container.appendChild(a);this.placeEl=t.createElement("div",{"class":"selectr-placeholder"});this.setPlaceholder();this.selected.appendChild(this.placeEl);this.disabled&&this.disable();this.el.parentNode.insertBefore(this.container,
this.el);this.container.appendChild(this.el)},a=function(a){a=a||window.event;if(this.items.length&&this.opened&&t.includes([13,38,40],a.which)){a.preventDefault();if(13===a.which)return this.config.taggable&&0<this.input.value.length?!1:this.change(this.navIndex);var c=this.items[this.navIndex];switch(a.which){case 38:var b=0;0<this.navIndex&&this.navIndex--;break;case 40:b=1,this.navIndex<this.items.length-1&&this.navIndex++}for(this.navigating=!0;t.hasClass(this.items[this.navIndex],"disabled")||
t.hasClass(this.items[this.navIndex],"excluded");)if(b?this.navIndex++:this.navIndex--,this.searching)if(this.navIndex>this.tree.lastElementChild.idx){this.navIndex=this.tree.lastElementChild.idx;break}else if(this.navIndex<this.tree.firstElementChild.idx){this.navIndex=this.tree.firstElementChild.idx;break}a=t.rect(this.items[this.navIndex]);b?(0===this.navIndex?this.tree.scrollTop=0:a.top+a.height>this.optsRect.top+this.optsRect.height&&(this.tree.scrollTop+=a.top+a.height-(this.optsRect.top+this.optsRect.height)),
this.navIndex===this.tree.childElementCount-1&&this.requiresPagination&&w.call(this)):0===this.navIndex?this.tree.scrollTop=0:0>a.top-this.optsRect.top&&(this.tree.scrollTop+=a.top-this.optsRect.top);c&&t.removeClass(c,"active");t.addClass(this.items[this.navIndex],"active")}else this.navigating=!1},c=function(a){var c=this,b=document.createDocumentFragment(),d=this.options[a.idx],f=this.data?this.data[a.idx]:d;f=this.customSelected?this.config.renderSelection(f):d.textContent;f=t.createElement("li",
{"class":"selectr-tag",html:f});var n=t.createElement("button",{"class":"selectr-tag-remove",type:"button"});f.appendChild(n);f.idx=a.idx;f.tag=d.value;this.tags.push(f);if(this.config.sortSelected){a=this.tags.slice();var l=function(a,c){a.replace(/(\d+)|(\D+)/g,function(a,b,d){c.push([b||Infinity,d||""])})};a.sort(function(a,b){var d=[],f=[];if(!0===c.config.sortSelected){var n=a.tag;var q=b.tag}else"text"===c.config.sortSelected&&(n=a.textContent,q=b.textContent);l(n,d);for(l(q,f);d.length&&f.length;)if(a=
d.shift(),b=f.shift(),a=a[0]-b[0]||a[1].localeCompare(b[1]))return a;return d.length-f.length});t.each(a,function(a,c){b.appendChild(c)});this.label.textContent=""}else b.appendChild(f);this.config.taggable?this.label.insertBefore(b,this.input.parentNode):this.label.appendChild(b)},f=function(a){var c=!1;t.each(this.tags,function(b,d){d.idx===a.idx&&(c=d)},this);c&&(this.label.removeChild(c),this.tags.splice(this.tags.indexOf(c),1))},w=function(){var a=this.tree;if(a.scrollTop>=a.scrollHeight-a.offsetHeight&&
this.pageIndex<this.pages.length){var c=document.createDocumentFragment();t.each(this.pages[this.pageIndex],function(a,b){h(b,c,this.customOption)},this);a.appendChild(c);this.pageIndex++;this.emit("selectr.paginate",{items:this.items.length,total:this.data.length,page:this.pageIndex,pages:this.pages.length})}},m=function(){if(this.config.searchable||this.config.taggable)this.input.value=null,this.searching=!1,this.config.searchable&&t.removeClass(this.inputContainer,"active"),t.hasClass(this.container,
"notice")&&(t.removeClass(this.container,"notice"),t.addClass(this.container,"open"),this.input.focus()),t.each(this.items,function(a,c){t.removeClass(c,"excluded");this.customOption||(c.textContent+="")},this)},p=function(a,c){c=c||{};if(!a)throw Error("You must supply either a HTMLSelectElement or a CSS3 selector string.");this.el=a;"string"===typeof a&&(this.el=document.querySelector(a));if(null===this.el)throw Error("The element you passed to Selectr can not be found.");if("select"!==this.el.nodeName.toLowerCase())throw Error("The element you passed to Selectr is not a HTMLSelectElement.");
this.render(c)};p.prototype.render=function(a){if(!this.rendered){this.config=t.extend(b,a);this.originalType=this.el.type;this.originalIndex=this.el.tabIndex;this.defaultSelected=[];this.originalOptionCount=this.el.options.length;if(this.config.multiple||this.config.taggable)this.el.multiple=!0;this.disabled=e(this.config,"disabled");this.opened=!1;this.config.taggable&&(this.config.searchable=!1);this.mobileDevice=this.navigating=!1;/Android|webOS|iPhone|iPad|BlackBerry|Windows Phone|Opera Mini|IEMobile|Mobile/i.test(navigator.userAgent)&&
(this.mobileDevice=!0);this.customOption=this.config.hasOwnProperty("renderOption")&&"function"===typeof this.config.renderOption;this.customSelected=this.config.hasOwnProperty("renderSelection")&&"function"===typeof this.config.renderSelection;r.mixin(this);d.call(this);this.bindEvents();this.update();this.optsRect=t.rect(this.tree);this.rendered=!0;this.el.multiple||(this.el.selectedIndex=this.selectedIndex);var c=this;setTimeout(function(){c.emit("selectr.init")},20)}};p.prototype.getSelected=
function(){return this.el.querySelectorAll("option:checked")};p.prototype.getSelectedProperties=function(a){var c=this.getSelected();return[].slice.call(c).map(function(c){return c[a]}).filter(function(a){return null!==a&&void 0!==a})};p.prototype.bindEvents=function(){var c=this;this.events={};this.events.dismiss=x.bind(this);this.events.navigate=a.bind(this);this.events.reset=this.reset.bind(this);if(this.config.nativeDropdown||this.mobileDevice){this.container.addEventListener("touchstart",function(a){a.changedTouches[0].target===
c.el&&c.toggle()});(this.config.nativeDropdown||this.mobileDevice)&&this.container.addEventListener("click",function(a){a.preventDefault();a.stopPropagation();a.target===c.el&&c.toggle()});var b=function(a,c){var b=[];a=a.slice(0);for(var d,f=0;f<c.length;f++)d=a.indexOf(c[f]),-1<d?a.splice(d,1):b.push(c[f]);return[b,a]};this.el.addEventListener("change",function(a){c.el.multiple?(a=c.getSelectedProperties("idx"),a=b(c.selectedIndexes,a),t.each(a[0],function(a,b){c.select(b)},c),t.each(a[1],function(a,
b){c.deselect(b)},c)):-1<c.el.selectedIndex&&c.select(c.el.selectedIndex)})}this.config.nativeDropdown&&this.container.addEventListener("keydown",function(a){"Enter"===a.key&&c.selected===document.activeElement&&(c.toggle(),setTimeout(function(){c.el.focus()},200))});this.selected.addEventListener("click",function(a){c.disabled||c.toggle();a.preventDefault();a.stopPropagation()});this.label.addEventListener("click",function(a){t.hasClass(a.target,"selectr-tag-remove")&&c.deselect(a.target.parentNode.idx)});
this.selectClear&&this.selectClear.addEventListener("click",this.clear.bind(this));this.tree.addEventListener("mousedown",function(a){a.preventDefault()});this.tree.addEventListener("click",function(a){a.preventDefault();a.stopPropagation();(a=t.closest(a.target,function(a){return a&&t.hasClass(a,"selectr-option")}))&&!t.hasClass(a,"disabled")&&(t.hasClass(a,"selected")?(c.el.multiple||!c.el.multiple&&c.config.allowDeselect)&&c.deselect(a.idx):c.select(a.idx),c.opened&&!c.el.multiple&&c.close())});
this.tree.addEventListener("mouseover",function(a){t.hasClass(a.target,"selectr-option")&&!t.hasClass(a.target,"disabled")&&(t.removeClass(c.items[c.navIndex],"active"),t.addClass(a.target,"active"),c.navIndex=[].slice.call(c.items).indexOf(a.target))});this.config.searchable&&(this.input.addEventListener("focus",function(a){c.searching=!0}),this.input.addEventListener("blur",function(a){c.searching=!1}),this.input.addEventListener("keyup",function(a){c.search();c.config.taggable||(this.value.length?
t.addClass(this.parentNode,"active"):t.removeClass(this.parentNode,"active"))}),this.inputClear.addEventListener("click",function(a){c.input.value=null;m.call(c);c.tree.childElementCount||k.call(c)}));this.config.taggable&&this.input.addEventListener("keyup",function(a){c.search();if(c.config.taggable&&this.value.length){var b=this.value.trim();if(13===a.which||t.includes(c.tagSeperators,a.key))t.each(c.tagSeperators,function(a,c){b=b.replace(c,"")}),c.add({value:b,text:b,selected:!0},!0)?(c.close(),
m.call(c)):(this.value="",c.setMessage("That tag is already in use."))}});this.update=t.debounce(function(){c.opened&&c.config.closeOnScroll&&c.close();c.width&&(c.container.style.width=c.width);c.invert()},50);this.requiresPagination&&(this.paginateItems=t.debounce(function(){w.call(this)},50),this.tree.addEventListener("scroll",this.paginateItems.bind(this)));document.addEventListener("click",this.events.dismiss);window.addEventListener("keydown",this.events.navigate);window.addEventListener("resize",
this.update);window.addEventListener("scroll",this.update);this.el.form&&this.el.form.addEventListener("reset",this.events.reset)};p.prototype.setSelected=function(a){this.config.data||this.el.multiple||!this.el.options.length||(0!==this.el.selectedIndex||this.el.options[0].defaultSelected||this.config.defaultSelected||(this.el.selectedIndex=-1),this.selectedIndex=this.el.selectedIndex,-1<this.selectedIndex&&this.select(this.selectedIndex));this.config.multiple&&"select-one"===this.originalType&&
!this.config.data&&this.el.options[0].selected&&!this.el.options[0].defaultSelected&&(this.el.options[0].selected=!1);t.each(this.options,function(a,c){c.selected&&c.defaultSelected&&this.select(c.idx)},this);this.config.selectedValue&&this.setValue(this.config.selectedValue);if(this.config.data){!this.el.multiple&&this.config.defaultSelected&&0>this.el.selectedIndex&&this.select(0);var c=0;t.each(this.config.data,function(a,b){e(b,"children")?t.each(b.children,function(a,b){b.hasOwnProperty("selected")&&
!0===b.selected&&this.select(c);c++},this):(b.hasOwnProperty("selected")&&!0===b.selected&&this.select(c),c++)},this)}};p.prototype.destroy=function(){this.rendered&&(this.emit("selectr.destroy"),"select-one"===this.originalType&&(this.el.multiple=!1),this.config.data&&(this.el.textContent=""),t.removeClass(this.el,"selectr-hidden"),this.el.form&&t.off(this.el.form,"reset",this.events.reset),t.off(document,"click",this.events.dismiss),t.off(document,"keydown",this.events.navigate),t.off(window,"resize",
this.update),t.off(window,"scroll",this.update),this.container.parentNode.replaceChild(this.el,this.container),this.rendered=!1)};p.prototype.change=function(a){var c=this.items[a],b=this.options[a];b.disabled||(b.selected&&t.hasClass(c,"selected")?this.deselect(a):this.select(a),this.opened&&!this.el.multiple&&this.close())};p.prototype.select=function(a){var b=this.items[a],d=[].slice.call(this.el.options),f=this.options[a];if(this.el.multiple){if(t.includes(this.selectedIndexes,a))return!1;if(this.config.maxSelections&&
this.tags.length===this.config.maxSelections)return this.setMessage("A maximum of "+this.config.maxSelections+" items can be selected.",!0),!1;this.selectedValues.push(f.value);this.selectedIndexes.push(a);c.call(this,b)}else{var q=this.data?this.data[a]:f;this.label.textContent=this.customSelected?this.config.renderSelection(q):f.textContent;this.selectedValue=f.value;this.selectedIndex=a;t.each(this.options,function(c,b){var d=this.items[c];c!==a&&(d&&t.removeClass(d,"selected"),b.selected=!1,b.removeAttribute("selected"))},
this)}t.includes(d,f)||this.el.add(f);b.setAttribute("aria-selected",!0);t.addClass(b,"selected");t.addClass(this.container,"has-selected");f.selected=!0;f.setAttribute("selected","");this.emit("selectr.change",f);this.emit("selectr.select",f)};p.prototype.deselect=function(a,c){var b=this.items[a],d=this.options[a];if(this.el.multiple)c=this.selectedIndexes.indexOf(a),this.selectedIndexes.splice(c,1),c=this.selectedValues.indexOf(d.value),this.selectedValues.splice(c,1),f.call(this,b),this.tags.length||
t.removeClass(this.container,"has-selected");else{if(!c&&!this.config.clearable&&!this.config.allowDeselect)return!1;this.label.textContent="";this.selectedValue=null;this.el.selectedIndex=this.selectedIndex=-1;t.removeClass(this.container,"has-selected")}this.items[a].setAttribute("aria-selected",!1);t.removeClass(this.items[a],"selected");d.selected=!1;d.removeAttribute("selected");this.emit("selectr.change",null);this.emit("selectr.deselect",d)};p.prototype.setValue=function(a){var c=Array.isArray(a);
c||(a=a.toString().trim());if(!this.el.multiple&&c)return!1;t.each(this.options,function(b,d){(c&&t.includes(a.toString(),d.value)||d.value===a)&&this.change(d.idx)},this)};p.prototype.getValue=function(a,c){if(this.el.multiple)if(a){if(this.selectedIndexes.length){var b={values:[]};t.each(this.selectedIndexes,function(a,c){c=this.options[c];b.values[a]={value:c.value,text:c.textContent}},this)}}else b=this.selectedValues.slice();else if(a){var d=this.options[this.selectedIndex];b={value:d.value,
text:d.textContent}}else b=this.selectedValue;a&&c&&(b=JSON.stringify(b));return b};p.prototype.add=function(a,c){if(a){this.data=this.data||[];this.items=this.items||[];this.options=this.options||[];if(Array.isArray(a))t.each(a,function(a,b){this.add(b,c)},this);else if("[object Object]"===Object.prototype.toString.call(a)){if(c){var b=!1;t.each(this.options,function(c,d){d.value.toLowerCase()===a.value.toLowerCase()&&(b=!0)});if(b)return!1}var d=t.createElement("option",a);this.data.push(a);this.options.push(d);
d.idx=0<this.options.length?this.options.length-1:0;g.call(this,d);a.selected&&this.select(d.idx);return d}this.setPlaceholder();this.config.pagination&&this.paginate();return!0}};p.prototype.remove=function(a){var c=[];Array.isArray(a)?t.each(a,function(b,d){t.isInt(d)?c.push(this.getOptionByIndex(d)):"string"===typeof a&&c.push(this.getOptionByValue(d))},this):t.isInt(a)?c.push(this.getOptionByIndex(a)):"string"===typeof a&&c.push(this.getOptionByValue(a));if(c.length){var b;t.each(c,function(a,
c){b=c.idx;this.el.remove(c);this.options.splice(b,1);(a=this.items[b].parentNode)&&a.removeChild(this.items[b]);this.items.splice(b,1);t.each(this.options,function(a,c){c.idx=a;this.items[a].idx=a},this)},this);this.setPlaceholder();this.config.pagination&&this.paginate()}};p.prototype.removeAll=function(){this.clear(!0);t.each(this.el.options,function(a,c){this.el.remove(c)},this);t.truncate(this.tree);this.items=[];this.options=[];this.data=[];this.navIndex=0;this.requiresPagination&&(this.requiresPagination=
!1,this.pageIndex=1,this.pages=[]);this.setPlaceholder()};p.prototype.search=function(a){if(!this.navigating){a=a||this.input.value;var c=document.createDocumentFragment();this.removeMessage();t.truncate(this.tree);if(1<a.length)if(t.each(this.options,function(b,d){b=this.items[d.idx];if(t.includes(d.textContent.toLowerCase(),a.toLowerCase())&&!d.disabled){if(h(b,c,this.customOption),t.removeClass(b,"excluded"),!this.customOption){b.textContent="";d=d.textContent;var f=(new RegExp(a,"i")).exec(d);
if(f){var q=f.index;f=f.index+f[0].length;d={before:d.substring(0,q),match:d.substring(q,f),after:d.substring(f)}}else d=null;d&&(b.appendChild(document.createTextNode(d.before)),q=document.createElement("span"),q.className="selectr-match",q.appendChild(document.createTextNode(d.match)),b.appendChild(q),b.appendChild(document.createTextNode(d.after)))}}else t.addClass(b,"excluded")},this),c.childElementCount){var b=c.firstElementChild;t.removeClass(this.items[this.navIndex],"active");this.navIndex=
b.idx;t.addClass(b,"active")}else this.config.taggable||this.setMessage("no results.");else k.call(this);this.tree.appendChild(c)}};p.prototype.toggle=function(){this.disabled||(this.opened?this.close():this.open())};p.prototype.open=function(){var a=this;if(!this.options.length)return!1;this.opened||this.emit("selectr.open");this.opened=!0;this.mobileDevice||this.config.nativeDropdown?(t.addClass(this.container,"native-open"),this.config.data&&t.each(this.options,function(a,c){this.el.add(c)},this)):
(t.addClass(this.container,"open"),k.call(this),this.invert(),this.tree.scrollTop=0,t.removeClass(this.container,"notice"),this.selected.setAttribute("aria-expanded",!0),this.tree.setAttribute("aria-hidden",!1),this.tree.setAttribute("aria-expanded",!0),this.config.searchable&&!this.config.taggable&&setTimeout(function(){a.input.focus();a.input.tabIndex=0},10))};p.prototype.close=function(){this.opened&&this.emit("selectr.close");this.opened=!1;if(this.mobileDevice||this.config.nativeDropdown)t.removeClass(this.container,
"native-open");else{var a=t.hasClass(this.container,"notice");this.config.searchable&&!a&&(this.input.blur(),this.input.tabIndex=-1,this.searching=!1);a&&(t.removeClass(this.container,"notice"),this.notice.textContent="");t.removeClass(this.container,"open");t.removeClass(this.container,"native-open");this.selected.setAttribute("aria-expanded",!1);this.tree.setAttribute("aria-hidden",!0);this.tree.setAttribute("aria-expanded",!1);t.truncate(this.tree);m.call(this)}};p.prototype.enable=function(){this.disabled=
!1;this.el.disabled=!1;this.selected.tabIndex=this.originalIndex;this.el.multiple&&t.each(this.tags,function(a,c){c.lastElementChild.tabIndex=0});t.removeClass(this.container,"selectr-disabled")};p.prototype.disable=function(a){a||(this.el.disabled=!0);this.selected.tabIndex=-1;this.el.multiple&&t.each(this.tags,function(a,c){c.lastElementChild.tabIndex=-1});this.disabled=!0;t.addClass(this.container,"selectr-disabled")};p.prototype.reset=function(){this.disabled||(this.clear(),this.setSelected(!0),
t.each(this.defaultSelected,function(a,c){this.select(c)},this),this.emit("selectr.reset"))};p.prototype.clear=function(a){this.el.multiple?this.selectedIndexes.length&&(a=this.selectedIndexes.slice(),t.each(a,function(a,c){this.deselect(c)},this)):-1<this.selectedIndex&&this.deselect(this.selectedIndex,a);this.emit("selectr.clear")};p.prototype.serialise=function(a){var c=[];t.each(this.options,function(a,b){var d={value:b.value,text:b.textContent};b.selected&&(d.selected=!0);b.disabled&&(d.disabled=
!0);c[a]=d});return a?JSON.stringify(c):c};p.prototype.serialize=function(a){return this.serialise(a)};p.prototype.setPlaceholder=function(a){a=a||this.config.placeholder||this.el.getAttribute("placeholder");this.options.length||(a="No options available");this.placeEl.textContent=a};p.prototype.paginate=function(){if(this.items.length){var a=this;return this.pages=this.items.map(function(c,b){return 0===b%a.config.pagination?a.items.slice(b,b+a.config.pagination):null}).filter(function(a){return a})}};
p.prototype.setMessage=function(a,c){c&&this.close();t.addClass(this.container,"notice");this.notice.textContent=a};p.prototype.removeMessage=function(){t.removeClass(this.container,"notice");this.notice.textContent=""};p.prototype.invert=function(){var a=t.rect(this.selected);a.top+a.height+this.tree.parentNode.offsetHeight>window.innerHeight?(t.addClass(this.container,"inverted"),this.isInverted=!0):(t.removeClass(this.container,"inverted"),this.isInverted=!1);this.optsRect=t.rect(this.tree)};p.prototype.getOptionByIndex=
function(a){return this.options[a]};p.prototype.getOptionByValue=function(a){for(var c=!1,b=0,d=this.options.length;b<d;b++)if(this.options[b].value.trim()===a.toString().trim()){c=this.options[b];break}return c};y.exports=p},4188:function(y,e,h){h.d(e,{qD:function(){return b},EX:function(){return r},WF:function(){return t},oW:function(){return k}});var b=document.body,r=10485760,t=2E4,k=2147483648},2602:function(y,e,h){function b(b,e,x){function g(){if(p&&p.parentNode){p.parentNode.removeChild(p);
for(var a in f)if(Object.prototype.hasOwnProperty.call(f,a)){var d=f[a];d&&(0,r.removeEventListener)(c,a,d);delete f[a]}"function"===typeof x&&x(b)}}function d(a){a=a.target;a!==p&&!(0,r.isChildOf)(a,p)&&g()}var a=3<arguments.length&&void 0!==arguments[3]?arguments[3]:!1,c="function"===typeof b.getRootNode?b.getRootNode():window,f={},w=b.getBoundingClientRect(),m=e.getBoundingClientRect(),p=document.createElement("div");p.className="jsoneditor-anchor";p.style.position="absolute";p.style.left=w.left-
m.left+"px";p.style.top=w.top-m.top+"px";p.style.width=w.width-2+"px";p.style.height=w.height-2+"px";p.style.boxSizing="border-box";e.appendChild(p);f.mousedown=(0,r.addEventListener)(c,"mousedown",d);f.mousewheel=(0,r.addEventListener)(c,"mousewheel",d);if(a){var l=null;p.onmouseover=function(){clearTimeout(l);l=null};p.onmouseout=function(){l||(l=setTimeout(g,200))}}p.destroy=g;return p}h.d(e,{w:function(){return b}});var r=h(9791)},7923:function(y){y.exports="data:application/javascript;base64,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"},
7907:function(y,e,h){function b(c){if(c){var b=k.find(function(a){return a===c});b?a=b:console.error("Language not found")}}function r(a){if(a){var c=function(c){k.find(function(a){return a===c})||k.push(c);x[c]=Object.assign({},x[g],x[c],a[c])},b;for(b in a)c(b)}}function t(c,b,d){d||(d=a);c=x[d][c]||x[g][c]||c;if(b)for(var f in b)c=c.replace("${"+f+"}",b[f]);return c}h.d(e,{m0:function(){return b},cC:function(){return r},Iu:function(){return t}});y=h(4987);h.n(y);var k="en pt-BR zh-CN tr ja fr-FR de ru".split(" "),
x={en:{array:"Array",auto:"Auto",appendText:"Append",appendTitle:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",appendSubmenuTitle:"Select the type of the field to be appended",appendTitleAuto:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascending",ascendingTitle:"Sort the childs of this ${type} in ascending order",actionsMenu:"Click to open the actions menu (Ctrl+M)",cannotParseFieldError:"Cannot parse field into JSON",cannotParseValueError:"Cannot parse value into JSON",
collapseAll:"Collapse all fields",compactTitle:"Compact JSON data, remove all whitespaces (Ctrl+Shift+I)",descending:"Descending",descendingTitle:"Sort the childs of this ${type} in descending order",drag:"Drag to move this field (Alt+Shift+Arrows)",duplicateKey:"duplicate key",duplicateText:"Duplicate",duplicateTitle:"Duplicate selected fields (Ctrl+D)",duplicateField:"Duplicate this field (Ctrl+D)",duplicateFieldError:"Duplicate field name",empty:"empty",expandAll:"Expand all fields",expandTitle:"Click to expand/collapse this field (Ctrl+E). \nCtrl+Click to expand/collapse including all childs.",
formatTitle:"Format JSON data, with proper indentation and line feeds (Ctrl+I)",insert:"Insert",insertTitle:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",insertSub:"Select the type of the field to be inserted",object:"Object",ok:"Ok",redo:"Redo (Ctrl+Shift+Z)",removeText:"Remove",removeTitle:"Remove selected fields (Ctrl+Del)",removeField:"Remove this field (Ctrl+Del)",repairTitle:"Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",
searchTitle:"Search fields and values",searchNextResultTitle:"Next result (Enter)",searchPreviousResultTitle:"Previous result (Shift + Enter)",selectNode:"Select a node...",showAll:"show all",showMore:"show more",showMoreStatus:"displaying ${visibleChilds} of ${totalChilds} items.",sort:"Sort",sortTitle:"Sort the childs of this ${type}",sortTitleShort:"Sort contents",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",
sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"String",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",extract:"Extract",extractTitle:"Extract this ${type}",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",
transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Type",typeTitle:"Change the type of this field",openUrl:"Ctrl+Click or Ctrl+Enter to open url in new window",undo:"Undo last action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Field type "object". An object contains an unordered set of key/value pairs.',
arrayType:'Field type "array". An array contains an ordered collection of values.',stringType:'Field type "string". Field type is not determined from the value, but always returned as string.',modeEditorTitle:"Switch Editor Mode",modeCodeText:"Code",modeCodeTitle:"Switch to code highlighter",modeFormText:"Form",modeFormTitle:"Switch to form editor",modeTextText:"Text",modeTextTitle:"Switch to plain text editor",modeTreeText:"Tree",modeTreeTitle:"Switch to tree editor",modeViewText:"View",modeViewTitle:"Switch to tree view",
modePreviewText:"Preview",modePreviewTitle:"Switch to preview mode",examples:"Examples","default":"Default",containsInvalidProperties:"Contains invalid properties",containsInvalidItems:"Contains invalid items"},"zh-CN":{array:"\u6570\u7ec4",auto:"\u81ea\u52a8",appendText:"\u8ffd\u52a0",appendTitle:"\u5728\u6b64\u5b57\u6bb5\u540e\u8ffd\u52a0\u4e00\u4e2a\u7c7b\u578b\u4e3a\u201cauto\u201d\u7684\u65b0\u5b57\u6bb5 (Ctrl+Shift+Ins)",appendSubmenuTitle:"\u9009\u62e9\u8981\u8ffd\u52a0\u7684\u5b57\u6bb5\u7c7b\u578b",
appendTitleAuto:"\u8ffd\u52a0\u7c7b\u578b\u4e3a\u201cauto\u201d\u7684\u65b0\u5b57\u6bb5 (Ctrl+Shift+Ins)",ascending:"\u5347\u5e8f",ascendingTitle:"\u5347\u5e8f\u6392\u5217${type}\u7684\u5b50\u8282\u70b9",actionsMenu:"\u70b9\u51fb\u6253\u5f00\u52a8\u4f5c\u83dc\u5355(Ctrl+M)",cannotParseFieldError:"\u65e0\u6cd5\u5c06\u5b57\u6bb5\u89e3\u6790\u4e3aJSON",cannotParseValueError:"\u65e0\u6cd5\u5c06\u503c\u89e3\u6790\u4e3aJSON",collapseAll:"\u7f29\u8fdb\u6240\u6709\u5b57\u6bb5",compactTitle:"\u538b\u7f29JSON\u6570\u636e\uff0c\u5220\u9664\u6240\u6709\u7a7a\u683c (Ctrl+Shift+I)",
descending:"\u964d\u5e8f",descendingTitle:"\u964d\u5e8f\u6392\u5217${type}\u7684\u5b50\u8282\u70b9",drag:"\u62d6\u62fd\u79fb\u52a8\u8be5\u8282\u70b9(Alt+Shift+Arrows)",duplicateKey:"\u91cd\u590d\u952e",duplicateText:"\u590d\u5236",duplicateTitle:"\u590d\u5236\u9009\u4e2d\u5b57\u6bb5(Ctrl+D)",duplicateField:"\u590d\u5236\u8be5\u5b57\u6bb5(Ctrl+D)",duplicateFieldError:"\u91cd\u590d\u7684\u5b57\u6bb5\u540d\u79f0",empty:"\u6e05\u7a7a",expandAll:"\u5c55\u5f00\u6240\u6709\u5b57\u6bb5",expandTitle:"\u70b9\u51fb \u5c55\u5f00/\u6536\u7f29 \u8be5\u5b57\u6bb5(Ctrl+E). \nCtrl+Click \u5c55\u5f00/\u6536\u7f29 \u5305\u542b\u6240\u6709\u5b50\u8282\u70b9.",
formatTitle:"\u4f7f\u7528\u9002\u5f53\u7684\u7f29\u8fdb\u548c\u6362\u884c\u7b26\u683c\u5f0f\u5316JSON\u6570\u636e (Ctrl+I)",insert:"\u63d2\u5165",insertTitle:"\u5728\u6b64\u5b57\u6bb5\u524d\u63d2\u5165\u7c7b\u578b\u4e3a\u201cauto\u201d\u7684\u65b0\u5b57\u6bb5 (Ctrl+Ins)",insertSub:"\u9009\u62e9\u8981\u63d2\u5165\u7684\u5b57\u6bb5\u7c7b\u578b",object:"\u5bf9\u8c61",ok:"Ok",redo:"\u91cd\u505a (Ctrl+Shift+Z)",removeText:"\u79fb\u9664",removeTitle:"\u79fb\u9664\u9009\u4e2d\u5b57\u6bb5 (Ctrl+Del)",removeField:"\u79fb\u9664\u8be5\u5b57\u6bb5 (Ctrl+Del)",
repairTitle:"\u4fee\u590dJSON\uff1a\u4fee\u590d\u5f15\u53f7\u548c\u8f6c\u4e49\u7b26\uff0c\u5220\u9664\u6ce8\u91ca\u548cJSONP\u8868\u793a\u6cd5\uff0c\u5c06JavaScript\u5bf9\u8c61\u8f6c\u6362\u4e3aJSON\u3002",selectNode:"\u9009\u62e9\u4e00\u4e2a\u8282\u70b9...",showAll:"\u5c55\u793a\u5168\u90e8",showMore:"\u5c55\u793a\u66f4\u591a",showMoreStatus:"\u663e\u793a${totalChilds}\u7684${visibleChilds}\u9879\u76ee.",sort:"\u6392\u5e8f",sortTitle:"\u6392\u5e8f${type}\u7684\u5b50\u8282\u70b9",sortTitleShort:"\u5185\u5bb9\u6392\u5e8f",
sortFieldLabel:"\u5b57\u6bb5\uff1a",sortDirectionLabel:"\u65b9\u5411\uff1a",sortFieldTitle:"\u9009\u62e9\u7528\u4e8e\u5bf9\u6570\u7ec4\u6216\u5bf9\u8c61\u6392\u5e8f\u7684\u5d4c\u5957\u5b57\u6bb5",sortAscending:"\u5347\u5e8f\u6392\u5e8f",sortAscendingTitle:"\u6309\u7167\u8be5\u5b57\u6bb5\u5347\u5e8f\u6392\u5e8f",sortDescending:"\u964d\u5e8f\u6392\u5e8f",sortDescendingTitle:"\u6309\u7167\u8be5\u5b57\u6bb5\u964d\u5e8f\u6392\u5e8f",string:"\u5b57\u7b26\u4e32",transform:"\u53d8\u6362",transformTitle:"\u7b5b\u9009\uff0c\u6392\u5e8f\uff0c\u6216\u8005\u8f6c\u6362${type}\u7684\u5b50\u8282\u70b9",
transformTitleShort:"\u7b5b\u9009\uff0c\u6392\u5e8f\uff0c\u6216\u8005\u8f6c\u6362\u5185\u5bb9",extract:"\u63d0\u53d6",extractTitle:"\u63d0\u53d6\u8fd9\u4e2a ${type}",transformQueryTitle:"\u8f93\u5165JMESPath\u67e5\u8be2",transformWizardLabel:"\u5411\u5bfc",transformWizardFilter:"\u7b5b\u9009",transformWizardSortBy:"\u6392\u5e8f",transformWizardSelectFields:"\u9009\u62e9\u5b57\u6bb5",transformQueryLabel:"\u67e5\u8be2",transformPreviewLabel:"\u9884\u89c8",type:"\u7c7b\u578b",typeTitle:"\u66f4\u6539\u5b57\u6bb5\u7c7b\u578b",
openUrl:"Ctrl+Click \u6216\u8005 Ctrl+Enter \u5728\u65b0\u7a97\u53e3\u6253\u5f00\u94fe\u63a5",undo:"\u64a4\u9500\u4e0a\u6b21\u52a8\u4f5c (Ctrl+Z)",validationCannotMove:"\u65e0\u6cd5\u5c06\u5b57\u6bb5\u79fb\u5165\u5176\u5b50\u8282\u70b9",autoType:'\u5b57\u6bb5\u7c7b\u578b "auto". \u5b57\u6bb5\u7c7b\u578b\u7531\u503c\u81ea\u52a8\u786e\u5b9a \u53ef\u4ee5\u4e3a string\uff0cnumber\uff0cboolean\uff0c\u6216\u8005 null.',objectType:'\u5b57\u6bb5\u7c7b\u578b "object". \u5bf9\u8c61\u5305\u542b\u4e00\u7ec4\u65e0\u5e8f\u7684\u952e/\u503c\u5bf9.',
arrayType:'\u5b57\u6bb5\u7c7b\u578b "array". \u6570\u7ec4\u5305\u542b\u503c\u7684\u6709\u5e8f\u96c6\u5408.',stringType:'\u5b57\u6bb5\u7c7b\u578b "string". \u5b57\u6bb5\u7c7b\u578b\u7531\u503c\u81ea\u52a8\u786e\u5b9a\uff0c\u4f46\u59cb\u7ec8\u4f5c\u4e3a\u5b57\u7b26\u4e32\u8fd4\u56de.',modeCodeText:"\u4ee3\u7801",modeCodeTitle:"\u5207\u6362\u81f3\u4ee3\u7801\u9ad8\u4eae",modeFormText:"\u8868\u5355",modeFormTitle:"\u5207\u6362\u81f3\u8868\u5355\u7f16\u8f91",modeTextText:"\u6587\u672c",modeTextTitle:"\u5207\u6362\u81f3\u6587\u672c\u7f16\u8f91",
modeTreeText:"\u6811",modeTreeTitle:"\u5207\u6362\u81f3\u6811\u7f16\u8f91",modeViewText:"\u89c6\u56fe",modeViewTitle:"\u5207\u6362\u81f3\u6811\u89c6\u56fe",modePreviewText:"\u9884\u89c8",modePreviewTitle:"\u5207\u6362\u81f3\u9884\u89c8\u6a21\u5f0f",examples:"\u4f8b\u5b50","default":"\u7f3a\u7701",containsInvalidProperties:"\u5305\u542b\u65e0\u6548\u7684\u5c5e\u6027",containsInvalidItems:"\u5305\u542b\u65e0\u6548\u9879\u76ee"},"pt-BR":{array:"Lista",auto:"Automatico",appendText:"Adicionar",appendTitle:"Adicionar novo campo com tipo 'auto' depois deste campo (Ctrl+Shift+Ins)",
appendSubmenuTitle:"Selecione o tipo do campo a ser adicionado",appendTitleAuto:"Adicionar novo campo com tipo 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendente",ascendingTitle:"Organizar filhor do tipo ${type} em crescente",actionsMenu:"Clique para abrir o menu de a\u00e7\u00f5es (Ctrl+M)",cannotParseFieldError:"N\u00e3o \u00e9 poss\u00edvel analisar o campo no JSON",cannotParseValueError:"N\u00e3o \u00e9 poss\u00edvel analisar o valor em JSON",collapseAll:"Fechar todos campos",compactTitle:"Dados JSON compactos, remova todos os espa\u00e7os em branco (Ctrl+Shift+I)",
descending:"Descendente",descendingTitle:"Organizar o filhos do tipo ${type} em decrescente",duplicateKey:"chave duplicada",drag:"Arraste para mover este campo (Alt+Shift+Arrows)",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos selecionados (Ctrl+D)",duplicateField:"Duplicar este campo (Ctrl+D)",duplicateFieldError:"Nome do campo duplicado",empty:"vazio",expandAll:"Expandir todos campos",expandTitle:"Clique para expandir/encolher este campo (Ctrl+E). \nCtrl+Click para expandir/encolher incluindo todos os filhos.",
formatTitle:"Formate dados JSON, com recuo e feeds de linha adequados (Ctrl+I)",insert:"Inserir",insertTitle:"Inserir um novo campo do tipo 'auto' antes deste campo (Ctrl+Ins)",insertSub:"Selecionar o tipo de campo a ser inserido",object:"Objeto",ok:"Ok",redo:"Refazer (Ctrl+Shift+Z)",removeText:"Remover",removeTitle:"Remover campos selecionados (Ctrl+Del)",removeField:"Remover este campo (Ctrl+Del)",repairTitle:"Repare JSON: corrija aspas e caracteres de escape, remova coment\u00e1rios e nota\u00e7\u00e3o JSONP, transforme objetos JavaScript em JSON.",
selectNode:"Selecione um n\u00f3dulo...",showAll:"mostrar todos",showMore:"mostrar mais",showMoreStatus:"exibindo ${visibleChilds} de ${totalChilds} itens.",sort:"Organizar",sortTitle:"Organizar os filhos deste ${type}",sortTitleShort:"Organizar os filhos",sortFieldLabel:"Campo:",sortDirectionLabel:"Dire\u00e7\u00e3o:",sortFieldTitle:"Selecione um campo filho pelo qual ordenar o array ou objeto",sortAscending:"Ascendente",sortAscendingTitle:"Ordenar o campo selecionado por ordem ascendente",sortDescending:"Descendente",
sortDescendingTitle:"Ordenar o campo selecionado por ordem descendente",string:"Texto",transform:"Transformar",transformTitle:"Filtrar, ordenar ou transformar os filhos deste ${type}",transformTitleShort:"Filtrar, ordenar ou transformar conte\u00fados",transformQueryTitle:"Insira uma express\u00e3o JMESPath",transformWizardLabel:"Assistente",transformWizardFilter:"Filtro",transformWizardSortBy:"Ordenar por",transformWizardSelectFields:"Selecionar campos",transformQueryLabel:"Express\u00e3o",transformPreviewLabel:"Visualizar",
type:"Tipo",typeTitle:"Mudar o tipo deste campo",openUrl:"Ctrl+Click ou Ctrl+Enter para abrir link em nova janela",undo:"Desfazer \u00faltimo a\u00e7\u00e3o (Ctrl+Z)",validationCannotMove:"N\u00e3o pode mover um campo como filho dele mesmo",autoType:'Campo do tipo "auto". O tipo do campo \u00e9 determinao automaticamente a partir do seu valor e pode ser texto, n\u00famero, verdade/falso ou nulo.',objectType:'Campo do tipo "objeto". Um objeto cont\u00e9m uma lista de pares com chave e valor.',arrayType:'Campo do tipo "lista". Uma lista contem uma cole\u00e7\u00e3o de valores ordenados.',
stringType:'Campo do tipo "string". Campo do tipo nao \u00e9 determinado atrav\u00e9s do seu valor, mas sempre retornara um texto.',examples:"Exemplos","default":"Revelia",containsInvalidProperties:"Cont\u00e9m propriedades inv\u00e1lidas",containsInvalidItems:"Cont\u00e9m itens inv\u00e1lidos"},tr:{array:"Dizin",auto:"Otomatik",appendText:"Ekle",appendTitle:"Bu alan\u0131n alt\u0131na 'otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",appendSubmenuTitle:"Eklenecek alan\u0131n tipini se\u00e7",
appendTitleAuto:"'Otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",ascending:"Artan",ascendingTitle:"${type}'\u0131n alt tiplerini artan d\u00fczende s\u0131rala",actionsMenu:"Aksiyon men\u00fcs\u00fcn\u00fc a\u00e7mak i\u00e7in t\u0131klay\u0131n (Ctrl+M)",collapseAll:"T\u00fcm alanlar\u0131 kapat",descending:"Azalan",descendingTitle:"${type}'\u0131n alt tiplerini azalan d\u00fczende s\u0131rala",drag:"Bu alan\u0131 ta\u015f\u0131mak i\u00e7in s\u00fcr\u00fckleyin (Alt+Shift+Arrows)",duplicateKey:"Var olan anahtar",
duplicateText:"A\u015fa\u011f\u0131ya kopyala",duplicateTitle:"Se\u00e7ili alanlardan bir daha olu\u015ftur (Ctrl+D)",duplicateField:"Bu alandan bir daha olu\u015ftur (Ctrl+D)",duplicateFieldError:"Duplicate field name",cannotParseFieldError:"Alan JSON'a ayr\u0131\u015ft\u0131r\u0131lam\u0131yor",cannotParseValueError:"JSON'a de\u011fer ayr\u0131\u015ft\u0131r\u0131lam\u0131yor",empty:"bo\u015f",expandAll:"T\u00fcm alanlar\u0131 a\u00e7",expandTitle:"Bu alan\u0131 a\u00e7mak/kapatmak i\u00e7in t\u0131kla (Ctrl+E). \nAlt alanlarda dahil t\u00fcm alanlar\u0131 a\u00e7mak i\u00e7in Ctrl+Click ",
insert:"Ekle",insertTitle:"Bu alan\u0131n \u00fcst\u00fcne 'otomatik' tipinde yeni bir alan ekle (Ctrl+Ins)",insertSub:"Araya eklenecek alan\u0131n tipini se\u00e7",object:"Nesne",ok:"Tamam",redo:"Yeniden yap (Ctrl+Shift+Z)",removeText:"Kald\u0131r",removeTitle:"Se\u00e7ilen alanlar\u0131 kald\u0131r (Ctrl+Del)",removeField:"Bu alan\u0131 kald\u0131r (Ctrl+Del)",selectNode:"Bir nesne se\u00e7...",showAll:"t\u00fcm\u00fcn\u00fc g\u00f6ster",showMore:"daha fazla g\u00f6ster",showMoreStatus:"${totalChilds} alan\u0131n ${visibleChilds} alt alanlar\u0131 g\u00f6steriliyor",
sort:"S\u0131rala",sortTitle:"${type}'\u0131n alt alanlar\u0131n\u0131 s\u0131rala",sortTitleShort:"\u0130\u00e7erikleri s\u0131rala",sortFieldLabel:"Alan:",sortDirectionLabel:"Y\u00f6n:",sortFieldTitle:"Diziyi veya nesneyi s\u0131ralamak i\u00e7in i\u00e7 i\u00e7e ge\u00e7mi\u015f alan\u0131 se\u00e7in",sortAscending:"Artan",sortAscendingTitle:"Se\u00e7ili alan\u0131 artan d\u00fczende s\u0131rala",sortDescending:"Azalan",sortDescendingTitle:"Se\u00e7ili alan\u0131 azalan d\u00fczende s\u0131rala",
string:"Karakter Dizisi",transform:"D\u00f6n\u00fc\u015ft\u00fcr",transformTitle:"${type}'\u0131n alt alanlar\u0131n\u0131 filtrele, s\u0131rala veya d\u00f6n\u00fc\u015ft\u00fcr",transformTitleShort:"\u0130\u00e7erikleri filterele, s\u0131rala veya d\u00f6n\u00fc\u015ft\u00fcr",transformQueryTitle:"JMESPath sorgusu gir",transformWizardLabel:"Sihirbaz",transformWizardFilter:"Filtre",transformWizardSortBy:"S\u0131rala",transformWizardSelectFields:"Alanlar\u0131 se\u00e7",transformQueryLabel:"Sorgu",
transformPreviewLabel:"\u00d6nizleme",type:"Tip",typeTitle:"Bu alan\u0131n tipini de\u011fi\u015ftir",openUrl:"URL'i yeni bir pencerede a\u00e7mak i\u00e7in Ctrl+Click veya Ctrl+Enter",undo:"Son de\u011fi\u015fikli\u011fi geri al (Ctrl+Z)",validationCannotMove:"Alt alan olarak ta\u015f\u0131nam\u0131yor",autoType:'Alan tipi "otomatik". Alan t\u00fcr\u00fc otomatik olarak de\u011ferden belirlenirve bir dize, say\u0131, boolean veya null olabilir.',objectType:'Alan tipi "nesne". Bir nesne, s\u0131ralanmam\u0131\u015f bir anahtar / de\u011fer \u00e7ifti k\u00fcmesi i\u00e7erir.',
arrayType:'Alan tipi "dizi". Bir dizi, d\u00fczenli de\u011ferler koleksiyonu i\u00e7erir.',stringType:'Alan tipi "karakter dizisi". Alan t\u00fcr\u00fc de\u011ferden belirlenmez,ancak her zaman karakter dizisi olarak d\u00f6nd\u00fcr\u00fcl\u00fcr.',modeCodeText:"Kod",modeCodeTitle:"Kod vurgulay\u0131c\u0131ya ge\u00e7",modeFormText:"Form",modeFormTitle:"Form d\u00fczenleyiciye ge\u00e7",modeTextText:"Metin",modeTextTitle:"D\u00fcz metin d\u00fczenleyiciye ge\u00e7",modeTreeText:"A\u011fa\u00e7",
modeTreeTitle:"A\u011fa\u00e7 d\u00fczenleyiciye ge\u00e7",modeViewText:"G\u00f6r\u00fcn\u00fcm",modeViewTitle:"A\u011fa\u00e7 g\u00f6r\u00fcn\u00fcm\u00fcne ge\u00e7",examples:"\u00d6rnekler","default":"Varsay\u0131lan",containsInvalidProperties:"Ge\u00e7ersiz \u00f6zellikler i\u00e7eriyor",containsInvalidItems:"Ge\u00e7ersiz \u00f6\u011feler i\u00e7eriyor"},ja:{array:"\u914d\u5217",auto:"\u30aa\u30fc\u30c8",appendText:"\u8ffd\u52a0",appendTitle:'\u6b21\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306b"\u30aa\u30fc\u30c8"\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u8ffd\u52a0 (Ctrl+Shift+Ins)',
appendSubmenuTitle:"\u8ffd\u52a0\u3059\u308b\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u578b\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044",appendTitleAuto:'"\u30aa\u30fc\u30c8"\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u8ffd\u52a0 (Ctrl+Shift+Ins)',ascending:"\u6607\u9806",ascendingTitle:"${type}\u306e\u5b50\u8981\u7d20\u3092\u6607\u9806\u306b\u4e26\u3079\u66ff\u3048",actionsMenu:"\u30af\u30ea\u30c3\u30af\u3057\u3066\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30cb\u30e5\u30fc\u3092\u958b\u304f (Ctrl+M)",
collapseAll:"\u3059\u3079\u3066\u3092\u6298\u308a\u305f\u305f\u3080",descending:"\u964d\u9806",descendingTitle:"${type}\u306e\u5b50\u8981\u7d20\u3092\u964d\u9806\u306b\u4e26\u3079\u66ff\u3048",drag:"\u30c9\u30e9\u30c3\u30b0\u3057\u3066\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u79fb\u52d5 (Alt+Shift+Arrows)",duplicateKey:"\u8907\u88fd\u30ad\u30fc",duplicateText:"\u8907\u88fd",duplicateTitle:"\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u8907\u88fd (Ctrl+D)",duplicateField:"\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u8907\u88fd (Ctrl+D)",
duplicateFieldError:"\u30d5\u30a3\u30fc\u30eb\u30c9\u540d\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059",cannotParseFieldError:"JSON\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u89e3\u6790\u3067\u304d\u307e\u305b\u3093",cannotParseValueError:"JSON\u306e\u5024\u3092\u89e3\u6790\u3067\u304d\u307e\u305b\u3093",empty:"\u7a7a",expandAll:"\u3059\u3079\u3066\u3092\u5c55\u958b",expandTitle:"\u30af\u30ea\u30c3\u30af\u3057\u3066\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u5c55\u958b/\u6298\u308a\u305f\u305f\u3080 (Ctrl+E). \nCtrl+Click \u3067\u3059\u3079\u3066\u306e\u5b50\u8981\u7d20\u3092\u5c55\u958b/\u6298\u308a\u305f\u305f\u3080",
insert:"\u633f\u5165",insertTitle:"\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u524d\u306b\u65b0\u3057\u3044\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u633f\u5165 (Ctrl+Ins)",insertSub:"\u633f\u5165\u3059\u308b\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u578b\u3092\u9078\u629e",object:"\u30aa\u30d6\u30b8\u30a7\u30af\u30c8",ok:"\u5b9f\u884c",redo:"\u3084\u308a\u76f4\u3059 (Ctrl+Shift+Z)",removeText:"\u524a\u9664",removeTitle:"\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u524a\u9664 (Ctrl+Del)",
removeField:"\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u524a\u9664 (Ctrl+Del)",selectNode:"\u30ce\u30fc\u30c9\u3092\u9078\u629e...",showAll:"\u3059\u3079\u3066\u3092\u8868\u793a",showMore:"\u3082\u3063\u3068\u898b\u308b",showMoreStatus:"${totalChilds}\u500b\u306e\u30a2\u30a4\u30c6\u30e0\u306e\u3046\u3061 ${visibleChilds}\u500b\u3092\u8868\u793a\u3057\u3066\u3044\u307e\u3059\u3002",sort:"\u4e26\u3079\u66ff\u3048",sortTitle:"${type}\u306e\u5b50\u8981\u7d20\u3092\u4e26\u3079\u66ff\u3048",
sortTitleShort:"\u4e26\u3079\u66ff\u3048",sortFieldLabel:"\u30d5\u30a3\u30fc\u30eb\u30c9:",sortDirectionLabel:"\u9806\u5e8f:",sortFieldTitle:"\u914d\u5217\u307e\u305f\u306f\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u4e26\u3073\u66ff\u3048\u308b\u305f\u3081\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u9078\u629e",sortAscending:"\u6607\u9806",sortAscendingTitle:"\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u6607\u9806\u306b\u4e26\u3073\u66ff\u3048",sortDescending:"\u964d\u9806",sortDescendingTitle:"\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u964d\u9806\u306b\u4e26\u3073\u66ff\u3048",
string:"\u6587\u5b57\u5217",transform:"\u5909\u63db",transformTitle:"${type}\u306e\u5b50\u8981\u7d20\u3092\u30d5\u30a3\u30eb\u30bf\u30fc\u30fb\u4e26\u3073\u66ff\u3048\u30fb\u5909\u63db\u3059\u308b",transformTitleShort:"\u5185\u5bb9\u3092\u30d5\u30a3\u30eb\u30bf\u30fc\u30fb\u4e26\u3073\u66ff\u3048\u30fb\u5909\u63db\u3059\u308b",extract:"\u62bd\u51fa",extractTitle:"${type}\u3092\u62bd\u51fa",transformQueryTitle:"JMESPath\u30af\u30a8\u30ea\u3092\u5165\u529b",transformWizardLabel:"\u30a6\u30a3\u30b6\u30fc\u30c9",
transformWizardFilter:"\u30d5\u30a3\u30eb\u30bf\u30fc",transformWizardSortBy:"\u4e26\u3073\u66ff\u3048",transformWizardSelectFields:"\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u9078\u629e",transformQueryLabel:"\u30af\u30a8\u30ea",transformPreviewLabel:"\u30d7\u30ec\u30d3\u30e5\u30fc",type:"\u578b",typeTitle:"\u9078\u629e\u4e2d\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u578b\u3092\u5909\u66f4",openUrl:"Ctrl+Click \u307e\u305f\u306f Ctrl+Enter \u3067 \u65b0\u898f\u30a6\u30a3\u30f3\u30c9\u30a6\u3067URL\u3092\u958b\u304f",
undo:"\u5143\u306b\u623b\u3059 (Ctrl+Z)",validationCannotMove:"\u5b50\u8981\u7d20\u306b\u79fb\u52d5\u3067\u304d\u307e\u305b\u3093 ",autoType:"\u30aa\u30fc\u30c8\uff1a \u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u578b\u306f\u5024\u304b\u3089\u81ea\u52d5\u7684\u306b\u6c7a\u5b9a\u3055\u308c\u307e\u3059\u3002 (\u6587\u5b57\u5217\u30fb\u6570\u5024\u30fb\u30d6\u30fc\u30eb\u30fbnull)",objectType:"\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\uff1a \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u9806\u5e8f\u304c\u6c7a\u307e\u3063\u3066\u3044\u306a\u3044\u30ad\u30fc\u3068\u5024\u306e\u30da\u30a2\u7d44\u307f\u5408\u308f\u305b\u3067\u3059\u3002",
arrayType:"\u914d\u5217\uff1a \u914d\u5217\u306f\u9806\u5e8f\u304c\u6c7a\u307e\u3063\u3066\u3044\u308b\u5024\u306e\u96c6\u5408\u4f53\u3067\u3059\u3002",stringType:"\u6587\u5b57\u5217\uff1a \u30d5\u30a3\u30fc\u30eb\u30c9\u578b\u306f\u5024\u304b\u3089\u6c7a\u5b9a\u3055\u308c\u307e\u305b\u3093\u304c\u3001\u5e38\u306b\u6587\u5b57\u5217\u3068\u3057\u3066\u8fd4\u3055\u308c\u307e\u3059\u3002",modeCodeText:"\u30b3\u30fc\u30c9\u30e2\u30fc\u30c9",modeCodeTitle:"\u30cf\u30a4\u30e9\u30a4\u30c8\u30e2\u30fc\u30c9\u306b\u5207\u308a\u66ff\u3048",
modeFormText:"\u30d5\u30a9\u30fc\u30e0\u30e2\u30fc\u30c9",modeFormTitle:"\u30d5\u30a9\u30fc\u30e0\u30e2\u30fc\u30c9\u306b\u5207\u308a\u66ff\u3048",modeTextText:"\u30c6\u30ad\u30b9\u30c8\u30e2\u30fc\u30c9",modeTextTitle:"\u30c6\u30ad\u30b9\u30c8\u30e2\u30fc\u30c9\u306b\u5207\u308a\u66ff\u3048",modeTreeText:"\u30c4\u30ea\u30fc\u30e2\u30fc\u30c9",modeTreeTitle:"\u30c4\u30ea\u30fc\u30e2\u30fc\u30c9\u306b\u5207\u308a\u66ff\u3048",modeViewText:"\u30d3\u30e5\u30fc\u30e2\u30fc\u30c9",modeViewTitle:"\u30d3\u30e5\u30fc\u30e2\u30fc\u30c9\u306b\u5207\u308a\u66ff\u3048",
modePreviewText:"\u30d7\u30ec\u30d3\u30e5\u30fc",modePreviewTitle:"\u30d7\u30ec\u30d3\u30e5\u30fc\u306b\u5207\u308a\u66ff\u3048",examples:"\u4f8b","default":"\u30c7\u30d5\u30a9\u30eb\u30c8",containsInvalidProperties:"\u7121\u52b9\u306a\u30d7\u30ed\u30d1\u30c6\u30a3\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059",containsInvalidItems:"\u7121\u52b9\u306a\u30a2\u30a4\u30c6\u30e0\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059"},"fr-FR":{array:"Liste",auto:"Auto",appendText:"Ajouter",appendTitle:"Ajouter un champ de type 'auto' apr\u00e8s ce champ (Ctrl+Shift+Ins)",
appendSubmenuTitle:"S\u00e9lectionner le type du champ \u00e0 ajouter",appendTitleAuto:"Ajouter un champ de type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendant",ascendingTitle:"Trier les enfants de ce ${type} par ordre ascendant",actionsMenu:"Ouvrir le menu des actions (Ctrl+M)",collapseAll:"Regrouper",descending:"Descendant",descendingTitle:"Trier les enfants de ce ${type} par ordre descendant",drag:"D\u00e9placer (Alt+Shift+Arrows)",duplicateKey:"Dupliquer la cl\u00e9",duplicateText:"Dupliquer",
duplicateTitle:"Dupliquer les champs s\u00e9lectionn\u00e9s (Ctrl+D)",duplicateField:"Dupliquer ce champ (Ctrl+D)",duplicateFieldError:"Dupliquer le nom de champ",cannotParseFieldError:"Champ impossible \u00e0 parser en JSON",cannotParseValueError:"Valeur impossible \u00e0 parser en JSON",empty:"vide",expandAll:"\u00c9tendre",expandTitle:"\u00c9tendre/regrouper ce champ (Ctrl+E). \nCtrl+Click pour \u00e9tendre/regrouper avec tous les champs.",insert:"Ins\u00e9rer",insertTitle:"Ins\u00e9rer un champ de type 'auto' avant ce champ (Ctrl+Ins)",
insertSub:"S\u00e9lectionner le type de champ \u00e0 ins\u00e9rer",object:"Objet",ok:"Ok",redo:"Rejouer (Ctrl+Shift+Z)",removeText:"Supprimer",removeTitle:"Supprimer les champs s\u00e9lectionn\u00e9s (Ctrl+Del)",removeField:"Supprimer ce champ (Ctrl+Del)",searchTitle:"Rechercher champs et valeurs",searchNextResultTitle:"R\u00e9sultat suivant (Enter)",searchPreviousResultTitle:"R\u00e9sultat pr\u00e9c\u00e9dent (Shift + Enter)",selectNode:"S\u00e9lectionner un n\u0153ud...",showAll:"voir tout",showMore:"voir plus",
showMoreStatus:"${visibleChilds} \u00e9l\u00e9ments affich\u00e9s de ${totalChilds}.",sort:"Trier",sortTitle:"Trier les champs de ce ${type}",sortTitleShort:"Trier",sortFieldLabel:"Champ:",sortDirectionLabel:"Direction:",sortFieldTitle:"S\u00e9lectionner les champs permettant de trier les listes et objet",sortAscending:"Ascendant",sortAscendingTitle:"Trier les champs s\u00e9lectionn\u00e9s par ordre ascendant",sortDescending:"Descendant",sortDescendingTitle:"Trier les champs s\u00e9lectionn\u00e9s par ordre descendant",
string:"Cha\u00eene",transform:"Transformer",transformTitle:"Filtrer, trier, or transformer les enfants de ce ${type}",transformTitleShort:"Filtrer, trier ou transformer le contenu",extract:"Extraire",extractTitle:"Extraire ce ${type}",transformQueryTitle:"Saisir une requ\u00eate JMESPath",transformWizardLabel:"Assistant",transformWizardFilter:"Filtrer",transformWizardSortBy:"Trier par",transformWizardSelectFields:"S\u00e9lectionner les champs",transformQueryLabel:"Requ\u00eate",transformPreviewLabel:"Pr\u00e9visualisation",
type:"Type",typeTitle:"Changer le type de ce champ",openUrl:"Ctrl+Click ou Ctrl+Enter pour ouvrir l'url dans une autre fen\u00eatre",undo:"Annuler la derni\u00e8re action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Champe de type "auto". Ce type de champ est automatiquement d\u00e9termin\u00e9 en fonction de la valeur et peut \u00eatre de type "cha\u00eene", "nombre", "bool\u00e9en" ou null.',objectType:'Champ de type "objet". Un objet contient un ensemble non ordonn\u00e9 de paires cl\u00e9/valeur.',
arrayType:'Champ de type "liste". Une liste contient une collection ordonn\u00e9e de valeurs.',stringType:'Champ de type "cha\u00eene". Ce type de champ n\'est pas d\u00e9termin\u00e9 en fonction de la valeur, mais retourne syst\u00e9matiquement une cha\u00eene de caract\u00e8res.',modeEditorTitle:"Changer mode d'\u00e9dition",modeCodeText:"Code",modeCodeTitle:"Activer surlignage code",modeFormText:"Formulaire",modeFormTitle:"Activer formulaire",modeTextText:"Texte",modeTextTitle:"Activer \u00e9diteur texte",
modeTreeText:"Arbre",modeTreeTitle:"Activer \u00e9diteur arbre",modeViewText:"Lecture seule",modeViewTitle:"Activer vue arbre",modePreviewText:"Pr\u00e9visualisation",modePreviewTitle:"Activer mode pr\u00e9visualiser",examples:"Exemples","default":"D\u00e9faut",containsInvalidProperties:"Contient des propri\u00e9t\u00e9s non valides",containsInvalidItems:"Contient des \u00e9l\u00e9ments invalides"},de:{array:"Auflistung",auto:"Auto",appendText:"anh\u00e4ngen",appendTitle:"F\u00fcgen Sie nach diesem Feld ein neues Feld mit dem Typ 'auto' ein (Strg+Umschalt+Ein)",
appendSubmenuTitle:"W\u00e4hlen Sie den Typ des neuen Feldes",appendTitleAuto:"Ein neues Feld vom Typ 'auto' hinzuf\u00fcgen (Strg+Umschalt+Ein)",ascending:"Aufsteigend",ascendingTitle:"Sortieren Sie die Elemente dieses ${type} in aufsteigender Reihenfolge",actionsMenu:"Klicken Sie zum \u00d6ffnen des Aktionsmen\u00fcs (Strg+M)",cannotParseFieldError:"Feld kann nicht in JSON geparst werden",cannotParseValueError:"Wert kann nicht in JSON geparst werden",collapseAll:"Alle Felder zuklappen",compactTitle:"JSON-Daten verdichten, alle Leerzeichen entfernen (Strg+Umschalt+\\)",
descending:"Absteigend",descendingTitle:"Sortieren Sie die Elemente dieses ${type} in absteigender Reihenfolge",drag:"Ziehen, um dieses Feld zu verschieben (Alt+Umschalt+Pfeile)",duplicateKey:"Doppelter Schl\u00fcssel",duplicateText:"Duplikat",duplicateTitle:"Ausgew\u00e4hlte Felder duplizieren (Strg+D)",duplicateField:"Dieses Feld duplizieren (Strg+D)",duplicateFieldError:"Doppelter Feldname",empty:"leer",expandAll:"Alle Felder anzeigen",expandTitle:"Klicken Sie, um dieses Feld zu erweitern/zu kollabieren (Strg+E). \nStrg+Klicken Sie, um dieses Feld einschlie\u00dflich aller Elemente zu erweitern/zu kollabieren.",
formatTitle:"JSON-Daten mit korrekter Einr\u00fcckung und Zeilenvorsch\u00fcben formatieren (Strg+\\)",insert:"einf\u00fcgen",insertTitle:"F\u00fcgen Sie vor diesem Feld ein neues Feld mit dem Typ 'auto' ein (Strg+Einfg)",insertSub:"W\u00e4hlen Sie den Typ des neuen Feldes",object:"Objekt",ok:"Ok",redo:"Wiederholen (Strg+Umschalt+Z)",removeText:"entfernen",removeTitle:"Ausgew\u00e4hlte Felder entfernen (Strg+Entf)",removeField:"Dieses Feld entfernen (Strg+Entf)",repairTitle:"JSON reparieren: Anf\u00fchrungszeichen und Escape-Zeichen korrigieren, Kommentare und JSONP-Notation entfernen, JavaScript-Objekte in JSON umwandeln.",
searchTitle:"Suchfelder und Werte",searchNextResultTitle:"N\u00e4chstes Ergebnis (Enter)",searchPreviousResultTitle:"Vorheriges Ergebnis (Umschalt + Eingabe)",selectNode:"W\u00e4hlen Sie einen Knoten aus...",showAll:"alle anzeigen",showMore:"mehr anzeigen",showMoreStatus:"Anzeige von ${visibleChilds} von ${totalChilds}-Elementen.",sort:"Sortieren",sortTitle:"Sortieren Sie die Elemente dieses ${type}",sortTitleShort:"Inhalt sortieren",sortFieldLabel:"Feld:",sortDirectionLabel:"Richtung:",sortFieldTitle:"W\u00e4hlen Sie das verschachtelte Feld, nach dem das Array oder Objekt sortiert werden soll.",
sortAscending:"Aufsteigend",sortAscendingTitle:"Sortieren Sie das ausgew\u00e4hlte Feld in aufsteigender Reihenfolge",sortDescending:"Absteigend",sortDescendingTitle:"Sortieren Sie das ausgew\u00e4hlte Feld in absteigender Reihenfolge",string:"Zeichenfolge",transform:"Verwandeln",transformTitle:"Die Elemente dieses ${type} filtern, sortieren oder transformieren",transformTitleShort:"Inhalte filtern, sortieren oder transformieren",extract:"Auszug",extractTitle:"Extrahieren Sie diesen ${type}",transformQueryTitle:"Eine JMESPath-Abfrage eingeben",
transformWizardLabel:"Zauberer",transformWizardFilter:"Filter",transformWizardSortBy:"Sortieren nach",transformWizardSelectFields:"Felder ausw\u00e4hlen",transformQueryLabel:"Anfrage",transformPreviewLabel:"Vorschau",type:"Geben Sie  ein.",typeTitle:"\u00c4ndern Sie den Typ dieses Feldes",openUrl:"Strg+Klicken oder Strg+Eingabe, um die URL in einem neuen Fenster zu \u00f6ffnen",undo:"Letzte Aktion r\u00fcckg\u00e4ngig machen (Strg+Z)",validationCannotMove:"Kann ein Feld nicht in ein Kind seiner selbst verschieben",
autoType:'Feldtyp "auto". Der Feldtyp wird automatisch aus dem Wert bestimmt und kann ein String, eine Zahl, boolesch oder null sein.',objectType:'Feldtyp "Objekt". Ein Objekt enth\u00e4lt eine ungeordnete Menge von Schl\u00fcssel/Wert-Paaren.',arrayType:'Feldtyp "Array". Ein Array enth\u00e4lt eine geordnete Sammlung von Werten.',stringType:'Feldtyp "Zeichenfolge". Der Feldtyp wird nicht aus dem Wert bestimmt, sondern immer als Zeichenfolge zur\u00fcckgegeben.',modeEditorTitle:"Editor-Modus umschalten",
modeCodeText:"Code",modeCodeTitle:"Umschalten auf Code-Highlighter",modeFormText:"Formular",modeFormTitle:"Zum Formular-Editor wechseln",modeTextText:"Text",modeTextTitle:"Zum Editor f\u00fcr einfachen Text wechseln",modeTreeText:"Baum",modeTreeTitle:"Zum Baum-Editor wechseln",modeViewText:"Siehe",modeViewTitle:"Zur Baumansicht wechseln",modePreviewText:"Vorschau",modePreviewTitle:"In den Vorschau-Modus wechseln",examples:"Beispiele","default":"Standardm\u00e4\u00dfig",containsInvalidProperties:"Enth\u00e4lt ung\u00fcltige Eigenschaften",
containsInvalidItems:"Enth\u00e4lt ung\u00fcltige Elemente"},ru:{array:"\u041c\u0430\u0441\u0441\u0438\u0432",auto:"\u0410\u0432\u0442\u043e",appendText:"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c",appendTitle:"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u043e\u0435 \u043f\u043e\u043b\u0435 \u0441 \u0442\u0438\u043f\u043e\u043c '\u0430\u0432\u0442\u043e' \u043f\u043e\u0441\u043b\u0435 \u044d\u0442\u043e\u0433\u043e \u043f\u043e\u043b\u044f (Ctrl+Shift+Ins)",appendSubmenuTitle:"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0442\u0438\u043f \u043f\u043e\u043b\u044f \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f",
appendTitleAuto:"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u043e\u0435 \u043f\u043e\u043b\u0435 \u0441 \u0442\u0438\u043f\u043e\u043c '\u0430\u0432\u0442\u043e' (Ctrl+Shift+Ins)",ascending:"\u041f\u043e \u0432\u043e\u0437\u0440\u0430\u0441\u0442\u0430\u043d\u0438\u044e",ascendingTitle:"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c ${type} \u043f\u043e \u0432\u043e\u0437\u0440\u0430\u0441\u0442\u0430\u043d\u0438\u044e",actionsMenu:"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0434\u043b\u044f \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u043c\u0435\u043d\u044e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439 (Ctrl+M)",
cannotParseFieldError:"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u043b\u0435 \u0432 JSON",cannotParseValueError:"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432 JSON",collapseAll:"\u0421\u0432\u0435\u0440\u043d\u0443\u0442\u044c \u0432\u0441\u0435",
compactTitle:"\u041c\u0438\u043d\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f JSON (Ctrl+Shift+I)",descending:"\u041f\u043e \u0443\u0431\u044b\u0432\u0430\u043d\u0438\u044e",descendingTitle:"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c ${type} \u043f\u043e \u0443\u0431\u044b\u0432\u0430\u043d\u0438\u044e",drag:"\u041f\u043e\u0442\u044f\u043d\u0438\u0442\u0435 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0438\u044f \u044d\u0442\u043e\u0433\u043e \u043f\u043e\u043b\u044f (Alt+Shift+Arrows)",
duplicateKey:"\u043f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0449\u0438\u0439\u0441\u044f \u043a\u043b\u044e\u0447",duplicateText:"\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c",duplicateTitle:"\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043b\u0435\u0439 (Ctrl+D)",duplicateField:"\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u043b\u0435 (Ctrl+D)",duplicateFieldError:"\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f \u043f\u043e\u043b\u044f",
empty:"\u043f\u0443\u0441\u0442\u043e\u0439",expandAll:"\u0420\u0430\u0437\u0432\u0435\u0440\u043d\u0443\u0442\u044c \u0432\u0441\u0435",expandTitle:"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0434\u043b\u044f \u0440\u0430\u0441\u043a\u0440\u044b\u0442\u0438\u044f/\u0441\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u043e\u043b\u044f (Ctrl+E)\n\u0438\u043b\u0438 Ctrl+Click \u0434\u043b\u044f \u0440\u0430\u0441\u043a\u0440\u044b\u0442\u0438\u044f/\u0441\u043a\u0440\u044b\u0442\u0438\u044f \u0432\u0441\u0435\u0445 \u043f\u043e\u0442\u043e\u043c\u043a\u043e\u0432.",
formatTitle:"\u0424\u043e\u0440\u043c\u0430\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 JSON (Ctrl+I)",insert:"\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c",insertTitle:"\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u043e\u0435 \u043f\u043e\u043b\u0435 \u0441 \u0442\u0438\u043f\u043e\u043c '\u0430\u0432\u0442\u043e' \u043f\u0435\u0440\u0435\u0434 \u044d\u0442\u0438\u043c \u043f\u043e\u043b\u0435\u043c (Ctrl+Ins)",insertSub:"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0442\u0438\u043f \u043f\u043e\u043b\u044f \u0434\u043b\u044f \u0432\u0441\u0442\u0430\u0432\u043a\u0438",
object:"\u041e\u0431\u044a\u0435\u043a\u0442",ok:"\u041e\u041a",redo:"\u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u044c (Ctrl+Shift+Z)",removeText:"\u0423\u0434\u0430\u043b\u0438\u0442\u044c",removeTitle:"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u043b\u044f (Ctrl+Del)",removeField:"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043e\u043b\u0435 (Ctrl+Del)",repairTitle:"\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 JSON: \u0438\u0441\u043f\u0440\u0430\u0432\u044c\u0442\u0435 \u043a\u0430\u0432\u044b\u0447\u043a\u0438 \u0438 escape-\u0441\u0438\u043c\u0432\u043e\u043b\u044b, \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0438 \u0438 \u043d\u043e\u0442\u0430\u0446\u0438\u044e JSONP, \u043c\u043e\u0434\u0438\u0444\u0438\u0446\u0438\u0440\u0443\u0439\u0442\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b JavaScript \u0432 JSON.",
searchTitle:"\u041f\u043e\u0438\u0441\u043a",searchNextResultTitle:"\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 (Enter)",searchPreviousResultTitle:"\u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 (Shift + Enter)",selectNode:"\u0412\u044b\u0431\u043e\u0440 \u0443\u0437\u043b\u0430...",showAll:"\u043f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0432\u0441\u0435",showMore:"\u0431\u043e\u043b\u044c\u0448\u0435",
showMoreStatus:"${visibleChilds} \u0438\u0437 ${totalChilds}",sort:"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430",sortTitle:"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u043f\u043e\u0442\u043e\u043c\u043a\u043e\u0432 \u0442\u0438\u043f\u0430 ${type}",sortTitleShort:"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e",sortFieldLabel:"\u041f\u043e\u043b\u0435:",sortDirectionLabel:"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435:",
sortFieldTitle:"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u043b\u0435 \u0434\u043b\u044f \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u0438\u043b\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430",sortAscending:"\u041f\u043e \u0432\u043e\u0437\u0440\u0430\u0441\u0442\u0430\u043d\u0438\u044e",sortAscendingTitle:"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u044f \u043f\u043e \u0432\u043e\u0437\u0440\u0430\u0441\u0442\u0430\u043d\u0438\u044e",
sortDescending:"\u041f\u043e \u0443\u0431\u044b\u0432\u0430\u043d\u0438\u044e",sortDescendingTitle:"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u044f \u043f\u043e \u0443\u0431\u044b\u0432\u0430\u043d\u0438\u044e",string:"\u0421\u0442\u0440\u043e\u043a\u0430",transform:"\u041c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f",transformTitle:"\u0424\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u044f, \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0438\u043b\u0438 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u0442\u0438\u043f\u0430 ${type}",
transformTitleShort:"\u0424\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u044f, \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0438\u043b\u0438 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445",extract:"\u0418\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u0435",extractTitle:"\u0418\u0437\u0432\u043b\u0435\u0447\u044c \u0442\u0438\u043f ${type}",transformQueryTitle:"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 JMESpath \u0437\u0430\u043f\u0440\u043e\u0441",
transformWizardLabel:"\u041c\u0430\u0441\u0442\u0435\u0440",transformWizardFilter:"\u0424\u0438\u043b\u044c\u0442\u0440",transformWizardSortBy:"\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430",transformWizardSelectFields:"\u041f\u043e\u043b\u044f",transformQueryLabel:"\u0417\u0430\u043f\u0440\u043e\u0441",transformPreviewLabel:"\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440",type:"\u0422\u0438\u043f",typeTitle:"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0438\u043f \u044d\u0442\u043e\u0433\u043e \u043f\u043e\u043b\u044f",
openUrl:"Ctrl+Click \u0438\u043b\u0438 Ctrl+Enter \u0434\u043b\u044f \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f url \u0432 \u043d\u043e\u0432\u043e\u043c \u043e\u043a\u043d\u0435",undo:"\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c (Ctrl+Z)",validationCannotMove:"\u041f\u043e\u043b\u0435 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u043e \u0432 \u043f\u043e\u0442\u043e\u043c\u043a\u0430",autoType:"\u0422\u0438\u043f \u043f\u043e\u043b\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044e \u0438 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u043e\u0439, \u0447\u0438\u0441\u043b\u043e\u043c, \u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u043c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u043c \u0438\u043b\u0438 null.",
objectType:"\u041e\u0431\u044a\u0435\u043a\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0443\u043f\u043e\u0440\u044f\u0434\u043e\u0447\u0435\u043d\u043d\u044b\u0439 \u043d\u0430\u0431\u043e\u0440 \u043f\u0430\u0440 \u043a\u043b\u044e\u0447/\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.",arrayType:"\u041c\u0430\u0441\u0441\u0438\u0432 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0443\u043f\u043e\u0440\u044f\u0434\u043e\u0447\u0435\u043d\u043d\u044b\u0439 \u043d\u0430\u0431\u043e\u0440 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439.",
stringType:"\u0422\u0438\u043f \u043f\u043e\u043b\u044f \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f \u0438\u0437 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f, \u043d\u043e \u0432\u0441\u0435\u0433\u0434\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u0442\u0441\u044f \u043a\u0430\u043a \u0441\u0442\u0440\u043e\u043a\u0430.",modeEditorTitle:"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0440\u0435\u0436\u0438\u043c\u0430 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430",
modeCodeText:"\u041a\u043e\u0434",modeCodeTitle:"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432 \u0440\u0435\u0436\u0438\u043c \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430 \u043a\u043e\u0434\u0430",modeFormText:"\u0424\u043e\u0440\u043c\u0430",modeFormTitle:"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432 \u0440\u0435\u0436\u0438\u043c \u0444\u043e\u0440\u043c\u044b",modeTextText:"\u0422\u0435\u043a\u0441\u0442",modeTextTitle:"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432 \u0440\u0435\u0436\u0438\u043c \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430 \u0442\u0435\u043a\u0441\u0442\u0430",
modeTreeText:"\u0414\u0435\u0440\u0435\u0432\u043e",modeTreeTitle:"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432 \u0440\u0435\u0436\u0438\u043c \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430 \u0434\u0435\u0440\u0435\u0432\u0430",modeViewText:"\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u0434\u0435\u0440\u0435\u0432\u0430",modeViewTitle:"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432 \u0440\u0435\u0436\u0438\u043c \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430 \u0434\u0435\u0440\u0435\u0432\u0430",
modePreviewText:"\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440",modePreviewTitle:"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432 \u0440\u0435\u0436\u0438\u043c \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430",examples:"\u041f\u0440\u0438\u043c\u0435\u0440\u044b","default":"\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e",containsInvalidProperties:"\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430",
containsInvalidItems:"\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b"}},g="en",d="undefined"!==typeof navigator?navigator.language||navigator.userLanguage:void 0,a=k.find(function(a){return a===d})||g},6056:function(y,e,h){function b(b,g){var d=g.sort,a=g.filter;g=g.projection;var c="";if(a){var f="@"!==a.field?["0"].concat((0,k.parsePath)("."+a.field)):["0"];b="string"===typeof(0,
k.get)(b,f)?a.value:(0,k.parseString)(a.value);c+="[? "+a.field+" "+a.relation+" `"+JSON.stringify(b)+"`]"}else c+=Array.isArray(b)?"[*]":"@";d&&(c="desc"===d.direction?c+(" | reverse(sort_by(@, &"+d.field+"))"):c+(" | sort_by(@, &"+d.field+")"));g&&("]"!==c[c.length-1]&&(c+=" | [*]"),1===g.fields.length?c+="."+g.fields[0]:1<g.fields.length&&(c+=".{"+g.fields.map(function(a){var c=a.split(".");return c[c.length-1]+": "+a}).join(", ")+"}"));return c}function r(b,g){return t().search(b,g)}h.d(e,{r:function(){return b},
J:function(){return r}});y=h(5156);var t=h.n(y),k=h(9791)},4987:function(){"undefined"!==typeof Element&&function(){function y(e){"remove"in e||Object.defineProperty(e,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){void 0!==this.parentNode&&this.parentNode.removeChild(this)}})}"undefined"!==typeof window.Element&&y(window.Element.prototype);"undefined"!==typeof window.CharacterData&&y(window.CharacterData.prototype);"undefined"!==typeof window.DocumentType&&y(window.DocumentType.prototype)}();
Array.prototype.findIndex||Object.defineProperty(Array.prototype,"findIndex",{value:function(y){for(var e=0;e<this.length;e++)if(y.call(this,this[e],e,this))return e;return-1},configurable:!0,writable:!0});Array.prototype.find||Object.defineProperty(Array.prototype,"find",{value:function(y){return this[this.findIndex(y)]},configurable:!0,writable:!0});String.prototype.trim||(String.prototype.trim=function(){return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")})},341:function(y,e,h){function b(a,
c){for(var b=0;b<c.length;b++){var d=c[b];d.enumerable=d.enumerable||!1;d.configurable=!0;"value"in d&&(d.writable=!0);Object.defineProperty(a,d.key,d)}}function r(a,c,d){c&&b(a.prototype,c);d&&b(a,d);return a}h.r(e);h.d(e,{previewModeMixins:function(){return l}});y=h(8909);var t=h.n(y),k=h(4188),x=h(6436),g=h(2474),d=function(){function a(c,b,d){if(!(this instanceof a))throw new TypeError("Cannot call a class as a function");this.onChange=c;this.calculateItemSize=b||function(){return 1};this.limit=
d;this.items=[];this.index=-1}r(a,[{key:"add",value:function(a){for(;this._calculateHistorySize()>this.limit&&1<this.items.length;)this.items.shift(),this.index--;this.items=this.items.slice(0,this.index+1);this.items.push(a);this.index++;this.onChange()}},{key:"_calculateHistorySize",value:function(){var a=this.calculateItemSize,c=0;this.items.forEach(function(b){c+=a(b)});return c}},{key:"undo",value:function(){if(this.canUndo())return this.index--,this.onChange(),this.items[this.index]}},{key:"redo",
value:function(){if(this.canRedo())return this.index++,this.onChange(),this.items[this.index]}},{key:"canUndo",value:function(){return 0<this.index}},{key:"canRedo",value:function(){return this.index<this.items.length-1}},{key:"clear",value:function(){this.items=[];this.index=-1;this.onChange()}}]);return a}(),a=h(7907),c=h(6056),f=h(6617),w=h(6210),m=h(2558);y=h(5956);var p=h(9791);h=y.textModeMixins[0].mixin;y={create:function(b){var l=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};"undefined"===
typeof l.statusBar&&(l.statusBar=!0);l.mainMenuBar=!1!==l.mainMenuBar;l.enableSort=!1!==l.enableSort;l.enableTransform=!1!==l.enableTransform;l.createQuery=l.createQuery||c.r;l.executeQuery=l.executeQuery||c.J;this.options=l;this.indentation="number"===typeof l.indentation?Number(l.indentation):2;(0,a.cC)(this.options.languages);(0,a.m0)(this.options.language);this.mode="preview";var m=this;this.container=b;this.dom={};this.json=void 0;this.text="";this._debouncedValidate=(0,p.debounce)(this.validate.bind(this),
this.DEBOUNCE_INTERVAL);this.width=b.clientWidth;this.height=b.clientHeight;this.frame=document.createElement("div");this.frame.className="jsoneditor jsoneditor-mode-preview";this.frame.onclick=function(a){a.preventDefault()};this.frameFocusTracker=new g.R({target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null});this.content=document.createElement("div");this.content.className="jsoneditor-outer";this.dom.busy=document.createElement("div");this.dom.busy.className="jsoneditor-busy";
this.dom.busyContent=document.createElement("span");this.dom.busyContent.textContent="busy...";this.dom.busy.appendChild(this.dom.busyContent);this.content.appendChild(this.dom.busy);this.dom.previewContent=document.createElement("pre");this.dom.previewContent.className="jsoneditor-preview";this.dom.previewText=document.createTextNode("");this.dom.previewContent.appendChild(this.dom.previewText);this.content.appendChild(this.dom.previewContent);if(this.options.mainMenuBar){(0,p.addClassName)(this.content,
"has-main-menu-bar");this.menu=document.createElement("div");this.menu.className="jsoneditor-menu";this.frame.appendChild(this.menu);var q=document.createElement("button");q.type="button";q.className="jsoneditor-format";q.title=(0,a.Iu)("formatTitle");this.menu.appendChild(q);q.onclick=function(){m.executeWithBusyMessage(function(){try{m.format()}catch(n){m._onError(n)}},"formatting...")};q=document.createElement("button");q.type="button";q.className="jsoneditor-compact";q.title=(0,a.Iu)("compactTitle");
this.menu.appendChild(q);q.onclick=function(){m.executeWithBusyMessage(function(){try{m.compact()}catch(n){m._onError(n)}},"compacting...")};this.options.enableSort&&(q=document.createElement("button"),q.type="button",q.className="jsoneditor-sort",q.title=(0,a.Iu)("sortTitleShort"),q.onclick=function(){m._showSortModal()},this.menu.appendChild(q));this.options.enableTransform&&(q=document.createElement("button"),q.type="button",q.title=(0,a.Iu)("transformTitleShort"),q.className="jsoneditor-transform",
q.onclick=function(){m._showTransformModal()},this.dom.transform=q,this.menu.appendChild(q));q=document.createElement("button");q.type="button";q.className="jsoneditor-repair";q.title=(0,a.Iu)("repairTitle");this.menu.appendChild(q);q.onclick=function(){void 0===m.json&&m.executeWithBusyMessage(function(){try{m.repair()}catch(n){m._onError(n)}},"repairing...")};!1!==this.options.history&&(this.history=new d(function(){m.dom.undo.disabled=!m.history.canUndo();m.dom.redo.disabled=!m.history.canRedo()},
function(a){return 2*a.text.length},k.oW),q=document.createElement("button"),q.type="button",q.className="jsoneditor-undo jsoneditor-separator",q.title=(0,a.Iu)("undo"),q.onclick=function(){var a=m.history.undo();a&&m._applyHistory(a)},this.menu.appendChild(q),this.dom.undo=q,q=document.createElement("button"),q.type="button",q.className="jsoneditor-redo",q.title=(0,a.Iu)("redo"),q.onclick=function(){var a=m.history.redo();a&&m._applyHistory(a)},this.menu.appendChild(q),this.dom.redo=q,this.history.onChange());
this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new f.x(this.menu,this.options.modes,this.options.mode,function(a){m.setMode(a);m.modeSwitcher.focus()}))}this.errorTable=new x.Q({errorTableVisible:!0,onToggleVisibility:function(){m.validate()},onFocusLine:null,onChangeHeight:function(a){a=a+(m.dom.statusBar?m.dom.statusBar.clientHeight:0)+1;m.content.style.marginBottom=-a+"px";m.content.style.paddingBottom=a+"px"}});this.frame.appendChild(this.content);this.frame.appendChild(this.errorTable.getErrorTable());
this.container.appendChild(this.frame);l.statusBar&&((0,p.addClassName)(this.content,"has-status-bar"),l=document.createElement("div"),this.dom.statusBar=l,l.className="jsoneditor-statusbar",this.frame.appendChild(l),this.dom.fileSizeInfo=document.createElement("span"),this.dom.fileSizeInfo.className="jsoneditor-size-info",this.dom.fileSizeInfo.innerText="",l.appendChild(this.dom.fileSizeInfo),this.dom.arrayInfo=document.createElement("span"),this.dom.arrayInfo.className="jsoneditor-size-info",this.dom.arrayInfo.innerText=
"",l.appendChild(this.dom.arrayInfo),l.appendChild(this.errorTable.getErrorCounter()),l.appendChild(this.errorTable.getWarningIcon()),l.appendChild(this.errorTable.getErrorIcon()));this._renderPreview();this.setSchema(this.options.schema,this.options.schemaRefs)},_renderPreview:function(){var a=this.getText();this.dom.previewText.nodeValue=(0,p.limitCharacters)(a,k.WF);this.dom.fileSizeInfo&&(this.dom.fileSizeInfo.innerText="Size: "+(0,p.formatSize)(a.length));this.dom.arrayInfo&&(Array.isArray(this.json)?
this.dom.arrayInfo.innerText="Array: "+this.json.length+" items":this.dom.arrayInfo.innerText="")},_onChange:function(){this._debouncedValidate();if(this.options.onChange)try{this.options.onChange()}catch(u){console.error("Error in onChange callback: ",u)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(u){console.error("Error in onChangeJSON callback: ",u)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(u){console.error("Error in onChangeText callback: ",
u)}},_showSortModal:function(){var a=this;this.executeWithBusyMessage(function(){var c=a.options.modalAnchor||k.qD,b=a.get();a._renderPreview();(0,w.showSortModal)(c,b,function(c){a.executeWithBusyMessage(function(){if(Array.isArray(b)){var d=(0,p.sort)(b,c.path,c.direction);a.sortedBy=c;a._setAndFireOnChange(d)}(0,p.isObject)(b)&&(d=(0,p.sortObjectKeys)(b,c.direction),a.sortedBy=c,a._setAndFireOnChange(d))},"sorting...")},a.sortedBy)},"parsing...")},_showTransformModal:function(){var a=this;this.executeWithBusyMessage(function(){var c=
a.options,b=c.createQuery,d=c.executeQuery,f=c.modalAnchor;c=c.queryDescription;var l=a.get();a._renderPreview();(0,m.showTransformModal)({container:f||k.qD,json:l,queryDescription:c,createQuery:b,executeQuery:d,onTransform:function(c){a.executeWithBusyMessage(function(){var b=d(l,c);a._setAndFireOnChange(b)},"transforming...")}})},"parsing...")},destroy:function(){this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame);this.modeSwitcher&&(this.modeSwitcher.destroy(),
this.modeSwitcher=null);this._debouncedValidate=null;this.history&&(this.history.clear(),this.history=null);this.frameFocusTracker.destroy()},compact:function(){var a=this.get(),c=JSON.stringify(a);this._setTextAndFireOnChange(c,a)},format:function(){var a=this.get(),c=JSON.stringify(a,null,this.indentation);this._setTextAndFireOnChange(c,a)},repair:function(){var a=this.getText();try{var c=t()(a);this._setTextAndFireOnChange(c)}catch(A){}},focus:function(){this.dom.transform.focus()},set:function(a){this.history&&
this.history.clear();this._set(a)},update:function(a){this._set(a)},_set:function(a){this.text=void 0;this.json=a;this._renderPreview();this._pushHistory();this._debouncedValidate()},_setAndFireOnChange:function(a){this._set(a);this._onChange()},get:function(){if(void 0===this.json){var a=this.getText();this.json=(0,p.parse)(a)}return this.json},getText:function(){void 0===this.text&&(this.text=JSON.stringify(this.json,null,this.indentation),!0===this.options.escapeUnicode&&(this.text=(0,p.escapeUnicodeChars)(this.text)));
return this.text},setText:function(a){this.history&&this.history.clear();this._setText(a)},updateText:function(a){this.getText()!==a&&this._setText(a)},_setText:function(a,c){this.text=!0===this.options.escapeUnicode?(0,p.escapeUnicodeChars)(a):a;this.json=c;this._renderPreview();if(void 0===this.json){var b=this;this.executeWithBusyMessage(function(){try{b.json=b.get(),b._renderPreview(),b._pushHistory()}catch(q){}},"parsing...")}else this._pushHistory();this._debouncedValidate()},_setTextAndFireOnChange:function(a,
c){this._setText(a,c);this._onChange()},_applyHistory:function(a){this.json=a.json;this.text=a.text;this._renderPreview();this._debouncedValidate()},_pushHistory:function(){this.history&&this.history.add({text:this.text,json:this.json})},executeWithBusyMessage:function(a,c){if(this.getText().length>k.EX){var b=this;(0,p.addClassName)(b.frame,"busy");b.dom.busyContent.innerText=c;setTimeout(function(){a();(0,p.removeClassName)(b.frame,"busy");b.dom.busyContent.innerText=""},100)}else a()}};y.validate=
h.validate;y._renderErrors=h._renderErrors;var l=[{mode:"preview",mixin:y,data:"json"}]},6210:function(y,e,h){function b(b,g,d,a){var c=Array.isArray(g)?(0,k.getChildPaths)(g):[""],f=a&&a.path&&(0,k.contains)(c,a.path)?a.path:c[0],w=a&&a.direction||"asc";g='<div class="pico-modal-contents"><div class="pico-modal-header">'+(0,t.Iu)("sort")+"</div><form><table><tbody><tr>  <td>"+(0,t.Iu)("sortFieldLabel")+' </td>  <td class="jsoneditor-modal-input">  <div class="jsoneditor-select-wrapper">    <select id="field" title="'+
(0,t.Iu)("sortFieldTitle")+'">    </select>  </div>  </td></tr><tr>  <td>'+(0,t.Iu)("sortDirectionLabel")+' </td>  <td class="jsoneditor-modal-input">  <div id="direction" class="jsoneditor-button-group"><input type="button" value="'+(0,t.Iu)("sortAscending")+'" title="'+(0,t.Iu)("sortAscendingTitle")+'" data-value="asc" class="jsoneditor-button-first jsoneditor-button-asc"/><input type="button" value="'+(0,t.Iu)("sortDescending")+'" title="'+(0,t.Iu)("sortDescendingTitle")+'" data-value="desc" class="jsoneditor-button-last jsoneditor-button-desc"/>  </div>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+
(0,t.Iu)("ok")+'" /></td></tr></tbody></table></form></div>';r()({parent:b,content:g,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-sort"}).afterCreate(function(a){function b(a){m.value=a;m.className="jsoneditor-button-group jsoneditor-button-group-value-"+m.value}var l=a.modalElem().querySelector("form"),g=a.modalElem().querySelector("#ok"),v=a.modalElem().querySelector("#field"),m=a.modalElem().querySelector("#direction");
c.forEach(function(a){var c=document.createElement("option");var b=""===a?"@":"."===a[0]?a.slice(1):a;c.text=b;c.value=a;v.appendChild(c)});v.value=f||c[0];b(w||"asc");m.onclick=function(a){b(a.target.getAttribute("data-value"))};g.onclick=function(c){c.preventDefault();c.stopPropagation();a.close();d({path:v.value,direction:m.value})};l&&(l.onsubmit=g.onclick)}).afterClose(function(a){a.destroy()}).show()}h.r(e);h.d(e,{showSortModal:function(){return b}});y=h(483);var r=h.n(y),t=h(7907),k=h(9791)},
2558:function(y,e,h){function b(a){"@babel/helpers - typeof";b="function"===typeof Symbol&&"symbol"===typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&"function"===typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?"symbol":typeof a};return b(a)}function r(a,c,d,g){if("boolean"===typeof a||a instanceof Boolean||null===a||"number"===typeof a||a instanceof Number||"string"===typeof a||a instanceof String||a instanceof Date)return JSON.stringify(a);if(Array.isArray(a)){a:{for(var f=
c?d+c:void 0,m=c?"[\n":"[",v=0;v<a.length;v++){var w=a[v];c&&(m+=f);m="undefined"!==typeof w&&"function"!==typeof w?m+r(w,c,f,g):m+"null";v<a.length-1&&(m+=c?",\n":",");if(m.length>g){a=m+"...";break a}}a=m+(c?"\n"+d+"]":"]")}return a}if(a&&"object"===b(a)){a:if(f=c?d+c:void 0,m=!0,v=c?"{\n":"{","function"===typeof a.toJSON)a=r(a.toJSON(),c,d,g);else{for(w in a)if(Object.prototype.hasOwnProperty.call(a,w)){var q=a[w];m?m=!1:v+=c?",\n":",";v+=c?f+'"'+w+'": ':'"'+w+'":';v+=r(q,c,f,g);if(v.length>g){a=
v+"...";break a}}a=v+(c?"\n"+d+"}":"}")}return a}}function t(b){var f=b.container,m=b.json,e=b.queryDescription;e=void 0===e?c:e;var l=b.createQuery,u=b.executeQuery,v=b.onTransform;b='<label class="pico-modal-contents"><div class="pico-modal-header">'+(0,g.Iu)("transform")+"</div><p>"+e+'</p><div class="jsoneditor-jmespath-label">'+(0,g.Iu)("transformWizardLabel")+' </div><div id="wizard" class="jsoneditor-jmespath-block jsoneditor-jmespath-wizard">  <table class="jsoneditor-jmespath-wizard-table">    <tbody>      <tr>        <th>'+
(0,g.Iu)("transformWizardFilter")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-filter-field" >            <select id="filterField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-relation" >            <select id="filterRelation">              <option value="==">==</option>              <option value="!=">!=</option>              <option value="<">&lt;</option>              <option value="<=">&lt;=</option>              <option value=">">&gt;</option>              <option value=">=">&gt;=</option>            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-value" >            <input type="text" class="value" placeholder="value..." id="filterValue" />          </div>        </td>      </tr>      <tr>        <th>'+
(0,g.Iu)("transformWizardSortBy")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-sort-field">            <select id="sortField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-sort-order" >            <select id="sortOrder">              <option value="asc">Ascending</option>              <option value="desc">Descending</option>            </select>          </div>        </td>      </tr>      <tr id="selectFieldsPart">        <th>'+
(0,g.Iu)("transformWizardSelectFields")+'</th>        <td class="jsoneditor-jmespath-filter">          <select class="jsoneditor-jmespath-select-fields" id="selectFields" multiple></select>        </td>      </tr>    </tbody>  </table></div><div class="jsoneditor-jmespath-label">'+(0,g.Iu)("transformQueryLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="query"             rows="4"             autocomplete="off"             autocorrect="off"             autocapitalize="off"             spellcheck="false"            title="'+
(0,g.Iu)("transformQueryTitle")+'">[*]</textarea></div><div class="jsoneditor-jmespath-label">'+(0,g.Iu)("transformPreviewLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="preview"       class="jsoneditor-transform-preview"      readonly> </textarea></div><div class="jsoneditor-jmespath-block jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+(0,g.Iu)("ok")+'" autofocus /></div></div>';k()({parent:f,content:b,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",
opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-transform",focus:!1}).afterCreate(function(c){function b(a){return""===a?"@":"."===a[0]?a.slice(1):a}function f(a,c){try{I.value=l(a,c),p.disabled=!1,U()}catch(X){a='Error: an error happened when executing "createQuery": '+(X.message||X.toString()),I.value="",p.disabled=!0,C.className="jsoneditor-transform-preview jsoneditor-error",C.value=a}}function g(){var a={};A.value&&k.value&&h.value&&(a.filter={field:A.value,relation:k.value,value:h.value});
t.value&&G.value&&(a.sort={field:t.value,direction:G.value});if(y.value){for(var c=[],b=0;b<y.options.length;b++)y.options[b].selected&&c.push(y.options[b].value);a.projection={fields:c}}f(m,a)}var w=c.modalElem(),e=w.querySelector("#wizard"),p=w.querySelector("#ok"),A=w.querySelector("#filterField"),k=w.querySelector("#filterRelation"),h=w.querySelector("#filterValue"),t=w.querySelector("#sortField"),G=w.querySelector("#sortOrder"),y=w.querySelector("#selectFields"),I=w.querySelector("#query"),C=
w.querySelector("#preview");Array.isArray(m)||(e.style.fontStyle="italic",e.textContent="(wizard not available for objects, only for arrays)");(0,d.getChildPaths)(m).forEach(function(a){a=b(a);var c=document.createElement("option");c.text=a;c.value=a;A.appendChild(c);c=document.createElement("option");c.text=a;c.value=a;t.appendChild(c)});e=(0,d.getChildPaths)(m,!0).filter(function(a){return""!==a});if(0<e.length)e.forEach(function(a){a=b(a);var c=document.createElement("option");c.text=a;c.value=
a;y.appendChild(c)});else if(e=w.querySelector("#selectFieldsPart"))e.style.display="none";e=new (x())(A,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."});var L=new (x())(k,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"compare..."}),Q=new (x())(t,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),S=new (x())(G,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"order..."}),O=new (x())(y,{multiple:!0,clearable:!0,defaultSelected:!1,
placeholder:"select fields..."});e.on("selectr.change",g);L.on("selectr.change",g);h.oninput=g;Q.on("selectr.change",g);S.on("selectr.change",g);O.on("selectr.change",g);w.querySelector(".pico-modal-contents").onclick=function(a){"A"!==a.target.nodeName&&a.preventDefault()};var U=(0,d.debounce)(function(){try{var c=u(m,I.value);C.className="jsoneditor-transform-preview";for(var b=a.WF,d=2,f="";0<d--;)f+=" ";var n=r(c,f,"",b);var q=n.length>b?("number"===typeof b?n.slice(0,b):n)+"...":n;C.value=q;
p.disabled=!1}catch(N){C.className="jsoneditor-transform-preview jsoneditor-error",C.value=N.toString(),p.disabled=!0}},300);I.oninput=U;p.onclick=function(a){a.preventDefault();a.stopPropagation();c.close();v(I.value)};f(m,{});setTimeout(function(){I.select();I.focus();I.selectionStart=3;I.selectionEnd=3})}).afterClose(function(a){a.destroy()}).show()}h.r(e);h.d(e,{showTransformModal:function(){return t}});y=h(483);var k=h.n(y);y=h(3879);var x=h.n(y),g=h(7907),d=h(9791),a=h(4188),c='Enter a <a href="http://jmespath.org" target="_blank">JMESPath</a> query to filter, sort, or transform the JSON data.<br/>To learn JMESPath, go to <a href="http://jmespath.org/tutorial.html" target="_blank">the interactive tutorial</a>.'},
5956:function(y,e,h){function b(a,c){if(!c)return Promise.resolve([]);try{var b=c(a);return((0,u.isPromise)(b)?b:Promise.resolve(b)).then(function(a){return Array.isArray(a)?a.filter(function(a){var c=(0,u.isValidValidationError)(a);c||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',a);return c}).map(function(a){return{dataPath:(0,u.stringifyPath)(a.path),message:a.message,type:"customValidation"}}):[]})}catch(J){return Promise.reject(J)}}
function r(a){"@babel/helpers - typeof";r="function"===typeof Symbol&&"symbol"===typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&"function"===typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?"symbol":typeof a};return r(a)}function t(){try{this.format()}catch(A){}}h.r(e);h.d(e,{textModeMixins:function(){return v}});y=h(8909);var k=h.n(y);y=h(8170);var x=h.n(y),g=h(4188),d=h(6436),a=h(2474),c=h(7907),f=h(6056),w=h(6617),m=h(6210),p=h(2558),l=h(9125),u=h(9791);h=
{create:function(b){var q=this,n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};"undefined"===typeof n.statusBar&&(n.statusBar=!0);n.mainMenuBar=!1!==n.mainMenuBar;n.enableSort=!1!==n.enableSort;n.enableTransform=!1!==n.enableTransform;n.createQuery=n.createQuery||f.r;n.executeQuery=n.executeQuery||f.J;this.options=n;this.indentation="number"===typeof n.indentation?Number(n.indentation):2;(0,c.cC)(this.options.languages);(0,c.m0)(this.options.language);var g=n.ace?n.ace:x();this.mode="code"===
n.mode?"code":"text";"code"===this.mode&&"undefined"===typeof g&&(this.mode="text",console.warn("Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`."));this.theme=n.theme||"ace/theme/jsoneditor";"ace/theme/jsoneditor"===this.theme&&g&&(0,l.O)();if(n.onTextSelectionChange)this.onTextSelectionChange(n.onTextSelectionChange);var v=this;this.container=b;this.dom={};this.textarea=this.aceEditor=void 0;
this.validateSchema=null;this.annotations=[];this.lastSchemaErrors=void 0;this._debouncedValidate=(0,u.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL);this.width=b.clientWidth;this.height=b.clientHeight;this.frame=document.createElement("div");this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode;this.frame.onclick=function(a){a.preventDefault()};this.frame.onkeydown=function(a){v._onKeyDown(a)};this.frameFocusTracker=new a.R({target:this.frame,onFocus:this.options.onFocus||
null,onBlur:this.options.onBlur||null});this.content=document.createElement("div");this.content.className="jsoneditor-outer";if(this.options.mainMenuBar){(0,u.addClassName)(this.content,"has-main-menu-bar");this.menu=document.createElement("div");this.menu.className="jsoneditor-menu";this.frame.appendChild(this.menu);var m=document.createElement("button");m.type="button";m.className="jsoneditor-format";m.title=(0,c.Iu)("formatTitle");this.menu.appendChild(m);m.onclick=function(){try{v.format(),v._onChange()}catch(F){v._onError(F)}};
m=document.createElement("button");m.type="button";m.className="jsoneditor-compact";m.title=(0,c.Iu)("compactTitle");this.menu.appendChild(m);m.onclick=function(){try{v.compact(),v._onChange()}catch(F){v._onError(F)}};this.options.enableSort&&(m=document.createElement("button"),m.type="button",m.className="jsoneditor-sort",m.title=(0,c.Iu)("sortTitleShort"),m.onclick=function(){v._showSortModal()},this.menu.appendChild(m));this.options.enableTransform&&(m=document.createElement("button"),m.type="button",
m.title=(0,c.Iu)("transformTitleShort"),m.className="jsoneditor-transform",m.onclick=function(){v._showTransformModal()},this.menu.appendChild(m));m=document.createElement("button");m.type="button";m.className="jsoneditor-repair";m.title=(0,c.Iu)("repairTitle");this.menu.appendChild(m);m.onclick=function(){try{v.repair(),v._onChange()}catch(F){v._onError(F)}};"code"===this.mode&&(m=document.createElement("button"),m.type="button",m.className="jsoneditor-undo jsoneditor-separator",m.title=(0,c.Iu)("undo"),
m.onclick=function(){q.aceEditor.getSession().getUndoManager().undo()},this.menu.appendChild(m),this.dom.undo=m,m=document.createElement("button"),m.type="button",m.className="jsoneditor-redo",m.title=(0,c.Iu)("redo"),m.onclick=function(){q.aceEditor.getSession().getUndoManager().redo()},this.menu.appendChild(m),this.dom.redo=m);this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new w.x(this.menu,this.options.modes,this.options.mode,function(a){v.setMode(a);v.modeSwitcher.focus()}));
if("code"===this.mode){var e=document.createElement("a");e.appendChild(document.createTextNode("powered by ace"));e.href="https://ace.c9.io/";e.target="_blank";e.className="jsoneditor-poweredBy";e.onclick=function(){window.open(e.href,e.target,"noopener")};this.menu.appendChild(e)}}m={};m=this.options.onEditable&&r("function"===this.options.onEditable)&&!this.options.onEditable(m);this.frame.appendChild(this.content);this.container.appendChild(this.frame);if("code"===this.mode){this.editorDom=document.createElement("div");
this.editorDom.style.height="100%";this.editorDom.style.width="100%";this.content.appendChild(this.editorDom);g=g.edit(this.editorDom);var p=g.getSession();g.$blockScrolling=Infinity;g.setTheme(this.theme);g.setOptions({readOnly:m});g.setShowPrintMargin(!1);g.setFontSize("13px");p.setMode("ace/mode/json");p.setTabSize(this.indentation);p.setUseSoftTabs(!0);p.setUseWrapMode(!0);var A=p.setAnnotations;p.setAnnotations=function(a){A.call(this,a&&a.length?a:v.annotations)};g.commands.bindKey("Ctrl-L",
null);g.commands.bindKey("Command-L",null);g.commands.bindKey("Ctrl-\\",null);g.commands.bindKey("Command-\\",null);g.commands.bindKey("Ctrl-Shift-\\",null);g.commands.bindKey("Command-Shift-\\",null);this.aceEditor=g;g.on("change",this._onChange.bind(this));g.on("changeSelection",this._onSelect.bind(this))}else g=document.createElement("textarea"),g.className="jsoneditor-text",g.spellcheck=!1,this.content.appendChild(g),this.textarea=g,this.textarea.readOnly=m,null===this.textarea.oninput?this.textarea.oninput=
this._onChange.bind(this):this.textarea.onchange=this._onChange.bind(this),g.onselect=this._onSelect.bind(this),g.onmousedown=this._onMouseDown.bind(this),g.onblur=this._onBlur.bind(this);this._updateHistoryButtons();this.errorTable=new d.Q({errorTableVisible:"text"===this.mode,onToggleVisibility:function(){v.validate()},onFocusLine:function(a){v.isFocused=!0;isNaN(a)||v.setTextSelection({row:a,column:1},{row:a,column:1E3})},onChangeHeight:function(a){a=a+(v.dom.statusBar?v.dom.statusBar.clientHeight:
0)+1;v.content.style.marginBottom=-a+"px";v.content.style.paddingBottom=a+"px"}});this.frame.appendChild(this.errorTable.getErrorTable());n.statusBar&&((0,u.addClassName)(this.content,"has-status-bar"),this.curserInfoElements={},n=document.createElement("div"),this.dom.statusBar=n,n.className="jsoneditor-statusbar",this.frame.appendChild(n),m=document.createElement("span"),m.className="jsoneditor-curserinfo-label",m.innerText="Ln:",g=document.createElement("span"),g.className="jsoneditor-curserinfo-val",
g.innerText="1",n.appendChild(m),n.appendChild(g),m=document.createElement("span"),m.className="jsoneditor-curserinfo-label",m.innerText="Col:",p=document.createElement("span"),p.className="jsoneditor-curserinfo-val",p.innerText="1",n.appendChild(m),n.appendChild(p),this.curserInfoElements.colVal=p,this.curserInfoElements.lnVal=g,g=document.createElement("span"),g.className="jsoneditor-curserinfo-label",g.innerText="characters selected",g.style.display="none",m=document.createElement("span"),m.className=
"jsoneditor-curserinfo-count",m.innerText="0",m.style.display="none",this.curserInfoElements.countLabel=g,this.curserInfoElements.countVal=m,n.appendChild(m),n.appendChild(g),n.appendChild(this.errorTable.getErrorCounter()),n.appendChild(this.errorTable.getWarningIcon()),n.appendChild(this.errorTable.getErrorIcon()));this.setSchema(this.options.schema,this.options.schemaRefs)},_onChange:function(){var a=this;if(!this.onChangeDisabled){setTimeout(function(){return a._updateHistoryButtons()});this._debouncedValidate();
if(this.options.onChange)try{this.options.onChange()}catch(q){console.error("Error in onChange callback: ",q)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(q){console.error("Error in onChangeText callback: ",q)}}},_updateHistoryButtons:function(){if(this.aceEditor&&this.dom.undo&&this.dom.redo){var a=this.aceEditor.getSession().getUndoManager();a&&a.hasUndo&&a.hasRedo&&(this.dom.undo.disabled=!a.hasUndo(),this.dom.redo.disabled=!a.hasRedo())}},_showSortModal:function(){var a=
this,c=this.options.modalAnchor||g.qD,b=this.get();(0,m.showSortModal)(c,b,function(c){if(Array.isArray(b)){var d=(0,u.sort)(b,c.path,c.direction);a.sortedBy=c;a.update(d)}(0,u.isObject)(b)&&(d=(0,u.sortObjectKeys)(b,c.direction),a.sortedBy=c,a.update(d))},a.sortedBy)},_showTransformModal:function(){var a=this,c=this.options,b=c.modalAnchor,d=c.createQuery,f=c.executeQuery;c=c.queryDescription;var l=this.get();(0,p.showTransformModal)({container:b||g.qD,json:l,queryDescription:c,createQuery:d,executeQuery:f,
onTransform:function(c){c=f(l,c);a.update(c)}})},_onSelect:function(){this._updateCursorInfo();this._emitSelectionChange()},_onKeyDown:function(a){var c=!1;73===(a.which||a.keyCode)&&a.ctrlKey&&(a.shiftKey?this.compact():this.format(),this._onChange(),c=!0);c&&(a.preventDefault(),a.stopPropagation());this._updateCursorInfo();this._emitSelectionChange()},_onMouseDown:function(){this._updateCursorInfo();this._emitSelectionChange()},_onBlur:function(){var a=this;setTimeout(function(){a.isFocused||(a._updateCursorInfo(),
a._emitSelectionChange());a.isFocused=!1})},_updateCursorInfo:function(){function a(){c.curserInfoElements.countVal.innerText!==l&&(c.curserInfoElements.countVal.innerText=l,c.curserInfoElements.countVal.style.display=l?"inline":"none",c.curserInfoElements.countLabel.style.display=l?"inline":"none");c.curserInfoElements.lnVal.innerText=f;c.curserInfoElements.colVal.innerText=g}var c=this;if(this.textarea)setTimeout(function(){var b=(0,u.getInputSelection)(c.textarea);b.startIndex!==b.endIndex&&(l=
b.endIndex-b.startIndex);l&&c.cursorInfo&&c.cursorInfo.line===b.end.row&&c.cursorInfo.column===b.end.column?(f=b.start.row,g=b.start.column):(f=b.end.row,g=b.end.column);c.cursorInfo={line:f,column:g,count:l};c.options.statusBar&&a()},0);else if(this.aceEditor&&this.curserInfoElements){var b=this.aceEditor.getCursorPosition(),d=this.aceEditor.getSelectedText();var f=b.row+1;var g=b.column+1;var l=d.length;c.cursorInfo={line:f,column:g,count:l};this.options.statusBar&&a()}},_emitSelectionChange:function(){if(this._selectionChangedHandler){var a=
this.getTextSelection();this._selectionChangedHandler(a.start,a.end,a.text)}},_refreshAnnotations:function(){var a=this.aceEditor&&this.aceEditor.getSession();if(a){var c=a.getAnnotations().filter(function(a){return"error"===a.type});a.setAnnotations(c)}},destroy:function(){this.aceEditor&&(this.aceEditor.destroy(),this.aceEditor=null);this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame);this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=
null);this._debouncedValidate=this.textarea=null;this.frameFocusTracker.destroy()},compact:function(){var a=this.get();a=JSON.stringify(a);this.updateText(a)},format:function(){var a=this.get();a=JSON.stringify(a,null,this.indentation);this.updateText(a)},repair:function(){var a=this.getText();try{var c=k()(a);this.updateText(c)}catch(n){}},focus:function(){this.textarea&&this.textarea.focus();this.aceEditor&&this.aceEditor.focus()},resize:function(){this.aceEditor&&this.aceEditor.resize(!1)},set:function(a){this.setText(JSON.stringify(a,
null,this.indentation))},update:function(a){this.updateText(JSON.stringify(a,null,this.indentation))},get:function(){var a=this.getText();return(0,u.parse)(a)},getText:function(){return this.textarea?this.textarea.value:this.aceEditor?this.aceEditor.getValue():""},_setText:function(a,c){var b=this;a=!0===this.options.escapeUnicode?(0,u.escapeUnicodeChars)(a):a;this.textarea&&(this.textarea.value=a);if(this.aceEditor){this.onChangeDisabled=!0;this.aceEditor.setValue(a,-1);this.onChangeDisabled=!1;
if(c){var d=this;setTimeout(function(){d.aceEditor&&d.aceEditor.session.getUndoManager().reset()})}setTimeout(function(){return b._updateHistoryButtons()})}this._debouncedValidate()},setText:function(a){this._setText(a,!0)},updateText:function(a){this.getText()!==a&&this._setText(a,!1)},validate:function(){var a=this,c=[],d=[];try{var f=this.get();this.validateSchema&&(this.validateSchema(f)||(c=this.validateSchema.errors.map(function(a){a.type="validation";return(0,u.improveSchemaError)(a)})));this.validationSequence=
(this.validationSequence||0)+1;var g=this,l=this.validationSequence;b(f,this.options.onValidate).then(function(b){l===g.validationSequence&&(b=c.concat(d).concat(b),g._renderErrors(b),"function"===typeof a.options.onValidationError&&((0,u.isValidationErrorChanged)(b,a.lastSchemaErrors)&&a.options.onValidationError.call(a,b),a.lastSchemaErrors=b))})["catch"](function(a){console.error("Custom validation function did throw an error",a)})}catch(E){if(this.getText()){f=/\w*line\s*(\d+)\w*/g.exec(E.message);
var m;f&&(m=+f[1]);d=[{type:"error",message:E.message.replace(/\n/g,"<br>"),line:m}]}this._renderErrors(d);"function"===typeof this.options.onValidationError&&((0,u.isValidationErrorChanged)(d,this.lastSchemaErrors)&&this.options.onValidationError.call(this,d),this.lastSchemaErrors=d)}},_renderErrors:function(a){var c=this.getText(),b=[];a.reduce(function(a,c){"string"===typeof c.dataPath&&-1===a.indexOf(c.dataPath)&&a.push(c.dataPath);return a},b);c=(0,u.getPositionForPath)(c,b);this.aceEditor&&
(this.annotations=c.map(function(c){var b=a.filter(function(a){return a.dataPath===c.path}),d=b.map(function(a){return a.message}).join("\n");return d?{row:c.line,column:c.column,text:"Schema validation error"+(1!==b.length?"s":"")+": \n"+d,type:"warning",source:"jsoneditor"}:{}}),this._refreshAnnotations());this.errorTable.setErrors(a,c);this.aceEditor&&this.aceEditor.resize(!1)},getTextSelection:function(){var a={};if(this.textarea){var c=(0,u.getInputSelection)(this.textarea);this.cursorInfo&&
this.cursorInfo.line===c.end.row&&this.cursorInfo.column===c.end.column?(a.start=c.end,a.end=c.start):a=c;return{start:a.start,end:a.end,text:this.textarea.value.substring(c.startIndex,c.endIndex)}}if(this.aceEditor){var b=this.aceEditor.getSelection();c=this.aceEditor.getSelectedText();var d=b.getRange();b=b.getSelectionLead();b.row===d.end.row&&b.column===d.end.column?a=d:(a.start=d.end,a.end=d.start);return{start:{row:a.start.row+1,column:a.start.column+1},end:{row:a.end.row+1,column:a.end.column+
1},text:c}}},onTextSelectionChange:function(a){"function"===typeof a&&(this._selectionChangedHandler=(0,u.debounce)(a,this.DEBOUNCE_INTERVAL))},setTextSelection:function(a,c){if(a&&c)if(this.textarea){var b=(0,u.getIndexForPosition)(this.textarea,a.row,a.column);c=(0,u.getIndexForPosition)(this.textarea,c.row,c.column);if(-1<b&&-1<c){if(this.textarea.setSelectionRange)this.textarea.focus(),this.textarea.setSelectionRange(b,c);else if(this.textarea.createTextRange){var d=this.textarea.createTextRange();
d.collapse(!0);d.moveEnd("character",c);d.moveStart("character",b);d.select()}b=(this.textarea.value.match(/\n/g)||[]).length+1;a=this.textarea.scrollHeight/b*a.row;this.textarea.scrollTop=a>this.textarea.clientHeight?a-this.textarea.clientHeight/2:0}}else this.aceEditor&&(this.aceEditor.selection.setRange({start:{row:a.row-1,column:a.column-1},end:{row:c.row-1,column:c.column-1}}),this.aceEditor.scrollToLine(a.row-1,!0))}};var v=[{mode:"text",mixin:h,data:"text",load:t},{mode:"code",mixin:h,data:"text",
load:t}]},8038:function(y,e,h){function b(a){function c(a){if(document.createRange){var c=document.createRange();c.selectNodeContents(a);c.collapse(!1);a=window.getSelection();a.removeAllRanges();a.addRange(c)}else document.selection&&(c=document.body.createTextRange(),c.moveToElementText(a),c.collapse(!1),c.select())}function b(a){void 0===l&&(l=document.createElement("span"),l.style.visibility="hidden",l.style.position="fixed",l.style.outline="0",l.style.margin="0",l.style.padding="0",l.style.border=
"0",l.style.left="0",l.style.whiteSpace="pre",l.style.fontSize=d,l.style.fontFamily=f,l.style.fontWeight="normal",document.body.appendChild(l));l.textContent=a;return l.getBoundingClientRect().right}a=a||{};a.filter=a.filter||"start";a.trigger=a.trigger||"keydown";a.confirmKeys=a.confirmKeys||[39,35,9];a.caseSensitive=a.caseSensitive||!1;var d="",f="",n=document.createElement("div");n.style.position="relative";n.style.outline="0";n.style.border="0";n.style.margin="0";n.style.padding="0";var g=document.createElement("div");
g.className="autocomplete dropdown";g.style.position="absolute";g.style.visibility="hidden";var l,m,v={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},startFrom:0,options:[],element:null,elementHint:null,elementStyle:null,wrapper:n,show:function(a,c,b){var l=this;this.startFrom=c;this.wrapper.remove();this.elementHint&&(this.elementHint.remove(),this.elementHint=null);""===d&&(d=window.getComputedStyle(a).getPropertyValue("font-size"));""===f&&(f=window.getComputedStyle(a).getPropertyValue("font-family"));
g.style.marginLeft="0";g.style.marginTop=a.getBoundingClientRect().height+"px";this.options=b.map(String);this.element!==a&&(this.element=a,this.elementStyle={zIndex:this.element.style.zIndex,position:this.element.style.position,backgroundColor:this.element.style.backgroundColor,borderColor:this.element.style.borderColor});this.element.style.zIndex=3;this.element.style.position="relative";this.element.style.backgroundColor="transparent";this.element.style.borderColor="transparent";this.elementHint=
a.cloneNode();this.elementHint.className="autocomplete hint";this.elementHint.style.zIndex=2;this.elementHint.style.position="absolute";this.elementHint.onfocus=function(){l.element.focus()};this.element.addEventListener&&(this.element.removeEventListener("keydown",e),this.element.addEventListener("keydown",e,!1),this.element.removeEventListener("blur",p),this.element.addEventListener("blur",p,!1));n.appendChild(this.elementHint);n.appendChild(g);a.parentElement.appendChild(n);this.repaint(a)},setText:function(a){this.element.innerText=
a},getText:function(){return this.element.innerText},hideDropDown:function(){this.wrapper.remove();this.elementHint&&(this.elementHint.remove(),this.elementHint=null,w.hide(),this.element.style.zIndex=this.elementStyle.zIndex,this.element.style.position=this.elementStyle.position,this.element.style.backgroundColor=this.elementStyle.backgroundColor,this.element.style.borderColor=this.elementStyle.borderColor)},repaint:function(c){var d=c.innerText;d=d.replace("\n","");c=this.options.length;var f=d.substring(this.startFrom);
m=d.substring(0,this.startFrom);for(d=0;d<c;d++){var n=this.options[d];if(!a.caseSensitive&&0===n.toLowerCase().indexOf(f.toLowerCase())||a.caseSensitive&&0===n.indexOf(f)){this.elementHint.innerText=m+f+n.substring(f.length);this.elementHint.realInnerText=m+n;break}}g.style.left=b(m)+"px";w.refresh(f,this.options);this.elementHint.style.width=b(this.elementHint.innerText)+10+"px";"hidden"!==g.style.visibility&&(this.elementHint.style.width=b(this.elementHint.innerText)+g.clientWidth+"px")}},w=function(c,
b){var d=[],f=0,n=-1,g=function(){this.style.backgroundColor="#ddd"},l=function(){this.style.backgroundColor=""},m=function(){v.hide();v.onmouseselection(this.__hint,v.rs)},v={rs:b,hide:function(){c.style.visibility="hidden"},refresh:function(b,n){c.style.visibility="hidden";f=0;c.textContent="";var w=window.innerHeight||document.documentElement.clientHeight,e=c.parentNode.getBoundingClientRect(),p=e.top-6;w=w-e.bottom-6;d=[];var u="function"===typeof a.filter?a.filter:q[a.filter];d=(u?n.filter(function(c){return u(a.caseSensitive?
b:b.toLowerCase(),a.caseSensitive?c:c.toLowerCase(),a)}):[]).map(function(a){var d=document.createElement("div");d.className="item";d.onmouseover=g;d.onmouseout=l;d.onmousedown=m;d.__hint=a;d.textContent="";d.appendChild(document.createTextNode(a.substring(0,b.length)));var f=document.createElement("b");f.appendChild(document.createTextNode(a.substring(b.length)));d.appendChild(f);c.appendChild(d);return d});0===d.length||1===d.length&&(b.toLowerCase()===d[0].__hint.toLowerCase()&&!a.caseSensitive||
b===d[0].__hint&&a.caseSensitive)||2>d.length||(v.highlight(0),p>3*w?(c.style.maxHeight=p+"px",c.style.top="",c.style.bottom="100%"):(c.style.top="100%",c.style.bottom="",c.style.maxHeight=w+"px"),c.style.visibility="visible")},highlight:function(a){-1!==n&&d[n]&&(d[n].className="item");d[a].className="item hover";n=a},move:function(a){if("hidden"===c.style.visibility)return"";if(-1===f+a||f+a===d.length)return d[f].__hint;f+=a;v.highlight(f);return d[f].__hint},onmouseselection:function(){}};return v}(g,
v),e=function(b){b=b||window.event;var d=b.keyCode;if(null!=this.elementHint&&33!==d&&34!==d)if(27===d)v.hideDropDown(),v.element.focus(),b.preventDefault(),b.stopPropagation();else{var f=this.element.innerText;f=f.replace("\n","");if(0<=a.confirmKeys.indexOf(d)){if(9===d&&0===this.elementHint.innerText.length)v.onTab();0<this.elementHint.innerText.length&&this.element.innerText!==this.elementHint.realInnerText&&(this.element.innerText=this.elementHint.realInnerText,v.hideDropDown(),c(this.element),
9===d&&(v.element.focus(),b.preventDefault(),b.stopPropagation()))}else if(13===d)if(0===this.elementHint.innerText.length)v.onEnter();else d="hidden"===g.style.visibility,w.hide(),d?(v.hideDropDown(),v.element.focus(),v.onEnter()):(this.element.innerText=this.elementHint.realInnerText,v.hideDropDown(),c(this.element),b.preventDefault(),b.stopPropagation());else if(40===d){d=f.substring(this.startFrom);f=w.move(1);if(""===f)v.onArrowDown();this.elementHint.innerText=m+d+f.substring(d.length);this.elementHint.realInnerText=
m+f;b.preventDefault();b.stopPropagation()}else if(38===d){d=f.substring(this.startFrom);f=w.move(-1);if(""===f)v.onArrowUp();this.elementHint.innerText=m+d+f.substring(d.length);this.elementHint.realInnerText=m+f;b.preventDefault();b.stopPropagation()}}}.bind(v),p=function(a){v.hideDropDown()};w.onmouseselection=function(a,b){b.element.innerText=b.elementHint.innerText=m+a;b.hideDropDown();window.setTimeout(function(){b.element.focus();c(b.element)},1)};return v}function r(a,c){for(var b=0;b<c.length;b++){var d=
c[b];d.enumerable=d.enumerable||!1;d.configurable=!0;"value"in d&&(d.writable=!0);Object.defineProperty(a,d.key,d)}}function t(a,c,b){c&&r(a.prototype,c);b&&r(a,b);return a}function k(a,c){var b;if("undefined"===typeof Symbol||null==a[Symbol.iterator]){if(Array.isArray(a)||(b=x(a))||c&&a&&"number"===typeof a.length){b&&(a=b);var d=0;c=function(){};return{s:c,n:function(){return d>=a.length?{done:!0}:{done:!1,value:a[d++]}},e:function(a){throw a;},f:c}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}var f=!0,n=!1,g;return{s:function(){b=a[Symbol.iterator]()},n:function(){var a=b.next();f=a.done;return a},e:function(a){n=!0;g=a},f:function(){try{if(!f&&null!=b["return"])b["return"]()}finally{if(n)throw g;}}}}function x(a,c){if(a){if("string"===typeof a)return g(a,c);var b=Object.prototype.toString.call(a).slice(8,-1);"Object"===b&&a.constructor&&(b=a.constructor.name);if("Map"===b||"Set"===b)return Array.from(a);if("Arguments"===b||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(b))return g(a,
c)}}function g(a,c){if(null==c||c>a.length)c=a.length;for(var b=0,d=Array(c);b<c;b++)d[b]=a[b];return d}function d(a){"@babel/helpers - typeof";d="function"===typeof Symbol&&"symbol"===typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&"function"===typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?"symbol":typeof a};return d(a)}function a(a,c){for(var b=0;b<c.length;b++){var d=c[b];d.enumerable=d.enumerable||!1;d.configurable=!0;"value"in d&&(d.writable=!0);Object.defineProperty(a,
d.key,d)}}function c(c,b,d){b&&a(c.prototype,b);d&&a(c,d);return c}function f(a){return a.getInternalPath()}function w(a){return a.getField()}function m(a,c){for(var b=0;b<c.length;b++){var d=c[b];d.enumerable=d.enumerable||!1;d.configurable=!0;"value"in d&&(d.writable=!0);Object.defineProperty(a,d.key,d)}}function p(a,c,b){c&&m(a.prototype,c);b&&m(a,b);return a}function l(a,c){for(var b=0;b<c.length;b++){var d=c[b];d.enumerable=d.enumerable||!1;d.configurable=!0;"value"in d&&(d.writable=!0);Object.defineProperty(a,
d.key,d)}}function u(a,c,b){c&&l(a.prototype,c);b&&l(a,b);return a}function v(a,c){for(var b=0;b<c.length;b++){var d=c[b];d.enumerable=d.enumerable||!1;d.configurable=!0;"value"in d&&(d.writable=!0);Object.defineProperty(a,d.key,d)}}function A(a,c,b){c&&v(a.prototype,c);b&&v(a,b);return a}h.r(e);h.d(e,{treeModeMixins:function(){return X}});var q={start:function(a,c,b){return 0===c.indexOf(a)},contain:function(a,c,b){return-1<c.indexOf(a)}},n=h(897),J=h(2474),K=function(){function a(){if(!(this instanceof
a))throw new TypeError("Cannot call a class as a function");this.locked=!1}t(a,[{key:"highlight",value:function(a){this.locked||(this.node!==a&&(this.node&&this.node.setHighlight(!1),this.node=a,this.node.setHighlight(!0)),this._cancelUnhighlight())}},{key:"unhighlight",value:function(){if(!this.locked){var a=this;this.node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){a.node.setHighlight(!1);a.node=void 0;a.unhighlightTimer=void 0},0))}}},{key:"_cancelUnhighlight",value:function(){this.unhighlightTimer&&
(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)}},{key:"lock",value:function(){this.locked=!0}},{key:"unlock",value:function(){this.locked=!1}}]);return a}(),z=h(7907),H=h(6056),E=h(6617);y=h(233);var D=h.n(y),F=h(2602),B=h(9791),G=h(6210),M=h(2558),I=h(4188),C=function(){function a(c,b){if(!(this instanceof a))throw new TypeError("Cannot call a class as a function");this.editor=c;this.dom={};this.expanded=!1;b&&b instanceof Object?(this.setField(b.field,b.fieldEditable),"value"in
b&&this.setValue(b.value,b.type),"internalValue"in b&&this.setInternalValue(b.internalValue)):(this.setField(""),this.setValue(null));this._debouncedOnChangeValue=(0,B.debounce)(this._onChangeValue.bind(this),a.prototype.DEBOUNCE_INTERVAL);this._debouncedOnChangeField=(0,B.debounce)(this._onChangeField.bind(this),a.prototype.DEBOUNCE_INTERVAL);this.visibleChilds=this.getMaxVisibleChilds()}c(a,[{key:"getMaxVisibleChilds",value:function(){return this.editor&&this.editor.options&&this.editor.options.maxVisibleChilds?
this.editor.options.maxVisibleChilds:L}},{key:"_updateEditability",value:function(){this.editable={field:!0,value:!0};if(this.editor&&(this.editable.field="tree"===this.editor.options.mode,this.editable.value="view"!==this.editor.options.mode,("tree"===this.editor.options.mode||"form"===this.editor.options.mode)&&"function"===typeof this.editor.options.onEditable)){var a=this.editor.options.onEditable({field:this.field,value:this.value,path:this.getPath()});"boolean"===typeof a?(this.editable.field=
a,this.editable.value=a):"object"===d(a)&&null!==a?("boolean"===typeof a.field&&(this.editable.field=a.field),"boolean"===typeof a.value&&(this.editable.value=a.value)):(console.error("Invalid return value for function onEditable.","Actual value:",a,".","Either a boolean or object { field: boolean, value: boolean } expected."),this.editable.field=!1,this.editable.value=!1)}}},{key:"getPath",value:function(){for(var a=this,c=[];a;){var b=a.getName();void 0!==b&&c.unshift(b);a=a.parent}return c}},{key:"getInternalPath",
value:function(){for(var a=this,c=[];a;)a.parent&&c.unshift(a.getIndex()),a=a.parent;return c}},{key:"getName",value:function(){return this.parent?"array"!==this.parent.type?this.field:this.index:void 0}},{key:"findNodeByPath",value:function(a){if(a){if(0===a.length)return this;if(a.length&&this.childs&&this.childs.length)for(var c=0;c<this.childs.length;++c)if(""+a[0]===""+this.childs[c].getName())return this.childs[c].findNodeByPath(a.slice(1))}}},{key:"findNodeByInternalPath",value:function(a){if(a){for(var c=
this,b=0;b<a.length&&c;b++)c=c.childs[a[b]];return c}}},{key:"serialize",value:function(){return{value:this.getValue(),path:this.getPath()}}},{key:"findNode",value:function(a){var c=(0,B.parsePath)(a),b=this;for(a=function(){var a=c.shift();if("number"===typeof a){if("array"!==b.type)throw Error("Cannot get child node at index "+a+": node is no array");b=b.childs[a]}else{if("object"!==b.type)throw Error("Cannot get child node "+a+": node is no object");b=b.childs.filter(function(c){return c.field===
a})[0]}};b&&0<c.length;)a();return b}},{key:"findParents",value:function(){for(var a=[],c=this.parent;c;)a.unshift(c),c=c.parent;return a}},{key:"setError",value:function(a,c){this.error=a;this.errorChild=c;this.dom&&this.dom.tr&&this.updateError()}},{key:"updateError",value:function(){var a=this,c=this.fieldError||this.valueError||this.error,b=this.dom.tdError;if(c&&this.dom&&this.dom.tr){(0,B.addClassName)(this.dom.tr,"jsoneditor-validation-error");b||(b=document.createElement("td"),this.dom.tdError=
b,this.dom.tdValue.parentNode.appendChild(b));var d=document.createElement("button");d.type="button";d.className="jsoneditor-button jsoneditor-schema-error";var f=function(){delete a.dom.popupAnchor},n=function(b){var n=a.editor.frame;a.dom.popupAnchor=(0,F.w)(d,a.editor.getPopupAnchor(),f,b);b=d.getBoundingClientRect();n=120<n.getBoundingClientRect().width-b.x?"jsoneditor-above":"jsoneditor-left";b=document.createElement("div");b.className="jsoneditor-popover "+n;b.appendChild(document.createTextNode(c.message));
a.dom.popupAnchor.appendChild(b)};d.onmouseover=function(){a.dom.popupAnchor||n(!0)};d.onfocus=function(){a.dom.popupAnchor&&a.dom.popupAnchor.destroy();n(!1)};d.onblur=function(){a.dom.popupAnchor&&a.dom.popupAnchor.destroy()};var g=this.errorChild;g&&(d.onclick=function(){g.findParents().forEach(function(a){a.expand(!1)});g.scrollTo(function(){g.focus()})});for(;b.firstChild;)b.removeChild(b.firstChild);b.appendChild(d)}else this.dom.tr&&(0,B.removeClassName)(this.dom.tr,"jsoneditor-validation-error"),
b&&(this.dom.tdError.parentNode.removeChild(this.dom.tdError),delete this.dom.tdError)}},{key:"getIndex",value:function(){if(this.parent){var a=this.parent.childs.indexOf(this);return-1!==a?a:null}return-1}},{key:"setParent",value:function(a){this.parent=a}},{key:"setField",value:function(a,c){this.previousField=this.field=a;this.fieldEditable=!0===c}},{key:"getField",value:function(){void 0===this.field&&this._getDomField();return this.field}},{key:"setValue",value:function(c,b){var d=this.childs;
this.type=this._getType(c);if(b&&b!==this.type)if("string"===b&&"auto"===this.type)this.type=b;else throw Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+b+'"');if("array"===this.type){this.childs||(this.childs=[]);for(b=0;b<c.length;b++){var f=c[b];if(void 0!==f&&!(f instanceof Function))if(b<this.childs.length){var n=this.childs[b];n.fieldEditable=!1;n.index=b;n.setValue(f)}else n=new a(this.editor,{value:f}),f=b<this.getMaxVisibleChilds(),this.appendChild(n,
f,!1)}for(b=this.childs.length;b>=c.length;b--)this.removeChild(this.childs[b],!1)}else if("object"===this.type){this.childs||(this.childs=[]);for(b=this.childs.length-1;0<=b;b--)Object.prototype.hasOwnProperty.call(c,this.childs[b].field)||this.removeChild(this.childs[b],!1);b=0;for(n in c)if(Object.prototype.hasOwnProperty.call(c,n)){f=c[n];if(void 0!==f&&!(f instanceof Function)){var g=this.findChildByProperty(n);g?(g.setField(n,!0),g.setValue(f)):(f=new a(this.editor,{field:n,value:f}),g=b<this.getMaxVisibleChilds(),
this.appendChild(f,g,!1))}b++}this.value="";!0===this.editor.options.sortObjectKeys&&this.sort([],"asc",!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=c;Array.isArray(d)!==Array.isArray(this.childs)&&this.recreateDom();this.updateDom({updateIndexes:!0});this.previousValue=this.value}},{key:"setInternalValue",value:function(c){var b,d=this.childs;this.type=c.type;if("array"===c.type){this.childs||(this.childs=[]);for(b=0;b<c.childs.length;b++){var f=
c.childs[b];if(void 0!==f&&!(f instanceof Function))if(b<this.childs.length){var n=this.childs[b];n.fieldEditable=!1;n.index=b;n.setInternalValue(f)}else n=new a(this.editor,{internalValue:f}),f=b<this.getMaxVisibleChilds(),this.appendChild(n,f,!1)}for(n=this.childs.length;n>=c.childs.length;n--)this.removeChild(this.childs[n],!1)}else if("object"===c.type){this.childs||(this.childs=[]);for(b=0;b<c.childs.length;b++)f=c.childs[b],void 0===f||f instanceof Function||(b<this.childs.length?(n=this.childs[b],
delete n.index,n.setField(f.field,!0),n.setInternalValue(f.value)):(n=new a(this.editor,{field:f.field,internalValue:f.value}),f=b<this.getMaxVisibleChilds(),this.appendChild(n,f,!1)));for(n=this.childs.length;n>=c.childs.length;n--)this.removeChild(this.childs[n],!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=c.value;Array.isArray(d)!==Array.isArray(this.childs)&&this.recreateDom();this.updateDom({updateIndexes:!0});this.previousValue=
this.value}},{key:"recreateDom",value:function(){if(this.dom&&this.dom.tr&&this.dom.tr.parentNode){var a=this._detachFromDom();this.clearDom();this._attachToDom(a)}else this.clearDom()}},{key:"getValue",value:function(){if("array"===this.type){var a=[];this.childs.forEach(function(c){a.push(c.getValue())});return a}if("object"===this.type){var c={};this.childs.forEach(function(a){c[a.getField()]=a.getValue()});return c}void 0===this.value&&this._getDomValue();return this.value}},{key:"getInternalValue",
value:function(){if("array"===this.type)return{type:this.type,childs:this.childs.map(function(a){return a.getInternalValue()})};if("object"===this.type)return{type:this.type,childs:this.childs.map(function(a){return{field:a.getField(),value:a.getInternalValue()}})};void 0===this.value&&this._getDomValue();return{type:this.type,value:this.value}}},{key:"getLevel",value:function(){return this.parent?this.parent.getLevel()+1:0}},{key:"getNodePath",value:function(){var a=this.parent?this.parent.getNodePath():
[];a.push(this);return a}},{key:"clone",value:function(){var c=new a(this.editor);c.type=this.type;c.field=this.field;c.fieldInnerText=this.fieldInnerText;c.fieldEditable=this.fieldEditable;c.previousField=this.previousField;c.value=this.value;c.valueInnerText=this.valueInnerText;c.previousValue=this.previousValue;c.expanded=this.expanded;c.visibleChilds=this.visibleChilds;if(this.childs){var b=[];this.childs.forEach(function(a){a=a.clone();a.setParent(c);b.push(a)});c.childs=b}else c.childs=void 0;
return c}},{key:"expand",value:function(a){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-expanded"),this.showChilds(),!1!==a&&this.childs.forEach(function(c){c.expand(a)}),this.updateDom({recurse:!1}))}},{key:"collapse",value:function(a){this.childs&&(this.hideChilds(),!1!==a&&this.childs.forEach(function(c){c.collapse(a)}),this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-collapsed"),this.expanded=!1,this.updateDom({recurse:!1}))}},
{key:"showChilds",value:function(){if(this.childs&&this.expanded){var a=this.dom.tr,c=a?a.parentNode:void 0;if(c){var b=this.getAppendDom();b.parentNode||((a=a.nextSibling)?c.insertBefore(b,a):c.appendChild(b));b=Math.min(this.childs.length,this.visibleChilds);a=this._getNextTr();for(var d=0;d<b;d++){var f=this.childs[d];f.getDom().parentNode||c.insertBefore(f.getDom(),a);f.showChilds()}b=this.getShowMoreDom();a=this._getNextTr();b.parentNode||c.insertBefore(b,a);this.showMore.updateDom()}}}},{key:"_getNextTr",
value:function(){if(this.showMore&&this.showMore.getDom().parentNode)return this.showMore.getDom();if(this.append&&this.append.getDom().parentNode)return this.append.getDom()}},{key:"hide",value:function(a){var c=this.dom.tr,b=c?c.parentNode:void 0;b&&b.removeChild(c);this.dom.popupAnchor&&this.dom.popupAnchor.destroy();this.hideChilds(a)}},{key:"hideChilds",value:function(a){if(this.childs&&this.expanded){var c=this.getAppendDom();c.parentNode&&c.parentNode.removeChild(c);this.childs.forEach(function(a){a.hide()});
c=this.getShowMoreDom();c.parentNode&&c.parentNode.removeChild(c);if(!a||a.resetVisibleChilds)this.visibleChilds=this.getMaxVisibleChilds()}}},{key:"_updateCssClassName",value:function(){if(this.dom.field&&this.editor&&this.editor.options&&"function"===typeof this.editor.options.onClassName&&this.dom.tree){(0,B.removeAllClassNames)(this.dom.tree);var a=this.editor.options.onClassName({path:this.getPath(),field:this.field,value:this.value})||"";(0,B.addClassName)(this.dom.tree,"jsoneditor-values "+
a)}}},{key:"recursivelyUpdateCssClassesOnNodes",value:function(){this._updateCssClassName();if(Array.isArray(this.childs))for(var a=0;a<this.childs.length;a++)this.childs[a].recursivelyUpdateCssClassesOnNodes()}},{key:"expandTo",value:function(){for(var a=this.parent;a;)a.expanded||a.expand(),a=a.parent}},{key:"appendChild",value:function(a,c,b){if(this._hasChilds()){a.setParent(this);a.fieldEditable="object"===this.type;"array"===this.type&&(a.index=this.childs.length);"object"===this.type&&void 0===
a.field&&a.setField("");this.childs.push(a);if(this.expanded&&!1!==c){c=a.getDom();var d=this._getNextTr(),f=d?d.parentNode:void 0;d&&f&&f.insertBefore(c,d);a.showChilds();this.visibleChilds++}!1!==b&&(this.updateDom({updateIndexes:!0}),a.updateDom({recurse:!0}))}}},{key:"moveBefore",value:function(a,c,b){if(this._hasChilds()){var d=this.dom.tr?this.dom.tr.parentNode:void 0;if(d){var f=document.createElement("tr");f.style.height=d.clientHeight+"px";d.appendChild(f)}a.parent&&a.parent.removeChild(a);
c instanceof Q||!c?this.childs.length+1>this.visibleChilds?this.insertBefore(a,this.childs[this.visibleChilds-1],b):this.appendChild(a,!0,b):this.insertBefore(a,c,b);d&&f&&d.removeChild(f)}}},{key:"insertBefore",value:function(a,c,b){if(this._hasChilds()){this.visibleChilds++;"object"===this.type&&void 0===a.field&&a.setField("");if(c===this.append)a.setParent(this),a.fieldEditable="object"===this.type,this.childs.push(a);else{var d=this.childs.indexOf(c);if(-1===d)throw Error("Node not found");a.setParent(this);
a.fieldEditable="object"===this.type;this.childs.splice(d,0,a)}if(this.expanded){d=a.getDom();var f=(c=c.getDom())?c.parentNode:void 0;c&&f&&f.insertBefore(d,c);a.showChilds();this.showChilds()}!1!==b&&(this.updateDom({updateIndexes:!0}),a.updateDom({recurse:!0}))}}},{key:"insertAfter",value:function(a,c){this._hasChilds()&&(c=this.childs.indexOf(c),(c=this.childs[c+1])?this.insertBefore(a,c):this.appendChild(a))}},{key:"search",value:function(a,c){Array.isArray(c)||(c=[]);var b=a?a.toLowerCase():
void 0;delete this.searchField;delete this.searchValue;if(void 0!==this.field&&c.length<=this.MAX_SEARCH_RESULTS){var d=String(this.field).toLowerCase().indexOf(b);-1!==d&&(this.searchField=!0,c.push({node:this,elem:"field"}));this._updateDomField()}this._hasChilds()?this.childs&&this.childs.forEach(function(b){b.search(a,c)}):void 0!==this.value&&c.length<=this.MAX_SEARCH_RESULTS&&(d=String(this.value).toLowerCase().indexOf(b),-1!==d&&(this.searchValue=!0,c.push({node:this,elem:"value"})),this._updateDomValue());
return c}},{key:"scrollTo",value:function(a){this.expandPathToNode();this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,a)}},{key:"expandPathToNode",value:function(){for(var a=this;a&&a.parent;){for(var c="array"===a.parent.type?a.index:a.parent.childs.indexOf(a);a.parent.visibleChilds<c+1;)a.parent.visibleChilds+=this.getMaxVisibleChilds();a.parent.expand(!1);a=a.parent}}},{key:"focus",value:function(c){a.focusElement=c;if(this.dom.tr&&this.dom.tr.parentNode){var b=this.dom;
switch(c){case "drag":b.drag?b.drag.focus():b.menu.focus();break;case "menu":b.menu.focus();break;case "expand":this._hasChilds()?b.expand.focus():b.field&&this.fieldEditable?(b.field.focus(),(0,B.selectContentEditable)(b.field)):b.value&&!this._hasChilds()?(b.value.focus(),(0,B.selectContentEditable)(b.value)):b.menu.focus();break;case "field":b.field&&this.fieldEditable?(b.field.focus(),(0,B.selectContentEditable)(b.field)):b.value&&!this._hasChilds()?(b.value.focus(),(0,B.selectContentEditable)(b.value)):
this._hasChilds()?b.expand.focus():b.menu.focus();break;default:b.select?b.select.focus():b.value&&!this._hasChilds()?(b.value.focus(),(0,B.selectContentEditable)(b.value)):b.field&&this.fieldEditable?(b.field.focus(),(0,B.selectContentEditable)(b.field)):this._hasChilds()?b.expand.focus():b.menu.focus()}}}},{key:"containsNode",value:function(a){if(this===a)return!0;var c=this.childs;if(c)for(var b=0,d=c.length;b<d;b++)if(c[b].containsNode(a))return!0;return!1}},{key:"removeChild",value:function(a,
c){if(this.childs){var b=this.childs.indexOf(a);if(-1!==b)return b<this.visibleChilds&&this.expanded&&this.visibleChilds--,a.hide(),delete a.searchField,delete a.searchValue,a=this.childs.splice(b,1)[0],a.parent=null,!1!==c&&this.updateDom({updateIndexes:!0}),a}}},{key:"_remove",value:function(a){this.removeChild(a)}},{key:"changeType",value:function(a){var c=this.type;if(c!==a){if("string"!==a&&"auto"!==a||"string"!==c&&"auto"!==c){var b=this._detachFromDom();this.clearDom();this.type=a;if("object"===
a){if(this.childs||(this.childs=[]),this.childs.forEach(function(a){a.clearDom();delete a.index;a.fieldEditable=!0;void 0===a.field&&(a.field="")}),"string"===c||"auto"===c)this.expanded=!0}else if("array"===a){if(this.childs||(this.childs=[]),this.childs.forEach(function(a,c){a.clearDom();a.fieldEditable=!1;a.index=c}),"string"===c||"auto"===c)this.expanded=!0}else this.expanded=!1;this._attachToDom(b)}else this.type=a;if("auto"===a||"string"===a)this.value="string"===a?String(this.value):(0,B.parseString)(String(this.value)),
this.focus();this.updateDom({updateIndexes:!0})}}},{key:"deepEqual",value:function(a){var c;if("array"===this.type){if(!Array.isArray(a)||this.childs.length!==a.length)return!1;for(c=0;c<this.childs.length;c++)if(!this.childs[c].deepEqual(a[c]))return!1}else if("object"===this.type){if("object"!==d(a)||!a)return!1;var b=Object.keys(a);if(this.childs.length!==b.length)return!1;for(c=0;c<b.length;c++){var f=this.childs[c];if(f.field!==b[c]||!f.deepEqual(a[f.field]))return!1}}else if(this.value!==a)return!1;
return!0}},{key:"_getDomValue",value:function(){this._clearValueError();this.dom.value&&"array"!==this.type&&"object"!==this.type&&(this.valueInnerText=(0,B.getInnerText)(this.dom.value),""===this.valueInnerText&&""!==this.dom.value.innerHTML&&(this.dom.value.textContent=""));if(void 0!==this.valueInnerText)try{if("string"===this.type)var a=this._unescapeHTML(this.valueInnerText);else{var c=this._unescapeHTML(this.valueInnerText);a=(0,B.parseString)(c)}a!==this.value&&(this.value=a,this._debouncedOnChangeValue())}catch(N){this._setValueError((0,
z.Iu)("cannotParseValueError"))}}},{key:"_setValueError",value:function(a){this.valueError={message:a};this.updateError()}},{key:"_clearValueError",value:function(){this.valueError&&(this.valueError=null,this.updateError())}},{key:"_setFieldError",value:function(a){this.fieldError={message:a};this.updateError()}},{key:"_clearFieldError",value:function(){this.fieldError&&(this.fieldError=null,this.updateError())}},{key:"_onChangeValue",value:function(){var a=this.editor.getDomSelection();if(a.range){var c=
(0,B.textDiff)(String(this.value),String(this.previousValue));a.range.startOffset=c.start;a.range.endOffset=c.end}c=this.editor.getDomSelection();if(c.range){var b=(0,B.textDiff)(String(this.previousValue),String(this.value));c.range.startOffset=b.start;c.range.endOffset=b.end}this.editor._onAction("editValue",{path:this.getInternalPath(),oldValue:this.previousValue,newValue:this.value,oldSelection:a,newSelection:c});this.previousValue=this.value}},{key:"_onChangeField",value:function(){var a=this.editor.getDomSelection(),
c=this.previousField||"";if(a.range){var b=(0,B.textDiff)(this.field,c);a.range.startOffset=b.start;a.range.endOffset=b.end}b=this.editor.getDomSelection();b.range&&(c=(0,B.textDiff)(c,this.field),b.range.startOffset=c.start,b.range.endOffset=c.end);this.editor._onAction("editField",{parentPath:this.parent.getInternalPath(),index:this.getIndex(),oldValue:this.previousField,newValue:this.field,oldSelection:a,newSelection:b});this.previousField=this.field}},{key:"_updateDomValue",value:function(){var a=
this.dom.value;if(a){var c=["jsoneditor-value"],b=this.value,d="auto"===this.type?(0,B.getType)(b):this.type,f="string"===d&&(0,B.isUrl)(b);c.push("jsoneditor-"+d);f&&c.push("jsoneditor-url");""===String(this.value)&&"array"!==this.type&&"object"!==this.type&&c.push("jsoneditor-empty");this.searchValueActive&&c.push("jsoneditor-highlight-active");this.searchValue&&c.push("jsoneditor-highlight");a.className=c.join(" ");a.title="array"===d||"object"===d?this.type+" containing "+(this.childs?this.childs.length:
0)+" items":f&&this.editable.value?(0,z.Iu)("openUrl"):"";"boolean"===d&&this.editable.value?(this.dom.checkbox||(this.dom.checkbox=document.createElement("input"),this.dom.checkbox.type="checkbox",this.dom.tdCheckbox=document.createElement("td"),this.dom.tdCheckbox.className="jsoneditor-tree",this.dom.tdCheckbox.appendChild(this.dom.checkbox),this.dom.tdValue.parentNode.insertBefore(this.dom.tdCheckbox,this.dom.tdValue)),this.dom.checkbox.checked=this.value):this.dom.tdCheckbox&&(this.dom.tdCheckbox.parentNode.removeChild(this.dom.tdCheckbox),
delete this.dom.tdCheckbox,delete this.dom.checkbox);if(this["enum"]&&this.editable.value){if(!this.dom.select){this.dom.select=document.createElement("select");this.id=this.field+"_"+(new Date).getUTCMilliseconds();this.dom.select.id=this.id;this.dom.select.name=this.dom.select.id;c=document.createElement("option");c.value="";c.textContent="--";this.dom.select.appendChild(c);for(c=0;c<this["enum"].length;c++)d=document.createElement("option"),d.value=this["enum"][c],d.textContent=this["enum"][c],
this.dom.select.appendChild(d);this.dom.tdSelect=document.createElement("td");this.dom.tdSelect.className="jsoneditor-tree";this.dom.tdSelect.appendChild(this.dom.select);this.dom.tdValue.parentNode.insertBefore(this.dom.tdSelect,this.dom.tdValue)}this.dom.select.value=-1!==this["enum"].indexOf(this.value)?this.value:"";!this.schema||Object.prototype.hasOwnProperty.call(this.schema,"oneOf")||Object.prototype.hasOwnProperty.call(this.schema,"anyOf")||Object.prototype.hasOwnProperty.call(this.schema,
"allOf")?delete this.valueFieldHTML:(this.valueFieldHTML=this.dom.tdValue.innerHTML,this.dom.tdValue.style.visibility="hidden",this.dom.tdValue.textContent="")}else this.dom.tdSelect&&(this.dom.tdSelect.parentNode.removeChild(this.dom.tdSelect),delete this.dom.tdSelect,delete this.dom.select,this.dom.tdValue.innerHTML=this.valueFieldHTML,this.dom.tdValue.style.visibility="",delete this.valueFieldHTML);this.editable.value&&this.editor.options.colorPicker&&"string"===typeof b&&(0,B.isValidColor)(b)?
(this.dom.color||(this.dom.color=document.createElement("div"),this.dom.color.className="jsoneditor-color",this.dom.tdColor=document.createElement("td"),this.dom.tdColor.className="jsoneditor-tree",this.dom.tdColor.appendChild(this.dom.color),this.dom.tdValue.parentNode.insertBefore(this.dom.tdColor,this.dom.tdValue)),(0,B.addClassName)(this.dom.value,"jsoneditor-color-value"),this.dom.color.style.backgroundColor=b):this._deleteDomColor();if(this._showTimestampTag()){this.dom.date||(this.dom.date=
document.createElement("div"),this.dom.date.className="jsoneditor-date",this.dom.value.parentNode.appendChild(this.dom.date));c=null;"function"===typeof this.editor.options.timestampFormat&&(c=this.editor.options.timestampFormat({field:this.field,value:this.value,path:this.getPath()}));if(c){for(;this.dom.date.firstChild;)this.dom.date.removeChild(this.dom.date.firstChild);this.dom.date.appendChild(document.createTextNode(c))}else this.dom.date.textContent=(new Date(b)).toISOString();this.dom.date.title=
(new Date(b)).toString()}else this.dom.date&&(this.dom.date.parentNode.removeChild(this.dom.date),delete this.dom.date);(0,B.stripFormatting)(a);this._updateDomDefault()}}},{key:"_deleteDomColor",value:function(){this.dom.color&&(this.dom.tdColor.parentNode.removeChild(this.dom.tdColor),delete this.dom.tdColor,delete this.dom.color,(0,B.removeClassName)(this.dom.value,"jsoneditor-color-value"))}},{key:"_updateDomField",value:function(){var a=this.dom.field;if(a){var c=(0,B.makeFieldTooltip)(this.schema,
this.editor.options.language);c&&(a.title=c);""===String(this.field)&&this.parent&&"array"!==this.parent.type?(0,B.addClassName)(a,"jsoneditor-empty"):(0,B.removeClassName)(a,"jsoneditor-empty");this.searchFieldActive?(0,B.addClassName)(a,"jsoneditor-highlight-active"):(0,B.removeClassName)(a,"jsoneditor-highlight-active");this.searchField?(0,B.addClassName)(a,"jsoneditor-highlight"):(0,B.removeClassName)(a,"jsoneditor-highlight");(0,B.stripFormatting)(a)}}},{key:"_getDomField",value:function(a){this._clearFieldError();
this.dom.field&&this.fieldEditable&&(this.fieldInnerText=(0,B.getInnerText)(this.dom.field),""===this.fieldInnerText&&""!==this.dom.field.innerHTML&&(this.dom.field.textContent=""));if(void 0!==this.fieldInnerText)try{var c=this._unescapeHTML(this.fieldInnerText),b=this.parent.getFieldNames(this);-1===b.indexOf(c)?c!==this.field&&(this.field=c,this._debouncedOnChangeField()):a?(c=(0,B.findUniqueName)(c,b),c!==this.field&&(this.field=c,this._debouncedOnChangeField())):this._setFieldError((0,z.Iu)("duplicateFieldError"))}catch(V){this._setFieldError((0,
z.Iu)("cannotParseFieldError"))}}},{key:"_updateDomDefault",value:function(){if(this.schema&&void 0!==this.schema["default"]&&!this._hasChilds()){var a=this.dom.select?this.dom.select:this.dom.value;a&&(this.value===this.schema["default"]?(a.title=(0,z.Iu)("default"),(0,B.addClassName)(a,"jsoneditor-is-default"),(0,B.removeClassName)(a,"jsoneditor-is-not-default")):(a.removeAttribute("title"),(0,B.removeClassName)(a,"jsoneditor-is-default"),(0,B.addClassName)(a,"jsoneditor-is-not-default")))}}},{key:"_showTimestampTag",
value:function(){if("number"!==typeof this.value)return!1;var a=this.editor.options.timestampTag;return"function"===typeof a?(a=a({field:this.field,value:this.value,path:this.getPath()}),"boolean"===typeof a?a:(0,B.isTimestamp)(this.field,this.value)):!0===a?(0,B.isTimestamp)(this.field,this.value):!1}},{key:"clearDom",value:function(){this.dom={}}},{key:"getDom",value:function(){var a=this.dom;if(a.tr)return a.tr;this._updateEditability();a.tr=document.createElement("tr");a.tr.node=this;if("tree"===
this.editor.options.mode){var c=document.createElement("td");if(this.editable.field&&this.parent){var b=document.createElement("button");b.type="button";a.drag=b;b.className="jsoneditor-button jsoneditor-dragarea";b.title=(0,z.Iu)("drag");c.appendChild(b)}a.tr.appendChild(c);c=document.createElement("td");b=document.createElement("button");b.type="button";a.menu=b;b.className="jsoneditor-button jsoneditor-contextmenu-button";b.title=(0,z.Iu)("actionsMenu");c.appendChild(a.menu);a.tr.appendChild(c)}c=
document.createElement("td");a.tr.appendChild(c);a.tree=this._createDomTree();c.appendChild(a.tree);this.updateDom({updateIndexes:!0});return a.tr}},{key:"isVisible",value:function(){return this.dom&&this.dom.tr&&this.dom.tr.parentNode||!1}},{key:"isDescendantOf",value:function(a){for(var c=this.parent;c;){if(c===a)return!0;c=c.parent}return!1}},{key:"_createDomField",value:function(){return document.createElement("div")}},{key:"setHighlight",value:function(a){this.dom.tr&&(a?(0,B.addClassName)(this.dom.tr,
"jsoneditor-highlight"):(0,B.removeClassName)(this.dom.tr,"jsoneditor-highlight"),this.append&&this.append.setHighlight(a),this.childs&&this.childs.forEach(function(c){c.setHighlight(a)}))}},{key:"setSelected",value:function(a,c){this.selected=a;this.dom.tr&&(a?(0,B.addClassName)(this.dom.tr,"jsoneditor-selected"):(0,B.removeClassName)(this.dom.tr,"jsoneditor-selected"),c?(0,B.addClassName)(this.dom.tr,"jsoneditor-first"):(0,B.removeClassName)(this.dom.tr,"jsoneditor-first"),this.append&&this.append.setSelected(a),
this.showMore&&this.showMore.setSelected(a),this.childs&&this.childs.forEach(function(c){c.setSelected(a)}))}},{key:"updateValue",value:function(a){this.previousValue=this.value=a;this.valueError=void 0;this.updateDom()}},{key:"updateField",value:function(a){this.previousField=this.field=a;this.fieldError=void 0;this.updateDom()}},{key:"updateDom",value:function(c){var b=this.dom.tree;b&&(b.style.marginLeft=24*this.getLevel()+"px");if(b=this.dom.field){this.fieldEditable?(b.contentEditable=this.editable.field,
b.spellcheck=!1,b.className="jsoneditor-field"):(b.contentEditable=!1,b.className="jsoneditor-readonly");var d=void 0!==this.index?this.index:void 0!==this.field?this.field:(d=this.editor.options.schema?a._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):void 0)&&d.title?d.title:this._hasChilds()?this.type:"";d=this._escapeHTML(d);if(document.activeElement!==b||d!==this._unescapeHTML((0,B.getInnerText)(b)))b.innerHTML=d;this._updateSchema()}if(b=this.dom.value)if("array"===
this.type||"object"===this.type)this.updateNodeName();else if(d=this._escapeHTML(this.value),document.activeElement!==b||d!==this._unescapeHTML((0,B.getInnerText)(b)))b.innerHTML=d;if(b=this.dom.tr)"array"===this.type||"object"===this.type?((0,B.addClassName)(b,"jsoneditor-expandable"),this.expanded?((0,B.addClassName)(b,"jsoneditor-expanded"),(0,B.removeClassName)(b,"jsoneditor-collapsed")):((0,B.addClassName)(b,"jsoneditor-collapsed"),(0,B.removeClassName)(b,"jsoneditor-expanded"))):((0,B.removeClassName)(b,
"jsoneditor-expandable"),(0,B.removeClassName)(b,"jsoneditor-expanded"),(0,B.removeClassName)(b,"jsoneditor-collapsed"));this._updateDomField();this._updateDomValue();c&&!0===c.updateIndexes&&this._updateDomIndexes();c&&!0===c.recurse&&this.childs&&this.childs.forEach(function(a){a.updateDom(c)});this.error&&this.updateError();this.append&&this.append.updateDom();this.showMore&&this.showMore.updateDom();this._updateCssClassName()}},{key:"_updateSchema",value:function(){this.editor&&this.editor.options&&
((this.schema=this.editor.options.schema?a._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):null)?this["enum"]=a._findEnum(this.schema):delete this["enum"])}},{key:"_updateDomIndexes",value:function(){var a=this.childs;this.dom.value&&a&&("array"===this.type?a.forEach(function(a,c){a.index=c;if(a=a.dom.field)a.textContent=c}):"object"===this.type&&a.forEach(function(a){void 0!==a.index&&(delete a.index,void 0===a.field&&(a.field=""))}))}},{key:"_createDomValue",
value:function(){if("array"===this.type){var a=document.createElement("div");a.textContent="[...]"}else"object"===this.type?(a=document.createElement("div"),a.textContent="{...}"):(!this.editable.value&&(0,B.isUrl)(this.value)?(a=document.createElement("a"),a.href=this.value):(a=document.createElement("div"),a.contentEditable=this.editable.value,a.spellcheck=!1),a.innerHTML=this._escapeHTML(this.value));return a}},{key:"_createDomExpandButton",value:function(){var a=document.createElement("button");
a.type="button";this._hasChilds()?(a.className=this.expanded?"jsoneditor-button jsoneditor-expanded":"jsoneditor-button jsoneditor-collapsed",a.title=(0,z.Iu)("expandTitle")):(a.className="jsoneditor-button jsoneditor-invisible",a.title="");return a}},{key:"_createDomTree",value:function(){var a=this.dom,c=document.createElement("table"),b=document.createElement("tbody");c.style.borderCollapse="collapse";c.className="jsoneditor-values";c.appendChild(b);var d=document.createElement("tr");b.appendChild(d);
b=document.createElement("td");b.className="jsoneditor-tree";d.appendChild(b);a.expand=this._createDomExpandButton();b.appendChild(a.expand);a.tdExpand=b;b=document.createElement("td");b.className="jsoneditor-tree";d.appendChild(b);a.field=this._createDomField();b.appendChild(a.field);a.tdField=b;b=document.createElement("td");b.className="jsoneditor-tree";d.appendChild(b);"object"!==this.type&&"array"!==this.type&&(b.appendChild(document.createTextNode(":")),b.className="jsoneditor-separator");a.tdSeparator=
b;b=document.createElement("td");b.className="jsoneditor-tree";d.appendChild(b);a.value=this._createDomValue();b.appendChild(a.value);a.tdValue=b;return c}},{key:"onEvent",value:function(a){var c=a.type,b=a.target||a.srcElement,d=this.dom,f=this,n=this._hasChilds();if(b===d.drag||b===d.menu)"mouseover"===c?this.editor.highlighter.highlight(this):"mouseout"===c&&this.editor.highlighter.unhighlight();if("click"===c&&b===d.menu){var g=f.editor.highlighter;g.highlight(f);g.lock();(0,B.addClassName)(d.menu,
"jsoneditor-selected");this.showContextMenu(d.menu,function(){(0,B.removeClassName)(d.menu,"jsoneditor-selected");g.unlock();g.unhighlight()})}"click"===c&&b===d.expand&&n&&this._onExpand(a.ctrlKey);"click"!==c||a.target!==f.dom.tdColor&&a.target!==f.dom.color||this._showColorPicker();"change"===c&&b===d.checkbox&&(this.dom.value.textContent=String(!this.value),this._getDomValue(),this._updateDomDefault());"change"===c&&b===d.select&&(this.dom.value.innerHTML=this._escapeHTML(d.select.value),this._getDomValue(),
this._updateDomValue());var l=d.value;if(b===l)switch(c){case "blur":case "change":this._getDomValue();this._clearValueError();this._updateDomValue();var q=this._escapeHTML(this.value);q!==this._unescapeHTML((0,B.getInnerText)(l))&&(l.innerHTML=q);break;case "input":this._getDomValue();this._updateDomValue();break;case "keydown":case "mousedown":this.editor.selection=this.editor.getDomSelection();break;case "click":a.ctrlKey&&this.editable.value&&(0,B.isUrl)(this.value)&&(a.preventDefault(),window.open(this.value,
"_blank","noopener"));break;case "keyup":this._getDomValue();this._updateDomValue();break;case "cut":case "paste":setTimeout(function(){f._getDomValue();f._updateDomValue()},1)}q=d.field;if(b===q)switch(c){case "blur":this._getDomField(!0);this._updateDomField();var m=this._escapeHTML(this.field);m!==this._unescapeHTML((0,B.getInnerText)(q))&&(q.innerHTML=m);break;case "input":this._getDomField();this._updateSchema();this._updateDomField();this._updateDomValue();break;case "keydown":case "mousedown":this.editor.selection=
this.editor.getDomSelection();break;case "keyup":this._getDomField();this._updateDomField();break;case "cut":case "paste":setTimeout(function(){f._getDomField();f._updateDomField()},1)}(m=d.tree)&&b===m.parentNode&&"click"===c&&!a.hasMoved&&((void 0!==a.offsetX?a.offsetX<24*(this.getLevel()+1):a.pageX<(0,B.getAbsoluteLeft)(d.tdSeparator))||n?q&&((0,B.setEndOfContentEditable)(q),q.focus()):l&&!this["enum"]&&((0,B.setEndOfContentEditable)(l),l.focus()));(b!==d.tdExpand||n)&&b!==d.tdField&&b!==d.tdSeparator||
"click"!==c||a.hasMoved||!q||((0,B.setEndOfContentEditable)(q),q.focus());if("keydown"===c)this.onKeyDown(a);"function"===typeof this.editor.options.onEvent&&this._onEvent(a)}},{key:"_onEvent",value:function(a){var c=a.target,b=c===this.dom.value||c===this.dom.checkbox||c===this.dom.select;if(c===this.dom.field||b)c={field:this.getField(),path:this.getPath()},b&&!this._hasChilds()&&(c.value=this.getValue()),this.editor.options.onEvent(c,a)}},{key:"onKeyDown",value:function(c){var b=c.which||c.keyCode,
d=c.target||c.srcElement,f=c.ctrlKey,n=c.shiftKey,g=c.altKey,l=!1,q,m="tree"===this.editor.options.mode,v=0<this.editor.multiselection.nodes.length?this.editor.multiselection.nodes:[this],e=v[0];var p=v[v.length-1];if(13===b)d===this.dom.value?this.editable.value&&!c.ctrlKey||!(0,B.isUrl)(this.value)||(window.open(this.value,"_blank","noopener"),l=!0):d===this.dom.expand&&this._hasChilds()&&(this._onExpand(c.ctrlKey),d.focus(),l=!0);else if(68===b)f&&m&&(a.onDuplicate(v),l=!0);else if(69===b)f&&(this._onExpand(n),
d.focus(),l=!0);else if(77===b&&m)f&&(this.showContextMenu(d),l=!0);else if(46===b&&m)f&&(a.onRemove(v),l=!0);else if(45===b&&m)f&&!n?(this._onInsertBefore(),l=!0):f&&n&&(this._onInsertAfter(),l=!0);else if(35===b)g&&((l=this._lastNode())&&l.focus(a.focusElement||this._getElementName(d)),l=!0);else if(36===b)g&&((l=this._firstNode())&&l.focus(a.focusElement||this._getElementName(d)),l=!0);else if(37===b)if(g&&!n)(d=this._previousElement(d))&&this.focus(this._getElementName(d)),l=!0;else{if(g&&n&&
m&&(f=p.expanded?(b=p.getAppendDom())?b.nextSibling:void 0:p.getDom().nextSibling,f)){b=a.getNodeFromTarget(f);f=f.nextSibling;var u=a.getNodeFromTarget(f);if(b&&b instanceof Q&&1!==p.parent.childs.length&&u&&u.parent){b=this.editor.getDomSelection();f=e.parent;p=f.childs[p.getIndex()+1]||f.append;n=e.getIndex();g=u.getIndex();m=f.getInternalPath();var x=u.parent.getInternalPath();v.forEach(function(a){u.parent.moveBefore(a,u)});this.focus(a.focusElement||this._getElementName(d));this.editor._onAction("moveNodes",
{count:v.length,fieldNames:v.map(w),oldParentPath:f.getInternalPath(),newParentPath:e.parent.getInternalPath(),oldIndex:p.getIndex(),newIndex:e.getIndex(),oldIndexRedo:n,newIndexRedo:g,oldParentPathRedo:m,newParentPathRedo:x,oldSelection:b,newSelection:this.editor.getDomSelection()})}}}else if(38===b)if(g&&!n){if(q=this._previousNode())this.editor.deselect(!0),q.focus(a.focusElement||this._getElementName(d));l=!0}else if(!g&&f&&n&&m){if(q=this._previousNode())d=this.editor.multiselection,d.start=
d.start||this,d.end=q,d=this.editor._findTopLevelNodes(d.start,d.end),this.editor.select(d),q.focus("field");l=!0}else g&&n&&m&&((q=e._previousNode())&&q.parent&&(b=this.editor.getDomSelection(),f=e.parent,p=f.childs[p.getIndex()+1]||f.append,n=e.getIndex(),g=q.getIndex(),m=f.getInternalPath(),x=q.parent.getInternalPath(),v.forEach(function(a){q.parent.moveBefore(a,q)}),this.focus(a.focusElement||this._getElementName(d)),this.editor._onAction("moveNodes",{count:v.length,fieldNames:v.map(w),oldParentPath:f.getInternalPath(),
newParentPath:e.parent.getInternalPath(),oldIndex:p.getIndex(),newIndex:e.getIndex(),oldIndexRedo:n,newIndexRedo:g,oldParentPathRedo:m,newParentPathRedo:x,oldSelection:b,newSelection:this.editor.getDomSelection()})),l=!0);else if(39===b)g&&!n?((d=this._nextElement(d))&&this.focus(this._getElementName(d)),l=!0):g&&n&&m&&(b=e.getDom().previousSibling)&&(q=a.getNodeFromTarget(b))&&q.parent&&!q.isVisible()&&(b=this.editor.getDomSelection(),f=e.parent,p=f.childs[p.getIndex()+1]||f.append,n=e.getIndex(),
g=q.getIndex(),m=f.getInternalPath(),x=q.parent.getInternalPath(),v.forEach(function(a){q.parent.moveBefore(a,q)}),this.focus(a.focusElement||this._getElementName(d)),this.editor._onAction("moveNodes",{count:v.length,fieldNames:v.map(w),oldParentPath:f.getInternalPath(),newParentPath:e.parent.getInternalPath(),oldIndex:p.getIndex(),newIndex:e.getIndex(),oldIndexRedo:n,newIndexRedo:g,oldParentPathRedo:m,newParentPathRedo:x,oldSelection:b,newSelection:this.editor.getDomSelection()}));else if(40===b)if(g&&
!n){if(b=this._nextNode())this.editor.deselect(!0),b.focus(a.focusElement||this._getElementName(d));l=!0}else if(!g&&f&&n&&m){if(b=this._nextNode())d=this.editor.multiselection,d.start=d.start||this,d.end=b,d=this.editor._findTopLevelNodes(d.start,d.end),this.editor.select(d),b.focus("field");l=!0}else if(g&&n&&m){(b=p.expanded?p.append?p.append._nextNode():void 0:p._nextNode())&&!b.isVisible()&&(b=b.parent.showMore);b&&b instanceof Q&&(b=p);var J=b&&(b._nextNode()||b.parent.append);J&&J.parent&&
(b=this.editor.getDomSelection(),f=e.parent,p=f.childs[p.getIndex()+1]||f.append,n=e.getIndex(),g=J.getIndex(),m=f.getInternalPath(),x=J.parent.getInternalPath(),v.forEach(function(a){J.parent.moveBefore(a,J)}),this.focus(a.focusElement||this._getElementName(d)),this.editor._onAction("moveNodes",{count:v.length,fieldNames:v.map(w),oldParentPath:f.getInternalPath(),newParentPath:e.parent.getInternalPath(),oldParentPathRedo:m,newParentPathRedo:x,oldIndexRedo:n,newIndexRedo:g,oldIndex:p.getIndex(),newIndex:e.getIndex(),
oldSelection:b,newSelection:this.editor.getDomSelection()}));l=!0}l&&(c.preventDefault(),c.stopPropagation())}},{key:"_onExpand",value:function(a){if(a){var c=this.dom.tr.parentNode;var b=c.parentNode;var d=b.scrollTop;b.removeChild(c)}this.expanded?this.collapse(a):this.expand(a);a&&(b.appendChild(c),b.scrollTop=d)}},{key:"_showColorPicker",value:function(){if("function"===typeof this.editor.options.onColorPicker&&this.dom.color){var a=this;a._deleteDomColor();a.updateDom();var c=(0,F.w)(this.dom.color,
this.editor.getPopupAnchor());this.editor.options.onColorPicker(c,this.value,function(c){"string"===typeof c&&c!==a.value&&(a._deleteDomColor(),a.value=c,a.updateDom(),a._debouncedOnChangeValue())})}}},{key:"getFieldNames",value:function(a){return"object"===this.type?this.childs.filter(function(c){return c!==a}).map(function(a){return a.field}):[]}},{key:"_onInsertBefore",value:function(c,b,d){var f=this.editor.getDomSelection();c=new a(this.editor,{field:void 0!==c?c:"",value:void 0!==b?b:"",type:d});
c.expand(!0);b=this.getInternalPath();this.parent.insertBefore(c,this);this.editor.highlighter.unhighlight();c.focus("field");d=this.editor.getDomSelection();this.editor._onAction("insertBeforeNodes",{nodes:[c],paths:[c.getInternalPath()],beforePath:b,parentPath:this.parent.getInternalPath(),oldSelection:f,newSelection:d})}},{key:"_onInsertAfter",value:function(c,b,d){var f=this.editor.getDomSelection();c=new a(this.editor,{field:void 0!==c?c:"",value:void 0!==b?b:"",type:d});c.expand(!0);this.parent.insertAfter(c,
this);this.editor.highlighter.unhighlight();c.focus("field");b=this.editor.getDomSelection();this.editor._onAction("insertAfterNodes",{nodes:[c],paths:[c.getInternalPath()],afterPath:this.getInternalPath(),parentPath:this.parent.getInternalPath(),oldSelection:f,newSelection:b})}},{key:"_onAppend",value:function(c,b,d){var f=this.editor.getDomSelection();c=new a(this.editor,{field:void 0!==c?c:"",value:void 0!==b?b:"",type:d});c.expand(!0);this.parent.appendChild(c);this.editor.highlighter.unhighlight();
c.focus("field");b=this.editor.getDomSelection();this.editor._onAction("appendNodes",{nodes:[c],paths:[c.getInternalPath()],parentPath:this.parent.getInternalPath(),oldSelection:f,newSelection:b})}},{key:"_onChangeType",value:function(a){var c=this.type;if(a!==c){var b=this.editor.getDomSelection();this.changeType(a);var d=this.editor.getDomSelection();this.editor._onAction("changeType",{path:this.getInternalPath(),oldType:c,newType:a,oldSelection:b,newSelection:d})}}},{key:"sort",value:function(a,
c){var b=2<arguments.length&&void 0!==arguments[2]?arguments[2]:!0;"string"===typeof a&&(a=(0,B.parsePath)(a));if(this._hasChilds()){this.hideChilds();var d=this.childs;this.childs=this.childs.concat();var f="desc"===c?-1:1;"object"===this.type?this.childs.sort(function(a,c){return f*D()(a.field,c.field)}):this.childs.sort(function(c,b){c=c.getNestedChild(a);b=b.getNestedChild(a);if(!c)return f;if(!b)return-f;c=c.value;b=b.value;return"string"!==typeof c&&"string"!==typeof b?c>b?f:c<b?-f:0:f*D()(c,
b)});this._updateDomIndexes();this.showChilds();!0===b&&this.editor._onAction("sort",{path:this.getInternalPath(),oldChilds:d,newChilds:this.childs})}}},{key:"update",value:function(a){var c=this.getInternalValue();this.setValue(a);this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:c,newValue:this.getInternalValue()})}},{key:"_detachFromDom",value:function(){var a=this.dom.tr?this.dom.tr.parentNode:void 0;var c=(c=this.expanded?this.getAppendDom():this.getDom())&&c.parentNode?
c.nextSibling:void 0;this.hide({resetVisibleChilds:!1});return{table:a,nextTr:c}}},{key:"_attachToDom",value:function(a){a.table&&(a.nextTr?a.table.insertBefore(this.getDom(),a.nextTr):a.table.appendChild(this.getDom()));this.expanded&&this.showChilds()}},{key:"transform",value:function(a){if(this._hasChilds()){this.hideChilds();try{var c=this.getInternalValue(),b=this.getValue(),d=this.editor.options.executeQuery(b,a);this.setValue(d);var f=this.getInternalValue();this.editor._onAction("transform",
{path:this.getInternalPath(),oldValue:c,newValue:f});this.showChilds()}catch(Y){this.showChilds(),this.editor._onError(Y)}}}},{key:"extract",value:function(){this.editor.node.hideChilds();this.hideChilds();try{var a=this.editor.node.getInternalValue();this.editor._setRoot(this);var c=this.editor.node.getInternalValue();this.editor._onAction("transform",{path:this.editor.node.getInternalPath(),oldValue:a,newValue:c})}catch(N){this.editor._onError(N)}finally{this.updateDom({recurse:!0}),this.showChilds()}}},
{key:"getNestedChild",value:function(a){for(var c=0,b=this;b&&c<a.length;)b=b.findChildByProperty(a[c]),c++;return b}},{key:"findChildByProperty",value:function(a){if("object"===this.type)return this.childs.find(function(c){return c.field===a})}},{key:"getAppendDom",value:function(){this.append||(this.append=new Q(this.editor),this.append.setParent(this));return this.append.getDom()}},{key:"getShowMoreDom",value:function(){this.showMore||(this.showMore=new S(this.editor,this));return this.showMore.getDom()}},
{key:"nextSibling",value:function(){var a=this.parent.childs.indexOf(this);return this.parent.childs[a+1]||this.parent.append}},{key:"_previousNode",value:function(){var c=null,b=this.getDom();if(b&&b.parentNode){do b=b.previousSibling,c=a.getNodeFromTarget(b);while(b&&c&&c instanceof Q&&!c.isVisible())}return c}},{key:"_nextNode",value:function(){var c=null,b=this.getDom();if(b&&b.parentNode){do b=b.nextSibling,c=a.getNodeFromTarget(b);while(b&&c&&c instanceof Q&&!c.isVisible())}return c}},{key:"_firstNode",
value:function(){var c=null,b=this.getDom();b&&b.parentNode&&(c=a.getNodeFromTarget(b.parentNode.firstChild));return c}},{key:"_lastNode",value:function(){var c=null,b=this.getDom();if(b&&b.parentNode)for(b=b.parentNode.lastChild,c=a.getNodeFromTarget(b);b&&c&&!c.isVisible();)b=b.previousSibling,c=a.getNodeFromTarget(b);return c}},{key:"_previousElement",value:function(a){var c=this.dom;switch(a){case c.value:if(this.fieldEditable)return c.field;case c.field:if(this._hasChilds())return c.expand;case c.expand:return c.menu;
case c.menu:if(c.drag)return c.drag;default:return null}}},{key:"_nextElement",value:function(a){var c=this.dom;switch(a){case c.drag:return c.menu;case c.menu:if(this._hasChilds())return c.expand;case c.expand:if(this.fieldEditable)return c.field;case c.field:if(!this._hasChilds())return c.value;default:return null}}},{key:"_getElementName",value:function(a){var c=this;return Object.keys(this.dom).find(function(b){return c.dom[b]===a})}},{key:"_hasChilds",value:function(){return"array"===this.type||
"object"===this.type}},{key:"addTemplates",value:function(a,c){var b=this,d=b.editor.options.templates;if(null!=d){d.length&&a.push({type:"separator"});var f=function(a,c){b._onAppend(a,c)},n=function(a,c){b._onInsertBefore(a,c)};d.forEach(function(b){a.push({text:b.text,className:b.className||"jsoneditor-type-object",title:b.title,click:c?f.bind(this,b.field,b.value):n.bind(this,b.field,b.value)})})}}},{key:"showContextMenu",value:function(c,b){var d=this,f=[];this.editable.value&&f.push({text:(0,
z.Iu)("type"),title:(0,z.Iu)("typeTitle"),className:"jsoneditor-type-"+this.type,submenu:[{text:(0,z.Iu)("auto"),className:"jsoneditor-type-auto"+("auto"===this.type?" jsoneditor-selected":""),title:(0,z.Iu)("autoType"),click:function(){d._onChangeType("auto")}},{text:(0,z.Iu)("array"),className:"jsoneditor-type-array"+("array"===this.type?" jsoneditor-selected":""),title:(0,z.Iu)("arrayType"),click:function(){d._onChangeType("array")}},{text:(0,z.Iu)("object"),className:"jsoneditor-type-object"+
("object"===this.type?" jsoneditor-selected":""),title:(0,z.Iu)("objectType"),click:function(){d._onChangeType("object")}},{text:(0,z.Iu)("string"),className:"jsoneditor-type-string"+("string"===this.type?" jsoneditor-selected":""),title:(0,z.Iu)("stringType"),click:function(){d._onChangeType("string")}}]});this._hasChilds()&&(this.editor.options.enableSort&&f.push({text:(0,z.Iu)("sort"),title:(0,z.Iu)("sortTitle",{type:this.type}),className:"jsoneditor-sort-asc",click:function(){d.showSortModal()}}),
this.editor.options.enableTransform&&f.push({text:(0,z.Iu)("transform"),title:(0,z.Iu)("transformTitle",{type:this.type}),className:"jsoneditor-transform",click:function(){d.showTransformModal()}}),this.parent&&f.push({text:(0,z.Iu)("extract"),title:(0,z.Iu)("extractTitle",{type:this.type}),className:"jsoneditor-extract",click:function(){d.extract()}}));if(this.parent&&this.parent._hasChilds()){f.length&&f.push({type:"separator"});var g=d.parent.childs;d===g[g.length-1]&&(g=[{text:(0,z.Iu)("auto"),
className:"jsoneditor-type-auto",title:(0,z.Iu)("autoType"),click:function(){d._onAppend("","","auto")}},{text:(0,z.Iu)("array"),className:"jsoneditor-type-array",title:(0,z.Iu)("arrayType"),click:function(){d._onAppend("",[])}},{text:(0,z.Iu)("object"),className:"jsoneditor-type-object",title:(0,z.Iu)("objectType"),click:function(){d._onAppend("",{})}},{text:(0,z.Iu)("string"),className:"jsoneditor-type-string",title:(0,z.Iu)("stringType"),click:function(){d._onAppend("","","string")}}],d.addTemplates(g,
!0),f.push({text:(0,z.Iu)("appendText"),title:(0,z.Iu)("appendTitle"),submenuTitle:(0,z.Iu)("appendSubmenuTitle"),className:"jsoneditor-append",click:function(){d._onAppend("","","auto")},submenu:g}));g=[{text:(0,z.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,z.Iu)("autoType"),click:function(){d._onInsertBefore("","","auto")}},{text:(0,z.Iu)("array"),className:"jsoneditor-type-array",title:(0,z.Iu)("arrayType"),click:function(){d._onInsertBefore("",[])}},{text:(0,z.Iu)("object"),className:"jsoneditor-type-object",
title:(0,z.Iu)("objectType"),click:function(){d._onInsertBefore("",{})}},{text:(0,z.Iu)("string"),className:"jsoneditor-type-string",title:(0,z.Iu)("stringType"),click:function(){d._onInsertBefore("","","string")}}];d.addTemplates(g,!1);f.push({text:(0,z.Iu)("insert"),title:(0,z.Iu)("insertTitle"),submenuTitle:(0,z.Iu)("insertSub"),className:"jsoneditor-insert",click:function(){d._onInsertBefore("","","auto")},submenu:g});this.editable.field&&(f.push({text:(0,z.Iu)("duplicateText"),title:(0,z.Iu)("duplicateField"),
className:"jsoneditor-duplicate",click:function(){a.onDuplicate(d)}}),f.push({text:(0,z.Iu)("removeText"),title:(0,z.Iu)("removeField"),className:"jsoneditor-remove",click:function(){a.onRemove(d)}}))}this.editor.options.onCreateMenu&&(g=d.getPath(),f=this.editor.options.onCreateMenu(f,{type:"single",path:g,paths:[g]}));(new n.x(f,{close:b})).show(c,this.editor.getPopupAnchor())}},{key:"showSortModal",value:function(){var a=this,c=this.editor.options.modalAnchor||I.qD,b=this.getValue();(0,G.showSortModal)(c,
b,function(c){var b=c.path;b=(0,B.parsePath)(b);a.sortedBy=c;a.sort(b,c.direction)},a.sortedBy)}},{key:"showTransformModal",value:function(){var a=this,c=this.editor.options,b=c.modalAnchor,d=c.createQuery,f=c.executeQuery;c=c.queryDescription;var n=this.getValue();(0,M.showTransformModal)({container:b||I.qD,json:n,queryDescription:c,createQuery:d,executeQuery:f,onTransform:function(c){a.transform(c)}})}},{key:"_getType",value:function(a){return a instanceof Array?"array":a instanceof Object?"object":
"string"===typeof a&&"string"!==typeof(0,B.parseString)(a)?"string":"auto"}},{key:"_escapeHTML",value:function(a){if("string"!==typeof a)return String(a);a=String(a).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/ {2}/g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;");a=JSON.stringify(a);a=a.substring(1,a.length-1);!0===this.editor.options.escapeUnicode&&(a=(0,B.escapeUnicodeChars)(a));return a}},{key:"_unescapeHTML",value:function(a){a='"'+this._escapeJSON(a)+'"';
return(0,B.parse)(a).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ").replace(/&amp;/g,"&")}},{key:"_escapeJSON",value:function(a){for(var c="",b=0;b<a.length;){var d=a.charAt(b);if("\n"===d)c+="\\n";else if("\\"===d){c+=d;b++;d=a.charAt(b);if(""===d||-1==='"\\/bfnrtu'.indexOf(d))c+="\\";c+=d}else c='"'===d?c+'\\"':c+d;b++}return c}},{key:"updateNodeName",value:function(){var a=this.childs?this.childs.length:0;if("object"===this.type||"array"===this.type){if(this.editor.options.onNodeName)try{var c=
this.editor.options.onNodeName({path:this.getPath(),size:a,type:this.type})}catch(N){console.error("Error in onNodeName callback: ",N)}this.dom.value.textContent="object"===this.type?"{"+(c||a)+"}":"["+(c||a)+"]"}}},{key:"recursivelyUpdateNodeName",value:function(){if(this.expanded&&(this.updateNodeName(),"undefined"!==this.childs))for(var a in this.childs)this.childs[a].recursivelyUpdateNodeName()}}]);return a}();C.prototype.DEBOUNCE_INTERVAL=150;C.prototype.MAX_SEARCH_RESULTS=999;var L=100;C.focusElement=
void 0;C.select=function(a){setTimeout(function(){(0,B.selectContentEditable)(a)},0)};C.onDragStart=function(a,c){if(!Array.isArray(a))return C.onDragStart([a],c);if(0!==a.length){var b=a[0],d=a[a.length-1],n=b.parent,g=C.getNodeFromTarget(c.target),l=b.editor;g=(0,B.getAbsoluteTop)(g.dom.tr)-(0,B.getAbsoluteTop)(b.dom.tr);l.mousemove||(l.mousemove=(0,B.addEventListener)(c.view,"mousemove",function(c){C.onDrag(a,c)}));l.mouseup||(l.mouseup=(0,B.addEventListener)(c.view,"mouseup",function(c){C.onDragEnd(a,
c)}));l.highlighter.lock();l.drag={oldCursor:document.body.style.cursor,oldSelection:l.getDomSelection(),oldPaths:a.map(f),oldParent:n,oldNextNode:n.childs[d.getIndex()+1]||n.append,oldParentPathRedo:n.getInternalPath(),oldIndexRedo:b.getIndex(),mouseX:c.pageX,offsetY:g,level:b.getLevel()};document.body.style.cursor="move";c.preventDefault()}};C.onDrag=function(a,c){if(!Array.isArray(a))return C.onDrag([a],c);if(0!==a.length){var b=a[0].editor,d=c.pageY-b.drag.offsetY,f=c.pageX,n,g=!1,l=a[0];var q=
l.dom.tr;var m=(0,B.getAbsoluteTop)(q);var v=q.offsetHeight;if(d<m){m=q;do{m=m.previousSibling;var w=C.getNodeFromTarget(m);var e=m?(0,B.getAbsoluteTop)(m):0}while(m&&d<e);w&&!w.parent&&(w=void 0);w||(m=(q=q.parentNode.firstChild)?q.nextSibling:void 0,w=C.getNodeFromTarget(m),w===l&&(w=void 0));w&&w.isVisible()&&(e=(m=w.dom.tr)?(0,B.getAbsoluteTop)(m):0,d>e+v&&(w=void 0));!w||!1!==b.options.limitDragging&&w.parent!==a[0].parent||(a.forEach(function(a){w.parent.moveBefore(a,w)}),g=!0)}else if(q=a[a.length-
1],n=(v=q.expanded&&q.append?q.append.getDom():q.dom.tr)?v.nextSibling:void 0){var p=(0,B.getAbsoluteTop)(n);do{var u=C.getNodeFromTarget(n);n&&(e=n.nextSibling?(0,B.getAbsoluteTop)(n.nextSibling):0,e=n?e-p:0,u&&u.parent.childs.length===a.length&&u.parent.childs[a.length-1]===q&&(m+=27),n=n.nextSibling)}while(n&&d>m+e);if(u&&u.parent){e=b.drag.level+Math.round((f-b.drag.mouseX)/24/2);p=u.getLevel();for(m=u.dom.tr&&u.dom.tr.previousSibling;p<e&&m;){w=C.getNodeFromTarget(m);if(!a.some(function(a){return a===
w||w.isDescendantOf(a)}))if(w instanceof Q)if(p=w.parent.childs,p.length!==a.length||p[a.length-1]!==q)u=C.getNodeFromTarget(m),p=u.getLevel();else break;else break;m=m.previousSibling}u instanceof Q&&!u.isVisible()&&u.parent.showMore.isVisible()&&(u=u._nextNode());u&&(!1===b.options.limitDragging||u.parent===a[0].parent)&&u.dom.tr&&u.dom.tr!==v.nextSibling&&(a.forEach(function(a){u.parent.moveBefore(a,u)}),g=!0)}}g&&(b.drag.mouseX=f,b.drag.level=l.getLevel());b.startAutoScroll(d);c.preventDefault()}};
C.onDragEnd=function(a,c){if(!Array.isArray(a))return C.onDrag([a],c);if(0!==a.length){var b=a[0],d=b.editor;b&&b.dom.menu&&b.dom.menu.focus();var f=d.drag.oldParent.getInternalPath(),n=b.parent.getInternalPath(),g=d.drag.oldParent===b.parent,l=d.drag.oldNextNode.getIndex();b=b.getIndex();var q=d.drag.oldParentPathRedo,m=d.drag.oldIndexRedo,v=g&&m<b?b+a.length:b;g&&m===b||d._onAction("moveNodes",{count:a.length,fieldNames:a.map(w),oldParentPath:f,newParentPath:n,oldIndex:l,newIndex:b,oldIndexRedo:m,
newIndexRedo:v,oldParentPathRedo:q,newParentPathRedo:null,oldSelection:d.drag.oldSelection,newSelection:d.getDomSelection()});document.body.style.cursor=d.drag.oldCursor;d.highlighter.unlock();a.forEach(function(a){a.updateDom();c.target!==a.dom.drag&&c.target!==a.dom.menu&&d.highlighter.unhighlight()});delete d.drag;d.mousemove&&((0,B.removeEventListener)(c.view,"mousemove",d.mousemove),delete d.mousemove);d.mouseup&&((0,B.removeEventListener)(c.view,"mouseup",d.mouseup),delete d.mouseup);d.stopAutoScroll();
c.preventDefault()}};C._findEnum=function(a){if(a["enum"])return a["enum"];if(a=a.oneOf||a.anyOf||a.allOf)if(a=a.filter(function(a){return a["enum"]}),0<a.length)return a[0]["enum"];return null};C._findSchema=function(a,c,b){var f=3<arguments.length&&void 0!==arguments[3]?arguments[3]:a,n=b.slice(1,b.length),g=b[0],l=k(f.oneOf||f.anyOf||f.allOf||[f]),q;try{for(l.s();!(q=l.n()).done;){f=q.value;if("$ref"in f&&"string"===typeof f.$ref){var m,v=f.$ref;if(v in c)f=c[v];else if(v.startsWith("#/")){var w=
v.substring(2).split("/");f=a;var e=k(w),p;try{for(e.s();!(p=e.n()).done;){var u=p.value;if(u in f)f=f[u];else throw Error("Unable to resovle reference ".concat(v));}}catch(ea){e.e(ea)}finally{e.f()}}else{if(1===(null===(m=v.match(/#\//g))||void 0===m?void 0:m.length)){var J=v.split("#/"),H,A;f=J;var r=Array.isArray(f)?f:void 0;if(!(A=r))if(r=void 0,"undefined"!==typeof Symbol&&Symbol.iterator in Object(J)){f=[];g=!0;q=!1;m=void 0;try{for(var z=J[Symbol.iterator]();!(g=(r=z.next()).done)&&(f.push(r.value),
2!==f.length);g=!0);}catch(ea){q=!0,m=ea}finally{try{if(!g&&null!=z["return"])z["return"]()}finally{if(q)throw m;}}A=f}else A=void 0;if(!(H=A||x(J,2)))throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");var K=H;var E=K[0],D=K[1];if(E in c){var h=c[E],t={$ref:"#/".concat(D)};return C._findSchema(h,c,n,t)}}throw Error("Unable to resolve reference ".concat(v));}}if(void 0===g)return f;if("string"===
typeof g){if("object"===d(f.properties)&&null!==f.properties&&g in f.properties)return f=f.properties[g],C._findSchema(a,c,n,f);if("object"===d(f.patternProperties)&&null!==f.patternProperties)for(var F in f.patternProperties)if(g.match(F))return f=f.patternProperties[F],C._findSchema(a,c,n,f);if("object"===d(f.additionalProperties))return f=f.additionalProperties,C._findSchema(a,c,n,f)}else if("number"===typeof g&&"object"===d(f.items)&&null!==f.items)return f=f.items,C._findSchema(a,c,n,f)}}catch(ea){l.e(ea)}finally{l.f()}return null};
C.onRemove=function(a){if(!Array.isArray(a))return C.onRemove([a]);if(a&&0<a.length){var c=a[0],b=c.parent,d=c.editor;c=c.getIndex();d.highlighter.unhighlight();var n=d.getDomSelection();C.blurNodes(a);var g=d.getDomSelection(),l=a.map(f);a.forEach(function(a){a.parent._remove(a)});d._onAction("removeNodes",{nodes:a,paths:l,parentPath:b.getInternalPath(),index:c,oldSelection:n,newSelection:g})}};C.onDuplicate=function(a){if(!Array.isArray(a))return C.onDuplicate([a]);if(a&&0<a.length){var c=a[a.length-
1],b=c.parent,d=c.editor;d.deselect(d.multiselection.nodes);var n=d.getDomSelection(),g=c,l=a.map(function(a){var c=a.clone();if("object"===a.parent.type){var d=a.parent.getFieldNames();c.field=(0,B.findUniqueName)(a.field,d)}b.insertAfter(c,g);return g=c});1===a.length?"object"===l[0].parent.type?(l[0].dom.field.innerHTML=a[0]._escapeHTML(a[0].field),l[0].focus("field")):l[0].focus():d.select(l);var q=d.getDomSelection();d._onAction("duplicateNodes",{paths:a.map(f),clonePaths:l.map(f),afterPath:c.getInternalPath(),
parentPath:b.getInternalPath(),oldSelection:n,newSelection:q})}};C.getNodeFromTarget=function(a){for(;a;){if(a.node)return a.node;a=a.parentNode}};C.targetIsColorPicker=function(a){var c=C.getNodeFromTarget(a);if(c)for(a=a&&a.parentNode;a;){if(a===c.dom.color)return!0;a=a.parentNode}return!1};C.blurNodes=function(a){if(Array.isArray(a)){var c=a[0],b=c.parent;c=c.getIndex();b.childs[c+a.length]?b.childs[c+a.length].focus():b.childs[c-1]?b.childs[c-1].focus():b.focus()}else C.blurNodes([a])};var Q=
function(a){function c(a){this.editor=a;this.dom={}}c.prototype=new a;c.prototype.getDom=function(){var a=this.dom;if(a.tr)return a.tr;this._updateEditability();var c=document.createElement("tr");c.className="jsoneditor-append";c.node=this;a.tr=c;if("tree"===this.editor.options.mode){a.tdDrag=document.createElement("td");var b=document.createElement("td");a.tdMenu=b;var d=document.createElement("button");d.type="button";d.className="jsoneditor-button jsoneditor-contextmenu-button";d.title="Click to open the actions menu (Ctrl+M)";
a.menu=d;b.appendChild(a.menu)}b=document.createElement("td");d=document.createElement("div");d.appendChild(document.createTextNode("("+(0,z.Iu)("empty")+")"));d.className="jsoneditor-readonly";b.appendChild(d);a.td=b;a.text=d;this.updateDom();return c};c.prototype.getPath=function(){return null};c.prototype.getIndex=function(){return null};c.prototype.updateDom=function(a){a=this.dom;var c=a.td;c&&(c.style.paddingLeft=24*this.getLevel()+26+"px");var b=a.text;b&&(b.firstChild.nodeValue="("+(0,z.Iu)("empty")+
" "+this.parent.type+")");b=a.tr;this.isVisible()?a.tr.firstChild||(a.tdDrag&&b.appendChild(a.tdDrag),a.tdMenu&&b.appendChild(a.tdMenu),b.appendChild(c)):a.tr.firstChild&&(a.tdDrag&&b.removeChild(a.tdDrag),a.tdMenu&&b.removeChild(a.tdMenu),b.removeChild(c))};c.prototype.isVisible=function(){return 0===this.parent.childs.length};c.prototype.showContextMenu=function(a,c){var b=this,d=[{text:(0,z.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,z.Iu)("autoType"),click:function(){b._onAppend("",
"","auto")}},{text:(0,z.Iu)("array"),className:"jsoneditor-type-array",title:(0,z.Iu)("arrayType"),click:function(){b._onAppend("",[])}},{text:(0,z.Iu)("object"),className:"jsoneditor-type-object",title:(0,z.Iu)("objectType"),click:function(){b._onAppend("",{})}},{text:(0,z.Iu)("string"),className:"jsoneditor-type-string",title:(0,z.Iu)("stringType"),click:function(){b._onAppend("","","string")}}];b.addTemplates(d,!0);d=[{text:(0,z.Iu)("appendText"),title:(0,z.Iu)("appendTitleAuto"),submenuTitle:(0,
z.Iu)("appendSubmenuTitle"),className:"jsoneditor-insert",click:function(){b._onAppend("","","auto")},submenu:d}];if(this.editor.options.onCreateMenu){var f=b.parent.getPath();d=this.editor.options.onCreateMenu(d,{type:"append",path:f,paths:[f]})}(new n.x(d,{close:c})).show(a,this.editor.getPopupAnchor())};c.prototype.onEvent=function(a){var c=a.type,b=a.target||a.srcElement,d=this.dom;b===d.menu&&("mouseover"===c?this.editor.highlighter.highlight(this.parent):"mouseout"===c&&this.editor.highlighter.unhighlight());
if("click"===c&&b===d.menu){var f=this.editor.highlighter;f.highlight(this.parent);f.lock();(0,B.addClassName)(d.menu,"jsoneditor-selected");this.showContextMenu(d.menu,function(){(0,B.removeClassName)(d.menu,"jsoneditor-selected");f.unlock();f.unhighlight()})}if("keydown"===c)this.onKeyDown(a)};return c}(C),S=function(a){function c(a,c){this.editor=a;this.parent=c;this.dom={}}c.prototype=new a;c.prototype.getDom=function(){if(this.dom.tr)return this.dom.tr;this._updateEditability();if(!this.dom.tr){var a=
this,c=this.parent,b=document.createElement("a");b.appendChild(document.createTextNode((0,z.Iu)("showMore")));b.href="#";b.onclick=function(b){c.visibleChilds=Math.floor(c.visibleChilds/c.getMaxVisibleChilds()+1)*c.getMaxVisibleChilds();a.updateDom();c.showChilds();b.preventDefault();return!1};var d=document.createElement("a");d.appendChild(document.createTextNode((0,z.Iu)("showAll")));d.href="#";d.onclick=function(b){c.visibleChilds=Infinity;a.updateDom();c.showChilds();b.preventDefault();return!1};
var f=document.createElement("div"),n=document.createTextNode(this._getShowMoreText());f.className="jsoneditor-show-more";f.appendChild(n);f.appendChild(b);f.appendChild(document.createTextNode(". "));f.appendChild(d);f.appendChild(document.createTextNode(". "));b=document.createElement("td");b.appendChild(f);d=document.createElement("tr");"tree"===this.editor.options.mode&&(d.appendChild(document.createElement("td")),d.appendChild(document.createElement("td")));d.appendChild(b);d.className="jsoneditor-show-more";
this.dom.tr=d;this.dom.moreContents=f;this.dom.moreText=n}this.updateDom();return this.dom.tr};c.prototype.updateDom=function(a){this.isVisible()?(this.dom.tr.node=this.parent.childs[this.parent.visibleChilds],this.dom.tr.parentNode||(a=this.parent._getNextTr())&&a.parentNode.insertBefore(this.dom.tr,a),this.dom.moreText.nodeValue=this._getShowMoreText(),this.dom.moreContents.style.marginLeft=24*(this.getLevel()+1)+"px"):this.dom.tr&&this.dom.tr.parentNode&&this.dom.tr.parentNode.removeChild(this.dom.tr)};
c.prototype._getShowMoreText=function(){return(0,z.Iu)("showMoreStatus",{visibleChilds:this.parent.visibleChilds,totalChilds:this.parent.childs.length})+" "};c.prototype.isVisible=function(){return this.parent.expanded&&this.parent.childs.length>this.parent.visibleChilds};c.prototype.onEvent=function(a){if("keydown"===a.type)this.onKeyDown(a)};return c}(C),O=function(){function a(c){function b(a){return c.node.findNodeByInternalPath(a)}if(!(this instanceof a))throw new TypeError("Cannot call a class as a function");
this.editor=c;this.history=[];this.index=-1;this.clear();this.actions={editField:{undo:function(a){b(a.parentPath).childs[a.index].updateField(a.oldValue)},redo:function(a){b(a.parentPath).childs[a.index].updateField(a.newValue)}},editValue:{undo:function(a){b(a.path).updateValue(a.oldValue)},redo:function(a){b(a.path).updateValue(a.newValue)}},changeType:{undo:function(a){b(a.path).changeType(a.oldType)},redo:function(a){b(a.path).changeType(a.newType)}},appendNodes:{undo:function(a){var c=b(a.parentPath);
a.paths.map(b).forEach(function(a){c.removeChild(a)})},redo:function(a){var c=b(a.parentPath);a.nodes.forEach(function(a){c.appendChild(a)})}},insertBeforeNodes:{undo:function(a){var c=b(a.parentPath);a.paths.map(b).forEach(function(a){c.removeChild(a)})},redo:function(a){var c=b(a.parentPath),d=b(a.beforePath);a.nodes.forEach(function(a){c.insertBefore(a,d)})}},insertAfterNodes:{undo:function(a){var c=b(a.parentPath);a.paths.map(b).forEach(function(a){c.removeChild(a)})},redo:function(a){var c=b(a.parentPath),
d=b(a.afterPath);a.nodes.forEach(function(a){c.insertAfter(a,d);d=a})}},removeNodes:{undo:function(a){var c=b(a.parentPath),d=c.childs[a.index]||c.append;a.nodes.forEach(function(a){c.insertBefore(a,d)})},redo:function(a){var c=b(a.parentPath);a.paths.map(b).forEach(function(a){c.removeChild(a)})}},duplicateNodes:{undo:function(a){var c=b(a.parentPath);a.clonePaths.map(b).forEach(function(a){c.removeChild(a)})},redo:function(a){var c=b(a.parentPath),d=b(a.afterPath);a.paths.map(b).forEach(function(a){var b=
a.clone();if("object"===c.type){var f=c.getFieldNames();b.field=(0,B.findUniqueName)(a.field,f)}c.insertAfter(b,d);d=b})}},moveNodes:{undo:function(a){var c=b(a.oldParentPath),d=b(a.newParentPath),f=c.childs[a.oldIndex]||c.append;d.childs.slice(a.newIndex,a.newIndex+a.count).forEach(function(b,d){b.field=a.fieldNames[d];c.moveBefore(b,f)});null===a.newParentPathRedo&&(a.newParentPathRedo=d.getInternalPath())},redo:function(a){var c=b(a.oldParentPathRedo),d=b(a.newParentPathRedo),f=d.childs[a.newIndexRedo]||
d.append;c.childs.slice(a.oldIndexRedo,a.oldIndexRedo+a.count).forEach(function(c,b){c.field=a.fieldNames[b];d.moveBefore(c,f)})}},sort:{undo:function(a){var c=b(a.path);c.hideChilds();c.childs=a.oldChilds;c.updateDom({updateIndexes:!0});c.showChilds()},redo:function(a){var c=b(a.path);c.hideChilds();c.childs=a.newChilds;c.updateDom({updateIndexes:!0});c.showChilds()}},transform:{undo:function(a){b(a.path).setInternalValue(a.oldValue)},redo:function(a){b(a.path).setInternalValue(a.newValue)}}}}p(a,
[{key:"onChange",value:function(){}},{key:"add",value:function(a,c){this.index++;this.history[this.index]={action:a,params:c,timestamp:new Date};this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1);this.onChange()}},{key:"clear",value:function(){this.history=[];this.index=-1;this.onChange()}},{key:"canUndo",value:function(){return 0<=this.index}},{key:"canRedo",value:function(){return this.index<this.history.length-1}},{key:"undo",value:function(){if(this.canUndo()){var a=
this.history[this.index];if(a){var c=this.actions[a.action];if(c&&c.undo){if(c.undo(a.params),a.params.oldSelection)try{this.editor.setDomSelection(a.params.oldSelection)}catch(N){console.error(N)}}else console.error(Error('unknown action "'+a.action+'"'))}this.index--;this.onChange()}}},{key:"redo",value:function(){if(this.canRedo()){this.index++;var a=this.history[this.index];if(a){var c=this.actions[a.action];if(c&&c.redo){if(c.redo(a.params),a.params.newSelection)try{this.editor.setDomSelection(a.params.newSelection)}catch(N){console.error(N)}}else console.error(Error('unknown action "'+
a.action+'"'))}this.onChange()}}},{key:"destroy",value:function(){this.editor=null;this.history=[];this.index=-1}}]);return a}(),U=function(){function a(c,b){if(!(this instanceof a))throw new TypeError("Cannot call a class as a function");var d=this;this.editor=c;this.timeout=void 0;this.delay=200;this.lastText=void 0;this.results=null;this.dom={};this.dom.container=b;c=document.createElement("div");this.dom.wrapper=c;c.className="jsoneditor-search";b.appendChild(c);b=document.createElement("div");
this.dom.results=b;b.className="jsoneditor-results";c.appendChild(b);b=document.createElement("div");this.dom.input=b;b.className="jsoneditor-frame";b.title=(0,z.Iu)("searchTitle");c.appendChild(b);c=document.createElement("button");c.type="button";c.className="jsoneditor-refresh";b.appendChild(c);var f=document.createElement("input");f.type="text";this.dom.search=f;f.oninput=function(a){d._onDelayedSearch(a)};f.onchange=function(a){d._onSearch()};f.onkeydown=function(a){d._onKeyDown(a)};f.onkeyup=
function(a){d._onKeyUp(a)};c.onclick=function(a){f.select()};b.appendChild(f);c=document.createElement("button");c.type="button";c.title=(0,z.Iu)("searchNextResultTitle");c.className="jsoneditor-next";c.onclick=function(){d.next()};b.appendChild(c);c=document.createElement("button");c.type="button";c.title=(0,z.Iu)("searchPreviousResultTitle");c.className="jsoneditor-previous";c.onclick=function(){d.previous()};b.appendChild(c)}u(a,[{key:"next",value:function(a){if(this.results){var c=null!==this.resultIndex?
this.resultIndex+1:0;c>this.results.length-1&&(c=0);this._setActiveResult(c,a)}}},{key:"previous",value:function(a){if(this.results){var c=this.results.length-1,b=null!==this.resultIndex?this.resultIndex-1:c;0>b&&(b=c);this._setActiveResult(b,a)}}},{key:"_setActiveResult",value:function(a,c){if(this.activeResult){var b=this.activeResult.node;"field"===this.activeResult.elem?delete b.searchFieldActive:delete b.searchValueActive;b.updateDom()}if(this.results&&this.results[a]){this.resultIndex=a;var d=
this.results[this.resultIndex].node,f=this.results[this.resultIndex].elem;"field"===f?d.searchFieldActive=!0:d.searchValueActive=!0;this.activeResult=this.results[this.resultIndex];d.updateDom();d.scrollTo(function(){c&&d.focus(f)})}else this.activeResult=this.resultIndex=void 0}},{key:"_clearDelay",value:function(){void 0!==this.timeout&&(clearTimeout(this.timeout),delete this.timeout)}},{key:"_onDelayedSearch",value:function(a){this._clearDelay();var c=this;this.timeout=setTimeout(function(a){c._onSearch()},
this.delay)}},{key:"_onSearch",value:function(a){this._clearDelay();var c=this.dom.search.value;c=0<c.length?c:void 0;if(c!==this.lastText||a){this.lastText=c;this.results=this.editor.search(c);a=this.results[0]?this.results[0].node.MAX_SEARCH_RESULTS:Infinity;var b=0;if(this.activeResult)for(var d=0;d<this.results.length;d++)if(this.results[d].node===this.activeResult.node){b=d;break}this._setActiveResult(b,!1);void 0!==c?(c=this.results.length,this.dom.results.textContent=0===c?"no\u00a0results":
1===c?"1\u00a0result":c>a?a+"+\u00a0results":c+"\u00a0results"):this.dom.results.textContent=""}}},{key:"_onKeyDown",value:function(a){var c=a.which;27===c?(this.dom.search.value="",this._onSearch(),a.preventDefault(),a.stopPropagation()):13===c&&(a.ctrlKey?this._onSearch(!0):a.shiftKey?this.previous():this.next(),a.preventDefault(),a.stopPropagation())}},{key:"_onKeyUp",value:function(a){var c=a.keyCode;27!==c&&13!==c&&this._onDelayedSearch(a)}},{key:"clear",value:function(){this.dom.search.value=
"";this._onSearch()}},{key:"forceSearch",value:function(){this._onSearch(!0)}},{key:"isEmpty",value:function(){return""===this.dom.search.value}},{key:"destroy",value:function(){this.editor=null;this.dom.container.removeChild(this.dom.wrapper);this.activeResult=this.results=this.dom=null;this._clearDelay()}}]);return a}(),R=function(){function a(c,b){if(!(this instanceof a))throw new TypeError("Cannot call a class as a function");c&&(this.root=b,this.path=document.createElement("div"),this.path.className=
"jsoneditor-treepath",this.path.setAttribute("tabindex",0),this.contentMenuClicked=!1,c.appendChild(this.path),this.reset())}A(a,[{key:"reset",value:function(){this.path.textContent=(0,z.Iu)("selectNode")}},{key:"setPath",value:function(a){function c(a){f.contentMenuClicked=!1;(0,B.addClassName)(f.path,"show-all");f.path.style.width=f.path.parentNode.getBoundingClientRect().width-10+"px";f.path.onblur=function(){f.contentMenuClicked?(f.contentMenuClicked=!1,f.path.focus()):((0,B.removeClassName)(f.path,
"show-all"),f.path.onblur=void 0,f.path.style.width="",f.setPath(a))}}function b(a){this.selectionCallback&&this.selectionCallback(a)}function d(a,c){this.contextMenuCallback&&this.contextMenuCallback(a,c)}var f=this;this.path.textContent="";a&&a.length&&a.forEach(function(g,l){var q=document.createElement("span");q.className="jsoneditor-treepath-element";q.innerText=g.name;q.onclick=b.bind(f,g);f.path.appendChild(q);if(g.children.length){var m=document.createElement("span");m.className="jsoneditor-treepath-seperator";
m.textContent="\u25ba";m.onclick=function(){f.contentMenuClicked=!0;var c=[];g.children.forEach(function(b){c.push({text:b.name,className:"jsoneditor-type-modes"+(a[l+1]+1&&a[l+1].name===b.name?" jsoneditor-selected":""),click:d.bind(f,g,b.name)})});(new n.x(c,{limitHeight:!0})).show(m,f.root,!0)};f.path.appendChild(m)}l===a.length-1&&(q=(m||q).getBoundingClientRect().right,f.path.offsetWidth<q&&(f.path.scrollLeft=q),f.path.scrollLeft&&(q=document.createElement("span"),q.className="jsoneditor-treepath-show-all-btn",
q.title="show all path",q.textContent="...",q.onclick=c.bind(f,a),f.path.insertBefore(q,f.path.firstChild)))})}},{key:"onSectionSelected",value:function(a){"function"===typeof a&&(this.selectionCallback=a)}},{key:"onContextMenuItemSelected",value:function(a){"function"===typeof a&&(this.contextMenuCallback=a)}}]);return a}();y=h(8037);var P=h.n(y);h={create:function(a,c){if(!a)throw Error("No container element provided.");this.container=a;this.dom={};this.highlighter=new K;this.selection=void 0;this.multiselection=
{nodes:[]};this.validateSchema=null;this.validationSequence=0;this.errorNodes=[];this.lastSchemaErrors=void 0;this.focusTarget=this.node=null;this._setOptions(c);c.autocomplete&&(this.autocomplete=b(c.autocomplete));this.options.history&&"view"!==this.options.mode&&(this.history=new O(this));this._createFrame();this._createTable()},destroy:function(){this.frame&&this.container&&this.frame.parentNode===this.container&&(this.container.removeChild(this.frame),this.frame=null);this.dom=this.container=
null;this.clear();this._debouncedValidate=this.validateSchema=this.errorNodes=this.multiselection=this.selection=this.focusTarget=this.node=null;this.history&&(this.history.destroy(),this.history=null);this.searchBox&&(this.searchBox.destroy(),this.searchBox=null);this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null);this.frameFocusTracker.destroy()},_setOptions:function(a){var c=this;this.options={search:!0,history:!0,mode:"tree",name:void 0,schema:null,schemaRefs:null,autocomplete:null,
navigationBar:!0,mainMenuBar:!0,limitDragging:!1,onSelectionChange:null,colorPicker:!0,onColorPicker:function(a,c,b){if(P()){var d=a.getBoundingClientRect().top;d=300>(0,B.getWindow)(a).innerHeight-d&&300<d;(new (P())({parent:a,color:c,popup:d?"top":"bottom",onDone:function(a){a=1===a.rgba[3]?a.hex.substr(0,7):a.hex;b(a)}})).show()}else console.warn("Cannot open color picker: the `vanilla-picker` library is not included in the bundle. Either use the full bundle or implement your own color picker using `onColorPicker`.")},
timestampTag:!0,timestampFormat:null,createQuery:H.r,executeQuery:H.J,onEvent:null,enableSort:!0,enableTransform:!0};a&&(Object.keys(a).forEach(function(b){c.options[b]=a[b]}),null==a.limitDragging&&null!=a.schema&&(this.options.limitDragging=!0));this.setSchema(this.options.schema,this.options.schemaRefs);this._debouncedValidate=(0,B.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL);if(a.onSelectionChange)this.onSelectionChange(a.onSelectionChange);(0,z.cC)(this.options.languages);(0,z.m0)(this.options.language)},
set:function(a){a instanceof Function||void 0===a?this.clear():(this.content.removeChild(this.table),a=new C(this,{field:this.options.name,value:a}),this._setRoot(a),this.validate(),this.node.expand(!1),this.content.appendChild(this.table));this.history&&this.history.clear();this.searchBox&&this.searchBox.clear()},update:function(a){if(!this.node.deepEqual(a)){var c=this.getSelection();this.onChangeDisabled=!0;this.node.update(a);this.onChangeDisabled=!1;this.validate();this.searchBox&&!this.searchBox.isEmpty()&&
this.searchBox.forceSearch();if(c&&c.start&&c.end){a=this.node.findNodeByPath(c.start.path);var b=this.node.findNodeByPath(c.end.path);a&&b?this.setSelection(c.start,c.end):this.setSelection({},{})}else this.setSelection({},{})}},get:function(){if(this.node)return this.node.getValue()},getText:function(){return JSON.stringify(this.get())},setText:function(a){try{this.set((0,B.parse)(a))}catch(T){a=(0,B.tryJsonRepair)(a),this.set((0,B.parse)(a))}},updateText:function(a){try{this.update((0,B.parse)(a))}catch(T){a=
(0,B.tryJsonRepair)(a),this.update((0,B.parse)(a))}},setName:function(a){this.options.name=a;this.node&&this.node.updateField(this.options.name)},getName:function(){return this.options.name},focus:function(){var a=this.scrollableContent.querySelector("[contenteditable=true]");a?a.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(a=this.frame.querySelector("button"))&&a.focus()},clear:function(){this.node&&(this.node.hide(),delete this.node);this.treePath&&
this.treePath.reset()},_setRoot:function(a){this.clear();this.node=a;a.setParent(null);a.setField(this.getName(),!1);delete a.index;this.tbody.appendChild(a.getDom())},search:function(a){this.node?(this.content.removeChild(this.table),a=this.node.search(a),this.content.appendChild(this.table)):a=[];return a},expandAll:function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},collapseAll:function(){this.node&&(this.content.removeChild(this.table),
this.node.collapse(),this.content.appendChild(this.table))},_onAction:function(a,c){this.history&&this.history.add(a,c);this._onChange()},_onChange:function(){if(!this.onChangeDisabled){this.selection=this.getDomSelection();this._debouncedValidate();if(this.treePath){var a=this.node&&this.selection?this.node.findNodeByInternalPath(this.selection.path):this.multiselection?this.multiselection.nodes[0]:void 0;a?this._updateTreePath(a.getNodePath()):this.treePath.reset()}if(this.options.onChange)try{this.options.onChange()}catch(T){console.error("Error in onChange callback: ",
T)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(T){console.error("Error in onChangeJSON callback: ",T)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(T){console.error("Error in onChangeText callback: ",T)}this.options.onClassName&&this.node.recursivelyUpdateCssClassesOnNodes();if(this.options.onNodeName&&this.node.childs)try{this.node.recursivelyUpdateNodeName()}catch(T){console.error("Error in onNodeName callback: ",T)}}},validate:function(){var a=
this,c=this.node;if(c){var b=c.getValue(),d=[];this.validateSchema&&(this.validateSchema(b)||(d=this.validateSchema.errors.map(function(a){return(0,B.improveSchemaError)(a)}).map(function(a){return{node:c.findNode(a.dataPath),error:a,type:"validation"}}).filter(function(a){return null!=a.node})));try{this.validationSequence++;var f=this,n=this.validationSequence;this._validateCustom(b).then(function(c){n===f.validationSequence&&(c=[].concat(d,c||[]),f._renderValidationErrors(c),"function"===typeof a.options.onValidationError&&
((0,B.isValidationErrorChanged)(c,a.lastSchemaErrors)&&a.options.onValidationError.call(a,c),a.lastSchemaErrors=c))})["catch"](function(a){console.error(a)})}catch(Y){console.error(Y)}}},_renderValidationErrors:function(a){this.errorNodes&&this.errorNodes.forEach(function(a){a.setError(null)});this.errorNodes=a.reduce(function(a,c){return c.node.findParents().filter(function(c){return!a.some(function(a){return a[0]===c})}).map(function(a){return[a,c.node]}).concat(a)},[]).map(function(a){return{node:a[0],
child:a[1],error:{message:"object"===a[0].type?(0,z.Iu)("containsInvalidProperties"):(0,z.Iu)("containsInvalidItems")}}}).concat(a).map(function(a){a.node.setError(a.error,a.child);return a.node})},_validateCustom:function(a){try{if(this.options.onValidate){var c=this.node,b=this.options.onValidate(a);return((0,B.isPromise)(b)?b:Promise.resolve(b)).then(function(a){return Array.isArray(a)?a.filter(function(a){var c=(0,B.isValidValidationError)(a);c||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',
a);return c}).map(function(a){try{var b=a&&a.path?c.findNodeByPath(a.path):null}catch(Y){}b||console.warn("Ignoring validation error: node not found. Path:",a.path,"Error:",a);return{node:b,error:a,type:"customValidation"}}).filter(function(a){return a&&a.node&&a.error&&a.error.message}):null})}}catch(N){return Promise.reject(N)}return Promise.resolve(null)},refresh:function(){this.node&&this.node.updateDom({recurse:!0})},startAutoScroll:function(a){var c=this,b=this.scrollableContent,d=(0,B.getAbsoluteTop)(b),
f=b.clientHeight,n=d+f;(this.autoScrollStep=a<d+24&&0<b.scrollTop?(d+24-a)/3:a>n-24&&f+b.scrollTop<b.scrollHeight?(n-24-a)/3:void 0)?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){c.autoScrollStep?b.scrollTop-=c.autoScrollStep:c.stopAutoScroll()},50)):this.stopAutoScroll()},stopAutoScroll:function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer);this.autoScrollStep&&delete this.autoScrollStep},setDomSelection:function(a){if(a)if("scrollTop"in
a&&this.scrollableContent&&(this.scrollableContent.scrollTop=a.scrollTop),a.paths){var c=this;a=a.paths.map(function(a){return c.node.findNodeByInternalPath(a)});this.select(a)}else{var b=a.path?this.node.findNodeByInternalPath(a.path):null,d=b&&a.domName?b.dom[a.domName]:null;a.range&&d?(a=Object.assign({},a.range,{container:d}),(0,B.setSelectionOffset)(a)):b&&b.focus()}},getDomSelection:function(){var a=C.getNodeFromTarget(this.focusTarget),c=this.focusTarget,b=a?Object.keys(a.dom).find(function(b){return a.dom[b]===
c}):null,d=(0,B.getSelectionOffset)();d&&"DIV"!==d.container.nodeName&&(d=null);d&&d.container!==c&&(d=null);d&&delete d.container;return{path:a?a.getInternalPath():null,domName:b,range:d,paths:0<this.multiselection.length?this.multiselection.nodes.map(function(a){return a.getInternalPath()}):null,scrollTop:this.scrollableContent?this.scrollableContent.scrollTop:0}},scrollTo:function(a,c){var b=this.scrollableContent;if(b){var d=this;d.animateTimeout&&(clearTimeout(d.animateTimeout),delete d.animateTimeout);
d.animateCallback&&(d.animateCallback(!1),delete d.animateCallback);var f=b.clientHeight,n=Math.min(Math.max(a-f/4,0),b.scrollHeight-f);(function Z(){var a=n-b.scrollTop;3<Math.abs(a)?(b.scrollTop+=a/3,d.animateCallback=c,d.animateTimeout=setTimeout(Z,50)):(c&&c(!0),b.scrollTop=n,delete d.animateTimeout,delete d.animateCallback)})()}else c&&c(!1)},_createFrame:function(){function a(a){c._onEvent&&c._onEvent(a)}this.frame=document.createElement("div");this.frame.className="jsoneditor jsoneditor-mode-"+
this.options.mode;this.container.appendChild(this.frame);this.contentOuter=document.createElement("div");this.contentOuter.className="jsoneditor-outer";var c=this;this.frameFocusTracker=new J.R({target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null});this.frame.onclick=function(c){var b=c.target;a(c);"BUTTON"===b.nodeName&&c.preventDefault()};this.frame.oninput=a;this.frame.onchange=a;this.frame.onkeydown=a;this.frame.onkeyup=a;this.frame.oncut=a;this.frame.onpaste=
a;this.frame.onmousedown=a;this.frame.onmouseup=a;this.frame.onmouseover=a;this.frame.onmouseout=a;(0,B.addEventListener)(this.frame,"focus",a,!0);(0,B.addEventListener)(this.frame,"blur",a,!0);this.frame.onfocusin=a;this.frame.onfocusout=a;if(this.options.mainMenuBar){(0,B.addClassName)(this.contentOuter,"has-main-menu-bar");this.menu=document.createElement("div");this.menu.className="jsoneditor-menu";this.frame.appendChild(this.menu);var b=document.createElement("button");b.type="button";b.className=
"jsoneditor-expand-all";b.title=(0,z.Iu)("expandAll");b.onclick=function(){c.expandAll()};this.menu.appendChild(b);b=document.createElement("button");b.type="button";b.title=(0,z.Iu)("collapseAll");b.className="jsoneditor-collapse-all";b.onclick=function(){c.collapseAll()};this.menu.appendChild(b);this.options.enableSort&&(b=document.createElement("button"),b.type="button",b.className="jsoneditor-sort",b.title=(0,z.Iu)("sortTitleShort"),b.onclick=function(){c.node.showSortModal()},this.menu.appendChild(b));
this.options.enableTransform&&(b=document.createElement("button"),b.type="button",b.title=(0,z.Iu)("transformTitleShort"),b.className="jsoneditor-transform",b.onclick=function(){c.node.showTransformModal()},this.menu.appendChild(b));if(this.history){var d=document.createElement("button");d.type="button";d.className="jsoneditor-undo jsoneditor-separator";d.title=(0,z.Iu)("undo");d.onclick=function(){c._onUndo()};this.menu.appendChild(d);this.dom.undo=d;var f=document.createElement("button");f.type=
"button";f.className="jsoneditor-redo";f.title=(0,z.Iu)("redo");f.onclick=function(){c._onRedo()};this.menu.appendChild(f);this.dom.redo=f;this.history.onChange=function(){d.disabled=!c.history.canUndo();f.disabled=!c.history.canRedo()};this.history.onChange()}if(this.options&&this.options.modes&&this.options.modes.length){var n=this;this.modeSwitcher=new E.x(this.menu,this.options.modes,this.options.mode,function(a){n.setMode(a);n.modeSwitcher.focus()})}this.options.search&&(this.searchBox=new U(this,
this.menu))}this.options.navigationBar&&(this.navBar=document.createElement("div"),this.navBar.className="jsoneditor-navigation-bar nav-bar-empty",this.frame.appendChild(this.navBar),this.treePath=new R(this.navBar,this.getPopupAnchor()),this.treePath.onSectionSelected(this._onTreePathSectionSelected.bind(this)),this.treePath.onContextMenuItemSelected(this._onTreePathMenuItemSelected.bind(this)))},_onUndo:function(){this.history&&(this.history.undo(),this._onChange())},_onRedo:function(){this.history&&
(this.history.redo(),this._onChange())},_onEvent:function(a){if(!C.targetIsColorPicker(a.target)){var c=C.getNodeFromTarget(a.target);"keydown"===a.type&&this._onKeyDown(a);c&&"focus"===a.type&&(this.focusTarget=a.target,this.options.autocomplete&&"focus"===this.options.autocomplete.trigger&&this._showAutoComplete(a.target));"mousedown"===a.type&&this._startDragDistance(a);"mousemove"!==a.type&&"mouseup"!==a.type&&"click"!==a.type||this._updateDragDistance(a);if(c&&this.options&&this.options.navigationBar&&
c&&("keydown"===a.type||"mousedown"===a.type)){var b=this;setTimeout(function(){b._updateTreePath(c.getNodePath())})}if(c&&c.selected){if("click"===a.type){if(a.target===c.dom.menu){this.showContextMenu(a.target);return}a.hasMoved||this.deselect()}if("mousedown"===a.type)C.onDragStart(this.multiselection.nodes,a)}else if("mousedown"===a.type&&(0,B.hasParentNode)(a.target,this.content))if(this.deselect(),c&&a.target===c.dom.drag)C.onDragStart(c,a);else(!c||a.target!==c.dom.field&&a.target!==c.dom.value&&
a.target!==c.dom.select)&&this._onMultiSelectStart(a);if(c)c.onEvent(a)}},_updateTreePath:function(a){function c(a){return a.parent?"array"===a.parent.type?a.index:a.field:a.field||a.type}if(a&&a.length){(0,B.removeClassName)(this.navBar,"nav-bar-empty");var b=[];a.forEach(function(a){var d={name:c(a),node:a,children:[]};a.childs&&a.childs.length&&a.childs.forEach(function(a){d.children.push({name:c(a),node:a})});b.push(d)});this.treePath.setPath(b)}else(0,B.addClassName)(this.navBar,"nav-bar-empty")},
_onTreePathSectionSelected:function(a){a&&a.node&&(a.node.expandTo(),a.node.focus())},_onTreePathMenuItemSelected:function(a,c){a&&a.children.length&&(a=a.children.find(function(a){return a.name===c}))&&a.node&&(this._updateTreePath(a.node.getNodePath()),a.node.expandTo(),a.node.focus())},_startDragDistance:function(a){this.dragDistanceEvent={initialTarget:a.target,initialPageX:a.pageX,initialPageY:a.pageY,dragDistance:0,hasMoved:!1}},_updateDragDistance:function(a){this.dragDistanceEvent||this._startDragDistance(a);
var c=a.pageX-this.dragDistanceEvent.initialPageX,b=a.pageY-this.dragDistanceEvent.initialPageY;this.dragDistanceEvent.dragDistance=Math.sqrt(c*c+b*b);this.dragDistanceEvent.hasMoved=this.dragDistanceEvent.hasMoved||10<this.dragDistanceEvent.dragDistance;a.dragDistance=this.dragDistanceEvent.dragDistance;a.hasMoved=this.dragDistanceEvent.hasMoved;return a.dragDistance},_onMultiSelectStart:function(a){var c=C.getNodeFromTarget(a.target);if("tree"===this.options.mode&&void 0===this.options.onEditable){this.multiselection=
{start:c||null,end:null,nodes:[]};this._startDragDistance(a);var b=this;this.mousemove||(this.mousemove=(0,B.addEventListener)(a.view,"mousemove",function(a){b._onMultiSelect(a)}));this.mouseup||(this.mouseup=(0,B.addEventListener)(a.view,"mouseup",function(a){b._onMultiSelectEnd(a)}));a.preventDefault()}},_onMultiSelect:function(a){a.preventDefault();this._updateDragDistance(a);if(a.hasMoved){if(a=C.getNodeFromTarget(a.target))null==this.multiselection.start&&(this.multiselection.start=a),this.multiselection.end=
a;this.deselect();a=this.multiselection.start;var c=this.multiselection.end||this.multiselection.start;a&&c&&(this.multiselection.nodes=this._findTopLevelNodes(a,c),this.multiselection.nodes&&this.multiselection.nodes.length&&(a=this.multiselection.nodes[0],this.multiselection.start===a||this.multiselection.start.isDescendantOf(a)?this.multiselection.direction="down":this.multiselection.direction="up"),this.select(this.multiselection.nodes))}},_onMultiSelectEnd:function(a){var c=this.multiselection.nodes[0];
c&&c.dom.menu&&c.dom.menu.focus();this.multiselection.start=null;this.multiselection.end=null;this.mousemove&&((0,B.removeEventListener)(a.view,"mousemove",this.mousemove),delete this.mousemove);this.mouseup&&((0,B.removeEventListener)(a.view,"mouseup",this.mouseup),delete this.mouseup)},deselect:function(a){var c=!!this.multiselection.nodes.length;this.multiselection.nodes.forEach(function(a){a.setSelected(!1)});this.multiselection.nodes=[];a&&(this.multiselection.start=null,this.multiselection.end=
null);c&&this._selectionChangedHandler&&this._selectionChangedHandler()},select:function(a){if(!Array.isArray(a))return this.select([a]);if(a){this.deselect();this.multiselection.nodes=a.slice(0);var c=a[0];a.forEach(function(a){a.expandPathToNode();a.setSelected(!0,a===c)});this._selectionChangedHandler&&(a=this.getSelection(),this._selectionChangedHandler(a.start,a.end))}},_findTopLevelNodes:function(a,c){a=a.getNodePath();for(var b=c.getNodePath(),d=0;d<a.length&&a[d]===b[d];)d++;c=a[d-1];a=a[d];
b=b[d];a&&b||(c.parent?(b=a=c,c=c.parent):(a=c.childs[0],b=c.childs[c.childs.length-1]));return c&&a&&b?(a=c.childs.indexOf(a),b=c.childs.indexOf(b),c.childs.slice(Math.min(a,b),Math.max(a,b)+1)):[]},_showAutoComplete:function(a){var c=C.getNodeFromTarget(a),b="";0<=a.className.indexOf("jsoneditor-value")&&(b="value");0<=a.className.indexOf("jsoneditor-field")&&(b="field");if(""!==b){var d=this;setTimeout(function(){if(c&&("focus"===d.options.autocomplete.trigger||0<a.innerText.length)){var f=d.options.autocomplete.getOptions(a.innerText,
c.getPath(),b,c.editor);if(null===f)d.autocomplete.hideDropDown();else if("function"===typeof f.then)f.then(function(c){null===c?d.autocomplete.hideDropDown():c.options?d.autocomplete.show(a,c.startFrom,c.options):d.autocomplete.show(a,0,c)})["catch"](function(a){console.error(a)});else f.options?d.autocomplete.show(a,f.startFrom,f.options):d.autocomplete.show(a,0,f)}else d.autocomplete.hideDropDown()},50)}},_onKeyDown:function(a){var c=a.which||a.keyCode,b=a.altKey,d=a.ctrlKey,f=a.metaKey,n=a.shiftKey,
g=!1,l=this.focusTarget;if(9===c){var q=this;setTimeout(function(){q.focusTarget!==l&&(0,B.selectContentEditable)(q.focusTarget)},0)}if(this.searchBox)if(d&&70===c)this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),g=!0;else if(114===c||d&&71===c)n?this.searchBox.previous(!0):this.searchBox.next(!0),g=!0;this.history&&(d&&!n&&90===c?(this._onUndo(),g=!0):d&&n&&90===c&&(this._onRedo(),g=!0));!this.options.autocomplete||g||d||b||f||1!==a.key.length&&8!==c&&46!==c||(g=!1,this._showAutoComplete(a.target));
g&&(a.preventDefault(),a.stopPropagation())},_createTable:function(){this.options.navigationBar&&(0,B.addClassName)(this.contentOuter,"has-nav-bar");this.scrollableContent=document.createElement("div");this.scrollableContent.className="jsoneditor-tree";this.contentOuter.appendChild(this.scrollableContent);this.content=document.createElement("div");this.content.className="jsoneditor-tree-inner";this.scrollableContent.appendChild(this.content);this.table=document.createElement("table");this.table.className=
"jsoneditor-tree";this.content.appendChild(this.table);this.colgroupContent=document.createElement("colgroup");if("tree"===this.options.mode){var a=document.createElement("col");a.width="24px";this.colgroupContent.appendChild(a)}a=document.createElement("col");a.width="24px";this.colgroupContent.appendChild(a);a=document.createElement("col");this.colgroupContent.appendChild(a);this.table.appendChild(this.colgroupContent);this.tbody=document.createElement("tbody");this.table.appendChild(this.tbody);
this.frame.appendChild(this.contentOuter)},showContextMenu:function(a,c){var b=[],d=this.multiselection.nodes.slice();b.push({text:(0,z.Iu)("duplicateText"),title:(0,z.Iu)("duplicateTitle"),className:"jsoneditor-duplicate",click:function(){C.onDuplicate(d)}});b.push({text:(0,z.Iu)("remove"),title:(0,z.Iu)("removeTitle"),className:"jsoneditor-remove",click:function(){C.onRemove(d)}});if(this.options.onCreateMenu){var f=d.map(function(a){return a.getPath()});b=this.options.onCreateMenu(b,{type:"multiple",
path:f[0],paths:f})}(new n.x(b,{close:c})).show(a,this.getPopupAnchor())},getPopupAnchor:function(){return this.options.popupAnchor||this.frame},getSelection:function(){var a={start:null,end:null};if(this.multiselection.nodes&&this.multiselection.nodes.length&&this.multiselection.nodes.length){var c=this.multiselection.nodes[0],b=this.multiselection.nodes[this.multiselection.nodes.length-1];"down"===this.multiselection.direction?(a.start=c.serialize(),a.end=b.serialize()):(a.start=b.serialize(),a.end=
c.serialize())}return a},onSelectionChange:function(a){"function"===typeof a&&(this._selectionChangedHandler=(0,B.debounce)(a,this.DEBOUNCE_INTERVAL))},setSelection:function(a,c){a&&a.dom&&a.range&&(console.warn("setSelection/getSelection usage for text selection is deprecated and should not be used, see documentation for supported selection options"),this.setDomSelection(a));a=this._getNodeInstancesByRange(a,c);a.forEach(function(a){a.expandTo()});this.select(a)},_getNodeInstancesByRange:function(a,
c){var b;if(a&&a.path){var d=this.node.findNodeByPath(a.path);c&&c.path&&(b=this.node.findNodeByPath(c.path))}var f=[];if(d instanceof C)if(b instanceof C&&b!==d)if(d.parent===b.parent){d.getIndex()<b.getIndex()?(a=d,c=b):(a=b,c=d);f.push(a);do a=a.nextSibling(),f.push(a);while(a&&a!==c)}else f=this._findTopLevelNodes(d,b);else f.push(d);return f},getNodesByRange:function(a,c){var b=[];this._getNodeInstancesByRange(a,c).forEach(function(a){b.push(a.serialize())});return b}};var X=[{mode:"tree",mixin:h,
data:"json"},{mode:"view",mixin:h,data:"json"},{mode:"form",mixin:h,data:"json"}]},2744:function(y,e,h){e.tryRequireAjv=function(){try{return h(8903)}catch(b){}}},9125:function(y,e,h){e.O=function(){try{h(4864)}catch(b){console.error(b)}}},9791:function(y,e,h){function b(a){"@babel/helpers - typeof";b="function"===typeof Symbol&&"symbol"===typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&"function"===typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?"symbol":typeof a};
return b(a)}function r(a){try{return JSON.parse(a)}catch(ra){throw x(a),ra;}}function t(a){try{return ja()(a)}catch(ra){return a}}function k(a){return a.replace(/[\u007F-\uFFFF]/g,function(a){return"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})}function x(a){"undefined"!==typeof wa?wa.parse(a):JSON.parse(a)}function g(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b]);return a}function d(a){for(var c in a)Object.prototype.hasOwnProperty.call(a,c)&&delete a[c];return a}
function a(a){return null===a?"null":void 0===a?"undefined":a instanceof Number||"number"===typeof a?"number":a instanceof String||"string"===typeof a?"string":a instanceof Boolean||"boolean"===typeof a?"boolean":a instanceof RegExp?"regexp":f(a)?"array":"object"}function c(a){return("string"===typeof a||a instanceof String)&&ea.test(a)}function f(a){return"[object Array]"===Object.prototype.toString.call(a)}function w(a){return a.ownerDocument.defaultView}function m(a){return a.getBoundingClientRect().left+
window.pageXOffset||document.scrollLeft||0}function p(a){return a.getBoundingClientRect().top+window.pageYOffset||document.scrollTop||0}function l(a,c){var b=a.className.split(" ");-1===b.indexOf(c)&&(b.push(c),a.className=b.join(" "))}function u(a){a.className=""}function v(a,c){var b=a.className.split(" ");c=b.indexOf(c);-1!==c&&(b.splice(c,1),a.className=b.join(" "))}function A(a){a=a.childNodes;for(var c=0,b=a.length;c<b;c++){var d=a[c];d.style&&d.removeAttribute("style");var f=d.attributes;if(f)for(var n=
f.length-1;0<=n;n--){var g=f[n];!0===g.specified&&d.removeAttribute(g.name)}A(d)}}function q(a){if(document.createRange){var c=document.createRange();c.selectNodeContents(a);c.collapse(!1);a=window.getSelection();a.removeAllRanges();a.addRange(c)}}function n(a){if(a&&"DIV"===a.nodeName&&window.getSelection&&document.createRange){var c=document.createRange();c.selectNodeContents(a);a=window.getSelection();a.removeAllRanges();a.addRange(c)}}function J(){if(window.getSelection){var a=window.getSelection();
if(a.getRangeAt&&a.rangeCount)return a.getRangeAt(0)}return null}function K(a){if(a&&window.getSelection){var c=window.getSelection();c.removeAllRanges();c.addRange(a)}}function z(){var a=J();return a&&"startOffset"in a&&"endOffset"in a&&a.startContainer&&a.startContainer===a.endContainer?{startOffset:a.startOffset,endOffset:a.endOffset,container:a.startContainer.parentNode}:null}function H(a){if(document.createRange&&window.getSelection&&window.getSelection()){var c=document.createRange();a.container.firstChild||
a.container.appendChild(document.createTextNode(""));c.setStart(a.container.firstChild,a.startOffset);c.setEnd(a.container.firstChild,a.endOffset);K(c)}}function E(a,c){void 0===c&&(c={_text:"",flush:function(){var a=this._text;this._text="";return a},set:function(a){this._text=a}});if(a.nodeValue)return a=a.nodeValue.replace(/\s*\n\s*/g,""),""!==a?c.flush()+a:"";if(a.hasChildNodes()){a=a.childNodes;for(var b="",d=0,f=a.length;d<f;d++){var n=a[d];if("DIV"===n.nodeName||"P"===n.nodeName){var g=a[d-
1];(g=g?g.nodeName:void 0)&&"DIV"!==g&&"P"!==g&&"BR"!==g&&(""!==b&&(b+="\n"),c.flush());b+=E(n,c);c.set("\n")}else"BR"===n.nodeName?(b+=c.flush(),c.set("\n")):b+=E(n,c)}return b}return""}function D(a,c){for(a=a?a.parentNode:void 0;a;){if(a===c)return!0;a=a.parentNode}return!1}function F(){if(-1===ua){var a=-1;"undefined"!==typeof navigator&&"Microsoft Internet Explorer"===navigator.appName&&null!=/MSIE ([0-9]+[.0-9]+)/.exec(navigator.userAgent)&&(a=parseFloat(RegExp.$1));ua=a}return ua}function B(){return"undefined"!==
typeof navigator&&-1!==navigator.userAgent.indexOf("Firefox")}function G(a,c,b,d){if(a.addEventListener)return void 0===d&&(d=!1),"mousewheel"===c&&B()&&(c="DOMMouseScroll"),a.addEventListener(c,b,d),b;if(a.attachEvent)return d=function(){return b.call(a,window.event)},a.attachEvent("on"+c,d),d}function M(a,c,b,d){a.removeEventListener?(void 0===d&&(d=!1),"mousewheel"===c&&B()&&(c="DOMMouseScroll"),a.removeEventListener(c,b,d)):a.detachEvent&&a.detachEvent("on"+c,b)}function I(a,c){for(a=a.parentNode;a;){if(a===
c)return!0;a=a.parentNode}return!1}function C(a){function c(){for(var c="";void 0!==a[f]&&/[\w$]/.test(a[f]);)c+=a[f],f++;if(""===c)throw Error("Invalid JSON path: property name expected at index "+f);return c}function b(c){for(var b="";void 0!==a[f]&&a[f]!==c;)b+=a[f],f++;if(a[f]!==c)throw Error("Invalid JSON path: unexpected end, character "+c+" expected");return b}for(var d=[],f=0;void 0!==a[f];)if("."===a[f])f++,d.push(c());else if("["===a[f]){f++;if("'"===a[f]||'"'===a[f]){var n=a[f];f++;d.push(b(n));
if(a[f]!==n)throw Error("Invalid JSON path: closing quote ' expected at index "+f);f++}else{n=b("]").trim();if(0===n.length)throw Error("Invalid JSON path: array value expected at index "+f);n="*"===n?n:JSON.parse(n);d.push(n)}if("]"!==a[f])throw Error("Invalid JSON path: closing bracket ] expected at index "+f);f++}else throw Error('Invalid JSON path: unexpected character "'+a[f]+'" at index '+f);return d}function L(a){return a.map(function(a){return"number"===typeof a?"["+a+"]":"string"===typeof a&&
a.match(/^[A-Za-z0-9_$]+$/)?"."+a:'["'+a+'"]'}).join("")}function Q(a){if("enum"===a.keyword&&Array.isArray(a.schema)){var c=a.schema;if(c){c=c.map(function(a){return JSON.stringify(a)});if(5<c.length){var b=["("+(c.length-5)+" more...)"];c=c.slice(0,5);c.push(b)}a.message="should be equal to one of: "+c.join(", ")}}"additionalProperties"===a.keyword&&(a.message="should NOT have additional property: "+a.params.additionalProperty);return a}function S(a){return a&&"function"===typeof a.then&&"function"===
typeof a["catch"]}function O(a){return"object"===b(a)&&Array.isArray(a.path)&&"string"===typeof a.message}function U(a,c,b){b=void 0!==b?b:0;return c.left-b>=a.left&&c.right+b<=a.right&&c.top-b>=a.top&&c.bottom+b<=a.bottom}function R(a,c,b){var d;return function(){var f=this,n=arguments,g=b&&!d;clearTimeout(d);d=setTimeout(function(){d=null;b||a.apply(f,n)},c);g&&a.apply(f,n)}}function P(a,c){for(var b=c.length,d=0,f=a.length,n=c.length;c.charAt(d)===a.charAt(d)&&d<b;)d++;for(;c.charAt(n-1)===a.charAt(f-
1)&&n>d&&0<f;)n--,f--;return{start:d,end:n}}function X(a){function c(c){var b=a.value.substring(0,c);c=(b.match(/\n/g)||[]).length+1;b=b.length-b.lastIndexOf("\n");return{row:c,column:b}}var b=0,d=0,f;if("number"===typeof a.selectionStart&&"number"===typeof a.selectionEnd)b=a.selectionStart,d=a.selectionEnd;else if((f=document.selection.createRange())&&f.parentElement()===a){var n=a.value.length;var g=a.value.replace(/\r\n/g,"\n");d=a.createTextRange();d.moveToBookmark(f.getBookmark());f=a.createTextRange();
f.collapse(!1);-1<d.compareEndPoints("StartToEnd",f)?b=d=n:(b=-d.moveStart("character",-n),b+=g.slice(0,b).split("\n").length-1,-1<d.compareEndPoints("EndToEnd",f)?d=n:(d=-d.moveEnd("character",-n),d+=g.slice(0,d).split("\n").length-1))}return{startIndex:b,endIndex:d,start:c(b),end:c(d)}}function ca(a,c,b){a=a.value||"";return 0<c&&0<b?(a=a.split("\n",c),c=Math.min(a.length,c),b=Math.min(a[c-1].length,b-1),b=1===c?b:b+1,a.slice(0,c-1).join("\n").length+b):-1}function T(a,c){var b=[];if(!c||!c.length)return b;
try{var d=za.parse(a)}catch(Da){return b}c.forEach(function(a){var c=C(a);c=ba(c);(c=d.pointers[c])&&b.push({path:a,line:c.key?c.key.line:c.value?c.value.line:0,column:c.key?c.key.column:c.value?c.value.column:0})});return b}function ba(a){return a.map(function(a){return"/"+String(a).replace(/~/g,"~0").replace(/\//g,"~1")}).join("")}function N(a){var c=document.createElement("div");c.style.color=a;return c.style.color.split(/\s+/).join("").toLowerCase()||null}function V(a){return!!N(a)}function aa(a,
c){if(!a)return"";var b="";a.title&&(b+=a.title);a.description&&(0<b.length&&(b+="\n"),b+=a.description);a["default"]&&(0<b.length&&(b+="\n\n"),b+=(0,xa.Iu)("default",void 0,c)+"\n",b+=JSON.stringify(a["default"],null,2));Array.isArray(a.examples)&&0<a.examples.length&&(0<b.length&&(b+="\n\n"),b+=(0,xa.Iu)("examples",void 0,c)+"\n",a.examples.forEach(function(c,d){b+=JSON.stringify(c,null,2);d!==a.examples.length-1&&(b+="\n")}));return b}function Y(a,c){for(var b=0;b<c.length&&void 0!==a&&null!==
a;b++)a=a[c[b]];return a}function Z(a,c){for(var b=a=a.replace(/ \(copy( \d+)?\)$/,""),d=1;-1!==c.indexOf(b);)b=a+" (copy"+(1<d?" "+d:"")+")",d++;return b}function ia(a,c){function b(a,c,d,f){if(!Array.isArray(a)&&!na(a)||f)c[d||""]=!0;na(a)&&Object.keys(a).forEach(function(n){b(a[n],c,d+"."+n,f)})}var d={};if(Array.isArray(a))for(var f=Math.min(a.length,Aa),n=0;n<f;n++)b(a[n],d,"",c);else d[""]=!0;return Object.keys(d).sort()}function la(a,c,b){var d=c&&"."!==c?C(c):[],f="desc"===b?-1:1;a=a.slice();
a.sort(function(a,c){a=Y(a,d);c=Y(c,d);return f*(a>c?1:a<c?-1:0)});return a}function ka(a,c){var b="desc"===c?-1:1,d={};Object.keys(a).sort(function(a,c){return b*qa()(a,c)}).forEach(function(c){d[c]=a[c]});return d}function da(a){if(""===a)return"";var c=a.toLowerCase();if("null"===c)return null;if("true"===c)return!0;if("false"===c)return!1;c=Number(a);var b=parseFloat(a);return isNaN(c)||isNaN(b)?a:c}function ya(a,c){return"number"===typeof c&&c>ta&&isFinite(c)&&Math.floor(c)===c&&!isNaN((new Date(c)).valueOf())}
function ha(a){if(900>a)return a.toFixed()+" B";a/=1E3;if(900>a)return a.toFixed(1)+" KB";a/=1E3;if(900>a)return a.toFixed(1)+" MB";a/=1E3;return 900>a?a.toFixed(1)+" GB":(a/1E3).toFixed(1)+" TB"}function ma(a,c){return a.length<=c?a:a.slice(0,c)+"..."}function na(a){return"object"===b(a)&&null!==a&&!Array.isArray(a)}function pa(a,c){return-1!==a.indexOf(c)}function sa(a,c){if(!c&&!a)return!1;if(c&&!a||!c&&a||c.length!==a.length)return!0;for(var d=function(b){var d=void 0;d="error"===a[b].type?c.find(function(c){return c.line===
a[b].line}):c.find(function(c){return c.dataPath===a[b].dataPath&&c.schemaPath===a[b].schemaPath});if(!d)return{v:!0}},f=0;f<a.length;++f){var n=d(f);if("object"===b(n))return n.v}return!1}h.r(e);h.d(e,{parse:function(){return r},tryJsonRepair:function(){return t},escapeUnicodeChars:function(){return k},validate:function(){return x},extend:function(){return g},clear:function(){return d},getType:function(){return a},isUrl:function(){return c},isArray:function(){return f},getWindow:function(){return w},
getAbsoluteLeft:function(){return m},getAbsoluteTop:function(){return p},addClassName:function(){return l},removeAllClassNames:function(){return u},removeClassName:function(){return v},stripFormatting:function(){return A},setEndOfContentEditable:function(){return q},selectContentEditable:function(){return n},getSelection:function(){return J},setSelection:function(){return K},getSelectionOffset:function(){return z},setSelectionOffset:function(){return H},getInnerText:function(){return E},hasParentNode:function(){return D},
getInternetExplorerVersion:function(){return F},isFirefox:function(){return B},addEventListener:function(){return G},removeEventListener:function(){return M},isChildOf:function(){return I},parsePath:function(){return C},stringifyPath:function(){return L},improveSchemaError:function(){return Q},isPromise:function(){return S},isValidValidationError:function(){return O},insideRect:function(){return U},debounce:function(){return R},textDiff:function(){return P},getInputSelection:function(){return X},
getIndexForPosition:function(){return ca},getPositionForPath:function(){return T},compileJSONPointer:function(){return ba},getColorCSS:function(){return N},isValidColor:function(){return V},makeFieldTooltip:function(){return aa},get:function(){return Y},findUniqueName:function(){return Z},getChildPaths:function(){return ia},sort:function(){return la},sortObjectKeys:function(){return ka},parseString:function(){return da},isTimestamp:function(){return ya},formatSize:function(){return ha},limitCharacters:function(){return ma},
isObject:function(){return na},contains:function(){return pa},isValidationErrorChanged:function(){return sa}});y=h(4987);h.n(y);y=h(233);var qa=h.n(y);y=h(8909);var ja=h.n(y),wa=h(6589),za=h(7026),xa=h(7907),Aa=1E4,ta=9466848E5,ea=/^https?:\/\/\S+$/,ua=-1},8037:function(y,e,h){if(window.Picker)var b=window.Picker;else try{b=h(4049)}catch(r){}y.exports=b},6225:function(y,e,h){y=h.nmd(y);(function(){var b=function(){return this}();b||"undefined"==typeof window||(b=window);var e=function(b,a,c){"string"!==
typeof b?e.original?e.original.apply(this,arguments):(console.error("dropping module because define wasn't a string."),console.trace()):(2==arguments.length&&(c=a),e.modules[b]||(e.payloads[b]=c,e.modules[b]=null))};e.modules={};e.payloads={};var h=function(b,a,c){if("string"===typeof a){if(b=g(b,a),void 0!=b)return c&&c(),b}else if("[object Array]"===Object.prototype.toString.call(a)){for(var d=[],w=0,m=a.length;w<m;++w){var e=g(b,a[w]);if(void 0==e&&k.original)return;d.push(e)}return c&&c.apply(null,
d)||!0}},k=function(b,a){var c=h("",b,a);return void 0==c&&k.original?k.original.apply(this,arguments):c},x=function(b,a){if(-1!==a.indexOf("!"))return a=a.split("!"),x(b,a[0])+"!"+x(b,a[1]);if("."==a.charAt(0))for(a=b.split("/").slice(0,-1).join("/")+"/"+a;-1!==a.indexOf(".")&&c!=a;){var c=a;a=a.replace(/\/\.\//,"/").replace(/[^\/]+\/\.\.\//,"")}return a},g=function(b,a){a=x(b,a);b=e.modules[a];if(!b){b=e.payloads[a];if("function"===typeof b){var c={},d={id:a,uri:"",exports:c,packaged:!0};c=b(function(c,
b){return h(a,c,b)},c,d)||d.exports;e.modules[a]=c;delete e.payloads[a]}b=e.modules[a]=c||b}return b};(function(d){var a=b;d&&(b[d]||(b[d]={}),a=b[d]);a.define&&a.define.packaged||(e.original=a.define,a.define=e,a.define.packaged=!0);a.require&&a.require.packaged||(k.original=a.require,a.require=k,a.require.packaged=!0)})("ace")})();ace.define("ace/lib/fixoldbrowsers",["require","exports","module"],function(b,e,h){"undefined"==typeof Element||Element.prototype.remove||Object.defineProperty(Element.prototype,
"remove",{enumerable:!1,writable:!0,configurable:!0,value:function(){this.parentNode&&this.parentNode.removeChild(this)}})});ace.define("ace/lib/useragent",["require","exports","module"],function(b,e,h){e.OS={LINUX:"LINUX",MAC:"MAC",WINDOWS:"WINDOWS"};e.getOS=function(){return e.isMac?e.OS.MAC:e.isLinux?e.OS.LINUX:e.OS.WINDOWS};var k="object"==typeof navigator?navigator:{};b=(/mac|win|linux/i.exec(k.platform)||["other"])[0].toLowerCase();h=k.userAgent||"";k=k.appName||"";e.isWin="win"==b;e.isMac=
"mac"==b;e.isLinux="linux"==b;e.isIE="Microsoft Internet Explorer"==k||0<=k.indexOf("MSAppHost")?parseFloat((h.match(/(?:MSIE |Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]):parseFloat((h.match(/(?:Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]);e.isOldIE=e.isIE&&9>e.isIE;e.isGecko=e.isMozilla=h.match(/ Gecko\/\d+/);e.isOpera="object"==typeof opera&&"[object Opera]"==Object.prototype.toString.call(window.opera);e.isWebKit=parseFloat(h.split("WebKit/")[1])||void 0;e.isChrome=parseFloat(h.split(" Chrome/")[1])||
void 0;e.isEdge=parseFloat(h.split(" Edge/")[1])||void 0;e.isAIR=0<=h.indexOf("AdobeAIR");e.isAndroid=0<=h.indexOf("Android");e.isChromeOS=0<=h.indexOf(" CrOS ");e.isIOS=/iPad|iPhone|iPod/.test(h)&&!window.MSStream;e.isIOS&&(e.isMac=!0);e.isMobile=e.isIOS||e.isAndroid});ace.define("ace/lib/dom",["require","exports","module","ace/lib/useragent"],function(b,e,h){b=b("./useragent");e.buildDom=function a(b,g,d){if("string"==typeof b&&b)return b=document.createTextNode(b),g&&g.appendChild(b),b;if(!Array.isArray(b))return b&&
b.appendChild&&g&&g.appendChild(b),b;if("string"!=typeof b[0]||!b[0]){for(var c=[],f=0;f<b.length;f++){var e=a(b[f],g,d);e&&c.push(e)}return c}var m=document.createElement(b[0]),p=b[1];c=1;p&&"object"==typeof p&&!Array.isArray(p)&&(c=2);for(f=c;f<b.length;f++)a(b[f],m,d);2==c&&Object.keys(p).forEach(function(a){var c=p[a];"class"===a?m.className=Array.isArray(c)?c.join(" "):c:"function"==typeof c||"value"==a||"$"==a[0]?m[a]=c:"ref"===a?d&&(d[c]=m):null!=c&&m.setAttribute(a,c)});g&&g.appendChild(m);
return m};e.getDocumentHead=function(b){b||(b=document);return b.head||b.getElementsByTagName("head")[0]||b.documentElement};e.createElement=function(b,g){return document.createElementNS?document.createElementNS(g||"http://www.w3.org/1999/xhtml",b):document.createElement(b)};e.removeChildren=function(b){b.innerHTML=""};e.createTextNode=function(b,g){return(g?g.ownerDocument:document).createTextNode(b)};e.createFragment=function(b){return(b?b.ownerDocument:document).createDocumentFragment()};e.hasCssClass=
function(b,g){return-1!==(b.className+"").split(/\s+/g).indexOf(g)};e.addCssClass=function(b,g){e.hasCssClass(b,g)||(b.className+=" "+g)};e.removeCssClass=function(b,g){for(var d=b.className.split(/\s+/g);;){var a=d.indexOf(g);if(-1==a)break;d.splice(a,1)}b.className=d.join(" ")};e.toggleCssClass=function(b,g){for(var d=b.className.split(/\s+/g),a=!0;;){var c=d.indexOf(g);if(-1==c)break;a=!1;d.splice(c,1)}a&&d.push(g);b.className=d.join(" ");return a};e.setCssClass=function(b,g,d){d?e.addCssClass(b,
g):e.removeCssClass(b,g)};e.hasCssString=function(b,g){var d=0;g=g||document;if(g=g.querySelectorAll("style"))for(;d<g.length;)if(g[d++].id===b)return!0};e.importCssString=function(b,g,d){var a;d&&d.getRootNode?(a=d.getRootNode())&&a!=d||(a=document):a=document;d=a.ownerDocument||a;if(g&&e.hasCssString(g,a))return null;g&&(b+="\n/*# sourceURL=ace/css/"+g+" */");var c=e.createElement("style");c.appendChild(d.createTextNode(b));g&&(c.id=g);a==d&&(a=e.getDocumentHead(d));a.insertBefore(c,a.firstChild)};
e.importCssStylsheet=function(b,g){e.buildDom(["link",{rel:"stylesheet",href:b}],e.getDocumentHead(g))};e.scrollbarWidth=function(b){var g=e.createElement("ace_inner");g.style.width="100%";g.style.minWidth="0px";g.style.height="200px";g.style.display="block";var d=e.createElement("ace_outer"),a=d.style;a.position="absolute";a.left="-10000px";a.overflow="hidden";a.width="200px";a.minWidth="0px";a.height="150px";a.display="block";d.appendChild(g);b=b.documentElement;b.appendChild(d);var c=g.offsetWidth;
a.overflow="scroll";g=g.offsetWidth;c==g&&(g=d.clientWidth);b.removeChild(d);return c-g};"undefined"==typeof document&&(e.importCssString=function(){});e.computedStyle=function(b,g){return window.getComputedStyle(b,"")||{}};e.setStyle=function(b,g,d){b[g]!==d&&(b[g]=d)};e.HAS_CSS_ANIMATION=!1;e.HAS_CSS_TRANSFORMS=!1;e.HI_DPI=b.isWin?"undefined"!==typeof window&&1.5<=window.devicePixelRatio:!0;"undefined"!==typeof document&&(h=document.createElement("div"),e.HI_DPI&&void 0!==h.style.transform&&(e.HAS_CSS_TRANSFORMS=
!0),b.isEdge||"undefined"===typeof h.style.animationName||(e.HAS_CSS_ANIMATION=!0),h=null);e.translate=e.HAS_CSS_TRANSFORMS?function(b,g,d){b.style.transform="translate("+Math.round(g)+"px, "+Math.round(d)+"px)"}:function(b,g,d){b.style.top=Math.round(d)+"px";b.style.left=Math.round(g)+"px"}});ace.define("ace/lib/oop",["require","exports","module"],function(b,e,h){e.inherits=function(b,e){b.super_=e;b.prototype=Object.create(e.prototype,{constructor:{value:b,enumerable:!1,writable:!0,configurable:!0}})};
e.mixin=function(b,e){for(var g in e)b[g]=e[g];return b};e.implement=function(b,x){e.mixin(b,x)}});ace.define("ace/lib/keys",["require","exports","module","ace/lib/oop"],function(b,e,h){var k=b("./oop"),x=function(){var b={MODIFIER_KEYS:{16:"Shift",17:"Ctrl",18:"Alt",224:"Meta",91:"MetaLeft",92:"MetaRight",93:"ContextMenu"},KEY_MODS:{ctrl:1,alt:2,option:2,shift:4,"super":8,meta:8,command:8,cmd:8,control:1},FUNCTION_KEYS:{8:"Backspace",9:"Tab",13:"Return",19:"Pause",27:"Esc",32:"Space",33:"PageUp",
34:"PageDown",35:"End",36:"Home",37:"Left",38:"Up",39:"Right",40:"Down",44:"Print",45:"Insert",46:"Delete",96:"Numpad0",97:"Numpad1",98:"Numpad2",99:"Numpad3",100:"Numpad4",101:"Numpad5",102:"Numpad6",103:"Numpad7",104:"Numpad8",105:"Numpad9","-13":"NumpadEnter",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"Numlock",145:"Scrolllock"},PRINTABLE_KEYS:{32:" ",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",59:";",
61:"=",65:"a",66:"b",67:"c",68:"d",69:"e",70:"f",71:"g",72:"h",73:"i",74:"j",75:"k",76:"l",77:"m",78:"n",79:"o",80:"p",81:"q",82:"r",83:"s",84:"t",85:"u",86:"v",87:"w",88:"x",89:"y",90:"z",107:"+",109:"-",110:".",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",111:"/",106:"*"}},d;for(d in b.FUNCTION_KEYS){var a=b.FUNCTION_KEYS[d].toLowerCase();b[a]=parseInt(d,10)}for(d in b.PRINTABLE_KEYS)a=b.PRINTABLE_KEYS[d].toLowerCase(),b[a]=parseInt(d,10);k.mixin(b,b.MODIFIER_KEYS);
k.mixin(b,b.PRINTABLE_KEYS);k.mixin(b,b.FUNCTION_KEYS);b.enter=b["return"];b.escape=b.esc;b.del=b["delete"];b[173]="-";(function(){for(var a=["cmd","ctrl","alt","shift"],d=Math.pow(2,a.length);d--;)b.KEY_MODS[d]=a.filter(function(a){return d&b.KEY_MODS[a]}).join("-")+"-"})();b.KEY_MODS[0]="";b.KEY_MODS[-1]="input-";return b}();k.mixin(e,x);e.keyCodeToString=function(b){var d=x[b];"string"!=typeof d&&(d=String.fromCharCode(b));return d.toLowerCase()}});ace.define("ace/lib/event",["require","exports",
"module","ace/lib/keys","ace/lib/useragent"],function(b,e,h){function k(){p=!1;try{document.createComment("").addEventListener("test",function(){},{get passive(){p={passive:!1}}})}catch(q){}}function x(){void 0==p&&k();return p}function g(a,c,b){this.elem=a;this.type=c;this.callback=b}function d(a,b,d){var n=v(b);if(!f.isMac&&w){b.getModifierState&&(b.getModifierState("OS")||b.getModifierState("Win"))&&(n|=8);if(w.altGr)if(3!=(3&n))w.altGr=0;else return;if(18===d||17===d){var g="location"in b?b.location:
b.keyLocation;17===d&&1===g?1==w[d]&&(m=b.timeStamp):18===d&&3===n&&2===g&&50>b.timeStamp-m&&(w.altGr=!0)}}d in c.MODIFIER_KEYS&&(d=-1);if(!n&&13===d&&(g="location"in b?b.location:b.keyLocation,3===g&&(a(b,n,-d),b.defaultPrevented)))return;if(f.isChromeOS&&n&8){a(b,n,d);if(b.defaultPrevented)return;n&=-9}return n||d in c.FUNCTION_KEYS||d in c.PRINTABLE_KEYS?a(b,n,d):!1}function a(){w=Object.create(null)}var c=b("./keys"),f=b("./useragent"),w=null,m=0,p;g.prototype.destroy=function(){u(this.elem,this.type,
this.callback);this.elem=this.type=this.callback=void 0};var l=e.addListener=function(a,c,b,d){a.addEventListener(c,b,x());d&&d.$toDestroy.push(new g(a,c,b))},u=e.removeListener=function(a,c,b){a.removeEventListener(c,b,x())};e.stopEvent=function(a){e.stopPropagation(a);e.preventDefault(a);return!1};e.stopPropagation=function(a){a.stopPropagation&&a.stopPropagation()};e.preventDefault=function(a){a.preventDefault&&a.preventDefault()};e.getButton=function(a){return"dblclick"==a.type?0:"contextmenu"==
a.type||f.isMac&&a.ctrlKey&&!a.altKey&&!a.shiftKey?2:a.button};e.capture=function(a,c,b){function d(a){c&&c(a);b&&b(a);u(f,"mousemove",c);u(f,"mouseup",d);u(f,"dragstart",d)}var f=a&&a.ownerDocument||document;l(f,"mousemove",c);l(f,"mouseup",d);l(f,"dragstart",d);return d};e.addMouseWheelListener=function(a,c,b){"onmousewheel"in a?l(a,"mousewheel",function(a){void 0!==a.wheelDeltaX?(a.wheelX=-a.wheelDeltaX/8,a.wheelY=-a.wheelDeltaY/8):(a.wheelX=0,a.wheelY=-a.wheelDelta/8);c(a)},b):"onwheel"in a?l(a,
"wheel",function(a){switch(a.deltaMode){case a.DOM_DELTA_PIXEL:a.wheelX=.35*a.deltaX||0;a.wheelY=.35*a.deltaY||0;break;case a.DOM_DELTA_LINE:case a.DOM_DELTA_PAGE:a.wheelX=5*(a.deltaX||0),a.wheelY=5*(a.deltaY||0)}c(a)},b):l(a,"DOMMouseScroll",function(a){a.axis&&a.axis==a.HORIZONTAL_AXIS?(a.wheelX=5*(a.detail||0),a.wheelY=0):(a.wheelX=0,a.wheelY=5*(a.detail||0));c(a)},b)};e.addMultiMouseDownListener=function(a,c,b,d,g){function n(a){0!==e.getButton(a)?q=0:1<a.detail?(q++,4<q&&(q=1)):q=1;if(f.isIE){var n=
5<Math.abs(a.clientX-m)||5<Math.abs(a.clientY-v);if(!w||n)q=1;w&&clearTimeout(w);w=setTimeout(function(){w=null},c[q-1]||600);1==q&&(m=a.clientX,v=a.clientY)}a._clicks=q;b[d]("mousedown",a);if(4<q)q=0;else if(1<q)return b[d](p[q],a)}var q=0,m,v,w,p={2:"dblclick",3:"tripleclick",4:"quadclick"};Array.isArray(a)||(a=[a]);a.forEach(function(a){l(a,"mousedown",n,g)})};var v=function(a){return 0|(a.ctrlKey?1:0)|(a.altKey?2:0)|(a.shiftKey?4:0)|(a.metaKey?8:0)};e.getModifierString=function(a){return c.KEY_MODS[v(a)]};
e.addCommandKeyListener=function(c,b,g){if(f.isOldGecko||f.isOpera&&!("KeyboardEvent"in window)){var n=null;l(c,"keydown",function(a){n=a.keyCode},g);l(c,"keypress",function(a){return d(b,a,n)},g)}else{var m=null;l(c,"keydown",function(a){w[a.keyCode]=(w[a.keyCode]||0)+1;var c=d(b,a,a.keyCode);m=a.defaultPrevented;return c},g);l(c,"keypress",function(a){m&&(a.ctrlKey||a.altKey||a.shiftKey||a.metaKey)&&(e.stopEvent(a),m=null)},g);l(c,"keyup",function(a){w[a.keyCode]=null},g);w||(a(),l(window,"focus",
a))}};if("object"==typeof window&&window.postMessage&&!f.isOldIE){var A=1;e.nextTick=function(a,c){c=c||window;var b="zero-timeout-message-"+A++,d=function(f){f.data==b&&(e.stopPropagation(f),u(c,"message",d),a())};l(c,"message",d);c.postMessage(b,"*")}}e.$idleBlocked=!1;e.onIdle=function(a,c){return setTimeout(function K(){e.$idleBlocked?setTimeout(K,100):a()},c)};e.$idleBlockId=null;e.blockIdle=function(a){e.$idleBlockId&&clearTimeout(e.$idleBlockId);e.$idleBlocked=!0;e.$idleBlockId=setTimeout(function(){e.$idleBlocked=
!1},a||100)};e.nextFrame="object"==typeof window&&(window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||window.oRequestAnimationFrame);e.nextFrame=e.nextFrame?e.nextFrame.bind(window):function(a){setTimeout(a,17)}});ace.define("ace/range",["require","exports","module"],function(b,e,h){var k=function(b,g,d,a){this.start={row:b,column:g};this.end={row:d,column:a}};(function(){this.isEqual=function(b){return this.start.row===
b.start.row&&this.end.row===b.end.row&&this.start.column===b.start.column&&this.end.column===b.end.column};this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"};this.contains=function(b,g){return 0==this.compare(b,g)};this.compareRange=function(b){var g=b.end;b=b.start;g=this.compare(g.row,g.column);if(1==g)return g=this.compare(b.row,b.column),1==g?2:0==g?1:0;if(-1==g)return-2;g=this.compare(b.row,b.column);return-1==g?-1:1==
g?42:0};this.comparePoint=function(b){return this.compare(b.row,b.column)};this.containsRange=function(b){return 0==this.comparePoint(b.start)&&0==this.comparePoint(b.end)};this.intersects=function(b){b=this.compareRange(b);return-1==b||0==b||1==b};this.isEnd=function(b,g){return this.end.row==b&&this.end.column==g};this.isStart=function(b,g){return this.start.row==b&&this.start.column==g};this.setStart=function(b,g){"object"==typeof b?(this.start.column=b.column,this.start.row=b.row):(this.start.row=
b,this.start.column=g)};this.setEnd=function(b,g){"object"==typeof b?(this.end.column=b.column,this.end.row=b.row):(this.end.row=b,this.end.column=g)};this.inside=function(b,g){return 0!=this.compare(b,g)||this.isEnd(b,g)||this.isStart(b,g)?!1:!0};this.insideStart=function(b,g){return 0!=this.compare(b,g)||this.isEnd(b,g)?!1:!0};this.insideEnd=function(b,g){return 0!=this.compare(b,g)||this.isStart(b,g)?!1:!0};this.compare=function(b,g){return this.isMultiLine()||b!==this.start.row?b<this.start.row?
-1:b>this.end.row?1:this.start.row===b?g>=this.start.column?0:-1:this.end.row===b?g<=this.end.column?0:1:0:g<this.start.column?-1:g>this.end.column?1:0};this.compareStart=function(b,g){return this.start.row==b&&this.start.column==g?-1:this.compare(b,g)};this.compareEnd=function(b,g){return this.end.row==b&&this.end.column==g?1:this.compare(b,g)};this.compareInside=function(b,g){return this.end.row==b&&this.end.column==g?1:this.start.row==b&&this.start.column==g?-1:this.compare(b,g)};this.clipRows=
function(b,g){if(this.end.row>g)var d={row:g+1,column:0};else this.end.row<b&&(d={row:b,column:0});if(this.start.row>g)var a={row:g+1,column:0};else this.start.row<b&&(a={row:b,column:0});return k.fromPoints(a||this.start,d||this.end)};this.extend=function(b,g){var d=this.compare(b,g);if(0==d)return this;if(-1==d)var a={row:b,column:g};else var c={row:b,column:g};return k.fromPoints(a||this.start,c||this.end)};this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column};
this.isMultiLine=function(){return this.start.row!==this.end.row};this.clone=function(){return k.fromPoints(this.start,this.end)};this.collapseRows=function(){return 0==this.end.column?new k(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new k(this.start.row,0,this.end.row,0)};this.toScreenRange=function(b){var g=b.documentToScreenPosition(this.start);b=b.documentToScreenPosition(this.end);return new k(g.row,g.column,b.row,b.column)};this.moveBy=function(b,g){this.start.row+=b;this.start.column+=
g;this.end.row+=b;this.end.column+=g}}).call(k.prototype);k.fromPoints=function(b,g){return new k(b.row,b.column,g.row,g.column)};k.comparePoints=function(b,g){return b.row-g.row||b.column-g.column};k.comparePoints=function(b,g){return b.row-g.row||b.column-g.column};e.Range=k});ace.define("ace/lib/lang",["require","exports","module"],function(b,e,h){e.last=function(b){return b[b.length-1]};e.stringReverse=function(b){return b.split("").reverse().join("")};e.stringRepeat=function(b,d){for(var a="";0<
d;)if(d&1&&(a+=b),d>>=1)b+=b;return a};var k=/^\s\s*/,x=/\s\s*$/;e.stringTrimLeft=function(b){return b.replace(k,"")};e.stringTrimRight=function(b){return b.replace(x,"")};e.copyObject=function(b){var d={},a;for(a in b)d[a]=b[a];return d};e.copyArray=function(b){for(var d=[],a=0,c=b.length;a<c;a++)d[a]=b[a]&&"object"==typeof b[a]?this.copyObject(b[a]):b[a];return d};e.deepCopy=function a(b){if("object"!==typeof b||!b)return b;if(Array.isArray(b)){var c=[];for(var d=0;d<b.length;d++)c[d]=a(b[d]);return c}if("[object Object]"!==
Object.prototype.toString.call(b))return b;c={};for(d in b)c[d]=a(b[d]);return c};e.arrayToMap=function(b){for(var a={},c=0;c<b.length;c++)a[b[c]]=1;return a};e.createMap=function(b){var a=Object.create(null),c;for(c in b)a[c]=b[c];return a};e.arrayRemove=function(b,a){for(var c=0;c<=b.length;c++)a===b[c]&&b.splice(c,1)};e.escapeRegExp=function(b){return b.replace(/([.*+?^${}()|[\]\/\\])/g,"\\$1")};e.escapeHTML=function(b){return(""+b).replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/'/g,"&#39;").replace(/</g,
"&#60;")};e.getMatchOffsets=function(b,a){var c=[];b.replace(a,function(a){c.push({offset:arguments[arguments.length-2],length:a.length})});return c};e.deferredCall=function(b){var a=null,c=function(){a=null;b()},d=function(b){d.cancel();a=setTimeout(c,b||0);return d};d.schedule=d;d.call=function(){this.cancel();b();return d};d.cancel=function(){clearTimeout(a);a=null;return d};d.isPending=function(){return a};return d};e.delayedCall=function(b,a){var c=null,d=function(){c=null;b()},e=function(b){null==
c&&(c=setTimeout(d,b||a))};e.delay=function(b){c&&clearTimeout(c);c=setTimeout(d,b||a)};e.schedule=e;e.call=function(){this.cancel();b()};e.cancel=function(){c&&clearTimeout(c);c=null};e.isPending=function(){return c};return e}});ace.define("ace/clipboard",["require","exports","module"],function(b,e,h){var k;h.exports={lineMode:!1,pasteCancelled:function(){return k&&k>Date.now()-50?!0:k=!1},cancel:function(){k=Date.now()}}});ace.define("ace/keyboard/textinput","require exports module ace/lib/event ace/lib/useragent ace/lib/dom ace/lib/lang ace/clipboard ace/lib/keys".split(" "),
function(b,e,h){var k=b("../lib/event"),x=b("../lib/useragent"),g=b("../lib/dom"),d=b("../lib/lang"),a=b("../clipboard"),c=18>x.isChrome,f=x.isIE,w=63<x.isChrome,m=b("../lib/keys"),p=m.KEY_MODS,l=x.isIOS,u=l?/\s/:/\n/,v=x.isMobile;e.TextInput=function(b,q){function n(){y=!0;z.blur();z.focus();y=!1}function e(){clearTimeout(ia);ia=setTimeout(function(){B&&(z.style.cssText=B,B="");q.renderer.$isMousePressed=!1;q.renderer.$keepTextAreaAtCursor&&q.renderer.$moveTextAreaToCursor()},0)}function A(a,c,b){var d=
null,f=!1;b.addEventListener("keydown",function(a){d&&clearTimeout(d);f=!0},!0);b.addEventListener("keyup",function(a){d=setTimeout(function(){f=!1},100)},!0);var n=function(a){if(document.activeElement===b&&!(f||h||c.$mouseHandler.isMousePressed||H)){a=b.selectionStart;var d=b.selectionEnd,n=null,g=0;if(0==a)n=m.up;else if(1==a)n=m.home;else if(d>L&&"\n"==I[d])n=m.end;else if(a<C&&" "==I[a-1])n=m.left,g=p.option;else if(a<C||a==C&&L!=C&&a==d)n=m.left;else if(d>L&&2<I.slice(0,d).split("\n").length)n=
m.down;else if(d>L&&" "==I[d-1])n=m.right,g=p.option;else if(d>L||d==L&&L!=C&&a==d)n=m.right;a!==d&&(g|=p.shift);n&&(!c.onCommandKey({},g,n)&&c.commands&&(n=m.keyCodeToString(n),(n=c.commands.findKeyCommand(g,n))&&c.execCommand(n)),C=a,L=d,O(""))}};document.addEventListener("selectionchange",n);c.on("destroy",function(){document.removeEventListener("selectionchange",n)})}var z=g.createElement("textarea");z.className="ace_text-input";z.setAttribute("wrap","off");z.setAttribute("autocorrect","off");
z.setAttribute("autocapitalize","off");z.setAttribute("spellcheck",!1);z.style.opacity="0";b.insertBefore(z,b.firstChild);var H=!1,r=!1,h=!1,t=!1,B="";v||(z.style.fontSize="1px");var G=!1,y=!1,I="",C=0,L=0,Q=0;try{var S=document.activeElement===z}catch(ka){}k.addListener(z,"blur",function(a){y||(q.onBlur(a),S=!1)},q);k.addListener(z,"focus",function(a){if(!y){S=!0;if(x.isEdge)try{if(!document.hasFocus())return}catch(da){}q.onFocus(a);x.isEdge?setTimeout(O):O()}},q);this.$focusScroll=!1;this.focus=
function(){if(B||w||"browser"==this.$focusScroll)return z.focus({preventScroll:!0});var a=z.style.top;z.style.position="fixed";z.style.top="0px";try{var c=0!=z.getBoundingClientRect().top}catch(ma){return}var b=[];if(c)for(var d=z.parentElement;d&&1==d.nodeType;)b.push(d),d.setAttribute("ace_nocontext",!0),d=!d.parentElement&&d.getRootNode?d.getRootNode().host:d.parentElement;z.focus({preventScroll:!0});c&&b.forEach(function(a){a.removeAttribute("ace_nocontext")});setTimeout(function(){z.style.position=
"";"0px"==z.style.top&&(z.style.top=a)},0)};this.blur=function(){z.blur()};this.isFocused=function(){return S};q.on("beforeEndOperation",function(){var a=q.curOp,c=a&&a.command&&a.command.name;"insertstring"!=c&&(a=c&&(a.docChanged||a.selectionChanged),h&&a&&(I=z.value="",Y()),O())});var O=l?function(a){if(S&&(!H||a)&&!t){a||(a="");var c="\n ab"+a+"cde fg\n";c!=z.value&&(z.value=I=c);a=4+(a.length||(q.selection.isEmpty()?0:1));4==C&&L==a||z.setSelectionRange(4,a);C=4;L=a}}:function(){if(!h&&!t&&(S||
R)){h=!0;var a=0,c=0,b="";if(q.session){a=q.selection;var d=a.getRange(),f=a.cursor.row;a=d.start.column;c=d.end.column;b=q.session.getLine(f);if(d.start.row!=f){var n=q.session.getLine(f-1);a=d.start.row<f-1?0:a;c+=n.length+1;b=n+"\n"+b}else d.end.row!=f?(n=q.session.getLine(f+1),c=d.end.row>f+1?n.length:c,c+=b.length+1,b=b+"\n"+n):v&&0<f&&(b="\n"+b,c+=1,a+=1);400<b.length&&(400>a&&400>c?b=b.slice(0,400):(b="\n",a==c?a=c=0:(a=0,c=1)))}d=b+"\n\n";d!=I&&(z.value=I=d,C=L=d.length);R&&(C=z.selectionStart,
L=z.selectionEnd);if(L!=c||C!=a||z.selectionEnd!=L)try{z.setSelectionRange(a,c),C=a,L=c}catch(pa){}h=!1}};this.resetSelection=O;if(S)q.onFocus();var U=null;this.setInputHandler=function(a){U=a};this.getInputHandler=function(){return U};var R=!1,P=function(a,c){R&&(R=!1);if(r){O();if(a)q.onPaste(a);r=!1;return""}for(var b=z.selectionStart,d=z.selectionEnd,f=C,n=I.length-L,g,l=a.length-b,m=a.length-d,e=0;0<f&&I[e]==a[e];)e++,f--;g=a.slice(e);for(e=1;0<n&&I.length-e>C-1&&I[I.length-e]==a[a.length-e];)e++,
n--;l-=e-1;m-=e-1;e=g.length-e+1;0>e&&(f=-e,e=0);g=g.slice(0,e);if(!(c||g||l||f||n||m))return"";t=!0;c=!1;x.isAndroid&&". "==g&&(g="  ",c=!0);if(g&&!f&&!n&&!l&&!m||G)q.onTextInput(g);else q.onTextInput(g,{extendLeft:f,extendRight:n,restoreStart:l,restoreEnd:m});t=!1;I=a;C=b;L=d;Q=m;return c?"\n":g},X=function(a){if(h)return aa();if(a&&a.inputType){if("historyUndo"==a.inputType)return q.execCommand("undo");if("historyRedo"==a.inputType)return q.execCommand("redo")}a=z.value;var c=P(a,!0);(500<a.length||
u.test(c)||v&&1>C&&C==L)&&O()},ca=function(a,b,d){if((a=a.clipboardData||window.clipboardData)&&!c){var n=f||d?"Text":"text/plain";try{return b?!1!==a.setData(n,b):a.getData(n)}catch(ma){if(!d)return ca(ma,b,!0)}}},T=function(a,c){var b=q.getCopyText();if(!b)return k.preventDefault(a);ca(a,b)?(l&&(O(b),H=b,setTimeout(function(){H=!1},10)),c?q.onCut():q.onCopy(),k.preventDefault(a)):(H=!0,z.value=b,z.select(),setTimeout(function(){H=!1;O();c?q.onCut():q.onCopy()}))},ba=function(a){T(a,!0)},N=function(a){T(a,
!1)},V=function(c){var b=ca(c);if(!a.pasteCancelled())if("string"==typeof b){if(b)q.onPaste(b,c);x.isIE&&setTimeout(O);k.preventDefault(c)}else z.value="",r=!0};k.addCommandKeyListener(z,q.onCommandKey.bind(q),q);k.addListener(z,"select",function(a){h||(H?H=!1:0===z.selectionStart&&z.selectionEnd>=I.length&&z.value===I&&I&&z.selectionEnd!==L?(q.selectAll(),O()):v&&z.selectionStart!=C&&O())},q);k.addListener(z,"input",X,q);k.addListener(z,"cut",ba,q);k.addListener(z,"copy",N,q);k.addListener(z,"paste",
V,q);"oncut"in z&&"oncopy"in z&&"onpaste"in z||k.addListener(b,"keydown",function(a){if((!x.isMac||a.metaKey)&&a.ctrlKey)switch(a.keyCode){case 67:N(a);break;case 86:V(a);break;case 88:ba(a)}},q);var aa=function(){if(h&&q.onCompositionUpdate&&!q.$readOnly){if(G)return n();if(h.useTextareaForIME)q.onCompositionUpdate(z.value);else P(z.value),h.markerRange&&(h.context&&(h.markerRange.start.column=h.selectionStart=h.context.compositionStartOffset),h.markerRange.end.column=h.markerRange.start.column+
L-h.selectionStart+Q)}},Y=function(a){q.onCompositionEnd&&!q.$readOnly&&(h=!1,q.onCompositionEnd(),q.off("mousedown",n),a&&X())},Z=d.delayedCall(aa,50).schedule.bind(null,null);k.addListener(z,"compositionstart",function(a){h||!q.onCompositionStart||q.$readOnly||(h={},G||(a.data&&(h.useTextareaForIME=!1),setTimeout(aa,0),q._signal("compositionStart"),q.on("mousedown",n),a=q.getSelectionRange(),a.end.row=a.start.row,a.end.column=a.start.column,h.markerRange=a,h.selectionStart=C,q.onCompositionStart(h),
h.useTextareaForIME?(I=z.value="",L=C=0):(z.msGetInputContext&&(h.context=z.msGetInputContext()),z.getInputContext&&(h.context=z.getInputContext()))))},q);k.addListener(z,"compositionupdate",aa,q);k.addListener(z,"keyup",function(a){27==a.keyCode&&z.value.length<z.selectionStart&&(h||(I=z.value),C=L=-1,O());Z()},q);k.addListener(z,"keydown",Z,q);k.addListener(z,"compositionend",Y,q);this.getElement=function(){return z};this.setCommandMode=function(a){G=a;z.readOnly=!1};this.setReadOnly=function(a){G||
(z.readOnly=a)};this.setCopyWithEmptySelection=function(a){};this.onContextMenu=function(a){R=!0;O();q._emit("nativecontextmenu",{target:q,domEvent:a});this.moveToMouse(a,!0)};this.moveToMouse=function(a,c){B||(B=z.style.cssText);z.style.cssText=(c?"z-index:100000;":"")+(x.isIE?"opacity:0.1;":"")+"text-indent: -"+(C+L)*q.renderer.characterWidth*.5+"px;";c=q.container.getBoundingClientRect();var b=g.computedStyle(q.container),d=c.top+(parseInt(b.borderTopWidth)||0),f=c.left+(parseInt(c.borderLeftWidth)||
0),n=c.bottom-d-z.clientHeight-2;c=function(a){g.translate(z,a.clientX-f-2,Math.min(a.clientY-d-2,n))};c(a);"mousedown"==a.type&&(q.renderer.$isMousePressed=!0,clearTimeout(ia),x.isWin&&k.capture(q.container,c,e))};this.onContextMenuClose=e;var ia,la=function(a){q.textInput.onContextMenu(a);e()};k.addListener(z,"mouseup",la,q);k.addListener(z,"mousedown",function(a){a.preventDefault();e()},q);k.addListener(q.renderer.scroller,"contextmenu",la,q);k.addListener(z,"contextmenu",la,q);l&&A(b,q,z)};e.$setUserAgentForTests=
function(a,c){v=a;l=c}});ace.define("ace/mouse/default_handlers",["require","exports","module","ace/lib/useragent"],function(b,e,h){function k(b){b.$clickSelection=null;var a=b.editor;a.setDefaultHandler("mousedown",this.onMouseDown.bind(b));a.setDefaultHandler("dblclick",this.onDoubleClick.bind(b));a.setDefaultHandler("tripleclick",this.onTripleClick.bind(b));a.setDefaultHandler("quadclick",this.onQuadClick.bind(b));a.setDefaultHandler("mousewheel",this.onMouseWheel.bind(b));"select startSelect selectEnd selectAllEnd selectByWordsEnd selectByLinesEnd dragWait dragWaitEnd focusWait".split(" ").forEach(function(a){b[a]=
this[a]},this);b.selectByLines=this.extendSelectionBy.bind(b,"getLineRange");b.selectByWords=this.extendSelectionBy.bind(b,"getWordRange")}function x(b,a){return 0>(b.start.row==b.end.row?2*a.column-b.start.column-b.end.column:b.start.row!=b.end.row-1||b.start.column||b.end.column?2*a.row-b.start.row-b.end.row:a.column-4)?{cursor:b.start,anchor:b.end}:{cursor:b.end,anchor:b.start}}var g=b("../lib/useragent");(function(){this.onMouseDown=function(b){var a=b.inSelection(),c=b.getDocumentPosition();
this.mousedownEvent=b;var d=this.editor,e=b.getButton();if(0!==e)(d.getSelectionRange().isEmpty()||1==e)&&d.selection.moveToPosition(c),2==e&&(d.textInput.onContextMenu(b.domEvent),g.isMozilla||b.preventDefault());else{this.mousedownEvent.time=Date.now();if(a&&!d.isFocused()&&(d.focus(),this.$focusTimeout&&!this.$clickSelection&&!d.inMultiSelectMode)){this.setState("focusWait");this.captureMouse(b);return}this.captureMouse(b);this.startSelect(c,1<b.domEvent._clicks);return b.preventDefault()}};this.startSelect=
function(b,a){b=b||this.editor.renderer.screenToTextCoordinates(this.x,this.y);var c=this.editor;this.mousedownEvent&&(this.mousedownEvent.getShiftKey()?c.selection.selectToPosition(b):a||c.selection.moveToPosition(b),a||this.select(),c.renderer.scroller.setCapture&&c.renderer.scroller.setCapture(),c.setStyle("ace_selecting"),this.setState("select"))};this.select=function(){var b=this.editor,a=b.renderer.screenToTextCoordinates(this.x,this.y);if(this.$clickSelection){var c=this.$clickSelection.comparePoint(a);
-1==c?c=this.$clickSelection.end:1==c?c=this.$clickSelection.start:(c=x(this.$clickSelection,a),a=c.cursor,c=c.anchor);b.selection.setSelectionAnchor(c.row,c.column)}b.selection.selectToPosition(a);b.renderer.scrollCursorIntoView()};this.extendSelectionBy=function(b){var a=this.editor,c=a.renderer.screenToTextCoordinates(this.x,this.y);b=a.selection[b](c.row,c.column);if(this.$clickSelection){var d=this.$clickSelection.comparePoint(b.start);var g=this.$clickSelection.comparePoint(b.end);if(-1==d&&
0>=g){if(d=this.$clickSelection.end,b.end.row!=c.row||b.end.column!=c.column)c=b.start}else if(1==g&&0<=d){if(d=this.$clickSelection.start,b.start.row!=c.row||b.start.column!=c.column)c=b.end}else-1==d&&1==g?(c=b.end,d=b.start):(b=x(this.$clickSelection,c),c=b.cursor,d=b.anchor);a.selection.setSelectionAnchor(d.row,d.column)}a.selection.selectToPosition(c);a.renderer.scrollCursorIntoView()};this.selectEnd=this.selectAllEnd=this.selectByWordsEnd=this.selectByLinesEnd=function(){this.$clickSelection=
null;this.editor.unsetStyle("ace_selecting");this.editor.renderer.scroller.releaseCapture&&this.editor.renderer.scroller.releaseCapture()};this.focusWait=function(){var b=Math.sqrt(Math.pow(this.x-this.mousedownEvent.x,2)+Math.pow(this.y-this.mousedownEvent.y,2)),a=Date.now();(0<b||a-this.mousedownEvent.time>this.$focusTimeout)&&this.startSelect(this.mousedownEvent.getDocumentPosition())};this.onDoubleClick=function(b){b=b.getDocumentPosition();var a=this.editor,c=a.session.getBracketRange(b);c?(c.isEmpty()&&
(c.start.column--,c.end.column++),this.setState("select")):(c=a.selection.getWordRange(b.row,b.column),this.setState("selectByWords"));this.$clickSelection=c;this.select()};this.onTripleClick=function(b){b=b.getDocumentPosition();var a=this.editor;this.setState("selectByLines");var c=a.getSelectionRange();c.isMultiLine()&&c.contains(b.row,b.column)?(this.$clickSelection=a.selection.getLineRange(c.start.row),this.$clickSelection.end=a.selection.getLineRange(c.end.row).end):this.$clickSelection=a.selection.getLineRange(b.row);
this.select()};this.onQuadClick=function(b){b=this.editor;b.selectAll();this.$clickSelection=b.getSelectionRange();this.setState("selectAll")};this.onMouseWheel=function(b){if(!b.getAccelKey()){b.getShiftKey()&&b.wheelY&&!b.wheelX&&(b.wheelX=b.wheelY,b.wheelY=0);var a=this.editor;this.$lastScroll||(this.$lastScroll={t:0,vx:0,vy:0,allowed:0});var c=this.$lastScroll,d=b.domEvent.timeStamp,g=d-c.t,m=g?b.wheelX/g:c.vx,e=g?b.wheelY/g:c.vy;550>g&&(m=(m+c.vx)/2,e=(e+c.vy)/2);g=Math.abs(m/e);var l=!1;1<=
g&&a.renderer.isScrollableBy(b.wheelX*b.speed,0)&&(l=!0);1>=g&&a.renderer.isScrollableBy(0,b.wheelY*b.speed)&&(l=!0);l?c.allowed=d:550>d-c.allowed&&(Math.abs(m)<=1.5*Math.abs(c.vx)&&Math.abs(e)<=1.5*Math.abs(c.vy)?(l=!0,c.allowed=d):c.allowed=0);c.t=d;c.vx=m;c.vy=e;if(l)return a.renderer.scrollBy(b.wheelX*b.speed,b.wheelY*b.speed),b.stop()}}}).call(k.prototype);e.DefaultHandlers=k});ace.define("ace/tooltip",["require","exports","module","ace/lib/oop","ace/lib/dom"],function(b,e,h){function k(b){this.isOpen=
!1;this.$element=null;this.$parentNode=b}b("./lib/oop");var x=b("./lib/dom");(function(){this.$init=function(){this.$element=x.createElement("div");this.$element.className="ace_tooltip";this.$element.style.display="none";this.$parentNode.appendChild(this.$element);return this.$element};this.getElement=function(){return this.$element||this.$init()};this.setText=function(b){this.getElement().textContent=b};this.setHtml=function(b){this.getElement().innerHTML=b};this.setPosition=function(b,d){this.getElement().style.left=
b+"px";this.getElement().style.top=d+"px"};this.setClassName=function(b){x.addCssClass(this.getElement(),b)};this.show=function(b,d,a){null!=b&&this.setText(b);null!=d&&null!=a&&this.setPosition(d,a);this.isOpen||(this.getElement().style.display="block",this.isOpen=!0)};this.hide=function(){this.isOpen&&(this.getElement().style.display="none",this.isOpen=!1)};this.getHeight=function(){return this.getElement().offsetHeight};this.getWidth=function(){return this.getElement().offsetWidth};this.destroy=
function(){this.isOpen=!1;this.$element&&this.$element.parentNode&&this.$element.parentNode.removeChild(this.$element)}}).call(k.prototype);e.Tooltip=k});ace.define("ace/mouse/default_gutter_handler","require exports module ace/lib/dom ace/lib/oop ace/lib/event ace/tooltip".split(" "),function(b,e,h){function k(a){d.call(this,a)}var x=b("../lib/dom");h=b("../lib/oop");var g=b("../lib/event"),d=b("../tooltip").Tooltip;h.inherits(k,d);(function(){this.setPosition=function(a,c){var b=window.innerWidth||
document.documentElement.clientWidth,g=window.innerHeight||document.documentElement.clientHeight,e=this.getWidth(),p=this.getHeight();a+=15;c+=15;a+e>b&&(a-=a+e-b);c+p>g&&(c-=20+p);d.prototype.setPosition.call(this,a,c)}}).call(k.prototype);e.GutterHandler=function(a){function c(){p&&(p=clearTimeout(p));u&&(e.hide(),u=null,b._signal("hideGutterTooltip",e),b.off("mousewheel",c))}var b=a.editor,d=b.renderer.$gutterLayer,e=new k(b.container);a.editor.setDefaultHandler("guttermousedown",function(c){if(b.isFocused()&&
0==c.getButton()&&"foldWidgets"!=d.getRegion(c)){var f=c.getDocumentPosition().row,g=b.session.selection;if(c.getShiftKey())g.selectTo(f,0);else{if(2==c.domEvent.detail)return b.selectAll(),c.preventDefault();a.$clickSelection=b.selection.getLineRange(f)}a.setState("selectByLines");a.captureMouse(c);return c.preventDefault()}});var p,l,u;a.editor.setDefaultHandler("guttermousemove",function(f){if(x.hasCssClass(f.domEvent.target||f.domEvent.srcElement,"ace_fold-widget"))return c();u&&a.$tooltipFollowsMouse&&
e.setPosition(f.x,f.y);l=f;p||(p=setTimeout(function(){p=null;if(l&&!a.isMousePressed)a:{var f=l.getDocumentPosition().row,g=d.$annotations[f];if(g){var n=b.session.getLength();if(f==n&&(f=b.renderer.pixelToScreenCoordinates(0,l.y).row,n=l.$pos,f>b.session.documentToScreenRow(n.row,n.column))){c();break a}u!=g&&(u=g.text.join("<br/>"),e.setHtml(u),e.show(),b._signal("showGutterTooltip",e),b.on("mousewheel",c),a.$tooltipFollowsMouse?e.setPosition(l.x,l.y):(g=l.domEvent.target.getBoundingClientRect(),
f=e.getElement().style,f.left=g.right+"px",f.top=g.bottom+"px"))}else c()}else c()},50))});g.addListener(b.renderer.$gutter,"mouseout",function(a){l=null;u&&!p&&(p=setTimeout(function(){p=null;c()},50))},b);b.on("changeSession",c)}});ace.define("ace/mouse/mouse_event",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(b,e,h){var k=b("../lib/event"),x=b("../lib/useragent");b=e.MouseEvent=function(b,d){this.domEvent=b;this.editor=d;this.x=this.clientX=b.clientX;this.y=this.clientY=
b.clientY;this.$inSelection=this.$pos=null;this.defaultPrevented=this.propagationStopped=!1};(function(){this.stopPropagation=function(){k.stopPropagation(this.domEvent);this.propagationStopped=!0};this.preventDefault=function(){k.preventDefault(this.domEvent);this.defaultPrevented=!0};this.stop=function(){this.stopPropagation();this.preventDefault()};this.getDocumentPosition=function(){return this.$pos?this.$pos:this.$pos=this.editor.renderer.screenToTextCoordinates(this.clientX,this.clientY)};this.inSelection=
function(){if(null!==this.$inSelection)return this.$inSelection;var b=this.editor.getSelectionRange();if(b.isEmpty())this.$inSelection=!1;else{var d=this.getDocumentPosition();this.$inSelection=b.contains(d.row,d.column)}return this.$inSelection};this.getButton=function(){return k.getButton(this.domEvent)};this.getShiftKey=function(){return this.domEvent.shiftKey};this.getAccelKey=x.isMac?function(){return this.domEvent.metaKey}:function(){return this.domEvent.ctrlKey}}).call(b.prototype)});ace.define("ace/mouse/dragdrop_handler",
"require exports module ace/lib/dom ace/lib/event ace/lib/useragent".split(" "),function(b,e,h){function k(a){var c,b;function e(){var a=h,d=h=A.renderer.screenToTextCoordinates(k,z),f=Date.now(),n=!a||d.row!=a.row,g=!a||d.column!=a.column;!I||n||g?(A.moveCursorToPosition(d),I=f,c=k,b=z):5<Math.sqrt(Math.pow(k-c,2)+Math.pow(z-b,2))?I=null:200<=f-I&&(A.renderer.scrollCursorIntoView(),I=null);d=h;f=Date.now();g=A.renderer.layerConfig.lineHeight;var l=A.renderer.layerConfig.characterWidth;n=A.renderer.scroller.getBoundingClientRect();
var e=k-n.left,m=n.right-k,q=z-n.top,v=n.bottom-z,w=Math.min(q,v);n={row:d.row,column:d.column};2>=Math.min(e,m)/l&&(n.column+=e<m?-3:2);1>=w/g&&(n.row+=q<v?-1:1);g=d.column!=n.column;a=!a||d.row!=a.row;d.row!=n.row||g&&!a?y?200<=f-y&&A.renderer.scrollCursorIntoView(n):y=f:y=null}function m(){r=A.selection.toOrientedRange();J=A.session.addMarker(r,"ace_selection",A.getSelectionStyle());A.clearSelection();A.isFocused()&&A.renderer.$cursorLayer.setBlinking(!1);clearInterval(H);e();H=setInterval(e,20);
t=0;g.addListener(document,"mousemove",l)}function p(){clearInterval(H);A.session.removeMarker(J);J=null;A.selection.fromOrientedRange(r);A.isFocused()&&!G&&A.$resetCursorStyle();h=r=null;t=0;I=y=null;g.removeListener(document,"mousemove",l)}function l(){null==C&&(C=setTimeout(function(){null!=C&&J&&p()},20))}function u(a){a=a.types;return!a||Array.prototype.some.call(a,function(a){return"text/plain"==a||"Text"==a})}function v(a){var c=["copy","copymove","all","uninitialized"],b=["move","copymove",
"linkmove","all","uninitialized"],f=d.isMac?a.altKey:a.ctrlKey,n="uninitialized";try{n=a.dataTransfer.effectAllowed.toLowerCase()}catch(R){}a="none";f&&0<=c.indexOf(n)?a="copy":0<=b.indexOf(n)?a="move":0<=c.indexOf(n)&&(a="copy");return a}var A=a.editor,q=x.createElement("img");q.src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";d.isOpera&&(q.style.cssText="width:1px;height:1px;position:fixed;top:0;left:0;z-index:2147483647;opacity:0;");["dragWait","dragWaitEnd","startDrag",
"dragReadyEnd","onMouseDrag"].forEach(function(c){a[c]=this[c]},this);A.on("mousedown",this.onMouseDown.bind(a));var n=A.container,J,k,z,H,r,h,t=0,B,G,y,I;this.onDragStart=function(a){if(this.cancelDrag||!n.draggable){var c=this;setTimeout(function(){c.startSelect();c.captureMouse(a)},0);return a.preventDefault()}r=A.getSelectionRange();var b=a.dataTransfer;b.effectAllowed=A.getReadOnly()?"copy":"copyMove";d.isOpera&&(A.container.appendChild(q),q.scrollTop=0);b.setDragImage&&b.setDragImage(q,0,0);
d.isOpera&&A.container.removeChild(q);b.clearData();b.setData("Text",A.session.getTextRange());G=!0;this.setState("drag")};this.onDragEnd=function(a){G=n.draggable=!1;this.setState(null);A.getReadOnly()||(a=a.dataTransfer.dropEffect,B||"move"!=a||A.session.remove(A.getSelectionRange()),A.$resetCursorStyle());this.editor.unsetStyle("ace_dragging");this.editor.renderer.setCursorStyle("")};this.onDragEnter=function(a){if(!A.getReadOnly()&&u(a.dataTransfer))return k=a.clientX,z=a.clientY,J||m(),t++,a.dataTransfer.dropEffect=
B=v(a),g.preventDefault(a)};this.onDragOver=function(a){if(!A.getReadOnly()&&u(a.dataTransfer))return k=a.clientX,z=a.clientY,J||(m(),t++),null!==C&&(C=null),a.dataTransfer.dropEffect=B=v(a),g.preventDefault(a)};this.onDragLeave=function(a){t--;if(0>=t&&J)return p(),B=null,g.preventDefault(a)};this.onDrop=function(a){if(h){var c=a.dataTransfer;if(G)switch(B){case "move":r=r.contains(h.row,h.column)?{start:h,end:h}:A.moveText(r,h);break;case "copy":r=A.moveText(r,h,!0)}else c=c.getData("Text"),r={start:h,
end:A.session.insert(h,c)},A.focus(),B=null;p();return g.preventDefault(a)}};g.addListener(n,"dragstart",this.onDragStart.bind(a),A);g.addListener(n,"dragend",this.onDragEnd.bind(a),A);g.addListener(n,"dragenter",this.onDragEnter.bind(a),A);g.addListener(n,"dragover",this.onDragOver.bind(a),A);g.addListener(n,"dragleave",this.onDragLeave.bind(a),A);g.addListener(n,"drop",this.onDrop.bind(a),A);var C=null}var x=b("../lib/dom"),g=b("../lib/event"),d=b("../lib/useragent");(function(){this.dragWait=function(){Date.now()-
this.mousedownEvent.time>this.editor.getDragDelay()&&this.startDrag()};this.dragWaitEnd=function(){this.editor.container.draggable=!1;this.startSelect(this.mousedownEvent.getDocumentPosition());this.selectEnd()};this.dragReadyEnd=function(a){this.editor.$resetCursorStyle();this.editor.unsetStyle("ace_dragging");this.editor.renderer.setCursorStyle("");this.dragWaitEnd()};this.startDrag=function(){this.cancelDrag=!1;var a=this.editor;a.container.draggable=!0;a.renderer.$cursorLayer.setBlinking(!1);
a.setStyle("ace_dragging");a.renderer.setCursorStyle(d.isWin?"default":"move");this.setState("dragReady")};this.onMouseDrag=function(a){a=this.editor.container;if(d.isIE&&"dragReady"==this.state){var c=Math.sqrt(Math.pow(this.x-this.mousedownEvent.x,2)+Math.pow(this.y-this.mousedownEvent.y,2));3<c&&a.dragDrop()}"dragWait"===this.state&&(c=Math.sqrt(Math.pow(this.x-this.mousedownEvent.x,2)+Math.pow(this.y-this.mousedownEvent.y,2)),0<c&&(a.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition())))};
this.onMouseDown=function(a){if(this.$dragEnabled){this.mousedownEvent=a;var c=this.editor,b=a.inSelection(),g=a.getButton();1!==(a.domEvent.detail||1)||0!==g||!b||a.editor.inMultiSelectMode&&(a.getAccelKey()||a.getShiftKey())||(this.mousedownEvent.time=Date.now(),b=a.domEvent.target||a.domEvent.srcElement,"unselectable"in b&&(b.unselectable="on"),c.getDragDelay()?(d.isWebKit&&(this.cancelDrag=!0,c.container.draggable=!0),this.setState("dragWait")):this.startDrag(),this.captureMouse(a,this.onMouseDrag.bind(this)),
a.defaultPrevented=!0)}}}).call(k.prototype);e.DragdropHandler=k});ace.define("ace/mouse/touch_handler","require exports module ace/mouse/mouse_event ace/lib/event ace/lib/dom".split(" "),function(b,e,h){var k=b("./mouse_event").MouseEvent,x=b("../lib/event"),g=b("../lib/dom");e.addTouchListeners=function(b,a){function c(){var c=window.navigator&&window.navigator.clipboard,b=!1,d=function(){var d=a.getCopyText(),f=a.session.getUndoManager().hasUndo();G.replaceChild(g.buildDom(b?["span",!d&&["span",
{class:"ace_mobile-button",action:"selectall"},"Select All"],d&&["span",{class:"ace_mobile-button",action:"copy"},"Copy"],d&&["span",{class:"ace_mobile-button",action:"cut"},"Cut"],c&&["span",{class:"ace_mobile-button",action:"paste"},"Paste"],f&&["span",{class:"ace_mobile-button",action:"undo"},"Undo"],["span",{class:"ace_mobile-button",action:"find"},"Find"],["span",{class:"ace_mobile-button",action:"openCommandPallete"},"Pallete"]]:["span"]),G.firstChild)},f=function(f){var n=f.target.getAttribute("action");
if("more"==n||!b)return b=!b,d();if("paste"==n)c.readText().then(function(c){a.execCommand(n,c)});else if(n){if("cut"==n||"copy"==n)c?c.writeText(a.getCopyText()):document.execCommand("copy");a.execCommand(n)}G.firstChild.style.display="none";b=!1;"openCommandPallete"!=n&&a.focus()};G=g.buildDom(["div",{class:"ace_mobile-menu",ontouchstart:function(c){u="menu";c.stopPropagation();c.preventDefault();a.textInput.focus()},ontouchend:function(a){a.stopPropagation();a.preventDefault();f(a)},onclick:f},
["span"],["span",{class:"ace_mobile-button",action:"more"},"..."]],a.container)}function d(){G||c();var b=a.selection.cursor;b=a.renderer.textToScreenCoordinates(b.row,b.column);var d=a.renderer.textToScreenCoordinates(0,0).pageX,f=a.renderer.scrollLeft,n=a.container.getBoundingClientRect();G.style.top=b.pageY-n.top-3+"px";b.pageX-n.left<n.width-70?(G.style.left="",G.style.right="10px"):(G.style.right="",G.style.left=d+f-n.left+"px");G.style.display="";G.firstChild.style.display="none";a.on("input",
e)}function e(c){G&&(G.style.display="none");a.off("input",e)}function m(){J=null;clearTimeout(J);var c=a.selection.getRange(),b=c.contains(H.row,H.column);if(c.isEmpty()||!b)a.selection.moveToPosition(H),a.selection.selectWord();u="wait";d()}function p(){J=null;clearTimeout(J);a.selection.moveToPosition(H);var c=2<=r?a.selection.getLineRange(H.row):a.session.getBracketRange(H);c&&!c.isEmpty()?a.selection.setRange(c):a.selection.selectWord();u="wait"}function l(){z+=60;K=setInterval(function(){0>=
z--&&(clearInterval(K),K=null);.01>Math.abs(h)&&(h=0);.01>Math.abs(t)&&(t=0);20>z&&(h*=.9);20>z&&(t*=.9);var c=a.session.getScrollTop();a.renderer.scrollBy(10*h,10*t);c==a.session.getScrollTop()&&(z=0)},10)}var u="scroll",v,A,q,n,J,K,z=0,H,r=0,h=0,t=0,B,G;x.addListener(b,"contextmenu",function(c){B&&a.textInput.getElement().focus()},a);x.addListener(b,"touchstart",function(c){var b=c.touches;if(J||1<b.length)clearTimeout(J),J=null,q=-1,u="zoom";else{B=a.$mouseHandler.isMousePressed=!0;var d=a.renderer.layerConfig.lineHeight,
f=a.renderer.layerConfig.lineHeight,g=c.timeStamp;n=g;var l=b[0],e=l.clientX;l=l.clientY;Math.abs(v-e)+Math.abs(A-l)>d&&(q=-1);v=c.clientX=e;A=c.clientY=l;h=t=0;H=(new k(c,a)).getDocumentPosition();if(500>g-q&&1==b.length&&!z)r++,c.preventDefault(),c.button=0,p();else{r=0;b=a.selection.cursor;e=a.selection.isEmpty()?b:a.selection.anchor;b=a.renderer.$cursorLayer.getPixelPosition(b,!0);e=a.renderer.$cursorLayer.getPixelPosition(e,!0);l=a.renderer.scroller.getBoundingClientRect();var w=a.renderer.layerConfig.offset,
x=a.renderer.scrollLeft,K=function(a,c){a/=f;c=c/d-.75;return a*a+c*c};if(c.clientX<l.left){u="zoom";return}b=K(c.clientX-l.left-b.left+x,c.clientY-l.top-b.top+w);c=K(c.clientX-l.left-e.left+x,c.clientY-l.top-e.top+w);3.5>b&&3.5>c&&(u=b>c?"cursor":"anchor");u=3.5>c?"anchor":3.5>b?"cursor":"scroll";J=setTimeout(m,450)}q=g}},a);x.addListener(b,"touchend",function(c){B=a.$mouseHandler.isMousePressed=!1;K&&clearInterval(K);"zoom"==u?(u="",z=0):J?(a.selection.moveToPosition(H),z=0,d()):"scroll"==u?(l(),
e()):d();clearTimeout(J);J=null},a);x.addListener(b,"touchmove",function(c){J&&(clearTimeout(J),J=null);var b=c.touches;if(!(1<b.length||"zoom"==u)){var d=b[0];b=v-d.clientX;var f=A-d.clientY;if("wait"==u)if(4<b*b+f*f)u="cursor";else return c.preventDefault();v=d.clientX;A=d.clientY;c.clientX=d.clientX;c.clientY=d.clientY;var g=c.timeStamp;d=g-n;n=g;"scroll"==u?(c=new k(c,a),c.speed=1,c.wheelX=b,c.wheelY=f,10*Math.abs(b)<Math.abs(f)&&(b=0),10*Math.abs(f)<Math.abs(b)&&(f=0),0!=d&&(h=b/d,t=f/d),a._emit("mousewheel",
c),c.propagationStopped||(h=t=0)):(b=(new k(c,a)).getDocumentPosition(),"cursor"==u?a.selection.moveCursorToPosition(b):"anchor"==u&&a.selection.setSelectionAnchor(b.row,b.column),a.renderer.scrollCursorIntoView(b),c.preventDefault())}},a)}});ace.define("ace/lib/net",["require","exports","module","ace/lib/dom"],function(b,e,h){var k=b("./dom");e.get=function(b,g){var d=new XMLHttpRequest;d.open("GET",b,!0);d.onreadystatechange=function(){4===d.readyState&&g(d.responseText)};d.send(null)};e.loadScript=
function(b,g){var d=k.getDocumentHead(),a=document.createElement("script");a.src=b;d.appendChild(a);a.onload=a.onreadystatechange=function(c,b){if(b||!a.readyState||"loaded"==a.readyState||"complete"==a.readyState)a=a.onload=a.onreadystatechange=null,b||g()}};e.qualifyURL=function(b){var g=document.createElement("a");g.href=b;return g.href}});ace.define("ace/lib/event_emitter",["require","exports","module"],function(b,e,h){b={};var k=function(){this.propagationStopped=!0},x=function(){this.defaultPrevented=
!0};b._emit=b._dispatchEvent=function(b,d){this._eventRegistry||(this._eventRegistry={});this._defaultHandlers||(this._defaultHandlers={});var a=this._eventRegistry[b]||[],c=this._defaultHandlers[b];if(a.length||c){"object"==typeof d&&d||(d={});d.type||(d.type=b);d.stopPropagation||(d.stopPropagation=k);d.preventDefault||(d.preventDefault=x);a=a.slice();for(b=0;b<a.length&&(a[b](d,this),!d.propagationStopped);b++);if(c&&!d.defaultPrevented)return c(d,this)}};b._signal=function(b,d){if(b=(this._eventRegistry||
{})[b]){b=b.slice();for(var a=0;a<b.length;a++)b[a](d,this)}};b.once=function(b,d){var a=this;this.on(b,function f(){a.off(b,f);d.apply(null,arguments)});if(!d)return new Promise(function(a){d=a})};b.setDefaultHandler=function(b,d){var a=this._defaultHandlers;a||(a=this._defaultHandlers={_disabled_:{}});if(a[b]){var c=a[b],f=a._disabled_[b];f||(a._disabled_[b]=f=[]);f.push(c);c=f.indexOf(d);-1!=c&&f.splice(c,1)}a[b]=d};b.removeDefaultHandler=function(b,d){var a=this._defaultHandlers;if(a){var c=a._disabled_[b];
a[b]==d?c&&this.setDefaultHandler(b,c.pop()):c&&(b=c.indexOf(d),-1!=b&&c.splice(b,1))}};b.on=b.addEventListener=function(b,d,a){this._eventRegistry=this._eventRegistry||{};var c=this._eventRegistry[b];c||(c=this._eventRegistry[b]=[]);if(-1==c.indexOf(d))c[a?"unshift":"push"](d);return d};b.off=b.removeListener=b.removeEventListener=function(b,d){this._eventRegistry=this._eventRegistry||{};if(b=this._eventRegistry[b])d=b.indexOf(d),-1!==d&&b.splice(d,1)};b.removeAllListeners=function(b){b||(this._eventRegistry=
this._defaultHandlers=void 0);this._eventRegistry&&(this._eventRegistry[b]=void 0);this._defaultHandlers&&(this._defaultHandlers[b]=void 0)};e.EventEmitter=b});ace.define("ace/lib/app_config",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(b,e,h){function k(a){"undefined"!=typeof console&&console.warn&&console.warn.apply(console,arguments)}function x(a,b){var c=Error(a);c.data=b;"object"==typeof console&&console.error&&console.error(c);setTimeout(function(){throw c;})}
"no use strict";var g=b("./oop"),d=b("./event_emitter").EventEmitter,a={setOptions:function(a){Object.keys(a).forEach(function(c){this.setOption(c,a[c])},this)},getOptions:function(a){var c={};if(a)Array.isArray(a)||(c=a,a=Object.keys(c));else{var b=this.$options;a=Object.keys(b).filter(function(a){return!b[a].hidden})}a.forEach(function(a){c[a]=this.getOption(a)},this);return c},setOption:function(a,b){if(this["$"+a]!==b){var c=this.$options[a];if(!c)return k('misspelled option "'+a+'"');if(c.forwardTo)return this[c.forwardTo]&&
this[c.forwardTo].setOption(a,b);c.handlesSet||(this["$"+a]=b);c&&c.set&&c.set.call(this,b)}},getOption:function(a){var c=this.$options[a];return c?c.forwardTo?this[c.forwardTo]&&this[c.forwardTo].getOption(a):c&&c.get?c.get.call(this):this["$"+a]:k('misspelled option "'+a+'"')}};b=function(){this.$defaultOptions={}};(function(){g.implement(this,d);this.defineOptions=function(c,b,d){c.$options||(this.$defaultOptions[b]=c.$options={});Object.keys(d).forEach(function(a){var b=d[a];"string"==typeof b&&
(b={forwardTo:b});b.name||(b.name=a);c.$options[b.name]=b;"initialValue"in b&&(c["$"+b.name]=b.initialValue)});g.implement(c,a);return this};this.resetOptions=function(a){Object.keys(a.$options).forEach(function(b){var c=a.$options[b];"value"in c&&a.setOption(b,c.value)})};this.setDefaultValue=function(a,b,d){if(!a){for(a in this.$defaultOptions)if(this.$defaultOptions[a][b])break;if(!this.$defaultOptions[a][b])return!1}a=this.$defaultOptions[a]||(this.$defaultOptions[a]={});a[b]&&(a.forwardTo?this.setDefaultValue(a.forwardTo,
b,d):a[b].value=d)};this.setDefaultValues=function(a,b){Object.keys(b).forEach(function(c){this.setDefaultValue(a,c,b[c])},this)};this.warn=k;this.reportError=x}).call(b.prototype);e.AppConfig=b});ace.define("ace/config","require exports module ace/lib/lang ace/lib/oop ace/lib/net ace/lib/app_config".split(" "),function(b,e,t){function k(a){if(c&&c.document){f.packaged=a||b.packaged||t.packaged||c.define&&h.amdD.packaged;a={};var d="",l=document.currentScript||document._currentScript;l=(l&&l.ownerDocument||
document).getElementsByTagName("script");for(var g=0;g<l.length;g++){var m=l[g],w=m.src||m.getAttribute("src");if(w){m=m.attributes;for(var q=0,n=m.length;q<n;q++){var J=m[q];0===J.name.indexOf("data-ace-")&&(a[x(J.name.replace(/^data-ace-/,""))]=J.value)}(w=w.match(/^(.*)\/ace(\-\w+)?\.js(\?|$)/))&&(d=w[1])}}d&&(a.base=a.base||d,a.packaged=!0);a.basePath=a.base;a.workerPath=a.workerPath||a.base;a.modePath=a.modePath||a.base;a.themePath=a.themePath||a.base;delete a.base;for(var k in a)"undefined"!==
typeof a[k]&&e.set(k,a[k])}}function x(a){return a.replace(/-(.)/g,function(a,b){return b.toUpperCase()})}"no use strict";var g=b("./lib/lang");b("./lib/oop");var d=b("./lib/net"),a=b("./lib/app_config").AppConfig;t.exports=e=new a;var c=function(){return this||"undefined"!=typeof window&&window}(),f={packaged:!1,workerPath:null,modePath:null,themePath:null,basePath:"",suffix:".js",$moduleUrls:{},loadWorkerFromBlob:!0,sharedPopups:!1};e.get=function(a){if(!f.hasOwnProperty(a))throw Error("Unknown config key: "+
a);return f[a]};e.set=function(a,b){if(f.hasOwnProperty(a))f[a]=b;else if(0==this.setDefaultValue("",a,b))throw Error("Unknown config key: "+a);};e.all=function(){return g.copyObject(f)};e.$modes={};e.moduleUrl=function(a,b){if(f.$moduleUrls[a])return f.$moduleUrls[a];var c=a.split("/");b=b||c[c.length-2]||"";a="snippets"==b?"/":"-";var d=c[c.length-1];"worker"==b&&"-"==a&&(d=d.replace(new RegExp("^"+b+"[\\-_]|[\\-_]"+b+"$","g"),""));(!d||d==b)&&1<c.length&&(d=c[c.length-2]);c=f[b+"Path"];null==c?
c=f.basePath:"/"==a&&(b=a="");c&&"/"!=c.slice(-1)&&(c+="/");return c+b+a+d+this.get("suffix")};e.setModuleUrl=function(a,b){return f.$moduleUrls[a]=b};e.$loading={};e.loadModule=function(a,c){if(Array.isArray(a)){var f=a[0];a=a[1]}try{var g=b(a)}catch(v){}if(g&&!e.$loading[a])return c&&c(g);e.$loading[a]||(e.$loading[a]=[]);e.$loading[a].push(c);if(!(1<e.$loading[a].length)){c=function(){b([a],function(b){e._emit("load.module",{name:a,module:b});var c=e.$loading[a];e.$loading[a]=null;c.forEach(function(a){a&&
a(b)})})};if(!e.get("packaged"))return c();d.loadScript(e.moduleUrl(a,f),c);w()}};var w=function(){f.basePath||f.workerPath||f.modePath||f.themePath||Object.keys(f.$moduleUrls).length||(console.error("Unable to infer path to ace from script src,","use ace.config.set('basePath', 'path') to enable dynamic loading of modes and themes","or with webpack use ace/webpack-resolver"),w=function(){})};k(!0);e.init=k;e.version="1.4.12"});ace.define("ace/mouse/mouse_handler","require exports module ace/lib/event ace/lib/useragent ace/mouse/default_handlers ace/mouse/default_gutter_handler ace/mouse/mouse_event ace/mouse/dragdrop_handler ace/mouse/touch_handler ace/config".split(" "),
function(b,e,h){var k=b("../lib/event"),x=b("../lib/useragent"),g=b("./default_handlers").DefaultHandlers,d=b("./default_gutter_handler").GutterHandler,a=b("./mouse_event").MouseEvent,c=b("./dragdrop_handler").DragdropHandler,f=b("./touch_handler").addTouchListeners;b=b("../config");h=function(a){var b=this;this.editor=a;new g(this);new d(this);new c(this);var e=function(b){document.hasFocus&&document.hasFocus()&&(a.isFocused()||document.activeElement!=(a.textInput&&a.textInput.getElement()))||window.focus();
a.focus()},l=a.renderer.getMouseEventTarget();k.addListener(l,"click",this.onMouseEvent.bind(this,"click"),a);k.addListener(l,"mousemove",this.onMouseMove.bind(this,"mousemove"),a);k.addMultiMouseDownListener([l,a.renderer.scrollBarV&&a.renderer.scrollBarV.inner,a.renderer.scrollBarH&&a.renderer.scrollBarH.inner,a.textInput&&a.textInput.getElement()].filter(Boolean),[400,300,250],this,"onMouseEvent",a);k.addMouseWheelListener(a.container,this.onMouseWheel.bind(this,"mousewheel"),a);f(a.container,
a);var w=a.renderer.$gutter;k.addListener(w,"mousedown",this.onMouseEvent.bind(this,"guttermousedown"),a);k.addListener(w,"click",this.onMouseEvent.bind(this,"gutterclick"),a);k.addListener(w,"dblclick",this.onMouseEvent.bind(this,"gutterdblclick"),a);k.addListener(w,"mousemove",this.onMouseEvent.bind(this,"guttermousemove"),a);k.addListener(l,"mousedown",e,a);k.addListener(w,"mousedown",e,a);x.isIE&&a.renderer.scrollBarV&&(k.addListener(a.renderer.scrollBarV.element,"mousedown",e,a),k.addListener(a.renderer.scrollBarH.element,
"mousedown",e,a));a.on("mousemove",function(c){if(!b.state&&!b.$dragDelay&&b.$dragEnabled){c=a.renderer.screenToTextCoordinates(c.x,c.y);var d=a.session.selection.getRange(),f=a.renderer;!d.isEmpty()&&d.insideStart(c.row,c.column)?f.setCursorStyle("default"):f.setCursorStyle("")}},a)};(function(){this.onMouseEvent=function(b,c){this.editor._emit(b,new a(c,this.editor))};this.onMouseMove=function(b,c){var d=this.editor._eventRegistry&&this.editor._eventRegistry.mousemove;d&&d.length&&this.editor._emit(b,
new a(c,this.editor))};this.onMouseWheel=function(b,c){var d=new a(c,this.editor);d.speed=2*this.$scrollSpeed;d.wheelX=c.wheelX;d.wheelY=c.wheelY;this.editor._emit(b,d)};this.setState=function(a){this.state=a};this.captureMouse=function(b,c){this.x=b.x;this.y=b.y;this.isMousePressed=!0;var d=this.editor,f=this.editor.renderer;f.$isMousePressed=!0;var e=this,g=function(b){if(b){if(x.isWebKit&&!b.which&&e.releaseMouse)return e.releaseMouse();e.x=b.clientX;e.y=b.clientY;c&&c(b);e.mouseEvent=new a(b,
e.editor);e.$mouseMoved=!0}},m=function(a){d.off("beforeEndOperation",n);clearInterval(w);q();e[e.state+"End"]&&e[e.state+"End"](a);e.state="";e.isMousePressed=f.$isMousePressed=!1;f.$keepTextAreaAtCursor&&f.$moveTextAreaToCursor();e.$onCaptureMouseMove=e.releaseMouse=null;a&&e.onMouseEvent("mouseup",a);d.endOperation()},q=function(){e[e.state]&&e[e.state]();e.$mouseMoved=!1};if(x.isOldIE&&"dblclick"==b.domEvent.type)return setTimeout(function(){m(b)});var n=function(a){e.releaseMouse&&d.curOp.command.name&&
d.curOp.selectionChanged&&(e[e.state+"End"]&&e[e.state+"End"](),e.state="",e.releaseMouse())};d.on("beforeEndOperation",n);d.startOperation({command:{name:"mouse"}});e.$onCaptureMouseMove=g;e.releaseMouse=k.capture(this.editor.container,g,m);var w=setInterval(q,20)};this.releaseMouse=null;this.cancelContextMenu=function(){var a=function(b){b&&b.domEvent&&"contextmenu"!=b.domEvent.type||(this.editor.off("nativecontextmenu",a),b&&b.domEvent&&k.stopEvent(b.domEvent))}.bind(this);setTimeout(a,10);this.editor.on("nativecontextmenu",
a)};this.destroy=function(){this.releaseMouse&&this.releaseMouse()}}).call(h.prototype);b.defineOptions(h.prototype,"mouseHandler",{scrollSpeed:{initialValue:2},dragDelay:{initialValue:x.isMac?150:0},dragEnabled:{initialValue:!0},focusTimeout:{initialValue:0},tooltipFollowsMouse:{initialValue:!0}});e.MouseHandler=h});ace.define("ace/mouse/fold_handler",["require","exports","module","ace/lib/dom"],function(b,e,h){var k=b("../lib/dom");e.FoldHandler=function(b){b.on("click",function(e){var d=e.getDocumentPosition(),
a=b.session;if(d=a.getFoldAt(d.row,d.column,1))e.getAccelKey()?a.removeFold(d):a.expandFold(d),e.stop();(e=e.domEvent&&e.domEvent.target)&&k.hasCssClass(e,"ace_inline_button")&&k.hasCssClass(e,"ace_toggle_wrap")&&(a.setOption("wrap",!a.getUseWrapMode()),b.renderer.scrollCursorIntoView())});b.on("gutterclick",function(e){if("foldWidgets"==b.renderer.$gutterLayer.getRegion(e)){var d=e.getDocumentPosition().row,a=b.session;if(a.foldWidgets&&a.foldWidgets[d])b.session.onFoldWidgetClick(d,e);b.isFocused()||
b.focus();e.stop()}});b.on("gutterdblclick",function(e){if("foldWidgets"==b.renderer.$gutterLayer.getRegion(e)){var d=e.getDocumentPosition().row,a=b.session,c=a.getParentFoldRangeData(d,!0);if(c=c.range||c.firstRange)d=c.start.row,(d=a.getFoldAt(d,a.getLine(d).length,1))?a.removeFold(d):(a.addFold("...",c),b.renderer.scrollCursorIntoView({row:c.start.row,column:0}));e.stop()}})}});ace.define("ace/keyboard/keybinding",["require","exports","module","ace/lib/keys","ace/lib/event"],function(b,e,h){var k=
b("../lib/keys"),x=b("../lib/event");b=function(b){this.$editor=b;this.$data={editor:b};this.$handlers=[];this.setDefaultHandler(b.commands)};(function(){this.setDefaultHandler=function(b){this.removeKeyboardHandler(this.$defaultHandler);this.$defaultHandler=b;this.addKeyboardHandler(b,0)};this.setKeyboardHandler=function(b){var d=this.$handlers;if(d[d.length-1]!=b){for(;d[d.length-1]&&d[d.length-1]!=this.$defaultHandler;)this.removeKeyboardHandler(d[d.length-1]);this.addKeyboardHandler(b,1)}};this.addKeyboardHandler=
function(b,d){if(b){"function"!=typeof b||b.handleKeyboard||(b.handleKeyboard=b);var a=this.$handlers.indexOf(b);-1!=a&&this.$handlers.splice(a,1);void 0==d?this.$handlers.push(b):this.$handlers.splice(d,0,b);-1==a&&b.attach&&b.attach(this.$editor)}};this.removeKeyboardHandler=function(b){var d=this.$handlers.indexOf(b);if(-1==d)return!1;this.$handlers.splice(d,1);b.detach&&b.detach(this.$editor);return!0};this.getKeyboardHandler=function(){return this.$handlers[this.$handlers.length-1]};this.getStatusText=
function(){var b=this.$data,d=b.editor;return this.$handlers.map(function(a){return a.getStatusText&&a.getStatusText(d,b)||""}).filter(Boolean).join(" ")};this.$callKeyboardHandlers=function(b,d,a,c){for(var f,e=!1,g=this.$editor.commands,p=this.$handlers.length;p--&&!((f=this.$handlers[p].handleKeyboard(this.$data,b,d,a,c))&&f.command&&((e="null"==f.command?!0:g.exec(f.command,this.$editor,f.args,c))&&c&&-1!=b&&1!=f.passEvent&&1!=f.command.passEvent&&x.stopEvent(c),e)););e||-1!=b||(f={command:"insertstring"},
e=g.exec("insertstring",this.$editor,d));e&&this.$editor._signal&&this.$editor._signal("keyboardActivity",f);return e};this.onCommandKey=function(b,d,a){var c=k.keyCodeToString(a);return this.$callKeyboardHandlers(d,c,a,b)};this.onTextInput=function(b){return this.$callKeyboardHandlers(-1,b)}}).call(b.prototype);e.KeyBinding=b});ace.define("ace/lib/bidiutil",["require","exports","module"],function(b,e,h){function k(b,c,e){if(!(a<b))if(1!=b||1!=d||f)for(var n=e.length,l=0,g,q,v;l<n;){if(c[l]>=b){for(g=
l+1;g<n&&c[g]>=b;)g++;for(q=g-1;l<q;l++,q--)v=e[l],e[l]=e[q],e[q]=v;l=g}l++}else e.reverse()}function x(a,b,e,n){var l=b[n],g,q;switch(l){case 0:case 1:c=!1;case 4:case 3:return l;case 2:return c?3:2;case 7:return c=!0,1;case 8:return 4;case 9:if(1>n||n+1>=b.length||2!=(g=e[n-1])&&3!=g||2!=(q=b[n+1])&&3!=q)return 4;c&&(q=3);return q==g?q:4;case 10:return g=0<n?e[n-1]:5,2==g&&n+1<b.length&&2==b[n+1]?2:4;case 11:if(0<n&&2==e[n-1])return 2;if(c)return 4;g=n+1;for(l=b.length;g<l&&11==b[g];)g++;return g<
l&&2==b[g]?2:4;case 12:l=b.length;for(g=n+1;g<l&&12==b[g];)g++;return g<l&&(a=a[n],g=b[g],(1425<=a&&2303>=a||64286==a)&&(1==g||7==g))?1:1>n||5==b[n-1]?4:e[n-1];case 5:return c=!1,f=!0,d;case 6:return w=!0,4;case 13:case 14:case 16:case 17:case 15:c=!1;case 18:return 4}}function g(a){var b=a.charCodeAt(0),c=b>>8;return 0==c?191<b?0:l[b]:5==c?/[\u0591-\u05f4]/.test(a)?1:0:6==c?/[\u0610-\u061a\u064b-\u065f\u06d6-\u06e4\u06e7-\u06ed]/.test(a)?12:/[\u0660-\u0669\u066b-\u066c]/.test(a)?3:1642==b?11:/[\u06f0-\u06f9]/.test(a)?
2:7:32==c&&8287>=b?u[b&255]:254==c?65136<=b?7:4:4}var d=0,a=0,c=!1,f=!1,w=!1,m=[[0,3,0,1,0,0,0],[0,3,0,1,2,2,0],[0,3,0,17,2,0,1],[0,3,5,5,4,1,0],[0,3,21,21,4,0,1],[0,3,5,5,4,2,0]],p=[[2,0,1,1,0,1,0],[2,0,1,1,0,2,0],[2,0,2,1,3,2,0],[2,0,2,33,3,1,1]],l=[18,18,18,18,18,18,18,18,18,6,5,6,8,5,18,18,18,18,18,18,18,18,18,18,18,18,18,18,5,5,5,6,8,4,4,11,11,11,4,4,4,4,4,10,9,10,9,9,2,2,2,2,2,2,2,2,2,2,9,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,18,18,18,18,18,18,5,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,9,4,11,11,11,11,4,4,4,4,0,4,4,18,4,4,11,11,2,2,4,0,4,4,4,2,0,4,4,4,4,4],u=[8,8,8,8,8,8,8,8,8,8,8,18,18,18,0,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,8,5,13,14,15,16,17,9,11,11,11,11,11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,9,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,8];e.L=0;e.R=1;e.EN=2;e.ON_R=3;e.AN=4;e.R_H=5;e.B=6;e.RLE=7;e.DOT="\u00b7";e.doBidiReorder=function(b,
l,q){if(2>b.length)return{};b=b.split("");var n=Array(b.length),v=Array(b.length),u=[];d=q?1:0;q=b.length;var A=l,H=d?p:m;var h=0;var r=-1,t,B=[];if(!A){var G=0;for(A=[];G<q;G++)A[G]=g(b[G])}a=d;w=f=c=!1;for(t=0;t<q;t++){var y=h;B[t]=h=x(b,A,B,t);h=H[y][h];G=h&240;h&=15;u[t]=y=H[h][5];if(0<G){if(16==G)for(G=r;G<t;G++)u[G]=1;r=-1}if(G=H[h][6])-1==r&&(r=t);else if(-1<r){for(G=r;G<t;G++)u[G]=y;r=-1}5==A[t]&&(u[t]=0);a|=y}if(w)for(G=0;G<q;G++)if(6==A[G])for(u[G]=d,H=G-1;0<=H;H--)if(8==A[H])u[H]=d;else break;
for(q=0;q<n.length;n[q]=q,q++);k(2,u,n);k(1,u,n);for(q=0;q<n.length-1;q++)3===l[q]?u[q]=e.AN:1===u[q]&&(7<l[q]&&13>l[q]||4===l[q]||18===l[q])?u[q]=e.ON_R:0<q&&"\u0644"===b[q-1]&&/\u0622|\u0623|\u0625|\u0627/.test(b[q])&&(u[q-1]=u[q]=e.R_H,q++);b[b.length-1]===e.DOT&&(u[b.length-1]=e.B);"\u202b"===b[0]&&(u[0]=e.RLE);for(q=0;q<n.length;q++)v[q]=u[n[q]];return{logicalFromVisual:n,bidiLevels:v}};e.hasBidiCharacters=function(a,b){for(var c=!1,d=0;d<a.length;d++)b[d]=g(a.charAt(d)),c||1!=b[d]&&7!=b[d]&&
3!=b[d]||(c=!0);return c};e.getVisualFromLogicalIdx=function(a,b){for(var c=0;c<b.logicalFromVisual.length;c++)if(b.logicalFromVisual[c]==a)return c;return 0}});ace.define("ace/bidihandler",["require","exports","module","ace/lib/bidiutil","ace/lib/lang"],function(b,e,h){var k=b("./lib/bidiutil"),x=b("./lib/lang"),g=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\u202B]/;b=function(b){this.session=b;this.bidiMap={};this.currentRow=null;this.bidiUtil=k;this.charWidths=[];this.EOL="\u00ac";this.showInvisibles=
!0;this.$isRtl=this.isRtlDir=!1;this.line="";this.wrapIndent=0;this.EOF="\u00b6";this.RLE="\u202b";this.contentWidth=0;this.fontMetrics=null;this.wrapOffset=this.rtlLineOffset=0;this.isMoveLeftOperation=!1;this.seenBidi=g.test(b.getValue())};(function(){this.isBidiRow=function(b,a,c){if(!this.seenBidi)return!1;b!==this.currentRow&&(this.currentRow=b,this.updateRowLine(a,c),this.updateBidiMap());return this.bidiMap.bidiLevels};this.onChange=function(b){this.seenBidi?this.currentRow=null:"insert"==
b.action&&g.test(b.lines.join("\n"))&&(this.seenBidi=!0,this.currentRow=null)};this.getDocumentRow=function(){var b=0,a=this.session.$screenRowCache;a.length&&(a=this.session.$getRowCacheIndex(a,this.currentRow),0<=a&&(b=this.session.$docRowCache[a]));return b};this.getSplitIndex=function(){var b=0,a=this.session.$screenRowCache;if(a.length)for(var c,f=this.session.$getRowCacheIndex(a,this.currentRow);0<this.currentRow-b;){c=this.session.$getRowCacheIndex(a,this.currentRow-b-1);if(c!==f)break;f=c;
b++}else b=this.currentRow;return b};this.updateRowLine=function(b,a){void 0===b&&(b=this.getDocumentRow());var c=b===this.session.getLength()-1?this.EOF:this.EOL;this.wrapIndent=0;this.line=this.session.getLine(b);this.isRtlDir=this.$isRtl||this.line.charAt(0)===this.RLE;if(this.session.$useWrapMode){if(b=this.session.$wrapData[b])void 0===a&&(a=this.getSplitIndex()),0<a&&b.length?(this.wrapIndent=b.indent,this.wrapOffset=this.wrapIndent*this.charWidths[k.L],this.line=a<b.length?this.line.substring(b[a-
1],b[a]):this.line.substring(b[b.length-1])):this.line=this.line.substring(0,b[a]);a==b.length&&(this.line+=this.showInvisibles?c:k.DOT)}else this.line+=this.showInvisibles?c:k.DOT;var d=this.session,e=0,g;this.line=this.line.replace(/\t|[\u1100-\u2029, \u202F-\uFFE6]/g,function(a,b){return"\t"===a||d.isFullWidth(a.charCodeAt(0))?(g="\t"===a?d.getScreenTabSize(b+e):2,e+=g-1,x.stringRepeat(k.DOT,g)):a});this.isRtlDir&&(this.fontMetrics.$main.textContent=this.line.charAt(this.line.length-1)==k.DOT?
this.line.substr(0,this.line.length-1):this.line,this.rtlLineOffset=this.contentWidth-this.fontMetrics.$main.getBoundingClientRect().width)};this.updateBidiMap=function(){var b=[];k.hasBidiCharacters(this.line,b)||this.isRtlDir?this.bidiMap=k.doBidiReorder(this.line,b,this.isRtlDir):this.bidiMap={}};this.markAsDirty=function(){this.currentRow=null};this.updateCharacterWidths=function(b){if(this.characterWidth!==b.$characterSize.width){this.fontMetrics=b;var a=this.characterWidth=b.$characterSize.width;
b=b.$measureCharWidth("\u05d4");this.charWidths[k.L]=this.charWidths[k.EN]=this.charWidths[k.ON_R]=a;this.charWidths[k.R]=this.charWidths[k.AN]=b;this.charWidths[k.R_H]=.45*b;this.charWidths[k.B]=this.charWidths[k.RLE]=0;this.currentRow=null}};this.setShowInvisibles=function(b){this.showInvisibles=b;this.currentRow=null};this.setEolChar=function(b){this.EOL=b};this.setContentWidth=function(b){this.contentWidth=b};this.isRtlLine=function(b){return this.$isRtl?!0:void 0!=b?this.session.getLine(b).charAt(0)==
this.RLE:this.isRtlDir};this.setRtlDirection=function(b,a){for(var c=b.getCursorPosition(),d=b.selection.getSelectionAnchor().row;d<=c.row;d++)a||b.session.getLine(d).charAt(0)!==b.session.$bidiHandler.RLE?a&&b.session.getLine(d).charAt(0)!==b.session.$bidiHandler.RLE&&b.session.doc.insert({column:0,row:d},b.session.$bidiHandler.RLE):b.session.doc.removeInLine(d,0,1)};this.getPosLeft=function(b){b-=this.wrapIndent;var a=this.line.charAt(0)===this.RLE?1:0,c=b>a?this.session.getOverwrite()?b:b-1:a;
c=k.getVisualFromLogicalIdx(c,this.bidiMap);var d=this.bidiMap.bidiLevels,e=0;!this.session.getOverwrite()&&b<=a&&0!==d[c]%2&&c++;for(var g=0;g<c;g++)e+=this.charWidths[d[g]];!this.session.getOverwrite()&&b>a&&0===d[c]%2&&(e+=this.charWidths[d[c]]);this.wrapIndent&&(e+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);this.isRtlDir&&(e+=this.rtlLineOffset);return e};this.getSelections=function(b,a){var c=this.bidiMap,d=c.bidiLevels,e=[],g=0,p=Math.min(b,a)-this.wrapIndent;a=Math.max(b,a)-this.wrapIndent;
var l=!1,u=!1,v=0;this.wrapIndent&&(g+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);for(var k=0;k<d.length;k++)l=c.logicalFromVisual[k],b=d[k],(l=l>=p&&l<a)&&!u?v=g:!l&&u&&e.push({left:v,width:g-v}),g+=this.charWidths[b],u=l;l&&k===d.length&&e.push({left:v,width:g-v});if(this.isRtlDir)for(c=0;c<e.length;c++)e[c].left+=this.rtlLineOffset;return e};this.offsetToCol=function(b){this.isRtlDir&&(b-=this.rtlLineOffset);b=Math.max(b,0);var a=0,c=0,d=this.bidiMap.bidiLevels,e=this.charWidths[d[c]];for(this.wrapIndent&&
(b-=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);b>a+e/2;){a+=e;if(c===d.length-1){e=0;break}e=this.charWidths[d[++c]]}0<c&&0!==d[c-1]%2&&0===d[c]%2?(b<a&&c--,b=this.bidiMap.logicalFromVisual[c]):0<c&&0===d[c-1]%2&&0!==d[c]%2?b=1+(b>a?this.bidiMap.logicalFromVisual[c]:this.bidiMap.logicalFromVisual[c-1]):this.isRtlDir&&c===d.length-1&&0===e&&0===d[c-1]%2||!this.isRtlDir&&0===c&&0!==d[c]%2?b=1+this.bidiMap.logicalFromVisual[c]:(0<c&&0!==d[c-1]%2&&0!==e&&c--,b=this.bidiMap.logicalFromVisual[c]);
0===b&&this.isRtlDir&&b++;return b+this.wrapIndent}}).call(b.prototype);e.BidiHandler=b});ace.define("ace/selection","require exports module ace/lib/oop ace/lib/lang ace/lib/event_emitter ace/range".split(" "),function(b,e,h){var k=b("./lib/oop"),x=b("./lib/lang"),g=b("./lib/event_emitter").EventEmitter,d=b("./range").Range;b=function(a){this.session=a;this.doc=a.getDocument();this.clearSelection();this.cursor=this.lead=this.doc.createAnchor(0,0);this.anchor=this.doc.createAnchor(0,0);this.$silent=
!1;var b=this;this.cursor.on("change",function(a){b.$cursorChanged=!0;b.$silent||b._emit("changeCursor");b.$isEmpty||b.$silent||b._emit("changeSelection");b.$keepDesiredColumnOnChange||a.old.column==a.value.column||(b.$desiredColumn=null)});this.anchor.on("change",function(){b.$anchorChanged=!0;b.$isEmpty||b.$silent||b._emit("changeSelection")})};(function(){k.implement(this,g);this.isEmpty=function(){return this.$isEmpty||this.anchor.row==this.lead.row&&this.anchor.column==this.lead.column};this.isMultiLine=
function(){return!this.$isEmpty&&this.anchor.row!=this.cursor.row};this.getCursor=function(){return this.lead.getPosition()};this.setSelectionAnchor=function(a,b){this.$isEmpty=!1;this.anchor.setPosition(a,b)};this.getAnchor=this.getSelectionAnchor=function(){return this.$isEmpty?this.getSelectionLead():this.anchor.getPosition()};this.getSelectionLead=function(){return this.lead.getPosition()};this.isBackwards=function(){var a=this.anchor,b=this.lead;return a.row>b.row||a.row==b.row&&a.column>b.column};
this.getRange=function(){var a=this.anchor,b=this.lead;return this.$isEmpty?d.fromPoints(b,b):this.isBackwards()?d.fromPoints(b,a):d.fromPoints(a,b)};this.clearSelection=function(){this.$isEmpty||(this.$isEmpty=!0,this._emit("changeSelection"))};this.selectAll=function(){this.$setSelection(0,0,Number.MAX_VALUE,Number.MAX_VALUE)};this.setRange=this.setSelectionRange=function(a,b){var c=b?a.end:a.start;a=b?a.start:a.end;this.$setSelection(c.row,c.column,a.row,a.column)};this.$setSelection=function(a,
b,f,e){if(!this.$silent){var c=this.$isEmpty,g=this.inMultiSelectMode;this.$silent=!0;this.$cursorChanged=this.$anchorChanged=!1;this.anchor.setPosition(a,b);this.cursor.setPosition(f,e);this.$isEmpty=!d.comparePoints(this.anchor,this.cursor);this.$silent=!1;this.$cursorChanged&&this._emit("changeCursor");(this.$cursorChanged||this.$anchorChanged||c!=this.$isEmpty||g)&&this._emit("changeSelection")}};this.$moveSelection=function(a){var b=this.lead;this.$isEmpty&&this.setSelectionAnchor(b.row,b.column);
a.call(this)};this.selectTo=function(a,b){this.$moveSelection(function(){this.moveCursorTo(a,b)})};this.selectToPosition=function(a){this.$moveSelection(function(){this.moveCursorToPosition(a)})};this.moveTo=function(a,b){this.clearSelection();this.moveCursorTo(a,b)};this.moveToPosition=function(a){this.clearSelection();this.moveCursorToPosition(a)};this.selectUp=function(){this.$moveSelection(this.moveCursorUp)};this.selectDown=function(){this.$moveSelection(this.moveCursorDown)};this.selectRight=
function(){this.$moveSelection(this.moveCursorRight)};this.selectLeft=function(){this.$moveSelection(this.moveCursorLeft)};this.selectLineStart=function(){this.$moveSelection(this.moveCursorLineStart)};this.selectLineEnd=function(){this.$moveSelection(this.moveCursorLineEnd)};this.selectFileEnd=function(){this.$moveSelection(this.moveCursorFileEnd)};this.selectFileStart=function(){this.$moveSelection(this.moveCursorFileStart)};this.selectWordRight=function(){this.$moveSelection(this.moveCursorWordRight)};
this.selectWordLeft=function(){this.$moveSelection(this.moveCursorWordLeft)};this.getWordRange=function(a,b){"undefined"==typeof b&&(b=a||this.lead,a=b.row,b=b.column);return this.session.getWordRange(a,b)};this.selectWord=function(){this.setSelectionRange(this.getWordRange())};this.selectAWord=function(){var a=this.getCursor();a=this.session.getAWordRange(a.row,a.column);this.setSelectionRange(a)};this.getLineRange=function(a,b){a="number"==typeof a?a:this.lead.row;var c;(c=this.session.getFoldLine(a))?
(a=c.start.row,c=c.end.row):c=a;return!0===b?new d(a,0,c,this.session.getLine(c).length):new d(a,0,c+1,0)};this.selectLine=function(){this.setSelectionRange(this.getLineRange())};this.moveCursorUp=function(){this.moveCursorBy(-1,0)};this.moveCursorDown=function(){this.moveCursorBy(1,0)};this.wouldMoveIntoSoftTab=function(a,b,d){var c=a.column,f=a.column+b;0>d&&(c=a.column-b,f=a.column);return this.session.isTabStop(a)&&this.doc.getLine(a.row).slice(c,f).split(" ").length-1==b};this.moveCursorLeft=
function(){var a=this.lead.getPosition(),b;(b=this.session.getFoldAt(a.row,a.column,-1))?this.moveCursorTo(b.start.row,b.start.column):0===a.column?0<a.row&&this.moveCursorTo(a.row-1,this.doc.getLine(a.row-1).length):(b=this.session.getTabSize(),this.wouldMoveIntoSoftTab(a,b,-1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,-b):this.moveCursorBy(0,-1))};this.moveCursorRight=function(){var a=this.lead.getPosition();if(a=this.session.getFoldAt(a.row,a.column,1))this.moveCursorTo(a.end.row,
a.end.column);else if(this.lead.column==this.doc.getLine(this.lead.row).length)this.lead.row<this.doc.getLength()-1&&this.moveCursorTo(this.lead.row+1,0);else{var b=this.session.getTabSize();a=this.lead;this.wouldMoveIntoSoftTab(a,b,1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,b):this.moveCursorBy(0,1)}};this.moveCursorLineStart=function(){var a=this.lead.row,b=this.lead.column,d=this.session.documentToScreenRow(a,b);d=this.session.screenToDocumentPosition(d,0);a=this.session.getDisplayLine(a,
null,d.row,d.column).match(/^\s*/);a[0].length==b||this.session.$useEmacsStyleLineStart||(d.column+=a[0].length);this.moveCursorToPosition(d)};this.moveCursorLineEnd=function(){var a=this.lead;a=this.session.getDocumentLastRowColumnPosition(a.row,a.column);if(this.lead.column==a.column){var b=this.session.getLine(a.row);a.column==b.length&&(b=b.search(/\s+$/),0<b&&(a.column=b))}this.moveCursorTo(a.row,a.column)};this.moveCursorFileEnd=function(){var a=this.doc.getLength()-1,b=this.doc.getLine(a).length;
this.moveCursorTo(a,b)};this.moveCursorFileStart=function(){this.moveCursorTo(0,0)};this.moveCursorLongWordRight=function(){var a=this.lead.row,b=this.lead.column,d=this.doc.getLine(a),e=d.substring(b);this.session.nonTokenRe.lastIndex=0;this.session.tokenRe.lastIndex=0;var g=this.session.getFoldAt(a,b,1);g?this.moveCursorTo(g.end.row,g.end.column):(this.session.nonTokenRe.exec(e)&&(b+=this.session.nonTokenRe.lastIndex,this.session.nonTokenRe.lastIndex=0,e=d.substring(b)),b>=d.length?(this.moveCursorTo(a,
d.length),this.moveCursorRight(),a<this.doc.getLength()-1&&this.moveCursorWordRight()):(this.session.tokenRe.exec(e)&&(b+=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(a,b)))};this.moveCursorLongWordLeft=function(){var a=this.lead.row,b=this.lead.column,d;(d=this.session.getFoldAt(a,b,-1))?this.moveCursorTo(d.start.row,d.start.column):(d=this.session.getFoldStringAt(a,b,-1),null==d&&(d=this.doc.getLine(a).substring(0,b)),d=x.stringReverse(d),this.session.nonTokenRe.lastIndex=
0,this.session.tokenRe.lastIndex=0,this.session.nonTokenRe.exec(d)&&(b-=this.session.nonTokenRe.lastIndex,d=d.slice(this.session.nonTokenRe.lastIndex),this.session.nonTokenRe.lastIndex=0),0>=b?(this.moveCursorTo(a,0),this.moveCursorLeft(),0<a&&this.moveCursorWordLeft()):(this.session.tokenRe.exec(d)&&(b-=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(a,b)))};this.$shortWordEndIndex=function(a){var b=0,d,e=/\s/,g=this.session.tokenRe;g.lastIndex=0;if(this.session.tokenRe.exec(a))b=
this.session.tokenRe.lastIndex;else{for(;(d=a[b])&&e.test(d);)b++;if(1>b)for(g.lastIndex=0;(d=a[b])&&!g.test(d);)if(g.lastIndex=0,b++,e.test(d))if(2<b){b--;break}else{for(;(d=a[b])&&e.test(d);)b++;if(2<b)break}}g.lastIndex=0;return b};this.moveCursorShortWordRight=function(){var a=this.lead.row,b=this.lead.column,d=this.doc.getLine(a),e=d.substring(b),g=this.session.getFoldAt(a,b,1);if(g)return this.moveCursorTo(g.end.row,g.end.column);if(b==d.length){b=this.doc.getLength();do a++,e=this.doc.getLine(a);
while(a<b&&/^\s*$/.test(e));/^\s+/.test(e)||(e="");b=0}e=this.$shortWordEndIndex(e);this.moveCursorTo(a,b+e)};this.moveCursorShortWordLeft=function(){var a=this.lead.row,b=this.lead.column,d;if(d=this.session.getFoldAt(a,b,-1))return this.moveCursorTo(d.start.row,d.start.column);d=this.session.getLine(a).substring(0,b);if(0===b){do a--,d=this.doc.getLine(a);while(0<a&&/^\s*$/.test(d));b=d.length;/\s+$/.test(d)||(d="")}d=x.stringReverse(d);d=this.$shortWordEndIndex(d);return this.moveCursorTo(a,b-
d)};this.moveCursorWordRight=function(){this.session.$selectLongWords?this.moveCursorLongWordRight():this.moveCursorShortWordRight()};this.moveCursorWordLeft=function(){this.session.$selectLongWords?this.moveCursorLongWordLeft():this.moveCursorShortWordLeft()};this.moveCursorBy=function(a,b){var c=this.session.documentToScreenPosition(this.lead.row,this.lead.column);if(0===b){if(0!==a)if(this.session.$bidiHandler.isBidiRow(c.row,this.lead.row)){var d=this.session.$bidiHandler.getPosLeft(c.column);
c.column=Math.round(d/this.session.$bidiHandler.charWidths[0])}else d=c.column*this.session.$bidiHandler.charWidths[0];this.$desiredColumn?c.column=this.$desiredColumn:this.$desiredColumn=c.column}if(0!=a&&this.session.lineWidgets&&this.session.lineWidgets[this.lead.row]){var e=this.session.lineWidgets[this.lead.row];0>a?a-=e.rowsAbove||0:0<a&&(a+=e.rowCount-(e.rowsAbove||0))}a=this.session.screenToDocumentPosition(c.row+a,c.column,d);this.moveCursorTo(a.row,a.column+b,0===b)};this.moveCursorToPosition=
function(a){this.moveCursorTo(a.row,a.column)};this.moveCursorTo=function(a,b,d){var c=this.session.getFoldAt(a,b,1);c&&(a=c.start.row,b=c.start.column);this.$keepDesiredColumnOnChange=!0;c=this.session.getLine(a);/[\uDC00-\uDFFF]/.test(c.charAt(b))&&c.charAt(b-1)&&(b=this.lead.row==a&&this.lead.column==b+1?b-1:b+1);this.lead.setPosition(a,b);this.$keepDesiredColumnOnChange=!1;d||(this.$desiredColumn=null)};this.moveCursorToScreen=function(a,b,d){a=this.session.screenToDocumentPosition(a,b);this.moveCursorTo(a.row,
a.column,d)};this.detach=function(){this.lead.detach();this.anchor.detach();this.session=this.doc=null};this.fromOrientedRange=function(a){this.setSelectionRange(a,a.cursor==a.start);this.$desiredColumn=a.desiredColumn||this.$desiredColumn};this.toOrientedRange=function(a){var b=this.getRange();a?(a.start.column=b.start.column,a.start.row=b.start.row,a.end.column=b.end.column,a.end.row=b.end.row):a=b;a.cursor=this.isBackwards()?a.start:a.end;a.desiredColumn=this.$desiredColumn;return a};this.getRangeOfMovements=
function(a){var b=this.getCursor();try{a(this);var f=this.getCursor();return d.fromPoints(b,f)}catch(w){return d.fromPoints(b,b)}finally{this.moveCursorToPosition(b)}};this.toJSON=function(){if(this.rangeCount)var a=this.ranges.map(function(a){var b=a.clone();b.isBackwards=a.cursor==a.start;return b});else a=this.getRange(),a.isBackwards=this.isBackwards();return a};this.fromJSON=function(a){if(void 0==a.start){if(this.rangeList&&1<a.length){this.toSingleRange(a[0]);for(var b=a.length;b--;){var f=
d.fromPoints(a[b].start,a[b].end);a[b].isBackwards&&(f.cursor=f.start);this.addRange(f,!0)}return}a=a[0]}this.rangeList&&this.toSingleRange(a);this.setSelectionRange(a,a.isBackwards)};this.isEqual=function(a){if((a.length||this.rangeCount)&&a.length!=this.rangeCount)return!1;if(!a.length||!this.ranges)return this.getRange().isEqual(a);for(var b=this.ranges.length;b--;)if(!this.ranges[b].isEqual(a[b]))return!1;return!0}}).call(b.prototype);e.Selection=b});ace.define("ace/tokenizer",["require","exports",
"module","ace/config"],function(b,e,h){var k=b("./config"),x=2E3;b=function(b){this.states=b;this.regExps={};this.matchMappings={};for(var d in this.states){b=this.states[d];for(var a=[],c=0,f=this.matchMappings[d]={defaultToken:"text"},e="g",g=[],p=0;p<b.length;p++){var l=b[p];l.defaultToken&&(f.defaultToken=l.defaultToken);l.caseInsensitive&&(e="gi");if(null!=l.regex){l.regex instanceof RegExp&&(l.regex=l.regex.toString().slice(1,-1));var u=l.regex,v=(new RegExp("(?:("+u+")|(.))")).exec("a").length-
2;Array.isArray(l.token)?1==l.token.length||1==v?l.token=l.token[0]:v-1!=l.token.length?(this.reportError("number of classes and regexp groups doesn't match",{rule:l,groupCount:v-1}),l.token=l.token[0]):(l.tokenArray=l.token,l.token=null,l.onMatch=this.$arrayTokens):"function"!=typeof l.token||l.onMatch||(l.onMatch=1<v?this.$applyToken:l.token);1<v&&(/\\\d/.test(l.regex)?u=l.regex.replace(/\\([0-9]+)/g,function(a,b){return"\\"+(parseInt(b,10)+c+1)}):(v=1,u=this.removeCapturingGroups(l.regex)),l.splitRegex||
"string"==typeof l.token||g.push(l));f[c]=p;c+=v;a.push(u);l.onMatch||(l.onMatch=null)}}a.length||(f[0]=0,a.push("$"));g.forEach(function(a){a.splitRegex=this.createSplitterRegexp(a.regex,e)},this);this.regExps[d]=new RegExp("("+a.join(")|(")+")|($)",e)}};(function(){this.$setMaxTokenCount=function(b){x=b|0};this.$applyToken=function(b){var d=this.splitRegex.exec(b).slice(1),a=this.token.apply(this,d);if("string"===typeof a)return[{type:a,value:b}];b=[];for(var c=0,f=a.length;c<f;c++)d[c]&&(b[b.length]=
{type:a[c],value:d[c]});return b};this.$arrayTokens=function(b){if(!b)return[];b=this.splitRegex.exec(b);if(!b)return"text";for(var d=[],a=this.tokenArray,c=0,f=a.length;c<f;c++)b[c+1]&&(d[d.length]={type:a[c],value:b[c+1]});return d};this.removeCapturingGroups=function(b){return b.replace(/\\.|\[(?:\\.|[^\\\]])*|\(\?[:=!]|(\()/g,function(b,a){return a?"(?:":b})};this.createSplitterRegexp=function(b,d){if(-1!=b.indexOf("(?=")){var a=0,c=!1,f={};b.replace(/(\\.)|(\((?:\?[=!])?)|(\))|([\[\]])/g,function(b,
d,e,l,g,v){c?c="]"!=g:g?c=!0:l?(a==f.stack&&(f.end=v+1,f.stack=-1),a--):e&&(a++,1!=e.length&&(f.stack=a,f.start=v));return b});null!=f.end&&/^\)*$/.test(b.substr(f.end))&&(b=b.substring(0,f.start)+b.substr(f.end))}"^"!=b.charAt(0)&&(b="^"+b);"$"!=b.charAt(b.length-1)&&(b+="$");return new RegExp(b,(d||"").replace("g",""))};this.getLineTokens=function(b,d){if(d&&"string"!=typeof d){var a=d.slice(0);d=a[0];"#tmp"===d&&(a.shift(),d=a.shift())}else a=[];var c=d||"start",f=this.states[c];f||(c="start",
f=this.states[c]);var e=this.matchMappings[c],g=this.regExps[c];g.lastIndex=0;for(var p,l=[],u=0,v=0,k={type:null,value:""};p=g.exec(b);){var q=e.defaultToken,n=null,J=p[0],h=g.lastIndex;if(h-J.length>u){var z=b.substring(u,h-J.length);k.type==q?k.value+=z:(k.type&&l.push(k),k={type:q,value:z})}for(z=0;z<p.length-2;z++)if(void 0!==p[z+1]){n=f[e[z]];q=n.onMatch?n.onMatch(J,c,a,b):n.token;n.next&&(c="string"==typeof n.next?n.next:n.next(c,a),f=this.states[c],f||(this.reportError("state doesn't exist",
c),c="start",f=this.states[c]),e=this.matchMappings[c],u=h,g=this.regExps[c],g.lastIndex=h);n.consumeLineEnd&&(u=h);break}if(J)if("string"===typeof q)n&&!1===n.merge||k.type!==q?(k.type&&l.push(k),k={type:q,value:J}):k.value+=J;else if(q)for(k.type&&l.push(k),k={type:null,value:""},z=0;z<q.length;z++)l.push(q[z]);if(u==b.length)break;u=h;if(v++>x){for(v>2*b.length&&this.reportError("infinite loop with in ace tokenizer",{startState:d,line:b});u<b.length;)k.type&&l.push(k),k={value:b.substring(u,u+=
500),type:"overflow"};c="start";a=[];break}}k.type&&l.push(k);1<a.length&&a[0]!==c&&a.unshift("#tmp",c);return{tokens:l,state:a.length?a:c}};this.reportError=k.reportError}).call(b.prototype);e.Tokenizer=b});ace.define("ace/mode/text_highlight_rules",["require","exports","module","ace/lib/lang"],function(b,e,h){var k=b("../lib/lang");b=function(){this.$rules={start:[{token:"empty_line",regex:"^$"},{defaultToken:"text"}]}};(function(){this.addRules=function(b,a){if(a)for(g in b){for(var c=b[g],d=0;d<
c.length;d++){var e=c[d];if(e.next||e.onMatch)"string"==typeof e.next&&0!==e.next.indexOf(a)&&(e.next=a+e.next),e.nextState&&0!==e.nextState.indexOf(a)&&(e.nextState=a+e.nextState)}this.$rules[a+g]=c}else for(var g in b)this.$rules[g]=b[g]};this.getRules=function(){return this.$rules};this.embedRules=function(b,a,c,f,e){b="function"==typeof b?(new b).getRules():b;if(f)for(var d=0;d<f.length;d++)f[d]=a+f[d];else for(d in f=[],b)f.push(a+d);this.addRules(b,a);if(c)for(e=Array.prototype[e?"push":"unshift"],
d=0;d<f.length;d++)e.apply(this.$rules[f[d]],k.deepCopy(c));this.$embeds||(this.$embeds=[]);this.$embeds.push(a)};this.getEmbeds=function(){return this.$embeds};var b=function(b,a){("start"!=b||a.length)&&a.unshift(this.nextState,b);return this.nextState},e=function(b,a){a.shift();return a.shift()||"start"};this.normalizeRules=function(){function d(f){f=c[f];f.processed=!0;for(var g=0;g<f.length;g++){var m=f[g],p=null;Array.isArray(m)&&(p=m,m={});!m.regex&&m.start&&(m.regex=m.start,m.next||(m.next=
[]),m.next.push({defaultToken:m.token},{token:m.token+".end",regex:m.end||m.start,next:"pop"}),m.token+=".start",m.push=!0);var l=m.next||m.push;if(l&&Array.isArray(l)){var u=m.stateName;u||(u=m.token,"string"!=typeof u&&(u=u[0]||""),c[u]&&(u+=a++));c[u]=l;m.next=u;d(u)}else"pop"==l&&(m.next=e);m.push&&(m.nextState=m.next||m.push,m.next=b,delete m.push);if(m.rules)for(var v in m.rules)c[v]?c[v].push&&c[v].push.apply(c[v],m.rules[v]):c[v]=m.rules[v];(l="string"==typeof m?m:m.include)&&(p=Array.isArray(l)?
l.map(function(a){return c[a]}):c[l]);p&&(p=[g,1].concat(p),m.noEscape&&(p=p.filter(function(a){return!a.next})),f.splice.apply(f,p),g--);m.keywordMap&&(m.token=this.createKeywordMapper(m.keywordMap,m.defaultToken||"text",m.caseInsensitive),delete m.defaultToken)}}var a=0,c=this.$rules;Object.keys(c).forEach(d,this)};this.createKeywordMapper=function(b,a,c,f){var d=Object.create(null);this.$keywordList=[];Object.keys(b).forEach(function(a){for(var e=b[a].split(f||"|"),l=e.length;l--;){var g=e[l];
this.$keywordList.push(g);c&&(g=g.toLowerCase());d[g]=a}},this);b=null;return c?function(b){return d[b.toLowerCase()]||a}:function(b){return d[b]||a}};this.getKeywords=function(){return this.$keywords}}).call(b.prototype);e.TextHighlightRules=b});ace.define("ace/mode/behaviour",["require","exports","module"],function(b,e,h){b=function(){this.$behaviours={}};(function(){this.add=function(b,e,g){switch(void 0){case this.$behaviours:this.$behaviours={};case this.$behaviours[b]:this.$behaviours[b]={}}this.$behaviours[b][e]=
g};this.addBehaviours=function(b){for(var e in b)for(var g in b[e])this.add(e,g,b[e][g])};this.remove=function(b){this.$behaviours&&this.$behaviours[b]&&delete this.$behaviours[b]};this.inherit=function(b,e){b="function"===typeof b?(new b).getBehaviours(e):b.getBehaviours(e);this.addBehaviours(b)};this.getBehaviours=function(b){if(b){for(var e={},g=0;g<b.length;g++)this.$behaviours[b[g]]&&(e[b[g]]=this.$behaviours[b[g]]);return e}return this.$behaviours}}).call(b.prototype);e.Behaviour=b});ace.define("ace/token_iterator",
["require","exports","module","ace/range"],function(b,e,h){var k=b("./range").Range;b=function(b,e,d){this.$session=b;this.$row=e;this.$rowTokens=b.getTokens(e);this.$tokenIndex=(b=b.getTokenAt(e,d))?b.index:-1};(function(){this.stepBackward=function(){for(--this.$tokenIndex;0>this.$tokenIndex;){--this.$row;if(0>this.$row)return this.$row=0,null;this.$rowTokens=this.$session.getTokens(this.$row);this.$tokenIndex=this.$rowTokens.length-1}return this.$rowTokens[this.$tokenIndex]};this.stepForward=function(){this.$tokenIndex+=
1;for(var b;this.$tokenIndex>=this.$rowTokens.length;){this.$row+=1;b||(b=this.$session.getLength());if(this.$row>=b)return this.$row=b-1,null;this.$rowTokens=this.$session.getTokens(this.$row);this.$tokenIndex=0}return this.$rowTokens[this.$tokenIndex]};this.getCurrentToken=function(){return this.$rowTokens[this.$tokenIndex]};this.getCurrentTokenRow=function(){return this.$row};this.getCurrentTokenColumn=function(){var b=this.$rowTokens,e=this.$tokenIndex,d=b[e].start;if(void 0!==d)return d;for(d=
0;0<e;)--e,d+=b[e].value.length;return d};this.getCurrentTokenPosition=function(){return{row:this.$row,column:this.getCurrentTokenColumn()}};this.getCurrentTokenRange=function(){var b=this.$rowTokens[this.$tokenIndex],e=this.getCurrentTokenColumn();return new k(this.$row,e,this.$row,e+b.value.length)}}).call(b.prototype);e.TokenIterator=b});ace.define("ace/mode/behaviour/cstyle","require exports module ace/lib/oop ace/mode/behaviour ace/token_iterator ace/lib/lang".split(" "),function(b,e,h){h=b("../../lib/oop");
var k=b("../behaviour").Behaviour,x=b("../../token_iterator").TokenIterator,g=b("../../lib/lang"),d=["text","paren.rparen","rparen","paren","punctuation.operator"],a="text paren.rparen rparen paren punctuation.operator comment".split(" "),c,f={},w={'"':'"',"'":"'"},m=function(a){var b=-1;a.multiSelect&&(b=a.selection.index,f.rangeCount!=a.multiSelect.rangeCount&&(f={rangeCount:a.multiSelect.rangeCount}));if(f[b])return c=f[b];c=f[b]={autoInsertedBrackets:0,autoInsertedRow:-1,autoInsertedLineEnd:"",
maybeInsertedBrackets:0,maybeInsertedRow:-1,maybeInsertedLineStart:"",maybeInsertedLineEnd:""}},p=function(a,b,c,d){var f=a.end.row-a.start.row;return{text:c+b+d,selection:[0,a.start.column+1,f,a.end.column+(f?0:1)]}},l=function(a){this.add("braces","insertion",function(b,d,f,e,w){b=f.getCursorPosition();d=e.doc.getLine(b.row);if("{"==w){m(f);w=f.getSelectionRange();var n=e.doc.getTextRange(w);if(""!==n&&"{"!==n&&f.getWrapBehavioursEnabled())return p(w,n,"{","}");if(l.isSaneInsertion(f,e)){if(/[\]\}\)]/.test(d[b.column])||
f.inMultiSelectMode||a&&a.braces)return l.recordAutoInsert(f,e,"}"),{text:"{}",selection:[1,1]};l.recordMaybeInsert(f,e,"{");return{text:"{",selection:[1,1]}}}else if("}"==w){if(m(f),n=d.substring(b.column,b.column+1),"}"==n&&null!==e.$findOpeningBracket("}",{column:b.column+1,row:b.row})&&l.isAutoInsertedClosing(b,d,w))return l.popAutoInsertedClosing(),{text:"",selection:[1,1]}}else{if("\n"==w||"\r\n"==w){m(f);f="";l.isMaybeInsertedClosing(b,d)&&(f=g.stringRepeat("}",c.maybeInsertedBrackets),l.clearMaybeInsertedClosing());
n=d.substring(b.column,b.column+1);if("}"===n){b=e.findMatchingBracket({row:b.row,column:b.column+1},"}");if(!b)return null;b=this.$getIndent(e.getLine(b.row))}else if(f)b=this.$getIndent(d);else{l.clearMaybeInsertedClosing();return}e=b+e.getTabString();return{text:"\n"+e+"\n"+b+f,selection:[1,e.length,1,e.length]}}l.clearMaybeInsertedClosing()}});this.add("braces","deletion",function(a,b,d,f,e){a=f.doc.getTextRange(e);if(!e.isMultiLine()&&"{"==a){m(d);if("}"==f.doc.getLine(e.start.row).substring(e.end.column,
e.end.column+1))return e.end.column++,e;c.maybeInsertedBrackets--}});this.add("parens","insertion",function(a,b,c,d,f){if("("==f){m(c);f=c.getSelectionRange();a=d.doc.getTextRange(f);if(""!==a&&c.getWrapBehavioursEnabled())return p(f,a,"(",")");if(l.isSaneInsertion(c,d))return l.recordAutoInsert(c,d,")"),{text:"()",selection:[1,1]}}else if(")"==f&&(m(c),c=c.getCursorPosition(),a=d.doc.getLine(c.row),")"==a.substring(c.column,c.column+1)&&null!==d.$findOpeningBracket(")",{column:c.column+1,row:c.row})&&
l.isAutoInsertedClosing(c,a,f)))return l.popAutoInsertedClosing(),{text:"",selection:[1,1]}});this.add("parens","deletion",function(a,b,c,d,f){a=d.doc.getTextRange(f);if(!f.isMultiLine()&&"("==a&&(m(c),")"==d.doc.getLine(f.start.row).substring(f.start.column+1,f.start.column+2)))return f.end.column++,f});this.add("brackets","insertion",function(a,b,c,d,f){if("["==f){m(c);f=c.getSelectionRange();a=d.doc.getTextRange(f);if(""!==a&&c.getWrapBehavioursEnabled())return p(f,a,"[","]");if(l.isSaneInsertion(c,
d))return l.recordAutoInsert(c,d,"]"),{text:"[]",selection:[1,1]}}else if("]"==f&&(m(c),c=c.getCursorPosition(),a=d.doc.getLine(c.row),"]"==a.substring(c.column,c.column+1)&&null!==d.$findOpeningBracket("]",{column:c.column+1,row:c.row})&&l.isAutoInsertedClosing(c,a,f)))return l.popAutoInsertedClosing(),{text:"",selection:[1,1]}});this.add("brackets","deletion",function(a,b,c,d,f){a=d.doc.getTextRange(f);if(!f.isMultiLine()&&"["==a&&(m(c),"]"==d.doc.getLine(f.start.row).substring(f.start.column+1,
f.start.column+2)))return f.end.column++,f});this.add("string_dquotes","insertion",function(a,b,c,d,f){a=d.$mode.$quotes||w;if(1==f.length&&a[f]&&(!this.lineCommentStart||-1==this.lineCommentStart.indexOf(f))){m(c);b=c.getSelectionRange();var e=d.doc.getTextRange(b);if(""!==e&&(1!=e.length||!a[e])&&c.getWrapBehavioursEnabled())return p(b,e,f,f);if(!e){a=c.getCursorPosition();b=d.doc.getLine(a.row);c=b.substring(a.column-1,a.column);e=b.substring(a.column,a.column+1);var n=d.getTokenAt(a.row,a.column),
l=d.getTokenAt(a.row,a.column+1);if("\\"==c&&n&&/escape/.test(n.type))return null;n=n&&/string|escape/.test(n.type);var g=!l||/string|escape/.test(l.type);if(e==f)(d=n!==g)&&/string\.end/.test(l.type)&&(d=!1);else{if(n&&!g||n&&g)return null;d=d.$mode.tokenRe;d.lastIndex=0;l=d.test(c);d.lastIndex=0;n=d.test(c);if(l||n||e&&!/[\s;,.})\]\\]/.test(e))return null;a=b[a.column-2];if(c==f&&(a==f||d.test(a)))return null;d=!0}return{text:d?f+f:"",selection:[1,1]}}}});this.add("string_dquotes","deletion",function(a,
b,c,d,f){a=d.$mode.$quotes||w;b=d.doc.getTextRange(f);if(!f.isMultiLine()&&a.hasOwnProperty(b)&&(m(c),d.doc.getLine(f.start.row).substring(f.start.column+1,f.start.column+2)==b))return f.end.column++,f})};l.isSaneInsertion=function(b,c){var f=b.getCursorPosition(),e=new x(c,f.row,f.column);if(!this.$matchTokenType(e.getCurrentToken()||"text",d)){if(/[)}\]]/.test(b.session.getLine(f.row)[f.column]))return!0;b=new x(c,f.row,f.column+1);if(!this.$matchTokenType(b.getCurrentToken()||"text",d))return!1}e.stepForward();
return e.getCurrentTokenRow()!==f.row||this.$matchTokenType(e.getCurrentToken()||"text",a)};l.$matchTokenType=function(a,b){return-1<b.indexOf(a.type||a)};l.recordAutoInsert=function(a,b,d){a=a.getCursorPosition();b=b.doc.getLine(a.row);this.isAutoInsertedClosing(a,b,c.autoInsertedLineEnd[0])||(c.autoInsertedBrackets=0);c.autoInsertedRow=a.row;c.autoInsertedLineEnd=d+b.substr(a.column);c.autoInsertedBrackets++};l.recordMaybeInsert=function(a,b,d){a=a.getCursorPosition();b=b.doc.getLine(a.row);this.isMaybeInsertedClosing(a,
b)||(c.maybeInsertedBrackets=0);c.maybeInsertedRow=a.row;c.maybeInsertedLineStart=b.substr(0,a.column)+d;c.maybeInsertedLineEnd=b.substr(a.column);c.maybeInsertedBrackets++};l.isAutoInsertedClosing=function(a,b,d){return 0<c.autoInsertedBrackets&&a.row===c.autoInsertedRow&&d===c.autoInsertedLineEnd[0]&&b.substr(a.column)===c.autoInsertedLineEnd};l.isMaybeInsertedClosing=function(a,b){return 0<c.maybeInsertedBrackets&&a.row===c.maybeInsertedRow&&b.substr(a.column)===c.maybeInsertedLineEnd&&b.substr(0,
a.column)==c.maybeInsertedLineStart};l.popAutoInsertedClosing=function(){c.autoInsertedLineEnd=c.autoInsertedLineEnd.substr(1);c.autoInsertedBrackets--};l.clearMaybeInsertedClosing=function(){c&&(c.maybeInsertedBrackets=0,c.maybeInsertedRow=-1)};h.inherits(l,k);e.CstyleBehaviour=l});ace.define("ace/unicode",["require","exports","module"],function(b,e,h){b=[48,9,8,25,5,0,2,25,48,0,11,0,5,0,6,22,2,30,2,457,5,11,15,4,8,0,2,0,18,116,2,1,3,3,9,0,2,2,2,0,2,19,2,82,2,138,2,4,3,155,12,37,3,0,8,38,10,44,2,
0,2,1,2,1,2,0,9,26,6,2,30,10,7,61,2,9,5,101,2,7,3,9,2,18,3,0,17,58,3,100,15,53,5,0,6,45,211,57,3,18,2,5,3,11,3,9,2,1,7,6,2,2,2,7,3,1,3,21,2,6,2,0,4,3,3,8,3,1,3,3,9,0,5,1,2,4,3,11,16,2,2,5,5,1,3,21,2,6,2,1,2,1,2,1,3,0,2,4,5,1,3,2,4,0,8,3,2,0,8,15,12,2,2,8,2,2,2,21,2,6,2,1,2,4,3,9,2,2,2,2,3,0,16,3,3,9,18,2,2,7,3,1,3,21,2,6,2,1,2,4,3,8,3,1,3,2,9,1,5,1,2,4,3,9,2,0,17,1,2,5,4,2,2,3,4,1,2,0,2,1,4,1,4,2,4,11,5,4,4,2,2,3,3,0,7,0,15,9,18,2,2,7,2,2,2,22,2,9,2,4,4,7,2,2,2,3,8,1,2,1,7,3,3,9,19,1,2,7,2,2,2,22,
2,9,2,4,3,8,2,2,2,3,8,1,8,0,2,3,3,9,19,1,2,7,2,2,2,22,2,15,4,7,2,2,2,3,10,0,9,3,3,9,11,5,3,1,2,17,4,23,2,8,2,0,3,6,4,0,5,5,2,0,2,7,19,1,14,57,6,14,2,9,40,1,2,0,3,1,2,0,3,0,7,3,2,6,2,2,2,0,2,0,3,1,2,12,2,2,3,4,2,0,2,5,3,9,3,1,35,0,24,1,7,9,12,0,2,0,2,0,5,9,2,35,5,19,2,5,5,7,2,35,10,0,58,73,7,77,3,37,11,42,2,0,4,328,2,3,3,6,2,0,2,3,3,40,2,3,3,32,2,3,3,6,2,0,2,3,3,14,2,56,2,3,3,66,5,0,33,15,17,84,13,619,3,16,2,25,6,74,22,12,2,6,12,20,12,19,13,12,2,2,2,1,13,51,3,29,4,0,5,1,3,9,34,2,3,9,7,87,9,42,6,69,
11,28,4,11,5,11,11,39,3,4,12,43,5,25,7,10,38,27,5,62,2,28,3,10,7,9,14,0,89,75,5,9,18,8,13,42,4,11,71,55,9,9,4,48,83,2,2,30,14,230,23,280,3,5,3,37,3,5,3,7,2,0,2,0,2,0,2,30,3,52,2,6,2,0,4,2,2,6,4,3,3,5,5,12,6,2,2,6,67,1,20,0,29,0,14,0,17,4,60,12,5,0,4,11,18,0,5,0,3,9,2,0,4,4,7,0,2,0,2,0,2,3,2,10,3,3,6,4,5,0,53,1,2684,46,2,46,2,132,7,6,15,37,11,53,10,0,17,22,10,6,2,6,2,6,2,6,2,6,2,6,2,6,2,6,2,31,48,0,470,1,36,5,2,4,6,1,5,85,3,1,3,2,2,89,2,3,6,40,4,93,18,23,57,15,513,6581,75,20939,53,1164,68,45,3,268,
4,27,21,31,3,13,13,1,2,24,9,69,11,1,38,8,3,102,3,1,111,44,25,51,13,68,12,9,7,23,4,0,5,45,3,35,13,28,4,64,15,10,39,54,10,13,3,9,7,22,4,1,5,66,25,2,227,42,2,1,3,9,7,11171,13,22,5,48,8453,301,3,61,3,105,39,6,13,4,6,11,2,12,2,4,2,0,2,1,2,1,2,107,34,362,19,63,3,53,41,11,5,15,17,6,13,1,25,2,33,4,2,134,20,9,8,25,5,0,2,25,12,88,4,5,3,5,3,5,3,2];h=0;for(var k=[],x=0;x<b.length;x+=2)k.push(h+=b[x]),b[x+1]&&k.push(45,h+=b[x+1]);e.wordChars=String.fromCharCode.apply(null,k)});ace.define("ace/mode/text","require exports module ace/config ace/tokenizer ace/mode/text_highlight_rules ace/mode/behaviour/cstyle ace/unicode ace/lib/lang ace/token_iterator ace/range".split(" "),
function(b,e,h){var k=b("../config"),x=b("../tokenizer").Tokenizer,g=b("./text_highlight_rules").TextHighlightRules,d=b("./behaviour/cstyle").CstyleBehaviour,a=b("../unicode"),c=b("../lib/lang"),f=b("../token_iterator").TokenIterator,w=b("../range").Range;b=function(){this.HighlightRules=g};(function(){this.$defaultBehaviour=new d;this.tokenRe=new RegExp("^["+a.wordChars+"\\$_]+","g");this.nonTokenRe=new RegExp("^(?:[^"+a.wordChars+"\\$_]|\\s])+","g");this.getTokenizer=function(){this.$tokenizer||
(this.$highlightRules=this.$highlightRules||new this.HighlightRules(this.$highlightRuleConfig),this.$tokenizer=new x(this.$highlightRules.getRules()));return this.$tokenizer};this.blockComment=this.lineCommentStart="";this.toggleCommentLines=function(a,b,d,f){function e(a){for(var b=d;b<=f;b++)a(l.getLine(b),b)}var l=b.doc,g=!0,n=!0,m=Infinity,w=b.getTabSize();a=!1;if(this.lineCommentStart){Array.isArray(this.lineCommentStart)?(h=this.lineCommentStart.map(c.escapeRegExp).join("|"),k=this.lineCommentStart[0]):
(h=c.escapeRegExp(this.lineCommentStart),k=this.lineCommentStart);h=new RegExp("^(\\s*)(?:"+h+") ?");a=b.getUseSoftTabs();y=function(a,b){var c=a.match(h);if(c){var d=c[1].length,f=c[0].length;u(a,d,f)||" "!=c[0][f-1]||f--;l.removeInLine(b,d,f)}};var p=k+" ";t=function(a,b){if(!g||/\S/.test(a))u(a,m,m)?l.insertInLine({row:b,column:m},p):l.insertInLine({row:b,column:m},k)};I=function(a,b){return h.test(a)};var u=function(a,b,c){for(var d=0;b--&&" "==a.charAt(b);)d++;if(0!=d%w)return!1;for(d=0;" "==
a.charAt(c++);)d++;return 2<w?d%w!=w-1:0==d%w}}else{if(!this.blockComment)return!1;var k=this.blockComment.start,x=this.blockComment.end,h=new RegExp("^(\\s*)(?:"+c.escapeRegExp(k)+")"),r=new RegExp("(?:"+c.escapeRegExp(x)+")\\s*$"),t=function(a,b){I(a,b)||g&&!/\S/.test(a)||(l.insertInLine({row:b,column:a.length},x),l.insertInLine({row:b,column:m},k))},y=function(a,b){var c;(c=a.match(r))&&l.removeInLine(b,a.length-c[0].length,a.length);(c=a.match(h))&&l.removeInLine(b,c[1].length,c[0].length)},I=
function(a,c){if(h.test(a))return!0;a=b.getTokens(c);for(c=0;c<a.length;c++)if("comment"===a[c].type)return!0}}var C=Infinity;e(function(a,b){var c=a.search(/\S/);-1!==c?(c<m&&(m=c),n&&!I(a,b)&&(n=!1)):C>a.length&&(C=a.length)});Infinity==m&&(m=C,n=g=!1);a&&0!=m%w&&(m=Math.floor(m/w)*w);e(n?y:t)};this.toggleBlockComment=function(a,b,c,d){if(a=this.blockComment){!a.start&&a[0]&&(a=a[0]);var e=new f(b,d.row,d.column),l=e.getCurrentToken(),g=b.selection.toOrientedRange();if(l&&/comment/.test(l.type)){for(var n,
m;l&&/comment/.test(l.type);){l=l.value.indexOf(a.start);if(-1!=l){c=e.getCurrentTokenRow();e=e.getCurrentTokenColumn()+l;n=new w(c,e,c,e+a.start.length);break}l=e.stepBackward()}e=new f(b,d.row,d.column);for(l=e.getCurrentToken();l&&/comment/.test(l.type);){l=l.value.indexOf(a.end);if(-1!=l){c=e.getCurrentTokenRow();e=e.getCurrentTokenColumn()+l;m=new w(c,e,c,e+a.end.length);break}l=e.stepForward()}m&&b.remove(m);if(n){b.remove(n);var p=n.start.row;var u=-a.start.length}}else u=a.start.length,p=
c.start.row,b.insert(c.end,a.end),b.insert(c.start,a.start);g.start.row==p&&(g.start.column+=u);g.end.row==p&&(g.end.column+=u);b.selection.fromOrientedRange(g)}};this.getNextLineIndent=function(a,b,c){return this.$getIndent(b)};this.checkOutdent=function(a,b,c){return!1};this.autoOutdent=function(a,b,c){};this.$getIndent=function(a){return a.match(/^\s*/)[0]};this.createWorker=function(a){return null};this.createModeDelegates=function(a){this.$embeds=[];this.$modes={};for(var b in a)if(a[b]){var c=
a[b],d=c.prototype.$id,f=k.$modes[d];f||(k.$modes[d]=f=new c);k.$modes[b]||(k.$modes[b]=f);this.$embeds.push(b);this.$modes[b]=f}var e="toggleBlockComment toggleCommentLines getNextLineIndent checkOutdent autoOutdent transformAction getCompletions".split(" ");for(b=0;b<e.length;b++)(function(a){var c=e[b],d=a[c];a[e[b]]=function(){return this.$delegator(c,arguments,d)}})(this)};this.$delegator=function(a,b,c){var d=b[0]||"start";if("string"!=typeof d){if(Array.isArray(d[2])){var f=this.$modes[d[2][d[2].length-
1]];if(f)return f[a].apply(f,[d[1]].concat([].slice.call(b,1)))}d=d[0]||"start"}for(f=0;f<this.$embeds.length;f++)if(this.$modes[this.$embeds[f]]){var e=d.split(this.$embeds[f]);if(!e[0]&&e[1])return b[0]=e[1],f=this.$modes[this.$embeds[f]],f[a].apply(f,b)}a=c.apply(this,b);return c?a:void 0};this.transformAction=function(a,b,c,d,f){if(this.$behaviour){var e=this.$behaviour.getBehaviours(),l;for(l in e)if(e[l][b]){var n=e[l][b].apply(this,arguments);if(n)return n}}};this.getKeywords=function(a){if(!this.completionKeywords){var b=
this.$tokenizer.rules,c=[];for(m in b)for(var d=b[m],f=0,e=d.length;f<e;f++)if("string"===typeof d[f].token)/keyword|support|storage/.test(d[f].token)&&c.push(d[f].regex);else if("object"===typeof d[f].token)for(var g=0,n=d[f].token.length;g<n;g++)if(/keyword|support|storage/.test(d[f].token[g])){var m=d[f].regex.match(/\(.+?\)/g)[g];c.push(m.substr(1,m.length-2))}this.completionKeywords=c}return a?c.concat(this.$keywordList||[]):this.$keywordList};this.$createKeywordList=function(){this.$highlightRules||
this.getTokenizer();return this.$keywordList=this.$highlightRules.$keywordList||[]};this.getCompletions=function(a,b,c,d){return(this.$keywordList||this.$createKeywordList()).map(function(a){return{name:a,value:a,score:0,meta:"keyword"}})};this.$id="ace/mode/text"}).call(b.prototype);e.Mode=b});ace.define("ace/apply_delta",["require","exports","module"],function(b,e,h){e.applyDelta=function(b,e,g){g=e.start.row;var d=e.start.column,a=b[g]||"";switch(e.action){case "insert":if(1===e.lines.length)b[g]=
a.substring(0,d)+e.lines[0]+a.substring(d);else{var c=[g,1].concat(e.lines);b.splice.apply(b,c);b[g]=a.substring(0,d)+b[g];b[g+e.lines.length-1]+=a.substring(d)}break;case "remove":c=e.end.column,e=e.end.row,g===e?b[g]=a.substring(0,d)+a.substring(c):b.splice(g,e-g+1,a.substring(0,d)+b[e].substring(c))}}});ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(b,e,h){var k=b("./lib/oop"),x=b("./lib/event_emitter").EventEmitter;b=e.Anchor=function(b,d,
a){this.$onChange=this.onChange.bind(this);this.attach(b);"undefined"==typeof a?this.setPosition(d.row,d.column):this.setPosition(d,a)};(function(){function b(b,a,c){c=c?b.column<=a.column:b.column<a.column;return b.row<a.row||b.row==a.row&&c}k.implement(this,x);this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)};this.getDocument=function(){return this.document};this.$insertRight=!1;this.onChange=function(d){if(!(d.start.row==d.end.row&&d.start.row!=this.row||d.start.row>
this.row)){var a={row:this.row,column:this.column};var c=this.$insertRight;var f="insert"==d.action,e=(f?1:-1)*(d.end.row-d.start.row),g=(f?1:-1)*(d.end.column-d.start.column),p=d.start;d=f?p:d.end;b(a,p,c)?(c=a.row,a=a.column):b(d,a,!c)?(c=a.row+e,a=a.column+(a.row==d.row?g:0)):(c=p.row,a=p.column);this.setPosition(c,a,!0)}};this.setPosition=function(b,a,c){b=c?{row:b,column:a}:this.$clipPositionToDocument(b,a);if(this.row!=b.row||this.column!=b.column)a={row:this.row,column:this.column},this.row=
b.row,this.column=b.column,this._signal("change",{old:a,value:b})};this.detach=function(){this.document.off("change",this.$onChange)};this.attach=function(b){this.document=b||this.document;this.document.on("change",this.$onChange)};this.$clipPositionToDocument=function(b,a){var c={};b>=this.document.getLength()?(c.row=Math.max(0,this.document.getLength()-1),c.column=this.document.getLine(c.row).length):0>b?(c.row=0,c.column=0):(c.row=b,c.column=Math.min(this.document.getLine(c.row).length,Math.max(0,
a)));0>a&&(c.column=0);return c}}).call(b.prototype)});ace.define("ace/document","require exports module ace/lib/oop ace/apply_delta ace/lib/event_emitter ace/range ace/anchor".split(" "),function(b,e,h){var k=b("./lib/oop"),x=b("./apply_delta").applyDelta,g=b("./lib/event_emitter").EventEmitter,d=b("./range").Range,a=b("./anchor").Anchor;b=function(a){this.$lines=[""];0===a.length?this.$lines=[""]:Array.isArray(a)?this.insertMergedLines({row:0,column:0},a):this.insert({row:0,column:0},a)};(function(){k.implement(this,
g);this.setValue=function(a){var b=this.getLength()-1;this.remove(new d(0,0,b,this.getLine(b).length));this.insert({row:0,column:0},a)};this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())};this.createAnchor=function(b,d){return new a(this,b,d)};0==="aaa".split(/a/).length?this.$split=function(a){return a.replace(/\r\n|\r/g,"\n").split("\n")}:this.$split=function(a){return a.split(/\r\n|\r|\n/)};this.$detectNewLine=function(a){this.$autoNewLine=(a=a.match(/^.*?(\r\n|\r|\n)/m))?
a[1]:"\n";this._signal("changeNewLineMode")};this.getNewLineCharacter=function(){switch(this.$newLineMode){case "windows":return"\r\n";case "unix":return"\n";default:return this.$autoNewLine||"\n"}};this.$autoNewLine="";this.$newLineMode="auto";this.setNewLineMode=function(a){this.$newLineMode!==a&&(this.$newLineMode=a,this._signal("changeNewLineMode"))};this.getNewLineMode=function(){return this.$newLineMode};this.isNewLine=function(a){return"\r\n"==a||"\r"==a||"\n"==a};this.getLine=function(a){return this.$lines[a]||
""};this.getLines=function(a,b){return this.$lines.slice(a,b+1)};this.getAllLines=function(){return this.getLines(0,this.getLength())};this.getLength=function(){return this.$lines.length};this.getTextRange=function(a){return this.getLinesForRange(a).join(this.getNewLineCharacter())};this.getLinesForRange=function(a){if(a.start.row===a.end.row)var b=[this.getLine(a.start.row).substring(a.start.column,a.end.column)];else{b=this.getLines(a.start.row,a.end.row);b[0]=(b[0]||"").substring(a.start.column);
var c=b.length-1;a.end.row-a.start.row==c&&(b[c]=b[c].substring(0,a.end.column))}return b};this.insertLines=function(a,b){console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead.");return this.insertFullLines(a,b)};this.removeLines=function(a,b){console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead.");return this.removeFullLines(a,b)};this.insertNewLine=function(a){console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, ['', '']) instead.");
return this.insertMergedLines(a,["",""])};this.insert=function(a,b){1>=this.getLength()&&this.$detectNewLine(b);return this.insertMergedLines(a,this.$split(b))};this.insertInLine=function(a,b){var c=this.clippedPos(a.row,a.column);a=this.pos(a.row,a.column+b.length);this.applyDelta({start:c,end:a,action:"insert",lines:[b]},!0);return this.clonePos(a)};this.clippedPos=function(a,b){var c=this.getLength();void 0===a?a=c:0>a?a=0:a>=c&&(a=c-1,b=void 0);c=this.getLine(a);void 0==b&&(b=c.length);b=Math.min(Math.max(b,
0),c.length);return{row:a,column:b}};this.clonePos=function(a){return{row:a.row,column:a.column}};this.pos=function(a,b){return{row:a,column:b}};this.$clipPosition=function(a){var b=this.getLength();a.row>=b?(a.row=Math.max(0,b-1),a.column=this.getLine(b-1).length):(a.row=Math.max(0,a.row),a.column=Math.min(Math.max(a.column,0),this.getLine(a.row).length));return a};this.insertFullLines=function(a,b){a=Math.min(Math.max(a,0),this.getLength());if(a<this.getLength()){b=b.concat([""]);var c=0}else b=
[""].concat(b),a--,c=this.$lines[a].length;this.insertMergedLines({row:a,column:c},b)};this.insertMergedLines=function(a,b){a=this.clippedPos(a.row,a.column);var c={row:a.row+b.length-1,column:(1==b.length?a.column:0)+b[b.length-1].length};this.applyDelta({start:a,end:c,action:"insert",lines:b});return this.clonePos(c)};this.remove=function(a){var b=this.clippedPos(a.start.row,a.start.column);a=this.clippedPos(a.end.row,a.end.column);this.applyDelta({start:b,end:a,action:"remove",lines:this.getLinesForRange({start:b,
end:a})});return this.clonePos(b)};this.removeInLine=function(a,b,d){b=this.clippedPos(a,b);a=this.clippedPos(a,d);this.applyDelta({start:b,end:a,action:"remove",lines:this.getLinesForRange({start:b,end:a})},!0);return this.clonePos(b)};this.removeFullLines=function(a,b){a=Math.min(Math.max(0,a),this.getLength()-1);b=Math.min(Math.max(0,b),this.getLength()-1);var c=b==this.getLength()-1&&0<a,f=b<this.getLength()-1,e=c?a-1:a;c=c?this.getLine(e).length:0;var l=f?b+1:b;f=f?0:this.getLine(l).length;e=
new d(e,c,l,f);a=this.$lines.slice(a,b+1);this.applyDelta({start:e.start,end:e.end,action:"remove",lines:this.getLinesForRange(e)});return a};this.removeNewLine=function(a){a<this.getLength()-1&&0<=a&&this.applyDelta({start:this.pos(a,this.getLine(a).length),end:this.pos(a+1,0),action:"remove",lines:["",""]})};this.replace=function(a,b){a instanceof d||(a=d.fromPoints(a.start,a.end));if(0===b.length&&a.isEmpty())return a.start;if(b==this.getTextRange(a))return a.end;this.remove(a);return b?this.insert(a.start,
b):a.start};this.applyDeltas=function(a){for(var b=0;b<a.length;b++)this.applyDelta(a[b])};this.revertDeltas=function(a){for(var b=a.length-1;0<=b;b--)this.revertDelta(a[b])};this.applyDelta=function(a,b){var c="insert"==a.action;(c?1>=a.lines.length&&!a.lines[0]:!d.comparePoints(a.start,a.end))||(c&&2E4<a.lines.length?this.$splitAndapplyLargeDelta(a,2E4):(x(this.$lines,a,b),this._signal("change",a)))};this.$safeApplyDelta=function(a){var b=this.$lines.length;("remove"==a.action&&a.start.row<b&&a.end.row<
b||"insert"==a.action&&a.start.row<=b)&&this.applyDelta(a)};this.$splitAndapplyLargeDelta=function(a,b){for(var c=a.lines,d=c.length-b+1,e=a.start.row,f=a.start.column,g=0,v=0;g<d;g=v){v+=b-1;var k=c.slice(g,v);k.push("");this.applyDelta({start:this.pos(e+g,f),end:this.pos(e+v,f=0),action:a.action,lines:k},!0)}a.lines=c.slice(g);a.start.row=e+g;a.start.column=f;this.applyDelta(a,!0)};this.revertDelta=function(a){this.$safeApplyDelta({start:this.clonePos(a.start),end:this.clonePos(a.end),action:"insert"==
a.action?"remove":"insert",lines:a.lines.slice()})};this.indexToPosition=function(a,b){var c=this.$lines||this.getAllLines(),d=this.getNewLineCharacter().length;b=b||0;for(var e=c.length;b<e;b++)if(a-=c[b].length+d,0>a)return{row:b,column:a+c[b].length+d};return{row:e-1,column:a+c[e-1].length+d}};this.positionToIndex=function(a,b){var c=this.$lines||this.getAllLines(),d=this.getNewLineCharacter().length,e=0,f=Math.min(a.row,c.length);for(b=b||0;b<f;++b)e+=c[b].length+d;return e+a.column}}).call(b.prototype);
e.Document=b});ace.define("ace/background_tokenizer",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(b,e,h){var k=b("./lib/oop"),x=b("./lib/event_emitter").EventEmitter;b=function(b,d){this.running=!1;this.lines=[];this.states=[];this.currentLine=0;this.tokenizer=b;var a=this;this.$worker=function(){if(a.running){for(var b=new Date,d=a.currentLine,e=-1,g=a.doc,p=d;a.lines[d];)d++;g=g.getLength();var l=0;for(a.running=!1;d<g;){a.$tokenizeRow(d);e=d;do d++;while(a.lines[d]);
l++;if(0===l%5&&20<new Date-b){a.running=setTimeout(a.$worker,20);break}}a.currentLine=d;-1==e&&(e=d);p<=e&&a.fireUpdateEvent(p,e)}}};(function(){k.implement(this,x);this.setTokenizer=function(b){this.tokenizer=b;this.lines=[];this.states=[];this.start(0)};this.setDocument=function(b){this.doc=b;this.lines=[];this.states=[];this.stop()};this.fireUpdateEvent=function(b,d){this._signal("update",{data:{first:b,last:d}})};this.start=function(b){this.currentLine=Math.min(b||0,this.currentLine,this.doc.getLength());
this.lines.splice(this.currentLine,this.lines.length);this.states.splice(this.currentLine,this.states.length);this.stop();this.running=setTimeout(this.$worker,700)};this.scheduleStart=function(){this.running||(this.running=setTimeout(this.$worker,700))};this.$updateOnChange=function(b){var d=b.start.row,a=b.end.row-d;0===a?this.lines[d]=null:"remove"==b.action?(this.lines.splice(d,a+1,null),this.states.splice(d,a+1,null)):(b=Array(a+1),b.unshift(d,1),this.lines.splice.apply(this.lines,b),this.states.splice.apply(this.states,
b));this.currentLine=Math.min(d,this.currentLine,this.doc.getLength());this.stop()};this.stop=function(){this.running&&clearTimeout(this.running);this.running=!1};this.getTokens=function(b){return this.lines[b]||this.$tokenizeRow(b)};this.getState=function(b){this.currentLine==b&&this.$tokenizeRow(b);return this.states[b]||"start"};this.$tokenizeRow=function(b){var d=this.doc.getLine(b);d=this.tokenizer.getLineTokens(d,this.states[b-1],b);this.states[b]+""!==d.state+""?(this.states[b]=d.state,this.lines[b+
1]=null,this.currentLine>b+1&&(this.currentLine=b+1)):this.currentLine==b&&(this.currentLine=b+1);return this.lines[b]=d.tokens}}).call(b.prototype);e.BackgroundTokenizer=b});ace.define("ace/search_highlight","require exports module ace/lib/lang ace/lib/oop ace/range".split(" "),function(b,e,h){var k=b("./lib/lang");b("./lib/oop");var x=b("./range").Range;b=function(b,d,a){this.setRegexp(b);this.clazz=d;this.type=a||"text"};(function(){this.MAX_RANGES=500;this.setRegexp=function(b){this.regExp+""!=
b+""&&(this.regExp=b,this.cache=[])};this.update=function(b,d,a,c){if(this.regExp)for(var e=c.lastRow,g=c.firstRow;g<=e;g++){var m=this.cache[g];null==m&&(m=k.getMatchOffsets(a.getLine(g),this.regExp),m.length>this.MAX_RANGES&&(m=m.slice(0,this.MAX_RANGES)),m=m.map(function(a){return new x(g,a.offset,g,a.offset+a.length)}),this.cache[g]=m.length?m:"");for(var p=m.length;p--;)d.drawSingleLineMarker(b,m[p].toScreenRange(a),this.clazz,c)}}}).call(b.prototype);e.SearchHighlight=b});ace.define("ace/edit_session/fold_line",
["require","exports","module","ace/range"],function(b,e,h){function k(b,d){this.foldData=b;Array.isArray(d)?this.folds=d:d=this.folds=[d];b=d[d.length-1];this.range=new x(d[0].start.row,d[0].start.column,b.end.row,b.end.column);this.start=this.range.start;this.end=this.range.end;this.folds.forEach(function(a){a.setFoldLine(this)},this)}var x=b("../range").Range;(function(){this.shiftRow=function(b){this.start.row+=b;this.end.row+=b;this.folds.forEach(function(d){d.start.row+=b;d.end.row+=b})};this.addFold=
function(b){if(b.sameRow){if(b.start.row<this.startRow||b.endRow>this.endRow)throw Error("Can't add a fold to this FoldLine as it has no connection");this.folds.push(b);this.folds.sort(function(b,a){return-b.range.compareEnd(a.start.row,a.start.column)});0<this.range.compareEnd(b.start.row,b.start.column)?(this.end.row=b.end.row,this.end.column=b.end.column):0>this.range.compareStart(b.end.row,b.end.column)&&(this.start.row=b.start.row,this.start.column=b.start.column)}else if(b.start.row==this.end.row)this.folds.push(b),
this.end.row=b.end.row,this.end.column=b.end.column;else if(b.end.row==this.start.row)this.folds.unshift(b),this.start.row=b.start.row,this.start.column=b.start.column;else throw Error("Trying to add fold to FoldRow that doesn't have a matching row");b.foldLine=this};this.containsRow=function(b){return b>=this.start.row&&b<=this.end.row};this.walk=function(b,d,a){var c=0,e=this.folds;var g=!0;null==d&&(d=this.end.row,a=this.end.column);for(var m=0;m<e.length;m++){var p=e[m];var l=p.range.compareStart(d,
a);if(-1==l){b(null,d,a,c,g);return}g=b(null,p.start.row,p.start.column,c,g);if((g=!g&&b(p.placeholder,p.start.row,p.start.column,c))||0===l)return;g=!p.sameRow;c=p.end.column}b(null,d,a,c,g)};this.getNextFoldTo=function(b,d){for(var a,c,e=0;e<this.folds.length;e++){a=this.folds[e];c=a.range.compareEnd(b,d);if(-1==c)return{fold:a,kind:"after"};if(0===c)return{fold:a,kind:"inside"}}return null};this.addRemoveChars=function(b,d,a){var c=this.getNextFoldTo(b,d);if(c){var e=c.fold;if("inside"==c.kind&&
e.start.column!=d&&e.start.row!=b)window.console&&window.console.log(b,d,e);else if(e.start.row==b){b=this.folds;d=b.indexOf(e);0===d&&(this.start.column+=a);for(d;d<b.length;d++){e=b[d];e.start.column+=a;if(!e.sameRow)return;e.end.column+=a}this.end.column+=a}}};this.split=function(b,d){var a=this.getNextFoldTo(b,d);if(!a||"inside"==a.kind)return null;d=this.folds;b=this.foldData;a=d.indexOf(a.fold);var c=d[a-1];this.end.row=c.end.row;this.end.column=c.end.column;d=d.splice(a,d.length-a);d=new k(b,
d);b.splice(b.indexOf(this)+1,0,d);return d};this.merge=function(b){for(var d=b.folds,a=0;a<d.length;a++)this.addFold(d[a]);d=this.foldData;d.splice(d.indexOf(b),1)};this.toString=function(){var b=[this.range.toString()+": ["];this.folds.forEach(function(d){b.push("  "+d.toString())});b.push("]");return b.join("\n")};this.idxToPosition=function(b){for(var d=0,a=0;a<this.folds.length;a++){var c=this.folds[a];b-=c.start.column-d;if(0>b)return{row:c.start.row,column:c.start.column+b};b-=c.placeholder.length;
if(0>b)return c.start;d=c.end.column}return{row:this.end.row,column:this.end.column+b}}}).call(k.prototype);e.FoldLine=k});ace.define("ace/range_list",["require","exports","module","ace/range"],function(b,e,h){var k=b("./range").Range.comparePoints;b=function(){this.ranges=[];this.$bias=1};(function(){this.comparePoints=k;this.pointIndex=function(b,e,d){var a=this.ranges;for(d=d||0;d<a.length;d++){var c=a[d],f=k(b,c.end);if(!(0<f)){b=k(b,c.start);if(0===f)return e&&0!==b?-d-2:d;if(0<b||0===b&&!e)return d;
break}}return-d-1};this.add=function(b){var e=!b.isEmpty(),d=this.pointIndex(b.start,e);0>d&&(d=-d-1);e=this.pointIndex(b.end,e,d);0>e?e=-e-1:e++;return this.ranges.splice(d,e-d,b)};this.addList=function(b){for(var e=[],d=b.length;d--;)e.push.apply(e,this.add(b[d]));return e};this.substractPoint=function(b){b=this.pointIndex(b);if(0<=b)return this.ranges.splice(b,1)};this.merge=function(){var b=[],e=this.ranges;e=e.sort(function(a,b){return k(a.start,b.start)});for(var d=e[0],a,c=1;c<e.length;c++){a=
d;d=e[c];var f=k(a.end,d.start);0>f||0==f&&!a.isEmpty()&&!d.isEmpty()||(0>k(a.end,d.end)&&(a.end.row=d.end.row,a.end.column=d.end.column),e.splice(c,1),b.push(d),d=a,c--)}this.ranges=e;return b};this.contains=function(b,e){return 0<=this.pointIndex({row:b,column:e})};this.containsPoint=function(b){return 0<=this.pointIndex(b)};this.rangeAtPoint=function(b){b=this.pointIndex(b);if(0<=b)return this.ranges[b]};this.clipRows=function(b,e){var d=this.ranges;if(d[0].start.row>e||d[d.length-1].start.row<
b)return[];b=this.pointIndex({row:b,column:0});0>b&&(b=-b-1);e=this.pointIndex({row:e,column:0},b);0>e&&(e=-e-1);for(var a=[];b<e;b++)a.push(d[b]);return a};this.removeAll=function(){return this.ranges.splice(0,this.ranges.length)};this.attach=function(b){this.session&&this.detach();this.session=b;this.onChange=this.$onChange.bind(this);this.session.on("change",this.onChange)};this.detach=function(){this.session&&(this.session.removeListener("change",this.onChange),this.session=null)};this.$onChange=
function(b){for(var e=b.start,d=b.end,a=e.row,c=d.row,f=this.ranges,w=0,m=f.length;w<m;w++){var p=f[w];if(p.end.row>=a)break}if("insert"==b.action){b=c-a;for(var l=-e.column+d.column;w<m;w++){p=f[w];if(p.start.row>a)break;p.start.row==a&&p.start.column>=e.column&&!(p.start.column==e.column&&0>=this.$bias)&&(p.start.column+=l,p.start.row+=b);p.end.row==a&&p.end.column>=e.column&&!(p.end.column==e.column&&0>this.$bias)&&(p.end.column==e.column&&0<l&&w<m-1&&p.end.column>p.start.column&&p.end.column==
f[w+1].start.column&&(p.end.column-=l),p.end.column+=l,p.end.row+=b)}}else for(b=a-c,l=e.column-d.column;w<m;w++){p=f[w];if(p.start.row>c)break;if(p.end.row<c&&(a<p.end.row||a==p.end.row&&e.column<p.end.column))p.end.row=a,p.end.column=e.column;else if(p.end.row==c)if(p.end.column<=d.column){if(b||p.end.column>e.column)p.end.column=e.column,p.end.row=e.row}else p.end.column+=l,p.end.row+=b;else p.end.row>c&&(p.end.row+=b);if(p.start.row<c&&(a<p.start.row||a==p.start.row&&e.column<p.start.column))p.start.row=
a,p.start.column=e.column;else if(p.start.row==c)if(p.start.column<=d.column){if(b||p.start.column>e.column)p.start.column=e.column,p.start.row=e.row}else p.start.column+=l,p.start.row+=b;else p.start.row>c&&(p.start.row+=b)}if(0!=b&&w<m)for(;w<m;w++)p=f[w],p.start.row+=b,p.end.row+=b}}).call(b.prototype);e.RangeList=b});ace.define("ace/edit_session/fold",["require","exports","module","ace/range_list","ace/lib/oop"],function(b,e,h){function k(b,a){b.row-=a.row;0==b.row&&(b.column-=a.column)}function x(b,
a){0==b.row&&(b.column+=a.column);b.row+=a.row}h=b("../range_list").RangeList;b=b("../lib/oop");var g=e.Fold=function(b,a){this.foldLine=null;this.placeholder=a;this.range=b;this.start=b.start;this.end=b.end;this.sameRow=b.start.row==b.end.row;this.subFolds=this.ranges=[]};b.inherits(g,h);(function(){this.toString=function(){return'"'+this.placeholder+'" '+this.range.toString()};this.setFoldLine=function(b){this.foldLine=b;this.subFolds.forEach(function(a){a.setFoldLine(b)})};this.clone=function(){var b=
this.range.clone(),a=new g(b,this.placeholder);this.subFolds.forEach(function(b){a.subFolds.push(b.clone())});a.collapseChildren=this.collapseChildren;return a};this.addSubFold=function(b){if(!this.range.isEqual(b)){var a=this.start;k(b.start,a);k(b.end,a);for(var c=b.start.row,d=b.start.column,e=0,g=-1;e<this.subFolds.length&&(g=this.subFolds[e].range.compare(c,d),1==g);e++);c=this.subFolds[e];a=0;if(0==g){if(c.range.containsRange(b))return c.addSubFold(b);a=1}c=b.range.end.row;d=b.range.end.column;
var p=e;for(g=-1;p<this.subFolds.length&&(g=this.subFolds[p].range.compare(c,d),1==g);p++);0==g&&p++;e=this.subFolds.splice(e,p-e,b);for(g=0==g?e.length-1:e.length;a<g;a++)b.addSubFold(e[a]);b.setFoldLine(this.foldLine);return b}};this.restoreRange=function(b){var a=this.start;x(b.start,a);x(b.end,a)}}).call(g.prototype)});ace.define("ace/edit_session/folding","require exports module ace/range ace/edit_session/fold_line ace/edit_session/fold ace/token_iterator".split(" "),function(b,e,h){var k=b("../range").Range,
x=b("./fold_line").FoldLine,g=b("./fold").Fold,d=b("../token_iterator").TokenIterator;e.Folding=function(){this.getFoldAt=function(a,b,d){var c=this.getFoldLine(a);if(!c)return null;c=c.folds;for(var e=0;e<c.length;e++){var f=c[e].range;if(f.contains(a,b)&&(1!=d||!f.isEnd(a,b)||f.isEmpty())&&(-1!=d||!f.isStart(a,b)||f.isEmpty()))return c[e]}};this.getFoldsInRange=function(a){var b=a.start,d=a.end,e=this.$foldData,g=[];b.column+=1;--d.column;for(var p=0;p<e.length;p++){var l=e[p].range.compareRange(a);
if(2!=l){if(-2==l)break;for(var u=e[p].folds,v=0;v<u.length;v++){var k=u[v];l=k.range.compareRange(a);if(-2==l)break;else if(2==l)continue;else if(42==l)break;g.push(k)}}}--b.column;d.column+=1;return g};this.getFoldsInRangeList=function(a){if(Array.isArray(a)){var b=[];a.forEach(function(a){b=b.concat(this.getFoldsInRange(a))},this)}else b=this.getFoldsInRange(a);return b};this.getAllFolds=function(){for(var a=[],b=this.$foldData,d=0;d<b.length;d++)for(var e=0;e<b[d].folds.length;e++)a.push(b[d].folds[e]);
return a};this.getFoldStringAt=function(a,b,d,e){e=e||this.getFoldLine(a);if(!e)return null;for(var c={end:{column:0}},f,l,g=0;g<e.folds.length;g++){l=e.folds[g];var v=l.range.compareEnd(a,b);if(-1==v){f=this.getLine(l.start.row).substring(c.end.column,l.start.column);break}else if(0===v)return null;c=l}f||(f=this.getLine(l.start.row).substring(c.end.column));return-1==d?f.substring(0,b-c.end.column):1==d?f.substring(b-c.end.column):f};this.getFoldLine=function(a,b){var c=this.$foldData,d=0;b&&(d=
c.indexOf(b));-1==d&&(d=0);for(d;d<c.length;d++){b=c[d];if(b.start.row<=a&&b.end.row>=a)return b;if(b.end.row>a)break}return null};this.getNextFoldLine=function(a,b){var c=this.$foldData,d=0;b&&(d=c.indexOf(b));-1==d&&(d=0);for(d;d<c.length;d++)if(b=c[d],b.end.row>=a)return b;return null};this.getFoldedRowCount=function(a,b){for(var c=this.$foldData,d=b-a+1,e=0;e<c.length;e++){var g=c[e],l=g.end.row;g=g.start.row;if(l>=b){g<b&&(d=g>=a?d-(b-g):0);break}else l>=a&&(d=g>=a?d-(l-g):d-(l-a+1))}return d};
this.$addFoldLine=function(a){this.$foldData.push(a);this.$foldData.sort(function(a,b){return a.start.row-b.start.row});return a};this.addFold=function(a,b){var c=this.$foldData,d=!1;if(a instanceof g)var e=a;else e=new g(b,a),e.collapseChildren=b.collapseChildren;this.$clipRangeToDocument(e.range);b=e.start.row;var p=e.start.column;a=e.end.row;var l=e.end.column,u=this.getFoldAt(b,p,1),v=this.getFoldAt(a,l,-1);if(u&&v==u)return u.addSubFold(e);u&&!u.range.isStart(b,p)&&this.removeFold(u);v&&!v.range.isEnd(a,
l)&&this.removeFold(v);p=this.getFoldsInRange(e.range);0<p.length&&(this.removeFolds(p),e.collapseChildren||p.forEach(function(a){e.addSubFold(a)}));for(p=0;p<c.length;p++){var k=c[p];if(a==k.start.row){k.addFold(e);d=!0;break}else if(b==k.end.row){k.addFold(e);d=!0;if(!e.sameRow&&(c=c[p+1])&&c.start.row==a){k.merge(c);break}break}else if(a<=k.start.row)break}d||(k=this.$addFoldLine(new x(this.$foldData,e)));this.$useWrapMode?this.$updateWrapData(k.start.row,k.start.row):this.$updateRowLengthCache(k.start.row,
k.start.row);this.$modified=!0;this._signal("changeFold",{data:e,action:"add"});return e};this.addFolds=function(a){a.forEach(function(a){this.addFold(a)},this)};this.removeFold=function(a){var b=a.foldLine,d=b.start.row,e=b.end.row,g=this.$foldData,p=b.folds;1==p.length?g.splice(g.indexOf(b),1):b.range.isEnd(a.end.row,a.end.column)?(p.pop(),b.end.row=p[p.length-1].end.row,b.end.column=p[p.length-1].end.column):b.range.isStart(a.start.row,a.start.column)?(p.shift(),b.start.row=p[0].start.row,b.start.column=
p[0].start.column):a.sameRow?p.splice(p.indexOf(a),1):(b=b.split(a.start.row,a.start.column),p=b.folds,p.shift(),b.start.row=p[0].start.row,b.start.column=p[0].start.column);this.$updating||(this.$useWrapMode?this.$updateWrapData(d,e):this.$updateRowLengthCache(d,e));this.$modified=!0;this._signal("changeFold",{data:a,action:"remove"})};this.removeFolds=function(a){for(var b=[],d=0;d<a.length;d++)b.push(a[d]);b.forEach(function(a){this.removeFold(a)},this);this.$modified=!0};this.expandFold=function(a){this.removeFold(a);
a.subFolds.forEach(function(b){a.restoreRange(b);this.addFold(b)},this);0<a.collapseChildren&&this.foldAll(a.start.row+1,a.end.row,a.collapseChildren-1);a.subFolds=[]};this.expandFolds=function(a){a.forEach(function(a){this.expandFold(a)},this)};this.unfold=function(a,b){null==a?(a=new k(0,0,this.getLength(),0),null==b&&(b=!0)):a="number"==typeof a?new k(a,0,a,this.getLine(a).length):"row"in a?k.fromPoints(a,a):a;a=this.getFoldsInRangeList(a);0!=b?this.removeFolds(a):this.expandFolds(a);if(a.length)return a};
this.isRowFolded=function(a,b){return!!this.getFoldLine(a,b)};this.getRowFoldEnd=function(a,b){return(b=this.getFoldLine(a,b))?b.end.row:a};this.getRowFoldStart=function(a,b){return(b=this.getFoldLine(a,b))?b.start.row:a};this.getFoldDisplayLine=function(a,b,d,e,g){null==e&&(e=a.start.row);null==g&&(g=0);null==b&&(b=a.end.row);null==d&&(d=this.getLine(b).length);var c=this.doc,f="";a.walk(function(a,b,d,l){if(!(b<e)){if(b==e){if(d<g)return;l=Math.max(g,l)}f=null!=a?f+a:f+c.getLine(b).substring(l,
d)}},b,d);return f};this.getDisplayLine=function(a,b,d,e){var c=this.getFoldLine(a);if(c)return this.getFoldDisplayLine(c,a,b,d,e);a=this.doc.getLine(a);return a.substring(e||0,b||a.length)};this.$cloneFoldData=function(){var a=[];return a=this.$foldData.map(function(b){b=b.folds.map(function(a){return a.clone()});return new x(a,b)})};this.toggleFold=function(a){var b=this.selection.getRange(),d;if(b.isEmpty()){var e=b.start;if(d=this.getFoldAt(e.row,e.column)){this.expandFold(d);return}(a=this.findMatchingBracket(e))?
1==b.comparePoint(a)?b.end=a:(b.start=a,b.start.column++,b.end.column--):(a=this.findMatchingBracket({row:e.row,column:e.column+1}))?(1==b.comparePoint(a)?b.end=a:b.start=a,b.start.column++):b=this.getCommentFoldRange(e.row,e.column)||b}else{e=this.getFoldsInRange(b);if(a&&e.length){this.expandFolds(e);return}1==e.length&&(d=e[0])}d||(d=this.getFoldAt(b.start.row,b.start.column));if(d&&d.range.toString()==b.toString())this.expandFold(d);else{d="...";if(!b.isMultiLine()){d=this.getTextRange(b);if(4>
d.length)return;d=d.trim().substring(0,2)+".."}this.addFold(d,b)}};this.getCommentFoldRange=function(a,b,e){var c=new d(this,a,b),f=c.getCurrentToken(),g=f&&f.type;if(f&&/^comment|string/.test(g)){g=g.match(/comment|string/)[0];"comment"==g&&(g+="|doc-start");g=new RegExp(g);var l=new k;if(1!=e){do f=c.stepBackward();while(f&&g.test(f.type));c.stepForward()}l.start.row=c.getCurrentTokenRow();l.start.column=c.getCurrentTokenColumn()+2;c=new d(this,a,b);if(-1!=e){a=-1;do if(f=c.stepForward(),-1==a)b=
this.getState(c.$row),g.test(b)||(a=c.$row);else if(c.$row>a)break;while(f&&g.test(f.type));f=c.stepBackward()}else f=c.getCurrentToken();l.end.row=c.getCurrentTokenRow();l.end.column=c.getCurrentTokenColumn()+f.value.length-2;return l}};this.foldAll=function(a,b,d,e){void 0==d&&(d=1E5);var c=this.foldWidgets;if(c){b=b||this.getLength();for(var f=a=a||0;f<b;f++)if(null==c[f]&&(c[f]=this.getFoldWidget(f)),"start"==c[f]&&(!e||e(f))){var l=this.getFoldWidgetRange(f);l&&l.isMultiLine()&&l.end.row<=b&&
l.start.row>=a&&(f=l.end.row,l.collapseChildren=d,this.addFold("...",l))}}};this.foldToLevel=function(a){for(this.foldAll();0<a--;)this.unfold(null,!1)};this.foldAllComments=function(){var a=this;this.foldAll(null,null,null,function(b){b=a.getTokens(b);for(var c=0;c<b.length;c++){var d=b[c];if("text"!=d.type||!/^\s+$/.test(d.value))return/comment/.test(d.type)?!0:!1}})};this.$foldStyles={manual:1,markbegin:1,markbeginend:1};this.$foldStyle="markbegin";this.setFoldStyle=function(a){if(!this.$foldStyles[a])throw Error("invalid fold style: "+
a+"["+Object.keys(this.$foldStyles).join(", ")+"]");this.$foldStyle!=a&&(this.$foldStyle=a,"manual"==a&&this.unfold(),a=this.$foldMode,this.$setFolding(null),this.$setFolding(a))};this.$setFolding=function(a){this.$foldMode!=a&&(this.$foldMode=a,this.off("change",this.$updateFoldWidgets),this.off("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets),this._signal("changeAnnotation"),a&&"manual"!=this.$foldStyle?(this.foldWidgets=[],this.getFoldWidget=a.getFoldWidget.bind(a,this,this.$foldStyle),this.getFoldWidgetRange=
a.getFoldWidgetRange.bind(a,this,this.$foldStyle),this.$updateFoldWidgets=this.updateFoldWidgets.bind(this),this.$tokenizerUpdateFoldWidgets=this.tokenizerUpdateFoldWidgets.bind(this),this.on("change",this.$updateFoldWidgets),this.on("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets)):this.foldWidgets=null)};this.getParentFoldRangeData=function(a,b){var c=this.foldWidgets;if(!c||b&&c[a])return{};b=a-1;for(var d;0<=b;){var e=c[b];null==e&&(e=c[b]=this.getFoldWidget(b));if("start"==e){var g=this.getFoldWidgetRange(b);
d||(d=g);if(g&&g.end.row>=a)break}b--}return{range:-1!==b&&g,firstRange:d}};this.onFoldWidgetClick=function(a,b){b=b.domEvent;this.$toggleFoldWidget(a,{children:b.shiftKey,all:b.ctrlKey||b.metaKey,siblings:b.altKey})||(a=b.target||b.srcElement)&&/ace_fold-widget/.test(a.className)&&(a.className+=" ace_invalid")};this.$toggleFoldWidget=function(a,b){if(this.getFoldWidget){var c=this.getFoldWidget(a),d=this.getLine(a);c="end"===c?-1:1;if(c=this.getFoldAt(a,-1===c?0:d.length,c))return b.children||b.all?
this.removeFold(c):this.expandFold(c),c;if((d=this.getFoldWidgetRange(a,!0))&&!d.isMultiLine()&&(c=this.getFoldAt(d.start.row,d.start.column,1))&&d.isEqual(c.range))return this.removeFold(c),c;if(b.siblings){a=this.getParentFoldRangeData(a);if(a.range)var e=a.range.start.row+1,g=a.range.end.row;this.foldAll(e,g,b.all?1E4:0)}else b.children?(g=d?d.end.row:this.getLength(),this.foldAll(a+1,g,b.all?1E4:0)):d&&(b.all&&(d.collapseChildren=1E4),this.addFold("...",d));return d}};this.toggleFoldWidget=function(a){var b=
this.selection.getCursor().row;b=this.getRowFoldStart(b);a=this.$toggleFoldWidget(b,{});!a&&(a=this.getParentFoldRangeData(b,!0),a=a.range||a.firstRange)&&(b=a.start.row,(b=this.getFoldAt(b,this.getLine(b).length,1))?this.removeFold(b):this.addFold("...",a))};this.updateFoldWidgets=function(a){var b=a.start.row,d=a.end.row-b;0===d?this.foldWidgets[b]=null:"remove"==a.action?this.foldWidgets.splice(b,d+1,null):(a=Array(d+1),a.unshift(b,1),this.foldWidgets.splice.apply(this.foldWidgets,a))};this.tokenizerUpdateFoldWidgets=
function(a){a=a.data;a.first!=a.last&&this.foldWidgets.length>a.first&&this.foldWidgets.splice(a.first,this.foldWidgets.length)}}});ace.define("ace/edit_session/bracket_match",["require","exports","module","ace/token_iterator","ace/range"],function(b,e,h){var k=b("../token_iterator").TokenIterator,x=b("../range").Range;e.BracketMatch=function(){this.findMatchingBracket=function(b,d){if(0==b.column)return null;d=d||this.getLine(b.row).charAt(b.column-1);return""==d?null:(d=d.match(/([\(\[\{])|([\)\]\}])/))?
d[1]?this.$findClosingBracket(d[1],b):this.$findOpeningBracket(d[2],b):null};this.getBracketRange=function(b){var d=this.getLine(b.row),a=!0,c=d.charAt(b.column-1);c=c&&c.match(/([\(\[\{])|([\)\]\}])/);c||(c=d.charAt(b.column),b={row:b.row,column:b.column+1},c=c&&c.match(/([\(\[\{])|([\)\]\}])/),a=!1);if(!c)return null;if(c[1]){d=this.$findClosingBracket(c[1],b);if(!d)return null;b=x.fromPoints(b,d);a||(b.end.column++,b.start.column--);b.cursor=b.end}else{d=this.$findOpeningBracket(c[2],b);if(!d)return null;
b=x.fromPoints(d,b);a||(b.start.column++,b.end.column--);b.cursor=b.start}return b};this.getMatchingBracketRanges=function(b){var d=this.getLine(b.row),a=d.charAt(b.column-1);a=a&&a.match(/([\(\[\{])|([\)\]\}])/);a||(a=d.charAt(b.column),b={row:b.row,column:b.column+1},a=a&&a.match(/([\(\[\{])|([\)\]\}])/));if(!a)return null;d=new x(b.row,b.column-1,b.row,b.column);b=a[1]?this.$findClosingBracket(a[1],b):this.$findOpeningBracket(a[2],b);if(!b)return[d];b=new x(b.row,b.column,b.row,b.column+1);return[d,
b]};this.$brackets={")":"(","(":")","]":"[","[":"]","{":"}","}":"{","<":">",">":"<"};this.$findOpeningBracket=function(b,d,a){var c=this.$brackets[b],e=1,g=new k(this,d.row,d.column),m=g.getCurrentToken();m||(m=g.stepForward());if(m){a||(a=new RegExp("(\\.?"+m.type.replace(".","\\.").replace("rparen",".paren").replace(/\b(?:end)\b/,"(?:start|begin|end)")+")+"));d=d.column-g.getCurrentTokenColumn()-2;for(m=m.value;;){for(;0<=d;){var p=m.charAt(d);if(p==c){if(--e,0==e)return{row:g.getCurrentTokenRow(),
column:d+g.getCurrentTokenColumn()}}else p==b&&(e+=1);--d}do m=g.stepBackward();while(m&&!a.test(m.type));if(null==m)break;m=m.value;d=m.length-1}return null}};this.$findClosingBracket=function(b,d,a){var c=this.$brackets[b],e=1,g=new k(this,d.row,d.column),m=g.getCurrentToken();m||(m=g.stepForward());if(m){a||(a=new RegExp("(\\.?"+m.type.replace(".","\\.").replace("lparen",".paren").replace(/\b(?:start|begin)\b/,"(?:start|begin|end)")+")+"));for(d=d.column-g.getCurrentTokenColumn();;){m=m.value;
for(var p=m.length;d<p;){var l=m.charAt(d);if(l==c){if(--e,0==e)return{row:g.getCurrentTokenRow(),column:d+g.getCurrentTokenColumn()}}else l==b&&(e+=1);d+=1}do m=g.stepForward();while(m&&!a.test(m.type));if(null==m)break;d=0}return null}}}});ace.define("ace/edit_session","require exports module ace/lib/oop ace/lib/lang ace/bidihandler ace/config ace/lib/event_emitter ace/selection ace/mode/text ace/range ace/document ace/background_tokenizer ace/search_highlight ace/edit_session/folding ace/edit_session/bracket_match".split(" "),
function(b,e,h){var k=b("./lib/oop"),x=b("./lib/lang"),g=b("./bidihandler").BidiHandler,d=b("./config"),a=b("./lib/event_emitter").EventEmitter,c=b("./selection").Selection,f=b("./mode/text").Mode,w=b("./range").Range,m=b("./document").Document,p=b("./background_tokenizer").BackgroundTokenizer,l=b("./search_highlight").SearchHighlight,u=function(a,b){this.$breakpoints=[];this.$decorations=[];this.$frontMarkers={};this.$backMarkers={};this.$markerId=1;this.$undoSelect=!0;this.$foldData=[];this.id=
"session"+ ++u.$uid;this.$foldData.toString=function(){return this.join("\n")};this.on("changeFold",this.onChangeFold.bind(this));this.$onChange=this.onChange.bind(this);"object"==typeof a&&a.getLine||(a=new m(a));this.setDocument(a);this.selection=new c(this);this.$bidiHandler=new g(this);d.resetOptions(this);this.setMode(b);d._signal("session",this)};u.$uid=0;(function(){function b(a){return 4352>a?!1:4352<=a&&4447>=a||4515<=a&&4519>=a||4602<=a&&4607>=a||9001<=a&&9002>=a||11904<=a&&11929>=a||11931<=
a&&12019>=a||12032<=a&&12245>=a||12272<=a&&12283>=a||12288<=a&&12350>=a||12353<=a&&12438>=a||12441<=a&&12543>=a||12549<=a&&12589>=a||12593<=a&&12686>=a||12688<=a&&12730>=a||12736<=a&&12771>=a||12784<=a&&12830>=a||12832<=a&&12871>=a||12880<=a&&13054>=a||13056<=a&&19903>=a||19968<=a&&42124>=a||42128<=a&&42182>=a||43360<=a&&43388>=a||44032<=a&&55203>=a||55216<=a&&55238>=a||55243<=a&&55291>=a||63744<=a&&64255>=a||65040<=a&&65049>=a||65072<=a&&65106>=a||65108<=a&&65126>=a||65128<=a&&65131>=a||65281<=a&&
65376>=a||65504<=a&&65510>=a}k.implement(this,a);this.setDocument=function(a){this.doc&&this.doc.removeListener("change",this.$onChange);this.doc=a;a.on("change",this.$onChange);this.bgTokenizer&&this.bgTokenizer.setDocument(this.getDocument());this.resetCaches()};this.getDocument=function(){return this.doc};this.$resetRowCache=function(a){if(a){var b=this.$docRowCache.length;a=this.$getRowCacheIndex(this.$docRowCache,a)+1;b>a&&(this.$docRowCache.splice(a,b),this.$screenRowCache.splice(a,b))}else this.$docRowCache=
[],this.$screenRowCache=[]};this.$getRowCacheIndex=function(a,b){for(var c=0,d=a.length-1;c<=d;){var e=c+d>>1,f=a[e];if(b>f)c=e+1;else if(b<f)d=e-1;else return e}return c-1};this.resetCaches=function(){this.$modified=!0;this.$wrapData=[];this.$rowLengthCache=[];this.$resetRowCache(0);this.bgTokenizer&&this.bgTokenizer.start(0)};this.onChangeFold=function(a){this.$resetRowCache(a.data.start.row)};this.onChange=function(a){this.$modified=!0;this.$bidiHandler.onChange(a);this.$resetRowCache(a.start.row);
var b=this.$updateInternalDataOnChange(a);!this.$fromUndo&&this.$undoManager&&(b&&b.length&&(this.$undoManager.add({action:"removeFolds",folds:b},this.mergeUndoDeltas),this.mergeUndoDeltas=!0),this.$undoManager.add(a,this.mergeUndoDeltas),this.mergeUndoDeltas=!0,this.$informUndoManager.schedule());this.bgTokenizer&&this.bgTokenizer.$updateOnChange(a);this._signal("change",a)};this.setValue=function(a){this.doc.setValue(a);this.selection.moveTo(0,0);this.$resetRowCache(0);this.setUndoManager(this.$undoManager);
this.getUndoManager().reset()};this.getValue=this.toString=function(){return this.doc.getValue()};this.getSelection=function(){return this.selection};this.getState=function(a){return this.bgTokenizer.getState(a)};this.getTokens=function(a){return this.bgTokenizer.getTokens(a)};this.getTokenAt=function(a,b){var c=this.bgTokenizer.getTokens(a),d=0;if(null==b){var e=c.length-1;d=this.getLine(a).length}else for(e=0;e<c.length&&!(d+=c[e].value.length,d>=b);e++);a=c[e];if(!a)return null;a.index=e;a.start=
d-a.value.length;return a};this.setUndoManager=function(a){this.$undoManager=a;this.$informUndoManager&&this.$informUndoManager.cancel();if(a){var b=this;a.addSession(this);this.$syncInformUndoManager=function(){b.$informUndoManager.cancel();b.mergeUndoDeltas=!1};this.$informUndoManager=x.delayedCall(this.$syncInformUndoManager)}else this.$syncInformUndoManager=function(){}};this.markUndoGroup=function(){this.$syncInformUndoManager&&this.$syncInformUndoManager()};this.$defaultUndoManager={undo:function(){},
redo:function(){},hasUndo:function(){},hasRedo:function(){},reset:function(){},add:function(){},addSelection:function(){},startNewGroup:function(){},addSession:function(){}};this.getUndoManager=function(){return this.$undoManager||this.$defaultUndoManager};this.getTabString=function(){return this.getUseSoftTabs()?x.stringRepeat(" ",this.getTabSize()):"\t"};this.setUseSoftTabs=function(a){this.setOption("useSoftTabs",a)};this.getUseSoftTabs=function(){return this.$useSoftTabs&&!this.$mode.$indentWithTabs};
this.setTabSize=function(a){this.setOption("tabSize",a)};this.getTabSize=function(){return this.$tabSize};this.isTabStop=function(a){return this.$useSoftTabs&&0===a.column%this.$tabSize};this.setNavigateWithinSoftTabs=function(a){this.setOption("navigateWithinSoftTabs",a)};this.getNavigateWithinSoftTabs=function(){return this.$navigateWithinSoftTabs};this.$overwrite=!1;this.setOverwrite=function(a){this.setOption("overwrite",a)};this.getOverwrite=function(){return this.$overwrite};this.toggleOverwrite=
function(){this.setOverwrite(!this.$overwrite)};this.addGutterDecoration=function(a,b){this.$decorations[a]||(this.$decorations[a]="");this.$decorations[a]+=" "+b;this._signal("changeBreakpoint",{})};this.removeGutterDecoration=function(a,b){this.$decorations[a]=(this.$decorations[a]||"").replace(" "+b,"");this._signal("changeBreakpoint",{})};this.getBreakpoints=function(){return this.$breakpoints};this.setBreakpoints=function(a){this.$breakpoints=[];for(var b=0;b<a.length;b++)this.$breakpoints[a[b]]=
"ace_breakpoint";this._signal("changeBreakpoint",{})};this.clearBreakpoints=function(){this.$breakpoints=[];this._signal("changeBreakpoint",{})};this.setBreakpoint=function(a,b){void 0===b&&(b="ace_breakpoint");b?this.$breakpoints[a]=b:delete this.$breakpoints[a];this._signal("changeBreakpoint",{})};this.clearBreakpoint=function(a){delete this.$breakpoints[a];this._signal("changeBreakpoint",{})};this.addMarker=function(a,b,c,d){var e=this.$markerId++;a={range:a,type:c||"line",renderer:"function"==
typeof c?c:null,clazz:b,inFront:!!d,id:e};d?(this.$frontMarkers[e]=a,this._signal("changeFrontMarker")):(this.$backMarkers[e]=a,this._signal("changeBackMarker"));return e};this.addDynamicMarker=function(a,b){if(a.update){var c=this.$markerId++;a.id=c;a.inFront=!!b;b?(this.$frontMarkers[c]=a,this._signal("changeFrontMarker")):(this.$backMarkers[c]=a,this._signal("changeBackMarker"));return a}};this.removeMarker=function(a){var b=this.$frontMarkers[a]||this.$backMarkers[a];b&&(delete (b.inFront?this.$frontMarkers:
this.$backMarkers)[a],this._signal(b.inFront?"changeFrontMarker":"changeBackMarker"))};this.getMarkers=function(a){return a?this.$frontMarkers:this.$backMarkers};this.highlight=function(a){if(!this.$searchHighlight){var b=new l(null,"ace_selected-word","text");this.$searchHighlight=this.addDynamicMarker(b)}this.$searchHighlight.setRegexp(a)};this.highlightLines=function(a,b,c,d){"number"!=typeof b&&(c=b,b=a);c||(c="ace_step");a=new w(a,0,b,Infinity);a.id=this.addMarker(a,c,"fullLine",d);return a};
this.setAnnotations=function(a){this.$annotations=a;this._signal("changeAnnotation",{})};this.getAnnotations=function(){return this.$annotations||[]};this.clearAnnotations=function(){this.setAnnotations([])};this.$detectNewLine=function(a){this.$autoNewLine=(a=a.match(/^.*?(\r?\n)/m))?a[1]:"\n"};this.getWordRange=function(a,b){var c=this.getLine(a),d=!1;0<b&&(d=!!c.charAt(b-1).match(this.tokenRe));d||(d=!!c.charAt(b).match(this.tokenRe));d=d?this.tokenRe:/^\s+$/.test(c.slice(b-1,b+1))?/\s/:this.nonTokenRe;
var e=b;if(0<e){do e--;while(0<=e&&c.charAt(e).match(d));e++}for(;b<c.length&&c.charAt(b).match(d);)b++;return new w(a,e,a,b)};this.getAWordRange=function(a,b){a=this.getWordRange(a,b);for(b=this.getLine(a.end.row);b.charAt(a.end.column).match(/[ \t]/);)a.end.column+=1;return a};this.setNewLineMode=function(a){this.doc.setNewLineMode(a)};this.getNewLineMode=function(){return this.doc.getNewLineMode()};this.setUseWorker=function(a){this.setOption("useWorker",a)};this.getUseWorker=function(){return this.$useWorker};
this.onReloadTokenizer=function(a){this.bgTokenizer.start(a.data.first);this._signal("tokenizerUpdate",a)};this.$modes=d.$modes;this.$modeId=this.$mode=null;this.setMode=function(a,b){if(a&&"object"===typeof a){if(a.getTokenizer)return this.$onChangeMode(a);var c=a,e=c.path}else e=a||"ace/mode/text";this.$modes["ace/mode/text"]||(this.$modes["ace/mode/text"]=new f);this.$modes[e]&&!c?(this.$onChangeMode(this.$modes[e]),b&&b()):(this.$modeId=e,d.loadModule(["mode",e],function(a){if(this.$modeId!==
e)return b&&b();this.$modes[e]&&!c?this.$onChangeMode(this.$modes[e]):a&&a.Mode&&(a=new a.Mode(c),c||(this.$modes[e]=a,a.$id=e),this.$onChangeMode(a));b&&b()}.bind(this)),this.$mode||this.$onChangeMode(this.$modes["ace/mode/text"],!0))};this.$onChangeMode=function(a,b){b||(this.$modeId=a.$id);if(this.$mode!==a){var c=this.$mode;this.$mode=a;this.$stopWorker();this.$useWorker&&this.$startWorker();var d=a.getTokenizer();if(void 0!==d.on){var e=this.onReloadTokenizer.bind(this);d.on("update",e)}if(this.bgTokenizer)this.bgTokenizer.setTokenizer(d);
else{this.bgTokenizer=new p(d);var f=this;this.bgTokenizer.on("update",function(a){f._signal("tokenizerUpdate",a)})}this.bgTokenizer.setDocument(this.getDocument());this.tokenRe=a.tokenRe;this.nonTokenRe=a.nonTokenRe;b||(a.attachToSession&&a.attachToSession(this),this.$options.wrapMethod.set.call(this,this.$wrapMethod),this.$setFolding(a.foldingRules),this.bgTokenizer.start(0),this._emit("changeMode",{oldMode:c,mode:a}))}};this.$stopWorker=function(){this.$worker&&(this.$worker.terminate(),this.$worker=
null)};this.$startWorker=function(){try{this.$worker=this.$mode.createWorker(this)}catch(n){d.warn("Could not load worker",n),this.$worker=null}};this.getMode=function(){return this.$mode};this.$scrollTop=0;this.setScrollTop=function(a){this.$scrollTop===a||isNaN(a)||(this.$scrollTop=a,this._signal("changeScrollTop",a))};this.getScrollTop=function(){return this.$scrollTop};this.$scrollLeft=0;this.setScrollLeft=function(a){this.$scrollLeft===a||isNaN(a)||(this.$scrollLeft=a,this._signal("changeScrollLeft",
a))};this.getScrollLeft=function(){return this.$scrollLeft};this.getScreenWidth=function(){this.$computeWidth();return this.lineWidgets?Math.max(this.getLineWidgetMaxWidth(),this.screenWidth):this.screenWidth};this.getLineWidgetMaxWidth=function(){if(null!=this.lineWidgetsWidth)return this.lineWidgetsWidth;var a=0;this.lineWidgets.forEach(function(b){b&&b.screenWidth>a&&(a=b.screenWidth)});return this.lineWidgetWidth=a};this.$computeWidth=function(a){if(this.$modified||a){this.$modified=!1;if(this.$useWrapMode)return this.screenWidth=
this.$wrapLimit;a=this.doc.getAllLines();for(var b=this.$rowLengthCache,c=0,d=0,e=this.$foldData[d],f=e?e.start.row:Infinity,l=a.length,n=0;n<l;n++){if(n>f){n=e.end.row+1;if(n>=l)break;f=(e=this.$foldData[d++])?e.start.row:Infinity}null==b[n]&&(b[n]=this.$getStringScreenWidth(a[n])[0]);b[n]>c&&(c=b[n])}this.screenWidth=c}};this.getLine=function(a){return this.doc.getLine(a)};this.getLines=function(a,b){return this.doc.getLines(a,b)};this.getLength=function(){return this.doc.getLength()};this.getTextRange=
function(a){return this.doc.getTextRange(a||this.selection.getRange())};this.insert=function(a,b){return this.doc.insert(a,b)};this.remove=function(a){return this.doc.remove(a)};this.removeFullLines=function(a,b){return this.doc.removeFullLines(a,b)};this.undoChanges=function(a,b){if(a.length){this.$fromUndo=!0;for(var c=a.length-1;-1!=c;c--){var d=a[c];"insert"==d.action||"remove"==d.action?this.doc.revertDelta(d):d.folds&&this.addFolds(d.folds)}!b&&this.$undoSelect&&(a.selectionBefore?this.selection.fromJSON(a.selectionBefore):
this.selection.setRange(this.$getUndoSelection(a,!0)));this.$fromUndo=!1}};this.redoChanges=function(a,b){if(a.length){this.$fromUndo=!0;for(var c=0;c<a.length;c++){var d=a[c];"insert"!=d.action&&"remove"!=d.action||this.doc.$safeApplyDelta(d)}!b&&this.$undoSelect&&(a.selectionAfter?this.selection.fromJSON(a.selectionAfter):this.selection.setRange(this.$getUndoSelection(a,!1)));this.$fromUndo=!1}};this.setUndoSelect=function(a){this.$undoSelect=a};this.$getUndoSelection=function(a,b){for(var c,d,
e=0;e<a.length;e++){var f=a[e];f.start&&(c?(b?"insert"!==f.action:"insert"===f.action)?(d=f.start,-1==c.compare(d.row,d.column)&&c.setStart(d),d=f.end,1==c.compare(d.row,d.column)&&c.setEnd(d)):(d=f.start,-1==c.compare(d.row,d.column)&&(c=w.fromPoints(f.start,f.start))):c=(b?"insert"!==f.action:"insert"===f.action)?w.fromPoints(f.start,f.end):w.fromPoints(f.start,f.start))}return c};this.replace=function(a,b){return this.doc.replace(a,b)};this.moveText=function(a,b,c){var d=this.getTextRange(a),e=
this.getFoldsInRange(a);b=w.fromPoints(b,b);if(!c){this.remove(a);var f=a.start.row-a.end.row,l=f?-a.end.column:a.start.column-a.end.column;l&&(b.start.row==a.end.row&&b.start.column>a.end.column&&(b.start.column+=l),b.end.row==a.end.row&&b.end.column>a.end.column&&(b.end.column+=l));f&&b.start.row>=a.end.row&&(b.start.row+=f,b.end.row+=f)}b.end=this.insert(b.start,d);if(e.length){var g=a.start;a=b.start;f=a.row-g.row;l=a.column-g.column;this.addFolds(e.map(function(a){a=a.clone();a.start.row==g.row&&
(a.start.column+=l);a.end.row==g.row&&(a.end.column+=l);a.start.row+=f;a.end.row+=f;return a}))}return b};this.indentRows=function(a,b,c){for(c=c.replace(/\t/g,this.getTabString());a<=b;a++)this.doc.insertInLine({row:a,column:0},c)};this.outdentRows=function(a){a=a.collapseRows();for(var b=new w(0,0,0,0),c=this.getTabSize(),d=a.start.row;d<=a.end.row;++d){var e=this.getLine(d);b.start.row=d;b.end.row=d;for(var f=0;f<c&&" "==e.charAt(f);++f);f<c&&"\t"==e.charAt(f)?(b.start.column=f,b.end.column=f+
1):(b.start.column=0,b.end.column=f);this.remove(b)}};this.$moveLines=function(a,b,c){a=this.getRowFoldStart(a);b=this.getRowFoldEnd(b);if(0>c){var d=this.getRowFoldStart(a+c);if(0>d)return 0;var e=d-a}else if(0<c){d=this.getRowFoldEnd(b+c);if(d>this.doc.getLength()-1)return 0;e=d-b}else a=this.$clipRowToDocument(a),b=this.$clipRowToDocument(b),e=b-a+1;d=new w(a,0,b,Number.MAX_VALUE);d=this.getFoldsInRange(d).map(function(a){a=a.clone();a.start.row+=e;a.end.row+=e;return a});b=0==c?this.doc.getLines(a,
b):this.doc.removeFullLines(a,b);this.doc.insertFullLines(a+e,b);d.length&&this.addFolds(d);return e};this.moveLinesUp=function(a,b){return this.$moveLines(a,b,-1)};this.moveLinesDown=function(a,b){return this.$moveLines(a,b,1)};this.duplicateLines=function(a,b){return this.$moveLines(a,b,0)};this.$clipRowToDocument=function(a){return Math.max(0,Math.min(a,this.doc.getLength()-1))};this.$clipColumnToRow=function(a,b){return 0>b?0:Math.min(this.doc.getLine(a).length,b)};this.$clipPositionToDocument=
function(a,b){b=Math.max(0,b);if(0>a)b=a=0;else{var c=this.doc.getLength();a>=c?(a=c-1,b=this.doc.getLine(c-1).length):b=Math.min(this.doc.getLine(a).length,b)}return{row:a,column:b}};this.$clipRangeToDocument=function(a){0>a.start.row?(a.start.row=0,a.start.column=0):a.start.column=this.$clipColumnToRow(a.start.row,a.start.column);var b=this.doc.getLength()-1;a.end.row>b?(a.end.row=b,a.end.column=this.doc.getLine(b).length):a.end.column=this.$clipColumnToRow(a.end.row,a.end.column);return a};this.$wrapLimit=
80;this.$useWrapMode=!1;this.$wrapLimitRange={min:null,max:null};this.setUseWrapMode=function(a){a!=this.$useWrapMode&&(this.$useWrapMode=a,this.$modified=!0,this.$resetRowCache(0),a&&(a=this.getLength(),this.$wrapData=Array(a),this.$updateWrapData(0,a-1)),this._signal("changeWrapMode"))};this.getUseWrapMode=function(){return this.$useWrapMode};this.setWrapLimitRange=function(a,b){if(this.$wrapLimitRange.min!==a||this.$wrapLimitRange.max!==b)this.$wrapLimitRange={min:a,max:b},this.$modified=!0,this.$bidiHandler.markAsDirty(),
this.$useWrapMode&&this._signal("changeWrapMode")};this.adjustWrapLimit=function(a,b){var c=this.$wrapLimitRange;0>c.max&&(c={min:b,max:b});a=this.$constrainWrapLimit(a,c.min,c.max);return a!=this.$wrapLimit&&1<a?(this.$wrapLimit=a,this.$modified=!0,this.$useWrapMode&&(this.$updateWrapData(0,this.getLength()-1),this.$resetRowCache(0),this._signal("changeWrapLimit")),!0):!1};this.$constrainWrapLimit=function(a,b,c){b&&(a=Math.max(b,a));c&&(a=Math.min(c,a));return a};this.getWrapLimit=function(){return this.$wrapLimit};
this.setWrapLimit=function(a){this.setWrapLimitRange(a,a)};this.getWrapLimitRange=function(){return{min:this.$wrapLimitRange.min,max:this.$wrapLimitRange.max}};this.$updateInternalDataOnChange=function(a){var b=this.$useWrapMode,c=a.action,d=a.start,e=a.end,f=d.row,l=e.row,g=l-f,q=null;this.$updating=!0;if(0!=g)if("remove"===c){this[b?"$wrapData":"$rowLengthCache"].splice(f,g);c=this.$foldData;q=this.getFoldsInRange(a);this.removeFolds(q);a=this.getFoldLine(e.row);var n=0;a&&(a.addRemoveChars(e.row,
e.column,d.column-e.column),a.shiftRow(-g),(d=this.getFoldLine(f))&&d!==a&&(d.merge(a),a=d),n=c.indexOf(a)+1);for(n;n<c.length;n++)a=c[n],a.start.row>=e.row&&a.shiftRow(-g);l=f}else{c=Array(g);c.unshift(f,0);a=b?this.$wrapData:this.$rowLengthCache;a.splice.apply(a,c);c=this.$foldData;a=this.getFoldLine(f);n=0;if(a){n=a.range.compareInside(d.row,d.column);if(0==n){if(a=a.split(d.row,d.column))a.shiftRow(g),a.addRemoveChars(l,0,e.column-d.column)}else-1==n&&(a.addRemoveChars(f,0,e.column-d.column),
a.shiftRow(g));n=c.indexOf(a)+1}for(n;n<c.length;n++)a=c[n],a.start.row>=f&&a.shiftRow(g)}else g=Math.abs(a.start.column-a.end.column),"remove"===c&&(q=this.getFoldsInRange(a),this.removeFolds(q),g=-g),(a=this.getFoldLine(f))&&a.addRemoveChars(f,d.column,g);b&&this.$wrapData.length!=this.doc.getLength()&&console.error("doc.getLength() and $wrapData.length have to be the same!");this.$updating=!1;b?this.$updateWrapData(f,l):this.$updateRowLengthCache(f,l);return q};this.$updateRowLengthCache=function(a,
b,c){this.$rowLengthCache[a]=null;this.$rowLengthCache[b]=null};this.$updateWrapData=function(a,b){var d=this.doc.getAllLines(),f=this.getTabSize(),l=this.$wrapData,g=this.$wrapLimit,q;for(b=Math.min(b,d.length-1);a<=b;)if(q=this.getFoldLine(a,q)){var n=[];q.walk(function(a,b,f,l){if(null!=a)for(a=this.$getDisplayTokens(a,n.length),a[0]=c,b=1;b<a.length;b++)a[b]=e;else a=this.$getDisplayTokens(d[b].substring(l,f),n.length);n=n.concat(a)}.bind(this),q.end.row,d[q.end.row].length+1);l[q.start.row]=
this.$computeWrapSplits(n,g,f);a=q.end.row+1}else n=this.$getDisplayTokens(d[a]),l[a]=this.$computeWrapSplits(n,g,f),a++};var c=3,e=4;this.$computeWrapSplits=function(a,b,d){function f(b){for(var c=b-q,e=q;e<b;e++){var f=a[e];12!==f&&2!==f||--c}if(!l.length){e=0;if(0===p)u=e;else{if(m)for(f=0;f<a.length;f++){var g=a[f];if(10==g)e+=1;else if(11==g)e+=d;else if(12!=g)break}v&&!1!==m&&(e+=d);u=Math.min(e,p)}l.indent=u}n+=c;l.push(n);q=b}if(0==a.length)return[];for(var l=[],g=a.length,q=0,n=0,v=this.$wrapAsCode,
m=this.$indentedSoftWrap,p=b<=Math.max(2*d,8)||!1===m?0:Math.floor(b/2),u=0;g-q>b-u;){var w=q+b-u;if(10<=a[w-1]&&10<=a[w])f(w);else if(a[w]==c||a[w]==e){for(w;w!=q-1&&a[w]!=c;w--);if(!(w>q)){w=q+b;for(w;w<a.length&&a[w]==e;w++);if(w==a.length)break}f(w)}else{for(var k=Math.max(w-(b-(b>>2)),q-1);w>k&&a[w]<c;)w--;if(v){for(;w>k&&a[w]<c;)w--;for(;w>k&&9==a[w];)w--}else for(;w>k&&10>a[w];)w--;w>k?f(++w):(w=q+b,2==a[w]&&w--,f(w-u))}}return l};this.$getDisplayTokens=function(a,c){var d=[];c=c||0;for(var e=
0;e<a.length;e++){var f=a.charCodeAt(e);if(9==f){f=this.getScreenTabSize(d.length+c);d.push(11);for(var l=1;l<f;l++)d.push(12)}else 32==f?d.push(10):39<f&&48>f||57<f&&64>f?d.push(9):4352<=f&&b(f)?d.push(1,2):d.push(1)}return d};this.$getStringScreenWidth=function(a,c,d){if(0==c)return[0,0];null==c&&(c=Infinity);d=d||0;var e;for(e=0;e<a.length;e++){var f=a.charCodeAt(e);d=9==f?d+this.getScreenTabSize(d):4352<=f&&b(f)?d+2:d+1;if(d>c)break}return[d,e]};this.lineWidgets=null;this.getRowLength=function(a){var b=
1;this.lineWidgets&&(b+=this.lineWidgets[a]&&this.lineWidgets[a].rowCount||0);return this.$useWrapMode&&this.$wrapData[a]?this.$wrapData[a].length+b:b};this.getRowLineCount=function(a){return this.$useWrapMode&&this.$wrapData[a]?this.$wrapData[a].length+1:1};this.getRowWrapIndent=function(a){if(this.$useWrapMode){a=this.screenToDocumentPosition(a,Number.MAX_VALUE);var b=this.$wrapData[a.row];return b.length&&b[0]<a.column?b.indent:0}return 0};this.getScreenLastRowColumn=function(a){a=this.screenToDocumentPosition(a,
Number.MAX_VALUE);return this.documentToScreenColumn(a.row,a.column)};this.getDocumentLastRowColumn=function(a,b){a=this.documentToScreenRow(a,b);return this.getScreenLastRowColumn(a)};this.getDocumentLastRowColumnPosition=function(a,b){a=this.documentToScreenRow(a,b);return this.screenToDocumentPosition(a,Number.MAX_VALUE/10)};this.getRowSplitData=function(a){if(this.$useWrapMode)return this.$wrapData[a]};this.getScreenTabSize=function(a){return this.$tabSize-(a%this.$tabSize|0)};this.screenToDocumentRow=
function(a,b){return this.screenToDocumentPosition(a,b).row};this.screenToDocumentColumn=function(a,b){return this.screenToDocumentPosition(a,b).column};this.screenToDocumentPosition=function(a,b,c){if(0>a)return{row:0,column:0};var d=0,e=0,f=0;var l=0;var g=this.$screenRowCache,q=this.$getRowCacheIndex(g,a),n=g.length;n&&0<=q?(f=g[q],d=this.$docRowCache[q],q=a>g[n-1]):q=!n;n=this.getLength()-1;for(var v=(g=this.getNextFoldLine(d))?g.start.row:Infinity;f<=a;){l=this.getRowLength(d);if(f+l>a||d>=n)break;
else f+=l,d++,d>v&&(d=g.end.row+1,v=(g=this.getNextFoldLine(d,g))?g.start.row:Infinity);q&&(this.$docRowCache.push(d),this.$screenRowCache.push(f))}if(g&&g.start.row<=d)l=this.getFoldDisplayLine(g),d=g.start.row;else{if(f+l<=a||d>n)return{row:n,column:this.getLine(n).length};l=this.getLine(d);g=null}q=0;a=Math.floor(a-f);if(this.$useWrapMode&&(n=this.$wrapData[d])){var m=n[a];0<a&&n.length&&(q=n.indent,e=n[a-1]||n[n.length-1],l=l.substring(e))}void 0!==c&&this.$bidiHandler.isBidiRow(f+a,d,a)&&(b=
this.$bidiHandler.offsetToCol(c));e+=this.$getStringScreenWidth(l,b-q)[1];this.$useWrapMode&&e>=m&&(e=m-1);return g?g.idxToPosition(e):{row:d,column:e}};this.documentToScreenPosition=function(a,b){var c="undefined"===typeof b?this.$clipPositionToDocument(a.row,a.column):this.$clipPositionToDocument(a,b);a=c.row;b=c.column;c=0;var d;if(d=this.getFoldAt(a,b,1))a=d.start.row,b=d.start.column;d=0;var e=this.$docRowCache;var f=this.$getRowCacheIndex(e,a);var l=e.length;l&&0<=f?(d=e[f],c=this.$screenRowCache[f],
l=a>e[l-1]):l=!l;for(var g=(e=this.getNextFoldLine(d))?e.start.row:Infinity;d<a;){if(d>=g){f=e.end.row+1;if(f>a)break;g=(e=this.getNextFoldLine(f,e))?e.start.row:Infinity}else f=d+1;c+=this.getRowLength(d);d=f;l&&(this.$docRowCache.push(d),this.$screenRowCache.push(c))}e&&d>=g?(b=this.getFoldDisplayLine(e,a,b),e=e.start.row):(b=this.getLine(a).substring(0,b),e=a);a=0;if(this.$useWrapMode&&(e=this.$wrapData[e])){for(a=0;b.length>=e[a];)c++,a++;b=b.substring(e[a-1]||0,b.length);a=0<a?e.indent:0}this.lineWidgets&&
this.lineWidgets[d]&&this.lineWidgets[d].rowsAbove&&(c+=this.lineWidgets[d].rowsAbove);return{row:c,column:a+this.$getStringScreenWidth(b)[0]}};this.documentToScreenColumn=function(a,b){return this.documentToScreenPosition(a,b).column};this.documentToScreenRow=function(a,b){return this.documentToScreenPosition(a,b).row};this.getScreenLength=function(){var a=0,b;if(this.$useWrapMode){var c=this.$wrapData.length,d=0;l=0;for(var e=(b=this.$foldData[l++])?b.start.row:Infinity;d<c;){var f=this.$wrapData[d];
a+=f?f.length+1:1;d++;d>e&&(d=b.end.row+1,e=(b=this.$foldData[l++])?b.start.row:Infinity)}}else{a=this.getLength();c=this.$foldData;for(var l=0;l<c.length;l++)b=c[l],a-=b.end.row-b.start.row}this.lineWidgets&&(a+=this.$getWidgetScreenLength());return a};this.$setFontMetrics=function(a){this.$enableVarChar&&(this.$getStringScreenWidth=function(b,c,d){if(0===c)return[0,0];c||(c=Infinity);d=d||0;var e;for(e=0;e<b.length;e++){var f=b.charAt(e);d="\t"===f?d+this.getScreenTabSize(d):d+a.getCharacterWidth(f);
if(d>c)break}return[d,e]})};this.destroy=function(){this.bgTokenizer&&(this.bgTokenizer.setDocument(null),this.bgTokenizer=null);this.$stopWorker();this.removeAllListeners();this.selection.detach()};this.isFullWidth=b}).call(u.prototype);b("./edit_session/folding").Folding.call(u.prototype);b("./edit_session/bracket_match").BracketMatch.call(u.prototype);d.defineOptions(u.prototype,"session",{wrap:{set:function(a){a&&"off"!=a?"free"==a?a=!0:"printMargin"==a?a=-1:"string"==typeof a&&(a=parseInt(a,
10)||!1):a=!1;this.$wrap!=a&&((this.$wrap=a)?(a="number"==typeof a?a:null,this.setWrapLimitRange(a,a),this.setUseWrapMode(!0)):this.setUseWrapMode(!1))},get:function(){return this.getUseWrapMode()?-1==this.$wrap?"printMargin":this.getWrapLimitRange().min?this.$wrap:"free":"off"},handlesSet:!0},wrapMethod:{set:function(a){a="auto"==a?"text"!=this.$mode.type:"text"!=a;a!=this.$wrapAsCode&&(this.$wrapAsCode=a,this.$useWrapMode&&(this.$useWrapMode=!1,this.setUseWrapMode(!0)))},initialValue:"auto"},indentedSoftWrap:{set:function(){this.$useWrapMode&&
(this.$useWrapMode=!1,this.setUseWrapMode(!0))},initialValue:!0},firstLineNumber:{set:function(){this._signal("changeBreakpoint")},initialValue:1},useWorker:{set:function(a){this.$useWorker=a;this.$stopWorker();a&&this.$startWorker()},initialValue:!0},useSoftTabs:{initialValue:!0},tabSize:{set:function(a){a=parseInt(a);0<a&&this.$tabSize!==a&&(this.$modified=!0,this.$rowLengthCache=[],this.$tabSize=a,this._signal("changeTabSize"))},initialValue:4,handlesSet:!0},navigateWithinSoftTabs:{initialValue:!1},
foldStyle:{set:function(a){this.setFoldStyle(a)},handlesSet:!0},overwrite:{set:function(a){this._signal("changeOverwrite")},initialValue:!1},newLineMode:{set:function(a){this.doc.setNewLineMode(a)},get:function(){return this.doc.getNewLineMode()},handlesSet:!0},mode:{set:function(a){this.setMode(a)},get:function(){return this.$modeId},handlesSet:!0}});e.EditSession=u});ace.define("ace/search","require exports module ace/lib/lang ace/lib/oop ace/range".split(" "),function(b,e,h){var k=b("./lib/lang"),
x=b("./lib/oop"),g=b("./range").Range;b=function(){this.$options={}};(function(){this.set=function(b){x.mixin(this.$options,b);return this};this.getOptions=function(){return k.copyObject(this.$options)};this.setOptions=function(b){this.$options=b};this.find=function(b){var a=this.$options;b=this.$matchIterator(b,a);if(!b)return!1;var c=null;b.forEach(function(b,d,e,p){c=new g(b,d,e,p);return d==p&&a.start&&a.start.start&&0!=a.skipCurrent&&c.isEqual(a.start)?(c=null,!1):!0});return c};this.findAll=
function(b){var a=this.$options;if(!a.needle)return[];this.$assembleRegExp(a);var c=a.range,d=c?b.getLines(c.start.row,c.end.row):b.doc.getAllLines();b=[];var e=a.re;if(a.$isMultiLine){var m=e.length,p=d.length-m,l,u=e.offset||0;a:for(;u<=p;u++){for(a=0;a<m;a++)if(-1==d[u+a].search(e[a]))continue a;var v=d[u];a=d[u+m-1];v=v.length-v.match(e[0])[0].length;a=a.match(e[m-1])[0].length;l&&l.end.row===u&&l.end.column>v||(b.push(l=new g(u,v,u+m-1,a)),2<m&&(u=u+m-2))}}else for(l=0;l<d.length;l++)for(m=k.getMatchOffsets(d[l],
e),a=0;a<m.length;a++)p=m[a],b.push(new g(l,p.offset,l,p.offset+p.length));if(c){e=d=c.start.column;l=0;for(a=b.length-1;l<a&&b[l].start.column<d&&b[l].start.row==c.start.row;)l++;for(;l<a&&b[a].end.column>e&&b[a].end.row==c.end.row;)a--;b=b.slice(l,a+1);l=0;for(a=b.length;l<a;l++)b[l].start.row+=c.start.row,b[l].end.row+=c.start.row}return b};this.replace=function(b,a){var c=this.$options,d=this.$assembleRegExp(c);if(c.$isMultiLine)return a;if(d){var e=d.exec(b);if(!e||e[0].length!=b.length)return null;
a=b.replace(d,a);if(c.preserveCase){a=a.split("");for(c=Math.min(b.length,b.length);c--;)(d=b[c])&&d.toLowerCase()!=d?a[c]=a[c].toUpperCase():a[c]=a[c].toLowerCase();a=a.join("")}return a}};this.$assembleRegExp=function(b,a){if(b.needle instanceof RegExp)return b.re=b.needle;var c=b.needle;if(!b.needle)return b.re=!1;b.regExp||(c=k.escapeRegExp(c));b.wholeWord&&(c=(/\w/.test(c[0])||b.regExp?"\\b":"")+c+(/\w/.test(c[c.length-1])||b.regExp?"\\b":""));var d=b.caseSensitive?"gm":"gmi";b.$isMultiLine=
!a&&/[\n\r]/.test(c);if(b.$isMultiLine)return b.re=this.$assembleMultilineRegExp(c,d);try{var e=new RegExp(c,d)}catch(m){e=!1}return b.re=e};this.$assembleMultilineRegExp=function(b,a){b=b.replace(/\r\n|\r|\n/g,"$\n^").split("\n");for(var c=[],d=0;d<b.length;d++)try{c.push(new RegExp(b[d],a))}catch(w){return!1}return c};this.$matchIterator=function(b,a){var c=this.$assembleRegExp(a);if(!c)return!1;var d=1==a.backwards,e=0!=a.skipCurrent,g=a.range,p=a.start;p||(p=g?g[d?"end":"start"]:b.selection.getRange());
p.start&&(p=p[e!=d?"end":"start"]);var l=g?g.start.row:0,u=g?g.end.row:b.getLength()-1;e=d?function(b){var c=p.row;if(!k(c,p.column,b)){for(c--;c>=l;c--)if(k(c,Number.MAX_VALUE,b))return;if(0!=a.wrap)for(c=u,l=p.row;c>=l&&!k(c,Number.MAX_VALUE,b);c--);}}:function(b){var c=p.row;if(!k(c,p.column,b)){for(c+=1;c<=u;c++)if(k(c,0,b))return;if(0!=a.wrap)for(c=l,u=p.row;c<=u&&!k(c,0,b);c++);}};if(a.$isMultiLine)var v=c.length,k=function(a,e,f){a=d?a-v+1:a;if(!(0>a)){var l=b.getLine(a),g=l.search(c[0]);if(!(!d&&
g<e||-1===g)){for(var q=1;q<v;q++)if(l=b.getLine(a+q),-1==l.search(c[q]))return;l=l.match(c[v-1])[0].length;if(!(d&&l>e)&&f(a,g,a+v-1,l))return!0}}};else k=d?function(a,d,e){var f=b.getLine(a),l=[],g;for(c.lastIndex=0;g=c.exec(f);){var q=g[0].length;var m=g.index;if(!q){if(m>=f.length)break;c.lastIndex=m+1}if(g.index+q>d)break;l.push(g.index,q)}for(d=l.length-1;0<=d;d-=2)if(f=l[d-1],q=l[d],e(a,f,a,f+q))return!0}:function(a,d,e){var f=b.getLine(a),l;for(c.lastIndex=d;l=c.exec(f);){d=l[0].length;l=
l.index;if(e(a,l,a,l+d))return!0;if(!d&&(c.lastIndex=l+=1,l>=f.length))return!1}};return{forEach:e}}}).call(b.prototype);e.Search=b});ace.define("ace/keyboard/hash_handler",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(b,e,h){function k(a,b){this.platform=b||(d.isMac?"mac":"win");this.commands={};this.commandKeyBinding={};this.addCommands(a);this.$singleCommand=!0}function x(a,b){k.call(this,a,b);this.$singleCommand=!1}var g=b("../lib/keys"),d=b("../lib/useragent"),a=
g.KEY_MODS;x.prototype=k.prototype;(function(){function b(a){return"object"==typeof a&&a.bindKey&&a.bindKey.position||(a.isDefault?-100:0)}this.addCommand=function(a){this.commands[a.name]&&this.removeCommand(a);this.commands[a.name]=a;a.bindKey&&this._buildKeyHash(a)};this.removeCommand=function(a,b){var c=a&&("string"===typeof a?a:a.name);a=this.commands[c];b||delete this.commands[c];b=this.commandKeyBinding;for(var d in b)if(c=b[d],c==a)delete b[d];else if(Array.isArray(c)){var e=c.indexOf(a);
-1!=e&&(c.splice(e,1),1==c.length&&(b[d]=c[0]))}};this.bindKey=function(b,c,d){"object"==typeof b&&b&&(void 0==d&&(d=b.position),b=b[this.platform]);if(b){if("function"==typeof c)return this.addCommand({exec:c,bindKey:b,name:c.name||b});b.split("|").forEach(function(b){var e="";if(-1!=b.indexOf(" ")){var f=b.split(/\s+/);b=f.pop();f.forEach(function(b){b=this.parseKeys(b);e+=(e?" ":"")+(a[b.hashId]+b.key);this._addCommandToBinding(e,"chainKeys")},this);e+=" "}b=this.parseKeys(b);this._addCommandToBinding(e+
(a[b.hashId]+b.key),c,d)},this)}};this._addCommandToBinding=function(a,c,d){var e=this.commandKeyBinding,f;if(c)if(!e[a]||this.$singleCommand)e[a]=c;else{Array.isArray(e[a])?-1!=(f=e[a].indexOf(c))&&e[a].splice(f,1):e[a]=[e[a]];"number"!=typeof d&&(d=b(c));a=e[a];for(f=0;f<a.length&&!(b(a[f])>d);f++);a.splice(f,0,c)}else delete e[a]};this.addCommands=function(a){a&&Object.keys(a).forEach(function(b){var c=a[b];if(c){if("string"===typeof c)return this.bindKey(c,b);"function"===typeof c&&(c={exec:c});
"object"===typeof c&&(c.name||(c.name=b),this.addCommand(c))}},this)};this.removeCommands=function(a){Object.keys(a).forEach(function(b){this.removeCommand(a[b])},this)};this.bindKeys=function(a){Object.keys(a).forEach(function(b){this.bindKey(b,a[b])},this)};this._buildKeyHash=function(a){this.bindKey(a.bindKey,a)};this.parseKeys=function(a){var b=a.toLowerCase().split(/[\-\+]([\-\+])?/).filter(function(a){return a}),c=b.pop(),d=g[c];if(g.FUNCTION_KEYS[d])c=g.FUNCTION_KEYS[d].toLowerCase();else{if(!b.length)return{key:c,
hashId:-1};if(1==b.length&&"shift"==b[0])return{key:c.toUpperCase(),hashId:-1}}d=0;for(var e=b.length;e--;){var f=g.KEY_MODS[b[e]];if(null==f)return"undefined"!=typeof console&&console.error("invalid modifier "+b[e]+" in "+a),!1;d|=f}return{key:c,hashId:d}};this.findKeyCommand=function(b,c){return this.commandKeyBinding[a[b]+c]};this.handleKeyboard=function(b,c,d,e){if(!(0>e)){var f=a[c]+d,g=this.commandKeyBinding[f];b.$keyChain&&(b.$keyChain+=" "+f,g=this.commandKeyBinding[b.$keyChain]||g);if(g&&
("chainKeys"==g||"chainKeys"==g[g.length-1]))return b.$keyChain=b.$keyChain||f,{command:"null"};if(b.$keyChain)if((!c||4==c)&&1==d.length)b.$keyChain=b.$keyChain.slice(0,-f.length-1);else if(-1==c||0<e)b.$keyChain="";return{command:g}}};this.getStatusText=function(a,b){return b.$keyChain||""}}).call(k.prototype);e.HashHandler=k;e.MultiHashHandler=x});ace.define("ace/commands/command_manager","require exports module ace/lib/oop ace/keyboard/hash_handler ace/lib/event_emitter".split(" "),function(b,
e,h){var k=b("../lib/oop"),x=b("../keyboard/hash_handler").MultiHashHandler,g=b("../lib/event_emitter").EventEmitter;b=function(b,a){x.call(this,a,b);this.byName=this.commands;this.setDefaultHandler("exec",function(a){return a.command.exec(a.editor,a.args||{})})};k.inherits(b,x);(function(){k.implement(this,g);this.exec=function(b,a,c){if(Array.isArray(b)){for(var d=b.length;d--;)if(this.exec(b[d],a,c))return!0;return!1}"string"===typeof b&&(b=this.commands[b]);if(!b||a&&a.$readOnly&&!b.readOnly||
0!=this.$checkCommandState&&b.isAvailable&&!b.isAvailable(a))return!1;b={editor:a,command:b,args:c};b.returnValue=this._emit("exec",b);this._signal("afterExec",b);return!1===b.returnValue?!1:!0};this.toggleRecording=function(b){if(!this.$inReplay){b&&b._emit("changeStatus");if(this.recording)return this.macro.pop(),this.off("exec",this.$addCommandToMacro),this.macro.length||(this.macro=this.oldMacro),this.recording=!1;this.$addCommandToMacro||(this.$addCommandToMacro=function(a){this.macro.push([a.command,
a.args])}.bind(this));this.oldMacro=this.macro;this.macro=[];this.on("exec",this.$addCommandToMacro);return this.recording=!0}};this.replay=function(b){if(!this.$inReplay&&this.macro){if(this.recording)return this.toggleRecording(b);try{this.$inReplay=!0,this.macro.forEach(function(a){"string"==typeof a?this.exec(a,b):this.exec(a[0],b,a[1])},this)}finally{this.$inReplay=!1}}};this.trimMacro=function(b){return b.map(function(a){"string"!=typeof a[0]&&(a[0]=a[0].name);a[1]||(a=a[0]);return a})}}).call(b.prototype);
e.CommandManager=b});ace.define("ace/commands/default_commands","require exports module ace/lib/lang ace/config ace/range".split(" "),function(b,e,h){function k(a,b){return{win:a,mac:b}}var x=b("../lib/lang"),g=b("../config"),d=b("../range").Range;e.commands=[{name:"showSettingsMenu",bindKey:k("Ctrl-,","Command-,"),exec:function(a){g.loadModule("ace/ext/settings_menu",function(b){b.init(a);a.showSettingsMenu()})},readOnly:!0},{name:"goToNextError",bindKey:k("Alt-E","F4"),exec:function(a){g.loadModule("./ext/error_marker",
function(b){b.showErrorMarker(a,1)})},scrollIntoView:"animate",readOnly:!0},{name:"goToPreviousError",bindKey:k("Alt-Shift-E","Shift-F4"),exec:function(a){g.loadModule("./ext/error_marker",function(b){b.showErrorMarker(a,-1)})},scrollIntoView:"animate",readOnly:!0},{name:"selectall",description:"Select all",bindKey:k("Ctrl-A","Command-A"),exec:function(a){a.selectAll()},readOnly:!0},{name:"centerselection",description:"Center selection",bindKey:k(null,"Ctrl-L"),exec:function(a){a.centerSelection()},
readOnly:!0},{name:"gotoline",description:"Go to line...",bindKey:k("Ctrl-L","Command-L"),exec:function(a,b){"number"!==typeof b||isNaN(b)||a.gotoLine(b);a.prompt({$type:"gotoLine"})},readOnly:!0},{name:"fold",bindKey:k("Alt-L|Ctrl-F1","Command-Alt-L|Command-F1"),exec:function(a){a.session.toggleFold(!1)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"unfold",bindKey:k("Alt-Shift-L|Ctrl-Shift-F1","Command-Alt-Shift-L|Command-Shift-F1"),exec:function(a){a.session.toggleFold(!0)},
multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleFoldWidget",bindKey:k("F2","F2"),exec:function(a){a.session.toggleFoldWidget()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleParentFoldWidget",bindKey:k("Alt-F2","Alt-F2"),exec:function(a){a.session.toggleFoldWidget(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"foldall",description:"Fold all",bindKey:k(null,"Ctrl-Command-Option-0"),exec:function(a){a.session.foldAll()},
scrollIntoView:"center",readOnly:!0},{name:"foldAllComments",description:"Fold all comments",bindKey:k(null,"Ctrl-Command-Option-0"),exec:function(a){a.session.foldAllComments()},scrollIntoView:"center",readOnly:!0},{name:"foldOther",description:"Fold other",bindKey:k("Alt-0","Command-Option-0"),exec:function(a){a.session.foldAll();a.session.unfold(a.selection.getAllRanges())},scrollIntoView:"center",readOnly:!0},{name:"unfoldall",description:"Unfold all",bindKey:k("Alt-Shift-0","Command-Option-Shift-0"),
exec:function(a){a.session.unfold()},scrollIntoView:"center",readOnly:!0},{name:"findnext",description:"Find next",bindKey:k("Ctrl-K","Command-G"),exec:function(a){a.findNext()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"findprevious",description:"Find previous",bindKey:k("Ctrl-Shift-K","Command-Shift-G"),exec:function(a){a.findPrevious()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"selectOrFindNext",description:"Select or find next",bindKey:k("Alt-K",
"Ctrl-G"),exec:function(a){a.selection.isEmpty()?a.selection.selectWord():a.findNext()},readOnly:!0},{name:"selectOrFindPrevious",description:"Select or find previous",bindKey:k("Alt-Shift-K","Ctrl-Shift-G"),exec:function(a){a.selection.isEmpty()?a.selection.selectWord():a.findPrevious()},readOnly:!0},{name:"find",description:"Find",bindKey:k("Ctrl-F","Command-F"),exec:function(a){g.loadModule("ace/ext/searchbox",function(b){b.Search(a)})},readOnly:!0},{name:"overwrite",description:"Overwrite",bindKey:"Insert",
exec:function(a){a.toggleOverwrite()},readOnly:!0},{name:"selecttostart",description:"Select to start",bindKey:k("Ctrl-Shift-Home","Command-Shift-Home|Command-Shift-Up"),exec:function(a){a.getSelection().selectFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotostart",description:"Go to start",bindKey:k("Ctrl-Home","Command-Home|Command-Up"),exec:function(a){a.navigateFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",
aceCommandGroup:"fileJump"},{name:"selectup",description:"Select up",bindKey:k("Shift-Up","Shift-Up|Ctrl-Shift-P"),exec:function(a){a.getSelection().selectUp()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golineup",description:"Go line up",bindKey:k("Up","Up|Ctrl-P"),exec:function(a,b){a.navigateUp(b.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttoend",description:"Select to end",bindKey:k("Ctrl-Shift-End","Command-Shift-End|Command-Shift-Down"),
exec:function(a){a.getSelection().selectFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotoend",description:"Go to end",bindKey:k("Ctrl-End","Command-End|Command-Down"),exec:function(a){a.navigateFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectdown",description:"Select down",bindKey:k("Shift-Down","Shift-Down|Ctrl-Shift-N"),exec:function(a){a.getSelection().selectDown()},
multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golinedown",description:"Go line down",bindKey:k("Down","Down|Ctrl-N"),exec:function(a,b){a.navigateDown(b.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordleft",description:"Select word left",bindKey:k("Ctrl-Shift-Left","Option-Shift-Left"),exec:function(a){a.getSelection().selectWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordleft",description:"Go to word left",
bindKey:k("Ctrl-Left","Option-Left"),exec:function(a){a.navigateWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolinestart",description:"Select to line start",bindKey:k("Alt-Shift-Left","Command-Shift-Left|Ctrl-Shift-A"),exec:function(a){a.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolinestart",description:"Go to line start",bindKey:k("Alt-Left|Home","Command-Left|Home|Ctrl-A"),exec:function(a){a.navigateLineStart()},
multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectleft",description:"Select left",bindKey:k("Shift-Left","Shift-Left|Ctrl-Shift-B"),exec:function(a){a.getSelection().selectLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoleft",description:"Go to left",bindKey:k("Left","Left|Ctrl-B"),exec:function(a,b){a.navigateLeft(b.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordright",description:"Select word right",
bindKey:k("Ctrl-Shift-Right","Option-Shift-Right"),exec:function(a){a.getSelection().selectWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordright",description:"Go to word right",bindKey:k("Ctrl-Right","Option-Right"),exec:function(a){a.navigateWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolineend",description:"Select to line end",bindKey:k("Alt-Shift-Right","Command-Shift-Right|Shift-End|Ctrl-Shift-E"),exec:function(a){a.getSelection().selectLineEnd()},
multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolineend",description:"Go to line end",bindKey:k("Alt-Right|End","Command-Right|End|Ctrl-E"),exec:function(a){a.navigateLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectright",description:"Select right",bindKey:k("Shift-Right","Shift-Right"),exec:function(a){a.getSelection().selectRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoright",description:"Go to right",
bindKey:k("Right","Right|Ctrl-F"),exec:function(a,b){a.navigateRight(b.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectpagedown",description:"Select page down",bindKey:"Shift-PageDown",exec:function(a){a.selectPageDown()},readOnly:!0},{name:"pagedown",description:"Page down",bindKey:k(null,"Option-PageDown"),exec:function(a){a.scrollPageDown()},readOnly:!0},{name:"gotopagedown",description:"Go to page down",bindKey:k("PageDown","PageDown|Ctrl-V"),exec:function(a){a.gotoPageDown()},
readOnly:!0},{name:"selectpageup",description:"Select page up",bindKey:"Shift-PageUp",exec:function(a){a.selectPageUp()},readOnly:!0},{name:"pageup",description:"Page up",bindKey:k(null,"Option-PageUp"),exec:function(a){a.scrollPageUp()},readOnly:!0},{name:"gotopageup",description:"Go to page up",bindKey:"PageUp",exec:function(a){a.gotoPageUp()},readOnly:!0},{name:"scrollup",description:"Scroll up",bindKey:k("Ctrl-Up",null),exec:function(a){a.renderer.scrollBy(0,-2*a.renderer.layerConfig.lineHeight)},
readOnly:!0},{name:"scrolldown",description:"Scroll down",bindKey:k("Ctrl-Down",null),exec:function(a){a.renderer.scrollBy(0,2*a.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"selectlinestart",description:"Select line start",bindKey:"Shift-Home",exec:function(a){a.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectlineend",description:"Select line end",bindKey:"Shift-End",exec:function(a){a.getSelection().selectLineEnd()},multiSelectAction:"forEach",
scrollIntoView:"cursor",readOnly:!0},{name:"togglerecording",description:"Toggle recording",bindKey:k("Ctrl-Alt-E","Command-Option-E"),exec:function(a){a.commands.toggleRecording(a)},readOnly:!0},{name:"replaymacro",description:"Replay macro",bindKey:k("Ctrl-Shift-E","Command-Shift-E"),exec:function(a){a.commands.replay(a)},readOnly:!0},{name:"jumptomatching",description:"Jump to matching",bindKey:k("Ctrl-\\|Ctrl-P","Command-\\"),exec:function(a){a.jumpToMatching()},multiSelectAction:"forEach",scrollIntoView:"animate",
readOnly:!0},{name:"selecttomatching",description:"Select to matching",bindKey:k("Ctrl-Shift-\\|Ctrl-Shift-P","Command-Shift-\\"),exec:function(a){a.jumpToMatching(!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"expandToMatching",description:"Expand to matching",bindKey:k("Ctrl-Shift-M","Ctrl-Shift-M"),exec:function(a){a.jumpToMatching(!0,!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"passKeysToBrowser",description:"Pass keys to browser",
bindKey:k(null,null),exec:function(){},passEvent:!0,readOnly:!0},{name:"copy",description:"Copy",exec:function(a){},readOnly:!0},{name:"cut",description:"Cut",exec:function(a){var b=a.$copyWithEmptySelection&&a.selection.isEmpty()?a.selection.getLineRange():a.selection.getRange();a._emit("cut",b);b.isEmpty()||a.session.remove(b);a.clearSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"paste",description:"Paste",exec:function(a,b){a.$handlePaste(b)},scrollIntoView:"cursor"},
{name:"removeline",description:"Remove line",bindKey:k("Ctrl-D","Command-D"),exec:function(a){a.removeLines()},scrollIntoView:"cursor",multiSelectAction:"forEachLine"},{name:"duplicateSelection",description:"Duplicate selection",bindKey:k("Ctrl-Shift-D","Command-Shift-D"),exec:function(a){a.duplicateSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"sortlines",description:"Sort lines",bindKey:k("Ctrl-Alt-S","Command-Alt-S"),exec:function(a){a.sortLines()},scrollIntoView:"selection",
multiSelectAction:"forEachLine"},{name:"togglecomment",description:"Toggle comment",bindKey:k("Ctrl-/","Command-/"),exec:function(a){a.toggleCommentLines()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"toggleBlockComment",description:"Toggle block comment",bindKey:k("Ctrl-Shift-/","Command-Shift-/"),exec:function(a){a.toggleBlockComment()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"modifyNumberUp",description:"Modify number up",bindKey:k("Ctrl-Shift-Up",
"Alt-Shift-Up"),exec:function(a){a.modifyNumber(1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"modifyNumberDown",description:"Modify number down",bindKey:k("Ctrl-Shift-Down","Alt-Shift-Down"),exec:function(a){a.modifyNumber(-1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"replace",description:"Replace",bindKey:k("Ctrl-H","Command-Option-F"),exec:function(a){g.loadModule("ace/ext/searchbox",function(b){b.Search(a,!0)})}},{name:"undo",description:"Undo",bindKey:k("Ctrl-Z",
"Command-Z"),exec:function(a){a.undo()}},{name:"redo",description:"Redo",bindKey:k("Ctrl-Shift-Z|Ctrl-Y","Command-Shift-Z|Command-Y"),exec:function(a){a.redo()}},{name:"copylinesup",description:"Copy lines up",bindKey:k("Alt-Shift-Up","Command-Option-Up"),exec:function(a){a.copyLinesUp()},scrollIntoView:"cursor"},{name:"movelinesup",description:"Move lines up",bindKey:k("Alt-Up","Option-Up"),exec:function(a){a.moveLinesUp()},scrollIntoView:"cursor"},{name:"copylinesdown",description:"Copy lines down",
bindKey:k("Alt-Shift-Down","Command-Option-Down"),exec:function(a){a.copyLinesDown()},scrollIntoView:"cursor"},{name:"movelinesdown",description:"Move lines down",bindKey:k("Alt-Down","Option-Down"),exec:function(a){a.moveLinesDown()},scrollIntoView:"cursor"},{name:"del",description:"Delete",bindKey:k("Delete","Delete|Ctrl-D|Shift-Delete"),exec:function(a){a.remove("right")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"backspace",description:"Backspace",bindKey:k("Shift-Backspace|Backspace",
"Ctrl-Backspace|Shift-Backspace|Backspace|Ctrl-H"),exec:function(a){a.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"cut_or_delete",description:"Cut or delete",bindKey:k("Shift-Delete",null),exec:function(a){if(a.selection.isEmpty())a.remove("left");else return!1},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestart",description:"Remove to line start",bindKey:k("Alt-Backspace","Command-Backspace"),exec:function(a){a.removeToLineStart()},multiSelectAction:"forEach",
scrollIntoView:"cursor"},{name:"removetolineend",description:"Remove to line end",bindKey:k("Alt-Delete","Ctrl-K|Command-Delete"),exec:function(a){a.removeToLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestarthard",description:"Remove to line start hard",bindKey:k("Ctrl-Shift-Backspace",null),exec:function(a){var b=a.selection.getRange();b.start.column=0;a.session.remove(b)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineendhard",description:"Remove to line end hard",
bindKey:k("Ctrl-Shift-Delete",null),exec:function(a){var b=a.selection.getRange();b.end.column=Number.MAX_VALUE;a.session.remove(b)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordleft",description:"Remove word left",bindKey:k("Ctrl-Backspace","Alt-Backspace|Ctrl-Alt-Backspace"),exec:function(a){a.removeWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordright",description:"Remove word right",bindKey:k("Ctrl-Delete","Alt-Delete"),exec:function(a){a.removeWordRight()},
multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"outdent",description:"Outdent",bindKey:k("Shift-Tab","Shift-Tab"),exec:function(a){a.blockOutdent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"indent",description:"Indent",bindKey:k("Tab","Tab"),exec:function(a){a.indent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"blockoutdent",description:"Block outdent",bindKey:k("Ctrl-[","Ctrl-["),exec:function(a){a.blockOutdent()},multiSelectAction:"forEachLine",
scrollIntoView:"selectionPart"},{name:"blockindent",description:"Block indent",bindKey:k("Ctrl-]","Ctrl-]"),exec:function(a){a.blockIndent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"insertstring",description:"Insert string",exec:function(a,b){a.insert(b)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"inserttext",description:"Insert text",exec:function(a,b){a.insert(x.stringRepeat(b.text||"",b.times||1))},multiSelectAction:"forEach",scrollIntoView:"cursor"},
{name:"splitline",description:"Split line",bindKey:k(null,"Ctrl-O"),exec:function(a){a.splitLine()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"transposeletters",description:"Transpose letters",bindKey:k("Alt-Shift-X","Ctrl-T"),exec:function(a){a.transposeLetters()},multiSelectAction:function(a){a.transposeSelections(1)},scrollIntoView:"cursor"},{name:"touppercase",description:"To uppercase",bindKey:k("Ctrl-U","Ctrl-U"),exec:function(a){a.toUpperCase()},multiSelectAction:"forEach",
scrollIntoView:"cursor"},{name:"tolowercase",description:"To lowercase",bindKey:k("Ctrl-Shift-U","Ctrl-Shift-U"),exec:function(a){a.toLowerCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"autoindent",description:"Auto Indent",bindKey:k(null,null),exec:function(a){a.autoIndent()},multiSelectAction:"forEachLine",scrollIntoView:"animate"},{name:"expandtoline",description:"Expand to line",bindKey:k("Ctrl-Shift-L","Command-Shift-L"),exec:function(a){var b=a.selection.getRange();b.start.column=
b.end.column=0;b.end.row++;a.selection.setRange(b,!1)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"joinlines",description:"Join lines",bindKey:k(null,null),exec:function(a){var b=a.selection.isBackwards(),e=b?a.selection.getSelectionLead():a.selection.getSelectionAnchor();b=b?a.selection.getSelectionAnchor():a.selection.getSelectionLead();for(var g=a.session.doc.getLine(e.row).length,m=a.session.doc.getTextRange(a.selection.getRange()).replace(/\n\s*/," ").length,p=a.session.doc.getLine(e.row),
l=e.row+1;l<=b.row+1;l++){var u=x.stringTrimLeft(x.stringTrimRight(a.session.doc.getLine(l)));0!==u.length&&(u=" "+u);p+=u}b.row+1<a.session.doc.getLength()-1&&(p+=a.session.doc.getNewLineCharacter());a.clearSelection();a.session.doc.replace(new d(e.row,0,b.row+2,0),p);0<m?(a.selection.moveCursorTo(e.row,e.column),a.selection.selectTo(e.row,e.column+m)):(g=a.session.doc.getLine(e.row).length>g?g+1:g,a.selection.moveCursorTo(e.row,g))},multiSelectAction:"forEach",readOnly:!0},{name:"invertSelection",
description:"Invert selection",bindKey:k(null,null),exec:function(a){var b=a.session.doc.getLength()-1,e=a.session.doc.getLine(b).length,g=a.selection.rangeList.ranges,m=[];1>g.length&&(g=[a.selection.getRange()]);for(var p=0;p<g.length;p++)p!=g.length-1||g[p].end.row===b&&g[p].end.column===e||m.push(new d(g[p].end.row,g[p].end.column,b,e)),0===p?(0!==g[p].start.row||0!==g[p].start.column)&&m.push(new d(0,0,g[p].start.row,g[p].start.column)):m.push(new d(g[p-1].end.row,g[p-1].end.column,g[p].start.row,
g[p].start.column));a.exitMultiSelectMode();a.clearSelection();for(p=0;p<m.length;p++)a.selection.addRange(m[p],!1)},readOnly:!0,scrollIntoView:"none"},{name:"addLineAfter",exec:function(a){a.selection.clearSelection();a.navigateLineEnd();a.insert("\n")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"addLineBefore",exec:function(a){a.selection.clearSelection();var b=a.getCursorPosition();a.selection.moveTo(b.row-1,Number.MAX_VALUE);a.insert("\n");0===b.row&&a.navigateUp()},multiSelectAction:"forEach",
scrollIntoView:"cursor"},{name:"openCommandPallete",description:"Open command pallete",bindKey:k("F1","F1"),exec:function(a){a.prompt({$type:"commands"})},readOnly:!0},{name:"modeSelect",description:"Change language mode...",bindKey:k(null,null),exec:function(a){a.prompt({$type:"modes"})},readOnly:!0}];for(b=1;9>b;b++)e.commands.push({name:"foldToLevel"+b,description:"Fold To Level "+b,level:b,exec:function(a){a.session.foldToLevel(this.level)},scrollIntoView:"center",readOnly:!0})});ace.define("ace/editor",
"require exports module ace/lib/fixoldbrowsers ace/lib/oop ace/lib/dom ace/lib/lang ace/lib/useragent ace/keyboard/textinput ace/mouse/mouse_handler ace/mouse/fold_handler ace/keyboard/keybinding ace/edit_session ace/search ace/range ace/lib/event_emitter ace/commands/command_manager ace/commands/default_commands ace/config ace/token_iterator ace/clipboard".split(" "),function(b,e,h){b("./lib/fixoldbrowsers");var k=b("./lib/oop"),x=b("./lib/dom"),g=b("./lib/lang"),d=b("./lib/useragent"),a=b("./keyboard/textinput").TextInput,
c=b("./mouse/mouse_handler").MouseHandler,f=b("./mouse/fold_handler").FoldHandler,w=b("./keyboard/keybinding").KeyBinding,m=b("./edit_session").EditSession,p=b("./search").Search,l=b("./range").Range,u=b("./lib/event_emitter").EventEmitter,v=b("./commands/command_manager").CommandManager,A=b("./commands/default_commands").commands,q=b("./config"),n=b("./token_iterator").TokenIterator,r=b("./clipboard"),t=function(b,e,l){this.$toDestroy=[];this.container=b.getContainerElement();this.renderer=b;this.id=
"editor"+ ++t.$uid;this.commands=new v(d.isMac?"mac":"win",A);"object"==typeof document&&(this.textInput=new a(b.getTextAreaContainer(),this),this.renderer.textarea=this.textInput.getElement(),this.$mouseHandler=new c(this),new f(this));this.keyBinding=new w(this);this.$search=(new p).set({wrap:!0});this.$historyTracker=this.$historyTracker.bind(this);this.commands.on("exec",this.$historyTracker);this.$initOperationListeners();this._$emitInputEvent=g.delayedCall(function(){this._signal("input",{});
this.session&&this.session.bgTokenizer&&this.session.bgTokenizer.scheduleStart()}.bind(this));this.on("change",function(a,b){b._$emitInputEvent.schedule(31)});this.setSession(e||l&&l.session||new m(""));q.resetOptions(this);l&&this.setOptions(l);q._signal("editor",this)};t.$uid=0;(function(){k.implement(this,u);this.$initOperationListeners=function(){this.commands.on("exec",this.startOperation.bind(this),!0);this.commands.on("afterExec",this.endOperation.bind(this),!0);this.$opResetTimer=g.delayedCall(this.endOperation.bind(this,
!0));this.on("change",function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel);this.curOp.docChanged=!0}.bind(this),!0);this.on("changeSelection",function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel);this.curOp.selectionChanged=!0}.bind(this),!0)};this.curOp=null;this.prevOp={};this.startOperation=function(a){if(this.curOp){if(!a||this.curOp.command)return;this.prevOp=this.curOp}a||(this.previousCommand=null,a={});this.$opResetTimer.schedule();
this.curOp=this.session.curOp={command:a.command||{},args:a.args,scrollTop:this.renderer.scrollTop};this.curOp.selectionBefore=this.selection.toJSON()};this.endOperation=function(a){if(this.curOp&&this.session){if(a&&!1===a.returnValue||!this.session)return this.curOp=null;if(1!=a||!this.curOp.command||"mouse"!=this.curOp.command.name)if(this._signal("beforeEndOperation"),this.curOp){if(a=(a=this.curOp.command)&&a.scrollIntoView){switch(a){case "center-animate":a="animate";case "center":this.renderer.scrollCursorIntoView(null,
.5);break;case "animate":case "cursor":this.renderer.scrollCursorIntoView();break;case "selectionPart":var b=this.selection.getRange(),c=this.renderer.layerConfig;(b.start.row>=c.lastRow||b.end.row<=c.firstRow)&&this.renderer.scrollSelectionIntoView(this.selection.anchor,this.selection.lead)}"animate"==a&&this.renderer.animateScrolling(this.curOp.scrollTop)}a=this.selection.toJSON();this.curOp.selectionAfter=a;this.$lastSel=this.selection.toJSON();this.session.getUndoManager().addSelection(a);this.prevOp=
this.curOp;this.curOp=null}}};this.$mergeableCommands=["backspace","del","insertstring"];this.$historyTracker=function(a){if(this.$mergeUndoDeltas){var b=this.prevOp,c=this.$mergeableCommands,d=b.command&&a.command.name==b.command.name;if("insertstring"==a.command.name){var e=a.args;void 0===this.mergeNextCommand&&(this.mergeNextCommand=!0);d=d&&this.mergeNextCommand&&(!/\s/.test(e)||/\s/.test(b.args));this.mergeNextCommand=!0}else d=d&&-1!==c.indexOf(a.command.name);"always"!=this.$mergeUndoDeltas&&
2E3<Date.now()-this.sequenceStartTime&&(d=!1);d?this.session.mergeUndoDeltas=!0:-1!==c.indexOf(a.command.name)&&(this.sequenceStartTime=Date.now())}};this.setKeyboardHandler=function(a,b){if(a&&"string"===typeof a&&"ace"!=a){this.$keybindingId=a;var c=this;q.loadModule(["keybinding",a],function(d){c.$keybindingId==a&&c.keyBinding.setKeyboardHandler(d&&d.handler);b&&b()})}else this.$keybindingId=null,this.keyBinding.setKeyboardHandler(a),b&&b()};this.getKeyboardHandler=function(){return this.keyBinding.getKeyboardHandler()};
this.setSession=function(a){if(this.session!=a){this.curOp&&this.endOperation();this.curOp={};var b=this.session;if(b){this.session.off("change",this.$onDocumentChange);this.session.off("changeMode",this.$onChangeMode);this.session.off("tokenizerUpdate",this.$onTokenizerUpdate);this.session.off("changeTabSize",this.$onChangeTabSize);this.session.off("changeWrapLimit",this.$onChangeWrapLimit);this.session.off("changeWrapMode",this.$onChangeWrapMode);this.session.off("changeFold",this.$onChangeFold);
this.session.off("changeFrontMarker",this.$onChangeFrontMarker);this.session.off("changeBackMarker",this.$onChangeBackMarker);this.session.off("changeBreakpoint",this.$onChangeBreakpoint);this.session.off("changeAnnotation",this.$onChangeAnnotation);this.session.off("changeOverwrite",this.$onCursorChange);this.session.off("changeScrollTop",this.$onScrollTopChange);this.session.off("changeScrollLeft",this.$onScrollLeftChange);var c=this.session.getSelection();c.off("changeCursor",this.$onCursorChange);
c.off("changeSelection",this.$onSelectionChange)}(this.session=a)?(this.$onDocumentChange=this.onDocumentChange.bind(this),a.on("change",this.$onDocumentChange),this.renderer.setSession(a),this.$onChangeMode=this.onChangeMode.bind(this),a.on("changeMode",this.$onChangeMode),this.$onTokenizerUpdate=this.onTokenizerUpdate.bind(this),a.on("tokenizerUpdate",this.$onTokenizerUpdate),this.$onChangeTabSize=this.renderer.onChangeTabSize.bind(this.renderer),a.on("changeTabSize",this.$onChangeTabSize),this.$onChangeWrapLimit=
this.onChangeWrapLimit.bind(this),a.on("changeWrapLimit",this.$onChangeWrapLimit),this.$onChangeWrapMode=this.onChangeWrapMode.bind(this),a.on("changeWrapMode",this.$onChangeWrapMode),this.$onChangeFold=this.onChangeFold.bind(this),a.on("changeFold",this.$onChangeFold),this.$onChangeFrontMarker=this.onChangeFrontMarker.bind(this),this.session.on("changeFrontMarker",this.$onChangeFrontMarker),this.$onChangeBackMarker=this.onChangeBackMarker.bind(this),this.session.on("changeBackMarker",this.$onChangeBackMarker),
this.$onChangeBreakpoint=this.onChangeBreakpoint.bind(this),this.session.on("changeBreakpoint",this.$onChangeBreakpoint),this.$onChangeAnnotation=this.onChangeAnnotation.bind(this),this.session.on("changeAnnotation",this.$onChangeAnnotation),this.$onCursorChange=this.onCursorChange.bind(this),this.session.on("changeOverwrite",this.$onCursorChange),this.$onScrollTopChange=this.onScrollTopChange.bind(this),this.session.on("changeScrollTop",this.$onScrollTopChange),this.$onScrollLeftChange=this.onScrollLeftChange.bind(this),
this.session.on("changeScrollLeft",this.$onScrollLeftChange),this.selection=a.getSelection(),this.selection.on("changeCursor",this.$onCursorChange),this.$onSelectionChange=this.onSelectionChange.bind(this),this.selection.on("changeSelection",this.$onSelectionChange),this.onChangeMode(),this.onCursorChange(),this.onScrollTopChange(),this.onScrollLeftChange(),this.onSelectionChange(),this.onChangeFrontMarker(),this.onChangeBackMarker(),this.onChangeBreakpoint(),this.onChangeAnnotation(),this.session.getUseWrapMode()&&
this.renderer.adjustWrapLimit(),this.renderer.updateFull()):(this.selection=null,this.renderer.setSession(a));this._signal("changeSession",{session:a,oldSession:b});this.curOp=null;b&&b._signal("changeEditor",{oldEditor:this});a&&a._signal("changeEditor",{editor:this});a&&a.bgTokenizer&&a.bgTokenizer.scheduleStart()}};this.getSession=function(){return this.session};this.setValue=function(a,b){this.session.doc.setValue(a);b?1==b?this.navigateFileEnd():-1==b&&this.navigateFileStart():this.selectAll();
return a};this.getValue=function(){return this.session.getValue()};this.getSelection=function(){return this.selection};this.resize=function(a){this.renderer.onResize(a)};this.setTheme=function(a,b){this.renderer.setTheme(a,b)};this.getTheme=function(){return this.renderer.getTheme()};this.setStyle=function(a){this.renderer.setStyle(a)};this.unsetStyle=function(a){this.renderer.unsetStyle(a)};this.getFontSize=function(){return this.getOption("fontSize")||x.computedStyle(this.container).fontSize};this.setFontSize=
function(a){this.setOption("fontSize",a)};this.$highlightBrackets=function(){if(!this.$highlightPending){var a=this;this.$highlightPending=!0;setTimeout(function(){a.$highlightPending=!1;var b=a.session;if(b&&b.bgTokenizer){b.$bracketHighlight&&(b.$bracketHighlight.markerIds.forEach(function(a){b.removeMarker(a)}),b.$bracketHighlight=null);var c=b.getMatchingBracketRanges(a.getCursorPosition());!c&&b.$mode.getMatching&&(c=b.$mode.getMatching(a.session));if(c){var d="ace_bracket";Array.isArray(c)?
1==c.length&&(d="ace_error_bracket"):c=[c];2==c.length&&(0==l.comparePoints(c[0].end,c[1].start)?c=[l.fromPoints(c[0].start,c[1].end)]:0==l.comparePoints(c[0].start,c[1].end)&&(c=[l.fromPoints(c[1].start,c[0].end)]));b.$bracketHighlight={ranges:c,markerIds:c.map(function(a){return b.addMarker(a,d,"text")})}}}},50)}};this.$highlightTags=function(){if(!this.$highlightTagPending){var a=this;this.$highlightTagPending=!0;setTimeout(function(){a.$highlightTagPending=!1;var b=a.session;if(b&&b.bgTokenizer){var c=
a.getCursorPosition(),d=new n(a.session,c.row,c.column);if((c=d.getCurrentToken())&&/\b(?:tag-open|tag-name)/.test(c.type)){if(-1!==c.type.indexOf("tag-open")&&(c=d.stepForward(),!c))return;var e=c.value,f=c.value,g=0,q=d.stepBackward();if("<"===q.value){do if(q=c,c=d.stepForward())-1!==c.type.indexOf("tag-name")?(f=c.value,e===f&&("<"===q.value?g++:"</"===q.value&&g--)):e===f&&"/>"===c.value&&g--;while(c&&0<=g)}else{do if(c=q,q=d.stepBackward(),c)if(-1!==c.type.indexOf("tag-name"))e===c.value&&("<"===
q.value?g++:"</"===q.value&&g--);else if("/>"===c.value){f=0;for(var v=q;v;){if(-1!==v.type.indexOf("tag-name")&&v.value===e){g--;break}else if("<"===v.value)break;v=d.stepBackward();f++}for(v=0;v<f;v++)d.stepForward()}while(q&&0>=g);d.stepForward()}c?(e=d.getCurrentTokenRow(),d=d.getCurrentTokenColumn(),c=new l(e,d,e,d+c.value.length),d=b.$backMarkers[b.$tagHighlight],b.$tagHighlight&&void 0!=d&&0!==c.compareRange(d.range)&&(b.removeMarker(b.$tagHighlight),b.$tagHighlight=null),b.$tagHighlight||
(b.$tagHighlight=b.addMarker(c,"ace_bracket","text"))):(b.removeMarker(b.$tagHighlight),b.$tagHighlight=null)}else b.removeMarker(b.$tagHighlight),b.$tagHighlight=null}},50)}};this.focus=function(){var a=this;setTimeout(function(){a.isFocused()||a.textInput.focus()});this.textInput.focus()};this.isFocused=function(){return this.textInput.isFocused()};this.blur=function(){this.textInput.blur()};this.onFocus=function(a){this.$isFocused||(this.$isFocused=!0,this.renderer.showCursor(),this.renderer.visualizeFocus(),
this._emit("focus",a))};this.onBlur=function(a){this.$isFocused&&(this.$isFocused=!1,this.renderer.hideCursor(),this.renderer.visualizeBlur(),this._emit("blur",a))};this.$cursorChange=function(){this.renderer.updateCursor();this.$highlightBrackets();this.$highlightTags();this.$updateHighlightActiveLine()};this.onDocumentChange=function(a){this.renderer.updateLines(a.start.row,a.start.row==a.end.row?a.end.row:Infinity,this.session.$useWrapMode);this._signal("change",a);this.$cursorChange()};this.onTokenizerUpdate=
function(a){a=a.data;this.renderer.updateLines(a.first,a.last)};this.onScrollTopChange=function(){this.renderer.scrollToY(this.session.getScrollTop())};this.onScrollLeftChange=function(){this.renderer.scrollToX(this.session.getScrollLeft())};this.onCursorChange=function(){this.$cursorChange();this._signal("changeSelection")};this.$updateHighlightActiveLine=function(){var a=this.getSession(),b;this.$highlightActiveLine&&("line"==this.$selectionStyle&&this.selection.isMultiLine()||(b=this.getCursorPosition()),
this.renderer.theme&&this.renderer.theme.$selectionColorConflict&&!this.selection.isEmpty()&&(b=!1),!this.renderer.$maxLines||1!==this.session.getLength()||1<this.renderer.$minLines||(b=!1));a.$highlightLineMarker&&!b?(a.removeMarker(a.$highlightLineMarker.id),a.$highlightLineMarker=null):!a.$highlightLineMarker&&b?(b=new l(b.row,b.column,b.row,Infinity),b.id=a.addMarker(b,"ace_active-line","screenLine"),a.$highlightLineMarker=b):b&&(a.$highlightLineMarker.start.row=b.row,a.$highlightLineMarker.end.row=
b.row,a.$highlightLineMarker.start.column=b.column,a._signal("changeBackMarker"))};this.onSelectionChange=function(a){a=this.session;a.$selectionMarker&&a.removeMarker(a.$selectionMarker);a.$selectionMarker=null;if(this.selection.isEmpty())this.$updateHighlightActiveLine();else{var b=this.selection.getRange(),c=this.getSelectionStyle();a.$selectionMarker=a.addMarker(b,"ace_selection",c)}a=this.$highlightSelectedWord&&this.$getSelectionHighLightRegexp();this.session.highlight(a);this._signal("changeSelection")};
this.$getSelectionHighLightRegexp=function(){var a=this.session,b=this.getSelectionRange();if(!b.isEmpty()&&!b.isMultiLine()){var c=b.start.column,d=b.end.column;a=a.getLine(b.start.row);b=a.substring(c,d);if(!(5E3<b.length)&&/[\w\d]/.test(b)&&(b=this.$search.$assembleRegExp({wholeWord:!0,caseSensitive:!0,needle:b}),c=a.substring(c-1,d+1),b.test(c)))return b}};this.onChangeFrontMarker=function(){this.renderer.updateFrontMarkers()};this.onChangeBackMarker=function(){this.renderer.updateBackMarkers()};
this.onChangeBreakpoint=function(){this.renderer.updateBreakpoints()};this.onChangeAnnotation=function(){this.renderer.setAnnotations(this.session.getAnnotations())};this.onChangeMode=function(a){this.renderer.updateText();this._emit("changeMode",a)};this.onChangeWrapLimit=function(){this.renderer.updateFull()};this.onChangeWrapMode=function(){this.renderer.onResize(!0)};this.onChangeFold=function(){this.$updateHighlightActiveLine();this.renderer.updateFull()};this.getSelectedText=function(){return this.session.getTextRange(this.getSelectionRange())};
this.getCopyText=function(){var a=this.getSelectedText(),b=this.session.doc.getNewLineCharacter(),c=!1;if(!a&&this.$copyWithEmptySelection){c=!0;for(var d=this.selection.getAllRanges(),e=0;e<d.length;e++){var f=d[e];e&&d[e-1].start.row==f.start.row||(a+=this.session.getLine(f.start.row)+b)}}a={text:a};this._signal("copy",a);r.lineMode=c?a.text:"";return a.text};this.onCopy=function(){this.commands.exec("copy",this)};this.onCut=function(){this.commands.exec("cut",this)};this.onPaste=function(a,b){this.commands.exec("paste",
this,{text:a,event:b})};this.$handlePaste=function(a){"string"==typeof a&&(a={text:a});this._signal("paste",a);var b=a.text;a=b==r.lineMode;var c=this.session;if(!this.inMultiSelectMode||this.inVirtualSelectionMode)a?c.insert({row:this.selection.lead.row,column:0},b):this.insert(b);else if(a)this.selection.rangeList.ranges.forEach(function(a){c.insert({row:a.start.row,column:0},b)});else{a=b.split(/\r\n|\r|\n/);var d=this.selection.rangeList.ranges,e=2==a.length&&(!a[0]||!a[1]);if(a.length!=d.length||
e)return this.commands.exec("insertstring",this,b);for(e=d.length;e--;){var f=d[e];f.isEmpty()||c.remove(f);c.insert(f.start,a[e])}}};this.execCommand=function(a,b){return this.commands.exec(a,this,b)};this.insert=function(a,b){var c=this.session,d=c.getMode(),e=this.getCursorPosition();if(this.getBehavioursEnabled()&&!b){var f=d.transformAction(c.getState(e.row),"insertion",this,c,a);f&&(a===f.text||this.inVirtualSelectionMode||(this.mergeNextCommand=this.session.mergeUndoDeltas=!1),a=f.text)}"\t"==
a&&(a=this.session.getTabString());this.selection.isEmpty()?this.session.getOverwrite()&&-1==a.indexOf("\n")&&(b=new l.fromPoints(e,e),b.end.column+=a.length,this.session.remove(b)):(b=this.getSelectionRange(),e=this.session.remove(b),this.clearSelection());if("\n"==a||"\r\n"==a){var g=c.getLine(e.row);e.column>g.search(/\S|$/)&&(b=g.substr(e.column).search(/\S|$/),c.doc.removeInLine(e.row,e.column,e.column+b))}this.clearSelection();var q=e.column;b=c.getState(e.row);g=c.getLine(e.row);var n=d.checkOutdent(b,
g,a);c.insert(e,a);f&&f.selection&&(2==f.selection.length?this.selection.setSelectionRange(new l(e.row,q+f.selection[0],e.row,q+f.selection[1])):this.selection.setSelectionRange(new l(e.row+f.selection[0],f.selection[1],e.row+f.selection[2],f.selection[3])));this.$enableAutoIndent&&(c.getDocument().isNewLine(a)&&(a=d.getNextLineIndent(b,g.slice(0,e.column),c.getTabString()),c.insert({row:e.row+1,column:0},a)),n&&d.autoOutdent(b,c,e.row))};this.autoIndent=function(){var a=this.session,b=a.getMode();
if(this.selection.isEmpty()){var c=0;var d=a.doc.getLength()-1}else d=this.getSelectionRange(),c=d.start.row,d=d.end.row;var e="";var f="";for(var g,q=a.getTabString();c<=d;c++)0<c&&(e=a.getState(c-1),f=a.getLine(c-1),f=b.getNextLineIndent(e,f,q)),g=a.getLine(c),g=b.$getIndent(g),f!==g&&(0<g.length&&(g=new l(c,0,c,g.length),a.remove(g)),0<f.length&&a.insert({row:c,column:0},f)),b.autoOutdent(e,a,c)};this.onTextInput=function(a,b){if(!b)return this.keyBinding.onTextInput(a);this.startOperation({command:{name:"insertstring"}});
a=this.applyComposition.bind(this,a,b);this.selection.rangeCount?this.forEachSelection(a):a();this.endOperation()};this.applyComposition=function(a,b){if(b.extendLeft||b.extendRight){var c=this.selection.getRange();c.start.column-=b.extendLeft;c.end.column+=b.extendRight;0>c.start.column&&(c.start.row--,c.start.column+=this.session.getLine(c.start.row).length+1);this.selection.setRange(c);a||c.isEmpty()||this.remove()}!a&&this.selection.isEmpty()||this.insert(a,!0);if(b.restoreStart||b.restoreEnd)c=
this.selection.getRange(),c.start.column-=b.restoreStart,c.end.column-=b.restoreEnd,this.selection.setRange(c)};this.onCommandKey=function(a,b,c){return this.keyBinding.onCommandKey(a,b,c)};this.setOverwrite=function(a){this.session.setOverwrite(a)};this.getOverwrite=function(){return this.session.getOverwrite()};this.toggleOverwrite=function(){this.session.toggleOverwrite()};this.setScrollSpeed=function(a){this.setOption("scrollSpeed",a)};this.getScrollSpeed=function(){return this.getOption("scrollSpeed")};
this.setDragDelay=function(a){this.setOption("dragDelay",a)};this.getDragDelay=function(){return this.getOption("dragDelay")};this.setSelectionStyle=function(a){this.setOption("selectionStyle",a)};this.getSelectionStyle=function(){return this.getOption("selectionStyle")};this.setHighlightActiveLine=function(a){this.setOption("highlightActiveLine",a)};this.getHighlightActiveLine=function(){return this.getOption("highlightActiveLine")};this.setHighlightGutterLine=function(a){this.setOption("highlightGutterLine",
a)};this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")};this.setHighlightSelectedWord=function(a){this.setOption("highlightSelectedWord",a)};this.getHighlightSelectedWord=function(){return this.$highlightSelectedWord};this.setAnimatedScroll=function(a){this.renderer.setAnimatedScroll(a)};this.getAnimatedScroll=function(){return this.renderer.getAnimatedScroll()};this.setShowInvisibles=function(a){this.renderer.setShowInvisibles(a)};this.getShowInvisibles=function(){return this.renderer.getShowInvisibles()};
this.setDisplayIndentGuides=function(a){this.renderer.setDisplayIndentGuides(a)};this.getDisplayIndentGuides=function(){return this.renderer.getDisplayIndentGuides()};this.setShowPrintMargin=function(a){this.renderer.setShowPrintMargin(a)};this.getShowPrintMargin=function(){return this.renderer.getShowPrintMargin()};this.setPrintMarginColumn=function(a){this.renderer.setPrintMarginColumn(a)};this.getPrintMarginColumn=function(){return this.renderer.getPrintMarginColumn()};this.setReadOnly=function(a){this.setOption("readOnly",
a)};this.getReadOnly=function(){return this.getOption("readOnly")};this.setBehavioursEnabled=function(a){this.setOption("behavioursEnabled",a)};this.getBehavioursEnabled=function(){return this.getOption("behavioursEnabled")};this.setWrapBehavioursEnabled=function(a){this.setOption("wrapBehavioursEnabled",a)};this.getWrapBehavioursEnabled=function(){return this.getOption("wrapBehavioursEnabled")};this.setShowFoldWidgets=function(a){this.setOption("showFoldWidgets",a)};this.getShowFoldWidgets=function(){return this.getOption("showFoldWidgets")};
this.setFadeFoldWidgets=function(a){this.setOption("fadeFoldWidgets",a)};this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")};this.remove=function(a){this.selection.isEmpty()&&("left"==a?this.selection.selectLeft():this.selection.selectRight());a=this.getSelectionRange();if(this.getBehavioursEnabled()){var b=this.session,c=b.getState(a.start.row);c=b.getMode().transformAction(c,"deletion",this,b,a);if(0===a.end.column){var d=b.getTextRange(a);"\n"==d[d.length-1]&&(b=b.getLine(a.end.row),
/^\s+$/.test(b)&&(a.end.column=b.length))}c&&(a=c)}this.session.remove(a);this.clearSelection()};this.removeWordRight=function(){this.selection.isEmpty()&&this.selection.selectWordRight();this.session.remove(this.getSelectionRange());this.clearSelection()};this.removeWordLeft=function(){this.selection.isEmpty()&&this.selection.selectWordLeft();this.session.remove(this.getSelectionRange());this.clearSelection()};this.removeToLineStart=function(){this.selection.isEmpty()&&this.selection.selectLineStart();
this.selection.isEmpty()&&this.selection.selectLeft();this.session.remove(this.getSelectionRange());this.clearSelection()};this.removeToLineEnd=function(){this.selection.isEmpty()&&this.selection.selectLineEnd();var a=this.getSelectionRange();a.start.column==a.end.column&&a.start.row==a.end.row&&(a.end.column=0,a.end.row++);this.session.remove(a);this.clearSelection()};this.splitLine=function(){this.selection.isEmpty()||(this.session.remove(this.getSelectionRange()),this.clearSelection());var a=this.getCursorPosition();
this.insert("\n");this.moveCursorToPosition(a)};this.transposeLetters=function(){if(this.selection.isEmpty()){var a=this.getCursorPosition(),b=a.column;if(0!==b){var c=this.session.getLine(a.row);b<c.length?(c=c.charAt(b)+c.charAt(b-1),a=new l(a.row,b-1,a.row,b+1)):(c=c.charAt(b-1)+c.charAt(b-2),a=new l(a.row,b-2,a.row,b));this.session.replace(a,c);this.session.selection.moveToPosition(a.end)}}};this.toLowerCase=function(){var a=this.getSelectionRange();this.selection.isEmpty()&&this.selection.selectWord();
var b=this.getSelectionRange(),c=this.session.getTextRange(b);this.session.replace(b,c.toLowerCase());this.selection.setSelectionRange(a)};this.toUpperCase=function(){var a=this.getSelectionRange();this.selection.isEmpty()&&this.selection.selectWord();var b=this.getSelectionRange(),c=this.session.getTextRange(b);this.session.replace(b,c.toUpperCase());this.selection.setSelectionRange(a)};this.indent=function(){var a=this.session,b=this.getSelectionRange();if(b.start.row<b.end.row)b=this.$getSelectedRows(),
a.indentRows(b.first,b.last,"\t");else{if(b.start.column<b.end.column){var c=a.getTextRange(b);if(!/^\s+$/.test(c)){b=this.$getSelectedRows();a.indentRows(b.first,b.last,"\t");return}}c=a.getLine(b.start.row);var d=b.start,e=a.getTabSize();a=a.documentToScreenColumn(d.row,d.column);if(this.session.getUseSoftTabs())b=g.stringRepeat(" ",e-a%e);else{for(a%=e;" "==c[b.start.column-1]&&a;)b.start.column--,a--;this.selection.setSelectionRange(b);b="\t"}return this.insert(b)}};this.blockIndent=function(){var a=
this.$getSelectedRows();this.session.indentRows(a.first,a.last,"\t")};this.blockOutdent=function(){var a=this.session.getSelection();this.session.outdentRows(a.getRange())};this.sortLines=function(){for(var a=this.$getSelectedRows(),b=this.session,c=[],d=a.first;d<=a.last;d++)c.push(b.getLine(d));c.sort(function(a,b){return a.toLowerCase()<b.toLowerCase()?-1:a.toLowerCase()>b.toLowerCase()?1:0});var e=new l(0,0,0,0);for(d=a.first;d<=a.last;d++){var f=b.getLine(d);e.start.row=d;e.end.row=d;e.end.column=
f.length;b.replace(e,c[d-a.first])}};this.toggleCommentLines=function(){var a=this.session.getState(this.getCursorPosition().row),b=this.$getSelectedRows();this.session.getMode().toggleCommentLines(a,this.session,b.first,b.last)};this.toggleBlockComment=function(){var a=this.getCursorPosition(),b=this.session.getState(a.row),c=this.getSelectionRange();this.session.getMode().toggleBlockComment(b,this.session,c,a)};this.getNumberAt=function(a,b){var c=/[\-]?[0-9]+(?:\.[0-9]+)?/g;c.lastIndex=0;for(a=
this.session.getLine(a);c.lastIndex<b;){var d=c.exec(a);if(d.index<=b&&d.index+d[0].length>=b)return{value:d[0],start:d.index,end:d.index+d[0].length}}return null};this.modifyNumber=function(a){var b=this.selection.getCursor().row,c=this.selection.getCursor().column,d=new l(b,c-1,b,c);d=this.session.getTextRange(d);if(!isNaN(parseFloat(d))&&isFinite(d)){if(d=this.getNumberAt(b,c)){var e=0<=d.value.indexOf(".")?d.start+d.value.indexOf(".")+1:d.end,f=d.start+d.value.length-e,g=parseFloat(d.value);g*=
Math.pow(10,f);a=e!==d.end&&c<e?a*Math.pow(10,d.end-c-1):a*Math.pow(10,d.end-c);g=(g+a)/Math.pow(10,f);a=g.toFixed(f);e=new l(b,d.start,b,d.end);this.session.replace(e,a);this.moveCursorTo(b,Math.max(d.start+1,c+a.length-d.value.length))}}else this.toggleWord()};this.$toggleWordPairs=[["first","last"],["true","false"],["yes","no"],["width","height"],["top","bottom"],["right","left"],["on","off"],["x","y"],["get","set"],["max","min"],["horizontal","vertical"],["show","hide"],["add","remove"],["up",
"down"],["before","after"],["even","odd"],["in","out"],["inside","outside"],["next","previous"],["increase","decrease"],["attach","detach"],["&&","||"],["==","!="]];this.toggleWord=function(){var a=this.selection.getCursor().row,b=this.selection.getCursor().column;this.selection.selectWord();var c=this.getSelectedText(),d=this.selection.getWordRange().start.column,e=c.replace(/([a-z]+|[A-Z]+)(?=[A-Z_]|$)/g,"$1 ").split(/\s/),f=b-d-1;0>f&&(f=0);var l=0,q=0,n=this;c.match(/[A-Za-z0-9_]+/)&&e.forEach(function(b,
e){q=l+b.length;f>=l&&f<=q&&(c=b,n.selection.clearSelection(),n.moveCursorTo(a,l+d),n.selection.selectTo(a,q+d));l=q});b=this.$toggleWordPairs;var v;for(e=0;e<b.length;e++)for(var m=b[e],p=0;1>=p;p++){var u=+!p;(v=c.match(new RegExp("^\\s?_?("+g.escapeRegExp(m[p])+")\\s?$","i")))&&c.match(new RegExp("([_]|^|\\s)("+g.escapeRegExp(v[1])+")($|\\s)","g"))&&(v=c.replace(new RegExp(g.escapeRegExp(m[p]),"i"),function(a){var b=m[u];a.toUpperCase()==a?b=b.toUpperCase():a.charAt(0).toUpperCase()==a.charAt(0)&&
(b=b.substr(0,0)+m[u].charAt(0).toUpperCase()+b.substr(1));return b}),this.insert(v),v="")}};this.removeLines=function(){var a=this.$getSelectedRows();this.session.removeFullLines(a.first,a.last);this.clearSelection()};this.duplicateSelection=function(){var a=this.selection,b=this.session,c=a.getRange(),d=a.isBackwards();if(c.isEmpty())a=c.start.row,b.duplicateLines(a,a);else{var e=d?c.start:c.end;b=b.insert(e,b.getTextRange(c),!1);c.start=e;c.end=b;a.setSelectionRange(c,d)}};this.moveLinesDown=function(){this.$moveLines(1,
!1)};this.moveLinesUp=function(){this.$moveLines(-1,!1)};this.moveText=function(a,b,c){return this.session.moveText(a,b,c)};this.copyLinesUp=function(){this.$moveLines(-1,!0)};this.copyLinesDown=function(){this.$moveLines(1,!0)};this.$moveLines=function(a,b){var c=this.selection;if(!c.inMultiSelectMode||this.inVirtualSelectionMode){var d=c.toOrientedRange();var e=this.$getSelectedRows(d);var f=this.session.$moveLines(e.first,e.last,b?0:a);b&&-1==a&&(f=0);d.moveBy(f,0);c.fromOrientedRange(d)}else{d=
c.rangeList.ranges;c.rangeList.detach(this.session);this.inVirtualSelectionMode=!0;var l=0;f=0;for(var g=d.length,q=0;q<g;q++){var n=q;d[q].moveBy(l,0);e=this.$getSelectedRows(d[q]);l=e.first;for(e=e.last;++q<g;){f&&d[q].moveBy(f,0);var v=this.$getSelectedRows(d[q]);if(b&&v.first!=e)break;else if(!b&&v.first>e+1)break;e=v.last}q--;l=this.session.$moveLines(l,e,b?0:a);for(b&&-1==a&&(n=q+1);n<=q;)d[n].moveBy(l,0),n++;b||(l=0);f+=l}c.fromOrientedRange(c.ranges[0]);c.rangeList.attach(this.session);this.inVirtualSelectionMode=
!1}};this.$getSelectedRows=function(a){a=(a||this.getSelectionRange()).collapseRows();return{first:this.session.getRowFoldStart(a.start.row),last:this.session.getRowFoldEnd(a.end.row)}};this.onCompositionStart=function(a){this.renderer.showComposition(a)};this.onCompositionUpdate=function(a){this.renderer.setCompositionText(a)};this.onCompositionEnd=function(){this.renderer.hideComposition()};this.getFirstVisibleRow=function(){return this.renderer.getFirstVisibleRow()};this.getLastVisibleRow=function(){return this.renderer.getLastVisibleRow()};
this.isRowVisible=function(a){return a>=this.getFirstVisibleRow()&&a<=this.getLastVisibleRow()};this.isRowFullyVisible=function(a){return a>=this.renderer.getFirstFullyVisibleRow()&&a<=this.renderer.getLastFullyVisibleRow()};this.$getVisibleRowCount=function(){return this.renderer.getScrollBottomRow()-this.renderer.getScrollTopRow()+1};this.$moveByPage=function(a,b){var c=this.renderer,d=this.renderer.layerConfig,e=a*Math.floor(d.height/d.lineHeight);!0===b?this.selection.$moveSelection(function(){this.moveCursorBy(e,
0)}):!1===b&&(this.selection.moveCursorBy(e,0),this.selection.clearSelection());a=c.scrollTop;c.scrollBy(0,e*d.lineHeight);null!=b&&c.scrollCursorIntoView(null,.5);c.animateScrolling(a)};this.selectPageDown=function(){this.$moveByPage(1,!0)};this.selectPageUp=function(){this.$moveByPage(-1,!0)};this.gotoPageDown=function(){this.$moveByPage(1,!1)};this.gotoPageUp=function(){this.$moveByPage(-1,!1)};this.scrollPageDown=function(){this.$moveByPage(1)};this.scrollPageUp=function(){this.$moveByPage(-1)};
this.scrollToRow=function(a){this.renderer.scrollToRow(a)};this.scrollToLine=function(a,b,c,d){this.renderer.scrollToLine(a,b,c,d)};this.centerSelection=function(){var a=this.getSelectionRange();this.renderer.alignCursor({row:Math.floor(a.start.row+(a.end.row-a.start.row)/2),column:Math.floor(a.start.column+(a.end.column-a.start.column)/2)},.5)};this.getCursorPosition=function(){return this.selection.getCursor()};this.getCursorPositionScreen=function(){return this.session.documentToScreenPosition(this.getCursorPosition())};
this.getSelectionRange=function(){return this.selection.getRange()};this.selectAll=function(){this.selection.selectAll()};this.clearSelection=function(){this.selection.clearSelection()};this.moveCursorTo=function(a,b){this.selection.moveCursorTo(a,b)};this.moveCursorToPosition=function(a){this.selection.moveCursorToPosition(a)};this.jumpToMatching=function(a,b){var c=this.getCursorPosition(),d=new n(this.session,c.row,c.column),e=d.getCurrentToken(),f=e||d.stepForward();if(f){var g=!1,q={},v=c.column-
f.start,m={")":"(","(":"(","]":"[","[":"[","{":"{","}":"{"};do{if(f.value.match(/[{}()\[\]]/g))for(;v<f.value.length&&!g;v++){if(m[f.value[v]]){var p=m[f.value[v]]+"."+f.type.replace("rparen","lparen");isNaN(q[p])&&(q[p]=0);switch(f.value[v]){case "(":case "[":case "{":q[p]++;break;case ")":case "]":case "}":if(q[p]--,-1===q[p]){var u="bracket";g=!0}}}}else-1!==f.type.indexOf("tag-name")&&(isNaN(q[f.value])&&(q[f.value]=0),"<"===e.value?q[f.value]++:"</"===e.value&&q[f.value]--,-1===q[f.value]&&(u=
"tag",g=!0));g||(e=f,f=d.stepForward(),v=0)}while(f&&!g);if(u){if("bracket"===u){var k=this.session.getBracketRange(c);if(!k){k=new l(d.getCurrentTokenRow(),d.getCurrentTokenColumn()+v-1,d.getCurrentTokenRow(),d.getCurrentTokenColumn()+v-1);var w=k.start;if(b||w.row===c.row&&2>Math.abs(w.column-c.column))k=this.session.getBracketRange(w)}}else if("tag"===u){if(f&&-1!==f.type.indexOf("tag-name"))u=f.value;else return;k=new l(d.getCurrentTokenRow(),d.getCurrentTokenColumn()-2,d.getCurrentTokenRow(),
d.getCurrentTokenColumn()-2);if(0===k.compare(c.row,c.column)){g=!1;do if(f=e,e=d.stepBackward())-1!==e.type.indexOf("tag-close")&&k.setEnd(d.getCurrentTokenRow(),d.getCurrentTokenColumn()+1),f.value===u&&-1!==f.type.indexOf("tag-name")&&("<"===e.value?q[u]++:"</"===e.value&&q[u]--,0===q[u]&&(g=!0));while(e&&!g)}f&&f.type.indexOf("tag-name")&&(w=k.start,w.row==c.row&&2>Math.abs(w.column-c.column)&&(w=k.end))}(w=k&&k.cursor||w)&&(a?k&&b?this.selection.setRange(k):k&&k.isEqual(this.getSelectionRange())?
this.clearSelection():this.selection.selectTo(w.row,w.column):this.selection.moveTo(w.row,w.column))}}};this.gotoLine=function(a,b,c){this.selection.clearSelection();this.session.unfold({row:a-1,column:b||0});this.exitMultiSelectMode&&this.exitMultiSelectMode();this.moveCursorTo(a-1,b||0);this.isRowFullyVisible(a-1)||this.scrollToLine(a-1,!0,c)};this.navigateTo=function(a,b){this.selection.moveTo(a,b)};this.navigateUp=function(a){if(this.selection.isMultiLine()&&!this.selection.isBackwards())return a=
this.selection.anchor.getPosition(),this.moveCursorToPosition(a);this.selection.clearSelection();this.selection.moveCursorBy(-a||-1,0)};this.navigateDown=function(a){if(this.selection.isMultiLine()&&this.selection.isBackwards())return a=this.selection.anchor.getPosition(),this.moveCursorToPosition(a);this.selection.clearSelection();this.selection.moveCursorBy(a||1,0)};this.navigateLeft=function(a){if(this.selection.isEmpty())for(a=a||1;a--;)this.selection.moveCursorLeft();else a=this.getSelectionRange().start,
this.moveCursorToPosition(a);this.clearSelection()};this.navigateRight=function(a){if(this.selection.isEmpty())for(a=a||1;a--;)this.selection.moveCursorRight();else a=this.getSelectionRange().end,this.moveCursorToPosition(a);this.clearSelection()};this.navigateLineStart=function(){this.selection.moveCursorLineStart();this.clearSelection()};this.navigateLineEnd=function(){this.selection.moveCursorLineEnd();this.clearSelection()};this.navigateFileEnd=function(){this.selection.moveCursorFileEnd();this.clearSelection()};
this.navigateFileStart=function(){this.selection.moveCursorFileStart();this.clearSelection()};this.navigateWordRight=function(){this.selection.moveCursorWordRight();this.clearSelection()};this.navigateWordLeft=function(){this.selection.moveCursorWordLeft();this.clearSelection()};this.replace=function(a,b){b&&this.$search.set(b);b=this.$search.find(this.session);var c=0;if(!b)return c;this.$tryReplace(b,a)&&(c=1);this.selection.setSelectionRange(b);this.renderer.scrollSelectionIntoView(b.start,b.end);
return c};this.replaceAll=function(a,b){b&&this.$search.set(b);b=this.$search.findAll(this.session);var c=0;if(!b.length)return c;var d=this.getSelectionRange();this.selection.moveTo(0,0);for(var e=b.length-1;0<=e;--e)this.$tryReplace(b[e],a)&&c++;this.selection.setSelectionRange(d);return c};this.$tryReplace=function(a,b){var c=this.session.getTextRange(a);b=this.$search.replace(c,b);return null!==b?(a.end=this.session.replace(a,b),a):null};this.getLastSearchOptions=function(){return this.$search.getOptions()};
this.find=function(a,b,c){b||(b={});"string"==typeof a||a instanceof RegExp?b.needle=a:"object"==typeof a&&k.mixin(b,a);var d=this.selection.getRange();null==b.needle&&(a=this.session.getTextRange(d)||this.$search.$options.needle,a||(d=this.session.getWordRange(d.start.row,d.start.column),a=this.session.getTextRange(d)),this.$search.set({needle:a}));this.$search.set(b);b.start||this.$search.set({start:d});a=this.$search.find(this.session);if(b.preventScroll)return a;if(a)return this.revealRange(a,
c),a;b.backwards?d.start=d.end:d.end=d.start;this.selection.setRange(d)};this.findNext=function(a,b){this.find({skipCurrent:!0,backwards:!1},a,b)};this.findPrevious=function(a,b){this.find(a,{skipCurrent:!0,backwards:!0},b)};this.revealRange=function(a,b){this.session.unfold(a);this.selection.setSelectionRange(a);var c=this.renderer.scrollTop;this.renderer.scrollSelectionIntoView(a.start,a.end,.5);!1!==b&&this.renderer.animateScrolling(c)};this.undo=function(){this.session.getUndoManager().undo(this.session);
this.renderer.scrollCursorIntoView(null,.5)};this.redo=function(){this.session.getUndoManager().redo(this.session);this.renderer.scrollCursorIntoView(null,.5)};this.destroy=function(){this.$toDestroy&&(this.$toDestroy.forEach(function(a){a.destroy()}),this.$toDestroy=null);this.$mouseHandler&&this.$mouseHandler.destroy();this.renderer.destroy();this._signal("destroy",this);this.session&&this.session.destroy();this._$emitInputEvent&&this._$emitInputEvent.cancel();this.removeAllListeners()};this.setAutoScrollEditorIntoView=
function(a){if(a){var b,c=this,d=!1;this.$scrollAnchor||(this.$scrollAnchor=document.createElement("div"));var e=this.$scrollAnchor;e.style.cssText="position:absolute";this.container.insertBefore(e,this.container.firstChild);var f=this.on("changeSelection",function(){d=!0}),l=this.renderer.on("beforeRender",function(){d&&(b=c.renderer.container.getBoundingClientRect())}),g=this.renderer.on("afterRender",function(){if(d&&b&&(c.isFocused()||c.searchBox&&c.searchBox.isFocused())){var a=c.renderer,f=
a.$cursorLayer.$pixelPos;a=a.layerConfig;var l=f.top-a.offset;d=0<=f.top&&0>l+b.top?!0:f.top<a.height&&f.top+b.top+a.lineHeight>window.innerHeight?!1:null;null!=d&&(e.style.top=l+"px",e.style.left=f.left+"px",e.style.height=a.lineHeight+"px",e.scrollIntoView(d));d=b=null}});this.setAutoScrollEditorIntoView=function(a){a||(delete this.setAutoScrollEditorIntoView,this.off("changeSelection",f),this.renderer.off("afterRender",g),this.renderer.off("beforeRender",l))}}};this.$resetCursorStyle=function(){var a=
this.$cursorStyle||"ace",b=this.renderer.$cursorLayer;b&&(b.setSmoothBlinking(/smooth/.test(a)),b.isBlinking=!this.$readOnly&&"wide"!=a,x.setCssClass(b.element,"ace_slim-cursors",/slim/.test(a)))};this.prompt=function(a,b,c){var d=this;q.loadModule("./ext/prompt",function(e){e.prompt(d,a,b,c)})}}).call(t.prototype);q.defineOptions(t.prototype,"editor",{selectionStyle:{set:function(a){this.onSelectionChange();this._signal("changeSelectionStyle",{data:a})},initialValue:"line"},highlightActiveLine:{set:function(){this.$updateHighlightActiveLine()},
initialValue:!0},highlightSelectedWord:{set:function(a){this.$onSelectionChange()},initialValue:!0},readOnly:{set:function(a){this.textInput.setReadOnly(a);this.$resetCursorStyle()},initialValue:!1},copyWithEmptySelection:{set:function(a){this.textInput.setCopyWithEmptySelection(a)},initialValue:!1},cursorStyle:{set:function(a){this.$resetCursorStyle()},values:["ace","slim","smooth","wide"],initialValue:"ace"},mergeUndoDeltas:{values:[!1,!0,"always"],initialValue:!0},behavioursEnabled:{initialValue:!0},
wrapBehavioursEnabled:{initialValue:!0},enableAutoIndent:{initialValue:!0},autoScrollEditorIntoView:{set:function(a){this.setAutoScrollEditorIntoView(a)}},keyboardHandler:{set:function(a){this.setKeyboardHandler(a)},get:function(){return this.$keybindingId},handlesSet:!0},value:{set:function(a){this.session.setValue(a)},get:function(){return this.getValue()},handlesSet:!0,hidden:!0},session:{set:function(a){this.setSession(a)},get:function(){return this.session},handlesSet:!0,hidden:!0},showLineNumbers:{set:function(a){this.renderer.$gutterLayer.setShowLineNumbers(a);
this.renderer.$loop.schedule(this.renderer.CHANGE_GUTTER);a&&this.$relativeLineNumbers?z.attach(this):z.detach(this)},initialValue:!0},relativeLineNumbers:{set:function(a){this.$showLineNumbers&&a?z.attach(this):z.detach(this)}},placeholder:{set:function(a){this.$updatePlaceholder||(this.$updatePlaceholder=function(){var a=this.session&&(this.renderer.$composition||this.getValue());a&&this.renderer.placeholderNode?(this.renderer.off("afterRender",this.$updatePlaceholder),x.removeCssClass(this.container,
"ace_hasPlaceholder"),this.renderer.placeholderNode.remove(),this.renderer.placeholderNode=null):a||this.renderer.placeholderNode?!a&&this.renderer.placeholderNode&&(this.renderer.placeholderNode.textContent=this.$placeholder||""):(this.renderer.on("afterRender",this.$updatePlaceholder),x.addCssClass(this.container,"ace_hasPlaceholder"),a=x.createElement("div"),a.className="ace_placeholder",a.textContent=this.$placeholder||"",this.renderer.placeholderNode=a,this.renderer.content.appendChild(this.renderer.placeholderNode))}.bind(this),
this.on("input",this.$updatePlaceholder));this.$updatePlaceholder()}},hScrollBarAlwaysVisible:"renderer",vScrollBarAlwaysVisible:"renderer",highlightGutterLine:"renderer",animatedScroll:"renderer",showInvisibles:"renderer",showPrintMargin:"renderer",printMarginColumn:"renderer",printMargin:"renderer",fadeFoldWidgets:"renderer",showFoldWidgets:"renderer",displayIndentGuides:"renderer",showGutter:"renderer",fontSize:"renderer",fontFamily:"renderer",maxLines:"renderer",minLines:"renderer",scrollPastEnd:"renderer",
fixedWidthGutter:"renderer",theme:"renderer",hasCssTransforms:"renderer",maxPixelHeight:"renderer",useTextareaForIME:"renderer",scrollSpeed:"$mouseHandler",dragDelay:"$mouseHandler",dragEnabled:"$mouseHandler",focusTimeout:"$mouseHandler",tooltipFollowsMouse:"$mouseHandler",firstLineNumber:"session",overwrite:"session",newLineMode:"session",useWorker:"session",useSoftTabs:"session",navigateWithinSoftTabs:"session",tabSize:"session",wrap:"session",indentedSoftWrap:"session",foldStyle:"session",mode:"session"});
var z={getText:function(a,b){return(Math.abs(a.selection.lead.row-b)||b+1+(9>b?"\u00b7":""))+""},getWidth:function(a,b,c){return Math.max(b.toString().length,(c.lastRow+1).toString().length,2)*c.characterWidth},update:function(a,b){b.renderer.$loop.schedule(b.renderer.CHANGE_GUTTER)},attach:function(a){a.renderer.$gutterLayer.$renderer=this;a.on("changeSelection",this.update);this.update(null,a)},detach:function(a){a.renderer.$gutterLayer.$renderer==this&&(a.renderer.$gutterLayer.$renderer=null);
a.off("changeSelection",this.update);this.update(null,a)}};e.Editor=t});ace.define("ace/undomanager",["require","exports","module","ace/range"],function(b,e,h){function k(a){return{row:a.row,column:a.column}}function x(a){a=a||this;if(Array.isArray(a))return a.map(x).join("\n");var b="";a.action?(b="insert"==a.action?"+":"-",b+="["+a.lines+"]"):a.value&&(b=Array.isArray(a.value)?a.value.map(g).join("\n"):g(a.value));a.start&&(b+=g(a));if(a.id||a.rev)b+="\t("+(a.id||a.rev)+")";return b}function g(a){return a.start.row+
":"+a.start.column+"=>"+a.end.row+":"+a.end.column}function d(b,c){var d="insert"==b.action,e="insert"==c.action;if(d&&e)if(0<=p(c.start,b.end))a(c,b,-1);else if(0>=p(c.start,b.start))a(b,c,1);else return null;else if(d&&!e)if(0<=p(c.start,b.end))a(c,b,-1);else if(0>=p(c.end,b.start))a(b,c,-1);else return null;else if(!d&&e)if(0<=p(c.start,b.start))a(c,b,1);else if(0>=p(c.start,b.start))a(b,c,1);else return null;else if(!d&&!e)if(0<=p(c.start,b.start))a(c,b,1);else if(0>=p(c.end,b.start))a(b,c,-1);
else return null;return[c,b]}function a(a,b,d){c(a.start,b.start,b.end,d);c(a.end,b.start,b.end,d)}function c(a,b,c,d){a.row==(1==d?b:c).row&&(a.column+=d*(c.column-b.column));a.row+=d*(c.row-b.row)}function f(a,b){var c=a.lines,d=a.end;a.end=k(b);var e=a.end.row-a.start.row,f=c.splice(e,c.length);e=e?b.column:b.column-a.start.column;c.push(f[0].substring(0,e));f[0]=f[0].substr(e);return{start:k(b),end:d,lines:f,action:a.action}}function w(b,d){for(var e=0;e<d.length;e++)for(var g=d[e],l=0;l<g.length;l++){var n=
b,u=g[l],w=u;u={start:k(w.start),end:k(w.end),action:w.action,lines:w.lines.slice()};for(w=n.length;w--;){for(var h=n[w],x=0;x<h.length;x++){var r;a:{var t=r=void 0,y=h[x],B="insert"==y.action,G="insert"==u.action;if(B&&G)0>p(y.start,u.start)?a(u,y,1):a(y,u,1);else if(B&&!G)0<=p(y.start,u.end)?a(y,u,-1):(0>=p(y.start,u.start)||a(y,m.fromPoints(u.start,y.start),-1),a(u,y,1));else if(!B&&G)0<=p(u.start,y.end)?a(u,y,-1):(0>=p(u.start,y.start)||a(u,m.fromPoints(y.start,u.start),-1),a(y,u,1));else if(!B&&
!G)if(0<=p(u.start,y.end))a(u,y,-1);else if(0>=p(u.end,y.start))a(y,u,-1);else{0>p(y.start,u.start)&&(t=y,y=f(y,u.start));0<p(y.end,u.end)&&(r=f(y,u.end));c(u.end,y.start,y.end,-1);r&&!t&&(y.lines=r.lines,y.start=r.start,y.end=r.end,r=y);r=[u,t,r].filter(Boolean);break a}r=[u,y]}u=r[0];2!=r.length&&(r[2]?(h.splice(x+1,1,r[1],r[2]),x++):r[1]||(h.splice(x,1),x--))}h.length||n.splice(w,1)}}}h=function(){this.$maxRev=0;this.$fromUndo=!1;this.reset()};(function(){this.addSession=function(a){this.$session=
a};this.add=function(a,b,c){if(!this.$fromUndo&&a!=this.$lastDelta){this.$keepRedoStack||(this.$redoStack.length=0);!1!==b&&this.lastDeltas||(this.lastDeltas=[],this.$undoStack.push(this.lastDeltas),a.id=this.$rev=++this.$maxRev);if("remove"==a.action||"insert"==a.action)this.$lastDelta=a;this.lastDeltas.push(a)}};this.addSelection=function(a,b){this.selections.push({value:a,rev:b||this.$rev})};this.startNewGroup=function(){this.lastDeltas=null;return this.$rev};this.markIgnored=function(a,b){null==
b&&(b=this.$rev+1);for(var c=this.$undoStack,d=c.length;d--;){var e=c[d][0];if(e.id<=a)break;e.id<b&&(e.ignore=!0)}this.lastDeltas=null};this.getSelection=function(a,b){for(var c=this.selections,d=c.length;d--;){var e=c[d];if(e.rev<a)return b&&(e=c[d+1]),e}};this.getRevision=function(){return this.$rev};this.getDeltas=function(a,b){null==b&&(b=this.$rev+1);for(var c=this.$undoStack,d=null,e=0,f=c.length;f--;){var g=c[f][0];g.id<b&&!d&&(d=f+1);if(g.id<=a){e=f+1;break}}return c.slice(e,d)};this.getChangedRanges=
function(a,b){};this.getChangedLines=function(a,b){};this.undo=function(a,b){this.lastDeltas=null;var c=this.$undoStack,e;a:{for(var f=e=c.length;f--;){var g=c[f];if(g&&!g[0].ignore){for(;f<e-1;){b:{g=c[f];for(var l=c[f+1],m=g.length;m--;)for(var p=0;p<l.length;p++)if(!d(g[m],l[p])){for(;m<g.length;){for(;p--;)d(l[p],g[m]);p=l.length;m++}g=[g,l];break b}g.selectionBefore=l.selectionBefore=g.selectionAfter=l.selectionAfter=null;g=[l,g]}c[f]=g[0];c[f+1]=g[1];f++}e=!0;break a}}e=void 0}if(e)return a||
(a=this.$session),this.$redoStackBaseRev!==this.$rev&&this.$redoStack.length&&(this.$redoStack=[]),this.$fromUndo=!0,c=c.pop(),e=null,c&&(e=a.undoChanges(c,b),this.$redoStack.push(c),this.$syncRev()),this.$fromUndo=!1,e};this.redo=function(a,b){this.lastDeltas=null;a||(a=this.$session);this.$fromUndo=!0;if(this.$redoStackBaseRev!=this.$rev){var c=this.getDeltas(this.$redoStackBaseRev,this.$rev+1);w(this.$redoStack,c);this.$redoStackBaseRev=this.$rev;this.$redoStack.forEach(function(a){a[0].id=++this.$maxRev},
this)}c=this.$redoStack.pop();var d=null;c&&(d=a.redoChanges(c,b),this.$undoStack.push(c),this.$syncRev());this.$fromUndo=!1;return d};this.$syncRev=function(){var a=this.$undoStack;this.$rev=this.$redoStackBaseRev=a=(a=a[a.length-1])&&a[0].id||0};this.reset=function(){this.$lastDelta=this.lastDeltas=null;this.$undoStack=[];this.$redoStack=[];this.$redoStackBaseRev=this.mark=this.$rev=0;this.selections=[]};this.canUndo=function(){return 0<this.$undoStack.length};this.canRedo=function(){return 0<this.$redoStack.length};
this.bookmark=function(a){void 0==a&&(a=this.$rev);this.mark=a};this.isAtBookmark=function(){return this.$rev===this.mark};this.toJSON=function(){};this.fromJSON=function(){};this.hasUndo=this.canUndo;this.hasRedo=this.canRedo;this.isClean=this.isAtBookmark;this.markClean=this.bookmark;this.$prettyPrint=function(a){return a?x(a):x(this.$undoStack)+"\n---\n"+x(this.$redoStack)}}).call(h.prototype);var m=b("./range").Range,p=m.comparePoints;e.UndoManager=h});ace.define("ace/layer/lines",["require",
"exports","module","ace/lib/dom"],function(b,e,h){var k=b("../lib/dom");b=function(b,e){this.element=b;this.canvasHeight=e||5E5;this.element.style.height=2*this.canvasHeight+"px";this.cells=[];this.cellCache=[];this.$offsetCoefficient=0};(function(){this.moveContainer=function(b){k.translate(this.element,0,-(b.firstRowScreen*b.lineHeight%this.canvasHeight)-b.offset*this.$offsetCoefficient)};this.pageChanged=function(b,e){return Math.floor(b.firstRowScreen*b.lineHeight/this.canvasHeight)!==Math.floor(e.firstRowScreen*
e.lineHeight/this.canvasHeight)};this.computeLineTop=function(b,e,d){var a=Math.floor(e.firstRowScreen*e.lineHeight/this.canvasHeight);return d.documentToScreenRow(b,0)*e.lineHeight-a*this.canvasHeight};this.computeLineHeight=function(b,e,d){return e.lineHeight*d.getRowLineCount(b)};this.getLength=function(){return this.cells.length};this.get=function(b){return this.cells[b]};this.shift=function(){this.$cacheCell(this.cells.shift())};this.pop=function(){this.$cacheCell(this.cells.pop())};this.push=
function(b){if(Array.isArray(b)){this.cells.push.apply(this.cells,b);for(var e=k.createFragment(this.element),d=0;d<b.length;d++)e.appendChild(b[d].element);this.element.appendChild(e)}else this.cells.push(b),this.element.appendChild(b.element)};this.unshift=function(b){if(Array.isArray(b)){this.cells.unshift.apply(this.cells,b);for(var e=k.createFragment(this.element),d=0;d<b.length;d++)e.appendChild(b[d].element);this.element.firstChild?this.element.insertBefore(e,this.element.firstChild):this.element.appendChild(e)}else this.cells.unshift(b),
this.element.insertAdjacentElement("afterbegin",b.element)};this.last=function(){return this.cells.length?this.cells[this.cells.length-1]:null};this.$cacheCell=function(b){b&&(b.element.remove(),this.cellCache.push(b))};this.createCell=function(b,e,d,a){e=this.cellCache.pop();e||(e=k.createElement("div"),a&&a(e),this.element.appendChild(e),e={element:e,text:"",row:b});e.row=b;return e}}).call(b.prototype);e.Lines=b});ace.define("ace/layer/gutter","require exports module ace/lib/dom ace/lib/oop ace/lib/lang ace/lib/event_emitter ace/layer/lines".split(" "),
function(b,e,h){function k(a){var b=document.createTextNode("");a.appendChild(b);b=r.createElement("span");a.appendChild(b);return a}var r=b("../lib/dom"),g=b("../lib/oop"),d=b("../lib/lang"),a=b("../lib/event_emitter").EventEmitter,c=b("./lines").Lines;b=function(a){this.element=r.createElement("div");this.element.className="ace_layer ace_gutter-layer";a.appendChild(this.element);this.setShowFoldWidgets(this.$showFoldWidgets);this.gutterWidth=0;this.$annotations=[];this.$updateAnnotations=this.$updateAnnotations.bind(this);
this.$lines=new c(this.element);this.$lines.$offsetCoefficient=1};(function(){g.implement(this,a);this.setSession=function(a){this.session&&this.session.off("change",this.$updateAnnotations);if(this.session=a)a.on("change",this.$updateAnnotations)};this.addGutterDecoration=function(a,b){window.console&&console.warn&&console.warn("deprecated use session.addGutterDecoration");this.session.addGutterDecoration(a,b)};this.removeGutterDecoration=function(a,b){window.console&&console.warn&&console.warn("deprecated use session.removeGutterDecoration");
this.session.removeGutterDecoration(a,b)};this.setAnnotations=function(a){this.$annotations=[];for(var b=0;b<a.length;b++){var c=a[b],e=c.row,f=this.$annotations[e];f||(f=this.$annotations[e]={text:[]});e=(e=c.text)?d.escapeHTML(e):c.html||"";-1===f.text.indexOf(e)&&f.text.push(e);c=c.type;"error"==c?f.className=" ace_error":"warning"==c&&" ace_error"!=f.className?f.className=" ace_warning":"info"!=c||f.className||(f.className=" ace_info")}};this.$updateAnnotations=function(a){if(this.$annotations.length){var b=
a.start.row,c=a.end.row-b;0!==c&&("remove"==a.action?this.$annotations.splice(b,c+1,null):(a=Array(c+1),a.unshift(b,1),this.$annotations.splice.apply(this.$annotations,a)))}};this.update=function(a){this.config=a;var b=this.session,c=a.firstRow,d=Math.min(a.lastRow+a.gutterOffset,b.getLength()-1);this.oldLastRow=d;this.config=a;this.$lines.moveContainer(a);this.$updateCursorRow();for(var e=b.getNextFoldLine(c),f=e?e.start.row:Infinity,g=-1,h=c;;){h>f&&(h=e.end.row+1,f=(e=b.getNextFoldLine(h,e))?e.start.row:
Infinity);if(h>d){for(;this.$lines.getLength()>g+1;)this.$lines.pop();break}(c=this.$lines.get(++g))?c.row=h:(c=this.$lines.createCell(h,a,this.session,k),this.$lines.push(c));this.$renderCell(c,a,e,h);h++}this._signal("afterRender");this.$updateGutterWidth(a)};this.$updateGutterWidth=function(a){var b=this.session,c=b.gutterRenderer||this.$renderer,d=b.$firstLineNumber,e=this.$lines.last()?this.$lines.last().text:"";if(this.$fixedWidth||b.$useWrapMode)e=b.getLength()+d-1;a=c?c.getWidth(b,e,a):e.toString().length*
a.characterWidth;b=this.$padding||this.$computePadding();a+=b.left+b.right;a===this.gutterWidth||isNaN(a)||(this.gutterWidth=a,this.element.parentNode.style.width=this.element.style.width=Math.ceil(this.gutterWidth)+"px",this._signal("changeGutterWidth",a))};this.$updateCursorRow=function(){if(this.$highlightGutterLine){var a=this.session.selection.getCursor();this.$cursorRow!==a.row&&(this.$cursorRow=a.row)}};this.updateLineHighlight=function(){if(this.$highlightGutterLine){var a=this.session.selection.cursor.row;
this.$cursorRow=a;if(!this.$cursorCell||this.$cursorCell.row!=a){this.$cursorCell&&(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ",""));a=this.$lines.cells;this.$cursorCell=null;for(var b=0;b<a.length;b++){var c=a[b];if(c.row>=this.$cursorRow){if(c.row>this.$cursorRow)if(c=this.session.getFoldLine(this.$cursorRow),0<b&&c&&c.start.row==a[b-1].row)c=a[b-1];else break;c.element.className="ace_gutter-active-line "+c.element.className;this.$cursorCell=
c;break}}}}};this.scrollLines=function(a){var b=this.config;this.config=a;this.$updateCursorRow();if(this.$lines.pageChanged(b,a))return this.update(a);this.$lines.moveContainer(a);var c=Math.min(a.lastRow+a.gutterOffset,this.session.getLength()-1),d=this.oldLastRow;this.oldLastRow=c;if(!b||d<a.firstRow||c<b.firstRow)return this.update(a);if(b.firstRow<a.firstRow)for(var e=this.session.getFoldedRowCount(b.firstRow,a.firstRow-1);0<e;e--)this.$lines.shift();if(d>c)for(e=this.session.getFoldedRowCount(c+
1,d);0<e;e--)this.$lines.pop();a.firstRow<b.firstRow&&this.$lines.unshift(this.$renderLines(a,a.firstRow,b.firstRow-1));c>d&&this.$lines.push(this.$renderLines(a,d+1,c));this.updateLineHighlight();this._signal("afterRender");this.$updateGutterWidth(a)};this.$renderLines=function(a,b,c){for(var d=[],e=this.session.getNextFoldLine(b),f=e?e.start.row:Infinity;;){b>f&&(b=e.end.row+1,f=(e=this.session.getNextFoldLine(b,e))?e.start.row:Infinity);if(b>c)break;var g=this.$lines.createCell(b,a,this.session,
k);this.$renderCell(g,a,e,b);d.push(g);b++}return d};this.$renderCell=function(a,b,c,d){var e=a.element,f=this.session,g=e.childNodes[0],m=e.childNodes[1],q=f.$firstLineNumber,n=f.$breakpoints,k=f.$decorations,p=f.gutterRenderer||this.$renderer,w=this.$showFoldWidgets&&f.foldWidgets,h=c?c.start.row:Number.MAX_VALUE,x="ace_gutter-cell ";this.$highlightGutterLine&&(d==this.$cursorRow||c&&d<this.$cursorRow&&d>=h&&this.$cursorRow<=c.end.row)&&(x+="ace_gutter-active-line ",this.$cursorCell!=a&&(this.$cursorCell&&
(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ","")),this.$cursorCell=a));n[d]&&(x+=n[d]);k[d]&&(x+=k[d]);this.$annotations[d]&&(x+=this.$annotations[d].className);e.className!=x&&(e.className=x);if(w){var t=w[d];null==t&&(t=w[d]=f.getFoldWidget(d))}t?(x="ace_fold-widget ace_"+t,x="start"==t&&d==h&&d<c.end.row?x+" ace_closed":x+" ace_open",m.className!=x&&(m.className=x),r.setStyle(m.style,"height",b.lineHeight+"px"),r.setStyle(m.style,"display",
"inline-block")):m&&r.setStyle(m.style,"display","none");c=(p?p.getText(f,d):d+q).toString();c!==g.data&&(g.data=c);r.setStyle(a.element.style,"height",this.$lines.computeLineHeight(d,b,f)+"px");r.setStyle(a.element.style,"top",this.$lines.computeLineTop(d,b,f)+"px");a.text=c;return a};this.$fixedWidth=!1;this.$highlightGutterLine=!0;this.$renderer="";this.setHighlightGutterLine=function(a){this.$highlightGutterLine=a};this.$showLineNumbers=!0;this.$renderer="";this.setShowLineNumbers=function(a){this.$renderer=
!a&&{getWidth:function(){return 0},getText:function(){return""}}};this.getShowLineNumbers=function(){return this.$showLineNumbers};this.$showFoldWidgets=!0;this.setShowFoldWidgets=function(a){a?r.addCssClass(this.element,"ace_folding-enabled"):r.removeCssClass(this.element,"ace_folding-enabled");this.$showFoldWidgets=a;this.$padding=null};this.getShowFoldWidgets=function(){return this.$showFoldWidgets};this.$computePadding=function(){if(!this.element.firstChild)return{left:0,right:0};var a=r.computedStyle(this.element.firstChild);
this.$padding={};this.$padding.left=(parseInt(a.borderLeftWidth)||0)+(parseInt(a.paddingLeft)||0)+1;this.$padding.right=(parseInt(a.borderRightWidth)||0)+(parseInt(a.paddingRight)||0);return this.$padding};this.getRegion=function(a){var b=this.$padding||this.$computePadding(),c=this.element.getBoundingClientRect();if(a.x<b.left+c.left)return"markers";if(this.$showFoldWidgets&&a.x>c.right-b.right)return"foldWidgets"}}).call(b.prototype);e.Gutter=b});ace.define("ace/layer/marker",["require","exports",
"module","ace/range","ace/lib/dom"],function(b,e,h){var k=b("../range").Range,r=b("../lib/dom");b=function(b){this.element=r.createElement("div");this.element.className="ace_layer ace_marker-layer";b.appendChild(this.element)};(function(){this.$padding=0;this.setPadding=function(b){this.$padding=b};this.setSession=function(b){this.session=b};this.setMarkers=function(b){this.markers=b};this.elt=function(b,d){var a=-1!=this.i&&this.element.childNodes[this.i];a?this.i++:(a=document.createElement("div"),
this.element.appendChild(a),this.i=-1);a.style.cssText=d;a.className=b};this.update=function(b){if(b){this.config=b;this.i=0;for(var d in this.markers){var a=this.markers[d];if(a.range){var c=a.range.clipRows(b.firstRow,b.lastRow);if(!c.isEmpty())if(c=c.toScreenRange(this.session),a.renderer){var e=this.$getTop(c.start.row,b);a.renderer(void 0,c,this.$padding+c.start.column*b.characterWidth,e,b)}else"fullLine"==a.type?this.drawFullLineMarker(void 0,c,a.clazz,b):"screenLine"==a.type?this.drawScreenLineMarker(void 0,
c,a.clazz,b):c.isMultiLine()?"text"==a.type?this.drawTextMarker(void 0,c,a.clazz,b):this.drawMultiLineMarker(void 0,c,a.clazz,b):this.drawSingleLineMarker(void 0,c,a.clazz+" ace_start ace_br15",b)}else a.update(void 0,this,this.session,b)}if(-1!=this.i)for(;this.i<this.element.childElementCount;)this.element.removeChild(this.element.lastChild)}};this.$getTop=function(b,d){return(b-d.firstRowScreen)*d.lineHeight};this.drawTextMarker=function(b,d,a,c,e){for(var f=this.session,g=d.start.row,p=d.end.row,
l=g,u,v=0,h=f.getScreenLastRowColumn(l),q=new k(l,d.start.column,l,v);l<=p;l++)q.start.row=q.end.row=l,q.start.column=l==g?d.start.column:f.getRowWrapIndent(l),q.end.column=h,u=v,v=h,h=l+1<p?f.getScreenLastRowColumn(l+1):l==p?0:d.end.column,this.drawSingleLineMarker(b,q,a+(l==g?" ace_start":"")+" ace_br"+((l==g||l==g+1&&d.start.column?1:0)|(u<v?2:0)|(v>h?4:0)|(l==p?8:0)),c,l==p?0:1,e)};this.drawMultiLineMarker=function(b,d,a,c,e){var f=this.$padding,g=c.lineHeight,k=this.$getTop(d.start.row,c),l=
f+d.start.column*c.characterWidth;e=e||"";this.session.$bidiHandler.isBidiRow(d.start.row)?(k=d.clone(),k.end.row=k.start.row,k.end.column=this.session.getLine(k.start.row).length,this.drawBidiSingleLineMarker(b,k,a+" ace_br1 ace_start",c,null,e)):this.elt(a+" ace_br1 ace_start","height:"+g+"px;right:0;top:"+k+"px;left:"+l+"px;"+(e||""));this.session.$bidiHandler.isBidiRow(d.end.row)?(k=d.clone(),k.start.row=k.end.row,k.start.column=0,this.drawBidiSingleLineMarker(b,k,a+" ace_br12",c,null,e)):(k=
this.$getTop(d.end.row,c),this.elt(a+" ace_br12","height:"+g+"px;width:"+d.end.column*c.characterWidth+"px;top:"+k+"px;left:"+f+"px;"+(e||"")));g=(d.end.row-d.start.row-1)*c.lineHeight;0>=g||(k=this.$getTop(d.start.row+1,c),b=(d.start.column?1:0)|(d.end.column?0:8),this.elt(a+(b?" ace_br"+b:""),"height:"+g+"px;right:0;top:"+k+"px;left:"+f+"px;"+(e||"")))};this.drawSingleLineMarker=function(b,d,a,c,e,k){if(this.session.$bidiHandler.isBidiRow(d.start.row))return this.drawBidiSingleLineMarker(b,d,a,
c,e,k);b=c.lineHeight;e=(d.end.column+(e||0)-d.start.column)*c.characterWidth;var f=this.$getTop(d.start.row,c);this.elt(a,"height:"+b+"px;width:"+e+"px;top:"+f+"px;left:"+(this.$padding+d.start.column*c.characterWidth)+"px;"+(k||""))};this.drawBidiSingleLineMarker=function(b,d,a,c,e,k){var f=c.lineHeight,g=this.$getTop(d.start.row,c),l=this.$padding;this.session.$bidiHandler.getSelections(d.start.column,d.end.column).forEach(function(b){this.elt(a,"height:"+f+"px;width:"+b.width+(e||0)+"px;top:"+
g+"px;left:"+(l+b.left)+"px;"+(k||""))},this)};this.drawFullLineMarker=function(b,d,a,c,e){b=this.$getTop(d.start.row,c);var f=c.lineHeight;d.start.row!=d.end.row&&(f+=this.$getTop(d.end.row,c)-b);this.elt(a,"height:"+f+"px;top:"+b+"px;left:0;right:0;"+(e||""))};this.drawScreenLineMarker=function(b,d,a,c,e){b=this.$getTop(d.start.row,c);this.elt(a,"height:"+c.lineHeight+"px;top:"+b+"px;left:0;right:0;"+(e||""))}}).call(b.prototype);e.Marker=b});ace.define("ace/layer/text","require exports module ace/lib/oop ace/lib/dom ace/lib/lang ace/layer/lines ace/lib/event_emitter".split(" "),
function(b,e,h){var k=b("../lib/oop"),r=b("../lib/dom"),g=b("../lib/lang"),d=b("./lines").Lines,a=b("../lib/event_emitter").EventEmitter;b=function(a){this.dom=r;this.element=this.dom.createElement("div");this.element.className="ace_layer ace_text-layer";a.appendChild(this.element);this.$updateEolChar=this.$updateEolChar.bind(this);this.$lines=new d(this.element)};(function(){k.implement(this,a);this.EOF_CHAR="\u00b6";this.EOL_CHAR_LF="\u00ac";this.EOL_CHAR_CRLF="\u00a4";this.EOL_CHAR=this.EOL_CHAR_LF;
this.TAB_CHAR="\u2014";this.SPACE_CHAR="\u00b7";this.$padding=0;this.MAX_LINE_LENGTH=1E4;this.$updateEolChar=function(){var a=this.session.doc;a="\n"==a.getNewLineCharacter()&&"windows"!=a.getNewLineMode()?this.EOL_CHAR_LF:this.EOL_CHAR_CRLF;if(this.EOL_CHAR!=a)return this.EOL_CHAR=a,!0};this.setPadding=function(a){this.$padding=a;this.element.style.margin="0 "+a+"px"};this.getLineHeight=function(){return this.$fontMetrics.$characterSize.height||0};this.getCharacterWidth=function(){return this.$fontMetrics.$characterSize.width||
0};this.$setFontMetrics=function(a){this.$fontMetrics=a;this.$fontMetrics.on("changeCharacterSize",function(a){this._signal("changeCharacterSize",a)}.bind(this));this.$pollSizeChanges()};this.checkForSizeChanges=function(){this.$fontMetrics.checkForSizeChanges()};this.$pollSizeChanges=function(){return this.$pollSizeChangesTimer=this.$fontMetrics.$pollSizeChanges()};this.setSession=function(a){(this.session=a)&&this.$computeTabString()};this.showEOL=this.showTabs=this.showSpaces=this.showInvisibles=
!1;this.setShowInvisibles=function(a){if(this.showInvisibles==a)return!1;this.showInvisibles=a;"string"==typeof a?(this.showSpaces=/tab/i.test(a),this.showTabs=/space/i.test(a),this.showEOL=/eol/i.test(a)):this.showSpaces=this.showTabs=this.showEOL=a;this.$computeTabString();return!0};this.displayIndentGuides=!0;this.setDisplayIndentGuides=function(a){if(this.displayIndentGuides==a)return!1;this.displayIndentGuides=a;this.$computeTabString();return!0};this.$tabStrings=[];this.onChangeTabSize=this.$computeTabString=
function(){var a=this.session.getTabSize();this.tabSize=a;for(var b=this.$tabStrings=[0],d=1;d<a+1;d++)if(this.showTabs){var e=this.dom.createElement("span");e.className="ace_invisible ace_invisible_tab";e.textContent=g.stringRepeat(this.TAB_CHAR,d);b.push(e)}else b.push(this.dom.createTextNode(g.stringRepeat(" ",d),this.element));if(this.displayIndentGuides){this.$indentGuideRe=/\s\S| \t|\t |\s$/;a=this.showSpaces?" ace_invisible ace_invisible_space":"";b=this.showSpaces?g.stringRepeat(this.SPACE_CHAR,
this.tabSize):g.stringRepeat(" ",this.tabSize);d=this.showTabs?" ace_invisible ace_invisible_tab":"";var k=this.showTabs?g.stringRepeat(this.TAB_CHAR,this.tabSize):b;e=this.dom.createElement("span");e.className="ace_indent-guide"+a;e.textContent=b;this.$tabStrings[" "]=e;e=this.dom.createElement("span");e.className="ace_indent-guide"+d;e.textContent=k;this.$tabStrings["\t"]=e}};this.updateLines=function(a,b,d){if(this.config.lastRow!=a.lastRow||this.config.firstRow!=a.firstRow)return this.update(a);
this.config=a;var c=Math.max(b,a.firstRow);b=Math.min(d,a.lastRow);var e=this.element.childNodes;d=0;for(var f=a.firstRow;f<c;f++){var g=this.session.getFoldLine(f);if(g)if(g.containsRow(c)){c=g.start.row;break}else f=g.end.row;d++}var v=!1;f=c;for(c=(g=this.session.getNextFoldLine(f))?g.start.row:Infinity;;){f>c&&(f=g.end.row+1,c=(g=this.session.getNextFoldLine(f,g))?g.start.row:Infinity);if(f>b)break;var k=e[d++];if(k){this.dom.removeChildren(k);this.$renderLine(k,f,f==c?g:!1);v&&(k.style.top=this.$lines.computeLineTop(f,
a,this.session)+"px");var q=a.lineHeight*this.session.getRowLength(f)+"px";k.style.height!=q&&(v=!0,k.style.height=q)}f++}if(v)for(;d<this.$lines.cells.length;)b=this.$lines.cells[d++],b.element.style.top=this.$lines.computeLineTop(b.row,a,this.session)+"px"};this.scrollLines=function(a){var b=this.config;this.config=a;if(this.$lines.pageChanged(b,a))return this.update(a);this.$lines.moveContainer(a);var c=a.lastRow,d=b?b.lastRow:-1;if(!b||d<a.firstRow||c<b.firstRow||!b||b.lastRow<a.firstRow||a.lastRow<
b.firstRow)return this.update(a);if(b.firstRow<a.firstRow)for(c=this.session.getFoldedRowCount(b.firstRow,a.firstRow-1);0<c;c--)this.$lines.shift();if(b.lastRow>a.lastRow)for(c=this.session.getFoldedRowCount(a.lastRow+1,b.lastRow);0<c;c--)this.$lines.pop();a.firstRow<b.firstRow&&this.$lines.unshift(this.$renderLinesFragment(a,a.firstRow,b.firstRow-1));a.lastRow>b.lastRow&&this.$lines.push(this.$renderLinesFragment(a,b.lastRow+1,a.lastRow))};this.$renderLinesFragment=function(a,b,d){for(var c=[],e=
this.session.getNextFoldLine(b),f=e?e.start.row:Infinity;;){b>f&&(b=e.end.row+1,f=(e=this.session.getNextFoldLine(b,e))?e.start.row:Infinity);if(b>d)break;var g=this.$lines.createCell(b,a,this.session),v=g.element;this.dom.removeChildren(v);r.setStyle(v.style,"height",this.$lines.computeLineHeight(b,a,this.session)+"px");r.setStyle(v.style,"top",this.$lines.computeLineTop(b,a,this.session)+"px");this.$renderLine(v,b,b==f?e:!1);this.$useLineGroups()?v.className="ace_line_group":v.className="ace_line";
c.push(g);b++}return c};this.update=function(a){this.$lines.moveContainer(a);this.config=a;for(var b=a.firstRow,c=a.lastRow,d=this.$lines;d.getLength();)d.pop();d.push(this.$renderLinesFragment(a,b,c))};this.$textToken={text:!0,rparen:!0,lparen:!0};this.$renderToken=function(a,b,d,e){for(var c=/(\t)|( +)|([\x00-\x1f\x80-\xa0\xad\u1680\u180E\u2000-\u200f\u2028\u2029\u202F\u205F\uFEFF\uFFF9-\uFFFC]+)|(\u3000)|([\u1100-\u115F\u11A3-\u11A7\u11FA-\u11FF\u2329-\u232A\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3001-\u303E\u3041-\u3096\u3099-\u30FF\u3105-\u312D\u3131-\u318E\u3190-\u31BA\u31C0-\u31E3\u31F0-\u321E\u3220-\u3247\u3250-\u32FE\u3300-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFAFF\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFF01-\uFF60\uFFE0-\uFFE6]|[\uD800-\uDBFF][\uDC00-\uDFFF])/g,
f=this.dom.createFragment(this.element),m,v=0;m=c.exec(e);){var k=m[1],q=m[2],n=m[3],h=m[4],w=m[5];if(this.showSpaces||!q){var r=v!=m.index?e.slice(v,m.index):"";v=m.index+m[0].length;r&&f.appendChild(this.dom.createTextNode(r,this.element));k?(q=this.session.getScreenTabSize(b+m.index),f.appendChild(this.$tabStrings[q].cloneNode(!0)),b+=q-1):q?this.showSpaces?(m=this.dom.createElement("span"),m.className="ace_invisible ace_invisible_space",m.textContent=g.stringRepeat(this.SPACE_CHAR,q.length),f.appendChild(m)):
f.appendChild(this.com.createTextNode(q,this.element)):n?(m=this.dom.createElement("span"),m.className="ace_invisible ace_invisible_space ace_invalid",m.textContent=g.stringRepeat(this.SPACE_CHAR,n.length),f.appendChild(m)):h?(b+=1,m=this.dom.createElement("span"),m.style.width=2*this.config.characterWidth+"px",m.className=this.showSpaces?"ace_cjk ace_invisible ace_invisible_space":"ace_cjk",m.textContent=this.showSpaces?this.SPACE_CHAR:h,f.appendChild(m)):w&&(b+=1,m=this.dom.createElement("span"),
m.style.width=2*this.config.characterWidth+"px",m.className="ace_cjk",m.textContent=w,f.appendChild(m))}}f.appendChild(this.dom.createTextNode(v?e.slice(v):e,this.element));this.$textToken[d.type]?a.appendChild(f):(c="ace_"+d.type.replace(/\./g," ace_"),m=this.dom.createElement("span"),"fold"==d.type&&(m.style.width=d.value.length*this.config.characterWidth+"px"),m.className=c,m.appendChild(f),a.appendChild(m));return b+e.length};this.renderIndentGuide=function(a,b,d){var c=b.search(this.$indentGuideRe);
if(0>=c||c>=d)return b;if(" "==b[0]){c-=c%this.tabSize;d=c/this.tabSize;for(var e=0;e<d;e++)a.appendChild(this.$tabStrings[" "].cloneNode(!0));return b.substr(c)}if("\t"==b[0]){for(e=0;e<c;e++)a.appendChild(this.$tabStrings["\t"].cloneNode(!0));return b.substr(c)}return b};this.$createLineElement=function(a){a=this.dom.createElement("div");a.className="ace_line";a.style.height=this.config.lineHeight+"px";return a};this.$renderWrappedLine=function(a,b,d){var c=0,e=0,f=d[0],k=0,v=this.$createLineElement();
a.appendChild(v);for(var h=0;h<b.length;h++){var q=b[h],n=q.value;if(0==h&&this.displayIndentGuides){c=n.length;n=this.renderIndentGuide(v,n,f);if(!n)continue;c-=n.length}if(c+n.length<f)k=this.$renderToken(v,k,q,n),c+=n.length;else{for(;c+n.length>=f;)this.$renderToken(v,k,q,n.substring(0,f-c)),n=n.substring(f-c),c=f,v=this.$createLineElement(),a.appendChild(v),v.appendChild(this.dom.createTextNode(g.stringRepeat("\u00a0",d.indent),this.element)),e++,k=0,f=d[e]||Number.MAX_VALUE;0!=n.length&&(c+=
n.length,k=this.$renderToken(v,k,q,n))}}d[d.length-1]>this.MAX_LINE_LENGTH&&this.$renderOverflowMessage(v,k,null,"",!0)};this.$renderSimpleLine=function(a,b){var c=0,d=b[0],e=d.value;this.displayIndentGuides&&(e=this.renderIndentGuide(a,e));e&&(c=this.$renderToken(a,c,d,e));for(var f=1;f<b.length;f++){d=b[f];e=d.value;if(c+e.length>this.MAX_LINE_LENGTH)return this.$renderOverflowMessage(a,c,d,e);c=this.$renderToken(a,c,d,e)}};this.$renderOverflowMessage=function(a,b,d,e,g){d&&this.$renderToken(a,
b,d,e.slice(0,this.MAX_LINE_LENGTH-b));b=this.dom.createElement("span");b.className="ace_inline_button ace_keyword ace_toggle_wrap";b.textContent=g?"<hide>":"<click to see more...>";a.appendChild(b)};this.$renderLine=function(a,b,d){d||0==d||(d=this.session.getFoldLine(b));var c=d?this.$getFoldLineTokens(b,d):this.session.getTokens(b),e=a;c.length?(e=this.session.getRowSplitData(b))&&e.length?(this.$renderWrappedLine(a,c,e),e=a.lastChild):(e=a,this.$useLineGroups()&&(e=this.$createLineElement(),a.appendChild(e)),
this.$renderSimpleLine(e,c)):this.$useLineGroups()&&(e=this.$createLineElement(),a.appendChild(e));this.showEOL&&e&&(d&&(b=d.end.row),a=this.dom.createElement("span"),a.className="ace_invisible ace_invisible_eol",a.textContent=b==this.session.getLength()-1?this.EOF_CHAR:this.EOL_CHAR,e.appendChild(a))};this.$getFoldLineTokens=function(a,b){var c=this.session,d=[],e=c.getTokens(a);b.walk(function(a,b,f,g,q){if(null!=a)d.push({type:"fold",value:a});else if(q&&(e=c.getTokens(b)),e.length)a:{a=e;for(q=
b=0;q+a[b].value.length<g;)if(q+=a[b].value.length,b++,b==a.length)break a;if(q!=g){var l=a[b].value.substring(g-q);l.length>f-g&&(l=l.substring(0,f-g));d.push({type:a[b].type,value:l});q=g+l.length;b+=1}for(;q<f&&b<a.length;)l=a[b].value,l.length+q>f?d.push({type:a[b].type,value:l.substring(0,f-q)}):d.push(a[b]),q+=l.length,b+=1}},b.end.row,this.session.getLine(b.end.row).length);return d};this.$useLineGroups=function(){return this.session.getUseWrapMode()};this.destroy=function(){}}).call(b.prototype);
e.Text=b});ace.define("ace/layer/cursor",["require","exports","module","ace/lib/dom"],function(b,e,h){var k=b("../lib/dom");b=function(b){this.element=k.createElement("div");this.element.className="ace_layer ace_cursor-layer";b.appendChild(this.element);this.isVisible=!1;this.isBlinking=!0;this.blinkInterval=1E3;this.smoothBlinking=!1;this.cursors=[];this.cursor=this.addCursor();k.addCssClass(this.element,"ace_hidden-cursors");this.$updateCursors=this.$updateOpacity.bind(this)};(function(){this.$updateOpacity=
function(b){for(var e=this.cursors,d=e.length;d--;)k.setStyle(e[d].style,"opacity",b?"":"0")};this.$startCssAnimation=function(){for(var b=this.cursors,e=b.length;e--;)b[e].style.animationDuration=this.blinkInterval+"ms";setTimeout(function(){k.addCssClass(this.element,"ace_animate-blinking")}.bind(this))};this.$stopCssAnimation=function(){k.removeCssClass(this.element,"ace_animate-blinking")};this.$padding=0;this.setPadding=function(b){this.$padding=b};this.setSession=function(b){this.session=b};
this.setBlinking=function(b){b!=this.isBlinking&&(this.isBlinking=b,this.restartTimer())};this.setBlinkInterval=function(b){b!=this.blinkInterval&&(this.blinkInterval=b,this.restartTimer())};this.setSmoothBlinking=function(b){b!=this.smoothBlinking&&(this.smoothBlinking=b,k.setCssClass(this.element,"ace_smooth-blinking",b),this.$updateCursors(!0),this.restartTimer())};this.addCursor=function(){var b=k.createElement("div");b.className="ace_cursor";this.element.appendChild(b);this.cursors.push(b);return b};
this.removeCursor=function(){if(1<this.cursors.length){var b=this.cursors.pop();b.parentNode.removeChild(b);return b}};this.hideCursor=function(){this.isVisible=!1;k.addCssClass(this.element,"ace_hidden-cursors");this.restartTimer()};this.showCursor=function(){this.isVisible=!0;k.removeCssClass(this.element,"ace_hidden-cursors");this.restartTimer()};this.restartTimer=function(){var b=this.$updateCursors;clearInterval(this.intervalId);clearTimeout(this.timeoutId);this.$stopCssAnimation();this.smoothBlinking&&
k.removeCssClass(this.element,"ace_smooth-blinking");b(!0);if(this.isBlinking&&this.blinkInterval&&this.isVisible)if(this.smoothBlinking&&setTimeout(function(){k.addCssClass(this.element,"ace_smooth-blinking")}.bind(this)),k.HAS_CSS_ANIMATION)this.$startCssAnimation();else{var e=function(){this.timeoutId=setTimeout(function(){b(!1)},.6*this.blinkInterval)}.bind(this);this.intervalId=setInterval(function(){b(!0);e()},this.blinkInterval);e()}else this.$stopCssAnimation()};this.getPixelPosition=function(b,
e){if(!this.config||!this.session)return{left:0,top:0};b||(b=this.session.selection.getCursor());var d=this.session.documentToScreenPosition(b);return{left:this.$padding+(this.session.$bidiHandler.isBidiRow(d.row,b.row)?this.session.$bidiHandler.getPosLeft(d.column):d.column*this.config.characterWidth),top:(d.row-(e?this.config.firstRowScreen:0))*this.config.lineHeight}};this.isCursorInView=function(b,e){return 0<=b.top&&b.top<e.maxHeight};this.update=function(b){this.config=b;var e=this.session.$selectionMarkers,
d=0;if(void 0===e||0===e.length)e=[{cursor:null}];var a=0;for(var c=e.length;a<c;a++){var f=this.getPixelPosition(e[a].cursor,!0);if(!((f.top>b.height+b.offset||0>f.top)&&1<a)){var h=this.cursors[d++]||this.addCursor(),m=h.style;this.drawCursor?this.drawCursor(h,f,b,e[a],this.session):this.isCursorInView(f,b)?(k.setStyle(m,"display","block"),k.translate(h,f.left,f.top),k.setStyle(m,"width",Math.round(b.characterWidth)+"px"),k.setStyle(m,"height",b.lineHeight+"px")):k.setStyle(m,"display","none")}}for(;this.cursors.length>
d;)this.removeCursor();b=this.session.getOverwrite();this.$setOverwrite(b);this.$pixelPos=f;this.restartTimer()};this.drawCursor=null;this.$setOverwrite=function(b){b!=this.overwrite&&((this.overwrite=b)?k.addCssClass(this.element,"ace_overwrite-cursors"):k.removeCssClass(this.element,"ace_overwrite-cursors"))};this.destroy=function(){clearInterval(this.intervalId);clearTimeout(this.timeoutId)}}).call(b.prototype);e.Cursor=b});ace.define("ace/scrollbar","require exports module ace/lib/oop ace/lib/dom ace/lib/event ace/lib/event_emitter".split(" "),
function(b,e,h){var k=b("./lib/oop"),r=b("./lib/dom"),g=b("./lib/event"),d=b("./lib/event_emitter").EventEmitter,a=function(a){this.element=r.createElement("div");this.element.className="ace_scrollbar ace_scrollbar"+this.classSuffix;this.inner=r.createElement("div");this.inner.className="ace_scrollbar-inner";this.inner.textContent="\u00a0";this.element.appendChild(this.inner);a.appendChild(this.element);this.setVisible(!1);this.skipEvent=!1;g.addListener(this.element,"scroll",this.onScroll.bind(this));
g.addListener(this.element,"mousedown",g.preventDefault)};(function(){k.implement(this,d);this.setVisible=function(a){this.element.style.display=a?"":"none";this.isVisible=a;this.coeff=1}}).call(a.prototype);b=function(b,d){a.call(this,b);this.scrollHeight=this.scrollTop=0;d.$scrollbarWidth=this.width=r.scrollbarWidth(b.ownerDocument);this.inner.style.width=this.element.style.width=(this.width||15)+5+"px";this.$minWidth=0};k.inherits(b,a);(function(){this.classSuffix="-v";this.onScroll=function(){if(!this.skipEvent){this.scrollTop=
this.element.scrollTop;if(1!=this.coeff){var a=this.element.clientHeight/this.scrollHeight;this.scrollTop=this.scrollTop*(1-a)/(this.coeff-a)}this._emit("scroll",{data:this.scrollTop})}this.skipEvent=!1};this.getWidth=function(){return Math.max(this.isVisible?this.width:0,this.$minWidth||0)};this.setHeight=function(a){this.element.style.height=a+"px"};this.setInnerHeight=this.setScrollHeight=function(a){this.scrollHeight=a;32768<a?(this.coeff=32768/a,a=32768):1!=this.coeff&&(this.coeff=1);this.inner.style.height=
a+"px"};this.setScrollTop=function(a){this.scrollTop!=a&&(this.skipEvent=!0,this.scrollTop=a,this.element.scrollTop=a*this.coeff)}}).call(b.prototype);h=function(b,d){a.call(this,b);this.scrollLeft=0;this.height=d.$scrollbarWidth;this.inner.style.height=this.element.style.height=(this.height||15)+5+"px"};k.inherits(h,a);(function(){this.classSuffix="-h";this.onScroll=function(){this.skipEvent||(this.scrollLeft=this.element.scrollLeft,this._emit("scroll",{data:this.scrollLeft}));this.skipEvent=!1};
this.getHeight=function(){return this.isVisible?this.height:0};this.setWidth=function(a){this.element.style.width=a+"px"};this.setInnerWidth=function(a){this.inner.style.width=a+"px"};this.setScrollWidth=function(a){this.inner.style.width=a+"px"};this.setScrollLeft=function(a){this.scrollLeft!=a&&(this.skipEvent=!0,this.scrollLeft=this.element.scrollLeft=a)}}).call(h.prototype);e.ScrollBar=b;e.ScrollBarV=b;e.ScrollBarH=h;e.VScrollBar=b;e.HScrollBar=h});ace.define("ace/renderloop",["require","exports",
"module","ace/lib/event"],function(b,e,h){var k=b("./lib/event");b=function(b,e){this.onRender=b;this.pending=!1;this.changes=0;this.$recursionLimit=2;this.window=e||window;var d=this;this._flush=function(a){d.pending=!1;if(a=d.changes)k.blockIdle(100),d.changes=0,d.onRender(a);d.changes?0>d.$recursionLimit--||d.schedule():d.$recursionLimit=2}};(function(){this.schedule=function(b){(this.changes|=b)&&!this.pending&&(k.nextFrame(this._flush),this.pending=!0)};this.clear=function(b){b=this.changes;
this.changes=0;return b}}).call(b.prototype);e.RenderLoop=b});ace.define("ace/layer/font_metrics","require exports module ace/lib/oop ace/lib/dom ace/lib/lang ace/lib/event ace/lib/useragent ace/lib/event_emitter".split(" "),function(b,e,h){var k=b("../lib/oop"),r=b("../lib/dom"),g=b("../lib/lang"),d=b("../lib/event"),a=b("../lib/useragent"),c=b("../lib/event_emitter").EventEmitter,f="function"==typeof ResizeObserver;b=e.FontMetrics=function(a){this.el=r.createElement("div");this.$setMeasureNodeStyles(this.el.style,
!0);this.$main=r.createElement("div");this.$setMeasureNodeStyles(this.$main.style);this.$measureNode=r.createElement("div");this.$setMeasureNodeStyles(this.$measureNode.style);this.el.appendChild(this.$main);this.el.appendChild(this.$measureNode);a.appendChild(this.el);this.$measureNode.textContent=g.stringRepeat("X",256);this.$characterSize={width:0,height:0};f?this.$addObserver():this.checkForSizeChanges()};(function(){k.implement(this,c);this.$characterSize={width:0,height:0};this.$setMeasureNodeStyles=
function(b,c){b.width=b.height="auto";b.left=b.top="0px";b.visibility="hidden";b.position="absolute";b.whiteSpace="pre";8>a.isIE?b["font-family"]="inherit":b.font="inherit";b.overflow=c?"hidden":"visible"};this.checkForSizeChanges=function(a){void 0===a&&(a=this.$measureSizes());if(a&&(this.$characterSize.width!==a.width||this.$characterSize.height!==a.height)){this.$measureNode.style.fontWeight="bold";var b=this.$measureSizes();this.$measureNode.style.fontWeight="";this.$characterSize=a;this.charSizes=
Object.create(null);this.allowBoldFonts=b&&b.width===a.width&&b.height===a.height;this._emit("changeCharacterSize",{data:a})}};this.$addObserver=function(){var a=this;this.$observer=new window.ResizeObserver(function(b){a.checkForSizeChanges()});this.$observer.observe(this.$measureNode)};this.$pollSizeChanges=function(){if(this.$pollSizeChangesTimer||this.$observer)return this.$pollSizeChangesTimer;var a=this;return this.$pollSizeChangesTimer=d.onIdle(function p(){a.checkForSizeChanges();d.onIdle(p,
500)},500)};this.setPolling=function(a){a?this.$pollSizeChanges():this.$pollSizeChangesTimer&&(clearInterval(this.$pollSizeChangesTimer),this.$pollSizeChangesTimer=0)};this.$measureSizes=function(a){a={height:(a||this.$measureNode).clientHeight,width:(a||this.$measureNode).clientWidth/256};return 0===a.width||0===a.height?null:a};this.$measureCharWidth=function(a){this.$main.textContent=g.stringRepeat(a,256);return this.$main.getBoundingClientRect().width/256};this.getCharacterWidth=function(a){var b=
this.charSizes[a];void 0===b&&(b=this.charSizes[a]=this.$measureCharWidth(a)/this.$characterSize.width);return b};this.destroy=function(){clearInterval(this.$pollSizeChangesTimer);this.$observer&&this.$observer.disconnect();this.el&&this.el.parentNode&&this.el.parentNode.removeChild(this.el)};this.$getZoom=function p(a){return a&&a.parentElement?(window.getComputedStyle(a).zoom||1)*p(a.parentElement):1};this.$initTransformMeasureNodes=function(){var a=function(a,b){return["div",{style:"position: absolute;top:"+
a+"px;left:"+b+"px;"}]};this.els=r.buildDom([a(0,0),a(200,0),a(0,200),a(200,200)],this.el)};this.transformCoordinates=function(a,b){function c(a,b,c){var d=a[1]*b[0]-a[0]*b[1];return[(-b[1]*c[0]+b[0]*c[1])/d,(+a[1]*c[0]-a[0]*c[1])/d]}function d(a,b){return[a[0]-b[0],a[1]-b[1]]}function e(a,b){return[a[0]+b[0],a[1]+b[1]]}function f(a,b){return[a*b[0],a*b[1]]}function g(a){a=a.getBoundingClientRect();return[a.left,a.top]}if(a){var n=this.$getZoom(this.el);a=f(1/n,a)}this.els||this.$initTransformMeasureNodes();
n=g(this.els[0]);var m=g(this.els[1]),k=g(this.els[2]),p=g(this.els[3]);p=c(d(p,m),d(p,k),d(e(m,k),e(p,n)));m=f(1+p[0],d(m,n));k=f(1+p[1],d(k,n));if(b)return a=p[0]*b[0]/200+p[1]*b[1]/200+1,b=e(f(b[0],m),f(b[1],k)),e(f(1/a/200,b),n);b=d(a,n);b=c(d(m,f(p[0],b)),d(k,f(p[1],b)),b);return f(200,b)}}).call(b.prototype)});ace.define("ace/virtual_renderer","require exports module ace/lib/oop ace/lib/dom ace/config ace/layer/gutter ace/layer/marker ace/layer/text ace/layer/cursor ace/scrollbar ace/scrollbar ace/renderloop ace/layer/font_metrics ace/lib/event_emitter ace/lib/useragent".split(" "),
function(b,e,h){var k=b("./lib/oop"),r=b("./lib/dom"),g=b("./config"),d=b("./layer/gutter").Gutter,a=b("./layer/marker").Marker,c=b("./layer/text").Text,f=b("./layer/cursor").Cursor,w=b("./scrollbar").HScrollBar,m=b("./scrollbar").VScrollBar,p=b("./renderloop").RenderLoop,l=b("./layer/font_metrics").FontMetrics,u=b("./lib/event_emitter").EventEmitter,v=b("./lib/useragent"),A=v.isIE;r.importCssString('.ace_br1 {border-top-left-radius    : 3px;}.ace_br2 {border-top-right-radius   : 3px;}.ace_br3 {border-top-left-radius    : 3px; border-top-right-radius:    3px;}.ace_br4 {border-bottom-right-radius: 3px;}.ace_br5 {border-top-left-radius    : 3px; border-bottom-right-radius: 3px;}.ace_br6 {border-top-right-radius   : 3px; border-bottom-right-radius: 3px;}.ace_br7 {border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px;}.ace_br8 {border-bottom-left-radius : 3px;}.ace_br9 {border-top-left-radius    : 3px; border-bottom-left-radius:  3px;}.ace_br10{border-top-right-radius   : 3px; border-bottom-left-radius:  3px;}.ace_br11{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-left-radius:  3px;}.ace_br12{border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br13{border-top-left-radius    : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br14{border-top-right-radius   : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br15{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px; border-bottom-left-radius: 3px;}.ace_editor {position: relative;overflow: hidden;padding: 0;font: 12px/normal \'Monaco\', \'Menlo\', \'Ubuntu Mono\', \'Consolas\', \'source-code-pro\', monospace;direction: ltr;text-align: left;-webkit-tap-highlight-color: rgba(0, 0, 0, 0);}.ace_scroller {position: absolute;overflow: hidden;top: 0;bottom: 0;background-color: inherit;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;cursor: text;}.ace_content {position: absolute;box-sizing: border-box;min-width: 100%;contain: style size layout;font-variant-ligatures: no-common-ligatures;}.ace_dragging .ace_scroller:before{position: absolute;top: 0;left: 0;right: 0;bottom: 0;content: \'\';background: rgba(250, 250, 250, 0.01);z-index: 1000;}.ace_dragging.ace_dark .ace_scroller:before{background: rgba(0, 0, 0, 0.01);}.ace_selecting, .ace_selecting * {cursor: text !important;}.ace_gutter {position: absolute;overflow : hidden;width: auto;top: 0;bottom: 0;left: 0;cursor: default;z-index: 4;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;contain: style size layout;}.ace_gutter-active-line {position: absolute;left: 0;right: 0;}.ace_scroller.ace_scroll-left {box-shadow: 17px 0 16px -16px rgba(0, 0, 0, 0.4) inset;}.ace_gutter-cell {position: absolute;top: 0;left: 0;right: 0;padding-left: 19px;padding-right: 6px;background-repeat: no-repeat;}.ace_gutter-cell.ace_error {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAABOFBMVEX/////////QRswFAb/Ui4wFAYwFAYwFAaWGAfDRymzOSH/PxswFAb/SiUwFAYwFAbUPRvjQiDllog5HhHdRybsTi3/Tyv9Tir+Syj/UC3////XurebMBIwFAb/RSHbPx/gUzfdwL3kzMivKBAwFAbbvbnhPx66NhowFAYwFAaZJg8wFAaxKBDZurf/RB6mMxb/SCMwFAYwFAbxQB3+RB4wFAb/Qhy4Oh+4QifbNRcwFAYwFAYwFAb/QRzdNhgwFAYwFAbav7v/Uy7oaE68MBK5LxLewr/r2NXewLswFAaxJw4wFAbkPRy2PyYwFAaxKhLm1tMwFAazPiQwFAaUGAb/QBrfOx3bvrv/VC/maE4wFAbRPBq6MRO8Qynew8Dp2tjfwb0wFAbx6eju5+by6uns4uH9/f36+vr/GkHjAAAAYnRSTlMAGt+64rnWu/bo8eAA4InH3+DwoN7j4eLi4xP99Nfg4+b+/u9B/eDs1MD1mO7+4PHg2MXa347g7vDizMLN4eG+Pv7i5evs/v79yu7S3/DV7/498Yv24eH+4ufQ3Ozu/v7+y13sRqwAAADLSURBVHjaZc/XDsFgGIBhtDrshlitmk2IrbHFqL2pvXf/+78DPokj7+Fz9qpU/9UXJIlhmPaTaQ6QPaz0mm+5gwkgovcV6GZzd5JtCQwgsxoHOvJO15kleRLAnMgHFIESUEPmawB9ngmelTtipwwfASilxOLyiV5UVUyVAfbG0cCPHig+GBkzAENHS0AstVF6bacZIOzgLmxsHbt2OecNgJC83JERmePUYq8ARGkJx6XtFsdddBQgZE2nPR6CICZhawjA4Fb/chv+399kfR+MMMDGOQAAAABJRU5ErkJggg==");background-repeat: no-repeat;background-position: 2px center;}.ace_gutter-cell.ace_warning {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAmVBMVEX///8AAAD///8AAAAAAABPSzb/5sAAAAB/blH/73z/ulkAAAAAAAD85pkAAAAAAAACAgP/vGz/rkDerGbGrV7/pkQICAf////e0IsAAAD/oED/qTvhrnUAAAD/yHD/njcAAADuv2r/nz//oTj/p064oGf/zHAAAAA9Nir/tFIAAAD/tlTiuWf/tkIAAACynXEAAAAAAAAtIRW7zBpBAAAAM3RSTlMAABR1m7RXO8Ln31Z36zT+neXe5OzooRDfn+TZ4p3h2hTf4t3k3ucyrN1K5+Xaks52Sfs9CXgrAAAAjklEQVR42o3PbQ+CIBQFYEwboPhSYgoYunIqqLn6/z8uYdH8Vmdnu9vz4WwXgN/xTPRD2+sgOcZjsge/whXZgUaYYvT8QnuJaUrjrHUQreGczuEafQCO/SJTufTbroWsPgsllVhq3wJEk2jUSzX3CUEDJC84707djRc5MTAQxoLgupWRwW6UB5fS++NV8AbOZgnsC7BpEAAAAABJRU5ErkJggg==");background-position: 2px center;}.ace_gutter-cell.ace_info {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAAAAAA6mKC9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAJ0Uk5TAAB2k804AAAAPklEQVQY02NgIB68QuO3tiLznjAwpKTgNyDbMegwisCHZUETUZV0ZqOquBpXj2rtnpSJT1AEnnRmL2OgGgAAIKkRQap2htgAAAAASUVORK5CYII=");background-position: 2px center;}.ace_dark .ace_gutter-cell.ace_info {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAAJFBMVEUAAAChoaGAgIAqKiq+vr6tra1ZWVmUlJSbm5s8PDxubm56enrdgzg3AAAAAXRSTlMAQObYZgAAAClJREFUeNpjYMAPdsMYHegyJZFQBlsUlMFVCWUYKkAZMxZAGdxlDMQBAG+TBP4B6RyJAAAAAElFTkSuQmCC");}.ace_scrollbar {contain: strict;position: absolute;right: 0;bottom: 0;z-index: 6;}.ace_scrollbar-inner {position: absolute;cursor: text;left: 0;top: 0;}.ace_scrollbar-v{overflow-x: hidden;overflow-y: scroll;top: 0;}.ace_scrollbar-h {overflow-x: scroll;overflow-y: hidden;left: 0;}.ace_print-margin {position: absolute;height: 100%;}.ace_text-input {position: absolute;z-index: 0;width: 0.5em;height: 1em;opacity: 0;background: transparent;-moz-appearance: none;appearance: none;border: none;resize: none;outline: none;overflow: hidden;font: inherit;padding: 0 1px;margin: 0 -1px;contain: strict;-ms-user-select: text;-moz-user-select: text;-webkit-user-select: text;user-select: text;white-space: pre!important;}.ace_text-input.ace_composition {background: transparent;color: inherit;z-index: 1000;opacity: 1;}.ace_composition_placeholder { color: transparent }.ace_composition_marker { border-bottom: 1px solid;position: absolute;border-radius: 0;margin-top: 1px;}[ace_nocontext=true] {transform: none!important;filter: none!important;clip-path: none!important;mask : none!important;contain: none!important;perspective: none!important;mix-blend-mode: initial!important;z-index: auto;}.ace_layer {z-index: 1;position: absolute;overflow: hidden;word-wrap: normal;white-space: pre;height: 100%;width: 100%;box-sizing: border-box;pointer-events: none;}.ace_gutter-layer {position: relative;width: auto;text-align: right;pointer-events: auto;height: 1000000px;contain: style size layout;}.ace_text-layer {font: inherit !important;position: absolute;height: 1000000px;width: 1000000px;contain: style size layout;}.ace_text-layer > .ace_line, .ace_text-layer > .ace_line_group {contain: style size layout;position: absolute;top: 0;left: 0;right: 0;}.ace_hidpi .ace_text-layer,.ace_hidpi .ace_gutter-layer,.ace_hidpi .ace_content,.ace_hidpi .ace_gutter {contain: strict;will-change: transform;}.ace_hidpi .ace_text-layer > .ace_line, .ace_hidpi .ace_text-layer > .ace_line_group {contain: strict;}.ace_cjk {display: inline-block;text-align: center;}.ace_cursor-layer {z-index: 4;}.ace_cursor {z-index: 4;position: absolute;box-sizing: border-box;border-left: 2px solid;transform: translatez(0);}.ace_multiselect .ace_cursor {border-left-width: 1px;}.ace_slim-cursors .ace_cursor {border-left-width: 1px;}.ace_overwrite-cursors .ace_cursor {border-left-width: 0;border-bottom: 1px solid;}.ace_hidden-cursors .ace_cursor {opacity: 0.2;}.ace_hasPlaceholder .ace_hidden-cursors .ace_cursor {opacity: 0;}.ace_smooth-blinking .ace_cursor {transition: opacity 0.18s;}.ace_animate-blinking .ace_cursor {animation-duration: 1000ms;animation-timing-function: step-end;animation-name: blink-ace-animate;animation-iteration-count: infinite;}.ace_animate-blinking.ace_smooth-blinking .ace_cursor {animation-duration: 1000ms;animation-timing-function: ease-in-out;animation-name: blink-ace-animate-smooth;}@keyframes blink-ace-animate {from, to { opacity: 1; }60% { opacity: 0; }}@keyframes blink-ace-animate-smooth {from, to { opacity: 1; }45% { opacity: 1; }60% { opacity: 0; }85% { opacity: 0; }}.ace_marker-layer .ace_step, .ace_marker-layer .ace_stack {position: absolute;z-index: 3;}.ace_marker-layer .ace_selection {position: absolute;z-index: 5;}.ace_marker-layer .ace_bracket {position: absolute;z-index: 6;}.ace_marker-layer .ace_error_bracket {position: absolute;border-bottom: 1px solid #DE5555;border-radius: 0;}.ace_marker-layer .ace_active-line {position: absolute;z-index: 2;}.ace_marker-layer .ace_selected-word {position: absolute;z-index: 4;box-sizing: border-box;}.ace_line .ace_fold {box-sizing: border-box;display: inline-block;height: 11px;margin-top: -2px;vertical-align: middle;background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACJJREFUeNpi+P//fxgTAwPDBxDxD078RSX+YeEyDFMCIMAAI3INmXiwf2YAAAAASUVORK5CYII=");background-repeat: no-repeat, repeat-x;background-position: center center, top left;color: transparent;border: 1px solid black;border-radius: 2px;cursor: pointer;pointer-events: auto;}.ace_dark .ace_fold {}.ace_fold:hover{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACBJREFUeNpi+P//fz4TAwPDZxDxD5X4i5fLMEwJgAADAEPVDbjNw87ZAAAAAElFTkSuQmCC");}.ace_tooltip {background-color: #FFF;background-image: linear-gradient(to bottom, transparent, rgba(0, 0, 0, 0.1));border: 1px solid gray;border-radius: 1px;box-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);color: black;max-width: 100%;padding: 3px 4px;position: fixed;z-index: 999999;box-sizing: border-box;cursor: default;white-space: pre;word-wrap: break-word;line-height: normal;font-style: normal;font-weight: normal;letter-spacing: normal;pointer-events: none;}.ace_folding-enabled > .ace_gutter-cell {padding-right: 13px;}.ace_fold-widget {box-sizing: border-box;margin: 0 -12px 0 1px;display: none;width: 11px;vertical-align: top;background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42mWKsQ0AMAzC8ixLlrzQjzmBiEjp0A6WwBCSPgKAXoLkqSot7nN3yMwR7pZ32NzpKkVoDBUxKAAAAABJRU5ErkJggg==");background-repeat: no-repeat;background-position: center;border-radius: 3px;border: 1px solid transparent;cursor: pointer;}.ace_folding-enabled .ace_fold-widget {display: inline-block;   }.ace_fold-widget.ace_end {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42m3HwQkAMAhD0YzsRchFKI7sAikeWkrxwScEB0nh5e7KTPWimZki4tYfVbX+MNl4pyZXejUO1QAAAABJRU5ErkJggg==");}.ace_fold-widget.ace_closed {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAGCAYAAAAG5SQMAAAAOUlEQVR42jXKwQkAMAgDwKwqKD4EwQ26sSOkVWjgIIHAzPiCgaqiqnJHZnKICBERHN194O5b9vbLuAVRL+l0YWnZAAAAAElFTkSuQmCCXA==");}.ace_fold-widget:hover {border: 1px solid rgba(0, 0, 0, 0.3);background-color: rgba(255, 255, 255, 0.2);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.7);}.ace_fold-widget:active {border: 1px solid rgba(0, 0, 0, 0.4);background-color: rgba(0, 0, 0, 0.05);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.8);}.ace_dark .ace_fold-widget {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHklEQVQIW2P4//8/AzoGEQ7oGCaLLAhWiSwB146BAQCSTPYocqT0AAAAAElFTkSuQmCC");}.ace_dark .ace_fold-widget.ace_end {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAH0lEQVQIW2P4//8/AxQ7wNjIAjDMgC4AxjCVKBirIAAF0kz2rlhxpAAAAABJRU5ErkJggg==");}.ace_dark .ace_fold-widget.ace_closed {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAFCAYAAACAcVaiAAAAHElEQVQIW2P4//+/AxAzgDADlOOAznHAKgPWAwARji8UIDTfQQAAAABJRU5ErkJggg==");}.ace_dark .ace_fold-widget:hover {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);background-color: rgba(255, 255, 255, 0.1);}.ace_dark .ace_fold-widget:active {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);}.ace_inline_button {border: 1px solid lightgray;display: inline-block;margin: -1px 8px;padding: 0 5px;pointer-events: auto;cursor: pointer;}.ace_inline_button:hover {border-color: gray;background: rgba(200,200,200,0.2);display: inline-block;pointer-events: auto;}.ace_fold-widget.ace_invalid {background-color: #FFB4B4;border-color: #DE5555;}.ace_fade-fold-widgets .ace_fold-widget {transition: opacity 0.4s ease 0.05s;opacity: 0;}.ace_fade-fold-widgets:hover .ace_fold-widget {transition: opacity 0.05s ease 0.05s;opacity:1;}.ace_underline {text-decoration: underline;}.ace_bold {font-weight: bold;}.ace_nobold .ace_bold {font-weight: normal;}.ace_italic {font-style: italic;}.ace_error-marker {background-color: rgba(255, 0, 0,0.2);position: absolute;z-index: 9;}.ace_highlight-marker {background-color: rgba(255, 255, 0,0.2);position: absolute;z-index: 8;}.ace_mobile-menu {position: absolute;line-height: 1.5;border-radius: 4px;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;background: white;box-shadow: 1px 3px 2px grey;border: 1px solid #dcdcdc;color: black;}.ace_dark > .ace_mobile-menu {background: #333;color: #ccc;box-shadow: 1px 3px 2px grey;border: 1px solid #444;}.ace_mobile-button {padding: 2px;cursor: pointer;overflow: hidden;}.ace_mobile-button:hover {background-color: #eee;opacity:1;}.ace_mobile-button:active {background-color: #ddd;}.ace_placeholder {font-family: arial;transform: scale(0.9);transform-origin: left;white-space: pre;opacity: 0.7;margin: 0 10px;}',
"ace_editor.css");b=function(b,e){var q=this;this.container=b||r.createElement("div");r.addCssClass(this.container,"ace_editor");r.HI_DPI&&r.addCssClass(this.container,"ace_hidpi");this.setTheme(e);this.$gutter=r.createElement("div");this.$gutter.className="ace_gutter";this.container.appendChild(this.$gutter);this.$gutter.setAttribute("aria-hidden",!0);this.scroller=r.createElement("div");this.scroller.className="ace_scroller";this.container.appendChild(this.scroller);this.content=r.createElement("div");
this.content.className="ace_content";this.scroller.appendChild(this.content);this.$gutterLayer=new d(this.$gutter);this.$gutterLayer.on("changeGutterWidth",this.onGutterResize.bind(this));this.$markerBack=new a(this.content);this.canvas=(this.$textLayer=new c(this.content)).element;this.$markerFront=new a(this.content);this.$cursorLayer=new f(this.content);this.$vScroll=this.$horizScroll=!1;this.scrollBar=this.scrollBarV=new m(this.container,this);this.scrollBarH=new w(this.container,this);this.scrollBarV.on("scroll",
function(a){q.$scrollAnimation||q.session.setScrollTop(a.data-q.scrollMargin.top)});this.scrollBarH.on("scroll",function(a){q.$scrollAnimation||q.session.setScrollLeft(a.data-q.scrollMargin.left)});this.scrollLeft=this.scrollTop=0;this.cursorPos={row:0,column:0};this.$fontMetrics=new l(this.container);this.$textLayer.$setFontMetrics(this.$fontMetrics);this.$textLayer.on("changeCharacterSize",function(a){q.updateCharacterSize();q.onResize(!0,q.gutterWidth,q.$size.width,q.$size.height);q._signal("changeCharacterSize",
a)});this.$size={width:0,height:0,scrollerHeight:0,scrollerWidth:0,$dirty:!0};this.layerConfig={width:1,padding:0,firstRow:0,firstRowScreen:0,lastRow:0,lineHeight:0,characterWidth:0,minHeight:1,maxHeight:1,offset:0,height:1,gutterOffset:1};this.scrollMargin={left:0,right:0,top:0,bottom:0,v:0,h:0};this.margin={left:0,right:0,top:0,bottom:0,v:0,h:0};this.$keepTextAreaAtCursor=!v.isIOS;this.$loop=new p(this.$renderChanges.bind(this),this.container.ownerDocument.defaultView);this.$loop.schedule(this.CHANGE_FULL);
this.updateCharacterSize();this.setPadding(4);g.resetOptions(this);g._signal("renderer",this)};(function(){this.CHANGE_CURSOR=1;this.CHANGE_MARKER=2;this.CHANGE_GUTTER=4;this.CHANGE_SCROLL=8;this.CHANGE_LINES=16;this.CHANGE_TEXT=32;this.CHANGE_SIZE=64;this.CHANGE_MARKER_BACK=128;this.CHANGE_MARKER_FRONT=256;this.CHANGE_FULL=512;this.CHANGE_H_SCROLL=1024;k.implement(this,u);this.updateCharacterSize=function(){this.$textLayer.allowBoldFonts!=this.$allowBoldFonts&&(this.$allowBoldFonts=this.$textLayer.allowBoldFonts,
this.setStyle("ace_nobold",!this.$allowBoldFonts));this.layerConfig.characterWidth=this.characterWidth=this.$textLayer.getCharacterWidth();this.layerConfig.lineHeight=this.lineHeight=this.$textLayer.getLineHeight();this.$updatePrintMargin();r.setStyle(this.scroller.style,"line-height",this.lineHeight+"px")};this.setSession=function(a){this.session&&this.session.doc.off("changeNewLineMode",this.onChangeNewLineMode);(this.session=a)&&this.scrollMargin.top&&0>=a.getScrollTop()&&a.setScrollTop(-this.scrollMargin.top);
this.$cursorLayer.setSession(a);this.$markerBack.setSession(a);this.$markerFront.setSession(a);this.$gutterLayer.setSession(a);this.$textLayer.setSession(a);a&&(this.$loop.schedule(this.CHANGE_FULL),this.session.$setFontMetrics(this.$fontMetrics),this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null,this.onChangeNewLineMode=this.onChangeNewLineMode.bind(this),this.onChangeNewLineMode(),this.session.doc.on("changeNewLineMode",this.onChangeNewLineMode))};this.updateLines=function(a,b,c){void 0===
b&&(b=Infinity);this.$changedLines?(this.$changedLines.firstRow>a&&(this.$changedLines.firstRow=a),this.$changedLines.lastRow<b&&(this.$changedLines.lastRow=b)):this.$changedLines={firstRow:a,lastRow:b};if(this.$changedLines.lastRow<this.layerConfig.firstRow)if(c)this.$changedLines.lastRow=this.layerConfig.lastRow;else return;this.$changedLines.firstRow>this.layerConfig.lastRow||this.$loop.schedule(this.CHANGE_LINES)};this.onChangeNewLineMode=function(){this.$loop.schedule(this.CHANGE_TEXT);this.$textLayer.$updateEolChar();
this.session.$bidiHandler.setEolChar(this.$textLayer.EOL_CHAR)};this.onChangeTabSize=function(){this.$loop.schedule(this.CHANGE_TEXT|this.CHANGE_MARKER);this.$textLayer.onChangeTabSize()};this.updateText=function(){this.$loop.schedule(this.CHANGE_TEXT)};this.updateFull=function(a){a?this.$renderChanges(this.CHANGE_FULL,!0):this.$loop.schedule(this.CHANGE_FULL)};this.updateFontSize=function(){this.$textLayer.checkForSizeChanges()};this.$changes=0;this.$updateSizeAsync=function(){if(this.$loop.pending)this.$size.$dirty=
!0;else this.onResize()};this.onResize=function(a,b,c,d){if(!(2<this.resizing)){0<this.resizing?this.resizing++:this.resizing=a?1:0;var e=this.container;d||(d=e.clientHeight||e.scrollHeight);c||(c=e.clientWidth||e.scrollWidth);b=this.$updateCachedSize(a,b,c,d);if(!this.$size.scrollerHeight||!c&&!d)return this.resizing=0;a&&(this.$gutterLayer.$padding=null);a?this.$renderChanges(b|this.$changes,!0):this.$loop.schedule(b|this.$changes);this.resizing&&(this.resizing=0);this.scrollBarV.scrollLeft=this.scrollBarV.scrollTop=
null}};this.$updateCachedSize=function(a,b,c,d){d-=this.$extraHeight||0;var e=0,f=this.$size,g={width:f.width,height:f.height,scrollerHeight:f.scrollerHeight,scrollerWidth:f.scrollerWidth};d&&(a||f.height!=d)&&(f.height=d,e|=this.CHANGE_SIZE,f.scrollerHeight=f.height,this.$horizScroll&&(f.scrollerHeight-=this.scrollBarH.getHeight()),this.scrollBarV.element.style.bottom=this.scrollBarH.getHeight()+"px",e|=this.CHANGE_SCROLL);c&&(a||f.width!=c)&&(e|=this.CHANGE_SIZE,f.width=c,null==b&&(b=this.$showGutter?
this.$gutter.offsetWidth:0),this.gutterWidth=b,r.setStyle(this.scrollBarH.element.style,"left",b+"px"),r.setStyle(this.scroller.style,"left",b+this.margin.left+"px"),f.scrollerWidth=Math.max(0,c-b-this.scrollBarV.getWidth()-this.margin.h),r.setStyle(this.$gutter.style,"left",this.margin.left+"px"),b=this.scrollBarV.getWidth()+"px",r.setStyle(this.scrollBarH.element.style,"right",b),r.setStyle(this.scroller.style,"right",b),r.setStyle(this.scroller.style,"bottom",this.scrollBarH.getHeight()),this.session&&
this.session.getUseWrapMode()&&this.adjustWrapLimit()||a)&&(e|=this.CHANGE_FULL);f.$dirty=!c||!d;e&&this._signal("resize",g);return e};this.onGutterResize=function(a){a=this.$showGutter?a:0;a!=this.gutterWidth&&(this.$changes|=this.$updateCachedSize(!0,a,this.$size.width,this.$size.height));this.session.getUseWrapMode()&&this.adjustWrapLimit()?this.$loop.schedule(this.CHANGE_FULL):this.$size.$dirty?this.$loop.schedule(this.CHANGE_FULL):this.$computeLayerConfig()};this.adjustWrapLimit=function(){return this.session.adjustWrapLimit(Math.floor((this.$size.scrollerWidth-
2*this.$padding)/this.characterWidth),this.$showPrintMargin&&this.$printMarginColumn)};this.setAnimatedScroll=function(a){this.setOption("animatedScroll",a)};this.getAnimatedScroll=function(){return this.$animatedScroll};this.setShowInvisibles=function(a){this.setOption("showInvisibles",a);this.session.$bidiHandler.setShowInvisibles(a)};this.getShowInvisibles=function(){return this.getOption("showInvisibles")};this.getDisplayIndentGuides=function(){return this.getOption("displayIndentGuides")};this.setDisplayIndentGuides=
function(a){this.setOption("displayIndentGuides",a)};this.setShowPrintMargin=function(a){this.setOption("showPrintMargin",a)};this.getShowPrintMargin=function(){return this.getOption("showPrintMargin")};this.setPrintMarginColumn=function(a){this.setOption("printMarginColumn",a)};this.getPrintMarginColumn=function(){return this.getOption("printMarginColumn")};this.getShowGutter=function(){return this.getOption("showGutter")};this.setShowGutter=function(a){return this.setOption("showGutter",a)};this.getFadeFoldWidgets=
function(){return this.getOption("fadeFoldWidgets")};this.setFadeFoldWidgets=function(a){this.setOption("fadeFoldWidgets",a)};this.setHighlightGutterLine=function(a){this.setOption("highlightGutterLine",a)};this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")};this.$updatePrintMargin=function(){if(this.$showPrintMargin||this.$printMarginEl){if(!this.$printMarginEl){var a=r.createElement("div");a.className="ace_layer ace_print-margin-layer";this.$printMarginEl=r.createElement("div");
this.$printMarginEl.className="ace_print-margin";a.appendChild(this.$printMarginEl);this.content.insertBefore(a,this.content.firstChild)}a=this.$printMarginEl.style;a.left=Math.round(this.characterWidth*this.$printMarginColumn+this.$padding)+"px";a.visibility=this.$showPrintMargin?"visible":"hidden";this.session&&-1==this.session.$wrap&&this.adjustWrapLimit()}};this.getContainerElement=function(){return this.container};this.getMouseEventTarget=function(){return this.scroller};this.getTextAreaContainer=
function(){return this.container};this.$moveTextAreaToCursor=function(){if(!this.$isMousePressed){var a=this.textarea.style,b=this.$composition;if(this.$keepTextAreaAtCursor||b){var c=this.$cursorLayer.$pixelPos;if(c){b&&b.markerRange&&(c=this.$cursorLayer.getPixelPosition(b.markerRange.start,!0));var d=this.layerConfig,e=c.top;c=c.left;e-=d.offset;var f=b&&b.useTextareaForIME?this.lineHeight:A?0:1;if(0>e||e>d.height-f)r.translate(this.textarea,0,0);else{d=1;var g=this.$size.height-f;b?b.useTextareaForIME?
d=this.characterWidth*this.session.$getStringScreenWidth(this.textarea.value)[0]:e+=this.lineHeight+2:e+=this.lineHeight;c-=this.scrollLeft;c>this.$size.scrollerWidth-d&&(c=this.$size.scrollerWidth-d);c+=this.gutterWidth+this.margin.left;r.setStyle(a,"height",f+"px");r.setStyle(a,"width",d+"px");r.translate(this.textarea,Math.min(c,this.$size.scrollerWidth-d),Math.min(e,g))}}}else r.translate(this.textarea,-100,0)}};this.getFirstVisibleRow=function(){return this.layerConfig.firstRow};this.getFirstFullyVisibleRow=
function(){return this.layerConfig.firstRow+(0===this.layerConfig.offset?0:1)};this.getLastFullyVisibleRow=function(){var a=this.layerConfig,b=a.lastRow;return this.session.documentToScreenRow(b,0)*a.lineHeight-this.session.getScrollTop()>a.height-a.lineHeight?b-1:b};this.getLastVisibleRow=function(){return this.layerConfig.lastRow};this.$padding=null;this.setPadding=function(a){this.$padding=a;this.$textLayer.setPadding(a);this.$cursorLayer.setPadding(a);this.$markerFront.setPadding(a);this.$markerBack.setPadding(a);
this.$loop.schedule(this.CHANGE_FULL);this.$updatePrintMargin()};this.setScrollMargin=function(a,b,c,d){var e=this.scrollMargin;e.top=a|0;e.bottom=b|0;e.right=d|0;e.left=c|0;e.v=e.top+e.bottom;e.h=e.left+e.right;e.top&&0>=this.scrollTop&&this.session&&this.session.setScrollTop(-e.top);this.updateFull()};this.setMargin=function(a,b,c,d){var e=this.margin;e.top=a|0;e.bottom=b|0;e.right=d|0;e.left=c|0;e.v=e.top+e.bottom;e.h=e.left+e.right;this.$updateCachedSize(!0,this.gutterWidth,this.$size.width,this.$size.height);
this.updateFull()};this.getHScrollBarAlwaysVisible=function(){return this.$hScrollBarAlwaysVisible};this.setHScrollBarAlwaysVisible=function(a){this.setOption("hScrollBarAlwaysVisible",a)};this.getVScrollBarAlwaysVisible=function(){return this.$vScrollBarAlwaysVisible};this.setVScrollBarAlwaysVisible=function(a){this.setOption("vScrollBarAlwaysVisible",a)};this.$updateScrollBarV=function(){var a=this.layerConfig.maxHeight,b=this.$size.scrollerHeight;!this.$maxLines&&this.$scrollPastEnd&&(a-=(b-this.lineHeight)*
this.$scrollPastEnd,this.scrollTop>a-b&&(a=this.scrollTop+b,this.scrollBarV.scrollTop=null));this.scrollBarV.setScrollHeight(a+this.scrollMargin.v);this.scrollBarV.setScrollTop(this.scrollTop+this.scrollMargin.top)};this.$updateScrollBarH=function(){this.scrollBarH.setScrollWidth(this.layerConfig.width+2*this.$padding+this.scrollMargin.h);this.scrollBarH.setScrollLeft(this.scrollLeft+this.scrollMargin.left)};this.$frozen=!1;this.freeze=function(){this.$frozen=!0};this.unfreeze=function(){this.$frozen=
!1};this.$renderChanges=function(a,b){this.$changes&&(a|=this.$changes,this.$changes=0);if(this.session&&this.container.offsetWidth&&!this.$frozen&&(a||b)){if(this.$size.$dirty)return this.$changes|=a,this.onResize(!0);this.lineHeight||this.$textLayer.checkForSizeChanges();this._signal("beforeRender",a);this.session&&this.session.$bidiHandler&&this.session.$bidiHandler.updateCharacterWidths(this.$fontMetrics);b=this.layerConfig;if(a&this.CHANGE_FULL||a&this.CHANGE_SIZE||a&this.CHANGE_TEXT||a&this.CHANGE_LINES||
a&this.CHANGE_SCROLL||a&this.CHANGE_H_SCROLL){a|=this.$computeLayerConfig()|this.$loop.clear();b.firstRow!=this.layerConfig.firstRow&&b.firstRowScreen==this.layerConfig.firstRowScreen&&(b=this.scrollTop+(b.firstRow-this.layerConfig.firstRow)*this.lineHeight,0<b&&(this.scrollTop=b,a|=this.CHANGE_SCROLL,a|=this.$computeLayerConfig()|this.$loop.clear()));b=this.layerConfig;this.$updateScrollBarV();a&this.CHANGE_H_SCROLL&&this.$updateScrollBarH();r.translate(this.content,-this.scrollLeft,-b.offset);var c=
b.minHeight+"px";r.setStyle(this.content.style,"width",b.width+2*this.$padding+"px");r.setStyle(this.content.style,"height",c)}a&this.CHANGE_H_SCROLL&&(r.translate(this.content,-this.scrollLeft,-b.offset),this.scroller.className=0>=this.scrollLeft?"ace_scroller":"ace_scroller ace_scroll-left");a&this.CHANGE_FULL?(this.$changedLines=null,this.$textLayer.update(b),this.$showGutter&&this.$gutterLayer.update(b),this.$markerBack.update(b),this.$markerFront.update(b),this.$cursorLayer.update(b),this.$moveTextAreaToCursor()):
a&this.CHANGE_SCROLL?(this.$changedLines=null,a&this.CHANGE_TEXT||a&this.CHANGE_LINES?this.$textLayer.update(b):this.$textLayer.scrollLines(b),this.$showGutter&&(a&this.CHANGE_GUTTER||a&this.CHANGE_LINES?this.$gutterLayer.update(b):this.$gutterLayer.scrollLines(b)),this.$markerBack.update(b),this.$markerFront.update(b),this.$cursorLayer.update(b),this.$moveTextAreaToCursor()):(a&this.CHANGE_TEXT?(this.$changedLines=null,this.$textLayer.update(b),this.$showGutter&&this.$gutterLayer.update(b)):a&this.CHANGE_LINES?
(this.$updateLines()||a&this.CHANGE_GUTTER&&this.$showGutter)&&this.$gutterLayer.update(b):a&this.CHANGE_TEXT||a&this.CHANGE_GUTTER?this.$showGutter&&this.$gutterLayer.update(b):a&this.CHANGE_CURSOR&&this.$highlightGutterLine&&this.$gutterLayer.updateLineHighlight(b),a&this.CHANGE_CURSOR&&(this.$cursorLayer.update(b),this.$moveTextAreaToCursor()),a&(this.CHANGE_MARKER|this.CHANGE_MARKER_FRONT)&&this.$markerFront.update(b),a&(this.CHANGE_MARKER|this.CHANGE_MARKER_BACK)&&this.$markerBack.update(b));
this._signal("afterRender",a)}else this.$changes|=a};this.$autosize=function(){var a=this.session.getScreenLength()*this.lineHeight,b=this.$maxLines*this.lineHeight,c=Math.min(b,Math.max((this.$minLines||1)*this.lineHeight,a))+this.scrollMargin.v+(this.$extraHeight||0);this.$horizScroll&&(c+=this.scrollBarH.getHeight());this.$maxPixelHeight&&c>this.$maxPixelHeight&&(c=this.$maxPixelHeight);a=!(c<=2*this.lineHeight)&&a>b;if(c!=this.desiredHeight||this.$size.height!=this.desiredHeight||a!=this.$vScroll)a!=
this.$vScroll&&(this.$vScroll=a,this.scrollBarV.setVisible(a)),a=this.container.clientWidth,this.container.style.height=c+"px",this.$updateCachedSize(!0,this.$gutterWidth,a,c),this.desiredHeight=c,this._signal("autosize")};this.$computeLayerConfig=function(){var a=this.session,b=this.$size,c=b.height<=2*this.lineHeight,d=this.session.getScreenLength()*this.lineHeight,e=this.$getLongestLine(),f=!c&&(this.$hScrollBarAlwaysVisible||0>b.scrollerWidth-e-2*this.$padding),g=this.$horizScroll!==f;g&&(this.$horizScroll=
f,this.scrollBarH.setVisible(f));var l=this.$vScroll;this.$maxLines&&1<this.lineHeight&&this.$autosize();f=b.scrollerHeight+this.lineHeight;var v=!this.$maxLines&&this.$scrollPastEnd?(b.scrollerHeight-this.lineHeight)*this.$scrollPastEnd:0;d+=v;var m=this.scrollMargin;this.session.setScrollTop(Math.max(-m.top,Math.min(this.scrollTop,d-b.scrollerHeight+m.bottom)));this.session.setScrollLeft(Math.max(-m.left,Math.min(this.scrollLeft,e+2*this.$padding-b.scrollerWidth+m.right)));v=!c&&(this.$vScrollBarAlwaysVisible||
0>b.scrollerHeight-d+v||this.scrollTop>m.top);if(c=l!==v)this.$vScroll=v,this.scrollBarV.setVisible(v);var k=this.scrollTop%this.lineHeight;l=Math.max(0,Math.round((this.scrollTop-k)/this.lineHeight));v=l+(Math.ceil(f/this.lineHeight)-1);m=this.lineHeight;l=a.screenToDocumentRow(l,0);if(f=a.getFoldLine(l))l=f.start.row;var p=a.documentToScreenRow(l,0);f=a.getRowLength(l)*m;v=Math.min(a.screenToDocumentRow(v,0),a.getLength()-1);f=b.scrollerHeight+a.getRowLength(v)*m+f;k=this.scrollTop-p*m;a=0;if(this.layerConfig.width!=
e||g)a=this.CHANGE_H_SCROLL;if(g||c)a|=this.$updateCachedSize(!0,this.gutterWidth,b.width,b.height),this._signal("scrollbarVisibilityChanged"),c&&(e=this.$getLongestLine());this.layerConfig={width:e,padding:this.$padding,firstRow:l,firstRowScreen:p,lastRow:v,lineHeight:m,characterWidth:this.characterWidth,minHeight:f,maxHeight:d,offset:k,gutterOffset:m?Math.max(0,Math.ceil((k+b.height-b.scrollerHeight)/m)):0,height:this.$size.scrollerHeight};this.session.$bidiHandler&&this.session.$bidiHandler.setContentWidth(e-
this.$padding);return a};this.$updateLines=function(){if(this.$changedLines){var a=this.$changedLines.firstRow,b=this.$changedLines.lastRow;this.$changedLines=null;var c=this.layerConfig;if(!(a>c.lastRow+1||b<c.firstRow))if(Infinity===b)this.$showGutter&&this.$gutterLayer.update(c),this.$textLayer.update(c);else return this.$textLayer.updateLines(c,a,b),!0}};this.$getLongestLine=function(){var a=this.session.getScreenWidth();this.showInvisibles&&!this.session.$useWrapMode&&(a+=1);this.$textLayer&&
a>this.$textLayer.MAX_LINE_LENGTH&&(a=this.$textLayer.MAX_LINE_LENGTH+30);return Math.max(this.$size.scrollerWidth-2*this.$padding,Math.round(a*this.characterWidth))};this.updateFrontMarkers=function(){this.$markerFront.setMarkers(this.session.getMarkers(!0));this.$loop.schedule(this.CHANGE_MARKER_FRONT)};this.updateBackMarkers=function(){this.$markerBack.setMarkers(this.session.getMarkers());this.$loop.schedule(this.CHANGE_MARKER_BACK)};this.addGutterDecoration=function(a,b){this.$gutterLayer.addGutterDecoration(a,
b)};this.removeGutterDecoration=function(a,b){this.$gutterLayer.removeGutterDecoration(a,b)};this.updateBreakpoints=function(a){this.$loop.schedule(this.CHANGE_GUTTER)};this.setAnnotations=function(a){this.$gutterLayer.setAnnotations(a);this.$loop.schedule(this.CHANGE_GUTTER)};this.updateCursor=function(){this.$loop.schedule(this.CHANGE_CURSOR)};this.hideCursor=function(){this.$cursorLayer.hideCursor()};this.showCursor=function(){this.$cursorLayer.showCursor()};this.scrollSelectionIntoView=function(a,
b,c){this.scrollCursorIntoView(a,c);this.scrollCursorIntoView(b,c)};this.scrollCursorIntoView=function(a,b,c){if(0!==this.$size.scrollerHeight){var d=this.$cursorLayer.getPixelPosition(a);a=d.left;d=d.top;var e=c&&c.top||0;c=c&&c.bottom||0;var f=this.$scrollAnimation?this.session.getScrollTop():this.scrollTop;f+e>d?(b&&f+e>d+this.lineHeight&&(d-=b*this.$size.scrollerHeight),0===d&&(d=-this.scrollMargin.top),this.session.setScrollTop(d)):f+this.$size.scrollerHeight-c<d+this.lineHeight&&(b&&f+this.$size.scrollerHeight-
c<d-this.lineHeight&&(d+=b*this.$size.scrollerHeight),this.session.setScrollTop(d+this.lineHeight+c-this.$size.scrollerHeight));b=this.scrollLeft;b>a?(a<this.$padding+2*this.layerConfig.characterWidth&&(a=-this.scrollMargin.left),this.session.setScrollLeft(a)):b+this.$size.scrollerWidth<a+this.characterWidth?this.session.setScrollLeft(Math.round(a+this.characterWidth-this.$size.scrollerWidth)):b<=this.$padding&&a-b<this.characterWidth&&this.session.setScrollLeft(0)}};this.getScrollTop=function(){return this.session.getScrollTop()};
this.getScrollLeft=function(){return this.session.getScrollLeft()};this.getScrollTopRow=function(){return this.scrollTop/this.lineHeight};this.getScrollBottomRow=function(){return Math.max(0,Math.floor((this.scrollTop+this.$size.scrollerHeight)/this.lineHeight)-1)};this.scrollToRow=function(a){this.session.setScrollTop(a*this.lineHeight)};this.alignCursor=function(a,b){"number"==typeof a&&(a={row:a,column:0});a=this.$cursorLayer.getPixelPosition(a).top-(this.$size.scrollerHeight-this.lineHeight)*
(b||0);this.session.setScrollTop(a);return a};this.STEPS=8;this.$calcSteps=function(a,b){var c,d=this.STEPS,e=[];for(c=0;c<d;++c)e.push((b-a)*(Math.pow(c/this.STEPS-1,3)+1)+a);return e};this.scrollToLine=function(a,b,c,d){a=this.$cursorLayer.getPixelPosition({row:a,column:0}).top;b&&(a-=this.$size.scrollerHeight/2);b=this.scrollTop;this.session.setScrollTop(a);!1!==c&&this.animateScrolling(b,d)};this.animateScrolling=function(a,b){var c=this.scrollTop;if(this.$animatedScroll){var d=this;if(a!=c){if(this.$scrollAnimation){var e=
this.$scrollAnimation.steps;if(e.length&&(a=e[0],a==c))return}var f=d.$calcSteps(a,c);this.$scrollAnimation={from:a,to:c,steps:f};clearInterval(this.$timer);d.session.setScrollTop(f.shift());d.session.$scrollTop=c;this.$timer=setInterval(function(){if(!d.session)return clearInterval(d.$timer);f.length?(d.session.setScrollTop(f.shift()),d.session.$scrollTop=c):null!=c?(d.session.$scrollTop=-1,d.session.setScrollTop(c),c=null):(d.$timer=clearInterval(d.$timer),d.$scrollAnimation=null,b&&b())},10)}}};
this.scrollToY=function(a){this.scrollTop!==a&&(this.$loop.schedule(this.CHANGE_SCROLL),this.scrollTop=a)};this.scrollToX=function(a){this.scrollLeft!==a&&(this.scrollLeft=a);this.$loop.schedule(this.CHANGE_H_SCROLL)};this.scrollTo=function(a,b){this.session.setScrollTop(b);this.session.setScrollLeft(b)};this.scrollBy=function(a,b){b&&this.session.setScrollTop(this.session.getScrollTop()+b);a&&this.session.setScrollLeft(this.session.getScrollLeft()+a)};this.isScrollableBy=function(a,b){if(0>b&&this.session.getScrollTop()>=
1-this.scrollMargin.top||0<b&&this.session.getScrollTop()+this.$size.scrollerHeight-this.layerConfig.maxHeight<-1+this.scrollMargin.bottom||0>a&&this.session.getScrollLeft()>=1-this.scrollMargin.left||0<a&&this.session.getScrollLeft()+this.$size.scrollerWidth-this.layerConfig.width<-1+this.scrollMargin.right)return!0};this.pixelToScreenCoordinates=function(a,b){if(this.$hasCssTransforms){var c={top:0,left:0};b=this.$fontMetrics.transformCoordinates([a,b]);a=b[1]-this.gutterWidth-this.margin.left;
b=b[0]}else c=this.scroller.getBoundingClientRect();a=a+this.scrollLeft-c.left-this.$padding;var d=a/this.characterWidth,e=this.$blockCursor?Math.floor(d):Math.round(d);return{row:Math.floor((b+this.scrollTop-c.top)/this.lineHeight),column:e,side:0<d-e?1:-1,offsetX:a}};this.screenToTextCoordinates=function(a,b){if(this.$hasCssTransforms){var c={top:0,left:0};b=this.$fontMetrics.transformCoordinates([a,b]);a=b[1]-this.gutterWidth-this.margin.left;b=b[0]}else c=this.scroller.getBoundingClientRect();
a=a+this.scrollLeft-c.left-this.$padding;var d=a/this.characterWidth;return this.session.screenToDocumentPosition(Math.floor((b+this.scrollTop-c.top)/this.lineHeight),Math.max(this.$blockCursor?Math.floor(d):Math.round(d),0),a)};this.textToScreenCoordinates=function(a,b){var c=this.scroller.getBoundingClientRect();b=this.session.documentToScreenPosition(a,b);a=this.$padding+(this.session.$bidiHandler.isBidiRow(b.row,a)?this.session.$bidiHandler.getPosLeft(b.column):Math.round(b.column*this.characterWidth));
return{pageX:c.left+a-this.scrollLeft,pageY:c.top+b.row*this.lineHeight-this.scrollTop}};this.visualizeFocus=function(){r.addCssClass(this.container,"ace_focus")};this.visualizeBlur=function(){r.removeCssClass(this.container,"ace_focus")};this.showComposition=function(a){this.$composition=a;a.cssText||(a.cssText=this.textarea.style.cssText);void 0==a.useTextareaForIME&&(a.useTextareaForIME=this.$useTextareaForIME);this.$useTextareaForIME?(r.addCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText=
"",this.$moveTextAreaToCursor(),this.$cursorLayer.element.style.display="none"):a.markerId=this.session.addMarker(a.markerRange,"ace_composition_marker","text")};this.setCompositionText=function(a){var b=this.session.selection.cursor;this.addToken(a,"composition_placeholder",b.row,b.column);this.$moveTextAreaToCursor()};this.hideComposition=function(){if(this.$composition){this.$composition.markerId&&this.session.removeMarker(this.$composition.markerId);r.removeCssClass(this.textarea,"ace_composition");
this.textarea.style.cssText=this.$composition.cssText;var a=this.session.selection.cursor;this.removeExtraToken(a.row,a.column);this.$composition=null;this.$cursorLayer.element.style.display=""}};this.addToken=function(a,b,c,d){var e=this.session;e.bgTokenizer.lines[c]=null;a={type:b,value:a};e=e.getTokens(c);if(null==d)e.push(a);else{var f=0;for(b=0;b<e.length;b++){var g=e[b];f+=g.value.length;if(d<=f){f=g.value.length-(f-d);d=g.value.slice(0,f);f=g.value.slice(f);e.splice(b,1,{type:g.type,value:d},
a,{type:g.type,value:f});break}}}this.updateLines(c,c)};this.removeExtraToken=function(a,b){this.updateLines(a,a)};this.setTheme=function(a,b){function c(c){if(d.$themeId!=a)return b&&b();if(!c||!c.cssClass)throw Error("couldn't load module "+a+" or it didn't call define");c.$id&&(d.$themeId=c.$id);r.importCssString(c.cssText,c.cssClass,d.container);d.theme&&r.removeCssClass(d.container,d.theme.cssClass);var e="padding"in c?c.padding:"padding"in(d.theme||{})?4:d.$padding;d.$padding&&e!=d.$padding&&
d.setPadding(e);d.$theme=c.cssClass;d.theme=c;r.addCssClass(d.container,c.cssClass);r.setCssClass(d.container,"ace_dark",c.isDark);d.$size&&(d.$size.width=0,d.$updateSizeAsync());d._dispatchEvent("themeLoaded",{theme:c});b&&b()}var d=this;this.$themeId=a;d._dispatchEvent("themeChange",{theme:a});a&&"string"!=typeof a?c(a):g.loadModule(["theme",a||this.$options.theme.initialValue],c)};this.getTheme=function(){return this.$themeId};this.setStyle=function(a,b){r.setCssClass(this.container,a,!1!==b)};
this.unsetStyle=function(a){r.removeCssClass(this.container,a)};this.setCursorStyle=function(a){r.setStyle(this.scroller.style,"cursor",a)};this.setMouseCursor=function(a){r.setStyle(this.scroller.style,"cursor",a)};this.attachToShadowRoot=function(){r.importCssString('.ace_br1 {border-top-left-radius    : 3px;}.ace_br2 {border-top-right-radius   : 3px;}.ace_br3 {border-top-left-radius    : 3px; border-top-right-radius:    3px;}.ace_br4 {border-bottom-right-radius: 3px;}.ace_br5 {border-top-left-radius    : 3px; border-bottom-right-radius: 3px;}.ace_br6 {border-top-right-radius   : 3px; border-bottom-right-radius: 3px;}.ace_br7 {border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px;}.ace_br8 {border-bottom-left-radius : 3px;}.ace_br9 {border-top-left-radius    : 3px; border-bottom-left-radius:  3px;}.ace_br10{border-top-right-radius   : 3px; border-bottom-left-radius:  3px;}.ace_br11{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-left-radius:  3px;}.ace_br12{border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br13{border-top-left-radius    : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br14{border-top-right-radius   : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br15{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px; border-bottom-left-radius: 3px;}.ace_editor {position: relative;overflow: hidden;padding: 0;font: 12px/normal \'Monaco\', \'Menlo\', \'Ubuntu Mono\', \'Consolas\', \'source-code-pro\', monospace;direction: ltr;text-align: left;-webkit-tap-highlight-color: rgba(0, 0, 0, 0);}.ace_scroller {position: absolute;overflow: hidden;top: 0;bottom: 0;background-color: inherit;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;cursor: text;}.ace_content {position: absolute;box-sizing: border-box;min-width: 100%;contain: style size layout;font-variant-ligatures: no-common-ligatures;}.ace_dragging .ace_scroller:before{position: absolute;top: 0;left: 0;right: 0;bottom: 0;content: \'\';background: rgba(250, 250, 250, 0.01);z-index: 1000;}.ace_dragging.ace_dark .ace_scroller:before{background: rgba(0, 0, 0, 0.01);}.ace_selecting, .ace_selecting * {cursor: text !important;}.ace_gutter {position: absolute;overflow : hidden;width: auto;top: 0;bottom: 0;left: 0;cursor: default;z-index: 4;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;contain: style size layout;}.ace_gutter-active-line {position: absolute;left: 0;right: 0;}.ace_scroller.ace_scroll-left {box-shadow: 17px 0 16px -16px rgba(0, 0, 0, 0.4) inset;}.ace_gutter-cell {position: absolute;top: 0;left: 0;right: 0;padding-left: 19px;padding-right: 6px;background-repeat: no-repeat;}.ace_gutter-cell.ace_error {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAABOFBMVEX/////////QRswFAb/Ui4wFAYwFAYwFAaWGAfDRymzOSH/PxswFAb/SiUwFAYwFAbUPRvjQiDllog5HhHdRybsTi3/Tyv9Tir+Syj/UC3////XurebMBIwFAb/RSHbPx/gUzfdwL3kzMivKBAwFAbbvbnhPx66NhowFAYwFAaZJg8wFAaxKBDZurf/RB6mMxb/SCMwFAYwFAbxQB3+RB4wFAb/Qhy4Oh+4QifbNRcwFAYwFAYwFAb/QRzdNhgwFAYwFAbav7v/Uy7oaE68MBK5LxLewr/r2NXewLswFAaxJw4wFAbkPRy2PyYwFAaxKhLm1tMwFAazPiQwFAaUGAb/QBrfOx3bvrv/VC/maE4wFAbRPBq6MRO8Qynew8Dp2tjfwb0wFAbx6eju5+by6uns4uH9/f36+vr/GkHjAAAAYnRSTlMAGt+64rnWu/bo8eAA4InH3+DwoN7j4eLi4xP99Nfg4+b+/u9B/eDs1MD1mO7+4PHg2MXa347g7vDizMLN4eG+Pv7i5evs/v79yu7S3/DV7/498Yv24eH+4ufQ3Ozu/v7+y13sRqwAAADLSURBVHjaZc/XDsFgGIBhtDrshlitmk2IrbHFqL2pvXf/+78DPokj7+Fz9qpU/9UXJIlhmPaTaQ6QPaz0mm+5gwkgovcV6GZzd5JtCQwgsxoHOvJO15kleRLAnMgHFIESUEPmawB9ngmelTtipwwfASilxOLyiV5UVUyVAfbG0cCPHig+GBkzAENHS0AstVF6bacZIOzgLmxsHbt2OecNgJC83JERmePUYq8ARGkJx6XtFsdddBQgZE2nPR6CICZhawjA4Fb/chv+399kfR+MMMDGOQAAAABJRU5ErkJggg==");background-repeat: no-repeat;background-position: 2px center;}.ace_gutter-cell.ace_warning {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAmVBMVEX///8AAAD///8AAAAAAABPSzb/5sAAAAB/blH/73z/ulkAAAAAAAD85pkAAAAAAAACAgP/vGz/rkDerGbGrV7/pkQICAf////e0IsAAAD/oED/qTvhrnUAAAD/yHD/njcAAADuv2r/nz//oTj/p064oGf/zHAAAAA9Nir/tFIAAAD/tlTiuWf/tkIAAACynXEAAAAAAAAtIRW7zBpBAAAAM3RSTlMAABR1m7RXO8Ln31Z36zT+neXe5OzooRDfn+TZ4p3h2hTf4t3k3ucyrN1K5+Xaks52Sfs9CXgrAAAAjklEQVR42o3PbQ+CIBQFYEwboPhSYgoYunIqqLn6/z8uYdH8Vmdnu9vz4WwXgN/xTPRD2+sgOcZjsge/whXZgUaYYvT8QnuJaUrjrHUQreGczuEafQCO/SJTufTbroWsPgsllVhq3wJEk2jUSzX3CUEDJC84707djRc5MTAQxoLgupWRwW6UB5fS++NV8AbOZgnsC7BpEAAAAABJRU5ErkJggg==");background-position: 2px center;}.ace_gutter-cell.ace_info {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAAAAAA6mKC9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAJ0Uk5TAAB2k804AAAAPklEQVQY02NgIB68QuO3tiLznjAwpKTgNyDbMegwisCHZUETUZV0ZqOquBpXj2rtnpSJT1AEnnRmL2OgGgAAIKkRQap2htgAAAAASUVORK5CYII=");background-position: 2px center;}.ace_dark .ace_gutter-cell.ace_info {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAAJFBMVEUAAAChoaGAgIAqKiq+vr6tra1ZWVmUlJSbm5s8PDxubm56enrdgzg3AAAAAXRSTlMAQObYZgAAAClJREFUeNpjYMAPdsMYHegyJZFQBlsUlMFVCWUYKkAZMxZAGdxlDMQBAG+TBP4B6RyJAAAAAElFTkSuQmCC");}.ace_scrollbar {contain: strict;position: absolute;right: 0;bottom: 0;z-index: 6;}.ace_scrollbar-inner {position: absolute;cursor: text;left: 0;top: 0;}.ace_scrollbar-v{overflow-x: hidden;overflow-y: scroll;top: 0;}.ace_scrollbar-h {overflow-x: scroll;overflow-y: hidden;left: 0;}.ace_print-margin {position: absolute;height: 100%;}.ace_text-input {position: absolute;z-index: 0;width: 0.5em;height: 1em;opacity: 0;background: transparent;-moz-appearance: none;appearance: none;border: none;resize: none;outline: none;overflow: hidden;font: inherit;padding: 0 1px;margin: 0 -1px;contain: strict;-ms-user-select: text;-moz-user-select: text;-webkit-user-select: text;user-select: text;white-space: pre!important;}.ace_text-input.ace_composition {background: transparent;color: inherit;z-index: 1000;opacity: 1;}.ace_composition_placeholder { color: transparent }.ace_composition_marker { border-bottom: 1px solid;position: absolute;border-radius: 0;margin-top: 1px;}[ace_nocontext=true] {transform: none!important;filter: none!important;clip-path: none!important;mask : none!important;contain: none!important;perspective: none!important;mix-blend-mode: initial!important;z-index: auto;}.ace_layer {z-index: 1;position: absolute;overflow: hidden;word-wrap: normal;white-space: pre;height: 100%;width: 100%;box-sizing: border-box;pointer-events: none;}.ace_gutter-layer {position: relative;width: auto;text-align: right;pointer-events: auto;height: 1000000px;contain: style size layout;}.ace_text-layer {font: inherit !important;position: absolute;height: 1000000px;width: 1000000px;contain: style size layout;}.ace_text-layer > .ace_line, .ace_text-layer > .ace_line_group {contain: style size layout;position: absolute;top: 0;left: 0;right: 0;}.ace_hidpi .ace_text-layer,.ace_hidpi .ace_gutter-layer,.ace_hidpi .ace_content,.ace_hidpi .ace_gutter {contain: strict;will-change: transform;}.ace_hidpi .ace_text-layer > .ace_line, .ace_hidpi .ace_text-layer > .ace_line_group {contain: strict;}.ace_cjk {display: inline-block;text-align: center;}.ace_cursor-layer {z-index: 4;}.ace_cursor {z-index: 4;position: absolute;box-sizing: border-box;border-left: 2px solid;transform: translatez(0);}.ace_multiselect .ace_cursor {border-left-width: 1px;}.ace_slim-cursors .ace_cursor {border-left-width: 1px;}.ace_overwrite-cursors .ace_cursor {border-left-width: 0;border-bottom: 1px solid;}.ace_hidden-cursors .ace_cursor {opacity: 0.2;}.ace_hasPlaceholder .ace_hidden-cursors .ace_cursor {opacity: 0;}.ace_smooth-blinking .ace_cursor {transition: opacity 0.18s;}.ace_animate-blinking .ace_cursor {animation-duration: 1000ms;animation-timing-function: step-end;animation-name: blink-ace-animate;animation-iteration-count: infinite;}.ace_animate-blinking.ace_smooth-blinking .ace_cursor {animation-duration: 1000ms;animation-timing-function: ease-in-out;animation-name: blink-ace-animate-smooth;}@keyframes blink-ace-animate {from, to { opacity: 1; }60% { opacity: 0; }}@keyframes blink-ace-animate-smooth {from, to { opacity: 1; }45% { opacity: 1; }60% { opacity: 0; }85% { opacity: 0; }}.ace_marker-layer .ace_step, .ace_marker-layer .ace_stack {position: absolute;z-index: 3;}.ace_marker-layer .ace_selection {position: absolute;z-index: 5;}.ace_marker-layer .ace_bracket {position: absolute;z-index: 6;}.ace_marker-layer .ace_error_bracket {position: absolute;border-bottom: 1px solid #DE5555;border-radius: 0;}.ace_marker-layer .ace_active-line {position: absolute;z-index: 2;}.ace_marker-layer .ace_selected-word {position: absolute;z-index: 4;box-sizing: border-box;}.ace_line .ace_fold {box-sizing: border-box;display: inline-block;height: 11px;margin-top: -2px;vertical-align: middle;background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACJJREFUeNpi+P//fxgTAwPDBxDxD078RSX+YeEyDFMCIMAAI3INmXiwf2YAAAAASUVORK5CYII=");background-repeat: no-repeat, repeat-x;background-position: center center, top left;color: transparent;border: 1px solid black;border-radius: 2px;cursor: pointer;pointer-events: auto;}.ace_dark .ace_fold {}.ace_fold:hover{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACBJREFUeNpi+P//fz4TAwPDZxDxD5X4i5fLMEwJgAADAEPVDbjNw87ZAAAAAElFTkSuQmCC");}.ace_tooltip {background-color: #FFF;background-image: linear-gradient(to bottom, transparent, rgba(0, 0, 0, 0.1));border: 1px solid gray;border-radius: 1px;box-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);color: black;max-width: 100%;padding: 3px 4px;position: fixed;z-index: 999999;box-sizing: border-box;cursor: default;white-space: pre;word-wrap: break-word;line-height: normal;font-style: normal;font-weight: normal;letter-spacing: normal;pointer-events: none;}.ace_folding-enabled > .ace_gutter-cell {padding-right: 13px;}.ace_fold-widget {box-sizing: border-box;margin: 0 -12px 0 1px;display: none;width: 11px;vertical-align: top;background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42mWKsQ0AMAzC8ixLlrzQjzmBiEjp0A6WwBCSPgKAXoLkqSot7nN3yMwR7pZ32NzpKkVoDBUxKAAAAABJRU5ErkJggg==");background-repeat: no-repeat;background-position: center;border-radius: 3px;border: 1px solid transparent;cursor: pointer;}.ace_folding-enabled .ace_fold-widget {display: inline-block;   }.ace_fold-widget.ace_end {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42m3HwQkAMAhD0YzsRchFKI7sAikeWkrxwScEB0nh5e7KTPWimZki4tYfVbX+MNl4pyZXejUO1QAAAABJRU5ErkJggg==");}.ace_fold-widget.ace_closed {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAGCAYAAAAG5SQMAAAAOUlEQVR42jXKwQkAMAgDwKwqKD4EwQ26sSOkVWjgIIHAzPiCgaqiqnJHZnKICBERHN194O5b9vbLuAVRL+l0YWnZAAAAAElFTkSuQmCCXA==");}.ace_fold-widget:hover {border: 1px solid rgba(0, 0, 0, 0.3);background-color: rgba(255, 255, 255, 0.2);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.7);}.ace_fold-widget:active {border: 1px solid rgba(0, 0, 0, 0.4);background-color: rgba(0, 0, 0, 0.05);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.8);}.ace_dark .ace_fold-widget {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHklEQVQIW2P4//8/AzoGEQ7oGCaLLAhWiSwB146BAQCSTPYocqT0AAAAAElFTkSuQmCC");}.ace_dark .ace_fold-widget.ace_end {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAH0lEQVQIW2P4//8/AxQ7wNjIAjDMgC4AxjCVKBirIAAF0kz2rlhxpAAAAABJRU5ErkJggg==");}.ace_dark .ace_fold-widget.ace_closed {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAFCAYAAACAcVaiAAAAHElEQVQIW2P4//+/AxAzgDADlOOAznHAKgPWAwARji8UIDTfQQAAAABJRU5ErkJggg==");}.ace_dark .ace_fold-widget:hover {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);background-color: rgba(255, 255, 255, 0.1);}.ace_dark .ace_fold-widget:active {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);}.ace_inline_button {border: 1px solid lightgray;display: inline-block;margin: -1px 8px;padding: 0 5px;pointer-events: auto;cursor: pointer;}.ace_inline_button:hover {border-color: gray;background: rgba(200,200,200,0.2);display: inline-block;pointer-events: auto;}.ace_fold-widget.ace_invalid {background-color: #FFB4B4;border-color: #DE5555;}.ace_fade-fold-widgets .ace_fold-widget {transition: opacity 0.4s ease 0.05s;opacity: 0;}.ace_fade-fold-widgets:hover .ace_fold-widget {transition: opacity 0.05s ease 0.05s;opacity:1;}.ace_underline {text-decoration: underline;}.ace_bold {font-weight: bold;}.ace_nobold .ace_bold {font-weight: normal;}.ace_italic {font-style: italic;}.ace_error-marker {background-color: rgba(255, 0, 0,0.2);position: absolute;z-index: 9;}.ace_highlight-marker {background-color: rgba(255, 255, 0,0.2);position: absolute;z-index: 8;}.ace_mobile-menu {position: absolute;line-height: 1.5;border-radius: 4px;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;background: white;box-shadow: 1px 3px 2px grey;border: 1px solid #dcdcdc;color: black;}.ace_dark > .ace_mobile-menu {background: #333;color: #ccc;box-shadow: 1px 3px 2px grey;border: 1px solid #444;}.ace_mobile-button {padding: 2px;cursor: pointer;overflow: hidden;}.ace_mobile-button:hover {background-color: #eee;opacity:1;}.ace_mobile-button:active {background-color: #ddd;}.ace_placeholder {font-family: arial;transform: scale(0.9);transform-origin: left;white-space: pre;opacity: 0.7;margin: 0 10px;}',
"ace_editor.css",this.container)};this.destroy=function(){this.freeze();this.$fontMetrics.destroy();this.$cursorLayer.destroy();this.removeAllListeners();this.container.textContent=""}}).call(b.prototype);g.defineOptions(b.prototype,"renderer",{animatedScroll:{initialValue:!1},showInvisibles:{set:function(a){this.$textLayer.setShowInvisibles(a)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!1},showPrintMargin:{set:function(){this.$updatePrintMargin()},initialValue:!0},printMarginColumn:{set:function(){this.$updatePrintMargin()},
initialValue:80},printMargin:{set:function(a){"number"==typeof a&&(this.$printMarginColumn=a);this.$showPrintMargin=!!a;this.$updatePrintMargin()},get:function(){return this.$showPrintMargin&&this.$printMarginColumn}},showGutter:{set:function(a){this.$gutter.style.display=a?"block":"none";this.$loop.schedule(this.CHANGE_FULL);this.onGutterResize()},initialValue:!0},fadeFoldWidgets:{set:function(a){r.setCssClass(this.$gutter,"ace_fade-fold-widgets",a)},initialValue:!1},showFoldWidgets:{set:function(a){this.$gutterLayer.setShowFoldWidgets(a);
this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},displayIndentGuides:{set:function(a){this.$textLayer.setDisplayIndentGuides(a)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!0},highlightGutterLine:{set:function(a){this.$gutterLayer.setHighlightGutterLine(a);this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},hScrollBarAlwaysVisible:{set:function(a){this.$hScrollBarAlwaysVisible&&this.$horizScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},vScrollBarAlwaysVisible:{set:function(a){this.$vScrollBarAlwaysVisible&&
this.$vScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},fontSize:{set:function(a){"number"==typeof a&&(a+="px");this.container.style.fontSize=a;this.updateFontSize()},initialValue:12},fontFamily:{set:function(a){this.container.style.fontFamily=a;this.updateFontSize()}},maxLines:{set:function(a){this.updateFull()}},minLines:{set:function(a){562949953421311>this.$minLines||(this.$minLines=0);this.updateFull()}},maxPixelHeight:{set:function(a){this.updateFull()},initialValue:0},scrollPastEnd:{set:function(a){a=
+a||0;this.$scrollPastEnd!=a&&(this.$scrollPastEnd=a,this.$loop.schedule(this.CHANGE_SCROLL))},initialValue:0,handlesSet:!0},fixedWidthGutter:{set:function(a){this.$gutterLayer.$fixedWidth=!!a;this.$loop.schedule(this.CHANGE_GUTTER)}},theme:{set:function(a){this.setTheme(a)},get:function(){return this.$themeId||this.theme},initialValue:"./theme/textmate",handlesSet:!0},hasCssTransforms:{},useTextareaForIME:{initialValue:!v.isMobile&&!v.isIE}});e.VirtualRenderer=b});ace.define("ace/worker/worker_client",
"require exports module ace/lib/oop ace/lib/net ace/lib/event_emitter ace/config".split(" "),function(b,e,h){function k(a){a="importScripts('"+d.qualifyURL(a)+"');";try{return new Blob([a],{type:"application/javascript"})}catch(p){var b=new (window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder);b.append(a);return b.getBlob("application/javascript")}}function r(a){return"undefined"==typeof Worker?{postMessage:function(){},terminate:function(){}}:c.get("loadWorkerFromBlob")?(a=k(a),a=
(window.URL||window.webkitURL).createObjectURL(a),new Worker(a)):new Worker(a)}var g=b("../lib/oop"),d=b("../lib/net"),a=b("../lib/event_emitter").EventEmitter,c=b("../config"),f=function(a){a.postMessage||(a=this.$createWorkerFromOldConfig.apply(this,arguments));this.$worker=a;this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this);this.changeListener=this.changeListener.bind(this);this.onMessage=this.onMessage.bind(this);this.callbackId=1;this.callbacks={};this.$worker.onmessage=this.onMessage};(function(){g.implement(this,
a);this.$createWorkerFromOldConfig=function(a,d,e,f,g){b.nameToUrl&&!b.toUrl&&(b.toUrl=b.nameToUrl);if(c.get("packaged")||!b.toUrl)f=f||c.moduleUrl(d,"worker");else{var l=this.$normalizePath;f=f||l(b.toUrl("ace/worker/worker.js",null,"_"));var m={};a.forEach(function(a){m[a]=l(b.toUrl(a,null,"_").replace(/(\.js)?(\?.*)?$/,""))})}this.$worker=r(f);g&&this.send("importScripts",g);this.$worker.postMessage({init:!0,tlns:m,module:d,classname:e});return this.$worker};this.onMessage=function(a){a=a.data;
switch(a.type){case "event":this._signal(a.name,{data:a.data});break;case "call":var b=this.callbacks[a.id];b&&(b(a.data),delete this.callbacks[a.id]);break;case "error":this.reportError(a.data);break;case "log":window.console&&console.log&&console.log.apply(console,a.data)}};this.reportError=function(a){window.console&&console.error&&console.error(a)};this.$normalizePath=function(a){return d.qualifyURL(a)};this.terminate=function(){this._signal("terminate",{});this.deltaQueue=null;this.$worker.terminate();
this.$worker=null;this.$doc&&this.$doc.off("change",this.changeListener);this.$doc=null};this.send=function(a,b){this.$worker.postMessage({command:a,args:b})};this.call=function(a,b,c){if(c){var d=this.callbackId++;this.callbacks[d]=c;b.push(d)}this.send(a,b)};this.emit=function(a,b){try{b.data&&b.data.err&&(b.data.err={message:b.data.err.message,stack:b.data.err.stack,code:b.data.err.code}),this.$worker.postMessage({event:a,data:{data:b.data}})}catch(p){console.error(p.stack)}};this.attachToDocument=
function(a){this.$doc&&this.terminate();this.$doc=a;this.call("setValue",[a.getValue()]);a.on("change",this.changeListener)};this.changeListener=function(a){this.deltaQueue||(this.deltaQueue=[],setTimeout(this.$sendDeltaQueue,0));"insert"==a.action?this.deltaQueue.push(a.start,a.lines):this.deltaQueue.push(a.start,a.end)};this.$sendDeltaQueue=function(){var a=this.deltaQueue;a&&(this.deltaQueue=null,50<a.length&&a.length>this.$doc.getLength()>>1?this.call("setValue",[this.$doc.getValue()]):this.emit("change",
{data:a}))}}).call(f.prototype);e.UIWorkerClient=function(b,d,e){var g=null,m=!1,v=Object.create(a),k=[],q=new f({messageBuffer:k,terminate:function(){},postMessage:function(a){k.push(a);g&&(m?setTimeout(n):n())}});q.setEmitSync=function(a){m=a};var n=function(){var a=k.shift();a.command?g[a.command].apply(g,a.args):a.event&&v._signal(a.event,a.data)};v.postMessage=function(a){q.onMessage({data:a})};v.callback=function(a,b){this.postMessage({type:"call",id:b,data:a})};v.emit=function(a,b){this.postMessage({type:"event",
name:a,data:b})};c.loadModule(["worker",d],function(a){for(g=new a[e](v);k.length;)n()});return q};e.WorkerClient=f;e.createWorker=r});ace.define("ace/placeholder","require exports module ace/range ace/lib/event_emitter ace/lib/oop".split(" "),function(b,e,h){var k=b("./range").Range,r=b("./lib/event_emitter").EventEmitter,g=b("./lib/oop");b=function(b,a,c,e,g,m){var d=this;this.length=a;this.session=b;this.doc=b.getDocument();this.mainClass=g;this.othersClass=m;this.$onUpdate=this.onUpdate.bind(this);
this.doc.on("change",this.$onUpdate);this.$others=e;this.$onCursorChange=function(){setTimeout(function(){d.onCursorChange()})};this.$pos=c;this.$undoStackDepth=(b.getUndoManager().$undoStack||b.getUndoManager().$undostack||{length:-1}).length;this.setup();b.selection.on("changeCursor",this.$onCursorChange)};(function(){g.implement(this,r);this.setup=function(){var b=this,a=this.doc,c=this.session;this.selectionBefore=c.selection.toJSON();c.selection.inMultiSelectMode&&c.selection.toSingleRange();
var e=this.pos=a.createAnchor(this.$pos.row,this.$pos.column);e.$insertRight=!0;e.detach();e.markerId=c.addMarker(new k(e.row,e.column,e.row,e.column+this.length),this.mainClass,null,!1);this.others=[];this.$others.forEach(function(c){c=a.createAnchor(c.row,c.column);c.$insertRight=!0;c.detach();b.others.push(c)});c.setUndoSelect(!1)};this.showOtherMarkers=function(){if(!this.othersActive){var b=this.session,a=this;this.othersActive=!0;this.others.forEach(function(c){c.markerId=b.addMarker(new k(c.row,
c.column,c.row,c.column+a.length),a.othersClass,null,!1)})}};this.hideOtherMarkers=function(){if(this.othersActive){this.othersActive=!1;for(var b=0;b<this.others.length;b++)this.session.removeMarker(this.others[b].markerId)}};this.onUpdate=function(b){if(this.$updating)return this.updateAnchors(b);if(b.start.row===b.end.row&&b.start.row===this.pos.row){this.$updating=!0;var a="insert"===b.action?b.end.column-b.start.column:b.start.column-b.end.column,c=b.start.column>=this.pos.column&&b.start.column<=
this.pos.column+this.length+1,d=b.start.column-this.pos.column;this.updateAnchors(b);c&&(this.length+=a);if(c&&!this.session.$fromUndo)if("insert"===b.action)for(c=this.others.length-1;0<=c;c--){var e=this.others[c];e={row:e.row,column:e.column+d};this.doc.insertMergedLines(e,b.lines)}else if("remove"===b.action)for(c=this.others.length-1;0<=c;c--)e=this.others[c],e={row:e.row,column:e.column+d},this.doc.remove(new k(e.row,e.column,e.row,e.column-a));this.$updating=!1;this.updateMarkers()}};this.updateAnchors=
function(b){this.pos.onChange(b);for(var a=this.others.length;a--;)this.others[a].onChange(b);this.updateMarkers()};this.updateMarkers=function(){if(!this.$updating){var b=this,a=this.session,c=function(c,d){a.removeMarker(c.markerId);c.markerId=a.addMarker(new k(c.row,c.column,c.row,c.column+b.length),d,null,!1)};c(this.pos,this.mainClass);for(var e=this.others.length;e--;)c(this.others[e],this.othersClass)}};this.onCursorChange=function(b){if(!this.$updating&&this.session){var a=this.session.selection.getCursor();
a.row===this.pos.row&&a.column>=this.pos.column&&a.column<=this.pos.column+this.length?(this.showOtherMarkers(),this._emit("cursorEnter",b)):(this.hideOtherMarkers(),this._emit("cursorLeave",b))}};this.detach=function(){this.session.removeMarker(this.pos&&this.pos.markerId);this.hideOtherMarkers();this.doc.off("change",this.$onUpdate);this.session.selection.off("changeCursor",this.$onCursorChange);this.session.setUndoSelect(!0);this.session=null};this.cancel=function(){if(-1!==this.$undoStackDepth){for(var b=
this.session.getUndoManager(),a=(b.$undoStack||b.$undostack).length-this.$undoStackDepth,c=0;c<a;c++)b.undo(this.session,!0);this.selectionBefore&&this.session.selection.fromJSON(this.selectionBefore)}}}).call(b.prototype);e.PlaceHolder=b});ace.define("ace/mouse/multi_select_handler",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(b,e,h){function k(b,a){return b.row==a.row&&b.column==a.column}var r=b("../lib/event"),g=b("../lib/useragent");e.onMouseDown=function(b){var a=
b.domEvent,c=a.altKey,d=a.shiftKey,e=a.ctrlKey,m=b.getAccelKey(),p=b.getButton();e&&g.isMac&&(p=a.button);if(b.editor.inMultiSelectMode&&2==p)b.editor.textInput.onContextMenu(b.domEvent);else if(!e&&!c&&!m)0===p&&b.editor.inMultiSelectMode&&b.editor.exitMultiSelectMode();else if(0===p){var l=b.editor,h=l.selection;p=l.inMultiSelectMode;var v=b.getDocumentPosition(),A=h.getCursor();A=b.inSelection()||h.isEmpty()&&k(v,A);var q=b.x,n=b.y,x=function(a){q=a.clientX;n=a.clientY},t=l.session,z=l.renderer.pixelToScreenCoordinates(q,
n),y=z,E;if(l.$mouseHandler.$enableJumpToDef)e&&c||m&&c?E=d?"block":"add":c&&l.$blockSelectEnabled&&(E="block");else if(m&&!c){if(E="add",!p&&d)return}else c&&l.$blockSelectEnabled&&(E="block");E&&g.isMac&&a.ctrlKey&&l.$mouseHandler.cancelContextMenu();if("add"==E){if(p||!A){if(!p){var D=h.toOrientedRange();l.addSelectionMarker(D)}var F=h.rangeList.rangeAtPoint(v);l.inVirtualSelectionMode=!0;d&&(F=null,D=h.ranges[0]||D,l.removeSelectionMarker(D));l.once("mouseup",function(){var a=h.toOrientedRange();
F&&a.isEmpty()&&k(F.cursor,a.cursor)?h.substractPoint(a.cursor):(d?h.substractPoint(D.cursor):D&&(l.removeSelectionMarker(D),h.addRange(D)),h.addRange(a));l.inVirtualSelectionMode=!1})}}else if("block"==E){b.stop();l.inVirtualSelectionMode=!0;var B=[],G=function(){var a=l.renderer.pixelToScreenCoordinates(q,n),b=t.screenToDocumentPosition(a.row,a.column,a.offsetX);k(y,a)&&k(b,h.lead)||(y=a,l.selection.moveToPosition(b),l.renderer.scrollCursorIntoView(),l.removeSelectionMarkers(B),B=h.rectangularRangeBlock(y,
z),l.$mouseHandler.$clickSelection&&1==B.length&&B[0].isEmpty()&&(B[0]=l.$mouseHandler.$clickSelection.clone()),B.forEach(l.addSelectionMarker,l),l.updateSelectionMarkers())};if(p&&!m)h.toSingleRange();else if(!p&&m){var M=h.toOrientedRange();l.addSelectionMarker(M)}d?z=t.documentToScreenPosition(h.lead):h.moveToPosition(v);y={row:-1,column:-1};r.capture(l.container,x,function(a){G();clearInterval(I);l.removeSelectionMarkers(B);B.length||(B=[h.toOrientedRange()]);M&&(l.removeSelectionMarker(M),h.toSingleRange(M));
for(a=0;a<B.length;a++)h.addRange(B[a]);l.inVirtualSelectionMode=!1;l.$mouseHandler.$clickSelection=null});var I=setInterval(function(){G()},20);return b.preventDefault()}}}});ace.define("ace/commands/multi_select_commands",["require","exports","module","ace/keyboard/hash_handler"],function(b,e,h){e.defaultCommands=[{name:"addCursorAbove",description:"Add cursor above",exec:function(b){b.selectMoreLines(-1)},bindKey:{win:"Ctrl-Alt-Up",mac:"Ctrl-Alt-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelow",
description:"Add cursor below",exec:function(b){b.selectMoreLines(1)},bindKey:{win:"Ctrl-Alt-Down",mac:"Ctrl-Alt-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorAboveSkipCurrent",description:"Add cursor above (skip current)",exec:function(b){b.selectMoreLines(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Up",mac:"Ctrl-Alt-Shift-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelowSkipCurrent",description:"Add cursor below (skip current)",exec:function(b){b.selectMoreLines(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Down",
mac:"Ctrl-Alt-Shift-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreBefore",description:"Select more before",exec:function(b){b.selectMore(-1)},bindKey:{win:"Ctrl-Alt-Left",mac:"Ctrl-Alt-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreAfter",description:"Select more after",exec:function(b){b.selectMore(1)},bindKey:{win:"Ctrl-Alt-Right",mac:"Ctrl-Alt-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextBefore",description:"Select next before",exec:function(b){b.selectMore(-1,
!0)},bindKey:{win:"Ctrl-Alt-Shift-Left",mac:"Ctrl-Alt-Shift-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextAfter",description:"Select next after",exec:function(b){b.selectMore(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Right",mac:"Ctrl-Alt-Shift-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"toggleSplitSelectionIntoLines",description:"Split into lines",exec:function(b){1<b.multiSelect.rangeCount?b.multiSelect.joinSelections():b.multiSelect.splitIntoLines()},bindKey:{win:"Ctrl-Alt-L",mac:"Ctrl-Alt-L"},
readOnly:!0},{name:"splitSelectionIntoLines",description:"Split into lines",exec:function(b){b.multiSelect.splitIntoLines()},readOnly:!0},{name:"alignCursors",description:"Align cursors",exec:function(b){b.alignCursors()},bindKey:{win:"Ctrl-Alt-A",mac:"Ctrl-Alt-A"},scrollIntoView:"cursor"},{name:"findAll",description:"Find all",exec:function(b){b.findAll()},bindKey:{win:"Ctrl-Alt-K",mac:"Ctrl-Alt-G"},scrollIntoView:"cursor",readOnly:!0}];e.multiSelectCommands=[{name:"singleSelection",description:"Single selection",
bindKey:"esc",exec:function(b){b.exitMultiSelectMode()},scrollIntoView:"cursor",readOnly:!0,isAvailable:function(b){return b&&b.inMultiSelectMode}}];b=b("../keyboard/hash_handler").HashHandler;e.keyboardHandler=new b(e.multiSelectCommands)});ace.define("ace/multi_select","require exports module ace/range_list ace/range ace/selection ace/mouse/multi_select_handler ace/lib/event ace/lib/lang ace/commands/multi_select_commands ace/search ace/edit_session ace/editor ace/config".split(" "),function(b,
e,h){function k(a){a.$multiselectOnSessionChange||(a.$onAddRange=a.$onAddRange.bind(a),a.$onRemoveRange=a.$onRemoveRange.bind(a),a.$onMultiSelect=a.$onMultiSelect.bind(a),a.$onSingleSelect=a.$onSingleSelect.bind(a),a.$multiselectOnSessionChange=e.onSessionChange.bind(a),a.$checkMultiselectChange=a.$checkMultiselectChange.bind(a),a.$multiselectOnSessionChange(a),a.on("changeSession",a.$multiselectOnSessionChange),a.on("mousedown",c),a.commands.addCommands(m.defaultCommands),r(a))}function r(a){function b(b){d&&
(a.renderer.setMouseCursor(""),d=!1)}if(a.textInput){var c=a.textInput.getElement(),d=!1;f.addListener(c,"keydown",function(c){c=18==c.keyCode&&!(c.ctrlKey||c.shiftKey||c.metaKey);a.$blockSelectEnabled&&c?d||(a.renderer.setMouseCursor("crosshair"),d=!0):d&&b()},a);f.addListener(c,"keyup",b,a);f.addListener(c,"blur",b,a)}}var g=b("./range_list").RangeList,d=b("./range").Range,a=b("./selection").Selection,c=b("./mouse/multi_select_handler").onMouseDown,f=b("./lib/event"),w=b("./lib/lang"),m=b("./commands/multi_select_commands");
e.commands=m.defaultCommands.concat(m.multiSelectCommands);var p=new (b("./search").Search);h=b("./edit_session").EditSession;(function(){this.getSelectionMarkers=function(){return this.$selectionMarkers}}).call(h.prototype);(function(){this.rangeList=this.ranges=null;this.addRange=function(a,b){if(a){if(!this.inMultiSelectMode&&0===this.rangeCount){var c=this.toOrientedRange();this.rangeList.add(c);this.rangeList.add(a);if(2!=this.rangeList.ranges.length)return this.rangeList.removeAll(),b||this.fromOrientedRange(a);
this.rangeList.removeAll();this.rangeList.add(c);this.$onAddRange(c)}a.cursor||(a.cursor=a.end);c=this.rangeList.add(a);this.$onAddRange(a);c.length&&this.$onRemoveRange(c);1<this.rangeCount&&!this.inMultiSelectMode&&(this._signal("multiSelect"),this.inMultiSelectMode=!0,this.session.$undoSelect=!1,this.rangeList.attach(this.session));return b||this.fromOrientedRange(a)}};this.toSingleRange=function(a){a=a||this.ranges[0];var b=this.rangeList.removeAll();b.length&&this.$onRemoveRange(b);a&&this.fromOrientedRange(a)};
this.substractPoint=function(a){if(a=this.rangeList.substractPoint(a))return this.$onRemoveRange(a),a[0]};this.mergeOverlappingRanges=function(){var a=this.rangeList.merge();a.length&&this.$onRemoveRange(a)};this.$onAddRange=function(a){this.rangeCount=this.rangeList.ranges.length;this.ranges.unshift(a);this._signal("addRange",{range:a})};this.$onRemoveRange=function(a){this.rangeCount=this.rangeList.ranges.length;if(1==this.rangeCount&&this.inMultiSelectMode){var b=this.rangeList.ranges.pop();a.push(b);
this.rangeCount=0}for(var c=a.length;c--;){var d=this.ranges.indexOf(a[c]);this.ranges.splice(d,1)}this._signal("removeRange",{ranges:a});0===this.rangeCount&&this.inMultiSelectMode&&(this.inMultiSelectMode=!1,this._signal("singleSelect"),this.session.$undoSelect=!0,this.rangeList.detach(this.session));(b=b||this.ranges[0])&&!b.isEqual(this.getRange())&&this.fromOrientedRange(b)};this.$initRangeList=function(){this.rangeList||(this.rangeList=new g,this.ranges=[],this.rangeCount=0)};this.getAllRanges=
function(){return this.rangeCount?this.rangeList.ranges.concat():[this.getRange()]};this.splitIntoLines=function(){for(var a=this.ranges.length?this.ranges:[this.getRange()],b=[],c=0;c<a.length;c++){var e=a[c],f=e.start.row,g=e.end.row;if(f===g)b.push(e.clone());else{for(b.push(new d(f,e.start.column,f,this.session.getLine(f).length));++f<g;)b.push(this.getLineRange(f,!0));b.push(new d(g,0,g,e.end.column))}0!=c||this.isBackwards()||(b=b.reverse())}this.toSingleRange();for(c=b.length;c--;)this.addRange(b[c])};
this.joinSelections=function(){var a=this.rangeList.ranges,b=a[a.length-1];a=d.fromPoints(a[0].start,b.end);this.toSingleRange();this.setSelectionRange(a,b.cursor==b.start)};this.toggleBlockSelection=function(){if(1<this.rangeCount){var a=this.rangeList.ranges,b=a[a.length-1];a=d.fromPoints(a[0].start,b.end);this.toSingleRange();this.setSelectionRange(a,b.cursor==b.start)}else b=this.session.documentToScreenPosition(this.cursor),a=this.session.documentToScreenPosition(this.anchor),this.rectangularRangeBlock(b,
a).forEach(this.addRange,this)};this.rectangularRangeBlock=function(a,b,c){var e=[],f=a.column<b.column;if(f)var g=a.column,l=b.column,v=a.offsetX,m=b.offsetX;else g=b.column,l=a.column,v=b.offsetX,m=a.offsetX;var k=a.row<b.row;if(k){var h=a.row;a=b.row}else h=b.row,a=a.row;0>g&&(g=0);0>h&&(h=0);h==a&&(c=!0);for(var p;h<=a;h++){b=d.fromPoints(this.session.screenToDocumentPosition(h,g,v),this.session.screenToDocumentPosition(h,l,m));if(b.isEmpty()){var u;if(u=p)u=b.end,u=u.row==p.row&&u.column==p.column;
if(u)break;p=b.end}b.cursor=f?b.start:b.end;e.push(b)}k&&e.reverse();if(!c){for(c=e.length-1;e[c].isEmpty()&&0<c;)c--;if(0<c)for(var r=0;e[r].isEmpty();)r++;for(;c>=r;c--)e[c].isEmpty()&&e.splice(c,1)}return e}}).call(a.prototype);h=b("./editor").Editor;(function(){this.updateSelectionMarkers=function(){this.renderer.updateCursor();this.renderer.updateBackMarkers()};this.addSelectionMarker=function(a){a.cursor||(a.cursor=a.end);var b=this.getSelectionStyle();a.marker=this.session.addMarker(a,"ace_selection",
b);this.session.$selectionMarkers.push(a);this.session.selectionMarkerCount=this.session.$selectionMarkers.length;return a};this.removeSelectionMarker=function(a){a.marker&&(this.session.removeMarker(a.marker),a=this.session.$selectionMarkers.indexOf(a),-1!=a&&this.session.$selectionMarkers.splice(a,1),this.session.selectionMarkerCount=this.session.$selectionMarkers.length)};this.removeSelectionMarkers=function(a){for(var b=this.session.$selectionMarkers,c=a.length;c--;){var d=a[c];d.marker&&(this.session.removeMarker(d.marker),
d=b.indexOf(d),-1!=d&&b.splice(d,1))}this.session.selectionMarkerCount=b.length};this.$onAddRange=function(a){this.addSelectionMarker(a.range);this.renderer.updateCursor();this.renderer.updateBackMarkers()};this.$onRemoveRange=function(a){this.removeSelectionMarkers(a.ranges);this.renderer.updateCursor();this.renderer.updateBackMarkers()};this.$onMultiSelect=function(a){this.inMultiSelectMode||(this.inMultiSelectMode=!0,this.setStyle("ace_multiselect"),this.keyBinding.addKeyboardHandler(m.keyboardHandler),
this.commands.setDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers())};this.$onSingleSelect=function(a){this.session.multiSelect.inVirtualMode||(this.inMultiSelectMode=!1,this.unsetStyle("ace_multiselect"),this.keyBinding.removeKeyboardHandler(m.keyboardHandler),this.commands.removeDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers(),this._emit("changeSelection"))};this.$onMultiSelectExec=
function(a){var b=a.command,c=a.editor;if(c.multiSelect)return b.multiSelectAction?"forEach"==b.multiSelectAction?a=c.forEachSelection(b,a.args):"forEachLine"==b.multiSelectAction?a=c.forEachSelection(b,a.args,!0):"single"==b.multiSelectAction?(c.exitMultiSelectMode(),a=b.exec(c,a.args||{})):a=b.multiSelectAction(c,a.args||{}):(a=b.exec(c,a.args||{}),c.multiSelect.addRange(c.multiSelect.toOrientedRange()),c.multiSelect.mergeOverlappingRanges()),a};this.forEachSelection=function(b,c,d){if(!this.inVirtualSelectionMode){var e=
1==d||d&&d.$byLines,f=this.session,g=this.selection,l=g.rangeList;d=(d&&d.keepOrder?g:l).ranges;var v;if(!d.length)return b.exec?b.exec(this,c||{}):b(this,c||{});l=g._eventRegistry;g._eventRegistry={};var m=new a(f);this.inVirtualSelectionMode=!0;for(var k=d.length;k--;){if(e)for(;0<k&&d[k].start.row==d[k-1].end.row;)k--;m.fromOrientedRange(d[k]);m.index=k;this.selection=f.selection=m;var h=b.exec?b.exec(this,c||{}):b(this,c||{});v||void 0===h||(v=h);m.toOrientedRange(d[k])}m.detach();this.selection=
f.selection=g;this.inVirtualSelectionMode=!1;g._eventRegistry=l;g.mergeOverlappingRanges();g.ranges[0]&&g.fromOrientedRange(g.ranges[0]);b=this.renderer.$scrollAnimation;this.onCursorChange();this.onSelectionChange();b&&b.from==b.to&&this.renderer.animateScrolling(b.from);return v}};this.exitMultiSelectMode=function(){this.inMultiSelectMode&&!this.inVirtualSelectionMode&&this.multiSelect.toSingleRange()};this.getSelectedText=function(){var a="";if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){a=
this.multiSelect.rangeList.ranges;for(var b=[],c=0;c<a.length;c++)b.push(this.session.getTextRange(a[c]));c=this.session.getDocument().getNewLineCharacter();a=b.join(c);a.length==(b.length-1)*c.length&&(a="")}else this.selection.isEmpty()||(a=this.session.getTextRange(this.getSelectionRange()));return a};this.$checkMultiselectChange=function(a,b){this.inMultiSelectMode&&!this.inVirtualSelectionMode&&(a=this.multiSelect.ranges[0],this.multiSelect.isEmpty()&&b==this.multiSelect.anchor||(a=b==this.multiSelect.anchor?
a.cursor==a.start?a.end:a.start:a.cursor,a.row!=b.row||this.session.$clipPositionToDocument(a.row,a.column).column!=b.column?this.multiSelect.toSingleRange(this.multiSelect.toOrientedRange()):this.multiSelect.mergeOverlappingRanges()))};this.findAll=function(a,b,c){b=b||{};b.needle=a||b.needle;if(void 0==b.needle){var d=this.selection.isEmpty()?this.selection.getWordRange():this.selection.getRange();b.needle=this.session.getTextRange(d)}this.$search.set(b);a=this.$search.findAll(this.session);if(!a.length)return 0;
b=this.multiSelect;c||b.toSingleRange(a[0]);for(c=a.length;c--;)b.addRange(a[c],!0);d&&b.rangeList.rangeAtPoint(d.start)&&b.addRange(d,!0);return a.length};this.selectMoreLines=function(a,b){var c=this.selection.toOrientedRange(),e=c.cursor==c.end,f=this.session.documentToScreenPosition(c.cursor);this.selection.$desiredColumn&&(f.column=this.selection.$desiredColumn);var g=this.session.screenToDocumentPosition(f.row+a,f.column);if(c.isEmpty())a=g;else{var l=this.session.documentToScreenPosition(e?
c.end:c.start);a=this.session.screenToDocumentPosition(l.row+a,l.column)}e?(e=d.fromPoints(g,a),e.cursor=e.start):(e=d.fromPoints(a,g),e.cursor=e.end);e.desiredColumn=f.column;if(!this.selection.inMultiSelectMode)this.selection.addRange(c);else if(b)var m=c.cursor;this.selection.addRange(e);m&&this.selection.substractPoint(m)};this.transposeSelections=function(a){for(var b=this.session,c=b.multiSelect,d=c.ranges,e=d.length;e--;){var f=d[e];if(f.isEmpty()){var g=b.getWordRange(f.start.row,f.start.column);
f.start.row=g.start.row;f.start.column=g.start.column;f.end.row=g.end.row;f.end.column=g.end.column}}c.mergeOverlappingRanges();var l=[];for(e=d.length;e--;)f=d[e],l.unshift(b.getTextRange(f));0>a?l.unshift(l.pop()):l.push(l.shift());for(e=d.length;e--;)f=d[e],g=f.clone(),b.replace(f,l[e]),f.start.row=g.start.row,f.start.column=g.start.column;c.fromOrientedRange(c.ranges[0])};this.selectMore=function(a,b,c){var d=this.session,e=d.multiSelect.toOrientedRange();if(e.isEmpty()&&(e=d.getWordRange(e.start.row,
e.start.column),e.cursor=-1==a?e.start:e.end,this.multiSelect.addRange(e),c))return;c=d.getTextRange(e);p.$options.wrap=!0;p.$options.needle=c;p.$options.backwards=-1==a;if(d=p.find(d))d.cursor=-1==a?d.start:d.end,this.session.unfold(d),this.multiSelect.addRange(d),this.renderer.scrollCursorIntoView(null,.5);b&&this.multiSelect.substractPoint(e.cursor)};this.alignCursors=function(){var a=this.session,b=a.multiSelect,c=b.ranges,e=-1,f=c.filter(function(a){if(a.cursor.row==e)return!0;e=a.cursor.row});
if(c.length&&f.length!=c.length-1){f.forEach(function(a){b.substractPoint(a.cursor)});var g=0,m=Infinity,k=c.map(function(b){b=b.cursor;var c=a.getLine(b.row).substr(b.column).search(/\S/g);-1==c&&(c=0);b.column>g&&(g=b.column);c<m&&(m=c);return c});c.forEach(function(b,c){var e=b.cursor,f=g-e.column;c=k[c]-m;f>c?a.insert(e,w.stringRepeat(" ",f-c)):a.remove(new d(e.row,e.column,e.row,e.column-f+c));b.start.column=b.end.column=g;b.start.row=b.end.row=e.row;b.cursor=b.end});b.fromOrientedRange(c[0]);
this.renderer.updateCursor();this.renderer.updateBackMarkers()}else{c=this.selection.getRange();f=c.start.row;var h=c.end.row,p=f==h;if(p){var r=this.session.getLength();do var x=this.session.getLine(h);while(/[=:]/.test(x)&&++h<r);do x=this.session.getLine(f);while(/[=:]/.test(x)&&0<--f);0>f&&(f=0);h>=r&&(h=r-1)}h=this.session.removeFullLines(f,h);h=this.$reAlignText(h,p);this.session.insert({row:f,column:0},h.join("\n")+"\n");p||(c.start.column=0,c.end.column=h[h.length-1].length);this.selection.setRange(c)}};
this.$reAlignText=function(a,b){function c(a){return w.stringRepeat(" ",a)}function d(a){return a[2]?c(m)+a[2]+c(k-a[2].length+h)+a[4].replace(/^([=:])\s+/,"$1 "):a[0]}function e(a){return a[2]?c(m+k-a[2].length)+a[2]+c(h)+a[4].replace(/^([=:])\s+/,"$1 "):a[0]}function f(a){return a[2]?c(m)+a[2]+c(h)+a[4].replace(/^([=:])\s+/,"$1 "):a[0]}var g=!0,l=!0,m,k,h;return a.map(function(a){var b=a.match(/(\s*)(.*?)(\s*)([=:].*)/);if(!b)return[a];if(null==m)return m=b[1].length,k=b[2].length,h=b[3].length,
b;m+k+h!=b[1].length+b[2].length+b[3].length&&(l=!1);m!=b[1].length&&(g=!1);m>b[1].length&&(m=b[1].length);k<b[2].length&&(k=b[2].length);h>b[3].length&&(h=b[3].length);return b}).map(b?d:g?l?e:d:f)}}).call(h.prototype);e.onSessionChange=function(a){var b=a.session;b&&!b.multiSelect&&(b.$selectionMarkers=[],b.selection.$initRangeList(),b.multiSelect=b.selection);this.multiSelect=b&&b.multiSelect;if(a=a.oldSession)a.multiSelect.off("addRange",this.$onAddRange),a.multiSelect.off("removeRange",this.$onRemoveRange),
a.multiSelect.off("multiSelect",this.$onMultiSelect),a.multiSelect.off("singleSelect",this.$onSingleSelect),a.multiSelect.lead.off("change",this.$checkMultiselectChange),a.multiSelect.anchor.off("change",this.$checkMultiselectChange);b&&(b.multiSelect.on("addRange",this.$onAddRange),b.multiSelect.on("removeRange",this.$onRemoveRange),b.multiSelect.on("multiSelect",this.$onMultiSelect),b.multiSelect.on("singleSelect",this.$onSingleSelect),b.multiSelect.lead.on("change",this.$checkMultiselectChange),
b.multiSelect.anchor.on("change",this.$checkMultiselectChange));b&&this.inMultiSelectMode!=b.selection.inMultiSelectMode&&(b.selection.inMultiSelectMode?this.$onMultiSelect():this.$onSingleSelect())};e.MultiSelect=k;b("./config").defineOptions(h.prototype,"editor",{enableMultiselect:{set:function(a){k(this);a?(this.on("changeSession",this.$multiselectOnSessionChange),this.on("mousedown",c)):(this.off("changeSession",this.$multiselectOnSessionChange),this.off("mousedown",c))},value:!0},enableBlockSelect:{set:function(a){this.$blockSelectEnabled=
a},value:!0}})});ace.define("ace/mode/folding/fold_mode",["require","exports","module","ace/range"],function(b,e,h){var k=b("../../range").Range;b=e.FoldMode=function(){};(function(){this.foldingStopMarker=this.foldingStartMarker=null;this.getFoldWidget=function(b,e,d){b=b.getLine(d);return this.foldingStartMarker.test(b)?"start":"markbeginend"==e&&this.foldingStopMarker&&this.foldingStopMarker.test(b)?"end":""};this.getFoldWidgetRange=function(b,e,d){return null};this.indentationBlock=function(b,
e,d){var a=/\S/,c=b.getLine(e),f=c.search(a);if(-1!=f){d=d||c.length;for(var g=b.getLength(),m=c=e;++e<g;){var h=b.getLine(e).search(a);if(-1!=h){if(h<=f&&(h=b.getTokenAt(e,0),!h||"string"!==h.type))break;m=e}}if(m>c)return b=b.getLine(m).length,new k(c,d,m,b)}};this.openingBracketBlock=function(b,e,d,a,c){d={row:d,column:a+1};if(e=b.$findClosingBracket(e,d,c))return c=b.foldWidgets[e.row],null==c&&(c=b.getFoldWidget(e.row)),"start"==c&&e.row>d.row&&(e.row--,e.column=b.getLine(e.row).length),k.fromPoints(d,
e)};this.closingBracketBlock=function(b,e,d,a,c){d={row:d,column:a};if(b=b.$findOpeningBracket(e,d))return b.column++,d.column--,k.fromPoints(b,d)}}).call(b.prototype)});ace.define("ace/theme/textmate",["require","exports","module","ace/lib/dom"],function(b,e,h){e.isDark=!1;e.cssClass="ace-tm";e.cssText='.ace-tm .ace_gutter {background: #f0f0f0;color: #333;}.ace-tm .ace_print-margin {width: 1px;background: #e8e8e8;}.ace-tm .ace_fold {background-color: #6B72E6;}.ace-tm {background-color: #FFFFFF;color: black;}.ace-tm .ace_cursor {color: black;}.ace-tm .ace_invisible {color: rgb(191, 191, 191);}.ace-tm .ace_storage,.ace-tm .ace_keyword {color: blue;}.ace-tm .ace_constant {color: rgb(197, 6, 11);}.ace-tm .ace_constant.ace_buildin {color: rgb(88, 72, 246);}.ace-tm .ace_constant.ace_language {color: rgb(88, 92, 246);}.ace-tm .ace_constant.ace_library {color: rgb(6, 150, 14);}.ace-tm .ace_invalid {background-color: rgba(255, 0, 0, 0.1);color: red;}.ace-tm .ace_support.ace_function {color: rgb(60, 76, 114);}.ace-tm .ace_support.ace_constant {color: rgb(6, 150, 14);}.ace-tm .ace_support.ace_type,.ace-tm .ace_support.ace_class {color: rgb(109, 121, 222);}.ace-tm .ace_keyword.ace_operator {color: rgb(104, 118, 135);}.ace-tm .ace_string {color: rgb(3, 106, 7);}.ace-tm .ace_comment {color: rgb(76, 136, 107);}.ace-tm .ace_comment.ace_doc {color: rgb(0, 102, 255);}.ace-tm .ace_comment.ace_doc.ace_tag {color: rgb(128, 159, 191);}.ace-tm .ace_constant.ace_numeric {color: rgb(0, 0, 205);}.ace-tm .ace_variable {color: rgb(49, 132, 149);}.ace-tm .ace_xml-pe {color: rgb(104, 104, 91);}.ace-tm .ace_entity.ace_name.ace_function {color: #0000A2;}.ace-tm .ace_heading {color: rgb(12, 7, 255);}.ace-tm .ace_list {color:rgb(185, 6, 144);}.ace-tm .ace_meta.ace_tag {color:rgb(0, 22, 142);}.ace-tm .ace_string.ace_regex {color: rgb(255, 0, 0)}.ace-tm .ace_marker-layer .ace_selection {background: rgb(181, 213, 255);}.ace-tm.ace_multiselect .ace_selection.ace_start {box-shadow: 0 0 3px 0px white;}.ace-tm .ace_marker-layer .ace_step {background: rgb(252, 255, 0);}.ace-tm .ace_marker-layer .ace_stack {background: rgb(164, 229, 101);}.ace-tm .ace_marker-layer .ace_bracket {margin: -1px 0 0 -1px;border: 1px solid rgb(192, 192, 192);}.ace-tm .ace_marker-layer .ace_active-line {background: rgba(0, 0, 0, 0.07);}.ace-tm .ace_gutter-active-line {background-color : #dcdcdc;}.ace-tm .ace_marker-layer .ace_selected-word {background: rgb(250, 250, 255);border: 1px solid rgb(200, 200, 250);}.ace-tm .ace_indent-guide {background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y;}';
e.$id="ace/theme/textmate";b("../lib/dom").importCssString(e.cssText,e.cssClass)});ace.define("ace/line_widgets",["require","exports","module","ace/lib/dom"],function(b,e,h){function k(b){this.session=b;this.session.widgetManager=this;this.session.getRowLength=this.getRowLength;this.session.$getWidgetScreenLength=this.$getWidgetScreenLength;this.updateOnChange=this.updateOnChange.bind(this);this.renderWidgets=this.renderWidgets.bind(this);this.measureWidgets=this.measureWidgets.bind(this);this.session._changedWidgets=
[];this.$onChangeEditor=this.$onChangeEditor.bind(this);this.session.on("change",this.updateOnChange);this.session.on("changeFold",this.updateOnFold);this.session.on("changeEditor",this.$onChangeEditor)}var r=b("./lib/dom");(function(){this.getRowLength=function(b){var d=this.lineWidgets?this.lineWidgets[b]&&this.lineWidgets[b].rowCount||0:0;return this.$useWrapMode&&this.$wrapData[b]?this.$wrapData[b].length+1+d:1+d};this.$getWidgetScreenLength=function(){var b=0;this.lineWidgets.forEach(function(d){d&&
d.rowCount&&!d.hidden&&(b+=d.rowCount)});return b};this.$onChangeEditor=function(b){this.attach(b.editor)};this.attach=function(b){b&&b.widgetManager&&b.widgetManager!=this&&b.widgetManager.detach();this.editor!=b&&(this.detach(),this.editor=b)&&(b.widgetManager=this,b.renderer.on("beforeRender",this.measureWidgets),b.renderer.on("afterRender",this.renderWidgets))};this.detach=function(b){if(b=this.editor)this.editor=null,b.widgetManager=null,b.renderer.off("beforeRender",this.measureWidgets),b.renderer.off("afterRender",
this.renderWidgets),(b=this.session.lineWidgets)&&b.forEach(function(b){b&&b.el&&b.el.parentNode&&(b._inDocument=!1,b.el.parentNode.removeChild(b.el))})};this.updateOnFold=function(b,d){if((d=d.lineWidgets)&&b.action){var a=b.data,c=a.start.row;a=a.end.row;b="add"==b.action;for(var e=c+1;e<a;e++)d[e]&&(d[e].hidden=b);d[a]&&(b?d[c]?d[a].hidden=b:d[c]=d[a]:(d[c]==d[a]&&(d[c]=void 0),d[a].hidden=b))}};this.updateOnChange=function(b){var d=this.session.lineWidgets;if(d){var a=b.start.row,c=b.end.row-
a;0!==c&&("remove"==b.action?(b=d.splice(a+1,c),!d[a]&&b[b.length-1]&&(d[a]=b.pop()),b.forEach(function(a){a&&this.removeLineWidget(a)},this)):(c=Array(c),d[a]&&null!=d[a].column&&b.start.column>d[a].column&&a++,c.unshift(a,0),d.splice.apply(d,c)),this.$updateRows())}};this.$updateRows=function(){var b=this.session.lineWidgets;if(b){var d=!0;b.forEach(function(a,b){if(a)for(d=!1,a.row=b;a.$oldWidget;)a.$oldWidget.row=b,a=a.$oldWidget});d&&(this.session.lineWidgets=null)}};this.$registerLineWidget=
function(b){this.session.lineWidgets||(this.session.lineWidgets=Array(this.session.getLength()));var d=this.session.lineWidgets[b.row];d&&(b.$oldWidget=d,d.el&&d.el.parentNode&&(d.el.parentNode.removeChild(d.el),d._inDocument=!1));return this.session.lineWidgets[b.row]=b};this.addLineWidget=function(b){this.$registerLineWidget(b);b.session=this.session;if(!this.editor)return b;var d=this.editor.renderer;b.html&&!b.el&&(b.el=r.createElement("div"),b.el.innerHTML=b.html);b.el&&(r.addCssClass(b.el,"ace_lineWidgetContainer"),
b.el.style.position="absolute",b.el.style.zIndex=5,d.container.appendChild(b.el),b._inDocument=!0,b.coverGutter||(b.el.style.zIndex=3),null==b.pixelHeight&&(b.pixelHeight=b.el.offsetHeight));null==b.rowCount&&(b.rowCount=b.pixelHeight/d.layerConfig.lineHeight);var a=this.session.getFoldAt(b.row,0);if(b.$fold=a){var c=this.session.lineWidgets;b.row!=a.end.row||c[a.start.row]?b.hidden=!0:c[a.start.row]=b}this.session._emit("changeFold",{data:{start:{row:b.row}}});this.$updateRows();this.renderWidgets(null,
d);this.onWidgetChanged(b);return b};this.removeLineWidget=function(b){b._inDocument=!1;b.session=null;b.el&&b.el.parentNode&&b.el.parentNode.removeChild(b.el);if(b.editor&&b.editor.destroy)try{b.editor.destroy()}catch(a){}if(this.session.lineWidgets){var d=this.session.lineWidgets[b.row];if(d==b){if(this.session.lineWidgets[b.row]=b.$oldWidget)this.onWidgetChanged(b.$oldWidget)}else for(;d;){if(d.$oldWidget==b){d.$oldWidget=b.$oldWidget;break}d=d.$oldWidget}}this.session._emit("changeFold",{data:{start:{row:b.row}}});
this.$updateRows()};this.getWidgetsAtRow=function(b){var d=this.session.lineWidgets;b=d&&d[b];for(d=[];b;)d.push(b),b=b.$oldWidget;return d};this.onWidgetChanged=function(b){this.session._changedWidgets.push(b);this.editor&&this.editor.renderer.updateFull()};this.measureWidgets=function(b,d){b=this.session._changedWidgets;var a=d.layerConfig;if(b&&b.length){for(var c=Infinity,e=0;e<b.length;e++){var g=b[e];if(g&&g.el&&g.session==this.session){if(!g._inDocument){if(this.session.lineWidgets[g.row]!=
g)continue;g._inDocument=!0;d.container.appendChild(g.el)}g.h=g.el.offsetHeight;g.fixedWidth||(g.w=g.el.offsetWidth,g.screenWidth=Math.ceil(g.w/a.characterWidth));var m=g.h/a.lineHeight;g.coverLine&&(m-=this.session.getRowLineCount(g.row),0>m&&(m=0));g.rowCount!=m&&(g.rowCount=m,g.row<c&&(c=g.row))}}Infinity!=c&&(this.session._emit("changeFold",{data:{start:{row:c}}}),this.session.lineWidgetWidth=null);this.session._changedWidgets=[]}};this.renderWidgets=function(b,d){b=d.layerConfig;var a=this.session.lineWidgets;
if(a){for(var c=Math.min(this.firstRow,b.firstRow),e=Math.max(this.lastRow,b.lastRow,a.length);0<c&&!a[c];)c--;this.firstRow=b.firstRow;this.lastRow=b.lastRow;for(d.$cursorLayer.config=b;c<=e;c++){var g=a[c];if(g&&g.el)if(g.hidden)g.el.style.top=-100-(g.pixelHeight||0)+"px";else{g._inDocument||(g._inDocument=!0,d.container.appendChild(g.el));var m=d.$cursorLayer.getPixelPosition({row:c,column:0},!0).top;g.coverLine||(m+=b.lineHeight*this.session.getRowLineCount(g.row));g.el.style.top=m-b.offset+"px";
m=g.coverGutter?0:d.gutterWidth;g.fixedWidth||(m-=d.scrollLeft);g.el.style.left=m+"px";g.fullWidth&&g.screenWidth&&(g.el.style.minWidth=b.width+2*b.padding+"px");g.el.style.right=g.fixedWidth?d.scrollBar.getWidth()+"px":""}}}}}).call(k.prototype);e.LineWidgets=k});ace.define("ace/ext/error_marker","require exports module ace/line_widgets ace/lib/dom ace/range".split(" "),function(b,e,h){function k(a,b,e){a=a.getAnnotations().sort(d.comparePoints);if(a.length){a:{var c={row:b,column:-1};for(var f=
d.comparePoints,g=0,l=a.length-1;g<=l;){var k=g+l>>1,v=f(c,a[k]);if(0<v)g=k+1;else if(0>v)l=k-1;else{c=k;break a}}c=-(g+1)}0>c&&(c=-c-1);c>=a.length?c=0<e?0:a.length-1:0===c&&0>e&&(c=a.length-1);if((f=a[c])&&e){if(f.row===b){do f=a[c+=e];while(f&&f.row===b);if(!f)return a.slice()}g=[];b=f.row;do g[0>e?"unshift":"push"](f),f=a[c+=e];while(f&&f.row==b);return g.length&&g}}}var r=b("../line_widgets").LineWidgets,g=b("../lib/dom"),d=b("../range").Range;e.showErrorMarker=function(a,b){var c=a.session;
c.widgetManager||(c.widgetManager=new r(c),c.widgetManager.attach(a));var d=a.getCursorPosition(),e=d.row,h=c.widgetManager.getWidgetsAtRow(e).filter(function(a){return"errorMarker"==a.type})[0];h?h.destroy():e-=b;if(b=k(c,e,b))h=b[0],d.column=(h.pos&&"number"!=typeof h.column?h.pos.sc:h.column)||0,d.row=h.row,h=a.renderer.$gutterLayer.$annotations[d.row];else{if(h)return;h={text:["Looks good!"],className:"ace_ok"}}a.session.unfold(d.row);a.selection.moveToPosition(d);var l={row:d.row,fixedWidth:!0,
coverGutter:!0,el:g.createElement("div"),type:"errorMarker"};b=l.el.appendChild(g.createElement("div"));e=l.el.appendChild(g.createElement("div"));e.className="error_widget_arrow "+h.className;d=a.renderer.$cursorLayer.getPixelPosition(d).left;e.style.left=d+a.renderer.gutterWidth-5+"px";l.el.className="error_widget_wrapper";b.className="error_widget "+h.className;b.innerHTML=h.text.join("<br>");b.appendChild(g.createElement("div"));var u=function(a,b,c){if(0===b&&("esc"===c||"return"===c))return l.destroy(),
{command:"null"}};l.destroy=function(){a.$mouseHandler.isMousePressed||(a.keyBinding.removeKeyboardHandler(u),c.widgetManager.removeLineWidget(l),a.off("changeSelection",l.destroy),a.off("changeSession",l.destroy),a.off("mouseup",l.destroy),a.off("change",l.destroy))};a.keyBinding.addKeyboardHandler(u);a.on("changeSelection",l.destroy);a.on("changeSession",l.destroy);a.on("mouseup",l.destroy);a.on("change",l.destroy);a.session.widgetManager.addLineWidget(l);l.el.onmousedown=a.focus.bind(a);a.renderer.scrollCursorIntoView(null,
.5,{bottom:l.el.offsetHeight})};g.importCssString("    .error_widget_wrapper {        background: inherit;        color: inherit;        border:none    }    .error_widget {        border-top: solid 2px;        border-bottom: solid 2px;        margin: 5px 0;        padding: 10px 40px;        white-space: pre-wrap;    }    .error_widget.ace_error, .error_widget_arrow.ace_error{        border-color: #ff5a5a    }    .error_widget.ace_warning, .error_widget_arrow.ace_warning{        border-color: #F1D817    }    .error_widget.ace_info, .error_widget_arrow.ace_info{        border-color: #5a5a5a    }    .error_widget.ace_ok, .error_widget_arrow.ace_ok{        border-color: #5aaa5a    }    .error_widget_arrow {        position: absolute;        border: solid 5px;        border-top-color: transparent!important;        border-right-color: transparent!important;        border-left-color: transparent!important;        top: -5px;    }",
"")});ace.define("ace/ace","require exports module ace/lib/fixoldbrowsers ace/lib/dom ace/lib/event ace/range ace/editor ace/edit_session ace/undomanager ace/virtual_renderer ace/worker/worker_client ace/keyboard/hash_handler ace/placeholder ace/multi_select ace/mode/folding/fold_mode ace/theme/textmate ace/ext/error_marker ace/config".split(" "),function(b,e,t){b("./lib/fixoldbrowsers");var k=b("./lib/dom"),r=b("./lib/event");t=b("./range").Range;var g=b("./editor").Editor,d=b("./edit_session").EditSession,
a=b("./undomanager").UndoManager,c=b("./virtual_renderer").VirtualRenderer;b("./worker/worker_client");b("./keyboard/hash_handler");b("./placeholder");b("./multi_select");b("./mode/folding/fold_mode");b("./theme/textmate");b("./ext/error_marker");e.config=b("./config");e.require=b;e.define=h.amdD;e.edit=function(a,b){if("string"==typeof a){var d=a;a=document.getElementById(d);if(!a)throw Error("ace.edit can't find div #"+d);}if(a&&a.env&&a.env.editor instanceof g)return a.env.editor;d="";if(a&&/input|textarea/i.test(a.tagName)){var f=
a;d=f.value;a=k.createElement("pre");f.parentNode.replaceChild(a,f)}else a&&(d=a.textContent,a.innerHTML="");d=e.createEditSession(d);a=new g(new c(a),d,b);var l={document:d,editor:a,onResize:a.resize.bind(a,null)};f&&(l.textarea=f);r.addListener(window,"resize",l.onResize);a.on("destroy",function(){r.removeListener(window,"resize",l.onResize);l.editor.container.env=null});a.container.env=a.env=l;return a};e.createEditSession=function(b,c){b=new d(b,c);b.setUndoManager(new a);return b};e.Range=t;
e.Editor=g;e.EditSession=d;e.UndoManager=a;e.VirtualRenderer=c;e.version=e.config.version});(function(){ace.require(["ace/ace"],function(b){b&&(b.config.init(!0),b.define=ace.define);window.ace||(window.ace=b);for(var e in b)b.hasOwnProperty(e)&&(window.ace[e]=b[e]);window.ace["default"]=window.ace;y&&(y.exports=window.ace)})})()},3330:function(y,e,h){y=h.nmd(y);ace.define("ace/ext/searchbox","require exports module ace/lib/dom ace/lib/lang ace/lib/event ace/keyboard/hash_handler ace/lib/keys".split(" "),
function(b,e,h){var k=b("../lib/dom"),r=b("../lib/lang"),g=b("../lib/event"),d=b("../keyboard/hash_handler").HashHandler,a=b("../lib/keys");k.importCssString('.ace_search {background-color: #ddd;color: #666;border: 1px solid #cbcbcb;border-top: 0 none;overflow: hidden;margin: 0;padding: 4px 6px 0 4px;position: absolute;top: 0;z-index: 99;white-space: normal;}.ace_search.left {border-left: 0 none;border-radius: 0px 0px 5px 0px;left: 0;}.ace_search.right {border-radius: 0px 0px 0px 5px;border-right: 0 none;right: 0;}.ace_search_form, .ace_replace_form {margin: 0 20px 4px 0;overflow: hidden;line-height: 1.9;}.ace_replace_form {margin-right: 0;}.ace_search_form.ace_nomatch {outline: 1px solid red;}.ace_search_field {border-radius: 3px 0 0 3px;background-color: white;color: black;border: 1px solid #cbcbcb;border-right: 0 none;outline: 0;padding: 0;font-size: inherit;margin: 0;line-height: inherit;padding: 0 6px;min-width: 17em;vertical-align: top;min-height: 1.8em;box-sizing: content-box;}.ace_searchbtn {border: 1px solid #cbcbcb;line-height: inherit;display: inline-block;padding: 0 6px;background: #fff;border-right: 0 none;border-left: 1px solid #dcdcdc;cursor: pointer;margin: 0;position: relative;color: #666;}.ace_searchbtn:last-child {border-radius: 0 3px 3px 0;border-right: 1px solid #cbcbcb;}.ace_searchbtn:disabled {background: none;cursor: default;}.ace_searchbtn:hover {background-color: #eef1f6;}.ace_searchbtn.prev, .ace_searchbtn.next {padding: 0px 0.7em}.ace_searchbtn.prev:after, .ace_searchbtn.next:after {content: "";border: solid 2px #888;width: 0.5em;height: 0.5em;border-width:  2px 0 0 2px;display:inline-block;transform: rotate(-45deg);}.ace_searchbtn.next:after {border-width: 0 2px 2px 0 ;}.ace_searchbtn_close {background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;border-radius: 50%;border: 0 none;color: #656565;cursor: pointer;font: 16px/16px Arial;padding: 0;height: 14px;width: 14px;top: 9px;right: 7px;position: absolute;}.ace_searchbtn_close:hover {background-color: #656565;background-position: 50% 100%;color: white;}.ace_button {margin-left: 2px;cursor: pointer;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;overflow: hidden;opacity: 0.7;border: 1px solid rgba(100,100,100,0.23);padding: 1px;box-sizing:    border-box!important;color: black;}.ace_button:hover {background-color: #eee;opacity:1;}.ace_button:active {background-color: #ddd;}.ace_button.checked {border-color: #3399ff;opacity:1;}.ace_search_options{margin-bottom: 3px;text-align: right;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;clear: both;}.ace_search_counter {float: left;font-family: arial;padding: 0 8px;}',
"ace_searchbox");var c=function(a,b,c){b=k.createElement("div");k.buildDom(["div",{class:"ace_search right"},["span",{action:"hide",class:"ace_searchbtn_close"}],["div",{class:"ace_search_form"},["input",{class:"ace_search_field",placeholder:"Search for",spellcheck:"false"}],["span",{action:"findPrev",class:"ace_searchbtn prev"},"\u200b"],["span",{action:"findNext",class:"ace_searchbtn next"},"\u200b"],["span",{action:"findAll",class:"ace_searchbtn",title:"Alt-Enter"},"All"]],["div",{class:"ace_replace_form"},
["input",{class:"ace_search_field",placeholder:"Replace with",spellcheck:"false"}],["span",{action:"replaceAndFindNext",class:"ace_searchbtn"},"Replace"],["span",{action:"replaceAll",class:"ace_searchbtn"},"All"]],["div",{class:"ace_search_options"},["span",{action:"toggleReplace",class:"ace_button",title:"Toggle Replace mode",style:"float:left;margin-top:-2px;padding:0 5px;"},"+"],["span",{class:"ace_search_counter"}],["span",{action:"toggleRegexpMode",class:"ace_button",title:"RegExp Search"},".*"],
["span",{action:"toggleCaseSensitive",class:"ace_button",title:"CaseSensitive Search"},"Aa"],["span",{action:"toggleWholeWords",class:"ace_button",title:"Whole Word Search"},"\\b"],["span",{action:"searchInSelection",class:"ace_button",title:"Search In Selection"},"S"]]],b);this.element=b.firstChild;this.setSession=this.setSession.bind(this);this.$init();this.setEditor(a);k.importCssString('.ace_search {background-color: #ddd;color: #666;border: 1px solid #cbcbcb;border-top: 0 none;overflow: hidden;margin: 0;padding: 4px 6px 0 4px;position: absolute;top: 0;z-index: 99;white-space: normal;}.ace_search.left {border-left: 0 none;border-radius: 0px 0px 5px 0px;left: 0;}.ace_search.right {border-radius: 0px 0px 0px 5px;border-right: 0 none;right: 0;}.ace_search_form, .ace_replace_form {margin: 0 20px 4px 0;overflow: hidden;line-height: 1.9;}.ace_replace_form {margin-right: 0;}.ace_search_form.ace_nomatch {outline: 1px solid red;}.ace_search_field {border-radius: 3px 0 0 3px;background-color: white;color: black;border: 1px solid #cbcbcb;border-right: 0 none;outline: 0;padding: 0;font-size: inherit;margin: 0;line-height: inherit;padding: 0 6px;min-width: 17em;vertical-align: top;min-height: 1.8em;box-sizing: content-box;}.ace_searchbtn {border: 1px solid #cbcbcb;line-height: inherit;display: inline-block;padding: 0 6px;background: #fff;border-right: 0 none;border-left: 1px solid #dcdcdc;cursor: pointer;margin: 0;position: relative;color: #666;}.ace_searchbtn:last-child {border-radius: 0 3px 3px 0;border-right: 1px solid #cbcbcb;}.ace_searchbtn:disabled {background: none;cursor: default;}.ace_searchbtn:hover {background-color: #eef1f6;}.ace_searchbtn.prev, .ace_searchbtn.next {padding: 0px 0.7em}.ace_searchbtn.prev:after, .ace_searchbtn.next:after {content: "";border: solid 2px #888;width: 0.5em;height: 0.5em;border-width:  2px 0 0 2px;display:inline-block;transform: rotate(-45deg);}.ace_searchbtn.next:after {border-width: 0 2px 2px 0 ;}.ace_searchbtn_close {background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;border-radius: 50%;border: 0 none;color: #656565;cursor: pointer;font: 16px/16px Arial;padding: 0;height: 14px;width: 14px;top: 9px;right: 7px;position: absolute;}.ace_searchbtn_close:hover {background-color: #656565;background-position: 50% 100%;color: white;}.ace_button {margin-left: 2px;cursor: pointer;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;overflow: hidden;opacity: 0.7;border: 1px solid rgba(100,100,100,0.23);padding: 1px;box-sizing:    border-box!important;color: black;}.ace_button:hover {background-color: #eee;opacity:1;}.ace_button:active {background-color: #ddd;}.ace_button.checked {border-color: #3399ff;opacity:1;}.ace_search_options{margin-bottom: 3px;text-align: right;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;clear: both;}.ace_search_counter {float: left;font-family: arial;padding: 0 8px;}',
"ace_searchbox",a.container)};(function(){this.setEditor=function(a){a.searchBox=this;a.renderer.scroller.appendChild(this.element);this.editor=a};this.setSession=function(a){this.searchRange=null;this.$syncOptions(!0)};this.$initElements=function(a){this.searchBox=a.querySelector(".ace_search_form");this.replaceBox=a.querySelector(".ace_replace_form");this.searchOption=a.querySelector("[action=searchInSelection]");this.replaceOption=a.querySelector("[action=toggleReplace]");this.regExpOption=a.querySelector("[action=toggleRegexpMode]");
this.caseSensitiveOption=a.querySelector("[action=toggleCaseSensitive]");this.wholeWordOption=a.querySelector("[action=toggleWholeWords]");this.searchInput=this.searchBox.querySelector(".ace_search_field");this.replaceInput=this.replaceBox.querySelector(".ace_search_field");this.searchCounter=a.querySelector(".ace_search_counter")};this.$init=function(){var b=this.element;this.$initElements(b);var c=this;g.addListener(b,"mousedown",function(a){setTimeout(function(){c.activeInput.focus()},0);g.stopPropagation(a)});
g.addListener(b,"click",function(a){var b=(a.target||a.srcElement).getAttribute("action");if(b&&c[b])c[b]();else c.$searchBarKb.commands[b]&&c.$searchBarKb.commands[b].exec(c);g.stopPropagation(a)});g.addCommandKeyListener(b,function(b,d,e){e=a.keyCodeToString(e);(d=c.$searchBarKb.findKeyCommand(d,e))&&d.exec&&(d.exec(c),g.stopEvent(b))});this.$onChange=r.delayedCall(function(){c.find(!1,!1)});g.addListener(this.searchInput,"input",function(){c.$onChange.schedule(20)});g.addListener(this.searchInput,
"focus",function(){c.activeInput=c.searchInput;c.searchInput.value&&c.highlight()});g.addListener(this.replaceInput,"focus",function(){c.activeInput=c.replaceInput;c.searchInput.value&&c.highlight()})};this.$closeSearchBarKb=new d([{bindKey:"Esc",name:"closeSearchBar",exec:function(a){a.searchBox.hide()}}]);this.$searchBarKb=new d;this.$searchBarKb.bindKeys({"Ctrl-f|Command-f":function(a){var b=a.isReplace=!a.isReplace;a.replaceBox.style.display=b?"":"none";a.replaceOption.checked=!1;a.$syncOptions();
a.searchInput.focus()},"Ctrl-H|Command-Option-F":function(a){a.editor.getReadOnly()||(a.replaceOption.checked=!0,a.$syncOptions(),a.replaceInput.focus())},"Ctrl-G|Command-G":function(a){a.findNext()},"Ctrl-Shift-G|Command-Shift-G":function(a){a.findPrev()},esc:function(a){setTimeout(function(){a.hide()})},Return:function(a){a.activeInput==a.replaceInput&&a.replace();a.findNext()},"Shift-Return":function(a){a.activeInput==a.replaceInput&&a.replace();a.findPrev()},"Alt-Return":function(a){a.activeInput==
a.replaceInput&&a.replaceAll();a.findAll()},Tab:function(a){(a.activeInput==a.replaceInput?a.searchInput:a.replaceInput).focus()}});this.$searchBarKb.addCommands([{name:"toggleRegexpMode",bindKey:{win:"Alt-R|Alt-/",mac:"Ctrl-Alt-R|Ctrl-Alt-/"},exec:function(a){a.regExpOption.checked=!a.regExpOption.checked;a.$syncOptions()}},{name:"toggleCaseSensitive",bindKey:{win:"Alt-C|Alt-I",mac:"Ctrl-Alt-R|Ctrl-Alt-I"},exec:function(a){a.caseSensitiveOption.checked=!a.caseSensitiveOption.checked;a.$syncOptions()}},
{name:"toggleWholeWords",bindKey:{win:"Alt-B|Alt-W",mac:"Ctrl-Alt-B|Ctrl-Alt-W"},exec:function(a){a.wholeWordOption.checked=!a.wholeWordOption.checked;a.$syncOptions()}},{name:"toggleReplace",exec:function(a){a.replaceOption.checked=!a.replaceOption.checked;a.$syncOptions()}},{name:"searchInSelection",exec:function(a){a.searchOption.checked=!a.searchRange;a.setSearchRange(a.searchOption.checked&&a.editor.getSelectionRange());a.$syncOptions()}}]);this.setSearchRange=function(a){(this.searchRange=a)?
this.searchRangeMarker=this.editor.session.addMarker(a,"ace_active-line"):this.searchRangeMarker&&(this.editor.session.removeMarker(this.searchRangeMarker),this.searchRangeMarker=null)};this.$syncOptions=function(a){k.setCssClass(this.replaceOption,"checked",this.searchRange);k.setCssClass(this.searchOption,"checked",this.searchOption.checked);this.replaceOption.textContent=this.replaceOption.checked?"-":"+";k.setCssClass(this.regExpOption,"checked",this.regExpOption.checked);k.setCssClass(this.wholeWordOption,
"checked",this.wholeWordOption.checked);k.setCssClass(this.caseSensitiveOption,"checked",this.caseSensitiveOption.checked);var b=this.editor.getReadOnly();this.replaceOption.style.display=b?"none":"";this.replaceBox.style.display=this.replaceOption.checked&&!b?"":"none";this.find(!1,!1,a)};this.highlight=function(a){this.editor.session.highlight(a||this.editor.$search.$options.re);this.editor.renderer.updateBackMarkers()};this.find=function(a,b,c){a=!this.editor.find(this.searchInput.value,{skipCurrent:a,
backwards:b,wrap:!0,regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked,preventScroll:c,range:this.searchRange})&&this.searchInput.value;k.setCssClass(this.searchBox,"ace_nomatch",a);this.editor._emit("findSearchBox",{match:!a});this.highlight();this.updateCounter()};this.updateCounter=function(){var a=this.editor,b=a.$search.$options.re,c=0,d=0;if(b){var e=this.searchRange?a.session.getTextRange(this.searchRange):a.getValue(),g=a.session.doc.positionToIndex(a.selection.anchor);
this.searchRange&&(g-=a.session.doc.positionToIndex(this.searchRange.start));b.lastIndex=0;for(var v;v=b.exec(e);){c++;a=v.index;a<=g&&d++;if(999<c)break;if(!v[0]&&(b.lastIndex=a+=1,a>=e.length))break}}this.searchCounter.textContent=d+" of "+(999<c?"999+":c)};this.findNext=function(){this.find(!0,!1)};this.findPrev=function(){this.find(!0,!0)};this.findAll=function(){var a=!this.editor.findAll(this.searchInput.value,{regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,
wholeWord:this.wholeWordOption.checked})&&this.searchInput.value;k.setCssClass(this.searchBox,"ace_nomatch",a);this.editor._emit("findSearchBox",{match:!a});this.highlight();this.hide()};this.replace=function(){this.editor.getReadOnly()||this.editor.replace(this.replaceInput.value)};this.replaceAndFindNext=function(){this.editor.getReadOnly()||(this.editor.replace(this.replaceInput.value),this.findNext())};this.replaceAll=function(){this.editor.getReadOnly()||this.editor.replaceAll(this.replaceInput.value)};
this.hide=function(){this.active=!1;this.setSearchRange(null);this.editor.off("changeSession",this.setSession);this.element.style.display="none";this.editor.keyBinding.removeKeyboardHandler(this.$closeSearchBarKb);this.editor.focus()};this.show=function(a,b){this.active=!0;this.editor.on("changeSession",this.setSession);this.element.style.display="";this.replaceOption.checked=b;a&&(this.searchInput.value=a);this.searchInput.focus();this.searchInput.select();this.editor.keyBinding.addKeyboardHandler(this.$closeSearchBarKb);
this.$syncOptions(!0)};this.isFocused=function(){var a=document.activeElement;return a==this.searchInput||a==this.replaceInput}}).call(c.prototype);e.SearchBox=c;e.Search=function(a,b){(a.searchBox||new c(a)).show(a.session.getTextRange(),b)}});(function(){ace.require(["ace/ext/searchbox"],function(b){y&&(y.exports=b)})})()},4091:function(y,e,h){y=h.nmd(y);ace.define("ace/mode/json_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(b,e,h){h=b("../lib/oop");
b=b("./text_highlight_rules").TextHighlightRules;var k=function(){this.$rules={start:[{token:"variable",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'},{token:"string",regex:'"',next:"string"},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:"text",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"comment",regex:"\\/\\/.*$"},{token:"comment.start",
regex:"\\/\\*",next:"comment"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],string:[{token:"constant.language.escape",regex:/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|["\\\/bfnrt])/},{token:"string",regex:'"|$',next:"start"},{defaultToken:"string"}],comment:[{token:"comment.end",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}]}};h.inherits(k,b);e.JsonHighlightRules=k});ace.define("ace/mode/matching_brace_outdent",["require","exports","module",
"ace/range"],function(b,e,h){var k=b("../range").Range;b=function(){};(function(){this.checkOutdent=function(b,e){return/^\s+$/.test(b)?/^\s*\}/.test(e):!1};this.autoOutdent=function(b,e){var d=b.getLine(e).match(/^(\s*\})/);if(!d)return 0;d=d[1].length;var a=b.findMatchingBracket({row:e,column:d});if(!a||a.row==e)return 0;a=this.$getIndent(b.getLine(a.row));b.replace(new k(e,0,e,d-1),a)};this.$getIndent=function(b){return b.match(/^\s*/)[0]}}).call(b.prototype);e.MatchingBraceOutdent=b});ace.define("ace/mode/folding/cstyle",
"require exports module ace/lib/oop ace/range ace/mode/folding/fold_mode".split(" "),function(b,e,h){h=b("../../lib/oop");var k=b("../../range").Range;b=b("./fold_mode").FoldMode;e=e.FoldMode=function(b){b&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+b.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+b.end)))};h.inherits(e,b);(function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/;this.foldingStopMarker=
/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/;this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/;this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/;this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/;this._getFoldWidgetBase=this.getFoldWidget;this.getFoldWidget=function(b,e,d){var a=b.getLine(d);if(this.singleLineBlockCommentRe.test(a)&&!this.startRegionRe.test(a)&&!this.tripleStarBlockCommentRe.test(a))return"";b=this._getFoldWidgetBase(b,e,d);return!b&&this.startRegionRe.test(a)?"start":b};this.getFoldWidgetRange=
function(b,e,d,a){var c=b.getLine(d);if(this.startRegionRe.test(c))return this.getCommentRegionBlock(b,c,d);var f=c.match(this.foldingStartMarker);if(f){c=f.index;if(f[1])return this.openingBracketBlock(b,f[1],d,c);(f=b.getCommentFoldRange(d,c+f[0].length,1))&&!f.isMultiLine()&&(a?f=this.getSectionRange(b,d):"all"!=e&&(f=null));return f}if("markbegin"!==e&&(f=c.match(this.foldingStopMarker)))return c=f.index+f[0].length,f[1]?this.closingBracketBlock(b,f[1],d,c):b.getCommentFoldRange(d,c,-1)};this.getSectionRange=
function(b,e){for(var d=b.getLine(e),a=d.search(/\S/),c=e,f=d.length,g=e+=1,m=b.getLength();++e<m;)if(d=b.getLine(e),d=d.search(/\S/),-1!==d){if(a>d)break;var h=this.getFoldWidgetRange(b,"all",e);if(h)if(h.start.row<=c)break;else if(h.isMultiLine())e=h.end.row;else if(a==d)break;g=e}return new k(c,f,g,b.getLine(g).length)};this.getCommentRegionBlock=function(b,e,d){for(var a=e.search(/\s*$/),c=b.getLength(),f=d,g=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,m=1;++d<c;){e=b.getLine(d);var h=g.exec(e);if(h&&
(h[1]?m--:m++,!m))break}b=d;if(b>f)return new k(f,a,b,e.length)}}).call(e.prototype)});ace.define("ace/mode/json","require exports module ace/lib/oop ace/mode/text ace/mode/json_highlight_rules ace/mode/matching_brace_outdent ace/mode/behaviour/cstyle ace/mode/folding/cstyle ace/worker/worker_client".split(" "),function(b,e,h){h=b("../lib/oop");var k=b("./text").Mode,r=b("./json_highlight_rules").JsonHighlightRules,g=b("./matching_brace_outdent").MatchingBraceOutdent,d=b("./behaviour/cstyle").CstyleBehaviour,
a=b("./folding/cstyle").FoldMode,c=b("../worker/worker_client").WorkerClient;b=function(){this.HighlightRules=r;this.$outdent=new g;this.$behaviour=new d;this.foldingRules=new a};h.inherits(b,k);(function(){this.lineCommentStart="//";this.blockComment={start:"/*",end:"*/"};this.getNextLineIndent=function(a,b,c){var d=this.$getIndent(b);"start"==a&&b.match(/^.*[\{\(\[]\s*$/)&&(d+=c);return d};this.checkOutdent=function(a,b,c){return this.$outdent.checkOutdent(b,c)};this.autoOutdent=function(a,b,c){this.$outdent.autoOutdent(b,
c)};this.createWorker=function(a){var b=new c(["ace"],"ace/mode/json_worker","JsonWorker");b.attachToDocument(a.getDocument());b.on("annotate",function(b){a.setAnnotations(b.data)});b.on("terminate",function(){a.clearAnnotations()});return b};this.$id="ace/mode/json"}).call(b.prototype);e.Mode=b});(function(){ace.require(["ace/mode/json"],function(b){y&&(y.exports=b)})})()},8903:function(y,e,h){function b(c){if(!(this instanceof b))return new b(c);c=this._opts=A.copy(c)||{};var d=this._opts.logger;
if(!1===d)this.logger={log:a,warn:a,error:a};else{void 0===d&&(d=console);if(!("object"==typeof d&&d.log&&d.warn&&d.error))throw Error("logger must implement log, warn and error methods");this.logger=d}this._schemas={};this._refs={};this._fragments={};this._formats=l(c.format);this._cache=c.cache||new w;this._loadingSchemas={};this._compilations=[];this.RULES=u();a:switch(c.schemaId){case "auto":d=g;break a;case "id":d=k;break a;default:d=x}this._getId=d;c.loopRequired=c.loopRequired||Infinity;"property"==
c.errorDataPath&&(c._errorDataPathProperty=!0);void 0===c.serialize&&(c.serialize=p);d=A.copy(this._opts);for(var e=0;e<n.length;e++)delete d[n[e]];this._metaOpts=d;if(c.formats)for(var f in this._opts.formats)this.addFormat(f,this._opts.formats[f]);if(c.keywords)for(var m in this._opts.keywords)this.addKeyword(m,this._opts.keywords[m]);this._opts.$data&&(f=h(6835),this.addMetaSchema(f,f.$id,!0));!1!==this._opts.meta&&(f=h(38),this._opts.$data&&(f=v(f,J)),this.addMetaSchema(f,q,!0),this._refs["http://json-schema.org/schema"]=
q);"object"==typeof c.meta&&this.addMetaSchema(c.meta);c.nullable&&this.addKeyword("nullable",{metaSchema:{type:"boolean"}});if(c=this._opts.schemas)if(Array.isArray(c))this.addSchema(c);else for(var r in c)this.addSchema(c[r],r)}function r(a,b){b=f.normalizeId(b);return a._schemas[b]||a._refs[b]||a._fragments[b]}function t(a,b,c){for(var d in b){var e=b[d];e.meta||c&&!c.test(d)||(a._cache.del(e.cacheKey),delete b[d])}}function k(a){a.$id&&this.logger.warn("schema $id ignored",a.$id);return a.id}
function x(a){a.id&&this.logger.warn("schema id ignored",a.id);return a.$id}function g(a){if(a.$id&&a.id&&a.$id!=a.id)throw Error("schema $id is different from id");return a.$id||a.id}function d(a,b){if(a._schemas[b]||a._refs[b])throw Error('schema with key or id "'+b+'" already exists');}function a(){}var c=h(5689),f=h(3969),w=h(5255),m=h(4293),p=h(3508),l=h(3368),u=h(742),v=h(9394),A=h(3724);y.exports=b;b.prototype.validate=function(a,b){if("string"==typeof a){var c=this.getSchema(a);if(!c)throw Error('no schema with key or ref "'+
a+'"');}else c=this._addSchema(a),c=c.validate||this._compile(c);b=c(b);!0!==c.$async&&(this.errors=c.errors);return b};b.prototype.compile=function(a,b){a=this._addSchema(a,void 0,b);return a.validate||this._compile(a)};b.prototype.addSchema=function(a,b,c,e){if(Array.isArray(a)){for(b=0;b<a.length;b++)this.addSchema(a[b],void 0,c,e);return this}var g=this._getId(a);if(void 0!==g&&"string"!=typeof g)throw Error("schema id must be string");b=f.normalizeId(b||g);d(this,b);this._schemas[b]=this._addSchema(a,
c,e,!0);return this};b.prototype.addMetaSchema=function(a,b,c){this.addSchema(a,b,c,!0);return this};b.prototype.validateSchema=function(a,b){var c=a.$schema;if(void 0!==c&&"string"!=typeof c)throw Error("$schema must be a string");(c=c||this._opts.defaultMeta)||(c=this._opts.meta,this._opts.defaultMeta="object"==typeof c?this._getId(c)||c:this.getSchema(q)?q:void 0,c=this._opts.defaultMeta);if(!c)return this.logger.warn("meta-schema not available"),this.errors=null,!0;a=this.validate(c,a);if(!a&&
b)if(b="schema is invalid: "+this.errorsText(),"log"==this._opts.validateSchema)this.logger.error(b);else throw Error(b);return a};b.prototype.getSchema=function(a){var b=r(this,a);switch(typeof b){case "object":return b.validate||this._compile(b);case "string":return this.getSchema(b);case "undefined":var d=f.schema.call(this,{schema:{}},a);if(d){b=d.schema;var e=d.root;d=d.baseId;var g=c.call(this,b,e,void 0,d);this._fragments[a]=new m({ref:a,fragment:!0,schema:b,root:e,baseId:d,validate:g});a=
g}else a=void 0;return a}};b.prototype.removeSchema=function(a){if(a instanceof RegExp)return t(this,this._schemas,a),t(this,this._refs,a),this;switch(typeof a){case "undefined":t(this,this._schemas);t(this,this._refs);this._cache.clear();break;case "string":var b=r(this,a);b&&this._cache.del(b.cacheKey);delete this._schemas[a];delete this._refs[a];break;case "object":if(b=(b=this._opts.serialize)?b(a):a,this._cache.del(b),a=this._getId(a))a=f.normalizeId(a),delete this._schemas[a],delete this._refs[a]}return this};
b.prototype.addFormat=function(a,b){"string"==typeof b&&(b=new RegExp(b));this._formats[a]=b;return this};b.prototype.errorsText=function(a,b){a=a||this.errors;if(!a)return"No errors";b=b||{};var c=void 0===b.separator?", ":b.separator;b=void 0===b.dataVar?"data":b.dataVar;for(var d="",e=0;e<a.length;e++){var f=a[e];f&&(d+=b+f.dataPath+" "+f.message+c)}return d.slice(0,-c.length)};b.prototype._addSchema=function(a,b,c,e){if("object"!=typeof a&&"boolean"!=typeof a)throw Error("schema should be object or boolean");
var g=this._opts.serialize;g=g?g(a):a;var l=this._cache.get(g);if(l)return l;e=e||!1!==this._opts.addUsedSchema;(l=f.normalizeId(this._getId(a)))&&e&&d(this,l);b=!1!==this._opts.validateSchema&&!b;var v;b&&!(v=l&&l==f.normalizeId(a.$schema))&&this.validateSchema(a,!0);var q=f.ids.call(this,a);c=new m({id:l,schema:a,localRefs:q,cacheKey:g,meta:c});"#"!=l[0]&&e&&(this._refs[l]=c);this._cache.put(g,c);b&&v&&this.validateSchema(a,!0);return c};b.prototype._compile=function(a,b){function d(){var b=a.validate,
c=b.apply(this,arguments);d.errors=b.errors;return c}if(a.compiling)return a.validate=d,d.schema=a.schema,d.errors=null,d.root=b?b:d,!0===a.schema.$async&&(d.$async=!0),d;a.compiling=!0;if(a.meta){var e=this._opts;this._opts=this._metaOpts}try{var f=c.call(this,a.schema,b,a.localRefs)}catch(F){throw delete a.validate,F;}finally{a.compiling=!1,a.meta&&(this._opts=e)}a.validate=f;a.refs=f.refs;a.refVal=f.refVal;a.root=f.root;return f};b.prototype.compileAsync=h(9677);y=h(7931);b.prototype.addKeyword=
y.add;b.prototype.getKeyword=y.get;b.prototype.removeKeyword=y.remove;b.prototype.validateKeyword=y.validate;y=h(5359);b.ValidationError=y.Validation;b.MissingRefError=y.MissingRef;b.$dataMetaSchema=v;var q="http://json-schema.org/draft-07/schema",n=["removeAdditional","useDefaults","coerceTypes","strictDefaults"],J=["/properties"]},5255:function(y){y=y.exports=function(){this._cache={}};y.prototype.put=function(e,h){this._cache[e]=h};y.prototype.get=function(e){return this._cache[e]};y.prototype.del=
function(e){delete this._cache[e]};y.prototype.clear=function(){this._cache={}}},9677:function(y,e,h){function b(e,k,h){function g(c){return(c=c.$schema)&&!a.getSchema(c)?b.call(a,{$ref:c},!0):Promise.resolve()}function d(b){function c(c){function e(){delete a._loadingSchemas[f]}var f=c.missingSchema;if(a._refs[f]||a._schemas[f])throw Error("Schema "+f+" is loaded but "+c.missingRef+" cannot be resolved");c=a._loadingSchemas[f];c||(c=a._loadingSchemas[f]=a._opts.loadSchema(f),c.then(e,e));return c.then(function(b){if(!a._refs[f]&&
!a._schemas[f])return g(b).then(function(){a._refs[f]||a._schemas[f]||a.addSchema(b,f,void 0,k)})}).then(function(){return d(b)})}try{return a._compile(b)}catch(m){if(m instanceof r)return c(m);throw m;}}var a=this;if("function"!=typeof this._opts.loadSchema)throw Error("options.loadSchema should be a function");"function"==typeof k&&(h=k,k=void 0);var c=g(e).then(function(){var b=a._addSchema(e,void 0,k);return b.validate||d(b)});h&&c.then(function(a){h(null,a)},h);return c}var r=h(5359).MissingRef;
y.exports=b},5359:function(y,e,h){function b(e,h,g){this.message=g||b.message(e,h);this.missingRef=t.url(e,h);this.missingSchema=t.normalizeId(t.fullPath(this.missingRef))}function r(b){b.prototype=Object.create(Error.prototype);return b.prototype.constructor=b}var t=h(3969);y.exports={Validation:r(function(b){this.message="validation failed";this.errors=b;this.ajv=this.validation=!0}),MissingRef:r(b)};b.message=function(b,e){return"can't resolve reference "+e+" from id "+b}},3368:function(y,e,h){function b(a){return x.copy(b["full"==
a?"full":"fast"])}function r(a){var b=a.match(g);if(!b)return!1;a=+b[1];var c=+b[2];b=+b[3];return 1<=c&&12>=c&&1<=b&&b<=(2!=c||0!==a%4||0===a%100&&0!==a%400?d[c]:29)}function t(b,c){var d=b.match(a);if(!d)return!1;b=d[1];var e=d[2],f=d[3];d=d[5];return(23>=b&&59>=e&&59>=f||23==b&&59==e&&60==f)&&(!c||d)}function k(a){if(A.test(a))return!1;try{return new RegExp(a),!0}catch(n){return!1}}var x=h(3724),g=/^(\d\d\d\d)-(\d\d)-(\d\d)$/,d=[0,31,28,31,30,31,30,31,31,30,31,30,31],a=/^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d(?::?\d\d)?)?$/i;
e=/^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i;var c=/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
h=/^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i;var f=/^(?:(?:http[s\u017F]?|ftp):\/\/)(?:(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+(?::(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?@)?(?:(?!10(?:\.[0-9]{1,3}){3})(?!127(?:\.[0-9]{1,3}){3})(?!169\.254(?:\.[0-9]{1,3}){2})(?!192\.168(?:\.[0-9]{1,3}){2})(?!172\.(?:1[6-9]|2[0-9]|3[01])(?:\.[0-9]{1,3}){2})(?:[1-9][0-9]?|1[0-9][0-9]|2[01][0-9]|22[0-3])(?:\.(?:1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}(?:\.(?:[1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-4]))|(?:(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)(?:\.(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)*(?:\.(?:(?:[a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]){2,})))(?::[0-9]{2,5})?(?:\/(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/i,
w=/^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i,m=/^(?:\/(?:[^~/]|~0|~1)*)*$/,p=/^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i,l=/^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/;y.exports=b;b.fast={date:/^\d\d\d\d-[0-1]\d-[0-3]\d$/,time:/^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i,"date-time":/^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i,uri:/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/)?[^\s]*$/i,
"uri-reference":/^(?:(?:[a-z][a-z0-9+\-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,"uri-template":h,url:f,email:/^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,hostname:e,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,
regex:k,uuid:w,"json-pointer":m,"json-pointer-uri-fragment":p,"relative-json-pointer":l};b.full={date:r,time:t,"date-time":function(a){a=a.split(u);return 2==a.length&&r(a[0])&&t(a[1],!0)},uri:function(a){return v.test(a)&&c.test(a)},"uri-reference":/^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,
"uri-template":h,url:f,email:/^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,hostname:e,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,
regex:k,uuid:w,"json-pointer":m,"json-pointer-uri-fragment":p,"relative-json-pointer":l};var u=/t|\s/i,v=/\/|:/,A=/[^\\]\\Z/},5689:function(y,e,h){function b(e,k,h,y){function q(){var a=ca.validate,b=a.apply(this,arguments);q.errors=a.errors;return b}function n(e,q,h,n){var p=!q||q&&q.schema==e;if(q.schema!=k.schema)return b.call(I,e,q,h,n);h=!0===e.$async;n=l({isTop:!0,schema:e,isRoot:p,baseId:n,root:q,schemaPath:"",errSchemaPath:"#",errorPath:'""',MissingRefError:m.MissingRef,RULES:ba,validate:l,
util:w,resolve:f,resolveRef:J,usePattern:B,useDefault:G,useCustomRule:M,opts:C,formats:T,logger:I.logger,self:I});n=c(L,d)+c(S,x)+c(U,g)+c(P,a)+n;C.processCode&&(n=C.processCode(n,e));try{var r=(new Function("self","RULES","formats","root","refVal","defaults","customRules","equal","ucs2length","ValidationError",n))(I,ba,T,k,L,U,P,v,u,A);L[0]=r}catch(da){throw I.logger.error("Error compiling schema, function code:",n),da;}r.schema=e;r.errors=null;r.refs=Q;r.refVal=L;r.root=p?r:q;h&&(r.$async=!0);!0===
C.sourceCode&&(r.source={code:n,patterns:S,defaults:U});return r}function J(a,c,d){c=f.url(a,c);var e=Q[c];if(void 0!==e)return a=L[e],F(a,"refVal["+e+"]");if(!d&&k.refs&&(e=k.refs[c],void 0!==e))return a=k.refVal[e],e=K(c,a),F(a,e);e=K(c);d=f.call(I,n,k,c);if(void 0===d){var g=h&&h[c];g&&(d=f.inlineRef(g,C.inlineRefs)?g:b.call(I,g,k,h,a))}if(void 0===d)delete Q[c];else return L[Q[c]]=d,F(d,e)}function K(a,b){var c=L.length;L[c]=b;Q[a]=c;return"refVal"+c}function F(a,b){return"object"==typeof a||
"boolean"==typeof a?{code:b,schema:a,inline:!0}:{code:b,$async:a&&!!a.$async}}function B(a){var b=O[a];void 0===b&&(b=O[a]=S.length,S[b]=a);return"pattern"+b}function G(a){switch(typeof a){case "boolean":case "number":return""+a;case "string":return w.toQuotedString(a);case "object":if(null===a)return"null";var b=p(a),c=R[b];void 0===c&&(c=R[b]=U.length,U[c]=a);return"default"+c}}function M(a,b,c,d){if(!1!==I._opts.validateSchema){var e=a.definition.dependencies;if(e&&!e.every(function(a){return Object.prototype.hasOwnProperty.call(c,
a)}))throw Error("parent schema must have all required keywords: "+e.join(","));if((e=a.definition.validateSchema)&&!e(b))if(e="keyword schema is invalid: "+I.errorsText(e.errors),"log"==I._opts.validateSchema)I.logger.error(e);else throw Error(e);}e=a.definition.compile;var f=a.definition.inline,g=a.definition.macro;if(e)b=e.call(I,b,c,d);else if(g)b=g.call(I,b,c,d),!1!==C.validateSchema&&I.validateSchema(b,!0);else if(f)b=f.call(I,d,a.keyword,b,c);else if(b=a.definition.validate,!b)return;if(void 0===
b)throw Error('custom keyword "'+a.keyword+'"failed to compile');a=P.length;P[a]=b;return{code:"customRule"+a,validate:b}}var I=this,C=this._opts,L=[void 0],Q={},S=[],O={},U=[],R={},P=[];k=k||{schema:e,refVal:L,refs:Q};var X=r.call(this,e,k,y),ca=this._compilations[X.index];if(X.compiling)return ca.callValidate=q;var T=this._formats,ba=this.RULES;try{var N=n(e,k,h,y);ca.validate=N;var V=ca.callValidate;V&&(V.schema=N.schema,V.errors=null,V.refs=N.refs,V.refVal=N.refVal,V.root=N.root,V.$async=N.$async,
C.sourceCode&&(V.source=N.source));return N}finally{t.call(this,e,k,y)}}function r(a,b,c){var d=k.call(this,a,b,c);if(0<=d)return{index:d,compiling:!0};d=this._compilations.length;this._compilations[d]={schema:a,root:b,baseId:c};return{index:d,compiling:!1}}function t(a,b,c){a=k.call(this,a,b,c);0<=a&&this._compilations.splice(a,1)}function k(a,b,c){for(var d=0;d<this._compilations.length;d++){var e=this._compilations[d];if(e.schema==a&&e.root==b&&e.baseId==c)return d}return-1}function x(a,b){return"var pattern"+
a+" = new RegExp("+w.toQuotedString(b[a])+");"}function g(a){return"var default"+a+" = defaults["+a+"];"}function d(a,b){return void 0===b[a]?"":"var refVal"+a+" = refVal["+a+"];"}function a(a){return"var customRule"+a+" = customRules["+a+"];"}function c(a,b){if(!a.length)return"";for(var c="",d=0;d<a.length;d++)c+=b(d,a);return c}var f=h(3969),w=h(3724),m=h(5359),p=h(3508),l=h(1869),u=w.ucs2length,v=h(2303),A=m.Validation;y.exports=b},3969:function(y,e,h){function b(a,c,d){var e=this._refs[d];if("string"==
typeof e)if(this._refs[e])e=this._refs[e];else return b.call(this,a,c,e);e=e||this._schemas[d];if(e instanceof p)return k(e.schema,this._opts.inlineRefs)?e.schema:e.validate||this._compile(e);d=r.call(this,c,d);var f;if(d){var g=d.schema;c=d.root;var l=d.baseId}g instanceof p?f=g.validate||a.call(this,g.schema,c,void 0,l):void 0!==g&&(f=k(g,this._opts.inlineRefs)?g:a.call(this,g,c,void 0,l));return f}function r(b,e){var g=f.parse(e),l=f.serialize(g).split("#")[0]+"#",v=d(this._getId(b.schema));if(0===
Object.keys(b.schema).length||l!==v){l=a(l);var m=this._refs[l];if("string"==typeof m)return(v=r.call(this,b,m))?(b=v.schema,e=v.baseId,v=v.root,(l=this._getId(b))&&(e=c(e,l)),g=t.call(this,g,e,b,v)):g=void 0,g;if(m instanceof p)m.validate||this._compile(m),b=m;else if(m=this._schemas[l],m instanceof p){m.validate||this._compile(m);if(l==a(e))return{schema:m,root:b,baseId:v};b=m}else return;if(!b.schema)return;v=d(this._getId(b.schema))}return t.call(this,g,v,b.schema,b)}function t(a,b,d,e){a.fragment=
a.fragment||"";if("/"==a.fragment.slice(0,1)){a=a.fragment.split("/");for(var f=1;f<a.length;f++){var g=a[f];if(g){g=m.unescapeFragment(g);d=d[g];if(void 0===d)break;!u[g]&&((g=this._getId(d))&&(b=c(b,g)),d.$ref&&(g=c(b,d.$ref),g=r.call(this,e,g)))&&(d=g.schema,e=g.root,b=g.baseId)}}if(void 0!==d&&d!==e.schema)return{schema:d,root:e,baseId:b}}}function k(a,b){if(!1===b)return!1;if(void 0===b||!0===b)return x(a);if(b)return g(a)<=b}function x(a){if(Array.isArray(a))for(var b=0;b<a.length;b++){var c=
a[b];if("object"==typeof c&&!x(c))return!1}else for(b in a){if("$ref"==b)return!1;c=a[b];if("object"==typeof c&&!x(c))return!1}return!0}function g(a){var b=0;if(Array.isArray(a))for(var c=0;c<a.length;c++){var d=a[c];"object"==typeof d&&(b+=g(d));if(Infinity==b)return Infinity}else for(c in a){if("$ref"==c)return Infinity;if(v[c])b++;else if(d=a[c],"object"==typeof d&&(b+=g(d)+1),Infinity==b)return Infinity}return b}function d(b,c){!1!==c&&(b=a(b));b=f.parse(b);return f.serialize(b).split("#")[0]+
"#"}function a(a){return a?a.replace(A,""):""}function c(b,c){c=a(c);return f.resolve(b,c)}var f=h(7533),w=h(2303),m=h(3724),p=h(4293),l=h(500);y.exports=b;b.normalizeId=a;b.fullPath=d;b.url=c;b.ids=function(b){var c=a(this._getId(b)),e={"":c},g={"":d(c,!1)},v={},k=this;l(b,{allKeys:!0},function(b,c,d,l,h,q,n){if(""!==c){d=k._getId(b);q=e[l];l=g[l]+"/"+h;void 0!==n&&(l+="/"+("number"==typeof n?n:m.escapeFragment(n)));if("string"==typeof d)if(d=q=a(q?f.resolve(q,d):d),n=k._refs[d],"string"==typeof n&&
(n=k._refs[n]),n&&n.schema){if(!w(b,n.schema))throw Error('id "'+d+'" resolves to more than one schema');}else if(d!=a(l))if("#"==d[0]){if(v[d]&&!w(b,v[d]))throw Error('id "'+d+'" resolves to more than one schema');v[d]=b}else k._refs[d]=l;e[c]=q;g[c]=l}});return v};b.inlineRef=k;b.schema=r;var u=m.toHash(["properties","patternProperties","enum","dependencies","definitions"]),v=m.toHash("type format pattern maxLength minLength maxProperties minProperties maxItems minItems maximum minimum uniqueItems multipleOf required enum".split(" ")),
A=/#\/?$/},742:function(y,e,h){var b=h(9646),r=h(3724).toHash;y.exports=function(){var e=[{type:"number",rules:[{maximum:["exclusiveMaximum"]},{minimum:["exclusiveMinimum"]},"multipleOf","format"]},{type:"string",rules:["maxLength","minLength","pattern","format"]},{type:"array",rules:["maxItems","minItems","items","contains","uniqueItems"]},{type:"object",rules:["maxProperties","minProperties","required","dependencies","propertyNames",{properties:["additionalProperties","patternProperties"]}]},{rules:"$ref const enum not anyOf oneOf allOf if".split(" ")}],
k=["type","$comment"];e.all=r(k);e.types=r("number integer string array object boolean null".split(" "));e.forEach(function(h){h.rules=h.rules.map(function(g){if("object"==typeof g){var d=Object.keys(g)[0];var a=g[d];g=d;a.forEach(function(a){k.push(a);e.all[a]=!0})}k.push(g);return e.all[g]={keyword:g,code:b[g],implements:a}});e.all.$comment={keyword:"$comment",code:b.$comment};h.type&&(e.types[h.type]=h)});e.keywords=r(k.concat("$schema $id id $data $async title description default definitions examples readOnly writeOnly contentMediaType contentEncoding additionalItems then else".split(" ")));
e.custom={};return e}},4293:function(y,e,h){var b=h(3724);y.exports=function(e){b.copy(e,this)}},6887:function(y){y.exports=function(e){for(var h=0,b=e.length,r=0,t;r<b;)h++,t=e.charCodeAt(r++),55296<=t&&56319>=t&&r<b&&(t=e.charCodeAt(r),56320==(t&64512)&&r++);return h}},3724:function(y,e,h){function b(a,b,c,d){var e=d?" !== ":" === ",f=d?" || ":" && ",g=d?"!":"";d=d?"":"!";switch(a){case "null":return b+e+"null";case "array":return g+"Array.isArray("+b+")";case "object":return"("+g+b+f+"typeof "+
b+e+'"object"'+f+d+"Array.isArray("+b+"))";case "integer":return"(typeof "+b+e+'"number"'+f+d+"("+b+" % 1)"+f+b+e+b+(c?f+g+"isFinite("+b+")":"")+")";case "number":return"(typeof "+b+e+'"'+a+'"'+(c?f+g+"isFinite("+b+")":"")+")";default:return"typeof "+b+e+'"'+a+'"'}}function r(a){for(var b={},c=0;c<a.length;c++)b[a[c]]=!0;return b}function t(a){return"number"==typeof a?"["+a+"]":f.test(a)?"."+a:"['"+k(a)+"']"}function k(a){return a.replace(w,"\\$&").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/\f/g,
"\\f").replace(/\t/g,"\\t")}function x(a){return"'"+k(a)+"'"}function g(a,b){return'""'==a?b:(a+" + "+b).replace(/([^\\])' \+ '/g,"$1")}function d(a){return a.replace(/~/g,"~0").replace(/\//g,"~1")}function a(a){return a.replace(/~1/g,"/").replace(/~0/g,"~")}y.exports={copy:function(a,b){b=b||{};for(var c in a)b[c]=a[c];return b},checkDataType:b,checkDataTypes:function(a,c,d){switch(a.length){case 1:return b(a[0],c,d,!0);default:var e="";a=r(a);a.array&&a.object&&(e=a.null?"(":"(!"+c+" || ",e+="typeof "+
c+' !== "object")',delete a.null,delete a.array,delete a.object);a.number&&delete a.integer;for(var f in a)e+=(e?" && ":"")+b(f,c,d,!0);return e}},coerceToTypes:function(a,b){if(Array.isArray(b)){for(var d=[],e=0;e<b.length;e++){var f=b[e];c[f]?d[d.length]=f:"array"===a&&"array"===f&&(d[d.length]=f)}if(d.length)return d}else{if(c[b])return[b];if("array"===a&&"array"===b)return["array"]}},toHash:r,getProperty:t,escapeQuotes:k,equal:h(2303),ucs2length:h(6887),varOccurences:function(a,b){return(a=a.match(new RegExp(b+
"[^0-9]","g")))?a.length:0},varReplace:function(a,b,c){b+="([^0-9])";c=c.replace(/\$/g,"$$$$");return a.replace(new RegExp(b,"g"),c+"$1")},schemaHasRules:function(a,b){if("boolean"==typeof a)return!a;for(var c in a)if(b[c])return!0},schemaHasRulesExcept:function(a,b,c){if("boolean"==typeof a)return!a&&"not"!=c;for(var d in a)if(d!=c&&b[d])return!0},schemaUnknownRules:function(a,b){if("boolean"!=typeof a)for(var c in a)if(!b[c])return c},toQuotedString:x,getPathExpr:function(a,b,c,d){return g(a,c?
"'/' + "+b+(d?"":".replace(/~/g, '~0').replace(/\\//g, '~1')"):d?"'[' + "+b+" + ']'":"'[\\'' + "+b+" + '\\']'")},getPath:function(a,b,c){b=c?x("/"+d(b)):x(t(b));return g(a,b)},getData:function(b,c,d){if(""===b)return"rootData";if("/"==b[0]){if(!m.test(b))throw Error("Invalid JSON-pointer: "+b);var e=b;c="rootData"}else{e=b.match(p);if(!e)throw Error("Invalid JSON-pointer: "+b);b=+e[1];e=e[2];if("#"==e){if(b>=c)throw Error("Cannot access property/index "+b+" levels up, current level is "+c);return d[c-
b]}if(b>c)throw Error("Cannot access data "+b+" levels up, current level is "+c);c="data"+(c-b||"");if(!e)return c}d=c;e=e.split("/");for(b=0;b<e.length;b++){var f=e[b];f&&(c+=t(a(f)),d+=" && "+c)}return d},unescapeFragment:function(b){return a(decodeURIComponent(b))},unescapeJsonPointer:a,escapeFragment:function(a){return encodeURIComponent(d(a))},escapeJsonPointer:d};var c=r(["string","number","integer","boolean","null"]),f=/^[a-z$_][a-z$_0-9]*$/i,w=/'|\\/g,m=/^\/(?:[^~]|~0|~1)*$/,p=/^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/},
9394:function(y){var e="multipleOf maximum exclusiveMaximum minimum exclusiveMinimum maxLength minLength pattern additionalItems maxItems minItems uniqueItems maxProperties minProperties required additionalProperties enum format const".split(" ");y.exports=function(h,b){for(var r=0;r<b.length;r++){h=JSON.parse(JSON.stringify(h));var t=b[r].split("/"),k=h,x;for(x=1;x<t.length;x++)k=k[t[x]];for(x=0;x<e.length;x++){t=e[x];var g=k[t];g&&(k[t]={anyOf:[g,{$ref:"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"}]})}}return h}},
5868:function(y,e,h){e=h(38);y.exports={$id:"https://github.com/ajv-validator/ajv/blob/master/lib/definition_schema.js",definitions:{simpleTypes:e.definitions.simpleTypes},type:"object",dependencies:{schema:["validate"],$data:["validate"],statements:["inline"],valid:{not:{required:["macro"]}}},properties:{type:e.properties.type,schema:{type:"boolean"},statements:{type:"boolean"},dependencies:{type:"array",items:{type:"string"}},metaSchema:{type:"object"},modifying:{type:"boolean"},valid:{type:"boolean"},
$data:{type:"boolean"},async:{type:"boolean"},errors:{anyOf:[{type:"boolean"},{const:"full"}]}}}},1796:function(y){y.exports=function(e,h,b){b=" ";var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+e.util.getProperty(h),g=e.errSchemaPath+"/"+h,d=!e.opts.allErrors,a="data"+(t||""),c=e.opts.$data&&k&&k.$data;if(c){b+=" var schema"+r+" = "+e.util.getData(k.$data,t,e.dataPathArr)+"; ";var f="schema"+r}else f=k;var w="maximum"==h,m=w?"exclusiveMaximum":"exclusiveMinimum",p=e.schema[m],l=e.opts.$data&&
p&&p.$data,u=w?"<":">",v=w?">":"<";var A=void 0;if(!c&&"number"!=typeof k&&void 0!==k)throw Error(h+" must be number");if(!l&&void 0!==p&&"number"!=typeof p&&"boolean"!=typeof p)throw Error(m+" must be number or boolean");if(l){p=e.util.getData(p.$data,t,e.dataPathArr);var q="exclusive"+r,n="exclType"+r;w="op"+r;t="' + "+w+" + '";b+=" var schemaExcl"+r+" = "+p+"; ";p="schemaExcl"+r;A=m;var y=y||[];y.push(b+(" var "+q+"; var "+n+" = typeof "+p+"; if ("+n+" != 'boolean' && "+n+" != 'undefined' && "+
n+" != 'number') { "));b="";!1!==e.createErrors?(b+=" { keyword: '"+(A||"_exclusiveLimit")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: {} ",!1!==e.opts.messages&&(b+=" , message: '"+m+" should be boolean' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+a+" "),b+=" } "):b+=" {} ";var K=b;b=y.pop();b=!e.compositeRule&&d?e.async?b+(" throw new ValidationError(["+K+"]); "):b+(" validate.errors = ["+
K+"]; return false; "):b+(" var err = "+K+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");b+=" } else if ( ";c&&(b+=" ("+f+" !== undefined && typeof "+f+" != 'number') || ");b+=" "+n+" == 'number' ? ( ("+q+" = "+f+" === undefined || "+p+" "+u+"= "+f+") ? "+a+" "+v+"= "+p+" : "+a+" "+v+" "+f+" ) : ( ("+q+" = "+p+" === true) ? "+a+" "+v+"= "+f+" : "+a+" "+v+" "+f+" ) || "+a+" !== "+a+") { var op"+r+" = "+q+" ? '"+u+"' : '"+u+"='; ";void 0===k&&(A=m,g=e.errSchemaPath+
"/"+m,f=p,c=l)}else r="number"==typeof p,t=u,r&&c?(w="'"+t+"'",b+=" if ( ",c&&(b+=" ("+f+" !== undefined && typeof "+f+" != 'number') || "),b+=" ( "+f+" === undefined || "+p+" "+u+"= "+f+" ? "+a+" "+v+"= "+p+" : "+a+" "+v+" "+f+" ) || "+a+" !== "+a+") { "):(r&&void 0===k?(q=!0,A=m,g=e.errSchemaPath+"/"+m,f=p,v+="="):(r&&(f=Math[w?"min":"max"](p,k)),p===(r?f:!0)?(q=!0,A=m,g=e.errSchemaPath+"/"+m,v+="="):(q=!1,t+="=")),w="'"+t+"'",b+=" if ( ",c&&(b+=" ("+f+" !== undefined && typeof "+f+" != 'number') || "),
b+=" "+a+" "+v+" "+f+" || "+a+" !== "+a+") { ");A=A||h;y=y||[];y.push(b);b="";!1!==e.createErrors?(b+=" { keyword: '"+(A||"_limit")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { comparison: "+w+", limit: "+f+", exclusive: "+q+" } ",!1!==e.opts.messages&&(b+=" , message: 'should be "+t+" ",b=c?b+("' + "+f):b+(""+f+"'")),e.opts.verbose&&(b+=" , schema:  ",b=(c?b+("validate.schema"+x):b+(""+k))+("         , parentSchema: validate.schema"+e.schemaPath+
" , data: "+a+" ")),b+=" } "):b+=" {} ";K=b;b=y.pop();b=!e.compositeRule&&d?e.async?b+(" throw new ValidationError(["+K+"]); "):b+(" validate.errors = ["+K+"]; return false; "):b+(" var err = "+K+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");b+=" } ";d&&(b+=" else { ");return b}},2407:function(y){y.exports=function(e,h,b){b=" ";var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+e.util.getProperty(h),g=e.errSchemaPath+"/"+h,d=!e.opts.allErrors,a="data"+(t||""),
c=e.opts.$data&&k&&k.$data;c?(b+=" var schema"+r+" = "+e.util.getData(k.$data,t,e.dataPathArr)+"; ",r="schema"+r):r=k;if(!c&&"number"!=typeof k)throw Error(h+" must be number");b+="if ( ";c&&(b+=" ("+r+" !== undefined && typeof "+r+" != 'number') || ");var f=f||[];f.push(b+(" "+a+".length "+("maxItems"==h?">":"<")+" "+r+") { "));b="";!1!==e.createErrors?(b+=" { keyword: '"+(h||"_limitItems")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { limit: "+
r+" } ",!1!==e.opts.messages&&(b+=" , message: 'should NOT have ",b="maxItems"==h?b+"more":b+"fewer",b+=" than ",b=c?b+("' + "+r+" + '"):b+(""+k),b+=" items' "),e.opts.verbose&&(b+=" , schema:  ",b=c?b+("validate.schema"+x):b+(""+k),b+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+a+" "),b+=" } "):b+=" {} ";h=b;b=f.pop();b=!e.compositeRule&&d?e.async?b+(" throw new ValidationError(["+h+"]); "):b+(" validate.errors = ["+h+"]; return false; "):b+(" var err = "+h+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");
b+="} ";d&&(b+=" else { ");return b}},1250:function(y){y.exports=function(e,h,b){b=" ";var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+e.util.getProperty(h),g=e.errSchemaPath+"/"+h,d=!e.opts.allErrors,a="data"+(t||""),c=e.opts.$data&&k&&k.$data;c?(b+=" var schema"+r+" = "+e.util.getData(k.$data,t,e.dataPathArr)+"; ",r="schema"+r):r=k;if(!c&&"number"!=typeof k)throw Error(h+" must be number");b+="if ( ";c&&(b+=" ("+r+" !== undefined && typeof "+r+" != 'number') || ");b=!1===e.opts.unicode?
b+(" "+a+".length "):b+(" ucs2length("+a+") ");var f=f||[];f.push(b+(" "+("maxLength"==h?">":"<")+" "+r+") { "));b="";!1!==e.createErrors?(b+=" { keyword: '"+(h||"_limitLength")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { limit: "+r+" } ",!1!==e.opts.messages&&(b+=" , message: 'should NOT be ",b="maxLength"==h?b+"longer":b+"shorter",b+=" than ",b=c?b+("' + "+r+" + '"):b+(""+k),b+=" characters' "),e.opts.verbose&&(b+=" , schema:  ",b=c?b+
("validate.schema"+x):b+(""+k),b+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+a+" "),b+=" } "):b+=" {} ";h=b;b=f.pop();b=!e.compositeRule&&d?e.async?b+(" throw new ValidationError(["+h+"]); "):b+(" validate.errors = ["+h+"]; return false; "):b+(" var err = "+h+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");b+="} ";d&&(b+=" else { ");return b}},2596:function(y){y.exports=function(e,h,b){b=" ";var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+
e.util.getProperty(h),g=e.errSchemaPath+"/"+h,d=!e.opts.allErrors,a="data"+(t||""),c=e.opts.$data&&k&&k.$data;c?(b+=" var schema"+r+" = "+e.util.getData(k.$data,t,e.dataPathArr)+"; ",r="schema"+r):r=k;if(!c&&"number"!=typeof k)throw Error(h+" must be number");b+="if ( ";c&&(b+=" ("+r+" !== undefined && typeof "+r+" != 'number') || ");var f=f||[];f.push(b+(" Object.keys("+a+").length "+("maxProperties"==h?">":"<")+" "+r+") { "));b="";!1!==e.createErrors?(b+=" { keyword: '"+(h||"_limitProperties")+
"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { limit: "+r+" } ",!1!==e.opts.messages&&(b+=" , message: 'should NOT have ",b="maxProperties"==h?b+"more":b+"fewer",b+=" than ",b=c?b+("' + "+r+" + '"):b+(""+k),b+=" properties' "),e.opts.verbose&&(b+=" , schema:  ",b=c?b+("validate.schema"+x):b+(""+k),b+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+a+" "),b+=" } "):b+=" {} ";h=b;b=f.pop();b=!e.compositeRule&&d?e.async?b+
(" throw new ValidationError(["+h+"]); "):b+(" validate.errors = ["+h+"]; return false; "):b+(" var err = "+h+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");b+="} ";d&&(b+=" else { ");return b}},9486:function(y){y.exports=function(e,h,b){b=" ";var r=e.schema[h],t=e.schemaPath+e.util.getProperty(h);h=e.errSchemaPath+"/"+h;var k=!e.opts.allErrors,x=e.util.copy(e),g="";x.level++;var d="valid"+x.level,a=x.baseId,c=!0;if(r)for(var f,w=-1,m=r.length-1;w<m;)if(f=r[w+=1],
e.opts.strictKeywords?"object"==typeof f&&0<Object.keys(f).length||!1===f:e.util.schemaHasRules(f,e.RULES.all))c=!1,x.schema=f,x.schemaPath=t+"["+w+"]",x.errSchemaPath=h+"/"+w,b+="  "+e.validate(x)+" ",x.baseId=a,k&&(b+=" if ("+d+") { ",g+="}");k&&(b=c?b+" if (true) { ":b+(" "+g.slice(0,-1)+" "));return b}},5347:function(y){y.exports=function(e,h,b){b=" ";var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+e.util.getProperty(h);h=e.errSchemaPath+"/"+h;var g=!e.opts.allErrors;t="data"+(t||"");
var d="valid"+r;r="errs__"+r;var a=e.util.copy(e),c="";a.level++;var f="valid"+a.level;if(k.every(function(a){return e.opts.strictKeywords?"object"==typeof a&&0<Object.keys(a).length||!1===a:e.util.schemaHasRules(a,e.RULES.all)})){var w=a.baseId;b+=" var "+r+" = errors; var "+d+" = false;  ";var m=e.compositeRule;e.compositeRule=a.compositeRule=!0;if(k)for(var p,l=-1,u=k.length-1;l<u;)p=k[l+=1],a.schema=p,a.schemaPath=x+"["+l+"]",a.errSchemaPath=h+"/"+l,b+="  "+e.validate(a)+" ",a.baseId=w,b+=" "+
d+" = "+d+" || "+f+"; if (!"+d+") { ",c+="}";e.compositeRule=a.compositeRule=m;b+=" "+c+" if (!"+d+") {   var err =   ";!1!==e.createErrors?(b+=" { keyword: 'anyOf' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: {} ",!1!==e.opts.messages&&(b+=" , message: 'should match some schema in anyOf' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+t+" "),b+=" } "):b+=" {} ";b+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
!e.compositeRule&&g&&(b=e.async?b+" throw new ValidationError(vErrors); ":b+" validate.errors = vErrors; return false; ");b+=" } else {  errors = "+r+"; if (vErrors !== null) { if ("+r+") vErrors.length = "+r+"; else vErrors = null; } ";e.opts.allErrors&&(b+=" } ")}else g&&(b+=" if (true) { ");return b}},923:function(y){y.exports=function(e,h,b){b=" ";var r=e.errSchemaPath+"/"+h;h=e.util.toQuotedString(e.schema[h]);!0===e.opts.$comment?b+=" console.log("+h+");":"function"==typeof e.opts.$comment&&
(b+=" self._opts.$comment("+h+", "+e.util.toQuotedString(r)+", validate.root.schema);");return b}},2617:function(y){y.exports=function(e,h,b){b=" ";var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+e.util.getProperty(h),g=e.errSchemaPath+"/"+h;h=!e.opts.allErrors;var d="data"+(t||""),a="valid"+r,c=e.opts.$data&&k&&k.$data;c&&(b+=" var schema"+r+" = "+e.util.getData(k.$data,t,e.dataPathArr)+"; ");c||(b+=" var schema"+r+" = validate.schema"+x+";");var f=f||[];f.push(b+("var "+a+" = equal("+d+
", schema"+r+"); if (!"+a+") {   "));b="";!1!==e.createErrors?(b+=" { keyword: 'const' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { allowedValue: schema"+r+" } ",!1!==e.opts.messages&&(b+=" , message: 'should be equal to constant' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),b+=" } "):b+=" {} ";r=b;b=f.pop();b=!e.compositeRule&&h?e.async?b+(" throw new ValidationError(["+
r+"]); "):b+(" validate.errors = ["+r+"]; return false; "):b+(" var err = "+r+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");b+=" }";h&&(b+=" else { ");return b}},2119:function(y){y.exports=function(e,h,b){b=" ";var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+e.util.getProperty(h),g=e.errSchemaPath+"/"+h;h=!e.opts.allErrors;var d="data"+(t||""),a="valid"+r;t="errs__"+r;var c=e.util.copy(e);c.level++;var f="valid"+c.level,w="i"+r,m=c.dataLevel=e.dataLevel+
1,p="data"+m,l=e.baseId;r=e.opts.strictKeywords?"object"==typeof k&&0<Object.keys(k).length||!1===k:e.util.schemaHasRules(k,e.RULES.all);b+="var "+t+" = errors;var "+a+";";r?(a=e.compositeRule,e.compositeRule=c.compositeRule=!0,c.schema=k,c.schemaPath=x,c.errSchemaPath=g,b+=" var "+f+" = false; for (var "+w+" = 0; "+w+" < "+d+".length; "+w+"++) { ",c.errorPath=e.util.getPathExpr(e.errorPath,w,e.opts.jsonPointers,!0),k=d+"["+w+"]",c.dataPathArr[m]=w,w=e.validate(c),c.baseId=l,b=2>e.util.varOccurences(w,
p)?b+(" "+e.util.varReplace(w,p,k)+" "):b+(" var "+p+" = "+k+"; "+w+" "),e.compositeRule=c.compositeRule=a,b=b+(" if ("+f+") break; }    if (!")+(f+") {")):b+=" if ("+d+".length == 0) {";var u=u||[];u.push(b);b="";!1!==e.createErrors?(b+=" { keyword: 'contains' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: {} ",!1!==e.opts.messages&&(b+=" , message: 'should contain a valid item' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+
e.schemaPath+" , data: "+d+" "),b+=" } "):b+=" {} ";x=b;b=u.pop();b=!e.compositeRule&&h?e.async?b+(" throw new ValidationError(["+x+"]); "):b+(" validate.errors = ["+x+"]; return false; "):b+(" var err = "+x+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");b+=" } else { ";r&&(b+="  errors = "+t+"; if (vErrors !== null) { if ("+t+") vErrors.length = "+t+"; else vErrors = null; } ");e.opts.allErrors&&(b+=" } ");return b}},1793:function(y){y.exports=function(e,h,b){b=" ";
var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+e.util.getProperty(h),g=e.errSchemaPath+"/"+h,d=!e.opts.allErrors,a="data"+(t||""),c="valid"+r,f="errs__"+r,w=e.opts.$data&&k&&k.$data;if(w){b+=" var schema"+r+" = "+e.util.getData(k.$data,t,e.dataPathArr)+"; ";var m="schema"+r}else m=k;var p="definition"+r,l=this.definition,u="";if(w&&l.$data){var v="keywordValidate"+r;var A=l.validateSchema;b+=" var "+p+" = RULES.custom['"+h+"'].definition; var "+v+" = "+p+".validate;"}else{var q=e.useCustomRule(this,
k,e.schema,e);if(!q)return;m="validate.schema"+x;v=q.code;var n=l.compile;var y=l.inline;var K=l.macro}h=v+".errors";k="i"+r;var z="ruleErr"+r,H=l.async;if(H&&!e.async)throw Error("async keyword in sync schema");y||K||(b+=""+h+" = null;");b+="var "+f+" = errors;var "+c+";";w&&l.$data&&(u+="}",b+=" if ("+m+" === undefined) { "+c+" = true; } else { ",A&&(u+="}",b+=" "+c+" = "+p+".validateSchema("+m+"); if ("+c+") { "));if(y)b=l.statements?b+(" "+q.validate+" "):b+(" "+c+" = "+q.validate+"; ");else if(K){r=
e.util.copy(e);u="";r.level++;var E="valid"+r.level;r.schema=q.validate;r.schemaPath="";q=e.compositeRule;e.compositeRule=r.compositeRule=!0;n=e.validate(r).replace(/validate\.schema/g,v);e.compositeRule=r.compositeRule=q;b+=" "+n}else{var D=D||[];D.push(b);b="  "+v+".call( ";b=e.opts.passContext?b+"this":b+"self";b=n||!1===l.schema?b+(" , "+a+" "):b+(" , "+m+" , "+a+" , validate.schema"+e.schemaPath+" ");b+=" , (dataPath || '')";'""'!=e.errorPath&&(b+=" + "+e.errorPath);var F=t?"data"+(t-1||""):
"parentData",B=t?e.dataPathArr[t]:"parentDataProperty";q=b+(" , "+F+" , "+B+" , rootData )  ");b=D.pop();!1===l.errors?(b+=" "+c+" = ",H&&(b+="await "),b+=""+q+"; "):H?(h="customErrors"+r,b+=" var "+h+" = null; try { "+c+" = await "+q+"; } catch (e) { "+c+" = false; if (e instanceof ValidationError) "+h+" = e.errors; else throw e; } "):b+=" "+h+" = null; "+c+" = "+q+"; "}l.modifying&&(b+=" if ("+F+") "+a+" = "+F+"["+B+"];");b+=""+u;l.valid?d&&(b+=" if (true) { "):(b+=" if ( ",void 0===l.valid?(b+=
" !",b=K?b+(""+E):b+(""+c)):b+=" "+!l.valid+" ",E=this.keyword,D=D||[],D.push(b+") { "),D=D||[],D.push(""),b="",!1!==e.createErrors?(b+=" { keyword: '"+(E||"custom")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { keyword: '"+this.keyword+"' } ",!1!==e.opts.messages&&(b+=" , message: 'should pass \""+this.keyword+"\" keyword validation' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+
a+" "),b+=" } "):b+=" {} ",F=b,b=D.pop(),F=b=!e.compositeRule&&d?e.async?b+(" throw new ValidationError(["+F+"]); "):b+(" validate.errors = ["+F+"]; return false; "):b+(" var err = "+F+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "),b=D.pop(),y?l.errors?"full"!=l.errors&&(b+="  for (var "+k+"="+f+"; "+k+"<errors; "+k+"++) { var "+z+" = vErrors["+k+"]; if ("+z+".dataPath === undefined) "+z+".dataPath = (dataPath || '') + "+e.errorPath+"; if ("+z+".schemaPath === undefined) { "+
z+'.schemaPath = "'+g+'"; } ',e.opts.verbose&&(b+=" "+z+".schema = "+m+"; "+z+".data = "+a+"; "),b+=" } "):!1===l.errors?b+=" "+F+" ":(b+=" if ("+f+" == errors) { "+F+" } else {  for (var "+k+"="+f+"; "+k+"<errors; "+k+"++) { var "+z+" = vErrors["+k+"]; if ("+z+".dataPath === undefined) "+z+".dataPath = (dataPath || '') + "+e.errorPath+"; if ("+z+".schemaPath === undefined) { "+z+'.schemaPath = "'+g+'"; } ',e.opts.verbose&&(b+=" "+z+".schema = "+m+"; "+z+".data = "+a+"; "),b+=" } } "):K?(b+="   var err =   ",
!1!==e.createErrors?(b+=" { keyword: '"+(E||"custom")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { keyword: '"+this.keyword+"' } ",!1!==e.opts.messages&&(b+=" , message: 'should pass \""+this.keyword+"\" keyword validation' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+a+" "),b+=" } "):b+=" {} ",b+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",
!e.compositeRule&&d&&(b=e.async?b+" throw new ValidationError(vErrors); ":b+" validate.errors = vErrors; return false; ")):!1===l.errors?b+=" "+F+" ":(b+=" if (Array.isArray("+h+")) { if (vErrors === null) vErrors = "+h+"; else vErrors = vErrors.concat("+h+"); errors = vErrors.length;  for (var "+k+"="+f+"; "+k+"<errors; "+k+"++) { var "+z+" = vErrors["+k+"]; if ("+z+".dataPath === undefined) "+z+".dataPath = (dataPath || '') + "+e.errorPath+";  "+z+'.schemaPath = "'+g+'";  ',e.opts.verbose&&(b+=
" "+z+".schema = "+m+"; "+z+".data = "+a+"; "),b+=" } } else { "+F+" } "),b+=" } ",d&&(b+=" else { "));return b}},9115:function(y){y.exports=function(e,h,b){b=" ";var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+e.util.getProperty(h);h=e.errSchemaPath+"/"+h;var g=!e.opts.allErrors;t="data"+(t||"");var d="errs__"+r,a=e.util.copy(e),c="";a.level++;var f="valid"+a.level,w={},m={},p=e.opts.ownProperties;for(v in k)if("__proto__"!=v){var l=k[v],u=Array.isArray(l)?m:w;u[v]=l}k=e.errorPath;b=b+("var "+
d+" = errors;var missing")+(r+";");for(var v in m)if(u=m[v],u.length){b+=" if ( "+t+e.util.getProperty(v)+" !== undefined ";p&&(b+=" && Object.prototype.hasOwnProperty.call("+t+", '"+e.util.escapeQuotes(v)+"') ");if(g){b+=" && ( ";var A=u;if(A)for(var q=-1,n=A.length-1;q<n;){l=A[q+=1];q&&(b+=" || ");var y=e.util.getProperty(l),K=t+y;b+=" ( ( "+K+" === undefined ";p&&(b+=" || ! Object.prototype.hasOwnProperty.call("+t+", '"+e.util.escapeQuotes(l)+"') ");b+=") && (missing"+r+" = "+e.util.toQuotedString(e.opts.jsonPointers?
l:y)+") ) "}b+=")) {  ";l="missing"+r;A="' + "+l+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.opts.jsonPointers?e.util.getPathExpr(k,l,!0):k+" + "+l);var z=z||[];z.push(b);b="";!1!==e.createErrors?(b+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { property: '"+e.util.escapeQuotes(v)+"', missingProperty: '"+A+"', depsCount: "+u.length+", deps: '"+e.util.escapeQuotes(1==u.length?u[0]:u.join(", "))+"' } ",!1!==
e.opts.messages&&(b+=" , message: 'should have ",b=1==u.length?b+("property "+e.util.escapeQuotes(u[0])):b+("properties "+e.util.escapeQuotes(u.join(", "))),b+=" when property "+e.util.escapeQuotes(v)+" is present' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+t+" "),b+=" } "):b+=" {} ";u=b;b=z.pop();b=!e.compositeRule&&g?e.async?b+(" throw new ValidationError(["+u+"]); "):b+(" validate.errors = ["+u+"]; return false; "):b+(" var err = "+
u+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ")}else if(b+=" ) { ",q=u){n=-1;for(var H=q.length-1;n<H;)l=q[n+=1],y=e.util.getProperty(l),A=e.util.escapeQuotes(l),K=t+y,e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(k,l,e.opts.jsonPointers)),b+=" if ( "+K+" === undefined ",p&&(b+=" || ! Object.prototype.hasOwnProperty.call("+t+", '"+e.util.escapeQuotes(l)+"') "),b+=") {  var err =   ",!1!==e.createErrors?(b+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+
e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { property: '"+e.util.escapeQuotes(v)+"', missingProperty: '"+A+"', depsCount: "+u.length+", deps: '"+e.util.escapeQuotes(1==u.length?u[0]:u.join(", "))+"' } ",!1!==e.opts.messages&&(b+=" , message: 'should have ",b=1==u.length?b+("property "+e.util.escapeQuotes(u[0])):b+("properties "+e.util.escapeQuotes(u.join(", "))),b+=" when property "+e.util.escapeQuotes(v)+" is present' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+
" , parentSchema: validate.schema"+e.schemaPath+" , data: "+t+" "),b+=" } "):b+=" {} ",b+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}b+=" }   ";g&&(c+="}",b+=" else { ")}e.errorPath=k;z=a.baseId;for(v in w)if(l=w[v],e.opts.strictKeywords?"object"==typeof l&&0<Object.keys(l).length||!1===l:e.util.schemaHasRules(l,e.RULES.all))b+=" "+f+" = true; if ( "+t+e.util.getProperty(v)+" !== undefined ",p&&(b+=" && Object.prototype.hasOwnProperty.call("+t+", '"+e.util.escapeQuotes(v)+
"') "),b+=") { ",a.schema=l,a.schemaPath=x+e.util.getProperty(v),a.errSchemaPath=h+"/"+e.util.escapeFragment(v),b+="  "+e.validate(a)+" ",a.baseId=z,b+=" }  ",g&&(b+=" if ("+f+") { ",c+="}");g&&(b+="   "+c+" if ("+d+" == errors) {");return b}},9317:function(y){y.exports=function(e,h,b){b=" ";var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+e.util.getProperty(h),g=e.errSchemaPath+"/"+h;h=!e.opts.allErrors;var d="data"+(t||""),a="valid"+r,c=e.opts.$data&&k&&k.$data;c&&(b+=" var schema"+r+" = "+
e.util.getData(k.$data,t,e.dataPathArr)+"; ");t="i"+r;k="schema"+r;c||(b+=" var "+k+" = validate.schema"+x+";");b+="var "+a+";";c&&(b+=" if (schema"+r+" === undefined) "+a+" = true; else if (!Array.isArray(schema"+r+")) "+a+" = false; else {");b+=""+a+" = false;for (var "+t+"=0; "+t+"<"+k+".length; "+t+"++) if (equal("+d+", "+k+"["+t+"])) { "+a+" = true; break; }";c&&(b+="  }  ");var f=f||[];f.push(b+(" if (!"+a+") {   "));b="";!1!==e.createErrors?(b+=" { keyword: 'enum' , dataPath: (dataPath || '') + "+
e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { allowedValues: schema"+r+" } ",!1!==e.opts.messages&&(b+=" , message: 'should be equal to one of the allowed values' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),b+=" } "):b+=" {} ";r=b;b=f.pop();b=!e.compositeRule&&h?e.async?b+(" throw new ValidationError(["+r+"]); "):b+(" validate.errors = ["+r+"]; return false; "):b+(" var err = "+r+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");
b+=" }";h&&(b+=" else { ");return b}},8327:function(y){y.exports=function(e,h,b){var r=" ",t=e.level,k=e.dataLevel,x=e.schema[h],g=e.schemaPath+e.util.getProperty(h),d=e.errSchemaPath+"/"+h;h=!e.opts.allErrors;var a="data"+(k||"");if(!1===e.opts.format)return h&&(r+=" if (true) { "),r;var c=e.opts.$data&&x&&x.$data;c?(r+=" var schema"+t+" = "+e.util.getData(x.$data,k,e.dataPathArr)+"; ",k="schema"+t):k=x;var f=e.opts.unknownFormats,w=Array.isArray(f);if(c){var m="format"+t,p="isObject"+t,l="formatType"+
t;r+=" var "+m+" = formats["+k+"]; var "+p+" = typeof "+m+" == 'object' && !("+m+" instanceof RegExp) && "+m+".validate; var "+l+" = "+p+" && "+m+".type || 'string'; if ("+p+") { ";e.async&&(r+=" var async"+t+" = "+m+".async; ");r+=" "+m+" = "+m+".validate; } if (  ";c&&(r+=" ("+k+" !== undefined && typeof "+k+" != 'string') || ");r+=" (";"ignore"!=f&&(r+=" ("+k+" && !"+m+" ",w&&(r+=" && self._opts.unknownFormats.indexOf("+k+") == -1 "),r+=") || ");r+=" ("+m+" && "+l+" == '"+b+"' && !(typeof "+m+
" == 'function' ? ";r=e.async?r+(" (async"+t+" ? await "+m+"("+a+") : "+m+"("+a+")) "):r+(" "+m+"("+a+") ");r+=" : "+m+".test("+a+"))))) {"}else{m=e.formats[x];if(!m){if("ignore"==f)return e.logger.warn('unknown format "'+x+'" ignored in schema at path "'+e.errSchemaPath+'"'),h&&(r+=" if (true) { "),r;if(w&&0<=f.indexOf(x))return h&&(r+=" if (true) { "),r;throw Error('unknown format "'+x+'" is used in schema at path "'+e.errSchemaPath+'"');}l=(p="object"==typeof m&&!(m instanceof RegExp)&&m.validate)&&
m.type||"string";if(p){var u=!0===m.async;m=m.validate}if(l!=b)return h&&(r+=" if (true) { "),r;if(u){if(!e.async)throw Error("async format in sync schema");b="formats"+e.util.getProperty(x)+".validate";r+=" if (!(await "+b+"("+a+"))) { "}else r+=" if (! ",b="formats"+e.util.getProperty(x),p&&(b+=".validate"),r=("function"==typeof m?r+(" "+b+"("+a+") "):r+(" "+b+".test("+a+") "))+") { "}var v=v||[];v.push(r);r="";!1!==e.createErrors?(r+=" { keyword: 'format' , dataPath: (dataPath || '') + "+e.errorPath+
" , schemaPath: "+e.util.toQuotedString(d)+" , params: { format:  ",r=c?r+(""+k):r+(""+e.util.toQuotedString(x)),r+="  } ",!1!==e.opts.messages&&(r+=" , message: 'should match format \"",r=c?r+("' + "+k+" + '"):r+(""+e.util.escapeQuotes(x)),r+="\"' "),e.opts.verbose&&(r+=" , schema:  ",r=c?r+("validate.schema"+g):r+(""+e.util.toQuotedString(x)),r+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+a+" "),r+=" } "):r+=" {} ";x=r;r=v.pop();r=!e.compositeRule&&h?e.async?r+(" throw new ValidationError(["+
x+"]); "):r+(" validate.errors = ["+x+"]; return false; "):r+(" var err = "+x+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");r+=" } ";h&&(r+=" else { ");return r}},5926:function(y){y.exports=function(e,h,b){b=" ";var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+e.util.getProperty(h);h=e.errSchemaPath+"/"+h;var g=!e.opts.allErrors;t="data"+(t||"");var d="valid"+r,a="errs__"+r,c=e.util.copy(e);c.level++;var f="valid"+c.level,w=e.schema.then,m=e.schema["else"];
w=void 0!==w&&(e.opts.strictKeywords?"object"==typeof w&&0<Object.keys(w).length||!1===w:e.util.schemaHasRules(w,e.RULES.all));m=void 0!==m&&(e.opts.strictKeywords?"object"==typeof m&&0<Object.keys(m).length||!1===m:e.util.schemaHasRules(m,e.RULES.all));var p=c.baseId;if(w||m){c.createErrors=!1;c.schema=k;c.schemaPath=x;c.errSchemaPath=h;k=e.compositeRule;e.compositeRule=c.compositeRule=!0;b=b+(" var "+a+" = errors; var "+d+" = true;    ")+(e.validate(c)+" ");c.baseId=p;c.createErrors=!0;b+="  errors = "+
a+"; if (vErrors !== null) { if ("+a+") vErrors.length = "+a+"; else vErrors = null; }  ";e.compositeRule=c.compositeRule=k;if(w){c.schema=e.schema.then;c.schemaPath=e.schemaPath+".then";c.errSchemaPath=e.errSchemaPath+"/then";b=b+(" if ("+f+") {    ")+(e.validate(c)+" ");c.baseId=p;b+=" "+d+" = "+f+"; ";if(w&&m){var l="ifClause"+r;b+=" var "+l+" = 'then'; "}else l="'then'";b+=" } ";m&&(b+=" else { ")}else b+=" if (!"+f+") { ";m&&(c.schema=e.schema["else"],c.schemaPath=e.schemaPath+".else",c.errSchemaPath=
e.errSchemaPath+"/else",b+="  "+e.validate(c)+" ",c.baseId=p,b+=" "+d+" = "+f+"; ",w&&m?(l="ifClause"+r,b+=" var "+l+" = 'else'; "):l="'else'",b+=" } ");b+=" if (!"+d+") {   var err =   ";!1!==e.createErrors?(b+=" { keyword: 'if' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { failingKeyword: "+l+" } ",!1!==e.opts.messages&&(b+=" , message: 'should match \"' + "+l+" + '\" schema' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+
e.schemaPath+" , data: "+t+" "),b+=" } "):b+=" {} ";b+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";!e.compositeRule&&g&&(b=e.async?b+" throw new ValidationError(vErrors); ":b+" validate.errors = vErrors; return false; ");b+=" }   ";g&&(b+=" else { ")}else g&&(b+=" if (true) { ");return b}},9646:function(y,e,h){y.exports={$ref:h(2331),allOf:h(9486),anyOf:h(5347),$comment:h(923),const:h(2617),contains:h(2119),dependencies:h(9115),"enum":h(9317),format:h(8327),"if":h(5926),
items:h(392),maximum:h(1796),minimum:h(1796),maxItems:h(2407),minItems:h(2407),maxLength:h(1250),minLength:h(1250),maxProperties:h(2596),minProperties:h(2596),multipleOf:h(6039),not:h(7946),oneOf:h(9344),pattern:h(9737),properties:h(2537),propertyNames:h(2127),required:h(1204),uniqueItems:h(1985),validate:h(1869)}},392:function(y){y.exports=function(e,h,b){b=" ";var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+e.util.getProperty(h),g=e.errSchemaPath+"/"+h;h=!e.opts.allErrors;t="data"+(t||
"");var d="valid"+r,a="errs__"+r,c=e.util.copy(e),f="";c.level++;var w="valid"+c.level;r="i"+r;var m=c.dataLevel=e.dataLevel+1,p="data"+m,l=e.baseId;b+="var "+a+" = errors;var "+d+";";if(Array.isArray(k)){var u=e.schema.additionalItems;if(!1===u){b+=" "+d+" = "+t+".length <= "+k.length+"; ";var v=g;g=e.errSchemaPath+"/additionalItems";var A=A||[];A.push(b+("  if (!"+d+") {   "));b="";!1!==e.createErrors?(b+=" { keyword: 'additionalItems' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+
e.util.toQuotedString(g)+" , params: { limit: "+k.length+" } ",!1!==e.opts.messages&&(b+=" , message: 'should NOT have more than "+k.length+" items' "),e.opts.verbose&&(b+=" , schema: false , parentSchema: validate.schema"+e.schemaPath+" , data: "+t+" "),b+=" } "):b+=" {} ";g=b;b=A.pop();b=!e.compositeRule&&h?e.async?b+(" throw new ValidationError(["+g+"]); "):b+(" validate.errors = ["+g+"]; return false; "):b+(" var err = "+g+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");
b+=" } ";g=v;h&&(f+="}",b+=" else { ")}if(k)for(A=-1,d=k.length-1;A<d;){var q=k[A+=1];if(e.opts.strictKeywords?"object"==typeof q&&0<Object.keys(q).length||!1===q:e.util.schemaHasRules(q,e.RULES.all))b+=" "+w+" = true; if ("+t+".length > "+A+") { ",v=t+"["+A+"]",c.schema=q,c.schemaPath=x+"["+A+"]",c.errSchemaPath=g+"/"+A,c.errorPath=e.util.getPathExpr(e.errorPath,A,e.opts.jsonPointers,!0),c.dataPathArr[m]=A,q=e.validate(c),c.baseId=l,b=2>e.util.varOccurences(q,p)?b+(" "+e.util.varReplace(q,p,v)+" "):
b+(" var "+p+" = "+v+"; "+q+" "),b+=" }  ",h&&(b+=" if ("+w+") { ",f+="}")}"object"==typeof u&&(e.opts.strictKeywords?"object"==typeof u&&0<Object.keys(u).length||!1===u:e.util.schemaHasRules(u,e.RULES.all))&&(c.schema=u,c.schemaPath=e.schemaPath+".additionalItems",c.errSchemaPath=e.errSchemaPath+"/additionalItems",b+=" "+w+" = true; if ("+t+".length > "+k.length+") {  for (var "+r+" = "+k.length+"; "+r+" < "+t+".length; "+r+"++) { ",c.errorPath=e.util.getPathExpr(e.errorPath,r,e.opts.jsonPointers,
!0),v=t+"["+r+"]",c.dataPathArr[m]=r,q=e.validate(c),c.baseId=l,b=2>e.util.varOccurences(q,p)?b+(" "+e.util.varReplace(q,p,v)+" "):b+(" var "+p+" = "+v+"; "+q+" "),h&&(b+=" if (!"+w+") break; "),b+=" } }  ",h&&(b+=" if ("+w+") { ",f+="}"))}else if(e.opts.strictKeywords?"object"==typeof k&&0<Object.keys(k).length||!1===k:e.util.schemaHasRules(k,e.RULES.all))c.schema=k,c.schemaPath=x,c.errSchemaPath=g,b+="  for (var "+r+" = 0; "+r+" < "+t+".length; "+r+"++) { ",c.errorPath=e.util.getPathExpr(e.errorPath,
r,e.opts.jsonPointers,!0),v=t+"["+r+"]",c.dataPathArr[m]=r,q=e.validate(c),c.baseId=l,b=2>e.util.varOccurences(q,p)?b+(" "+e.util.varReplace(q,p,v)+" "):b+(" var "+p+" = "+v+"; "+q+" "),h&&(b+=" if (!"+w+") break; "),b+=" }";h&&(b+=" "+f+" if ("+a+" == errors) {");return b}},6039:function(y){y.exports=function(e,h,b){b=" ";var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+e.util.getProperty(h),g=e.errSchemaPath+"/"+h,d=!e.opts.allErrors,a="data"+(t||""),c=e.opts.$data&&k&&k.$data;c?(b+=" var schema"+
r+" = "+e.util.getData(k.$data,t,e.dataPathArr)+"; ",t="schema"+r):t=k;if(!c&&"number"!=typeof k)throw Error(h+" must be number");b+="var division"+r+";if (";c&&(b+=" "+t+" !== undefined && ( typeof "+t+" != 'number' || ");b+=" (division"+r+" = "+a+" / "+t+", ";b=e.opts.multipleOfPrecision?b+(" Math.abs(Math.round(division"+r+") - division"+r+") > 1e-"+e.opts.multipleOfPrecision+" "):b+(" division"+r+" !== parseInt(division"+r+") ");b+=" ) ";c&&(b+="  )  ");var f=f||[];f.push(b+" ) {   ");b="";!1!==
e.createErrors?(b+=" { keyword: 'multipleOf' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { multipleOf: "+t+" } ",!1!==e.opts.messages&&(b+=" , message: 'should be multiple of ",b=c?b+("' + "+t):b+(""+t+"'")),e.opts.verbose&&(b+=" , schema:  ",b=(c?b+("validate.schema"+x):b+(""+k))+("         , parentSchema: validate.schema"+e.schemaPath+" , data: "+a+" ")),b+=" } "):b+=" {} ";h=b;b=f.pop();b=!e.compositeRule&&d?e.async?b+(" throw new ValidationError(["+
h+"]); "):b+(" validate.errors = ["+h+"]; return false; "):b+(" var err = "+h+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");b+="} ";d&&(b+=" else { ");return b}},7946:function(y){y.exports=function(e,h,b){b=" ";var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+e.util.getProperty(h),g=e.errSchemaPath+"/"+h;h=!e.opts.allErrors;t="data"+(t||"");r="errs__"+r;var d=e.util.copy(e);d.level++;var a="valid"+d.level;if(e.opts.strictKeywords?"object"==typeof k&&0<Object.keys(k).length||
!1===k:e.util.schemaHasRules(k,e.RULES.all)){d.schema=k;d.schemaPath=x;d.errSchemaPath=g;k=e.compositeRule;e.compositeRule=d.compositeRule=!0;d.createErrors=!1;if(d.opts.allErrors){var c=d.opts.allErrors;d.opts.allErrors=!1}b=b+(" var "+r+" = errors;   ")+(e.validate(d)+" ");d.createErrors=!0;c&&(d.opts.allErrors=c);e.compositeRule=d.compositeRule=k;var f=f||[];f.push(b+(" if ("+a+") {   "));b="";!1!==e.createErrors?(b+=" { keyword: 'not' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+
e.util.toQuotedString(g)+" , params: {} ",!1!==e.opts.messages&&(b+=" , message: 'should NOT be valid' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+t+" "),b+=" } "):b+=" {} ";c=b;b=f.pop();b=!e.compositeRule&&h?e.async?b+(" throw new ValidationError(["+c+"]); "):b+(" validate.errors = ["+c+"]; return false; "):b+(" var err = "+c+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");b+=" } else {  errors = "+
r+"; if (vErrors !== null) { if ("+r+") vErrors.length = "+r+"; else vErrors = null; } ";e.opts.allErrors&&(b+=" } ")}else b+="  var err =   ",!1!==e.createErrors?(b+=" { keyword: 'not' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: {} ",!1!==e.opts.messages&&(b+=" , message: 'should NOT be valid' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+t+" "),b+=" } "):b+=" {} ",b+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",
h&&(b+=" if (false) { ");return b}},9344:function(y){y.exports=function(e,h,b){b=" ";var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+e.util.getProperty(h);h=e.errSchemaPath+"/"+h;var g=!e.opts.allErrors;t="data"+(t||"");var d="valid"+r,a="errs__"+r,c=e.util.copy(e),f="";c.level++;var w="valid"+c.level,m=c.baseId,p="prevValid"+r;r="passingSchemas"+r;b+="var "+a+" = errors , "+p+" = false , "+d+" = false , "+r+" = null; ";var l=e.compositeRule;e.compositeRule=c.compositeRule=!0;if(k)for(var u,
v=-1,A=k.length-1;v<A;)u=k[v+=1],(e.opts.strictKeywords?"object"==typeof u&&0<Object.keys(u).length||!1===u:e.util.schemaHasRules(u,e.RULES.all))?(c.schema=u,c.schemaPath=x+"["+v+"]",c.errSchemaPath=h+"/"+v,b+="  "+e.validate(c)+" ",c.baseId=m):b+=" var "+w+" = true; ",v&&(b+=" if ("+w+" && "+p+") { "+d+" = false; "+r+" = ["+r+", "+v+"]; } else { ",f+="}"),b+=" if ("+w+") { "+d+" = "+p+" = true; "+r+" = "+v+"; }";e.compositeRule=c.compositeRule=l;b+=""+f+"if (!"+d+") {   var err =   ";!1!==e.createErrors?
(b+=" { keyword: 'oneOf' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { passingSchemas: "+r+" } ",!1!==e.opts.messages&&(b+=" , message: 'should match exactly one schema in oneOf' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+t+" "),b+=" } "):b+=" {} ";b+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";!e.compositeRule&&g&&(b=e.async?b+" throw new ValidationError(vErrors); ":
b+" validate.errors = vErrors; return false; ");b+="} else {  errors = "+a+"; if (vErrors !== null) { if ("+a+") vErrors.length = "+a+"; else vErrors = null; }";e.opts.allErrors&&(b+=" } ");return b}},9737:function(y){y.exports=function(e,h,b){b=" ";var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+e.util.getProperty(h),g=e.errSchemaPath+"/"+h;h=!e.opts.allErrors;var d="data"+(t||""),a=e.opts.$data&&k&&k.$data;a?(b+=" var schema"+r+" = "+e.util.getData(k.$data,t,e.dataPathArr)+"; ",r="schema"+
r):r=k;t=a?"(new RegExp("+r+"))":e.usePattern(k);b+="if ( ";a&&(b+=" ("+r+" !== undefined && typeof "+r+" != 'string') || ");var c=c||[];c.push(b+(" !"+t+".test("+d+") ) {   "));b="";!1!==e.createErrors?(b+=" { keyword: 'pattern' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { pattern:  ",b=a?b+(""+r):b+(""+e.util.toQuotedString(k)),b+="  } ",!1!==e.opts.messages&&(b+=" , message: 'should match pattern \"",b=a?b+("' + "+r+" + '"):b+(""+e.util.escapeQuotes(k)),
b+="\"' "),e.opts.verbose&&(b+=" , schema:  ",b=a?b+("validate.schema"+x):b+(""+e.util.toQuotedString(k)),b+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),b+=" } "):b+=" {} ";k=b;b=c.pop();b=!e.compositeRule&&h?e.async?b+(" throw new ValidationError(["+k+"]); "):b+(" validate.errors = ["+k+"]; return false; "):b+(" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");b+="} ";h&&(b+=" else { ");return b}},2537:function(y){y.exports=
function(e,h,b){function r(a){return"__proto__"!==a}b=" ";var t=e.level,k=e.dataLevel,x=e.schema[h],g=e.schemaPath+e.util.getProperty(h),d=e.errSchemaPath+"/"+h;h=!e.opts.allErrors;k="data"+(k||"");var a="errs__"+t,c=e.util.copy(e),f="";c.level++;var w="valid"+c.level,m="key"+t,p="idx"+t,l=c.dataLevel=e.dataLevel+1,u="data"+l,v="dataProperties"+t,A=Object.keys(x||{}).filter(r),q=e.schema.patternProperties||{},n=Object.keys(q).filter(r),y=e.schema.additionalProperties,K=A.length||n.length,z=!1===y,
H="object"==typeof y&&Object.keys(y).length,E=e.opts.removeAdditional,D=z||H||E,F=e.opts.ownProperties,B=e.baseId,G=e.schema.required;if(G&&(!e.opts.$data||!G.$data)&&G.length<e.opts.loopRequired)var M=e.util.toHash(G);b+="var "+a+" = errors;var "+w+" = true;";F&&(b+=" var "+v+" = undefined;");if(D){b=F?b+(" "+v+" = "+v+" || Object.keys("+k+"); for (var "+p+"=0; "+p+"<"+v+".length; "+p+"++) { var "+m+" = "+v+"["+p+"]; "):b+(" for (var "+m+" in "+k+") { ");if(K){b+=" var isAdditional"+t+" = !(false ";
if(A.length)if(8<A.length)b+=" || validate.schema"+g+".hasOwnProperty("+m+") ";else if(A){G=-1;for(var I=A.length-1;G<I;)D=A[G+=1],b+=" || "+m+" == "+e.util.toQuotedString(D)+" "}if(n.length&&n)for(G=-1,I=n.length-1;G<I;)D=n[G+=1],b+=" || "+e.usePattern(D)+".test("+m+") ";b+=" ); if (isAdditional"+t+") { "}if("all"==E)b+=" delete "+k+"["+m+"]; ";else{t=e.errorPath;D="' + "+m+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(e.errorPath,m,e.opts.jsonPointers));if(z)if(E)b+=" delete "+
k+"["+m+"]; ";else{z=d;d=e.errSchemaPath+"/additionalProperties";var C=C||[];C.push(b+(" "+w+" = false; "));b="";!1!==e.createErrors?(b+=" { keyword: 'additionalProperties' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(d)+" , params: { additionalProperty: '"+D+"' } ",!1!==e.opts.messages&&(b+=" , message: '",b=e.opts._errorDataPathProperty?b+"is an invalid additional property":b+"should NOT have additional properties",b+="' "),e.opts.verbose&&(b+=" , schema: false , parentSchema: validate.schema"+
e.schemaPath+" , data: "+k+" "),b+=" } "):b+=" {} ";d=b;b=C.pop();b=!e.compositeRule&&h?e.async?b+(" throw new ValidationError(["+d+"]); "):b+(" validate.errors = ["+d+"]; return false; "):b+(" var err = "+d+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");d=z;h&&(b+=" break; ")}else H&&("failing"==E?(b+=" var "+a+" = errors;  ",D=e.compositeRule,e.compositeRule=c.compositeRule=!0,c.schema=y,c.schemaPath=e.schemaPath+".additionalProperties",c.errSchemaPath=e.errSchemaPath+
"/additionalProperties",c.errorPath=e.opts._errorDataPathProperty?e.errorPath:e.util.getPathExpr(e.errorPath,m,e.opts.jsonPointers),z=k+"["+m+"]",c.dataPathArr[l]=m,y=e.validate(c),c.baseId=B,b=2>e.util.varOccurences(y,u)?b+(" "+e.util.varReplace(y,u,z)+" "):b+(" var "+u+" = "+z+"; "+y+" "),b+=" if (!"+w+") { errors = "+a+"; if (validate.errors !== null) { if (errors) validate.errors.length = errors; else validate.errors = null; } delete "+k+"["+m+"]; }  ",e.compositeRule=c.compositeRule=D):(c.schema=
y,c.schemaPath=e.schemaPath+".additionalProperties",c.errSchemaPath=e.errSchemaPath+"/additionalProperties",c.errorPath=e.opts._errorDataPathProperty?e.errorPath:e.util.getPathExpr(e.errorPath,m,e.opts.jsonPointers),z=k+"["+m+"]",c.dataPathArr[l]=m,y=e.validate(c),c.baseId=B,b=2>e.util.varOccurences(y,u)?b+(" "+e.util.varReplace(y,u,z)+" "):b+(" var "+u+" = "+z+"; "+y+" "),h&&(b+=" if (!"+w+") break; ")));e.errorPath=t}K&&(b+=" } ");b+=" }  ";h&&(b+=" if ("+w+") { ",f+="}")}K=e.opts.useDefaults&&
!e.compositeRule;if(A.length&&A)for(H=-1,E=A.length-1;H<E;){D=A[H+=1];y=x[D];if(e.opts.strictKeywords?"object"==typeof y&&0<Object.keys(y).length||!1===y:e.util.schemaHasRules(y,e.RULES.all))G=e.util.getProperty(D),z=k+G,t=K&&void 0!==y.default,c.schema=y,c.schemaPath=g+G,c.errSchemaPath=d+"/"+e.util.escapeFragment(D),c.errorPath=e.util.getPath(e.errorPath,D,e.opts.jsonPointers),c.dataPathArr[l]=e.util.toQuotedString(D),y=e.validate(c),c.baseId=B,2>e.util.varOccurences(y,u)?(y=e.util.varReplace(y,
u,z),G=z):(G=u,b+=" var "+u+" = "+z+"; "),t?b+=" "+y+" ":(M&&M[D]?(b+=" if ( "+G+" === undefined ",F&&(b+=" || ! Object.prototype.hasOwnProperty.call("+k+", '"+e.util.escapeQuotes(D)+"') "),b+=") { "+w+" = false; ",t=e.errorPath,z=d,G=e.util.escapeQuotes(D),e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(t,D,e.opts.jsonPointers)),d=e.errSchemaPath+"/required",C=C||[],C.push(b),b="",!1!==e.createErrors?(b+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+
e.util.toQuotedString(d)+" , params: { missingProperty: '"+G+"' } ",!1!==e.opts.messages&&(b+=" , message: '",b=e.opts._errorDataPathProperty?b+"is a required property":b+("should have required property \\'"+G+"\\'"),b+="' "),e.opts.verbose&&(b+=" , schema: validate.schema"+g+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+k+" "),b+=" } "):b+=" {} ",d=b,b=C.pop(),b=!e.compositeRule&&h?e.async?b+(" throw new ValidationError(["+d+"]); "):b+(" validate.errors = ["+d+"]; return false; "):
b+(" var err = "+d+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "),d=z,e.errorPath=t,b+=" } else { "):h?(b+=" if ( "+G+" === undefined ",F&&(b+=" || ! Object.prototype.hasOwnProperty.call("+k+", '"+e.util.escapeQuotes(D)+"') "),b+=") { "+w+" = true; } else { "):(b+=" if ("+G+" !== undefined ",F&&(b+=" &&   Object.prototype.hasOwnProperty.call("+k+", '"+e.util.escapeQuotes(D)+"') "),b+=" ) { "),b+=" "+y+" } ");h&&(b+=" if ("+w+") { ",f+="}")}if(n.length&&n)for(M=-1,
C=n.length-1;M<C;)if(D=n[M+=1],y=q[D],e.opts.strictKeywords?"object"==typeof y&&0<Object.keys(y).length||!1===y:e.util.schemaHasRules(y,e.RULES.all))c.schema=y,c.schemaPath=e.schemaPath+".patternProperties"+e.util.getProperty(D),c.errSchemaPath=e.errSchemaPath+"/patternProperties/"+e.util.escapeFragment(D),b=F?b+(" "+v+" = "+v+" || Object.keys("+k+"); for (var "+p+"=0; "+p+"<"+v+".length; "+p+"++) { var "+m+" = "+v+"["+p+"]; "):b+(" for (var "+m+" in "+k+") { "),b+=" if ("+e.usePattern(D)+".test("+
m+")) { ",c.errorPath=e.util.getPathExpr(e.errorPath,m,e.opts.jsonPointers),z=k+"["+m+"]",c.dataPathArr[l]=m,y=e.validate(c),c.baseId=B,b=2>e.util.varOccurences(y,u)?b+(" "+e.util.varReplace(y,u,z)+" "):b+(" var "+u+" = "+z+"; "+y+" "),h&&(b+=" if (!"+w+") break; "),b+=" } ",h&&(b+=" else "+w+" = true; "),b+=" }  ",h&&(b+=" if ("+w+") { ",f+="}");h&&(b+=" "+f+" if ("+a+" == errors) {");return b}},2127:function(y){y.exports=function(e,h,b){b=" ";var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+
e.util.getProperty(h);h=e.errSchemaPath+"/"+h;var g=!e.opts.allErrors;t="data"+(t||"");var d="errs__"+r,a=e.util.copy(e);a.level++;var c="valid"+a.level;b+="var "+d+" = errors;";if(e.opts.strictKeywords?"object"==typeof k&&0<Object.keys(k).length||!1===k:e.util.schemaHasRules(k,e.RULES.all)){a.schema=k;a.schemaPath=x;a.errSchemaPath=h;k="key"+r;var f="idx"+r,w="i"+r,m="' + "+k+" + '",p="data"+(a.dataLevel=e.dataLevel+1),l="dataProperties"+r,u=e.opts.ownProperties,v=e.baseId;u&&(b+=" var "+l+" = undefined; ");
b=(u?b+(" "+l+" = "+l+" || Object.keys("+t+"); for (var "+f+"=0; "+f+"<"+l+".length; "+f+"++) { var "+k+" = "+l+"["+f+"]; "):b+(" for (var "+k+" in "+t+") { "))+(" var startErrs"+r+" = errors; ");f=e.compositeRule;e.compositeRule=a.compositeRule=!0;l=e.validate(a);a.baseId=v;b=2>e.util.varOccurences(l,p)?b+(" "+e.util.varReplace(l,p,k)+" "):b+(" var "+p+" = "+k+"; "+l+" ");e.compositeRule=a.compositeRule=f;b+=" if (!"+c+") { for (var "+w+"=startErrs"+r+"; "+w+"<errors; "+w+"++) { vErrors["+w+"].propertyName = "+
k+"; }   var err =   ";!1!==e.createErrors?(b+=" { keyword: 'propertyNames' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { propertyName: '"+m+"' } ",!1!==e.opts.messages&&(b+=" , message: 'property name \\'"+m+"\\' is invalid' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+t+" "),b+=" } "):b+=" {} ";b+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";
!e.compositeRule&&g&&(b=e.async?b+" throw new ValidationError(vErrors); ":b+" validate.errors = vErrors; return false; ");g&&(b+=" break; ");b+=" } }"}g&&(b+="  if ("+d+" == errors) {");return b}},2331:function(y){y.exports=function(e,h,b){b=" ";var r=e.dataLevel,t=e.schema[h],k=e.errSchemaPath+"/"+h;h=!e.opts.allErrors;var x="data"+(r||""),g="valid"+e.level;if("#"==t||"#/"==t)if(e.isRoot){var d=e.async;var a="validate"}else d=!0===e.root.schema.$async,a="root.refVal[0]";else{var c=e.resolveRef(e.baseId,
t,e.isRoot);if(void 0===c)if(c=e.MissingRefError.message(e.baseId,t),"fail"==e.opts.missingRefs){e.logger.error(c);var f=f||[];f.push(b);b="";!1!==e.createErrors?(b+=" { keyword: '$ref' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(k)+" , params: { ref: '"+e.util.escapeQuotes(t)+"' } ",!1!==e.opts.messages&&(b+=" , message: 'can\\'t resolve reference "+e.util.escapeQuotes(t)+"' "),e.opts.verbose&&(b+=" , schema: "+e.util.toQuotedString(t)+" , parentSchema: validate.schema"+
e.schemaPath+" , data: "+x+" "),b+=" } "):b+=" {} ";t=b;b=f.pop();b=!e.compositeRule&&h?e.async?b+(" throw new ValidationError(["+t+"]); "):b+(" validate.errors = ["+t+"]; return false; "):b+(" var err = "+t+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");h&&(b+=" if (false) { ")}else if("ignore"==e.opts.missingRefs)e.logger.warn(c),h&&(b+=" if (true) { ");else throw new e.MissingRefError(e.baseId,t,c);else if(c.inline){var w=e.util.copy(e);w.level++;k="valid"+w.level;
w.schema=c.schema;w.schemaPath="";w.errSchemaPath=t;t=e.validate(w).replace(/validate\.schema/g,c.code);b+=" "+t+" ";h&&(b+=" if ("+k+") { ")}else d=!0===c.$async||e.async&&!1!==c.$async,a=c.code}if(a)if(f=f||[],f.push(b),b="",b=e.opts.passContext?b+(" "+a+".call(this, "):b+(" "+a+"( "),b+=" "+x+", (dataPath || '')",'""'!=e.errorPath&&(b+=" + "+e.errorPath),r=b+=" , "+(r?"data"+(r-1||""):"parentData")+" , "+(r?e.dataPathArr[r]:"parentDataProperty")+", rootData)  ",b=f.pop(),d){if(!e.async)throw Error("async schema referenced by sync schema");
h&&(b+=" var "+g+"; ");b+=" try { await "+r+"; ";h&&(b+=" "+g+" = true; ");b+=" } catch (e) { if (!(e instanceof ValidationError)) throw e; if (vErrors === null) vErrors = e.errors; else vErrors = vErrors.concat(e.errors); errors = vErrors.length; ";h&&(b+=" "+g+" = false; ");b+=" } ";h&&(b+=" if ("+g+") { ")}else b+=" if (!"+r+") { if (vErrors === null) vErrors = "+a+".errors; else vErrors = vErrors.concat("+a+".errors); errors = vErrors.length; } ",h&&(b+=" else { ");return b}},1204:function(y){y.exports=
function(e,h,b){b=" ";var r=e.level,t=e.dataLevel,k=e.schema[h],x=e.schemaPath+e.util.getProperty(h);h=e.errSchemaPath+"/"+h;var g=!e.opts.allErrors,d="data"+(t||""),a="valid"+r,c=e.opts.$data&&k&&k.$data;c&&(b+=" var schema"+r+" = "+e.util.getData(k.$data,t,e.dataPathArr)+"; ");var f="schema"+r;if(!c)if(k.length<e.opts.loopRequired&&e.schema.properties&&Object.keys(e.schema.properties).length){var w=[];if(k)for(var m=-1,p=k.length-1;m<p;){t=k[m+=1];var l=e.schema.properties[t];l&&(e.opts.strictKeywords?
"object"==typeof l&&0<Object.keys(l).length||!1===l:e.util.schemaHasRules(l,e.RULES.all))||(w[w.length]=t)}}else w=k;if(c||w.length){k=e.errorPath;m=c||w.length>=e.opts.loopRequired;t=e.opts.ownProperties;if(g){b+=" var missing"+r+"; ";if(m){c||(b+=" var "+f+" = validate.schema"+x+"; ");m="i"+r;p="schema"+r+"["+m+"]";w="' + "+p+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(k,p,e.opts.jsonPointers));b+=" var "+a+" = true; ";c&&(b+=" if (schema"+r+" === undefined) "+a+" = true; else if (!Array.isArray(schema"+
r+")) "+a+" = false; else {");b+=" for (var "+m+" = 0; "+m+" < "+f+".length; "+m+"++) { "+a+" = "+d+"["+f+"["+m+"]] !== undefined ";t&&(b+=" &&   Object.prototype.hasOwnProperty.call("+d+", "+f+"["+m+"]) ");b+="; if (!"+a+") break; } ";c&&(b+="  }  ");var u=u||[];u.push(b+("  if (!"+a+") {   "));b="";!1!==e.createErrors?(b+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { missingProperty: '"+w+"' } ",!1!==e.opts.messages&&
(b+=" , message: '",b=e.opts._errorDataPathProperty?b+"is a required property":b+("should have required property \\'"+w+"\\'"),b+="' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),b+=" } "):b+=" {} ";x=b}else{b+=" if ( ";if(w)for(m=-1,p=w.length-1;m<p;)a=w[m+=1],m&&(b+=" || "),c=e.util.getProperty(a),f=d+c,b+=" ( ( "+f+" === undefined ",t&&(b+=" || ! Object.prototype.hasOwnProperty.call("+d+", '"+e.util.escapeQuotes(a)+"') "),
b+=") && (missing"+r+" = "+e.util.toQuotedString(e.opts.jsonPointers?a:c)+") ) ";b+=") {  ";p="missing"+r;w="' + "+p+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.opts.jsonPointers?e.util.getPathExpr(k,p,!0):k+" + "+p);u=u||[];u.push(b);b="";!1!==e.createErrors?(b+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { missingProperty: '"+w+"' } ",!1!==e.opts.messages&&(b+=" , message: '",b=e.opts._errorDataPathProperty?
b+"is a required property":b+("should have required property \\'"+w+"\\'"),b+="' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),b+=" } "):b+=" {} ";x=b}b=u.pop();b=!e.compositeRule&&g?e.async?b+(" throw new ValidationError(["+x+"]); "):b+(" validate.errors = ["+x+"]; return false; "):b+(" var err = "+x+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");b+=" } else { "}else if(m)c||(b+=" var "+f+
" = validate.schema"+x+"; "),m="i"+r,p="schema"+r+"["+m+"]",w="' + "+p+" + '",e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(k,p,e.opts.jsonPointers)),c&&(b+=" if ("+f+" && !Array.isArray("+f+")) {  var err =   ",!1!==e.createErrors?(b+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { missingProperty: '"+w+"' } ",!1!==e.opts.messages&&(b+=" , message: '",b=e.opts._errorDataPathProperty?b+"is a required property":
b+("should have required property \\'"+w+"\\'"),b+="' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),b+=" } "):b+=" {} ",b+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } else if ("+f+" !== undefined) { "),b+=" for (var "+m+" = 0; "+m+" < "+f+".length; "+m+"++) { if ("+d+"["+f+"["+m+"]] === undefined ",t&&(b+=" || ! Object.prototype.hasOwnProperty.call("+d+", "+f+"["+m+"]) "),b+=") {  var err =   ",
!1!==e.createErrors?(b+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { missingProperty: '"+w+"' } ",!1!==e.opts.messages&&(b+=" , message: '",b=e.opts._errorDataPathProperty?b+"is a required property":b+("should have required property \\'"+w+"\\'"),b+="' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),b+=" } "):b+=" {} ",b+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } } ",
c&&(b+="  }  ");else if(u=w)for(r=-1,g=u.length-1;r<g;)a=u[r+=1],c=e.util.getProperty(a),w=e.util.escapeQuotes(a),f=d+c,e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(k,a,e.opts.jsonPointers)),b+=" if ( "+f+" === undefined ",t&&(b+=" || ! Object.prototype.hasOwnProperty.call("+d+", '"+e.util.escapeQuotes(a)+"') "),b+=") {  var err =   ",!1!==e.createErrors?(b+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { missingProperty: '"+
w+"' } ",!1!==e.opts.messages&&(b+=" , message: '",b=e.opts._errorDataPathProperty?b+"is a required property":b+("should have required property \\'"+w+"\\'"),b+="' "),e.opts.verbose&&(b+=" , schema: validate.schema"+x+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),b+=" } "):b+=" {} ",b+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } ";e.errorPath=k}else g&&(b+=" if (true) {");return b}},1985:function(y){y.exports=function(e,h,b){b=" ";var r=e.level,
t=e.dataLevel,k=e.schema[h],x=e.schemaPath+e.util.getProperty(h),g=e.errSchemaPath+"/"+h;h=!e.opts.allErrors;var d="data"+(t||""),a="valid"+r,c=e.opts.$data&&k&&k.$data;c?(b+=" var schema"+r+" = "+e.util.getData(k.$data,t,e.dataPathArr)+"; ",r="schema"+r):r=k;if((k||c)&&!1!==e.opts.uniqueItems){c&&(b+=" var "+a+"; if ("+r+" === false || "+r+" === undefined) "+a+" = true; else if (typeof "+r+" != 'boolean') "+a+" = false; else { ");b+=" var i = "+d+".length , "+a+" = true , j; if (i > 1) { ";r=e.schema.items&&
e.schema.items.type;t=Array.isArray(r);!r||"object"==r||"array"==r||t&&(0<=r.indexOf("object")||0<=r.indexOf("array"))?b+=" outer: for (;i--;) { for (j = i; j--;) { if (equal("+d+"[i], "+d+"[j])) { "+a+" = false; break outer; } } } ":(b=b+(" var itemIndices = {}, item; for (;i--;) { var item = "+d+"[i];  if (")+(e.util["checkDataType"+(t?"s":"")](r,"item",e.opts.strictNumbers,!0)+") continue; "),t&&(b+=" if (typeof item == 'string') item = '\"' + item; "),b+=" if (typeof itemIndices[item] == 'number') { "+
a+" = false; j = itemIndices[item]; break; } itemIndices[item] = i; } ");b+=" } ";c&&(b+="  }  ");var f=f||[];f.push(b+(" if (!"+a+") {   "));b="";!1!==e.createErrors?(b+=" { keyword: 'uniqueItems' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { i: i, j: j } ",!1!==e.opts.messages&&(b+=" , message: 'should NOT have duplicate items (items ## ' + j + ' and ' + i + ' are identical)' "),e.opts.verbose&&(b+=" , schema:  ",b=c?b+("validate.schema"+x):
b+(""+k),b+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),b+=" } "):b+=" {} ";k=b;b=f.pop();b=!e.compositeRule&&h?e.async?b+(" throw new ValidationError(["+k+"]); "):b+(" validate.errors = ["+k+"]; return false; "):b+(" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");b+=" } ";h&&(b+=" else { ")}else h&&(b+=" if (true) { ");return b}},1869:function(y){y.exports=function(e,h,b){function r(a){a=a.rules;for(var b=0;b<a.length;b++)if(t(a[b]))return!0}
function t(a){var b;if(!(b=void 0!==e.schema[a.keyword])&&(b=a.implements))a:{a=a.implements;for(b=0;b<a.length;b++)if(void 0!==e.schema[a[b]]){b=!0;break a}b=void 0}return b}b="";var k=!0===e.schema.$async,x=e.util.schemaHasRulesExcept(e.schema,e.RULES.all,"$ref"),g=e.self._getId(e.schema);if(e.opts.strictKeywords){var d=e.util.schemaUnknownRules(e.schema,e.RULES.keywords);if(d)if(d="unknown keyword: "+d,"log"===e.opts.strictKeywords)e.logger.warn(d);else throw Error(d);}e.isTop&&(b+=" var validate = ",
k&&(e.async=!0,b+="async "),b+="function(data, dataPath, parentData, parentDataProperty, rootData) { 'use strict'; ",g&&(e.opts.sourceCode||e.opts.processCode)&&(b+=" /*# sourceURL="+(g+" */ ")));if("boolean"==typeof e.schema||!x&&!e.schema.$ref){h="false schema";d=e.level;var a=e.dataLevel,c=e.schema[h],f=e.schemaPath+e.util.getProperty(h),w=e.errSchemaPath+"/"+h;g=!e.opts.allErrors;h="data"+(a||"");var m="valid"+d;if(!1===e.schema){e.isTop?g=!0:b+=" var "+m+" = false; ";var p=p||[];p.push(b);b=
"";!1!==e.createErrors?(b+=" { keyword: 'false schema' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(w)+" , params: {} ",!1!==e.opts.messages&&(b+=" , message: 'boolean schema is false' "),e.opts.verbose&&(b+=" , schema: false , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),b+=" } "):b+=" {} ";f=b;b=p.pop();b=!e.compositeRule&&g?e.async?b+(" throw new ValidationError(["+f+"]); "):b+(" validate.errors = ["+f+"]; return false; "):b+(" var err = "+
f+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ")}else b=e.isTop?k?b+" return data; ":b+" validate.errors = null; return true; ":b+(" var "+m+" = true; ");e.isTop&&(b+=" }; return validate; ");return b}if(e.isTop){var l=e.isTop;d=e.level=0;a=e.dataLevel=0;h="data";e.rootId=e.resolve.fullPath(e.self._getId(e.root.schema));e.baseId=e.baseId||e.rootId;delete e.isTop;e.dataPathArr=[""];if(void 0!==e.schema.default&&e.opts.useDefaults&&e.opts.strictDefaults)if(w="default is ignored in the schema root",
"log"===e.opts.strictDefaults)e.logger.warn(w);else throw Error(w);b+=" var vErrors = null;  var errors = 0;      if (rootData === undefined) rootData = data; "}else{d=e.level;a=e.dataLevel;h="data"+(a||"");g&&(e.baseId=e.resolve.url(e.baseId,g));if(k&&!e.async)throw Error("async schema in sync schema");b+=" var errs_"+d+" = errors;"}m="valid"+d;g=!e.opts.allErrors;var u="",v="",A=e.schema.type,q=Array.isArray(A);A&&e.opts.nullable&&!0===e.schema.nullable&&(q?-1==A.indexOf("null")&&(A=A.concat("null")):
"null"!=A&&(A=[A,"null"],q=!0));q&&1==A.length&&(A=A[0],q=!1);if(e.schema.$ref&&x){if("fail"==e.opts.extendRefs)throw Error('$ref: validation keywords used in schema at path "'+e.errSchemaPath+'" (see option extendRefs)');!0!==e.opts.extendRefs&&(x=!1,e.logger.warn('$ref: keywords ignored in schema at path "'+e.errSchemaPath+'"'))}e.schema.$comment&&e.opts.$comment&&(b+=" "+e.RULES.all.$comment.code(e,"$comment"));if(A){if(e.opts.coerceTypes)var n=e.util.coerceToTypes(e.opts.coerceTypes,A);f=e.RULES.types[A];
if(n||q||!0===f||f&&!r(f)){f=e.schemaPath+".type";w=e.errSchemaPath+"/type";f=e.schemaPath+".type";w=e.errSchemaPath+"/type";b+=" if ("+e.util[q?"checkDataTypes":"checkDataType"](A,h,e.opts.strictNumbers,!0)+") { ";if(n){var y="dataType"+d,K="coerced"+d;b+=" var "+y+" = typeof "+h+"; var "+K+" = undefined; ";"array"==e.opts.coerceTypes&&(b+=" if ("+y+" == 'object' && Array.isArray("+h+") && "+h+".length == 1) { "+h+" = "+h+"[0]; "+y+" = typeof "+h+"; if ("+e.util.checkDataType(e.schema.type,h,e.opts.strictNumbers)+
") "+K+" = "+h+"; } ");b+=" if ("+K+" !== undefined) ; ";var z=n;if(z){c=-1;for(var H=z.length-1;c<H;){var E=z[c+=1];"string"==E?b+=" else if ("+y+" == 'number' || "+y+" == 'boolean') "+K+" = '' + "+h+"; else if ("+h+" === null) "+K+" = ''; ":"number"==E||"integer"==E?(b+=" else if ("+y+" == 'boolean' || "+h+" === null || ("+y+" == 'string' && "+h+" && "+h+" == +"+h+" ","integer"==E&&(b+=" && !("+h+" % 1)"),b+=")) "+K+" = +"+h+"; "):"boolean"==E?b+=" else if ("+h+" === 'false' || "+h+" === 0 || "+
h+" === null) "+K+" = false; else if ("+h+" === 'true' || "+h+" === 1) "+K+" = true; ":"null"==E?b+=" else if ("+h+" === '' || "+h+" === 0 || "+h+" === false) "+K+" = null; ":"array"==e.opts.coerceTypes&&"array"==E&&(b+=" else if ("+y+" == 'string' || "+y+" == 'number' || "+y+" == 'boolean' || "+h+" == null) "+K+" = ["+h+"]; ")}}p=p||[];p.push(b+" else {   ");b="";!1!==e.createErrors?(b+=" { keyword: 'type' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(w)+" , params: { type: '",
b=q?b+(""+A.join(",")):b+(""+A),b+="' } ",!1!==e.opts.messages&&(b+=" , message: 'should be ",b=q?b+(""+A.join(",")):b+(""+A),b+="' "),e.opts.verbose&&(b+=" , schema: validate.schema"+f+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),b+=" } "):b+=" {} ";f=b;b=p.pop();b=!e.compositeRule&&g?e.async?b+(" throw new ValidationError(["+f+"]); "):b+(" validate.errors = ["+f+"]; return false; "):b+(" var err = "+f+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");
f=a?"data"+(a-1||""):"parentData";c=a?e.dataPathArr[a]:"parentDataProperty";b=b+(" } if ("+K+" !== undefined) {   ")+(h+" = "+K+"; ");a||(b+="if ("+f+" !== undefined)");b+=" "+f+"["+c+"] = "+K+"; } "}else p=p||[],p.push(b),b="",!1!==e.createErrors?(b+=" { keyword: 'type' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(w)+" , params: { type: '",b=q?b+(""+A.join(",")):b+(""+A),b+="' } ",!1!==e.opts.messages&&(b+=" , message: 'should be ",b=q?b+(""+A.join(",")):b+
(""+A),b+="' "),e.opts.verbose&&(b+=" , schema: validate.schema"+f+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),b+=" } "):b+=" {} ",f=b,b=p.pop(),b=!e.compositeRule&&g?e.async?b+(" throw new ValidationError(["+f+"]); "):b+(" validate.errors = ["+f+"]; return false; "):b+(" var err = "+f+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ");b+=" } "}}if(e.schema.$ref&&!x)b+=" "+e.RULES.all.$ref.code(e,"$ref")+" ",g&&(b+=" } if (errors === ",b=(l?b+"0":
b+("errs_"+d))+") { ",v+="}");else if(x=e.RULES)for(a=-1,K=x.length-1;a<K;)if(f=x[a+=1],r(f)){f.type&&(b+=" if ("+e.util.checkDataType(f.type,h,e.opts.strictNumbers)+") { ");if(e.opts.useDefaults)if("object"==f.type&&e.schema.properties){if(c=e.schema.properties,z=Object.keys(c))for(E=-1,H=z.length-1;E<H;)if(y=z[E+=1],w=c[y],void 0!==w.default)if(y=h+e.util.getProperty(y),e.compositeRule){if(e.opts.strictDefaults)if(w="default is ignored for: "+y,"log"===e.opts.strictDefaults)e.logger.warn(w);else throw Error(w);
}else b+=" if ("+y+" === undefined ","empty"==e.opts.useDefaults&&(b+=" || "+y+" === null || "+y+" === '' "),b+=" ) "+y+" = ",b="shared"==e.opts.useDefaults?b+(" "+e.useDefault(w.default)+" "):b+(" "+JSON.stringify(w.default)+" "),b+="; "}else if("array"==f.type&&Array.isArray(e.schema.items)&&(z=e.schema.items))for(c=-1,E=z.length-1;c<E;)if(w=z[c+=1],void 0!==w.default)if(y=h+"["+c+"]",e.compositeRule){if(e.opts.strictDefaults)if(w="default is ignored for: "+y,"log"===e.opts.strictDefaults)e.logger.warn(w);
else throw Error(w);}else b+=" if ("+y+" === undefined ","empty"==e.opts.useDefaults&&(b+=" || "+y+" === null || "+y+" === '' "),b+=" ) "+y+" = ",b="shared"==e.opts.useDefaults?b+(" "+e.useDefault(w.default)+" "):b+(" "+JSON.stringify(w.default)+" "),b+="; ";if(c=f.rules)for(w=-1,y=c.length-1;w<y;)if(z=c[w+=1],t(z)&&(z=z.code(e,z.keyword,f.type)))b+=" "+z+" ",g&&(u+="}");g&&(b+=" "+u+" ",u="");f.type&&(b+=" } ",A&&A===f.type&&!n&&(b+=" else { ",f=e.schemaPath+".type",w=e.errSchemaPath+"/type",p=p||
[],p.push(b),b="",!1!==e.createErrors?(b+=" { keyword: 'type' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(w)+" , params: { type: '",b=q?b+(""+A.join(",")):b+(""+A),b+="' } ",!1!==e.opts.messages&&(b+=" , message: 'should be ",b=q?b+(""+A.join(",")):b+(""+A),b+="' "),e.opts.verbose&&(b+=" , schema: validate.schema"+f+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),b+=" } "):b+=" {} ",f=b,b=p.pop(),b=!e.compositeRule&&g?e.async?b+(" throw new ValidationError(["+
f+"]); "):b+(" validate.errors = ["+f+"]; return false; "):b+(" var err = "+f+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "),b+=" } "));g&&(b+=" if (errors === ",b=l?b+"0":b+("errs_"+d),b+=") { ",v+="}")}g&&(b+=" "+v+" ");l?(k?(b+=" if (errors === 0) return data;           ",b+=" else throw new ValidationError(vErrors); "):(b+=" validate.errors = vErrors; ",b+=" return errors === 0;       "),b+=" }; return validate;"):b+=" var "+m+" = errors === errs_"+d+";";return b}},
7931:function(y,e,h){function b(e,g){b.errors=null;var d=this._validateKeyword=this._validateKeyword||this.compile(k,!0);if(d(e))return!0;b.errors=d.errors;if(g)throw Error("custom keyword definition is invalid: "+this.errorsText(d.errors));return!1}var r=/^[a-z_$][a-z0-9_$-]*$/i,t=h(1793),k=h(5868);y.exports={add:function(b,e){function d(b,c,d){for(var e,f=0;f<a.length;f++){var g=a[f];if(g.type==c){e=g;break}}e||(e={type:c,rules:[]},a.push(e));c={keyword:b,definition:d,custom:!0,code:t,implements:d.implements};
e.rules.push(c);a.custom[b]=c}var a=this.RULES;if(a.keywords[b])throw Error("Keyword "+b+" is already defined");if(!r.test(b))throw Error("Keyword "+b+" is not a valid identifier");if(e){this.validateKeyword(e,!0);var c=e.type;if(Array.isArray(c))for(var f=0;f<c.length;f++)d(b,c[f],e);else d(b,c,e);if(c=e.metaSchema)e.$data&&this._opts.$data&&(c={anyOf:[c,{$ref:"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"}]}),e.validateSchema=this.compile(c,!0)}a.keywords[b]=a.all[b]=
!0;return this},get:function(b){var e=this.RULES.custom[b];return e?e.definition:this.RULES.keywords[b]||!1},remove:function(b){var e=this.RULES;delete e.keywords[b];delete e.all[b];delete e.custom[b];for(var d=0;d<e.length;d++)for(var a=e[d].rules,c=0;c<a.length;c++)if(a[c].keyword==b){a.splice(c,1);break}return this},validate:b}},2303:function(y){y.exports=function r(h,b){if(h===b)return!0;if(h&&b&&"object"==typeof h&&"object"==typeof b){if(h.constructor!==b.constructor)return!1;var t;if(Array.isArray(h)){var k=
h.length;if(k!=b.length)return!1;for(t=k;0!==t--;)if(!r(h[t],b[t]))return!1;return!0}if(h.constructor===RegExp)return h.source===b.source&&h.flags===b.flags;if(h.valueOf!==Object.prototype.valueOf)return h.valueOf()===b.valueOf();if(h.toString!==Object.prototype.toString)return h.toString()===b.toString();var x=Object.keys(h);k=x.length;if(k!==Object.keys(b).length)return!1;for(t=k;0!==t--;)if(!Object.prototype.hasOwnProperty.call(b,x[t]))return!1;for(t=k;0!==t--;)if(k=x[t],!r(h[k],b[k]))return!1;
return!0}return h!==h&&b!==b}},3508:function(y){y.exports=function(e,h){h||(h={});"function"===typeof h&&(h={cmp:h});var b="boolean"===typeof h.cycles?h.cycles:!1,r=h.cmp&&function(b){return function(e){return function(g,d){return b({key:g,value:e[g]},{key:d,value:e[d]})}}}(h.cmp),t=[];return function g(e){e&&e.toJSON&&"function"===typeof e.toJSON&&(e=e.toJSON());if(void 0!==e){if("number"==typeof e)return isFinite(e)?""+e:"null";if("object"!==typeof e)return JSON.stringify(e);var d;if(Array.isArray(e)){var a=
"[";for(d=0;d<e.length;d++)d&&(a+=","),a+=g(e[d])||"null";return a+"]"}if(null===e)return"null";if(-1!==t.indexOf(e)){if(b)return JSON.stringify("__cycle__");throw new TypeError("Converting circular structure to JSON");}var c=t.push(e)-1,f=Object.keys(e).sort(r&&r(e));a="";for(d=0;d<f.length;d++){var h=f[d],m=g(e[h]);m&&(a&&(a+=","),a+=JSON.stringify(h)+":"+m)}t.splice(c,1);return"{"+a+"}"}}(e)}},233:function(y){y.exports=function r(h,b){var t=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,
k=/(^[ ]*|[ ]*$)/g,x=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,g=/^0x[0-9a-f]+$/i,d=/^0/,a=function(a){return r.insensitive&&(""+a).toLowerCase()||""+a};h=a(h).replace(k,"")||"";k=a(b).replace(k,"")||"";b=h.replace(t,"\x00$1\x00").replace(/\0$/,"").replace(/^\0/,"").split("\x00");t=k.replace(t,"\x00$1\x00").replace(/\0$/,"").replace(/^\0/,"").split("\x00");h=parseInt(h.match(g),16)||1!==b.length&&h.match(x)&&Date.parse(h);if(x=
parseInt(k.match(g),16)||h&&k.match(x)&&Date.parse(k)||null){if(h<x)return-1;if(h>x)return 1}h=0;for(k=Math.max(b.length,t.length);h<k;h++){x=!(b[h]||"").match(d)&&parseFloat(b[h])||b[h]||0;g=!(t[h]||"").match(d)&&parseFloat(t[h])||t[h]||0;if(isNaN(x)!==isNaN(g))return isNaN(x)?1:-1;typeof x!==typeof g&&(x+="",g+="");if(x<g)return-1;if(x>g)return 1}return 0}},5156:function(y,e){(function(e){function b(a){return null!==a?"[object Array]"===Object.prototype.toString.call(a):!1}function h(a){return null!==
a?"[object Object]"===Object.prototype.toString.call(a):!1}function t(a,c){if(a===c)return!0;if(Object.prototype.toString.call(a)!==Object.prototype.toString.call(c))return!1;if(!0===b(a)){if(a.length!==c.length)return!1;for(var d=0;d<a.length;d++)if(!1===t(a[d],c[d]))return!1;return!0}if(!0===h(a)){d={};for(var e in a)if(hasOwnProperty.call(a,e)){if(!1===t(a[e],c[e]))return!1;d[e]=!0}for(var f in c)if(hasOwnProperty.call(c,f)&&!0!==d[f])return!1;return!0}return!1}function k(a){if(""===a||!1===a||
null===a||b(a)&&0===a.length)return!0;if(h(a)){for(var c in a)if(a.hasOwnProperty(c))return!1;return!0}return!1}function x(a){return"0"<=a&&"9">=a||"-"===a}function g(a){return"a"<=a&&"z">=a||"A"<=a&&"Z">=a||"0"<=a&&"9">=a||"_"===a}function d(){}function a(){}function c(a){this.runtime=a}function f(a){this._interpreter=a;this.functionTable={abs:{_func:this._functionAbs,_signature:[{types:[0]}]},avg:{_func:this._functionAvg,_signature:[{types:[8]}]},ceil:{_func:this._functionCeil,_signature:[{types:[0]}]},
contains:{_func:this._functionContains,_signature:[{types:[2,3]},{types:[1]}]},ends_with:{_func:this._functionEndsWith,_signature:[{types:[2]},{types:[2]}]},floor:{_func:this._functionFloor,_signature:[{types:[0]}]},length:{_func:this._functionLength,_signature:[{types:[2,3,4]}]},map:{_func:this._functionMap,_signature:[{types:[6]},{types:[3]}]},max:{_func:this._functionMax,_signature:[{types:[8,9]}]},merge:{_func:this._functionMerge,_signature:[{types:[4],variadic:!0}]},max_by:{_func:this._functionMaxBy,
_signature:[{types:[3]},{types:[6]}]},sum:{_func:this._functionSum,_signature:[{types:[8]}]},starts_with:{_func:this._functionStartsWith,_signature:[{types:[2]},{types:[2]}]},min:{_func:this._functionMin,_signature:[{types:[8,9]}]},min_by:{_func:this._functionMinBy,_signature:[{types:[3]},{types:[6]}]},type:{_func:this._functionType,_signature:[{types:[1]}]},keys:{_func:this._functionKeys,_signature:[{types:[4]}]},values:{_func:this._functionValues,_signature:[{types:[4]}]},sort:{_func:this._functionSort,
_signature:[{types:[9,8]}]},sort_by:{_func:this._functionSortBy,_signature:[{types:[3]},{types:[6]}]},join:{_func:this._functionJoin,_signature:[{types:[2]},{types:[9]}]},reverse:{_func:this._functionReverse,_signature:[{types:[2,3]}]},to_array:{_func:this._functionToArray,_signature:[{types:[1]}]},to_string:{_func:this._functionToString,_signature:[{types:[1]}]},to_number:{_func:this._functionToNumber,_signature:[{types:[1]}]},not_null:{_func:this._functionNotNull,_signature:[{types:[1],variadic:!0}]}}}
var w="function"===typeof String.prototype.trimLeft?function(a){return a.trimLeft()}:function(a){return a.match(/^\s*(.*)/)[1]};var m={".":"Dot","*":"Star",",":"Comma",":":"Colon","{":"Lbrace","}":"Rbrace","]":"Rbracket","(":"Lparen",")":"Rparen","@":"Current"},p={"<":!0,">":!0,"=":!0,"!":!0},l={" ":!0,"\t":!0,"\n":!0};d.prototype={tokenize:function(a){var b=[];this._current=0;for(var c,d;this._current<a.length;)if(c=a[this._current],"a"<=c&&"z">=c||"A"<=c&&"Z">=c||"_"===c)c=this._current,d=this._consumeUnquotedIdentifier(a),
b.push({type:"UnquotedIdentifier",value:d,start:c});else if(void 0!==m[a[this._current]])b.push({type:m[a[this._current]],value:a[this._current],start:this._current}),this._current++;else if(x(a[this._current]))c=this._consumeNumber(a),b.push(c);else if("["===a[this._current])c=this._consumeLBracket(a),b.push(c);else if('"'===a[this._current])c=this._current,d=this._consumeQuotedIdentifier(a),b.push({type:"QuotedIdentifier",value:d,start:c});else if("'"===a[this._current])c=this._current,d=this._consumeRawStringLiteral(a),
b.push({type:"Literal",value:d,start:c});else if("`"===a[this._current])c=this._current,d=this._consumeLiteral(a),b.push({type:"Literal",value:d,start:c});else if(void 0!==p[a[this._current]])b.push(this._consumeOperator(a));else if(void 0!==l[a[this._current]])this._current++;else if("&"===a[this._current])c=this._current,this._current++,"&"===a[this._current]?(this._current++,b.push({type:"And",value:"&&",start:c})):b.push({type:"Expref",value:"&",start:c});else if("|"===a[this._current])c=this._current,
this._current++,"|"===a[this._current]?(this._current++,b.push({type:"Or",value:"||",start:c})):b.push({type:"Pipe",value:"|",start:c});else throw a=Error("Unknown character:"+a[this._current]),a.name="LexerError",a;return b},_consumeUnquotedIdentifier:function(a){var b=this._current;for(this._current++;this._current<a.length&&g(a[this._current]);)this._current++;return a.slice(b,this._current)},_consumeQuotedIdentifier:function(a){var b=this._current;this._current++;for(var c=a.length;'"'!==a[this._current]&&
this._current<c;){var d=this._current;"\\"!==a[d]||"\\"!==a[d+1]&&'"'!==a[d+1]?d++:d+=2;this._current=d}this._current++;return JSON.parse(a.slice(b,this._current))},_consumeRawStringLiteral:function(a){var b=this._current;this._current++;for(var c=a.length;"'"!==a[this._current]&&this._current<c;){var d=this._current;"\\"!==a[d]||"\\"!==a[d+1]&&"'"!==a[d+1]?d++:d+=2;this._current=d}this._current++;return a.slice(b+1,this._current-1).replace("\\'","'")},_consumeNumber:function(a){var b=this._current;
this._current++;for(var c=a.length;x(a[this._current])&&this._current<c;)this._current++;return{type:"Number",value:parseInt(a.slice(b,this._current)),start:b}},_consumeLBracket:function(a){var b=this._current;this._current++;return"?"===a[this._current]?(this._current++,{type:"Filter",value:"[?",start:b}):"]"===a[this._current]?(this._current++,{type:"Flatten",value:"[]",start:b}):{type:"Lbracket",value:"[",start:b}},_consumeOperator:function(a){var b=this._current,c=a[b];this._current++;if("!"===
c)return"="===a[this._current]?(this._current++,{type:"NE",value:"!=",start:b}):{type:"Not",value:"!",start:b};if("<"===c)return"="===a[this._current]?(this._current++,{type:"LTE",value:"<=",start:b}):{type:"LT",value:"<",start:b};if(">"===c)return"="===a[this._current]?(this._current++,{type:"GTE",value:">=",start:b}):{type:"GT",value:">",start:b};if("="===c&&"="===a[this._current])return this._current++,{type:"EQ",value:"==",start:b}},_consumeLiteral:function(a){this._current++;for(var b=this._current,
c=a.length;"`"!==a[this._current]&&this._current<c;){var d=this._current;"\\"!==a[d]||"\\"!==a[d+1]&&"`"!==a[d+1]?d++:d+=2;this._current=d}a=w(a.slice(b,this._current));a=a.replace("\\`","`");a=this._looksLikeJSON(a)?JSON.parse(a):JSON.parse('"'+a+'"');this._current++;return a},_looksLikeJSON:function(a){var b=["true","false","null"];if(""===a)return!1;if(0<='[{"'.indexOf(a[0])||0<=b.indexOf(a))return!0;if(0<="-0123456789".indexOf(a[0]))try{return JSON.parse(a),!0}catch(q){return!1}else return!1}};
var u={EOF:0,UnquotedIdentifier:0,QuotedIdentifier:0,Rbracket:0,Rparen:0,Comma:0,Rbrace:0,Number:0,Current:0,Expref:0,Pipe:1,Or:2,And:3,EQ:5,GT:5,LT:5,GTE:5,LTE:5,NE:5,Flatten:9,Star:20,Filter:21,Dot:40,Not:45,Lbrace:50,Lbracket:55,Lparen:60};a.prototype={parse:function(a){this._loadTokens(a);this.index=0;a=this.expression(0);if("EOF"!==this._lookahead(0))throw a=this._lookaheadToken(0),a=Error("Unexpected token type: "+a.type+", value: "+a.value),a.name="ParserError",a;return a},_loadTokens:function(a){var b=
(new d).tokenize(a);b.push({type:"EOF",value:"",start:a.length});this.tokens=b},expression:function(a){var b=this._lookaheadToken(0);this._advance();b=this.nud(b);for(var c=this._lookahead(0);a<u[c];)this._advance(),b=this.led(c,b),c=this._lookahead(0);return b},_lookahead:function(a){return this.tokens[this.index+a].type},_lookaheadToken:function(a){return this.tokens[this.index+a]},_advance:function(){this.index++},nud:function(a){switch(a.type){case "Literal":return{type:"Literal",value:a.value};
case "UnquotedIdentifier":return{type:"Field",name:a.value};case "QuotedIdentifier":a={type:"Field",name:a.value};if("Lparen"===this._lookahead(0))throw Error("Quoted identifier not allowed for function names.");return a;case "Not":var b=this.expression(u.Not);return{type:"NotExpression",children:[b]};case "Star":return a={type:"Identity"},b="Rbracket"===this._lookahead(0)?{type:"Identity"}:this._parseProjectionRHS(u.Star),{type:"ValueProjection",children:[a,b]};case "Filter":return this.led(a.type,
{type:"Identity"});case "Lbrace":return this._parseMultiselectHash();case "Flatten":return a={type:"Flatten",children:[{type:"Identity"}]},b=this._parseProjectionRHS(u.Flatten),{type:"Projection",children:[a,b]};case "Lbracket":return"Number"===this._lookahead(0)||"Colon"===this._lookahead(0)?(b=this._parseIndexExpression(),this._projectIfSlice({type:"Identity"},b)):"Star"===this._lookahead(0)&&"Rbracket"===this._lookahead(1)?(this._advance(),this._advance(),b=this._parseProjectionRHS(u.Star),{type:"Projection",
children:[{type:"Identity"},b]}):this._parseMultiselectList();case "Current":return{type:"Current"};case "Expref":return a=this.expression(u.Expref),{type:"ExpressionReference",children:[a]};case "Lparen":for(b=[];"Rparen"!==this._lookahead(0);)"Current"===this._lookahead(0)?(a={type:"Current"},this._advance()):a=this.expression(0),b.push(a);this._match("Rparen");return b[0];default:this._errorToken(a)}},led:function(a,b){switch(a){case "Dot":a=u.Dot;if("Star"!==this._lookahead(0))return a=this._parseDotRHS(a),
{type:"Subexpression",children:[b,a]};this._advance();a=this._parseProjectionRHS(a);return{type:"ValueProjection",children:[b,a]};case "Pipe":return a=this.expression(u.Pipe),{type:"Pipe",children:[b,a]};case "Or":return a=this.expression(u.Or),{type:"OrExpression",children:[b,a]};case "And":return a=this.expression(u.And),{type:"AndExpression",children:[b,a]};case "Lparen":b=b.name;a=[];for(var c;"Rparen"!==this._lookahead(0);)"Current"===this._lookahead(0)?(c={type:"Current"},this._advance()):c=
this.expression(0),"Comma"===this._lookahead(0)&&this._match("Comma"),a.push(c);this._match("Rparen");return{type:"Function",name:b,children:a};case "Filter":return c=this.expression(0),this._match("Rbracket"),a="Flatten"===this._lookahead(0)?{type:"Identity"}:this._parseProjectionRHS(u.Filter),{type:"FilterProjection",children:[b,a,c]};case "Flatten":return b={type:"Flatten",children:[b]},a=this._parseProjectionRHS(u.Flatten),{type:"Projection",children:[b,a]};case "EQ":case "NE":case "GT":case "GTE":case "LT":case "LTE":return this._parseComparator(b,
a);case "Lbracket":a=this._lookaheadToken(0);if("Number"===a.type||"Colon"===a.type)return a=this._parseIndexExpression(),this._projectIfSlice(b,a);this._match("Star");this._match("Rbracket");a=this._parseProjectionRHS(u.Star);return{type:"Projection",children:[b,a]};default:this._errorToken(this._lookaheadToken(0))}},_match:function(a){if(this._lookahead(0)===a)this._advance();else{var b=this._lookaheadToken(0);a=Error("Expected "+a+", got: "+b.type);a.name="ParserError";throw a;}},_errorToken:function(a){a=
Error("Invalid token ("+a.type+'): "'+a.value+'"');a.name="ParserError";throw a;},_parseIndexExpression:function(){if("Colon"===this._lookahead(0)||"Colon"===this._lookahead(1))return this._parseSliceExpression();var a={type:"Index",value:this._lookaheadToken(0).value};this._advance();this._match("Rbracket");return a},_projectIfSlice:function(a,b){a={type:"IndexExpression",children:[a,b]};return"Slice"===b.type?{type:"Projection",children:[a,this._parseProjectionRHS(u.Star)]}:a},_parseSliceExpression:function(){for(var a=
[null,null,null],b=0,c=this._lookahead(0);"Rbracket"!==c&&3>b;){if("Colon"===c)b++,this._advance();else if("Number"===c)a[b]=this._lookaheadToken(0).value,this._advance();else throw a=this._lookahead(0),a=Error("Syntax error, unexpected token: "+a.value+"("+a.type+")"),a.name="Parsererror",a;c=this._lookahead(0)}this._match("Rbracket");return{type:"Slice",children:a}},_parseComparator:function(a,b){var c=this.expression(u[b]);return{type:"Comparator",name:b,children:[a,c]}},_parseDotRHS:function(a){var b=
this._lookahead(0);if(0<=["UnquotedIdentifier","QuotedIdentifier","Star"].indexOf(b))return this.expression(a);if("Lbracket"===b)return this._match("Lbracket"),this._parseMultiselectList();if("Lbrace"===b)return this._match("Lbrace"),this._parseMultiselectHash()},_parseProjectionRHS:function(a){if(10>u[this._lookahead(0)])a={type:"Identity"};else if("Lbracket"===this._lookahead(0))a=this.expression(a);else if("Filter"===this._lookahead(0))a=this.expression(a);else if("Dot"===this._lookahead(0))this._match("Dot"),
a=this._parseDotRHS(a);else throw a=this._lookaheadToken(0),a=Error("Sytanx error, unexpected token: "+a.value+"("+a.type+")"),a.name="ParserError",a;return a},_parseMultiselectList:function(){for(var a=[];"Rbracket"!==this._lookahead(0);){var b=this.expression(0);a.push(b);if("Comma"===this._lookahead(0)&&(this._match("Comma"),"Rbracket"===this._lookahead(0)))throw Error("Unexpected token Rbracket");}this._match("Rbracket");return{type:"MultiSelectList",children:a}},_parseMultiselectHash:function(){for(var a=
[],b=["UnquotedIdentifier","QuotedIdentifier"],c,d;;){c=this._lookaheadToken(0);if(0>b.indexOf(c.type))throw Error("Expecting an identifier token, got: "+c.type);c=c.value;this._advance();this._match("Colon");d=this.expression(0);c={type:"KeyValuePair",name:c,value:d};a.push(c);if("Comma"===this._lookahead(0))this._match("Comma");else if("Rbrace"===this._lookahead(0)){this._match("Rbrace");break}}return{type:"MultiSelectHash",children:a}}};c.prototype={search:function(a,b){return this.visit(a,b)},
visit:function(a,c){var d;switch(a.type){case "Field":return null===c?null:h(c)?(a=c[a.name],void 0===a?null:a):null;case "Subexpression":var e=this.visit(a.children[0],c);for(d=1;d<a.children.length;d++)if(e=this.visit(a.children[1],e),null===e)return null;return e;case "IndexExpression":return d=this.visit(a.children[0],c),a=this.visit(a.children[1],d);case "Index":if(!b(c))return null;a=a.value;0>a&&(a=c.length+a);e=c[a];void 0===e&&(e=null);return e;case "Slice":if(!b(c))return null;a=a.children.slice(0);
e=this.computeSliceParams(c.length,a);d=e[0];a=e[1];var f=e[2];e=[];if(0<f)for(;d<a;d+=f)e.push(c[d]);else for(;d>a;d+=f)e.push(c[d]);return e;case "Projection":f=this.visit(a.children[0],c);if(!b(f))return null;e=[];for(d=0;d<f.length;d++)c=this.visit(a.children[1],f[d]),null!==c&&e.push(c);return e;case "ValueProjection":f=this.visit(a.children[0],c);if(!h(f))return null;e=[];d=f;c=Object.keys(d);f=[];for(var g=0;g<c.length;g++)f.push(d[c[g]]);for(d=0;d<f.length;d++)c=this.visit(a.children[1],f[d]),
null!==c&&e.push(c);return e;case "FilterProjection":f=this.visit(a.children[0],c);if(!b(f))return null;e=[];g=[];for(d=0;d<f.length;d++){var l=this.visit(a.children[2],f[d]);k(l)||e.push(f[d])}for(d=0;d<e.length;d++)c=this.visit(a.children[1],e[d]),null!==c&&g.push(c);return g;case "Comparator":d=this.visit(a.children[0],c);c=this.visit(a.children[1],c);switch(a.name){case "EQ":e=t(d,c);break;case "NE":e=!t(d,c);break;case "GT":e=d>c;break;case "GTE":e=d>=c;break;case "LT":e=d<c;break;case "LTE":e=
d<=c;break;default:throw Error("Unknown comparator: "+a.name);}return e;case "Flatten":a=this.visit(a.children[0],c);if(!b(a))return null;e=[];for(d=0;d<a.length;d++)c=a[d],b(c)?e.push.apply(e,c):e.push(c);return e;case "Identity":return c;case "MultiSelectList":if(null===c)return null;e=[];for(d=0;d<a.children.length;d++)e.push(this.visit(a.children[d],c));return e;case "MultiSelectHash":if(null===c)return null;e={};for(d=0;d<a.children.length;d++)f=a.children[d],e[f.name]=this.visit(f.value,c);
return e;case "OrExpression":return l=this.visit(a.children[0],c),k(l)&&(l=this.visit(a.children[1],c)),l;case "AndExpression":return d=this.visit(a.children[0],c),!0===k(d)?d:this.visit(a.children[1],c);case "NotExpression":return d=this.visit(a.children[0],c),k(d);case "Literal":return a.value;case "Pipe":return d=this.visit(a.children[0],c),this.visit(a.children[1],d);case "Current":return c;case "Function":e=[];for(d=0;d<a.children.length;d++)e.push(this.visit(a.children[d],c));return this.runtime.callFunction(a.name,
e);case "ExpressionReference":return a=a.children[0],a.jmespathType="Expref",a;default:throw Error("Unknown node type: "+a.type);}},computeSliceParams:function(a,b){var c=b[0],d=b[1];b=b[2];var e=[null,null,null];if(null===b)b=1;else if(0===b)throw a=Error("Invalid slice, step cannot be 0"),a.name="RuntimeError",a;var f=0>b?!0:!1;c=null===c?f?a-1:0:this.capSliceRange(a,c,b);d=null===d?f?-1:a:this.capSliceRange(a,d,b);e[0]=c;e[1]=d;e[2]=b;return e},capSliceRange:function(a,b,c){0>b?(b+=a,0>b&&(b=0>
c?-1:0)):b>=a&&(b=0>c?a-1:a);return b}};f.prototype={callFunction:function(a,b){var c=this.functionTable[a];if(void 0===c)throw Error("Unknown function: "+a+"()");this._validateArgs(a,b,c._signature);return c._func.call(this,b)},_validateArgs:function(a,b,c){if(c[c.length-1].variadic){if(b.length<c.length){var d=1===c.length?" argument":" arguments";throw Error("ArgumentError: "+a+"() takes at least"+c.length+d+" but received "+b.length);}}else if(b.length!==c.length)throw d=1===c.length?" argument":
" arguments",Error("ArgumentError: "+a+"() takes "+c.length+d+" but received "+b.length);for(var e,f,g=0;g<c.length;g++){f=!1;d=c[g].types;e=this._getTypeName(b[g]);for(var l=0;l<d.length;l++)if(this._typeMatches(e,d[l],b[g])){f=!0;break}if(!f)throw Error("TypeError: "+a+"() expected argument "+(g+1)+" to be type "+d+" but received type "+e+" instead.");}},_typeMatches:function(a,b,c){if(1===b)return!0;if(9===b||8===b||3===b){if(3===b)return 3===a;if(3===a){var d;8===b?d=0:9===b&&(d=2);for(a=0;a<
c.length;a++)if(!this._typeMatches(this._getTypeName(c[a]),d,c[a]))return!1;return!0}}else return a===b},_getTypeName:function(a){switch(Object.prototype.toString.call(a)){case "[object String]":return 2;case "[object Number]":return 0;case "[object Array]":return 3;case "[object Boolean]":return 5;case "[object Null]":return 7;case "[object Object]":return"Expref"===a.jmespathType?6:4}},_functionStartsWith:function(a){return 0===a[0].lastIndexOf(a[1])},_functionEndsWith:function(a){var b=a[0];a=
a[1];return-1!==b.indexOf(a,b.length-a.length)},_functionReverse:function(a){if(2===this._getTypeName(a[0])){a=a[0];for(var b="",c=a.length-1;0<=c;c--)b+=a[c];return b}a=a[0].slice(0);a.reverse();return a},_functionAbs:function(a){return Math.abs(a[0])},_functionCeil:function(a){return Math.ceil(a[0])},_functionAvg:function(a){var b=0;a=a[0];for(var c=0;c<a.length;c++)b+=a[c];return b/a.length},_functionContains:function(a){return 0<=a[0].indexOf(a[1])},_functionFloor:function(a){return Math.floor(a[0])},
_functionLength:function(a){return h(a[0])?Object.keys(a[0]).length:a[0].length},_functionMap:function(a){var b=[],c=this._interpreter,d=a[0];a=a[1];for(var e=0;e<a.length;e++)b.push(c.visit(d,a[e]));return b},_functionMerge:function(a){for(var b={},c=0;c<a.length;c++){var d=a[c],e;for(e in d)b[e]=d[e]}return b},_functionMax:function(a){if(0<a[0].length){if(0===this._getTypeName(a[0][0]))return Math.max.apply(Math,a[0]);a=a[0];for(var b=a[0],c=1;c<a.length;c++)0>b.localeCompare(a[c])&&(b=a[c]);return b}return null},
_functionMin:function(a){if(0<a[0].length){if(0===this._getTypeName(a[0][0]))return Math.min.apply(Math,a[0]);a=a[0];for(var b=a[0],c=1;c<a.length;c++)0>a[c].localeCompare(b)&&(b=a[c]);return b}return null},_functionSum:function(a){var b=0;a=a[0];for(var c=0;c<a.length;c++)b+=a[c];return b},_functionType:function(a){switch(this._getTypeName(a[0])){case 0:return"number";case 2:return"string";case 3:return"array";case 4:return"object";case 5:return"boolean";case 6:return"expref";case 7:return"null"}},
_functionKeys:function(a){return Object.keys(a[0])},_functionValues:function(a){a=a[0];for(var b=Object.keys(a),c=[],d=0;d<b.length;d++)c.push(a[b[d]]);return c},_functionJoin:function(a){return a[1].join(a[0])},_functionToArray:function(a){return 3===this._getTypeName(a[0])?a[0]:[a[0]]},_functionToString:function(a){return 2===this._getTypeName(a[0])?a[0]:JSON.stringify(a[0])},_functionToNumber:function(a){var b=this._getTypeName(a[0]);return 0===b?a[0]:2!==b||(a=+a[0],isNaN(a))?null:a},_functionNotNull:function(a){for(var b=
0;b<a.length;b++)if(7!==this._getTypeName(a[b]))return a[b];return null},_functionSort:function(a){a=a[0].slice(0);a.sort();return a},_functionSortBy:function(a){var b=a[0].slice(0);if(0===b.length)return b;var c=this._interpreter,d=a[1],e=this._getTypeName(c.visit(d,b[0]));if(0>[0,2].indexOf(e))throw Error("TypeError");var f=this;a=[];for(var g=0;g<b.length;g++)a.push([g,b[g]]);a.sort(function(a,b){var g=c.visit(d,a[1]),l=c.visit(d,b[1]);if(f._getTypeName(g)!==e)throw Error("TypeError: expected "+
e+", received "+f._getTypeName(g));if(f._getTypeName(l)!==e)throw Error("TypeError: expected "+e+", received "+f._getTypeName(l));return g>l?1:g<l?-1:a[0]-b[0]});for(g=0;g<a.length;g++)b[g]=a[g][1];return b},_functionMaxBy:function(a){var b=a[0];a=this.createKeyFunction(a[1],[0,2]);for(var c=-Infinity,d,e,f=0;f<b.length;f++)e=a(b[f]),e>c&&(c=e,d=b[f]);return d},_functionMinBy:function(a){var b=a[0];a=this.createKeyFunction(a[1],[0,2]);for(var c=Infinity,d,e,f=0;f<b.length;f++)e=a(b[f]),e<c&&(c=e,
d=b[f]);return d},createKeyFunction:function(a,b){var c=this,d=this._interpreter;return function(e){e=d.visit(a,e);if(0>b.indexOf(c._getTypeName(e)))throw e="TypeError: expected one of "+b+", received "+c._getTypeName(e),Error(e);return e}}};e.tokenize=function(a){return(new d).tokenize(a)};e.compile=function(b){return(new a).parse(b)};e.search=function(b,d){var e=new a,g=new f,l=new c(g);g._interpreter=l;d=e.parse(d);return l.search(d,b)};e.strictDeepEqual=t})(e)},500:function(y){function e(b,r,
t,k,x,g,d,a,c,f){if(k&&"object"==typeof k&&!Array.isArray(k)){r(k,x,g,d,a,c,f);for(var w in k){var m=k[w];if(Array.isArray(m)){if(w in h.arrayKeywords)for(var p=0;p<m.length;p++)e(b,r,t,m[p],x+"/"+w+"/"+p,g,x,w,k,p)}else if(w in h.propsKeywords){if(m&&"object"==typeof m)for(var l in m)e(b,r,t,m[l],x+"/"+w+"/"+l.replace(/~/g,"~0").replace(/\//g,"~1"),g,x,w,k,l)}else(w in h.keywords||b.allKeys&&!(w in h.skipKeywords))&&e(b,r,t,m,x+"/"+w,g,x,w,k)}t(k,x,g,d,a,c,f)}}var h=y.exports=function(b,h,t){"function"==
typeof h&&(t=h,h={});t=h.cb||t;e(h,"function"==typeof t?t:t.pre||function(){},t.post||function(){},b,"",b)};h.keywords={additionalItems:!0,items:!0,contains:!0,additionalProperties:!0,propertyNames:!0,not:!0};h.arrayKeywords={items:!0,allOf:!0,anyOf:!0,oneOf:!0};h.propsKeywords={definitions:!0,properties:!0,patternProperties:!0,dependencies:!0};h.skipKeywords={default:!0,enum:!0,const:!0,required:!0,maximum:!0,minimum:!0,exclusiveMaximum:!0,exclusiveMinimum:!0,multipleOf:!0,maxLength:!0,minLength:!0,
pattern:!0,format:!0,maxItems:!0,minItems:!0,uniqueItems:!0,maxProperties:!0,minProperties:!0}},7026:function(y,e){function h(a){return 0<=x.indexOf(typeof a)}function b(b){b=b.replace(g,"\\$&").replace(a,"\\f").replace(d,"\\b").replace(c,"\\n").replace(f,"\\r").replace(w,"\\t");return'"'+b+'"'}function r(a){return a.replace(m,"~0").replace(p,"~1")}var t={b:"\b",f:"\f",n:"\n",r:"\r",t:"\t",'"':'"',"/":"/","\\":"\\"},k="a".charCodeAt();e.parse=function(a,b,c){function d(b,c){e();h(b,"value",p());var k=
l();switch(k){case "t":g("rue");var n=!0;break;case "f":g("alse");n=!1;break;case "n":g("ull");n=null;break;case '"':n=f();break;case "[":e();n=[];k=0;if("]"!=l())for(C--,I--;;){n.push(d(b+"/"+k));e();var q=l();if("]"==q)break;","!=q&&v();e();k++}break;case "{":e();n={};if("}"!=l())for(C--,I--;;){k=p();'"'!=l()&&v();q=f();var t=b+"/"+r(q);h(t,"key",k);h(t,"keyEnd",p());e();":"!=l()&&v();e();n[q]=d(t);e();k=l();if("}"==k)break;","!=k&&v();e()}break;default:if(C--,I--,0<="-0123456789".indexOf(k)){n=
"";k=!0;"-"==a[C]&&(n+=l());n+="0"==a[C]?l():m();"."==a[C]&&(n+=l()+m(),k=!1);if("e"==a[C]||"E"==a[C]){n+=l();if("+"==a[C]||"-"==a[C])n+=l();n+=m();k=!1}q=+n;n=L&&k&&(q>Number.MAX_SAFE_INTEGER||q<Number.MIN_SAFE_INTEGER)?BigInt(n):q}else u()}h(b,"valueEnd",p());e();c&&C<a.length&&u();return n}function e(){a:for(;C<a.length;){switch(a[C]){case " ":I++;break;case "\t":I+=4;break;case "\r":I=0;break;case "\n":I=0;y++;break;default:break a}C++}}function f(){for(var a="",b;b=l(),'"'!=b;)if("\\"==b)if(b=
l(),b in t)a+=t[b];else if("u"==b){b=4;for(var c=0;b--;){c<<=4;var d=l().toLowerCase();"a"<=d&&"f">=d?c+=d.charCodeAt()-k+10:"0"<=d&&"9">=d?c+=+d:v()}b=String.fromCharCode(c);a+=b}else v();else a+=b;return a}function g(a){for(var b=0;b<a.length;b++)l()!==a[b]&&v()}function l(){w();var b=a[C];C++;I++;return b}function m(){for(var b="";"0"<=a[C]&&"9">=a[C];)b+=l();if(b.length)return b;w();u()}function h(a,b,c){x[a]=x[a]||{};x[a][b]=c}function p(){return{line:y,column:I,pos:C}}function u(){throw new SyntaxError("Unexpected token "+
a[C]+" in JSON at position "+C);}function v(){C--;I--;u()}function w(){if(C>=a.length)throw new SyntaxError("Unexpected end of JSON input");}var x={},y=0,I=0,C=0,L=c&&c.bigint&&"undefined"!=typeof BigInt;return{data:d("",!0),pointers:x}};e.stringify=function(a,c,d){function e(a,c,d){function m(){if(a.length){f("[");for(var b=c+1,l=0;l<a.length;l++){l&&f(",");g(b);var m=h(a[l])?a[l]:null;e(m,b,d+"/"+l)}g(c);f("]")}else f("[]")}function k(){var m=Object.keys(a);if(m.length){f("{");for(var k=c+1,n=0;n<
m.length;n++){var q=m[n],u=a[q];if(h(u)){n&&f(",");var t=d+"/"+r(q);g(k);l(t,"key");f(b(q));l(t,"keyEnd");f(":");p&&f(" ");e(u,k,t)}}g(c);f("}")}else f("{}")}function n(m){if(a.size){f("{");for(var k=c+1,n=!0,q=a.entries(),u=q.next();!u.done;){var t=u.value;u=t[0];t=m?!0:t[1];if(h(t)){n||f(",");n=!1;var v=d+"/"+r(u);g(k);l(v,"key");f(b(u));l(v,"keyEnd");f(":");p&&f(" ");e(t,k,v)}u=q.next()}g(c);f("}")}else f("{}")}l(d,"value");switch(typeof a){case "number":case "bigint":case "boolean":f(""+a);break;
case "string":f(b(a));break;case "object":null===a?f("null"):"function"==typeof a.toJSON?f(b(a.toJSON())):Array.isArray(a)?m():I?a.constructor.BYTES_PER_ELEMENT?m():a instanceof Map?n():a instanceof Set?n(!0):k():k()}l(d,"valueEnd")}function f(a){x+=a.length;y+=a.length;t+=a}function g(a){if(p){t+="\n"+Array(a+1).join(p);w++;for(x=0;a--;)m?(w+=m,x=u):x+=u,y+=k;y+=1}}function l(a,b){v[a]=v[a]||{};v[a][b]={line:w,column:x,pos:y}}if(h(a)){var m=0,k,p="object"==typeof d?d.space:d;switch(typeof p){case "number":p=
(c=10<p?10:0>p?0:Math.floor(p))&&Array(c+1).join(" ");var u=k=c;break;case "string":p=p.slice(0,10);for(c=u=k=0;c<p.length;c++){switch(p[c]){case " ":u++;break;case "\t":u+=4;break;case "\r":u=0;break;case "\n":u=0;m++;break;default:throw Error("whitespace characters not allowed in JSON");}k++}break;default:p=void 0}var t="",v={},w=0,x=0,y=0,I=d&&d.es6&&"function"==typeof Map;e(a,0,"");return{json:t,pointers:v}}};var x=["number","bigint","boolean","string","object"],g=/"|\\/g,d=/[\b]/g,a=/\f/g,c=
/\n/g,f=/\r/g,w=/\t/g,m=/~/g,p=/\//g},5755:function(y,e){function h(b,e){if(!(this instanceof h))throw new SyntaxError("Constructor must be called with the new operator");this.message=b+" (char "+e+")";this.char=e;this.stack=Error().stack}Object.defineProperty(e,"__esModule",{value:!0});e.default=h;h.prototype=Error();h.prototype.constructor=Error},8909:function(y,e,h){y.exports=h(8107).default},8107:function(y,e,h){function b(){H++;E=K.charAt(H)}function r(){b();"\\"===E&&b()}function t(){return F===
c&&("["===D||"{"===D)||F===w||F===f||F===m}function k(){z+=D;F=u;D="";if(v[E])F=c,D=E,b();else if((0,a.isDigit)(E)||"-"===E){F=f;if("-"===E){if(D+=E,b(),!(0,a.isDigit)(E))throw new d.default("Invalid number, digit expected",H);}else"0"===E&&(D+=E,b());for(;(0,a.isDigit)(E);)D+=E,b();if("."===E){D+=E;b();if(!(0,a.isDigit)(E))throw new d.default("Invalid number, digit expected",H);for(;(0,a.isDigit)(E);)D+=E,b()}if("e"===E||"E"===E){D+=E;b();if("+"===E||"-"===E)D+=E,b();if(!(0,a.isDigit)(E))throw new d.default("Invalid number, digit expected",
H);for(;(0,a.isDigit)(E);)D+=E,b()}}else"\\"===E&&'"'===K.charAt(H+1)?(b(),x(r)):x(b);F===p&&(D=(0,a.normalizeWhitespace)(D),k());F===l&&(F=u,D="",k())}function x(c){if((0,a.isQuote)(E)){var e=(0,a.normalizeQuote)(E),f=(0,a.isSingleQuote)(E)?a.isSingleQuote:a.isDoubleQuote;D+='"';F=w;for(c();""!==E&&!f(E);)if("\\"===E)if(c(),void 0!==A[E])D+="\\"+E,c();else if("u"===E){D+="\\u";c();for(var g=0;4>g;g++){if(!(0,a.isHex)(E))throw new d.default("Invalid unicode character",H-D.length);D+=E;c()}}else if("'"===
E)D+="'",c();else throw new d.default('Invalid escape character "\\'+E+'"',H);else D=q[E]?D+q[E]:'"'===E?D+'\\"':D+E,c();if((0,a.normalizeQuote)(E)!==e)throw new d.default("End of string expected",H-D.length);D+='"';c()}else if((0,a.isAlpha)(E))for(F=m;(0,a.isAlpha)(E)||(0,a.isDigit)(E)||"$"===E;)D+=E,b();else if((0,a.isWhitespace)(E)||(0,a.isSpecialWhitespace)(E))for(F=p;(0,a.isWhitespace)(E)||(0,a.isSpecialWhitespace)(E);)D+=E,b();else if("/"===E&&"*"===K[H+1]){for(F=l;""!==E&&("*"!==E||"*"===E&&
"/"!==K[H+1]);)D+=E,b();"*"===E&&"/"===K[H+1]&&(D+=E,b(),D+=E,b())}else if("/"===E&&"/"===K[H+1])for(F=l;""!==E&&"\n"!==E;)D+=E,b();else{for(F=u;""!==E;)D+=E,b();throw new d.default('Syntax error in part "'+D+'"',H-D.length);}}function g(){if(F===c&&"{"===D)if(k(),F===c&&"}"===D)k();else{for(;;){if(F===m||F===f)F=w,D='"'.concat(D,'"');if(F!==w)throw new d.default("Object key expected",H-D.length);k();if(F===c&&":"===D)k();else if(t())z=(0,a.insertBeforeLastWhitespace)(z,":");else throw new d.default("Colon expected",
H-D.length);g();if(F===c&&","===D){if(k(),F===c&&"}"===D){z=(0,a.stripLastOccurrence)(z,",");break}}else if(F===w||F===f||F===m)z=(0,a.insertBeforeLastWhitespace)(z,",");else break}F===c&&"}"===D?k():z=(0,a.insertBeforeLastWhitespace)(z,"}")}else if(F===c&&"["===D)if(k(),F===c&&"]"===D)k();else{for(;;)if(g(),F===c&&","===D){if(k(),F===c&&"]"===D){z=(0,a.stripLastOccurrence)(z,",");break}}else if(t())z=(0,a.insertBeforeLastWhitespace)(z,",");else break;F===c&&"]"===D?k():z=(0,a.insertBeforeLastWhitespace)(z,
"]")}else if(F===w)for(k();F===c&&"+"===D;){if(D="",k(),F===w){var b=z.lastIndexOf('"');z=z.substring(0,b)+D.substring(1);D="";k()}}else if(F===f)k();else if(F===m)if(n[D])k();else if(J[D])D=J[D],k();else{b=D;var e=z.length;D="";k();if(F===c&&"("===D)D="",k(),g(),F===c&&")"===D&&(D="",k(),F===c&&";"===D&&(D="",k()));else{for(z=(0,a.insertAtIndex)(z,'"'.concat(b),e);F===m||F===f;)k();z+='"'}}else{if(""===D)throw new d.default("Unexpected end of json string",H-D.length);throw new d.default("Value expected",
H-D.length);}}e.default=function(b){K=b;z="";H=0;E=K.charAt(0);D="";F=u;k();b=F===c&&"{"===D;g();if(""===D)return z;if(b&&t()){for(b="";t();)z=(0,a.insertBeforeLastWhitespace)(z,","),b+=z,z="",g();return"[\n".concat(b).concat(z,"\n]")}throw new d.default("Unexpected characters",H-D.length);};var d=function(a){return a&&a.__esModule?a:{default:a}}(h(5755)),a=h(1536),c=0,f=1,w=2,m=3,p=4,l=5,u=6,v={"":!0,"{":!0,"}":!0,"[":!0,"]":!0,":":!0,",":!0,"(":!0,")":!0,";":!0,"+":!0},A={'"':'"',"\\":"\\","/":"/",
b:"\b",f:"\f",n:"\n",r:"\r",t:"\t"},q={"\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"},n={null:"null",true:"true",false:"false"},J={None:"null",True:"true",False:"false"},K="",z="",H=0,E="",D="",F=u},1536:function(y,e){function h(b){return" "===b||"\t"===b||"\n"===b||"\r"===b}function b(b){return"\u00a0"===b||"\u2000"<=b&&"\u200a">=b||"\u202f"===b||"\u205f"===b||"\u3000"===b}Object.defineProperty(e,"__esModule",{value:!0});e.isAlpha=function(b){return k.test(b)};e.isHex=function(b){return x.test(b)};
e.isDigit=function(b){return g.test(b)};e.isWhitespace=h;e.isSpecialWhitespace=b;e.normalizeWhitespace=function(d){for(var a="",c=0;c<d.length;c++){var e=d[c];a+=b(e)?" ":e}return a};e.isQuote=function(b){return!0===r[b]||!0===t[b]};e.isSingleQuote=function(b){return!0===r[b]};e.isDoubleQuote=function(b){return!0===t[b]};e.normalizeQuote=function(b){return!0===r[b]?"'":!0===t[b]?'"':b};e.stripLastOccurrence=function(b,a){a=b.lastIndexOf(a);return-1!==a?b.substring(0,a)+b.substring(a+1):b};e.insertBeforeLastWhitespace=
function(b,a){var c=b.length;if(!h(b[c-1]))return b+a;for(;h(b[c-1]);)c--;return b.substring(0,c)+a+b.substring(c)};e.insertAtIndex=function(b,a,c){return b.substring(0,c)+a+b.substring(c)};var r={"'":!0,"\u2018":!0,"\u2019":!0,"`":!0,"\u00b4":!0},t={'"':!0,"\u201c":!0,"\u201d":!0},k=/^[a-zA-Z_]$/,x=/^[0-9a-fA-F]$/,g=/^[0-9]$/},483:function(y,e){var h,b,r;(function(t,k){!(b=[],h=k,r="function"===typeof h?h.apply(e,b):h,void 0!==r&&(y.exports=r))})(this,function(){function b(a){return"object"===typeof Node?
a instanceof Node:a&&"object"===typeof a&&"number"===typeof a.nodeType}function e(){var a=[];return{watch:a.push.bind(a),trigger:function(b,c){var d=!0;c={detail:c,preventDefault:function(){d=!1}};for(var e=0;e<a.length;e++)a[e](b,c);return d}}}function h(a){this.elem=a}function g(a,b){return h.make(a("parent")).clazz("pico-overlay").clazz(a("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1E4}).stylize(a("overlayStyles",{opacity:.5,
background:"#000"})).onClick(function(){a("overlayClose",!0)&&b()})}function d(a,b){var c=a("width","auto");"number"===typeof c&&(c=""+c+"px");var d=a("modalId","pico-"+r++);return h.make(a("parent")).clazz("pico-content").clazz(a("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:c,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)",
"-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(a("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(a("content")).attr("id",d).attr("role","dialog").attr("aria-labelledby",a("ariaLabelledBy")).attr("aria-describedby",a("ariaDescribedBy",d)).onClick(function(a){(new h(a.target)).anyAncestor(function(a){return/\bpico-close\b/.test(a.elem.className)})&&b()})}function a(a){return function(){return a().elem}}function c(a,
b){function c(a){return"none"===window.getComputedStyle(a).display||(a.msMatchesSelector||a.webkitMatchesSelector||a.matches).call(a,":disabled")||a.hasAttribute("contenteditable")?!1:a.hasAttribute("tabindex")||(a.msMatchesSelector||a.webkitMatchesSelector||a.matches).call(a,"input,select,textarea,button,a[href],area[href],iframe")}function d(a){a=a.getElementsByTagName("*");for(var b=0;b<a.length;b++)if(c(a[b]))return a[b]}var e;a.beforeShow(function(){e=document.activeElement});a.afterShow(function(){if(b()){var c=
d(a.modalElem());c&&c.focus()}});a.afterClose(function(){b()&&e&&e.focus();e=null});p.watch(function(e){if(b()&&a.isVisible()){var f=d(a.modalElem());a:{var g=a.modalElem().getElementsByTagName("*");for(var l=g.length;l--;)if(c(g[l])){g=g[l];break a}g=void 0}(e.shiftKey?f:g)===document.activeElement&&((e.shiftKey?g:f).focus(),e.preventDefault())}})}function f(a,b){var c,d=new h(document.body);a.beforeShow(function(){c=d.elem.style.overflow;b()&&d.stylize({overflow:"hidden"})});a.afterClose(function(){d.stylize({overflow:c})})}
h.make=function(a,b){"string"===typeof a&&(a=document.querySelector(a));b=document.createElement(b||"div");(a||document.body).appendChild(b);return new h(b)};h.prototype={child:function(a){return h.make(this.elem,a)},stylize:function(a){a=a||{};"undefined"!==typeof a.opacity&&(a.filter="alpha(opacity="+100*a.opacity+")");for(var b in a)a.hasOwnProperty(b)&&(this.elem.style[b]=a[b]);return this},clazz:function(a){this.elem.className+=" "+a;return this},html:function(a){b(a)?this.elem.appendChild(a):
this.elem.innerHTML=a;return this},onClick:function(a){this.elem.addEventListener("click",a);return this},destroy:function(){this.elem.parentNode.removeChild(this.elem)},hide:function(){this.elem.style.display="none"},show:function(){this.elem.style.display="block"},attr:function(a,b){void 0!==b&&this.elem.setAttribute(a,b);return this},anyAncestor:function(a){for(var b=this.elem;b;){if(a(new h(b)))return!0;b=b.parentNode}return!1},isVisible:function(){return"none"!==window.getComputedStyle(this.elem).display}};
var r=1,m=e(),p=e();document.documentElement.addEventListener("keydown",function(a){var b=a.which||a.keyCode;27===b?m.trigger():9===b&&p.trigger(a)});return function(l){function k(a,b){a=l[a];"function"===typeof a&&(a=a(b));return void 0===a?b:a}function h(a){F().hide();D().hide();E.trigger(M,a)}function p(a){y.trigger(M,a)&&h(a)}function r(a){return function(){a.apply(this,arguments);return M}}function n(a,b){if(!G){var c=d(k,p),e=g(k,p);var f=k("closeButton",!0)?c.child("button").html(k("closeHtml",
"&#xD7;")).clazz("pico-close").clazz(k("closeClass","")).stylize(k("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",k("close-label","Close")):void 0;G={modal:c,overlay:e,close:f};t.trigger(M,b)}return G[a]}if("string"===typeof l||b(l))l={content:l};var t=e(),w=e(),x=e(),y=e(),E=e(),D=n.bind(window,"modal"),F=n.bind(window,
"overlay"),B=n.bind(window,"close"),G;var M={modalElem:a(D),closeElem:a(B),overlayElem:a(F),buildDom:r(n.bind(null,null)),isVisible:function(){return!!(G&&D&&D().isVisible())},show:function(a){w.trigger(M,a)&&(F().show(),B(),D().show(),x.trigger(M,a));return this},close:r(p),forceClose:r(h),destroy:function(){D().destroy();F().destroy();F=D=B=void 0},options:function(a){Object.keys(a).map(function(b){l[b]=a[b]})},afterCreate:r(t.watch),beforeShow:r(w.watch),afterShow:r(x.watch),beforeClose:r(y.watch),
afterClose:r(E.watch)};c(M,k.bind(null,"focus",!0));f(M,k.bind(null,"bodyOverflow",!0));m.watch(function(){k("escCloses",!0)&&M.isVisible()&&M.close()});return M}})},7533:function(y,e){(function(h,b){b(e)})(this,function(e){function b(){for(var a=arguments.length,b=Array(a),c=0;c<a;c++)b[c]=arguments[c];if(1<b.length){b[0]=b[0].slice(0,-1);a=b.length-1;for(c=1;c<a;++c)b[c]=b[c].slice(1,-1);b[a]=b[a].slice(1);return b.join("")}return b[0]}function h(a){return"(?:"+a+")"}function t(a){return void 0===
a?"undefined":null===a?"null":Object.prototype.toString.call(a).split(" ").pop().split("]").shift().toLowerCase()}function k(a){return a.toUpperCase()}function x(a){var c=b("[0-9]","[A-Fa-f]"),d=h(h("%[EFef]"+c+"%"+c+c+"%"+c+c)+"|"+h("%[89A-Fa-f]"+c+"%"+c+c)+"|"+h("%"+c+c)),e=b("[\\:\\/\\?\\#\\[\\]\\@]","[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]"),f=a?"[\\uE000-\\uF8FF]":"[]";a=b("[A-Za-z]","[0-9]","[\\-\\.\\_\\~]",a?"[\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]":"[]");var g=
h("[A-Za-z]"+b("[A-Za-z]","[0-9]","[\\+\\-\\.]")+"*"),l=h(h(d+"|"+b(a,"[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]","[\\:]"))+"*");h(h("25[0-5]")+"|"+h("2[0-4][0-9]")+"|"+h("1[0-9][0-9]")+"|"+h("[1-9][0-9]")+"|[0-9]");var m=h(h("25[0-5]")+"|"+h("2[0-4][0-9]")+"|"+h("1[0-9][0-9]")+"|"+h("0?[1-9][0-9]")+"|0?0?[0-9]");m=h(m+"\\."+m+"\\."+m+"\\."+m);var k=h(c+"{1,4}"),p=h(h(k+"\\:"+k)+"|"+m),n=h(h(k+"\\:")+"{6}"+p),q=h("\\:\\:"+h(k+"\\:")+"{5}"+p),r=h(h(k)+"?\\:\\:"+h(k+"\\:")+"{4}"+p),u=h(h(h(k+"\\:")+"{0,1}"+
k)+"?\\:\\:"+h(k+"\\:")+"{3}"+p),t=h(h(h(k+"\\:")+"{0,2}"+k)+"?\\:\\:"+h(k+"\\:")+"{2}"+p),v=h(h(h(k+"\\:")+"{0,3}"+k)+"?\\:\\:"+k+"\\:"+p);p=h(h(h(k+"\\:")+"{0,4}"+k)+"?\\:\\:"+p);var w=h(h(h(k+"\\:")+"{0,5}"+k)+"?\\:\\:"+k);k=h(h(h(k+"\\:")+"{0,6}"+k)+"?\\:\\:");n=h([n,q,r,u,t,v,p,w,k].join("|"));q=h(h(a+"|"+d)+"+");h(n+"\\%25"+q);r=h(n+h("\\%25|\\%(?!"+c+"{2})")+q);u=h("[vV]"+c+"+\\."+b(a,"[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]","[\\:]")+"+");r=h("\\["+h(r+"|"+n+"|"+u)+"\\]");u=h(h(d+"|"+b(a,"[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]"))+
"*");r=h(r+"|"+m+"(?!"+u+")|"+u);u=h("[0-9]*");k=h(h(l+"@")+"?"+r+h("\\:"+u)+"?");var x=h(d+"|"+b(a,"[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]","[\\:\\@]"));t=h(x+"*");w=h(x+"+");p=h(h(d+"|"+b(a,"[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]","[\\@]"))+"+");t=h(h("\\/"+t)+"*");v=h("\\/"+h(w+t)+"?");p=h(p+t);w=h(w+t);var y="(?!"+x+")";h(t+"|"+v+"|"+p+"|"+w+"|"+y);var ja=h(h(x+"|"+b("[\\/\\?]",f))+"*");x=h(h(x+"|[\\/\\?]")+"*");var z=h(h("\\/\\/"+k+t)+"|"+v+"|"+w+"|"+y),A=h(g+"\\:"+z+h("\\?"+ja)+"?"+h("\\#"+x)+"?");
k=h(h("\\/\\/"+k+t)+"|"+v+"|"+p+"|"+y);k=h(k+h("\\?"+ja)+"?"+h("\\#"+x)+"?");h(A+"|"+k);h(g+"\\:"+z+h("\\?"+ja)+"?");h(h("\\/\\/("+h("("+l+")@")+"?("+r+")"+h("\\:("+u+")")+"?)")+"?("+t+"|"+v+"|"+w+"|"+y+")");h("\\?("+ja+")");h("\\#("+x+")");h(h("\\/\\/("+h("("+l+")@")+"?("+r+")"+h("\\:("+u+")")+"?)")+"?("+t+"|"+v+"|"+p+"|"+y+")");h("\\?("+ja+")");h("\\#("+x+")");h(h("\\/\\/("+h("("+l+")@")+"?("+r+")"+h("\\:("+u+")")+"?)")+"?("+t+"|"+v+"|"+w+"|"+y+")");h("\\?("+ja+")");h("\\#("+x+")");h("("+l+")@");
h("\\:("+u+")");return{NOT_SCHEME:new RegExp(b("[^]","[A-Za-z]","[0-9]","[\\+\\-\\.]"),"g"),NOT_USERINFO:new RegExp(b("[^\\%\\:]",a,"[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]"),"g"),NOT_HOST:new RegExp(b("[^\\%\\[\\]\\:]",a,"[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]"),"g"),NOT_PATH:new RegExp(b("[^\\%\\/\\:\\@]",a,"[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]"),"g"),NOT_PATH_NOSCHEME:new RegExp(b("[^\\%\\/\\@]",a,"[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]"),"g"),NOT_QUERY:new RegExp(b("[^\\%]",a,"[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]",
"[\\:\\@\\/\\?]",f),"g"),NOT_FRAGMENT:new RegExp(b("[^\\%]",a,"[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]","[\\:\\@\\/\\?]"),"g"),ESCAPE:new RegExp(b("[^]",a,"[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]"),"g"),UNRESERVED:new RegExp(a,"g"),OTHER_CHARS:new RegExp(b("[^\\%]",a,e),"g"),PCT_ENCODED:new RegExp(d,"g"),IPV4ADDRESS:new RegExp("^("+m+")$"),IPV6ADDRESS:new RegExp("^\\[?("+n+")"+h(h("\\%25|\\%(?!"+c+"{2})")+"("+q+")")+"?\\]?$")}}function g(a){throw new RangeError(I[a]);}function d(a,b){var c=a.split("@"),d=
"";1<c.length&&(d=c[0]+"@",a=c[1]);a=a.replace(M,".");a=a.split(".");c=[];for(var e=a.length;e--;)c[e]=b(a[e]);b=c.join(".");return d+b}function a(a){for(var b=[],c=0,d=a.length;c<d;){var e=a.charCodeAt(c++);if(55296<=e&&56319>=e&&c<d){var f=a.charCodeAt(c++);56320==(f&64512)?b.push(((e&1023)<<10)+(f&1023)+65536):(b.push(e),c--)}else b.push(e)}return b}function c(a){a=a.charCodeAt(0);return 16>a?"%0"+a.toString(16).toUpperCase():128>a?"%"+a.toString(16).toUpperCase():2048>a?"%"+(a>>6|192).toString(16).toUpperCase()+
"%"+(a&63|128).toString(16).toUpperCase():"%"+(a>>12|224).toString(16).toUpperCase()+"%"+(a>>6&63|128).toString(16).toUpperCase()+"%"+(a&63|128).toString(16).toUpperCase()}function f(a){for(var b="",c=0,d=a.length;c<d;){var e=parseInt(a.substr(c+1,2),16);if(128>e)b+=String.fromCharCode(e),c+=3;else if(194<=e&&224>e){if(6<=d-c){var f=parseInt(a.substr(c+4,2),16);b+=String.fromCharCode((e&31)<<6|f&63)}else b+=a.substr(c,6);c+=6}else if(224<=e){if(9<=d-c){f=parseInt(a.substr(c+4,2),16);var g=parseInt(a.substr(c+
7,2),16);b+=String.fromCharCode((e&15)<<12|(f&63)<<6|g&63)}else b+=a.substr(c,9);c+=9}else b+=a.substr(c,3),c+=3}return b}function w(a,b){function d(a){var c=f(a);return c.match(b.UNRESERVED)?c:a}a.scheme&&(a.scheme=String(a.scheme).replace(b.PCT_ENCODED,d).toLowerCase().replace(b.NOT_SCHEME,""));void 0!==a.userinfo&&(a.userinfo=String(a.userinfo).replace(b.PCT_ENCODED,d).replace(b.NOT_USERINFO,c).replace(b.PCT_ENCODED,k));void 0!==a.host&&(a.host=String(a.host).replace(b.PCT_ENCODED,d).toLowerCase().replace(b.NOT_HOST,
c).replace(b.PCT_ENCODED,k));void 0!==a.path&&(a.path=String(a.path).replace(b.PCT_ENCODED,d).replace(a.scheme?b.NOT_PATH:b.NOT_PATH_NOSCHEME,c).replace(b.PCT_ENCODED,k));void 0!==a.query&&(a.query=String(a.query).replace(b.PCT_ENCODED,d).replace(b.NOT_QUERY,c).replace(b.PCT_ENCODED,k));void 0!==a.fragment&&(a.fragment=String(a.fragment).replace(b.PCT_ENCODED,d).replace(b.NOT_FRAGMENT,c).replace(b.PCT_ENCODED,k));return a}function m(a){return a.replace(/^0*(.*)/,"$1")||"0"}function p(a,b){b=a.match(b.IPV4ADDRESS)||
[];return(b=D(b,2)[1])?b.split(".").map(m).join("."):a}function l(a,b){var c=a.match(b.IPV6ADDRESS)||[];c=D(c,3);var d=c[1];c=c[2];if(d){a=d.toLowerCase().split("::").reverse();d=D(a,2);a=d[0];d=(d=d[1])?d.split(":").map(m):[];var e=a.split(":").map(m),f=b.IPV4ADDRESS.test(e[e.length-1]),g=f?7:8,l=e.length-g;a=Array(g);for(var h=0;h<g;++h)a[h]=d[h]||e[l+h]||"";f&&(a[g-1]=p(a[g-1],b));b=a.reduce(function(a,b,c){b&&"0"!==b||((b=a[a.length-1])&&b.index+b.length===c?b.length++:a.push({index:c,length:1}));
return a},[]).sort(function(a,b){return b.length-a.length})[0];d=void 0;b&&1<b.length?(d=a.slice(0,b.index),b=a.slice(b.index+b.length),d=d.join(":")+"::"+b.join(":")):d=a.join(":");c&&(d+="%"+c);return d}return a}function u(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},c={},d=!1!==b.iri?E:H;"suffix"===b.reference&&(a=(b.scheme?b.scheme+":":"")+"//"+a);var e=a.match(X);if(e){W?(c.scheme=e[1],c.userinfo=e[3],c.host=e[4],c.port=parseInt(e[5],10),c.path=e[6]||"",c.query=e[7],c.fragment=
e[8],isNaN(c.port)&&(c.port=e[5])):(c.scheme=e[1]||void 0,c.userinfo=-1!==a.indexOf("@")?e[3]:void 0,c.host=-1!==a.indexOf("//")?e[4]:void 0,c.port=parseInt(e[5],10),c.path=e[6]||"",c.query=-1!==a.indexOf("?")?e[7]:void 0,c.fragment=-1!==a.indexOf("#")?e[8]:void 0,isNaN(c.port)&&(c.port=a.match(/\/\/(?:.|\n)*:(?:\/|\?|#|$)/)?e[4]:void 0));c.host&&(c.host=l(p(c.host,d),d));c.reference=void 0!==c.scheme||void 0!==c.userinfo||void 0!==c.host||void 0!==c.port||c.path||void 0!==c.query?void 0===c.scheme?
"relative":void 0===c.fragment?"absolute":"uri":"same-document";b.reference&&"suffix"!==b.reference&&b.reference!==c.reference&&(c.error=c.error||"URI is not a "+b.reference+" reference.");e=P[(b.scheme||c.scheme||"").toLowerCase()];if(b.unicodeSupport||e&&e.unicodeSupport)w(c,d);else{if(c.host&&(b.domainHost||e&&e.domainHost))try{c.host=R.toASCII(c.host.replace(d.PCT_ENCODED,f).toLowerCase())}catch(ta){c.error=c.error||"Host's domain name can not be converted to ASCII via punycode: "+ta}w(c,H)}e&&
e.parse&&e.parse(c,b)}else c.error=c.error||"URI can not be parsed.";return c}function v(a,b){b=!1!==b.iri?E:H;var c=[];void 0!==a.userinfo&&(c.push(a.userinfo),c.push("@"));void 0!==a.host&&c.push(l(p(String(a.host),b),b).replace(b.IPV6ADDRESS,function(a,b,c){return"["+b+(c?"%25"+c:"")+"]"}));if("number"===typeof a.port||"string"===typeof a.port)c.push(":"),c.push(String(a.port));return c.length?c.join(""):void 0}function y(a){for(var b=[];a.length;)if(a.match(T))a=a.replace(T,"");else if(a.match(ba))a=
a.replace(ba,"/");else if(a.match(N))a=a.replace(N,"/"),b.pop();else if("."===a||".."===a)a="";else{var c=a.match(V);if(c)c=c[0],a=a.slice(c.length),b.push(c);else throw Error("Unexpected dot segment condition");}return b.join("")}function q(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},c=b.iri?E:H,d=[],e=P[(b.scheme||a.scheme||"").toLowerCase()];e&&e.serialize&&e.serialize(a,b);if(a.host&&!c.IPV6ADDRESS.test(a.host)&&(b.domainHost||e&&e.domainHost))try{a.host=b.iri?R.toUnicode(a.host):
R.toASCII(a.host.replace(c.PCT_ENCODED,f).toLowerCase())}catch(ea){a.error=a.error||"Host's domain name can not be converted to "+(b.iri?"Unicode":"ASCII")+" via punycode: "+ea}w(a,c);"suffix"!==b.reference&&a.scheme&&(d.push(a.scheme),d.push(":"));c=v(a,b);void 0!==c&&("suffix"!==b.reference&&d.push("//"),d.push(c),a.path&&"/"!==a.path.charAt(0)&&d.push("/"));if(void 0!==a.path){var g=a.path;b.absolutePath||e&&e.absolutePath||(g=y(g));void 0===c&&(g=g.replace(/^\/\//,"/%2F"));d.push(g)}void 0!==
a.query&&(d.push("?"),d.push(a.query));void 0!==a.fragment&&(d.push("#"),d.push(a.fragment));return d.join("")}function n(a,b){var c=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},d={};arguments[3]||(a=u(q(a,c),c),b=u(q(b,c),c));c=c||{};!c.tolerant&&b.scheme?(d.scheme=b.scheme,d.userinfo=b.userinfo,d.host=b.host,d.port=b.port,d.path=y(b.path||""),d.query=b.query):(void 0!==b.userinfo||void 0!==b.host||void 0!==b.port?(d.userinfo=b.userinfo,d.host=b.host,d.port=b.port,d.path=y(b.path||""),
d.query=b.query):(b.path?("/"===b.path.charAt(0)?d.path=y(b.path):(d.path=void 0===a.userinfo&&void 0===a.host&&void 0===a.port||a.path?a.path?a.path.slice(0,a.path.lastIndexOf("/")+1)+b.path:b.path:"/"+b.path,d.path=y(d.path)),d.query=b.query):(d.path=a.path,d.query=void 0!==b.query?b.query:a.query),d.userinfo=a.userinfo,d.host=a.host,d.port=a.port),d.scheme=a.scheme);d.fragment=b.fragment;return d}function J(a,b){return a&&a.toString().replace(b&&b.iri?E.PCT_ENCODED:H.PCT_ENCODED,f)}function K(a){return"boolean"===
typeof a.secure?a.secure:"wss"===String(a.scheme).toLowerCase()}function z(a){var b=f(a);return b.match(fa)?b:a}var H=x(!1),E=x(!0),D=function(){return function(a,b){if(Array.isArray(a))return a;if(Symbol.iterator in Object(a)){var c=[],d=!0,e=!1,f=void 0;try{for(var g=a[Symbol.iterator](),l;!(d=(l=g.next()).done)&&(c.push(l.value),!b||c.length!==b);d=!0);}catch(Ba){e=!0,f=Ba}finally{try{if(!d&&g["return"])g["return"]()}finally{if(e)throw f;}}return c}throw new TypeError("Invalid attempt to destructure non-iterable instance");
}}(),F=function(a){if(Array.isArray(a)){for(var b=0,c=Array(a.length);b<a.length;b++)c[b]=a[b];return c}return Array.from(a)},B=/^xn--/,G=/[^\0-\x7E]/,M=/[\x2E\u3002\uFF0E\uFF61]/g,I={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},C=Math.floor,L=String.fromCharCode,Q=function(a,b){return a+22+75*(26>a)-((0!=b)<<5)},S=function(a,b,c){var d=0;a=c?C(a/700):a>>1;for(a+=C(a/b);455<a;d+=36)a=C(a/35);
return C(d+36*a/(a+38))},O=function(a){var b=[],c=a.length,d=0,e=128,f=72,l=a.lastIndexOf("-");0>l&&(l=0);for(var h=0;h<l;++h)128<=a.charCodeAt(h)&&g("not-basic"),b.push(a.charCodeAt(h));for(l=0<l?l+1:0;l<c;){h=d;for(var k=1,m=36;;m+=36){l>=c&&g("invalid-input");var p=a.charCodeAt(l++);p=10>p-48?p-22:26>p-65?p-65:26>p-97?p-97:36;(36<=p||p>C((2147483647-d)/k))&&g("overflow");d+=p*k;var n=m<=f?1:m>=f+26?26:m-f;if(p<n)break;p=36-n;k>C(2147483647/p)&&g("overflow");k*=p}k=b.length+1;f=S(d-h,k,0==h);C(d/
k)>2147483647-e&&g("overflow");e+=C(d/k);d%=k;b.splice(d++,0,e)}return String.fromCodePoint.apply(String,b)},U=function(b){var c=[];b=a(b);var d=b.length,e=128,f=0,l=72,h=!0,k=!1,m=void 0;try{for(var p=b[Symbol.iterator](),n;!(h=(n=p.next()).done);h=!0){var q=n.value;128>q&&c.push(L(q))}}catch(oa){k=!0,m=oa}finally{try{!h&&p.return&&p.return()}finally{if(k)throw m;}}for((k=h=c.length)&&c.push("-");k<d;){p=2147483647;m=!0;n=!1;q=void 0;try{for(var r=b[Symbol.iterator](),u;!(m=(u=r.next()).done);m=
!0){var t=u.value;t>=e&&t<p&&(p=t)}}catch(oa){n=!0,q=oa}finally{try{!m&&r.return&&r.return()}finally{if(n)throw q;}}m=k+1;p-e>C((2147483647-f)/m)&&g("overflow");f+=(p-e)*m;e=p;p=!0;n=!1;q=void 0;try{for(var v=b[Symbol.iterator](),w;!(p=(w=v.next()).done);p=!0){var x=w.value;x<e&&2147483647<++f&&g("overflow");if(x==e){for(var y=f,z=36;;z+=36){var A=z<=l?1:z>=l+26?26:z-l;if(y<A)break;var B=y-A,D=36-A;c.push(L(Q(A+B%D,0)));y=C(B/D)}c.push(L(Q(y,0)));l=S(f,m,k==h);f=0;++k}}}catch(oa){n=!0,q=oa}finally{try{!p&&
v.return&&v.return()}finally{if(n)throw q;}}++f;++e}return c.join("")},R={version:"2.1.0",ucs2:{decode:a,encode:function(a){return String.fromCodePoint.apply(String,F(a))}},decode:O,encode:U,toASCII:function(a){return d(a,function(a){return G.test(a)?"xn--"+U(a):a})},toUnicode:function(a){return d(a,function(a){return B.test(a)?O(a.slice(4).toLowerCase()):a})}},P={},X=/^(?:([^:\/?#]+):)?(?:\/\/((?:([^\/?#@]*)@)?(\[[^\/?#\]]+\]|[^\/?#:]*)(?::(\d*))?))?([^?#]*)(?:\?([^#]*))?(?:#((?:.|\n|\r)*))?/i,W=
void 0==="".match(/(){0}/)[1],T=/^\.\.?\//,ba=/^\/\.(\/|$)/,N=/^\/\.\.(\/|$)/,V=/^\/?(?:.|\n)*?(?=\/|$)/,aa={scheme:"http",domainHost:!0,parse:function(a,b){a.host||(a.error=a.error||"HTTP URIs must have a host.");return a},serialize:function(a,b){b="https"===String(a.scheme).toLowerCase();if(a.port===(b?443:80)||""===a.port)a.port=void 0;a.path||(a.path="/");return a}},Y={scheme:"https",domainHost:aa.domainHost,parse:aa.parse,serialize:aa.serialize},Z={scheme:"ws",domainHost:!0,parse:function(a,
b){a.secure=K(a);a.resourceName=(a.path||"/")+(a.query?"?"+a.query:"");a.path=void 0;a.query=void 0;return a},serialize:function(a,b){if(a.port===(K(a)?443:80)||""===a.port)a.port=void 0;"boolean"===typeof a.secure&&(a.scheme=a.secure?"wss":"ws",a.secure=void 0);if(a.resourceName){b=a.resourceName.split("?");var c=D(b,2);b=c[0];c=c[1];a.path=b&&"/"!==b?b:void 0;a.query=c;a.resourceName=void 0}a.fragment=void 0;return a}},ia={scheme:"wss",domainHost:Z.domainHost,parse:Z.parse,serialize:Z.serialize},
la={},ka=h(h("%[EFef][0-9A-Fa-f]%[0-9A-Fa-f][0-9A-Fa-f]%[0-9A-Fa-f][0-9A-Fa-f]")+"|"+h("%[89A-Fa-f][0-9A-Fa-f]%[0-9A-Fa-f][0-9A-Fa-f]")+"|"+h("%[0-9A-Fa-f][0-9A-Fa-f]")),da=b("[\\!\\$\\%\\'\\(\\)\\*\\+\\,\\-\\.0-9\\<\\>A-Z\\x5E-\\x7E]",'[\\"\\\\]'),fa=/[A-Za-z0-9\-\.\_\~\xA0-\u200D\u2010-\u2029\u202F-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]/g,ha=new RegExp(ka,"g"),ma=new RegExp(b("[^]","[A-Za-z0-9\\!\\$\\%\\'\\*\\+\\-\\^\\_\\`\\{\\|\\}\\~]","[\\.]",'[\\"]',da),"g"),na=new RegExp(b("[^]","[A-Za-z0-9\\-\\.\\_\\~\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]",
"[\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]"),"g");ka={scheme:"mailto",parse:function(a,b){var c=a.to=a.path?a.path.split(","):[];a.path=void 0;if(a.query){for(var d=!1,e={},f=a.query.split("&"),g=0,l=f.length;g<l;++g){var h=f[g].split("=");switch(h[0]){case "to":h=h[1].split(",");for(var k=0,m=h.length;k<m;++k)c.push(h[k]);break;case "subject":a.subject=J(h[1],b);break;case "body":a.body=J(h[1],b);break;default:d=!0,e[J(h[0],b)]=J(h[1],b)}}d&&(a.headers=e)}a.query=void 0;d=0;for(e=c.length;d<e;++d){f=c[d].split("@");
f[0]=J(f[0]);if(b.unicodeSupport)f[1]=J(f[1],b).toLowerCase();else try{f[1]=R.toASCII(J(f[1],b).toLowerCase())}catch(Ca){a.error=a.error||"Email address's domain name can not be converted to ASCII via punycode: "+Ca}c[d]=f.join("@")}return a},serialize:function(a,b){var d=a.to;if(d=void 0!==d&&null!==d?d instanceof Array?d:"number"!==typeof d.length||d.split||d.setInterval||d.call?[d]:Array.prototype.slice.call(d):[]){for(var e=0,f=d.length;e<f;++e){var g=String(d[e]),l=g.lastIndexOf("@"),h=g.slice(0,
l).replace(ha,z).replace(ha,k).replace(ma,c);g=g.slice(l+1);try{g=b.iri?R.toUnicode(g):R.toASCII(J(g,b).toLowerCase())}catch(ra){a.error=a.error||"Email address's domain name can not be converted to "+(b.iri?"Unicode":"ASCII")+" via punycode: "+ra}d[e]=h+"@"+g}a.path=d.join(",")}b=a.headers=a.headers||{};a.subject&&(b.subject=a.subject);a.body&&(b.body=a.body);d=[];for(var m in b)b[m]!==la[m]&&d.push(m.replace(ha,z).replace(ha,k).replace(na,c)+"="+b[m].replace(ha,z).replace(ha,k).replace(na,c));d.length&&
(a.query=d.join("&"));return a}};var pa=/^([^:]+):(.*)/;da={scheme:"urn",parse:function(a,b){var c=a.path&&a.path.match(pa);if(c){var d=b.scheme||a.scheme||"urn",e=c[1].toLowerCase();c=c[2];d=P[d+":"+(b.nid||e)];a.nid=e;a.nss=c;a.path=void 0;d&&(a=d.parse(a,b))}else a.error=a.error||"URN can not be parsed.";return a},serialize:function(a,b){var c=a.nid,d=P[(b.scheme||a.scheme||"urn")+":"+(b.nid||c)];d&&(a=d.serialize(a,b));d=a;d.path=(c||b.nid)+":"+a.nss;return d}};var sa=/^[0-9A-Fa-f]{8}(?:\-[0-9A-Fa-f]{4}){3}\-[0-9A-Fa-f]{12}$/,
qa={scheme:"urn:uuid",parse:function(a,b){a.uuid=a.nss;a.nss=void 0;b.tolerant||a.uuid&&a.uuid.match(sa)||(a.error=a.error||"UUID is not valid.");return a},serialize:function(a,b){a.nss=(a.uuid||"").toLowerCase();return a}};P[aa.scheme]=aa;P[Y.scheme]=Y;P[Z.scheme]=Z;P[ia.scheme]=ia;P[ka.scheme]=ka;P[da.scheme]=da;P[qa.scheme]=qa;e.SCHEMES=P;e.pctEncChar=c;e.pctDecChars=f;e.parse=u;e.removeDotSegments=y;e.serialize=q;e.resolveComponents=n;e.resolve=function(a,b,c){var d={scheme:"null"};if(c)for(var e in c)d[e]=
c[e];return q(n(u(a,d),u(b,d),d,!0),d)};e.normalize=function(a,b){"string"===typeof a?a=q(u(a,b),b):"object"===t(a)&&(a=u(q(a,b),b));return a};e.equal=function(a,b,c){"string"===typeof a?a=q(u(a,c),c):"object"===t(a)&&(a=q(a,c));"string"===typeof b?b=q(u(b,c),c):"object"===t(b)&&(b=q(b,c));return a===b};e.escapeComponent=function(a,b){return a&&a.toString().replace(b&&b.iri?E.ESCAPE:H.ESCAPE,c)};e.unescapeComponent=J;Object.defineProperty(e,"__esModule",{value:!0})})},4049:function(y){(function(e,
h){y.exports=h()})(this,function(){function e(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:1;return(0<b?a.toFixed(b).replace(/0+$/,"").replace(/\.$/,""):a.toString())||"0"}function h(a){var b=document.createElement("div");b.innerHTML=a;return b.firstElementChild}function b(a,b,c){function d(a,d,e){e&&(g=!0);if(g){a.preventDefault();a=b.getBoundingClientRect();e=a.width;var f=a.height;c(Math.max(0,Math.min(d.clientX-a.left,e))/e,Math.max(0,Math.min(d.clientY-a.top,f))/f)}}function e(a,
b){1===(void 0===a.buttons?a.which:a.buttons)?d(a,a,b):g=!1}function f(a,b){1===a.touches.length?d(a,a.touches[0],b):g=!1}var g=!1;a.add(b,"mousedown",function(a){e(a,!0)});a.add(b,"touchstart",function(a){f(a,!0)});a.add(window,"mousemove",e);a.add(b,"touchmove",f);a.add(window,"mouseup",function(a){g=!1});a.add(b,"touchend",function(a){g=!1});a.add(b,"touchcancel",function(a){g=!1})}function r(a,b){return(b||document).querySelector(a)}function t(a,b,c,d,e){a.add(b,"keydown",function(a){0<=c.indexOf(a.key)&&
(e&&(a.preventDefault(),a.stopPropagation()),d(a))})}var k=function(a,b){if(!(a instanceof b))throw new TypeError("Cannot call a class as a function");},x=function(){function a(a,b){for(var c=0;c<b.length;c++){var d=b[c];d.enumerable=d.enumerable||!1;d.configurable=!0;"value"in d&&(d.writable=!0);Object.defineProperty(a,d.key,d)}}return function(b,c,d){c&&a(b.prototype,c);d&&a(b,d);return b}}(),g=function(){return function(a,b){if(Array.isArray(a))return a;if(Symbol.iterator in Object(a)){var c=[],
d=!0,e=!1,f=void 0;try{for(var g=a[Symbol.iterator](),h;!(d=(h=g.next()).done)&&(c.push(h.value),!b||c.length!==b);d=!0);}catch(n){e=!0,f=n}finally{try{if(!d&&g["return"])g["return"]()}finally{if(e)throw f;}}return c}throw new TypeError("Invalid attempt to destructure non-iterable instance");}}();String.prototype.startsWith=String.prototype.startsWith||function(a){return 0===this.indexOf(a)};String.prototype.padStart=String.prototype.padStart||function(a,b){for(var c=this;c.length<a;)c=b+c;return c};
var d={cb:"0f8ff",tqw:"aebd7",q:"-ffff",qmrn:"7fffd4",zr:"0ffff",bg:"5f5dc",bsq:"e4c4",bck:"---",nch:"ebcd",b:"--ff",bvt:"8a2be2",brwn:"a52a2a",brw:"deb887",ctb:"5f9ea0",hrt:"7fff-",chcT:"d2691e",cr:"7f50",rnw:"6495ed",crns:"8dc",crms:"dc143c",cn:"-ffff",Db:"--8b",Dcn:"-8b8b",Dgnr:"b8860b",Dgr:"a9a9a9",Dgrn:"-64-",Dkhk:"bdb76b",Dmgn:"8b-8b",Dvgr:"556b2f",Drng:"8c-",Drch:"9932cc",Dr:"8b--",Dsmn:"e9967a",Dsgr:"8fbc8f",DsTb:"483d8b",DsTg:"2f4f4f",Dtrq:"-ced1",Dvt:"94-d3",ppnk:"1493",pskb:"-bfff",mgr:"696969",
grb:"1e90ff",rbrc:"b22222",rwht:"af0",stg:"228b22",chs:"-ff",gnsb:"dcdcdc",st:"8f8ff",g:"d7-",gnr:"daa520",gr:"808080",grn:"-8-0",grnw:"adff2f",hnw:"0fff0",htpn:"69b4",nnr:"cd5c5c",ng:"4b-82",vr:"0",khk:"0e68c",vnr:"e6e6fa",nrb:"0f5",wngr:"7cfc-",mnch:"acd",Lb:"add8e6",Lcr:"08080",Lcn:"e0ffff",Lgnr:"afad2",Lgr:"d3d3d3",Lgrn:"90ee90",Lpnk:"b6c1",Lsmn:"a07a",Lsgr:"20b2aa",Lskb:"87cefa",LsTg:"778899",Lstb:"b0c4de",Lw:"e0",m:"-ff-",mgrn:"32cd32",nn:"af0e6",mgnt:"-ff",mrn:"8--0",mqm:"66cdaa",mmb:"--cd",
mmrc:"ba55d3",mmpr:"9370db",msg:"3cb371",mmsT:"7b68ee","":"-fa9a",mtr:"48d1cc",mmvt:"c71585",mnLb:"191970",ntc:"5fffa",mstr:"e4e1",mccs:"e4b5",vjw:"dead",nv:"--80",c:"df5e6",v:"808-0",vrb:"6b8e23",rng:"a5-",rngr:"45-",rch:"da70d6",pgnr:"eee8aa",pgrn:"98fb98",ptrq:"afeeee",pvtr:"db7093",ppwh:"efd5",pchp:"dab9",pr:"cd853f",pnk:"c0cb",pm:"dda0dd",pwrb:"b0e0e6",prp:"8-080",cc:"663399",r:"--",sbr:"bc8f8f",rb:"4169e1",sbrw:"8b4513",smn:"a8072",nbr:"4a460",sgrn:"2e8b57",ssh:"5ee",snn:"a0522d",svr:"c0c0c0",
skb:"87ceeb",sTb:"6a5acd",sTgr:"708090",snw:"afa",n:"-ff7f",stb:"4682b4",tn:"d2b48c",t:"-8080",thst:"d8bfd8",tmT:"6347",trqs:"40e0d0",vt:"ee82ee",whT:"5deb3",wht:"",hts:"5f5f5",w:"-",wgrn:"9acd32"},a=function(){function a(b,c,d,e){k(this,a);if(void 0!==b)if(Array.isArray(b))this.rgba=b;else if(void 0===d){if(b=b&&""+b)b=b.toLowerCase(),b.startsWith("hsl")?(b=b.match(/([\-\d\.e]+)/g).map(Number),e=g(b,4),b=e[0],c=e[1],d=e[2],e=e[3],void 0===e&&(e=1),this.hsla=[b/360,c/100,d/100,e]):b.startsWith("rgb")?
(b=b.match(/([\-\d\.e]+)/g).map(Number),e=g(b,4),b=e[0],c=e[1],d=e[2],e=e[3],void 0===e&&(e=1),this.rgba=[b,c,d,e]):b.startsWith("#")?this.rgba=a.hexToRgb(b):this.rgba=a.nameToRgb(b)||a.hexToRgb(b)}else this.rgba=[b,c,d,void 0===e?1:e]}x(a,[{key:"printRGB",value:function(a){var b=(a?this.rgba:this.rgba.slice(0,3)).map(function(a,b){return e(a,3===b?3:0)});return a?"rgba("+b+")":"rgb("+b+")"}},{key:"printHSL",value:function(a){var b=[360,100,100,1],c=["","%","%",""],d=(a?this.hsla:this.hsla.slice(0,
3)).map(function(a,d){return e(a*b[d],3===d?3:1)+c[d]});return a?"hsla("+d+")":"hsl("+d+")"}},{key:"printHex",value:function(a){var b=this.hex;return a?b:b.substring(0,7)}},{key:"rgba",get:function(){if(this._rgba)return this._rgba;if(!this._hsla)throw Error("No color is set");return this._rgba=a.hslToRgb(this._hsla)},set:function(a){3===a.length&&(a[3]=1);this._rgba=a;this._hsla=null}},{key:"rgbString",get:function(){return this.printRGB()}},{key:"rgbaString",get:function(){return this.printRGB(!0)}},
{key:"hsla",get:function(){if(this._hsla)return this._hsla;if(!this._rgba)throw Error("No color is set");return this._hsla=a.rgbToHsl(this._rgba)},set:function(a){3===a.length&&(a[3]=1);this._hsla=a;this._rgba=null}},{key:"hslString",get:function(){return this.printHSL()}},{key:"hslaString",get:function(){return this.printHSL(!0)}},{key:"hex",get:function(){return"#"+this.rgba.map(function(a,b){return 3>b?a.toString(16):Math.round(255*a).toString(16)}).map(function(a){return a.padStart(2,"0")}).join("")},
set:function(b){this.rgba=a.hexToRgb(b)}}],[{key:"hexToRgb",value:function(a){var b=(a.startsWith("#")?a.slice(1):a).replace(/^(\w{3})$/,"$1F").replace(/^(\w)(\w)(\w)(\w)$/,"$1$1$2$2$3$3$4$4").replace(/^(\w{6})$/,"$1FF");if(!b.match(/^([0-9a-fA-F]{8})$/))throw Error("Unknown hex color; "+a);a=b.match(/^(\w\w)(\w\w)(\w\w)(\w\w)$/).slice(1).map(function(a){return parseInt(a,16)});a[3]/=255;return a}},{key:"nameToRgb",value:function(b){b=b.toLowerCase().replace("at","T").replace(/[aeiouyldf]/g,"").replace("ght",
"L").replace("rk","D").slice(-5,4);b=d[b];return void 0===b?b:a.hexToRgb(b.replace(/\-/g,"00").padStart(6,"f"))}},{key:"rgbToHsl",value:function(a){var b=g(a,4);a=b[0];var c=b[1],d=b[2];b=b[3];a/=255;c/=255;d/=255;var e=Math.max(a,c,d),f=Math.min(a,c,d),h=void 0,k=(e+f)/2;if(e===f)h=f=0;else{var m=e-f;f=.5<k?m/(2-e-f):m/(e+f);switch(e){case a:h=(c-d)/m+(c<d?6:0);break;case c:h=(d-a)/m+2;break;case d:h=(a-c)/m+4}h/=6}return[h,f,k,b]}},{key:"hslToRgb",value:function(a){var b=g(a,4);a=b[0];var c=b[1],
d=b[2];b=b[3];var e=void 0,f=void 0,h=void 0;0===c?e=f=h=d:(h=function(a,b,c){0>c&&(c+=1);1<c&&--c;return c<1/6?a+6*(b-a)*c:.5>c?b:c<2/3?a+(b-a)*(2/3-c)*6:a},c=.5>d?d*(1+c):d+c-d*c,d=2*d-c,e=h(d,c,a+1/3),f=h(d,c,a),h=h(d,c,a-1/3));a=[255*e,255*f,255*h].map(Math.round);a[3]=b;return a}}]);return a}(),c=function(){function a(){k(this,a);this._events=[]}x(a,[{key:"add",value:function(a,b,c){a.addEventListener(b,c,!1);this._events.push({target:a,type:b,handler:c})}},{key:"remove",value:function(b,c,d){this._events=
this._events.filter(function(e){var f=!0;b&&b!==e.target&&(f=!1);c&&c!==e.type&&(f=!1);d&&d!==e.handler&&(f=!1);f&&a._doRemove(e.target,e.type,e.handler);return!f})}},{key:"destroy",value:function(){this._events.forEach(function(b){return a._doRemove(b.target,b.type,b.handler)});this._events=[]}}],[{key:"_doRemove",value:function(a,b,c){a.removeEventListener(b,c,!1)}}]);return a}(),f=document.createElement("style");f.textContent=".picker_wrapper.no_alpha .picker_alpha{display:none}.picker_wrapper.no_editor .picker_editor{position:absolute;z-index:-1;opacity:0}.picker_wrapper.no_cancel .picker_cancel{display:none}.layout_default.picker_wrapper{display:-webkit-box;display:flex;-webkit-box-orient:horizontal;-webkit-box-direction:normal;flex-flow:row wrap;-webkit-box-pack:justify;justify-content:space-between;-webkit-box-align:stretch;align-items:stretch;font-size:10px;width:25em;padding:.5em}.layout_default.picker_wrapper input,.layout_default.picker_wrapper button{font-size:1rem}.layout_default.picker_wrapper>*{margin:.5em}.layout_default.picker_wrapper::before{content:'';display:block;width:100%;height:0;-webkit-box-ordinal-group:2;order:1}.layout_default .picker_slider,.layout_default .picker_selector{padding:1em}.layout_default .picker_hue{width:100%}.layout_default .picker_sl{-webkit-box-flex:1;flex:1 1 auto}.layout_default .picker_sl::before{content:'';display:block;padding-bottom:100%}.layout_default .picker_editor{-webkit-box-ordinal-group:2;order:1;width:6.5rem}.layout_default .picker_editor input{width:100%;height:100%}.layout_default .picker_sample{-webkit-box-ordinal-group:2;order:1;-webkit-box-flex:1;flex:1 1 auto}.layout_default .picker_done,.layout_default .picker_cancel{-webkit-box-ordinal-group:2;order:1}.picker_wrapper{box-sizing:border-box;background:#f2f2f2;box-shadow:0 0 0 1px silver;cursor:default;font-family:sans-serif;color:#444;pointer-events:auto}.picker_wrapper:focus{outline:none}.picker_wrapper button,.picker_wrapper input{box-sizing:border-box;border:none;box-shadow:0 0 0 1px silver;outline:none}.picker_wrapper button:focus,.picker_wrapper button:active,.picker_wrapper input:focus,.picker_wrapper input:active{box-shadow:0 0 2px 1px dodgerblue}.picker_wrapper button{padding:.4em .6em;cursor:pointer;background-color:whitesmoke;background-image:-webkit-gradient(linear, left bottom, left top, from(gainsboro), to(transparent));background-image:linear-gradient(0deg, gainsboro, transparent)}.picker_wrapper button:active{background-image:-webkit-gradient(linear, left bottom, left top, from(transparent), to(gainsboro));background-image:linear-gradient(0deg, transparent, gainsboro)}.picker_wrapper button:hover{background-color:white}.picker_selector{position:absolute;z-index:1;display:block;-webkit-transform:translate(-50%, -50%);transform:translate(-50%, -50%);border:2px solid white;border-radius:100%;box-shadow:0 0 3px 1px #67b9ff;background:currentColor;cursor:pointer}.picker_slider .picker_selector{border-radius:2px}.picker_hue{position:relative;background-image:-webkit-gradient(linear, left top, right top, from(red), color-stop(yellow), color-stop(lime), color-stop(cyan), color-stop(blue), color-stop(magenta), to(red));background-image:linear-gradient(90deg, red, yellow, lime, cyan, blue, magenta, red);box-shadow:0 0 0 1px silver}.picker_sl{position:relative;box-shadow:0 0 0 1px silver;background-image:-webkit-gradient(linear, left top, left bottom, from(white), color-stop(50%, rgba(255,255,255,0))),-webkit-gradient(linear, left bottom, left top, from(black), color-stop(50%, rgba(0,0,0,0))),-webkit-gradient(linear, left top, right top, from(gray), to(rgba(128,128,128,0)));background-image:linear-gradient(180deg, white, rgba(255,255,255,0) 50%),linear-gradient(0deg, black, rgba(0,0,0,0) 50%),linear-gradient(90deg, gray, rgba(128,128,128,0))}.picker_alpha,.picker_sample{position:relative;background:url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='2' height='2'%3E%3Cpath d='M1,0H0V1H2V2H1' fill='lightgrey'/%3E%3C/svg%3E\") left top/contain white;box-shadow:0 0 0 1px silver}.picker_alpha .picker_selector,.picker_sample .picker_selector{background:none}.picker_editor input{font-family:monospace;padding:.2em .4em}.picker_sample::before{content:'';position:absolute;display:block;width:100%;height:100%;background:currentColor}.picker_arrow{position:absolute;z-index:-1}.picker_wrapper.popup{position:absolute;z-index:2;margin:1.5em}.picker_wrapper.popup,.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{background:#f2f2f2;box-shadow:0 0 10px 1px rgba(0,0,0,0.4)}.picker_wrapper.popup .picker_arrow{width:3em;height:3em;margin:0}.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{content:\"\";display:block;position:absolute;top:0;left:0;z-index:-99}.picker_wrapper.popup .picker_arrow::before{width:100%;height:100%;-webkit-transform:skew(45deg);transform:skew(45deg);-webkit-transform-origin:0 100%;transform-origin:0 100%}.picker_wrapper.popup .picker_arrow::after{width:150%;height:150%;box-shadow:none}.popup.popup_top{bottom:100%;left:0}.popup.popup_top .picker_arrow{bottom:0;left:0;-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.popup.popup_bottom{top:100%;left:0}.popup.popup_bottom .picker_arrow{top:0;left:0;-webkit-transform:rotate(90deg) scale(1, -1);transform:rotate(90deg) scale(1, -1)}.popup.popup_left{top:0;right:100%}.popup.popup_left .picker_arrow{top:0;right:0;-webkit-transform:scale(-1, 1);transform:scale(-1, 1)}.popup.popup_right{top:0;left:100%}.popup.popup_right .picker_arrow{top:0;left:0}";
document.documentElement.firstElementChild.appendChild(f);return function(){function d(a){k(this,d);this.settings={popup:"right",layout:"default",alpha:!0,editor:!0,editorFormat:"hex",cancelButton:!1,defaultColor:"#0cf"};this._events=new c;this.onClose=this.onOpen=this.onDone=this.onChange=null;this.setOptions(a)}x(d,[{key:"setOptions",value:function(a){function b(a,b,c){for(var d in a)c&&0<=c.indexOf(d)||(b[d]=a[d])}var c=this;if(a){var d=this.settings;if(a instanceof HTMLElement)d.parent=a;else{d.parent&&
a.parent&&d.parent!==a.parent&&(this._events.remove(d.parent),this._popupInited=!1);b(a,d);a.onChange&&(this.onChange=a.onChange);a.onDone&&(this.onDone=a.onDone);a.onOpen&&(this.onOpen=a.onOpen);a.onClose&&(this.onClose=a.onClose);var e=a.color||a.colour;e&&this._setColor(e)}(e=d.parent)&&d.popup&&!this._popupInited?(a=function(a){return c.openHandler(a)},this._events.add(e,"click",a),t(this._events,e,[" ","Spacebar","Enter"],a),this._popupInited=!0):a.parent&&!d.popup&&this.show()}}},{key:"openHandler",
value:function(a){if(this.show()){a&&a.preventDefault();this.settings.parent.style.pointerEvents="none";var b=a&&"keydown"===a.type?this._domEdit:this.domElement;setTimeout(function(){return b.focus()},100);if(this.onOpen)this.onOpen(this.colour)}}},{key:"closeHandler",value:function(a){var b=a&&a.type,c=!1;a?"mousedown"===b||"focusin"===b?a.timeStamp>(this.__containedEvent||0)+100&&(c=!0):(a.preventDefault(),a.stopPropagation(),c=!0):c=!0;if(c&&this.hide()&&(this.settings.parent.style.pointerEvents=
"","mousedown"!==b&&this.settings.parent.focus(),this.onClose))this.onClose(this.colour)}},{key:"movePopup",value:function(a,b){this.closeHandler();this.setOptions(a);b&&this.openHandler()}},{key:"setColor",value:function(a,b){this._setColor(a,{silent:b})}},{key:"_setColor",value:function(b,c){"string"===typeof b&&(b=b.trim());if(b){c=c||{};var d=void 0;try{d=new a(b)}catch(u){if(c.failSilently)return;throw u;}this.settings.alpha||(b=d.hsla,b[3]=1,d.hsla=b);this.colour=this.color=d;this._setHSLA(null,
null,null,null,c)}}},{key:"setColour",value:function(a,b){this.setColor(a,b)}},{key:"show",value:function(){if(!this.settings.parent)return!1;if(this.domElement){var a=this._toggleDOM(!0);this._setPosition();return a}var b=h(this.settings.template||'<div class="picker_wrapper" tabindex="-1"><div class="picker_arrow"></div><div class="picker_hue picker_slider"><div class="picker_selector"></div></div><div class="picker_sl"><div class="picker_selector"></div></div><div class="picker_alpha picker_slider"><div class="picker_selector"></div></div><div class="picker_editor"><input aria-label="Type a color name or hex value"/></div><div class="picker_sample"></div><div class="picker_done"><button>Ok</button></div><div class="picker_cancel"><button>Cancel</button></div></div>');
this.domElement=b;this._domH=r(".picker_hue",b);this._domSL=r(".picker_sl",b);this._domA=r(".picker_alpha",b);this._domEdit=r(".picker_editor input",b);this._domSample=r(".picker_sample",b);this._domOkay=r(".picker_done button",b);this._domCancel=r(".picker_cancel button",b);b.classList.add("layout_"+this.settings.layout);this.settings.alpha||b.classList.add("no_alpha");this.settings.editor||b.classList.add("no_editor");this.settings.cancelButton||b.classList.add("no_cancel");this._ifPopup(function(){return b.classList.add("popup")});
this._setPosition();this.colour?this._updateUI():this._setColor(this.settings.defaultColor);this._bindEvents();return!0}},{key:"hide",value:function(){return this._toggleDOM(!1)}},{key:"destroy",value:function(){this._events.destroy();this.domElement&&this.settings.parent.removeChild(this.domElement)}},{key:"_bindEvents",value:function(){function a(a,b,c){f.add(a,b,c)}var c=this,d=this,e=this.domElement,f=this._events;a(e,"click",function(a){return a.preventDefault()});b(f,this._domH,function(a,b){return d._setHSLA(a)});
b(f,this._domSL,function(a,b){return d._setHSLA(null,a,1-b)});this.settings.alpha&&b(f,this._domA,function(a,b){return d._setHSLA(null,null,null,1-b)});var g=this._domEdit;a(g,"input",function(a){d._setColor(this.value,{fromEditor:!0,failSilently:!0})});a(g,"focus",function(a){this.selectionStart===this.selectionEnd&&this.select()});this._ifPopup(function(){var b=function(a){return c.closeHandler(a)};a(window,"mousedown",b);a(window,"focusin",b);t(f,e,["Esc","Escape"],b);var d=function(a){c.__containedEvent=
a.timeStamp};a(e,"mousedown",d);a(e,"focusin",d);a(c._domCancel,"click",b)});g=function(a){c._ifPopup(function(){return c.closeHandler(a)});if(c.onDone)c.onDone(c.colour)};a(this._domOkay,"click",g);t(f,e,["Enter"],g)}},{key:"_setPosition",value:function(){var a=this.settings.parent,b=this.domElement;a!==b.parentNode&&a.appendChild(b);this._ifPopup(function(c){"static"===getComputedStyle(a).position&&(a.style.position="relative");var d=!0===c?"popup_right":"popup_"+c;["popup_top","popup_bottom","popup_left",
"popup_right"].forEach(function(a){a===d?b.classList.add(a):b.classList.remove(a)});b.classList.add(d)})}},{key:"_setHSLA",value:function(a,b,c,d,e){e=e||{};var f=this.colour,g=f.hsla;[a,b,c,d].forEach(function(a,b){if(a||0===a)g[b]=a});f.hsla=g;this._updateUI(e);if(this.onChange&&!e.silent)this.onChange(f)}},{key:"_updateUI",value:function(a){if(this.domElement){a=a||{};var b=this.colour,c=b.hsla,d="hsl("+360*c[0]+", 100%, 50%)",e=b.hslString,f=b.hslaString,g=this._domSL,h=this._domA,k=r(".picker_selector",
this._domH),m=r(".picker_selector",g);h=r(".picker_selector",h);k.style.left=100*c[0]+"%";this._domSL.style.backgroundColor=this._domH.style.color=d;m.style.left=100*c[1]+"%";m.style.top=100*(1-c[2])+"%";g.style.color=e;h.style.top=100*(1-c[3])+"%";c=e.replace("hsl","hsla").replace(")",", 0)");this._domA.style.backgroundImage="linear-gradient("+[e,c]+"), url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='2' height='2'%3E%3Cpath d='M1,0H0V1H2V2H1' fill='lightgrey'/%3E%3C/svg%3E\")";
if(!a.fromEditor){a=this.settings.alpha;switch(this.settings.editorFormat){case "rgb":b=b.printRGB(a);break;case "hsl":b=b.printHSL(a);break;default:b=b.printHex(a)}this._domEdit.value=b}this._domSample.style.color=f}}},{key:"_ifPopup",value:function(a,b){this.settings.parent&&this.settings.popup?a&&a(this.settings.popup):b&&b()}},{key:"_toggleDOM",value:function(a){var b=this.domElement;if(!b)return!1;a=a?"":"none";var c=b.style.display!==a;c&&(b.style.display=a);return c}}],[{key:"StyleElement",
get:function(){return f}}]);return d}()})}},va={};!function(){W.amdD=function(){throw Error("define cannot be used indirect");}}();!function(){W.n=function(y){var e=y&&y.__esModule?function(){return y["default"]}:function(){return y};W.d(e,{a:e});return e}}();!function(){W.d=function(y,e){for(var h in e)W.o(e,h)&&!W.o(y,h)&&Object.defineProperty(y,h,{enumerable:!0,get:e[h]})}}();!function(){W.o=function(y,e){return Object.prototype.hasOwnProperty.call(y,e)}}();!function(){W.r=function(y){"undefined"!==
typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(y,Symbol.toStringTag,{value:"Module"});Object.defineProperty(y,"__esModule",{value:!0})}}();!function(){W.nmd=function(y){y.paths=[];y.children||(y.children=[]);return y}}();return W(3161)}()});