/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.ecodata;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniReader {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    HashMap<String, String> document = new HashMap();

    public IniReader(String filename) {
        this.loadFile(filename);
    }

    private void loadFile(String filename) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            String currentSection = "";
            while (in.ready()) {
                int i;
                String line = in.readLine().trim();
                if (line.startsWith("#") || line.startsWith(";")) continue;
                if (line.length() > 2 && line.charAt(0) == '[') {
                    i = line.lastIndexOf("]");
                    if (i <= 0 && line.length() > 1) {
                        currentSection = line.substring(1);
                        continue;
                    }
                    if (i <= 2) continue;
                    currentSection = line.substring(1, i);
                    continue;
                }
                if (line.length() <= 2) continue;
                String key = "";
                String value = "";
                i = line.indexOf("=");
                if (i > 1) {
                    key = line.substring(0, i);
                }
                if (i < line.length() - 1) {
                    value = line.substring(i + 1);
                }
                this.document.put(currentSection + "\\" + key, value);
            }
            in.close();
        }
        catch (Exception e) {
            this.logger.error(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    public String getStringValue(String section, String key) {
        String ret = (String)this.document.get(section + "\\" + key);
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public int getIntegerValue(String section, String key) {
        Integer ret;
        String str = (String)this.document.get(section + "\\" + key);
        try {
            ret = new Integer(str);
        }
        catch (Exception e) {
            ret = new Integer(0);
        }
        return ret;
    }

    public double getDoubleValue(String section, String key) {
        Double ret;
        String str = (String)this.document.get(section + "\\" + key);
        try {
            ret = new Double(str);
        }
        catch (Exception e) {
            ret = new Double(0.0);
        }
        return ret;
    }

    public boolean valueExists(String section, String key) {
        return this.document.get(section + "\\" + key) != null;
    }

    public void setValue(String section, String key, String value) {
        this.document.put(section + "\\" + key, value);
    }

    public void write(String filename) {
        this.write((Map)this.document, filename);
    }

    public void write(Map<String, String> doc, String filename) {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
            TreeMap<String, String> pmap = new TreeMap<String, String>(doc);
            Iterator<String> it = pmap.keySet().iterator();
            String currentSection = "";
            while (it.hasNext()) {
                String key = it.next();
                String[] sectionkey = key.split("\\\\");
                if (!currentSection.equals(sectionkey[0])) {
                    currentSection = sectionkey[0];
                    out.println("\n");
                    out.println("[" + sectionkey[0] + "]");
                }
                out.println(sectionkey[1] + "=" + pmap.get(key));
            }
            out.close();
        }
        catch (Exception e) {
            this.logger.error("Unable to write ini to " + filename);
            e.printStackTrace(System.out);
        }
    }
}

