/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.ecodata;

import au.org.ala.ecodata.IniReader;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BasicGridIntersector {
    RandomAccessFile raf;
    byte[] b;
    public Boolean byteorderLSB;
    public int ncols;
    public int nrows;
    public double nodatavalue;
    public Boolean valid;
    public double[] values;
    public double xmin;
    public double xmax;
    public double ymin;
    public double ymax;
    public double xres;
    public double yres;
    public String datatype;

    public BasicGridIntersector(String filePath) throws Exception {
        this.readgrd(filePath + ".grd");
        this.raf = new RandomAccessFile(filePath + ".gri", "r");
    }

    float readCell(double longitude, double latitude) throws Exception {
        long pos = this.getcellnumber(longitude, latitude);
        if (pos >= 0L) {
            this.b = new byte[4];
            this.raf.seek(pos * 4L);
            this.raf.read(this.b);
            ByteBuffer bb = ByteBuffer.wrap(this.b);
            if (this.byteorderLSB.booleanValue()) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
            }
            return bb.getFloat();
        }
        throw new IllegalArgumentException("No data at this position");
    }

    public int getcellnumber(double x, double y) {
        if (x < this.xmin || x > this.xmax || y < this.ymin || y > this.ymax) {
            return -1;
        }
        int col = (int)((x - this.xmin) / this.xres);
        int row = this.nrows - 1 - (int)((y - this.ymin) / this.yres);
        if (col < 0) {
            col = 0;
        }
        if (row < 0) {
            row = 0;
        }
        if (col >= this.ncols) {
            col = this.ncols - 1;
        }
        if (row >= this.nrows) {
            row = this.nrows - 1;
        }
        return row * this.ncols + col;
    }

    private void readgrd(String filename) throws Exception {
        IniReader ir = new IniReader(filename);
        this.datatype = "FLOAT";
        this.ncols = ir.getIntegerValue("GeoReference", "Columns");
        this.nrows = ir.getIntegerValue("GeoReference", "Rows");
        this.xmin = ir.getDoubleValue("GeoReference", "MinX");
        this.ymin = ir.getDoubleValue("GeoReference", "MinY");
        this.xmax = ir.getDoubleValue("GeoReference", "MaxX");
        this.ymax = ir.getDoubleValue("GeoReference", "MaxY");
        this.xres = ir.getDoubleValue("GeoReference", "ResolutionX");
        this.yres = ir.getDoubleValue("GeoReference", "ResolutionY");
        this.nodatavalue = ir.valueExists("Data", "NoDataValue") ? (double)((float)ir.getDoubleValue("Data", "NoDataValue")) : Double.NaN;
        String s = ir.getStringValue("Data", "ByteOrder");
        this.byteorderLSB = true;
        if (s != null && s.length() > 0 && s.equals("MSB")) {
            this.byteorderLSB = false;
        }
    }

    public void close() {
        try {
            this.raf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

