<!doctype html>
<html>
<head>
    <meta name="layout" content="main"/>
    <meta name="section" content="home"/>
    <title>ALA Web Theme - Home</title>
</head>
<body class="nav-about nav-species">
%{--<a href="#page-body" class="skip"><g:message code="default.link.skip.label" default="Skip to content&hellip;"/></a>--}%
<div class="row-fluid">
    <div class="span3 well" id="status" role="complementary">
        <h3>Application Status</h3>
        <ul>
            <li>App version: <g:meta name="app.version"/></li>
            <li>Grails version: <g:meta name="app.grails.version"/></li>
            %{-- Might need to edit the following line to be ${org.codehaus.groovy.runtime.InvokerHelper.getVersion()} for Grails < 2.1.5 --}%
            <li>Groovy version: ${GroovySystem.getVersion()}</li>
            <li>JVM version: ${System.getProperty('java.version')}</li>
            <li>Reloading active: ${grails.util.Environment.reloadingAgentEnabled}</li>
            <li>Controllers: ${grailsApplication.controllerClasses.size()}</li>
            <li>Domains: ${grailsApplication.domainClasses.size()}</li>
            <li>Services: ${grailsApplication.serviceClasses.size()}</li>
            <li>Tag Libraries: ${grailsApplication.tagLibClasses.size()}</li>
        </ul>
        <h3>Installed Plugins</h3>
        <ul>
            <g:each var="plugin" in="${applicationContext.getBean('pluginManager').allPlugins}">
                <li>${plugin.name} - ${plugin.version}</li>
            </g:each>
        </ul>
    </div>
    <div class="span9" id="page-body" role="main">
        <h1>Welcome to Grails</h1>
        <p>Congratulations, you have successfully started your first Grails application! At the moment
        this is the default page, feel free to modify it to either redirect to a controller or display whatever
        content you may choose. Below is a list of controllers that are currently deployed in this application,
        click on each to execute its default action:</p>

        <div id="controller-list" role="navigation">
            <h2>Available Controllers:</h2>
            <ul>
                <g:each var="c" in="${grailsApplication.controllerClasses.sort { it.fullName } }">
                    <li class="controller"><g:link controller="${c.logicalPropertyName}">${c.fullName}</g:link></li>
                </g:each>
            </ul>
        </div>
    </div>
</div>

</div>
</body>
</html>
