/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.load.MediaStore;
import au.org.ala.biocache.load.MediaStore$class;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Multimedia;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.Json$;
import com.google.common.util.concurrent.RateLimiter;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minidev.json.JSONArray;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.matching.Regex;

public final class RemoteMediaStore$
implements MediaStore {
    public static final RemoteMediaStore$ MODULE$;
    private final Logger logger;
    private final String FileProtocol;
    private PoolingHttpClientConnectionManager cm;
    private CloseableHttpClient client;
    private RateLimiter rateLimiter;
    private final Regex imageParser;
    private final Regex soundParser;
    private final Regex videoParser;
    private final String[] imageExtension;
    private final String[] soundExtension;
    private final String[] videoExtension;
    private volatile byte bitmap$0;

    static {
        new RemoteMediaStore$();
    }

    private Regex imageParser$lzycompute() {
        RemoteMediaStore$ remoteMediaStore$ = this;
        synchronized (remoteMediaStore$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.imageParser = MediaStore$class.imageParser(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.imageParser;
        }
    }

    @Override
    public Regex imageParser() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.imageParser$lzycompute() : this.imageParser;
    }

    private Regex soundParser$lzycompute() {
        RemoteMediaStore$ remoteMediaStore$ = this;
        synchronized (remoteMediaStore$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.soundParser = MediaStore$class.soundParser(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.soundParser;
        }
    }

    @Override
    public Regex soundParser() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.soundParser$lzycompute() : this.soundParser;
    }

    private Regex videoParser$lzycompute() {
        RemoteMediaStore$ remoteMediaStore$ = this;
        synchronized (remoteMediaStore$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.videoParser = MediaStore$class.videoParser(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.videoParser;
        }
    }

    @Override
    public Regex videoParser() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.videoParser$lzycompute() : this.videoParser;
    }

    @Override
    public String[] imageExtension() {
        return this.imageExtension;
    }

    @Override
    public String[] soundExtension() {
        return this.soundExtension;
    }

    @Override
    public String[] videoExtension() {
        return this.videoExtension;
    }

    @Override
    public void au$org$ala$biocache$load$MediaStore$_setter_$logger_$eq(Logger x$1) {
    }

    @Override
    public void au$org$ala$biocache$load$MediaStore$_setter_$imageExtension_$eq(String[] x$1) {
        this.imageExtension = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$MediaStore$_setter_$soundExtension_$eq(String[] x$1) {
        this.soundExtension = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$MediaStore$_setter_$videoExtension_$eq(String[] x$1) {
        this.videoExtension = x$1;
    }

    @Override
    public boolean isValidImageURL(String url) {
        return MediaStore$class.isValidImageURL(this, url);
    }

    @Override
    public boolean isValidSoundURL(String url) {
        return MediaStore$class.isValidSoundURL(this, url);
    }

    @Override
    public boolean isValidVideoURL(String url) {
        return MediaStore$class.isValidVideoURL(this, url);
    }

    @Override
    public boolean isValidImage(String filename) {
        return MediaStore$class.isValidImage(this, filename);
    }

    @Override
    public boolean isValidSound(String filename) {
        return MediaStore$class.isValidSound(this, filename);
    }

    @Override
    public boolean isValidVideo(String filename) {
        return MediaStore$class.isValidVideo(this, filename);
    }

    @Override
    public boolean isMediaFile(File file) {
        return MediaStore$class.isMediaFile(this, file);
    }

    @Override
    public boolean endsWithOneOf(String[] acceptedExtensions, String url) {
        return MediaStore$class.endsWithOneOf(this, acceptedExtensions, url);
    }

    @Override
    public String extractSimpleFileName(String urlToMedia) {
        return MediaStore$class.extractSimpleFileName(this, urlToMedia);
    }

    @Override
    public String extractFileName(String urlToMedia) {
        return MediaStore$class.extractFileName(this, urlToMedia);
    }

    @Override
    public boolean isAccessible(String urlString) {
        return MediaStore$class.isAccessible(this, urlString);
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    public String FileProtocol() {
        return this.FileProtocol;
    }

    public PoolingHttpClientConnectionManager cm() {
        return this.cm;
    }

    public void cm_$eq(PoolingHttpClientConnectionManager x$1) {
        this.cm = x$1;
    }

    public CloseableHttpClient client() {
        return this.client;
    }

    public void client_$eq(CloseableHttpClient x$1) {
        this.client = x$1;
    }

    public RateLimiter rateLimiter() {
        return this.rateLimiter;
    }

    public void rateLimiter_$eq(RateLimiter x$1) {
        this.rateLimiter = x$1;
    }

    /*
     * Loose catch block
     */
    public CloseableHttpClient getClient() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.client() == null) {
            RemoteMediaStore$ remoteMediaStore$ = this;
            synchronized (remoteMediaStore$) {
                BoxedUnit boxedUnit3;
                if (this.client() == null) {
                    this.cm_$eq(new PoolingHttpClientConnectionManager());
                    this.cm().setMaxTotal(Config$.MODULE$.remoteMediaConnectionPoolSize());
                    this.cm().setDefaultMaxPerRoute(Config$.MODULE$.remoteMediaConnectionMaxPerRoute());
                    this.client_$eq(HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.cm()).build());
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit4 = boxedUnit3;
                // MONITOREXIT @DISABLED, blocks:[0, 2, 12] lbl14 : MonitorExitStatement: MONITOREXIT : var1_1
                boxedUnit2 = boxedUnit4;
            }
        }
        boxedUnit2 = BoxedUnit.UNIT;
        if (this.rateLimiter() == null) {
            RemoteMediaStore$ remoteMediaStore$ = this;
            synchronized (remoteMediaStore$) {
                BoxedUnit boxedUnit5;
                if (this.rateLimiter() == null) {
                    this.rateLimiter_$eq(RateLimiter.create((double)Config$.MODULE$.remoteMediaStoreMaxRequests()));
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit6 = boxedUnit5;
                // MONITOREXIT @DISABLED, blocks:[1, 3, 9] lbl28 : MonitorExitStatement: MONITOREXIT : var3_3
                boxedUnit = boxedUnit6;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.rateLimiter().acquire();
        return this.client();
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public java.util.Map<String, String> getImageFormats(String imageId) {
        void var2_2;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("thumb", new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImageThumbnail?imageId=").append((Object)imageId).toString());
        map.put("small", new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImageThumbnail?imageId=").append((Object)imageId).toString());
        map.put("large", new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImageThumbnailLarge?imageId=").append((Object)imageId).toString());
        map.put("raw", new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImage?imageId=").append((Object)imageId).toString());
        return var2_2;
    }

    @Override
    public Tuple3<Object, String, String> alreadyStored(String uuid, String resourceUID, File file) {
        Tuple3 tuple3;
        CloseableHttpResponse response2;
        if (file.exists() && file.length() != 0L) {
            String hash = FileHelper$.MODULE$.file2helper(file).sha1Hash();
            if (this.logger().isDebugEnabled()) {
                this.logger().debug(new StringBuilder().append((Object)"Searching for media file by hash: '").append((Object)file.toString()).append((Object)"' uuid=").append((Object)uuid).append((Object)" hash=").append((Object)hash).toString());
            }
            HttpGet httpGet = new HttpGet(new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/ws/search?q=contentsha1hash:").append((Object)hash).append((Object)"&fq=dataResourceUid:").append((Object)resourceUID).toString());
            response2 = this.getClient().execute((HttpUriRequest)httpGet);
            if (response2.getStatusLine().getStatusCode() != 200) {
                this.logger().warn(new StringBuilder().append((Object)"Unable to test storage status for ").append((Object)file).append((Object)" reason ").append((Object)response2.getStatusLine()).append((Object)" treating as not stored").toString());
                tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"", (Object)"");
            } else {
                if (this.logger().isDebugEnabled()) {
                    this.logger().debug(new StringBuilder().append((Object)"Searching for media file by hash returned HTTP 200: '").append((Object)file.toString()).append((Object)"' uuid=").append((Object)uuid).append((Object)" hash=").append((Object)hash).toString());
                }
                String body = Source$.MODULE$.fromInputStream(response2.getEntity().getContent(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
                JsonPath jsonPath = JsonPath.compile((String)"$..imageIdentifier", (Filter[])new Filter[0]);
                JSONArray idArray = (JSONArray)jsonPath.read(body);
                if (idArray.isEmpty()) {
                    if (this.logger().isDebugEnabled()) {
                        this.logger().debug(new StringBuilder().append((Object)"Searching for media file by hash did not return matches: '").append((Object)file.toString()).append((Object)"' uuid=").append((Object)uuid).append((Object)" hash=").append((Object)hash).toString());
                    }
                    tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"", (Object)"");
                } else {
                    if (this.logger().isDebugEnabled()) {
                        this.logger().debug(new StringBuilder().append((Object)"Searching for media file by hash returned matches: '").append((Object)file.toString()).append((Object)"' uuid=").append((Object)uuid).append((Object)" hash=").append((Object)hash).append((Object)" idArray=").append((Object)idArray.toString()).append((Object)" using first id=").append((Object)((String)idArray.get(0))).toString());
                    }
                    tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)file.getName(), (Object)((String)idArray.get(0)));
                }
            }
        } else {
            if (this.logger().isDebugEnabled()) {
                this.logger().debug(new StringBuilder().append((Object)"Media file did not exist or file was 0-bytes: '").append((Object)file.toString()).append((Object)"' uuid=").append((Object)uuid).toString());
            }
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"", (Object)"");
        }
        return tuple3;
        finally {
            response2.close();
        }
    }

    public String constructFileID(String resourceUID, String uuid, String urlToMedia) {
        return new StringBuilder().append((Object)resourceUID).append((Object)"||").append((Object)uuid).append((Object)"||").append((Object)this.extractFileName(urlToMedia)).toString();
    }

    public boolean isRemoteMediaStoreUrl(String urlToMedia) {
        String urlToRemoteMediaStoreHost;
        if (urlToMedia == null) {
            return false;
        }
        if (urlToMedia.startsWith(Config$.MODULE$.remoteMediaStoreUrl())) {
            return true;
        }
        String urlToMediaHost = new URL(urlToMedia).getHost();
        return urlToMediaHost.equals(urlToRemoteMediaStoreHost = new URL(Config$.MODULE$.remoteMediaStoreUrl()).getHost());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Option<Tuple2<String, String>> save(String uuid, String resourceUID, String urlToMedia, Option<Multimedia> media) {
        None$ none$;
        Some imageId;
        Some some;
        if (this.isRemoteMediaStoreUrl(urlToMedia)) {
            Object originalFileName;
            this.logger().info(new StringBuilder().append((Object)"Remote media store host recognised: ").append((Object)urlToMedia).append((Object)" for uuid=").append((Object)uuid).toString());
            Option<String> imageId2 = this.extractUUIDFromURL(urlToMedia);
            if (imageId2.isEmpty()) {
                this.logger().info("Did not recognise URL pattern for remote media store: {}", new Object[]{urlToMedia});
                return None$.MODULE$;
            }
            java.util.Map<String, Object> metadata = this.getMetadata((String)imageId2.get());
            if (metadata == null) {
                this.logger().error(new StringBuilder().append((Object)"Unable to retrieve metadata for image already stored in image service: ").append(imageId2.get()).append((Object)" for uuid=").append((Object)uuid).toString());
                return None$.MODULE$;
            }
            if (this.logger().isDebugEnabled()) {
                this.logger().debug(new StringBuilder().append((Object)"Searching for remote media file imageId=").append(imageId2.get()).append((Object)" for uuid=").append((Object)uuid).append((Object)" returned metadata: ").append(metadata).toString());
            }
            if ((originalFileName = metadata.getOrDefault("originalFileName", "")) != null) return new Some((Object)new Tuple2((Object)originalFileName.toString(), imageId2.get()));
            return new Some((Object)new Tuple2((Object)"", imageId2.get()));
        }
        if (urlToMedia.isEmpty()) {
            this.logger().debug(new StringBuilder().append((Object)"Empty URL to media, ignoring for urlToMedia=").append((Object)urlToMedia).append((Object)" uuid=").append((Object)uuid).toString());
        } else {
            this.logger().info(new StringBuilder().append((Object)"Remote media store host not recognised: ").append((Object)urlToMedia).append((Object)" for uuid=").append((Object)uuid).toString());
        }
        if (urlToMedia.startsWith(this.FileProtocol())) {
            Tuple3 tuple3;
            Tuple2 tuple2;
            String string;
            Regex pattern = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)"(").append((Object)this.FileProtocol()).append((Object)"/+)(.+)").toString())).r();
            Option option = pattern.unapplySeq((Object)(string = urlToMedia));
            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) throw new MatchError((Object)string);
            String protocol = (String)((LinearSeqOptimized)option.get()).apply(0);
            String path = (String)((LinearSeqOptimized)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)protocol, (Object)path);
            String protocol2 = (String)tuple22._1();
            String path2 = (String)tuple22._2();
            File file = new File(URI.create(new StringBuilder().append((Object)protocol2).append((Object)URLEncoder.encode(path2, "UTF-8").replace("+", "%20")).toString()));
            Tuple3<Object, String, String> tuple32 = this.alreadyStored(uuid, resourceUID, file);
            if (tuple32 == null) throw new MatchError(tuple32);
            boolean stored = BoxesRunTime.unboxToBoolean((Object)tuple32._1());
            String name = (String)tuple32._2();
            String storedId = (String)tuple32._3();
            Tuple3 tuple33 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)stored), (Object)name, (Object)storedId);
            boolean stored2 = BoxesRunTime.unboxToBoolean((Object)tuple33._1());
            String name2 = (String)tuple33._2();
            String storedId2 = (String)tuple33._3();
            if (stored2) {
                this.logger().info(new StringBuilder().append((Object)"File ").append((Object)name2).append((Object)" already uploaded to ").append((Object)storedId2).append((Object)" for uuid=").append((Object)uuid).toString());
                some = new Some((Object)storedId2);
            } else {
                if (this.logger().isDebugEnabled()) {
                    this.logger().debug(new StringBuilder().append((Object)"Saving local file to remote media store for uuid=").append((Object)uuid).append((Object)" media=").append((Object)media.toString()).append((Object)" urlToMedia=").append((Object)urlToMedia).toString());
                }
                some = this.uploadImage(uuid, resourceUID, urlToMedia, file, media);
            }
        } else {
            if (this.logger().isDebugEnabled()) {
                this.logger().debug(new StringBuilder().append((Object)"Saving remote url to remote media store for uuid=").append((Object)uuid).append((Object)" media=").append((Object)media.toString()).append((Object)" urlToMedia=").append((Object)urlToMedia).toString());
            }
            some = imageId = this.uploadImageFromUrl(uuid, resourceUID, urlToMedia, media);
        }
        if (imageId.isDefined()) {
            if (this.logger().isDebugEnabled()) {
                this.logger().debug(new StringBuilder().append((Object)"Successfully searched or saved image to/from media store for uuid=").append((Object)uuid).toString());
            }
            none$ = new Some((Object)new Tuple2((Object)this.extractFileName(urlToMedia), imageId.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            })));
            return none$;
        } else {
            if (this.logger().isDebugEnabled()) {
                this.logger().debug(new StringBuilder().append((Object)"Failed to search or save image to/from media store for uuid=").append((Object)uuid).toString());
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<String> extractUUIDFromURL(String urlToMedia) {
        NonLocalReturnControl nonLocalReturnControl2;
        block5: {
            Option option;
            Object object = new Object();
            try {
                URI uri = new URI(urlToMedia.replace(" ", "%20"));
                if (urlToMedia.contains("/image/proxy")) {
                    List params = URLEncodedUtils.parse((URI)uri, (Charset)StandardCharsets.UTF_8);
                    JavaConversions$.MODULE$.asScalaBuffer(params).foreach((Function1)new Serializable(object){
                        public static final long serialVersionUID = 0L;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(NameValuePair param) {
                            String string = param.getName().toLowerCase();
                            String string2 = "imageid";
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                String originalUUID = param.getValue().toLowerCase();
                                UUID testUUID = UUID.fromString(originalUUID);
                                String reformedString = testUUID.toString().toLowerCase();
                                String string3 = originalUUID;
                                String string4 = reformedString;
                                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                                    throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)originalUUID));
                                }
                            }
                        }
                        {
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                } else if (urlToMedia.contains("/store/")) {
                    Predef$.MODULE$.refArrayOps((Object[])uri.getPath().split("/")).foreach((Function1)new Serializable(object){
                        public static final long serialVersionUID = 0L;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(String pathSegment) {
                            if (pathSegment.length() > 10) {
                                try {
                                    String originalUUID = pathSegment.toLowerCase();
                                    UUID testUUID = UUID.fromString(originalUUID);
                                    String reformedString = testUUID.toString().toLowerCase();
                                    String string = originalUUID;
                                    String string2 = reformedString;
                                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                        throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)originalUUID));
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        {
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                }
                option = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block5;
                option = (Option)nonLocalReturnControl2.value();
            }
            return option;
        }
        throw nonLocalReturnControl2;
    }

    @Override
    public java.util.Map<String, Object> getMetadata(String uuid) {
        java.util.Map<String, Object> map;
        String url = new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/ws/image/").append((Object)uuid).append((Object)".json").toString();
        CloseableHttpResponse httpResponse = this.getClient().execute((HttpUriRequest)new HttpGet(url));
        if (httpResponse.getStatusLine().getStatusCode() == 200) {
            java.util.Map<String, Object> result;
            String jsonStr = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            map = result = Json$.MODULE$.toJavaMap(jsonStr);
        } else {
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
            this.logger().warn(new StringBuilder().append((Object)"Unable to retrieve metadata for image already stored in image service: ").append((Object)url).toString());
            map = null;
        }
        return map;
    }

    /*
     * Loose catch block
     */
    private Option<File> downloadToTmpFile(String resourceUID, String uuid, String urlToMedia) {
        None$ none$;
        block10: {
            try {
                FileOutputStream out;
                InputStream in;
                String urlStr;
                block9: {
                    File tmpFile = new File(new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)File.separator).append((Object)this.constructFileID(resourceUID, uuid, urlToMedia)).toString());
                    urlStr = urlToMedia.replaceAll(" ", "%20");
                    URL url = new URL(urlStr);
                    in = url.openStream();
                    out = new FileOutputStream(tmpFile);
                    byte[] buffer = new byte[1024];
                    int numRead = 0;
                    while ((numRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, numRead);
                        out.flush();
                    }
                    out.close();
                    if (tmpFile.getTotalSpace() <= 0L) break block9;
                    this.logger().debug(new StringBuilder().append((Object)"Temp file created: ").append((Object)tmpFile.getAbsolutePath()).append((Object)", file size: ").append((Object)BoxesRunTime.boxToLong((long)tmpFile.getTotalSpace())).toString());
                    none$ = new Some((Object)tmpFile);
                    break block10;
                }
                this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failure to download image from  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{urlStr})));
                none$ = None$.MODULE$;
                break block10;
                {
                    catch (Throwable throwable) {
                        out.close();
                        throw throwable;
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (Exception exception) {
                this.logger().error(new StringBuilder().append((Object)"Problem downloading media. URL:").append((Object)urlToMedia).toString());
                this.logger().debug(exception.getMessage(), (Throwable)exception);
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private void updateMetadata(String imageId, Multimedia media) {
        long start = System.currentTimeMillis();
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating the metadata for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{imageId})));
        HttpEntity entity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addPart("metadata", (ContentBody)new StringBody(Json$.MODULE$.toJSON(media.metadata()), ContentType.APPLICATION_JSON)).build();
        HttpPost httpPost = new HttpPost(new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/ws/updateMetadata/").append((Object)imageId).toString());
        httpPost.setEntity(entity);
        CloseableHttpResponse response2 = this.getClient().execute((HttpUriRequest)httpPost);
        try {
            StatusLine status = response2.getStatusLine();
            return;
        }
        finally {
            response2.close();
        }
    }

    private Option<String> uploadImageFromUrl(String uuid, String resourceUID, String urlToMedia, Option<Multimedia> media) {
        None$ none$;
        block16: {
            Option option;
            CloseableHttpResponse response2;
            block15: {
                block14: {
                    Some some;
                    MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                    builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                    scala.collection.mutable.Map metadata = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"occurrenceId"), (Object)uuid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"dataResourceUid"), (Object)resourceUID), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"originalFileName"), (Object)urlToMedia), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"fullOriginalUrl"), (Object)urlToMedia)}));
                    Object object = media.isDefined() ? metadata.$plus$plus$eq(((Multimedia)media.get()).metadata()) : BoxedUnit.UNIT;
                    builder.addPart("imageUrl", (ContentBody)new StringBody(urlToMedia));
                    builder.addPart("metadata", (ContentBody)new StringBody(Json$.MODULE$.toJSON(metadata), ContentType.APPLICATION_JSON));
                    HttpEntity entity = builder.build();
                    HttpPost httpPost = new HttpPost(new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/ws/uploadImage").toString());
                    httpPost.setEntity(entity);
                    httpPost.setHeader("apiKey", Config$.MODULE$.mediaStoreApiKey());
                    response2 = this.getClient().execute((HttpUriRequest)httpPost);
                    StatusLine result = response2.getStatusLine();
                    HttpEntity entity2 = response2.getEntity();
                    if (entity2 == null) {
                        this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to persist image from URL. Response content was empty indicating a failure"})).s((Seq)Nil$.MODULE$));
                        none$ = None$.MODULE$;
                        break block14;
                    }
                    InputStream content = entity2.getContent();
                    if (content == null) {
                        this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to persist image from URL. Response entity was null indicating a failure"})).s((Seq)Nil$.MODULE$));
                        none$ = None$.MODULE$;
                        break block14;
                    }
                    BufferedSource bufferedSource = Source$.MODULE$.fromInputStream(content, Codec$.MODULE$.fallbackSystemCodec());
                    String responseBody = Source$.MODULE$.fromInputStream(response2.getEntity().getContent(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
                    if (this.logger().isDebugEnabled()) {
                        this.logger().debug(new StringBuilder().append((Object)"Image service response code: ").append((Object)BoxesRunTime.boxToInteger((int)result.getStatusCode())).toString());
                    }
                    Map<String, Object> map = Json$.MODULE$.toMap(responseBody);
                    if (this.logger().isDebugEnabled()) {
                        this.logger().debug(new StringBuilder().append((Object)"Image ID: ").append(map.getOrElse((Object)"imageId", (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        })).toString());
                    }
                    if ((option = map.get((Object)"imageId")) instanceof Some) {
                        Some some2 = (Some)option;
                        Object o = some2.x();
                        some = new Some((Object)o.toString());
                    } else {
                        None$ none$2 = None$.MODULE$;
                        Option option2 = option;
                        if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block15;
                        this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to persist image from URL. Response code ", ".  Image service response body: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)result.getStatusCode()), responseBody})));
                        some = None$.MODULE$;
                    }
                    none$ = some;
                }
                response2.close();
                break block16;
            }
            try {
                throw new MatchError((Object)option);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to persist image from URL. UnsupportedOperationException thrown"})).s((Seq)Nil$.MODULE$), (Throwable)unsupportedOperationException);
                none$ = None$.MODULE$;
                response2.close();
            }
            catch (IOException iOException) {
                try {
                    this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to persist image from URL. IOException thrown"})).s((Seq)Nil$.MODULE$), (Throwable)iOException);
                    none$ = None$.MODULE$;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    response2.close();
                }
            }
        }
        return none$;
    }

    private Option<String> uploadImage(String uuid, String resourceUID, String urlToMedia, File fileToUpload, Option<Multimedia> media) {
        CloseableHttpResponse response2;
        block8: {
            Option option;
            block11: {
                Some some;
                block10: {
                    String responseBody;
                    StatusLine result;
                    block9: {
                        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                        if (!fileToUpload.exists()) break block8;
                        if (fileToUpload.length() == 0L) {
                            this.logger().error(new StringBuilder().append((Object)"File to upload is empty. ").append((Object)fileToUpload.getAbsolutePath()).toString());
                            return None$.MODULE$;
                        }
                        this.logger().debug(new StringBuilder().append((Object)"File to upload: ").append((Object)fileToUpload.getAbsolutePath()).append((Object)", size:").append((Object)BoxesRunTime.boxToLong((long)fileToUpload.length())).toString());
                        scala.collection.mutable.Map metadata = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"occurrenceId"), (Object)uuid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"dataResourceUid"), (Object)resourceUID), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"originalFileName"), (Object)urlToMedia), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"fullOriginalUrl"), (Object)urlToMedia)}));
                        Object object = media.isDefined() ? metadata.$plus$plus$eq(((Multimedia)media.get()).metadata()) : BoxedUnit.UNIT;
                        builder.addPart("image", (ContentBody)new FileBody(fileToUpload, ContentType.create((String)"image/jpeg"), fileToUpload.getName()));
                        builder.addPart("metadata", (ContentBody)new StringBody(Json$.MODULE$.toJSON(metadata)));
                        HttpEntity entity = builder.build();
                        HttpPost httpPost = new HttpPost(new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/ws/uploadImage").toString());
                        httpPost.setEntity(entity);
                        httpPost.setHeader("apiKey", Config$.MODULE$.mediaStoreApiKey());
                        response2 = this.getClient().execute((HttpUriRequest)httpPost);
                        result = response2.getStatusLine();
                        responseBody = Source$.MODULE$.fromInputStream(response2.getEntity().getContent(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
                        this.logger().debug(new StringBuilder().append((Object)"Image service response code: ").append((Object)BoxesRunTime.boxToInteger((int)result.getStatusCode())).toString());
                        Map<String, Object> map = Json$.MODULE$.toMap(responseBody);
                        this.logger().debug(new StringBuilder().append((Object)"Image ID: ").append(map.getOrElse((Object)"imageId", (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        })).toString());
                        option = map.get((Object)"imageId");
                        if (!(option instanceof Some)) break block9;
                        Some some2 = (Some)option;
                        Object o = some2.x();
                        some = new Some((Object)o.toString());
                        break block10;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block11;
                    this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to persist image with multipart upload. Response code ", ".getStatusCode.  Image service response body: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result, responseBody})));
                    some = None$.MODULE$;
                }
                return some;
            }
            throw new MatchError((Object)option);
        }
        this.logger().error(new StringBuilder().append((Object)"File to upload does not exist or can not be read. ").append((Object)fileToUpload.getAbsolutePath()).toString());
        return None$.MODULE$;
        finally {
            response2.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public java.util.Map<String, String> getSoundFormats(String mediaID) {
        void var2_2;
        HashMap<String, String> formats2 = new HashMap<String, String>();
        formats2.put("audio/mpeg", new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImage?imageId=").append((Object)mediaID).toString());
        return var2_2;
    }

    @Override
    public void convertPathsToUrls(FullRecord fullRecord, String baseUrlPath) {
        if (fullRecord.occurrence().images() != null) {
            fullRecord.occurrence().images_$eq((String[])Predef$.MODULE$.refArrayOps((Object[])fullRecord.occurrence().images()).map((Function1)new Serializable(baseUrlPath){
                public static final long serialVersionUID = 0L;
                private final String baseUrlPath$2;

                public final String apply(String x) {
                    return RemoteMediaStore$.MODULE$.convertPathToUrl(x, this.baseUrlPath$2);
                }
                {
                    this.baseUrlPath$2 = baseUrlPath$2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        }
    }

    @Override
    public String convertPathToUrl(String str, String baseUrlPath) {
        return new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImageThumbnail?imageId=").append((Object)str).toString();
    }

    @Override
    public String convertPathToUrl(String str) {
        return new StringBuilder().append((Object)Config$.MODULE$.remoteMediaStoreUrl()).append((Object)"/image/proxyImageThumbnail?imageId=").append((Object)str).toString();
    }

    private RemoteMediaStore$() {
        MODULE$ = this;
        MediaStore$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"RemoteMediaStore");
        this.FileProtocol = "file:";
        this.cm = null;
        this.client = null;
        this.rateLimiter = null;
    }
}

