/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.load.DwCALoader;
import au.org.ala.biocache.util.OptionParser;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwc.terms.Term;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class DwCALoader$
implements Tool {
    public static final DwCALoader$ MODULE$;
    private final GbifTerm IMAGE_TYPE;
    private final GbifTerm MULTIMEDIA_TYPE;

    static {
        new DwCALoader$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    public GbifTerm IMAGE_TYPE() {
        return this.IMAGE_TYPE;
    }

    public GbifTerm MULTIMEDIA_TYPE() {
        return this.MULTIMEDIA_TYPE;
    }

    @Override
    public String cmd() {
        return "load-dwca";
    }

    @Override
    public String desc() {
        return "Load a Darwin Core Archive";
    }

    @Override
    public void main(String[] args) {
        Object object;
        ObjectRef resourceUid = new ObjectRef((Object)"");
        ObjectRef localFilePath = new ObjectRef((Object)None$.MODULE$);
        boolean logRowKeys = true;
        BooleanRef testFile = new BooleanRef(false);
        BooleanRef bypassConnParamLookup = new BooleanRef(false);
        BooleanRef removeNullFields = new BooleanRef(false);
        BooleanRef loadMissingOnly = new BooleanRef(false);
        IntRef loadingThreads = new IntRef(1);
        OptionParser parser = new OptionParser(resourceUid, localFilePath, testFile, bypassConnParamLookup, removeNullFields, loadMissingOnly, loadingThreads){
            {
                this.arg("<data resource UID>", "The UID of the data resource to load", (Function1<String, BoxedUnit>)new Serializable(this, resourceUid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef resourceUid$1;

                    public final void apply(String v) {
                        this.resourceUid$1.elem = v;
                    }
                    {
                        this.resourceUid$1 = resourceUid$1;
                    }
                });
                this.opt("l", "local", "skip the download and use local file", (Function1<String, BoxedUnit>)new Serializable(this, localFilePath$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef localFilePath$1;

                    public final void apply(String v) {
                        this.localFilePath$1.elem = new Some((Object)v);
                    }
                    {
                        this.localFilePath$1 = localFilePath$1;
                    }
                });
                this.booleanOpt("b", "bypassConnParamLookup", "bypass connection parameter lookup in the registry (collectory)", (Function1<Object, BoxedUnit>)new Serializable(this, bypassConnParamLookup$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef bypassConnParamLookup$1;

                    public final void apply(boolean v) {
                        this.bypassConnParamLookup$1.elem = v;
                    }
                    {
                        this.bypassConnParamLookup$1 = bypassConnParamLookup$1;
                    }
                });
                this.opt("test", "test the file only do not load", (Function0<BoxedUnit>)new Serializable(this, testFile$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef testFile$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.testFile$1.elem = true;
                    }
                    {
                        this.testFile$1 = testFile$1;
                    }
                });
                this.opt("rnf", "remove-null-fields", "Remove the null/Empty fields currently exist in the atlas", (Function0<BoxedUnit>)new Serializable(this, removeNullFields$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef removeNullFields$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.removeNullFields$1.elem = true;
                    }
                    {
                        this.removeNullFields$1 = removeNullFields$1;
                    }
                });
                this.opt("lmo", "load-missing-only", "Load missing records only", (Function0<BoxedUnit>)new Serializable(this, loadMissingOnly$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef loadMissingOnly$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.loadMissingOnly$1.elem = true;
                    }
                    {
                        this.loadMissingOnly$1 = loadMissingOnly$1;
                    }
                });
                this.intOpt("t", "number-of-threads", new StringBuilder().append((Object)"Number of loading threads to use. Default is ").append((Object)BoxesRunTime.boxToInteger((int)loadingThreads$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, loadingThreads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef loadingThreads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.loadingThreads$1.elem = v;
                    }
                    {
                        this.loadingThreads$1 = loadingThreads$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            DwCALoader l = new DwCALoader();
            l.deleteOldRowKeys((String)resourceUid.elem);
            if (((Option)localFilePath.elem).isEmpty()) {
                String x$7 = (String)resourceUid.elem;
                boolean x$8 = logRowKeys;
                boolean x$9 = testFile.elem;
                boolean x$10 = removeNullFields.elem;
                boolean x$11 = loadMissingOnly.elem;
                int x$12 = loadingThreads.elem;
                boolean x$13 = l.load$default$4();
                l.load(x$7, x$8, x$9, x$13, x$10, x$11, x$12);
            } else if (bypassConnParamLookup.elem) {
                l.loadArchive((String)((Option)localFilePath.elem).get(), (String)resourceUid.elem, (Seq<Term>)Nil$.MODULE$, (Option<String>)None$.MODULE$, false, logRowKeys, testFile.elem, removeNullFields.elem, loadMissingOnly.elem, loadingThreads.elem);
            } else {
                l.loadLocal((String)resourceUid.elem, (String)((Option)localFilePath.elem).get(), logRowKeys, testFile.elem, removeNullFields.elem, loadMissingOnly.elem, loadingThreads.elem);
            }
            object = BoxesRunTime.boxToBoolean((boolean)l.updateLastChecked((String)resourceUid.elem, l.updateLastChecked$default$2()));
        } else {
            object = BoxedUnit.UNIT;
        }
        Config$.MODULE$.persistenceManager().shutdown();
    }

    private DwCALoader$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.IMAGE_TYPE = GbifTerm.Image;
        this.MULTIMEDIA_TYPE = GbifTerm.Multimedia;
    }
}

