/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.export;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.export.DwCAExporter;
import au.org.ala.biocache.export.DwCAExporter$;
import au.org.ala.biocache.util.Json$;
import au.org.ala.biocache.util.OptionParser;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;
import scala.util.parsing.json.JSON$;

public final class DwCAExporter$
implements Tool {
    public static final DwCAExporter$ MODULE$;
    private final Logger logger;
    private final Regex dataResourcePattern;

    static {
        new DwCAExporter$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "export-dwca";
    }

    @Override
    public String desc() {
        return "Export Darwin Core Archive for a data resource";
    }

    public Logger logger() {
        return this.logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void main(String[] args) {
        BooleanRef exportExtensions;
        BooleanRef addImagesToExisting;
        IntRef pageSize;
        IntRef threads;
        ObjectRef directory;
        ObjectRef resourceUid;
        ObjectRef dwcFieldsMap = new ObjectRef((Object)((LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"rowkey"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"abcdIdentificationQualifier"), (Object)"http://rs.tdwg.org/abcd/terms/abcdIdentificationQualifier"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"abcdIdentificationQualifierInsertionPoint"), (Object)"http://rs.tdwg.org/abcd/terms/abcdIdentificationQualifierInsertionPoint"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"abcdTypeStatus"), (Object)"http://rs.tdwg.org/abcd/terms/abcdTypeStatus"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"acceptedNameUsage"), (Object)"http://rs.tdwg.org/dwc/terms/acceptedNameUsage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"acceptedNameUsageID"), (Object)"http://rs.tdwg.org/dwc/terms/acceptedNameUsageID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"accessRights"), (Object)"http://purl.org/dc/terms/accessRights"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"associatedMedia"), (Object)"http://rs.tdwg.org/dwc/terms/associatedMedia"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"associatedOccurrences"), (Object)"http://rs.tdwg.org/dwc/terms/associatedOccurrences"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"associatedReferences"), (Object)"http://rs.tdwg.org/dwc/terms/associatedReferences"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"associatedSequences"), (Object)"http://rs.tdwg.org/dwc/terms/associatedSequences"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"associatedTaxa"), (Object)"http://rs.tdwg.org/dwc/terms/associatedTaxa"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"basisOfRecord"), (Object)"http://rs.tdwg.org/dwc/terms/basisOfRecord"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"behavior"), (Object)"http://rs.tdwg.org/dwc/terms/behavior"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"bibliographicCitation"), (Object)"http://purl.org/dc/terms/bibliographicCitation"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"catalogNumber"), (Object)"http://rs.tdwg.org/dwc/terms/catalogNumber"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"class"), (Object)"http://rs.tdwg.org/dwc/terms/class"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"collectionCode"), (Object)"http://rs.tdwg.org/dwc/terms/collectionCode"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"collectionID"), (Object)"http://rs.tdwg.org/dwc/terms/collectionID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"continent"), (Object)"http://rs.tdwg.org/dwc/terms/continent"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"coordinatePrecision"), (Object)"http://rs.tdwg.org/dwc/terms/coordinatePrecision"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"coordinateUncertaintyInMeters"), (Object)"http://rs.tdwg.org/dwc/terms/coordinateUncertaintyInMeters"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"country"), (Object)"http://rs.tdwg.org/dwc/terms/country"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"countryCode"), (Object)"http://rs.tdwg.org/dwc/terms/countryCode"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"county"), (Object)"http://rs.tdwg.org/dwc/terms/county"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"dataGeneralizations"), (Object)"http://rs.tdwg.org/dwc/terms/dataGeneralizations"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"datasetID"), (Object)"http://rs.tdwg.org/dwc/terms/datasetID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"datasetName"), (Object)"http://rs.tdwg.org/dwc/terms/datasetName"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"dateIdentified"), (Object)"http://rs.tdwg.org/dwc/terms/dateIdentified"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"day"), (Object)"http://rs.tdwg.org/dwc/terms/day"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"decimalLatitude"), (Object)"http://rs.tdwg.org/dwc/terms/decimalLatitude"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"decimalLongitude"), (Object)"http://rs.tdwg.org/dwc/terms/decimalLongitude"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"disposition"), (Object)"http://rs.tdwg.org/dwc/terms/disposition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"dynamicProperties"), (Object)"http://rs.tdwg.org/dwc/terms/dynamicProperties"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"easting"), (Object)"http://rs.ala.org.au/terms/1.0/easting"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"endDayOfYear"), (Object)"http://rs.tdwg.org/dwc/terms/endDayOfYear"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"establishmentMeans"), (Object)"http://rs.tdwg.org/dwc/terms/establishmentMeans"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"eventAttributes"), (Object)"http://rs.tdwg.org/dwc/terms/eventAttributes"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"eventDate"), (Object)"http://rs.tdwg.org/dwc/terms/eventDate"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"eventID"), (Object)"http://rs.tdwg.org/dwc/terms/eventID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"eventRemarks"), (Object)"http://rs.tdwg.org/dwc/terms/eventRemarks"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"eventTime"), (Object)"http://rs.tdwg.org/dwc/terms/eventTime"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"family"), (Object)"http://rs.tdwg.org/dwc/terms/family"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"fieldNotes"), (Object)"http://rs.tdwg.org/dwc/terms/fieldNotes"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"fieldNumber"), (Object)"http://rs.tdwg.org/dwc/terms/fieldNumber"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"footprintSpatialFit"), (Object)"http://rs.tdwg.org/dwc/terms/footprintSpatialFit"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"footprintSRS"), (Object)"http://rs.tdwg.org/dwc/terms/footprintSRS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"footprintWKT"), (Object)"http://rs.tdwg.org/dwc/terms/footprintWKT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"genus"), (Object)"http://rs.tdwg.org/dwc/terms/genus"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"geodeticDatum"), (Object)"http://rs.tdwg.org/dwc/terms/geodeticDatum"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"georeferencedBy"), (Object)"http://rs.tdwg.org/dwc/terms/georeferencedBy"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"georeferencedDate"), (Object)"http://rs.tdwg.org/dwc/terms/georeferencedDate"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"georeferenceProtocol"), (Object)"http://rs.tdwg.org/dwc/terms/georeferenceProtocol"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"georeferenceRemarks"), (Object)"http://rs.tdwg.org/dwc/terms/georeferenceRemarks"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"georeferenceSources"), (Object)"http://rs.tdwg.org/dwc/terms/georeferenceSources"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"georeferenceVerificationStatus"), (Object)"http://rs.tdwg.org/dwc/terms/georeferenceVerificationStatus"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"habitat"), (Object)"http://rs.tdwg.org/dwc/terms/habitat"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"higherClassification"), (Object)"http://rs.tdwg.org/dwc/terms/higherClassification"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"higherGeography"), (Object)"http://rs.tdwg.org/dwc/terms/higherGeography"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"higherGeographyID"), (Object)"http://rs.tdwg.org/dwc/terms/higherGeographyID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"identificationID"), (Object)"http://rs.tdwg.org/dwc/terms/identificationID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"identificationQualifier"), (Object)"http://rs.tdwg.org/dwc/terms/identificationQualifier"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"identificationReferences"), (Object)"http://rs.tdwg.org/dwc/terms/identificationReferences"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"identificationRemarks"), (Object)"http://rs.tdwg.org/dwc/terms/identificationRemarks"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"identificationVerificationStatus"), (Object)"http://rs.tdwg.org/dwc/terms/identificationVerificationStatus"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"identifiedBy"), (Object)"http://rs.tdwg.org/dwc/terms/identifiedBy"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"identifierRole"), (Object)"http://hiscom.chah.org.au/hispid/terms/identifierRole"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"individualCount"), (Object)"http://rs.tdwg.org/dwc/terms/individualCount"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"individualID"), (Object)"http://rs.tdwg.org/dwc/terms/individualID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"informationWithheld"), (Object)"http://rs.tdwg.org/dwc/terms/informationWithheld"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"infraspecificEpithet"), (Object)"http://rs.tdwg.org/dwc/terms/infraspecificEpithet"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"institutionCode"), (Object)"http://rs.tdwg.org/dwc/terms/institutionCode"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"institutionID"), (Object)"http://rs.tdwg.org/dwc/terms/institutionID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"island"), (Object)"http://rs.tdwg.org/dwc/terms/island"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"islandGroup"), (Object)"http://rs.tdwg.org/dwc/terms/islandGroup"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"kingdom"), (Object)"http://rs.tdwg.org/dwc/terms/kingdom"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"language"), (Object)"http://purl.org/dc/terms/language"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"license"), (Object)"http://purl.org/dc/terms/license"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lifeStage"), (Object)"http://rs.tdwg.org/dwc/terms/lifeStage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"loanDate"), (Object)"http://data.ggbn.org/schemas/ggbn/terms/loanDate"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"loanDestination"), (Object)"http://data.ggbn.org/schemas/ggbn/terms/loanDestination"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"loanIdentifier"), (Object)"http://data.ggbn.org/schemas/ggbn/terms/loanIdentifier"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"locality"), (Object)"http://rs.tdwg.org/dwc/terms/locality"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"locationAccordingTo"), (Object)"http://rs.tdwg.org/dwc/terms/locationAccordingTo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"locationAttributes"), (Object)"http://rs.tdwg.org/dwc/terms/locationAttributes"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"locationID"), (Object)"http://rs.tdwg.org/dwc/terms/locationID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"locationRemarks"), (Object)"http://rs.tdwg.org/dwc/terms/locationRemarks"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"maximumDepthInMeters"), (Object)"http://rs.tdwg.org/dwc/terms/maximumDepthInMeters"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"maximumDistanceAboveSurfaceInMeters"), (Object)"http://rs.tdwg.org/dwc/terms/maximumDistanceAboveSurfaceInMeters"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"maximumElevationInMeters"), (Object)"http://rs.tdwg.org/dwc/terms/maximumElevationInMeters"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"measurementAccuracy"), (Object)"http://rs.tdwg.org/dwc/terms/measurementAccuracy"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"measurementDeterminedBy"), (Object)"http://rs.tdwg.org/dwc/terms/measurementDeterminedBy"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"measurementDeterminedDate"), (Object)"http://rs.tdwg.org/dwc/terms/measurementDeterminedDate"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"measurementID"), (Object)"http://rs.tdwg.org/dwc/terms/measurementID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"measurementMethod"), (Object)"http://rs.tdwg.org/dwc/terms/measurementMethod"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"measurementRemarks"), (Object)"http://rs.tdwg.org/dwc/terms/measurementRemarks"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"measurementType"), (Object)"http://rs.tdwg.org/dwc/terms/measurementType"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"measurementUnit"), (Object)"http://rs.tdwg.org/dwc/terms/measurementUnit"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"measurementValue"), (Object)"http://rs.tdwg.org/dwc/terms/measurementValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"minimumDepthInMeters"), (Object)"http://rs.tdwg.org/dwc/terms/minimumDepthInMeters"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"minimumDistanceAboveSurfaceInMeters"), (Object)"http://rs.tdwg.org/dwc/terms/minimumDistanceAboveSurfaceInMeters"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"minimumElevationInMeters"), (Object)"http://rs.tdwg.org/dwc/terms/minimumElevationInMeters"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"modified"), (Object)"http://purl.org/dc/terms/modified"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"month"), (Object)"http://rs.tdwg.org/dwc/terms/month"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"municipality"), (Object)"http://rs.tdwg.org/dwc/terms/municipality"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"nameAccordingTo"), (Object)"http://rs.tdwg.org/dwc/terms/nameAccordingTo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"nameAccordingToID"), (Object)"http://rs.tdwg.org/dwc/terms/nameAccordingToID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"namePublishedIn"), (Object)"http://rs.tdwg.org/dwc/terms/namePublishedIn"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"namePublishedInID"), (Object)"http://rs.tdwg.org/dwc/terms/namePublishedInID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"namePublishedInYear"), (Object)"http://rs.tdwg.org/dwc/terms/namePublishedInYear"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"nomenclaturalCode"), (Object)"http://rs.tdwg.org/dwc/terms/nomenclaturalCode"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"nomenclaturalStatus"), (Object)"http://rs.tdwg.org/dwc/terms/nomenclaturalStatus"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"northing"), (Object)"http://rs.ala.org.au/terms/1.0/northing"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"occurrenceAttributes"), (Object)"http://rs.tdwg.org/dwc/terms/occurrenceAttributes"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"occurrenceDetails"), (Object)"http://rs.tdwg.org/dwc/terms/occurrenceDetails"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"occurrenceID"), (Object)"http://rs.tdwg.org/dwc/terms/occurrenceID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"occurrenceRemarks"), (Object)"http://rs.tdwg.org/dwc/terms/occurrenceRemarks"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"occurrenceStatus"), (Object)"http://rs.tdwg.org/dwc/terms/occurrenceStatus"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"order"), (Object)"http://rs.tdwg.org/dwc/terms/order"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"organismQuantity"), (Object)"http://rs.tdwg.org/dwc/terms/organismQuantity"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"organismQuantityType"), (Object)"http://rs.tdwg.org/dwc/terms/organismQuantityType"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"originalNameUsage"), (Object)"http://rs.tdwg.org/dwc/terms/originalNameUsage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"originalNameUsageID"), (Object)"http://rs.tdwg.org/dwc/terms/originalNameUsageID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"otherCatalogNumbers"), (Object)"http://rs.tdwg.org/dwc/terms/otherCatalogNumbers"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"ownerInstitutionCode"), (Object)"http://rs.tdwg.org/dwc/terms/ownerInstitutionCode"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"parentNameUsage"), (Object)"http://rs.tdwg.org/dwc/terms/parentNameUsage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"parentNameUsageID"), (Object)"http://rs.tdwg.org/dwc/terms/parentNameUsageID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"phylum"), (Object)"http://rs.tdwg.org/dwc/terms/phylum"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"pointRadiusSpatialFit"), (Object)"http://rs.tdwg.org/dwc/terms/pointRadiusSpatialFit"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"preparations"), (Object)"http://rs.tdwg.org/dwc/terms/preparations"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"previousIdentifications"), (Object)"http://rs.tdwg.org/dwc/terms/previousIdentifications"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"photographer"), (Object)"http://rs.ala.org.au/terms/1.0/photographer"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"recordedBy"), (Object)"http://rs.tdwg.org/dwc/terms/recordedBy"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"recordNumber"), (Object)"http://rs.tdwg.org/dwc/terms/recordNumber"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"relatedResourceID"), (Object)"http://rs.tdwg.org/dwc/terms/relatedResourceID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"relationshipAccordingTo"), (Object)"http://rs.tdwg.org/dwc/terms/relationshipAccordingTo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"relationshipEstablishedDate"), (Object)"http://rs.tdwg.org/dwc/terms/relationshipEstablishedDate"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"relationshipOfResource"), (Object)"http://rs.tdwg.org/dwc/terms/relationshipOfResource"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"relationshipRemarks"), (Object)"http://rs.tdwg.org/dwc/terms/relationshipRemarks"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"reproductiveCondition"), (Object)"http://rs.tdwg.org/dwc/terms/reproductiveCondition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"resourceID"), (Object)"http://rs.tdwg.org/dwc/terms/resourceID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"resourceRelationshipID"), (Object)"http://rs.tdwg.org/dwc/terms/resourceRelationshipID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"rights"), (Object)"http://purl.org/dc/terms/rights"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"rightsHolder"), (Object)"http://purl.org/dc/terms/rightsHolder"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"samplingEffort"), (Object)"http://rs.tdwg.org/dwc/terms/samplingEffort"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"samplingProtocol"), (Object)"http://rs.tdwg.org/dwc/terms/samplingProtocol"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"scientificName"), (Object)"http://rs.tdwg.org/dwc/terms/scientificName"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"scientificNameAuthorship"), (Object)"http://rs.tdwg.org/dwc/terms/scientificNameAuthorship"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"scientificNameID"), (Object)"http://rs.tdwg.org/dwc/terms/scientificNameID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"secondaryCollectors"), (Object)"http://hiscom.chah.org.au/hispid/terms/secondaryCollectors"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"sex"), (Object)"http://rs.tdwg.org/dwc/terms/sex"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"source"), (Object)"http://purl.org/dc/terms/source"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"species"), (Object)"http://rs.ala.org.au/terms/1.0/species"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"specificEpithet"), (Object)"http://rs.tdwg.org/dwc/terms/specificEpithet"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"startDayOfYear"), (Object)"http://rs.tdwg.org/dwc/terms/startDayOfYear"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"stateProvince"), (Object)"http://rs.tdwg.org/dwc/terms/stateProvince"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"subgenus"), (Object)"http://rs.tdwg.org/dwc/terms/subgenus"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"subfamily"), (Object)"http://rs.ala.org.au/terms/1.0/subfamily"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"subspecies"), (Object)"http://rs.ala.org.au/terms/1.0/subspecies"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"superfamily"), (Object)"http://rs.ala.org.au/terms/1.0/superfamily"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"taxonConceptID"), (Object)"http://rs.tdwg.org/dwc/terms/taxonConceptID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"taxonID"), (Object)"http://rs.tdwg.org/dwc/terms/taxonID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"taxonomicStatus"), (Object)"http://rs.tdwg.org/dwc/terms/taxonomicStatus"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"taxonRank"), (Object)"http://rs.tdwg.org/dwc/terms/taxonRank"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"taxonRemarks"), (Object)"http://rs.tdwg.org/dwc/terms/taxonRemarks"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"type"), (Object)"http://purl.org/dc/terms/type"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"typeStatus"), (Object)"http://rs.tdwg.org/dwc/terms/typeStatus"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"typifiedName"), (Object)"http://rs.tdwg.org/abcd/terms/typifiedName"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"userId"), (Object)"http://rs.gbif.org/terms/1.0/recordedByID"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"verbatimCoordinates"), (Object)"http://rs.tdwg.org/dwc/terms/verbatimCoordinates"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"verbatimCoordinateSystem"), (Object)"http://rs.tdwg.org/dwc/terms/verbatimCoordinateSystem"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"verbatimDepth"), (Object)"http://rs.tdwg.org/dwc/terms/verbatimDepth"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"verbatimElevation"), (Object)"http://rs.tdwg.org/dwc/terms/verbatimElevation"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"verbatimEventDate"), (Object)"http://rs.tdwg.org/dwc/terms/verbatimEventDate"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"verbatimLatitude"), (Object)"http://rs.tdwg.org/dwc/terms/verbatimLatitude"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"verbatimLocality"), (Object)"http://rs.tdwg.org/dwc/terms/verbatimLocality"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"verbatimLongitude"), (Object)"http://rs.tdwg.org/dwc/terms/verbatimLongitude"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"verbatimSRS"), (Object)"http://rs.tdwg.org/dwc/terms/verbatimSRS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"verbatimTaxonRank"), (Object)"http://rs.tdwg.org/dwc/terms/verbatimTaxonRank"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"vernacularName"), (Object)"http://rs.tdwg.org/dwc/terms/vernacularName"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"waterBody"), (Object)"http://rs.tdwg.org/dwc/terms/waterBody"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"year"), (Object)"http://rs.tdwg.org/dwc/terms/year"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"zone"), (Object)"http://rs.ala.org.au/terms/1.0/zone")}))));
        OptionParser parser = new OptionParser(dwcFieldsMap, resourceUid = new ObjectRef((Object)""), directory = new ObjectRef((Object)""), threads = new IntRef(4), pageSize = new IntRef(1000), addImagesToExisting = new BooleanRef(false), exportExtensions = new BooleanRef(false)){
            {
                this.arg("data-resource-uid", "Comma separated list of DRs or 'all' to generate for all", (Function1<String, BoxedUnit>)new Serializable(this, resourceUid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef resourceUid$1;

                    public final void apply(String v) {
                        this.resourceUid$1.elem = v;
                    }
                    {
                        this.resourceUid$1 = resourceUid$1;
                    }
                });
                this.arg("directory-to-dump", "Directory to place the created archives", (Function1<String, BoxedUnit>)new Serializable(this, directory$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef directory$1;

                    public final void apply(String v) {
                        this.directory$1.elem = v;
                    }
                    {
                        this.directory$1 = directory$1;
                    }
                });
                this.opt("f", "fields", new StringBuilder().append((Object)"Comma separated list of DwC fields to export (according to cassandra DB). Default is :").append((Object)((LinkedHashMap)dwcFieldsMap$1.elem).keySet()).toString(), (Function1<String, BoxedUnit>)new Serializable(this, dwcFieldsMap$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef dwcFieldsMap$1;

                    public final void apply(String v) {
                        List fields = Predef$.MODULE$.refArrayOps((Object[])v.split(",")).toList();
                        this.dwcFieldsMap$1.elem = (LinkedHashMap)((LinkedHashMap)this.dwcFieldsMap$1.elem).filter((Function1)new Serializable(this, fields){
                            public static final long serialVersionUID = 0L;
                            private final List fields$1;

                            public final boolean apply(Tuple2<String, String> field) {
                                return this.fields$1.contains(field._1());
                            }
                            {
                                this.fields$1 = fields$1;
                            }
                        });
                    }
                    {
                        this.dwcFieldsMap$1 = dwcFieldsMap$1;
                    }
                });
                this.intOpt("t", "thread", new StringBuilder().append((Object)"The number of threads to use. Default is ").append((Object)BoxesRunTime.boxToInteger((int)threads$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, threads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threads$1.elem = v;
                    }
                    {
                        this.threads$1 = threads$1;
                    }
                });
                this.intOpt("ps", "pageSize", new StringBuilder().append((Object)"The pageSize to use. Default is ").append((Object)BoxesRunTime.boxToInteger((int)pageSize$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, pageSize$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef pageSize$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.pageSize$1.elem = v;
                    }
                    {
                        this.pageSize$1 = pageSize$1;
                    }
                });
                this.booleanOpt("export-extensions", "Export extensions too.", (Function1<Object, BoxedUnit>)new Serializable(this, exportExtensions$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef exportExtensions$1;

                    public final void apply(boolean v) {
                        this.exportExtensions$1.elem = v;
                    }
                    {
                        this.exportExtensions$1 = exportExtensions$1;
                    }
                });
                this.booleanOpt("add-images-to-existing-only", "Add images to existing archives.", (Function1<Object, BoxedUnit>)new Serializable(this, addImagesToExisting$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef addImagesToExisting$1;

                    public final void apply(boolean v) {
                        this.addImagesToExisting$1.elem = v;
                    }
                    {
                        this.addImagesToExisting$1 = addImagesToExisting$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            DwCAExporter dwcc = new DwCAExporter((LinkedHashMap<String, String>)((LinkedHashMap)dwcFieldsMap.elem));
            if (addImagesToExisting.elem) {
                dwcc.addImageExportsToArchives((String)directory.elem);
            } else {
                try {
                    String string = (String)resourceUid.elem;
                    String string2 = "all";
                    List resourceIDs = !(string != null ? !string.equals(string2) : string2 != null) ? this.getDataResourceUids() : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((String)resourceUid.elem).split(",")).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String x$4) {
                            return x$4.trim();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toList();
                    Map dataResource2OutputStreams = ((TraversableOnce)resourceIDs.map((Function1)new Serializable(directory, dwcc){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef directory$1;
                        private final DwCAExporter dwcc$1;

                        public final Tuple2<String, Option<Tuple2<ZipOutputStream, CSVWriter>>> apply(String uid) {
                            return new Tuple2((Object)uid, this.dwcc$1.createOutputForCSV((String)this.directory$1.elem, uid));
                        }
                        {
                            this.directory$1 = directory$1;
                            this.dwcc$1 = dwcc$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                    Config$.MODULE$.persistenceManager().pageOverSelect("occ", (Function2<String, Map<String, String>, Object>)new Serializable(dwcFieldsMap, (Seq)resourceIDs, dataResource2OutputStreams){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef dwcFieldsMap$1;
                        private final Seq resourceIDs$1;
                        private final Map dataResource2OutputStreams$1;

                        public final boolean apply(String key, Map<String, String> map) {
                            DwCAExporter$ dwCAExporter$ = DwCAExporter$.MODULE$;
                            synchronized (dwCAExporter$) {
                                DwCAExporter$.MODULE$.au$org$ala$biocache$export$DwCAExporter$$writeCsvRow$1(this.resourceIDs$1, this.dataResource2OutputStreams$1, map, this.dwcFieldsMap$1);
                                return true;
                            }
                        }
                        {
                            this.dwcFieldsMap$1 = dwcFieldsMap$1;
                            this.resourceIDs$1 = resourceIDs$1;
                            this.dataResource2OutputStreams$1 = dataResource2OutputStreams$1;
                        }
                    }, pageSize.elem, threads.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                    dataResource2OutputStreams.values().foreach((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Option<Tuple2<ZipOutputStream, CSVWriter>> zopAndCsv) {
                            if (!zopAndCsv.isEmpty()) {
                                ((DeflaterOutputStream)((Tuple2)zopAndCsv.get())._1()).flush();
                                ((ZipOutputStream)((Tuple2)zopAndCsv.get())._1()).closeEntry();
                                ((ZipOutputStream)((Tuple2)zopAndCsv.get())._1()).close();
                            }
                        }
                    });
                    if (exportExtensions.elem) {
                        dwcc.addImageExportsToArchives((String)directory.elem);
                    }
                }
                catch (Exception exception) {
                    this.logger().error(exception.getMessage(), (Throwable)exception);
                    throw new RuntimeException(exception);
                }
            }
        }
        Config$.MODULE$.persistenceManager().shutdown();
    }

    public String cleanValue(String input) {
        return input == null ? "" : input.replaceAll("[\\t\\n\\r]", " ").trim();
    }

    public Regex dataResourcePattern() {
        return this.dataResourcePattern;
    }

    public Seq<String> getDataResourceUids() {
        String url = new StringBuilder().append((Object)Config$.MODULE$.biocacheServiceUrl()).append((Object)"/occurrences/search?q=*:*&facets=data_resource_uid&pageSize=0&flimit=-1").toString();
        String jsonString = Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
        Map json = (Map)JSON$.MODULE$.parseFull(jsonString).get();
        List results = (List)((MapLike)((List)json.get((Object)"facetResults").get()).head()).get((Object)"fieldResult").get();
        return (Seq)((TraversableLike)results.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Map<String, String> facet) {
                String fq = (String)facet.get((Object)"fq").get();
                return DwCAExporter$.MODULE$.parseFq(fq);
            }
        }, List$.MODULE$.canBuildFrom())).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$5) {
                return x$5.equals("Unknown");
            }
        });
    }

    public String parseFq(String fq) {
        String dr;
        String string = fq;
        Option option = this.dataResourcePattern().unapplySeq((Object)string);
        String string2 = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 ? (dr = (String)((LinearSeqOptimized)option.get()).apply(0)) : "Unknown";
        return string2;
    }

    private final Tuple2 extractOriginalSensitiveProperties$1(ObjectRef dwcFieldsMap$1, Map map$1) {
        Tuple2 tuple2;
        if (((String)map$1.getOrElse((Object)"originalSensitiveValues", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).isEmpty()) {
            tuple2 = new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)Predef$.MODULE$.Map().empty());
        } else {
            Map json = (Map)JSON$.MODULE$.parseFull((String)map$1.getOrElse((Object)"originalSensitiveValues", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            })).get();
            ObjectRef originalMiscProperties = new ObjectRef((Object)new HashMap());
            ObjectRef originalProperties = new ObjectRef((Object)new HashMap());
            json.filterKeys((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String k) {
                    return !k.endsWith("_p");
                }
            }).foreach((Function1)new Serializable(dwcFieldsMap$1, originalMiscProperties, originalProperties){
                public static final long serialVersionUID = 0L;
                private final ObjectRef dwcFieldsMap$1;
                private final ObjectRef originalMiscProperties$1;
                private final ObjectRef originalProperties$1;

                public final HashMap<String, String> apply(Tuple2<String, String> originalTerm) {
                    return ((LinkedHashMap)this.dwcFieldsMap$1.elem).contains(originalTerm._1()) ? ((HashMap)this.originalProperties$1.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(originalTerm._1()), originalTerm._2())) : ((HashMap)this.originalMiscProperties$1.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(originalTerm._1()), originalTerm._2()));
                }
                {
                    this.dwcFieldsMap$1 = dwcFieldsMap$1;
                    this.originalMiscProperties$1 = originalMiscProperties$1;
                    this.originalProperties$1 = originalProperties$1;
                }
            });
            tuple2 = new Tuple2((Object)((HashMap)originalProperties.elem).toMap(Predef$.MODULE$.conforms()), (Object)((HashMap)originalMiscProperties.elem).toMap(Predef$.MODULE$.conforms()));
        }
        return tuple2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void au$org$ala$biocache$export$DwCAExporter$$writeCsvRow$1(Seq resourceIDs, Map dataResource2OutputStreams, Map map, ObjectRef dwcFieldsMap$1) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        Option dataResourceMap;
        String dr = (String)map.getOrElse((Object)"dataResourceUid", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        String dateDeleted = (String)map.getOrElse((Object)"dateDeleted", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        if (dr.isEmpty() || !resourceIDs.contains((Object)dr) || !dateDeleted.isEmpty() || (dataResourceMap = dataResource2OutputStreams.get((Object)dr)).isEmpty() || ((Option)dataResourceMap.get()).isEmpty()) return;
        Tuple2 tuple23 = (Tuple2)((Option)dataResourceMap.get()).get();
        if (tuple23 == null) throw new MatchError((Object)tuple23);
        ZipOutputStream zop = (ZipOutputStream)tuple23._1();
        CSVWriter csv = (CSVWriter)tuple23._2();
        Tuple2 tuple24 = tuple22 = new Tuple2((Object)zop, (Object)csv);
        ZipOutputStream zop2 = (ZipOutputStream)tuple24._1();
        CSVWriter csv2 = (CSVWriter)tuple24._2();
        Tuple2 tuple25 = this.extractOriginalSensitiveProperties$1(dwcFieldsMap$1, map);
        if (tuple25 == null) throw new MatchError((Object)tuple25);
        Map originalProperties = (Map)tuple25._1();
        Map originalMiscProperties = (Map)tuple25._2();
        Tuple2 tuple26 = tuple2 = new Tuple2((Object)originalProperties, (Object)originalMiscProperties);
        Map originalProperties2 = (Map)tuple26._1();
        Map originalMiscProperties2 = (Map)tuple26._2();
        Map resultMap = (Map)((TraversableLike)((TraversableLike)map.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x$3) {
                return x$3._2() != null;
            }
        })).map((Function1)new Serializable(map, originalProperties2, originalMiscProperties2){
            public static final long serialVersionUID = 0L;
            public final Map map$1;
            private final Map originalProperties$2;
            private final Map originalMiscProperties$2;

            public final Tuple2<String, String> apply(Tuple2<String, String> entry) {
                Tuple2 tuple2;
                String string;
                String string2 = string = (String)entry._1();
                if (!("class" != null ? !"class".equals(string2) : string2 != null)) {
                    tuple2 = new Tuple2(entry._1(), this.originalProperties$2.getOrElse(entry._1(), (Function0)new Serializable(this, entry){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.7 $outer;
                        private final Tuple2 entry$1;

                        public final String apply() {
                            return ((String)this.entry$1._2()).isEmpty() ? (((String)this.$outer.map$1.getOrElse((Object)"classs", (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "";
                                }
                            })).isEmpty() ? (String)this.$outer.map$1.getOrElse((Object)"_class", (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "";
                                }
                            }) : (String)this.$outer.map$1.getOrElse((Object)"classs", (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "";
                                }
                            })) : (String)this.entry$1._2();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.entry$1 = entry$1;
                        }
                    }));
                } else {
                    String string3 = string;
                    if (!("identifiedBy" != null ? !"identifiedBy".equals(string3) : string3 != null)) {
                        tuple2 = new Tuple2(entry._1(), this.originalProperties$2.getOrElse(entry._1(), (Function0)new Serializable(this, entry){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.7 $outer;
                            private final Tuple2 entry$1;

                            public final String apply() {
                                return ((String)this.entry$1._2()).isEmpty() ? (String)this.$outer.map$1.getOrElse((Object)"identifierBy", (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }) : (String)this.entry$1._2();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.entry$1 = entry$1;
                            }
                        }));
                    } else {
                        String string4 = string;
                        if (!("miscProperties" != null ? !"miscProperties".equals(string4) : string4 != null)) {
                            Tuple2 tuple22;
                            if (this.originalMiscProperties$2.isEmpty()) {
                                tuple22 = new Tuple2((Object)"dynamicProperties", entry._2());
                            } else {
                                Map miscProperties = (Map)JSON$.MODULE$.parseFull((String)this.map$1.getOrElse((Object)"miscProperties", (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                })).get();
                                tuple22 = new Tuple2((Object)"dynamicProperties", (Object)Json$.MODULE$.toJSON((Map<String, Object>)miscProperties.$plus$plus((GenTraversableOnce)this.originalMiscProperties$2)));
                            }
                            tuple2 = tuple22;
                        } else {
                            tuple2 = new Tuple2(entry._1(), this.originalProperties$2.getOrElse(entry._1(), (Function0)new Serializable(this, entry){
                                public static final long serialVersionUID = 0L;
                                private final Tuple2 entry$1;

                                public final String apply() {
                                    return (String)this.entry$1._2();
                                }
                                {
                                    this.entry$1 = entry$1;
                                }
                            }));
                        }
                    }
                }
                return tuple2;
            }
            {
                this.map$1 = map$1;
                this.originalProperties$2 = originalProperties$2;
                this.originalMiscProperties$2 = originalMiscProperties$2;
            }
        }, Map$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(dwcFieldsMap$1){
            public static final long serialVersionUID = 0L;
            private final ObjectRef dwcFieldsMap$1;

            public final boolean apply(Tuple2<String, String> term) {
                return ((LinkedHashMap)this.dwcFieldsMap$1.elem).contains(term._1());
            }
            {
                this.dwcFieldsMap$1 = dwcFieldsMap$1;
            }
        });
        String[] row = (String[])((TraversableOnce)((LinkedHashMap)dwcFieldsMap$1.elem).map((Function1)new Serializable(resultMap){
            public static final long serialVersionUID = 0L;
            private final Map resultMap$1;

            public final String apply(Tuple2<String, String> fieldMap) {
                return DwCAExporter$.MODULE$.cleanValue((String)this.resultMap$1.getOrElse(fieldMap._1(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
            }
            {
                this.resultMap$1 = resultMap$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        DwCAExporter$ dwCAExporter$ = this;
        synchronized (dwCAExporter$) {
            csv2.writeNext(row);
            csv2.flush();
            return;
        }
    }

    private DwCAExporter$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"DwCAExporter");
        this.dataResourcePattern = new StringOps(Predef$.MODULE$.augmentString("(?:[\"]*)?(?:[a-z_]*_uid:\")([a-z0-9]*)(?:[\"]*)?")).r();
    }
}

