/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.index.IndexDAO;
import au.org.ala.biocache.index.IndexRecords$;
import au.org.ala.biocache.tool.ProcessRecords$;
import au.org.ala.biocache.util.OptionParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class ReprocessIndexSelect$
implements Tool {
    public static final ReprocessIndexSelect$ MODULE$;

    static {
        new ReprocessIndexSelect$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "index-query";
    }

    @Override
    public String desc() {
        return "Reindex the records that match a query";
    }

    @Override
    public void main(String[] args) {
        ObjectRef query = new ObjectRef((Object)None$.MODULE$);
        IntRef threads = new IntRef(4);
        BooleanRef exist = new BooleanRef(false);
        BooleanRef indexOnly = new BooleanRef(false);
        ObjectRef startUuid = new ObjectRef((Object)None$.MODULE$);
        OptionParser parser = new OptionParser(query, threads, exist, indexOnly, startUuid){
            {
                this.opt("q", "query", "The query to run e.g. 'year:[2001 TO *]' or 'taxon_name:Macropus'", (Function1<String, BoxedUnit>)new Serializable(this, query$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef query$1;

                    public final void apply(String v) {
                        this.query$1.elem = new Some((Object)v);
                    }
                    {
                        this.query$1 = query$1;
                    }
                });
                this.intOpt("t", "thread", "The number of threads to use", (Function1<Object, BoxedUnit>)new Serializable(this, threads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threads$1.elem = v;
                    }
                    {
                        this.threads$1 = threads$1;
                    }
                });
                this.opt("exist", "use the existing list of row keys", (Function0<BoxedUnit>)new Serializable(this, exist$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef exist$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.exist$1.elem = true;
                    }
                    {
                        this.exist$1 = exist$1;
                    }
                });
                this.opt("s", "start", "The record to start processing with", (Function1<String, BoxedUnit>)new Serializable(this, startUuid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef startUuid$1;

                    public final void apply(String v) {
                        this.startUuid$1.elem = new Some((Object)v);
                    }
                    {
                        this.startUuid$1 = startUuid$1;
                    }
                });
                this.opt("index", "reindex only - do not reprocess", (Function0<BoxedUnit>)new Serializable(this, indexOnly$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef indexOnly$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.indexOnly$1.elem = true;
                    }
                    {
                        this.indexOnly$1 = indexOnly$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            if (((Option)query.elem).isEmpty()) {
                parser.showUsage();
            } else {
                this.reprocessIndex((String)((Option)query.elem).get(), threads.elem, exist.elem, (Option<String>)((Option)startUuid.elem), indexOnly.elem);
            }
        }
    }

    public void reprocessIndex(String query, int threads, boolean exist, Option<String> startUuid, boolean indexOnly) {
        IndexDAO indexer = (IndexDAO)Config$.MODULE$.getInstance(IndexDAO.class);
        File file = new File(new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/reprocess_index_rowkeys.out").toString());
        if (!exist) {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            indexer.writeRowKeysToStream(query, out);
            out.flush();
            out.close();
        }
        if (!indexOnly) {
            ProcessRecords$.MODULE$.processFileOfRowKeys(file, threads);
        }
        IndexRecords$.MODULE$.indexList(file, IndexRecords$.MODULE$.indexList$default$2());
    }

    private ReprocessIndexSelect$() {
        MODULE$ = this;
        Tool$class.$init$(this);
    }
}

