/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.qa;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.biocache.Config$;
import au.org.ala.biocache.util.OptionParser;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.ErrorCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.input.BOMInputStream;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class LoadBulkQas$ {
    public static final LoadBulkQas$ MODULE$;

    static {
        new LoadBulkQas$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void main(String[] args) {
        PostMethod post;
        String[] headers;
        ObjectRef filename = new ObjectRef((Object)"");
        ObjectRef userId = new ObjectRef((Object)"");
        ObjectRef userDisplayName = new ObjectRef((Object)"");
        OptionParser parser = new OptionParser(filename, userId, userDisplayName){
            {
                this.arg("<filename>", "The absolute path to the CSV file that should be loaded as a bulk annotation. Relies on file structure: recordUuid, assertionType, comment", (Function1<String, BoxedUnit>)new Serializable(this, filename$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef filename$1;

                    public final void apply(String v) {
                        this.filename$1.elem = v;
                    }
                    {
                        this.filename$1 = filename$1;
                    }
                });
                this.arg("<userId>", "The id for the user to apply the assertions for", (Function1<String, BoxedUnit>)new Serializable(this, userId$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef userId$1;

                    public final void apply(String v) {
                        this.userId$1.elem = v;
                    }
                    {
                        this.userId$1 = userId$1;
                    }
                });
                this.arg("<display name>", "The display name for the user.", (Function1<String, BoxedUnit>)new Serializable(this, userDisplayName$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef userDisplayName$1;

                    public final void apply(String v) {
                        this.userDisplayName$1.elem = v;
                    }
                    {
                        this.userDisplayName$1 = userDisplayName$1;
                    }
                });
            }
        };
        if (!parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) return;
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        CSVReader reader = new CSVReader((Reader)new InputStreamReader((InputStream)new BOMInputStream((InputStream)new FileInputStream((String)filename.elem))), ',', '\"', '~');
        String[] nextLine = headers = reader.readNext();
        if (headers.length >= 3) {
            Tuple3 tuple3;
            Tuple3 tuple32 = (Tuple3)this.findRequiredHeaders(headers).get();
            if (tuple32 == null) throw new MatchError((Object)tuple32);
            int uuid = BoxesRunTime.unboxToInt((Object)tuple32._1());
            int atype = BoxesRunTime.unboxToInt((Object)tuple32._2());
            int comment = BoxesRunTime.unboxToInt((Object)tuple32._3());
            Tuple3 tuple33 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)uuid), (Object)BoxesRunTime.boxToInteger((int)atype), (Object)BoxesRunTime.boxToInteger((int)comment));
            int uuid2 = BoxesRunTime.unboxToInt((Object)tuple33._1());
            int atype2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
            int comment2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
            ArrayBuffer buf = new ArrayBuffer();
            while (true) {
                BoxedUnit boxedUnit;
                if (nextLine == null) break;
                if (nextLine != headers) {
                    String string;
                    if (nextLine[uuid2].startsWith("http:")) {
                        String path = new URL(nextLine[uuid2]).getPath();
                        string = path.substring(path.lastIndexOf("/") + 1);
                    } else {
                        string = nextLine[uuid2];
                    }
                    String recordUuid = string;
                    Option<ErrorCode> code = AssertionCodes$.MODULE$.getByName(nextLine[atype2]);
                    if (code.isDefined()) {
                        boxedUnit = buf.$plus$eq((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"recordUuid"), (Object)recordUuid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"code"), (Object)((Object)BoxesRunTime.boxToInteger((int)((ErrorCode)code.get()).code())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"comment"), (Object)nextLine[comment2])})));
                    } else {
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Unable to apply ").append((Object)Predef$.MODULE$.refArrayOps((Object[])nextLine).toList()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                nextLine = reader.readNext();
            }
            HttpClient http = new HttpClient();
            post = new PostMethod(new StringBuilder().append((Object)Config$.MODULE$.biocacheServiceUrl()).append((Object)"/bulk/assertions/add").toString());
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)Config$.MODULE$.biocacheServiceUrl()).append((Object)"/bulk/assertions/add").toString());
            post.addParameter("assertions", mapper.writeValueAsString((Object)buf.toList()));
            post.addParameter("userId", (String)userId.elem);
            post.addParameter("userDisplayName", (String)userDisplayName.elem);
            post.addParameter("apiKey", Config$.MODULE$.getProperty("apiKey"));
            Predef$.MODULE$.println((Object)post.toString());
            int responseCode = http.executeMethod((HttpMethod)post);
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Response: ").append((Object)BoxesRunTime.boxToInteger((int)responseCode)).toString());
            return;
        } else {
            Predef$.MODULE$.println((Object)"Need at least 3 columns to load a CSV annotations: uuid, annotation type, comment");
        }
        return;
        finally {
            post.releaseConnection();
        }
    }

    public Option<Tuple3<Object, Object, Object>> findRequiredHeaders(String[] header) {
        return new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)));
    }

    private LoadBulkQas$() {
        MODULE$ = this;
    }
}

