/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.util.IndexStatus;
import au.org.ala.biocache.util.ProcessingStatus;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class JMX$ {
    public static final JMX$ MODULE$;
    private final MBeanServer mbs;
    private final IndexStatus indexStatus;
    private final ProcessingStatus processingStatus;

    static {
        new JMX$();
    }

    public MBeanServer mbs() {
        return this.mbs;
    }

    public IndexStatus indexStatus() {
        return this.indexStatus;
    }

    public ProcessingStatus processingStatus() {
        return this.processingStatus;
    }

    public void updateIndexStatus(long totalRecords, float recordsPerSec, long cassandraTime, long processingTime, long solrTime, long totalTime, long indexDocsCommitted, long indexDocsInRam, long indexDocsInRamMB, long processingQueue, long luceneQueue, long commitBatchQueue) {
        this.indexStatus().totalRecords_$eq(totalRecords);
        this.indexStatus().recordsPerSec_$eq(recordsPerSec);
        this.indexStatus().cassandraTime_$eq(cassandraTime);
        this.indexStatus().processingTime_$eq(processingTime);
        this.indexStatus().solrTime_$eq(solrTime);
        this.indexStatus().totalTime_$eq(totalTime);
        this.indexStatus().indexDocsCommitted_$eq(indexDocsCommitted);
        this.indexStatus().indexDocsInRam_$eq(indexDocsInRam);
        this.indexStatus().indexDocsInRamMB_$eq(indexDocsInRamMB);
        this.indexStatus().processingQueue_$eq(processingQueue);
        this.indexStatus().luceneQueue_$eq(luceneQueue);
        this.indexStatus().commitBatchQueue_$eq(commitBatchQueue);
    }

    public void updateProcessingStats(float recordsPerSec, float lastPageInSecs, int totalRecordsRead, int totalRecordsUpdated) {
        this.processingStatus().recordsPerSec_$eq(recordsPerSec);
        this.processingStatus().lastPageInSecs_$eq(lastPageInSecs);
        this.processingStatus().recordsRead_$eq(totalRecordsRead);
        this.processingStatus().recordsUpdated_$eq(totalRecordsUpdated);
    }

    public void updateProcessingCacheStatistics(int classificationCacheSize, int locationCacheSize, int storedPointCacheSize, int attributionCacheSize, int spatialLayerCacheSize, int taxonProfileCacheSize, int sensitivityCacheSize, int commonNameCacheSize, int cassandraQueryCacheSize, ConcurrentMap<String, AtomicLong> timings) {
        this.processingStatus().classificationCacheSize_$eq(classificationCacheSize);
        this.processingStatus().locationCacheSize_$eq(locationCacheSize);
        this.processingStatus().storedPointCacheSize_$eq(storedPointCacheSize);
        this.processingStatus().attributionCacheSize_$eq(attributionCacheSize);
        this.processingStatus().spatialLayerCacheSize_$eq(spatialLayerCacheSize);
        this.processingStatus().taxonProfileCacheSize_$eq(taxonProfileCacheSize);
        this.processingStatus().sensitivityCacheSize_$eq(sensitivityCacheSize);
        this.processingStatus().commonNameCacheSize_$eq(commonNameCacheSize);
        this.processingStatus().cassandraQueryCacheSize_$eq(cassandraQueryCacheSize);
        this.processingStatus().defaultProcessorChange_$eq(timings.getOrDefault("default", new AtomicLong(0L)).longValue() - this.processingStatus().defaultProcessor());
        this.processingStatus().imageProcessorChange_$eq(timings.getOrDefault("image", new AtomicLong(0L)).longValue() - this.processingStatus().imageProcessor());
        this.processingStatus().offlineProcessorChange_$eq(timings.getOrDefault("offline", new AtomicLong(0L)).longValue() - this.processingStatus().offlineProcessor());
        this.processingStatus().attributionProcessorChange_$eq(timings.getOrDefault("attr", new AtomicLong(0L)).longValue() - this.processingStatus().attributionProcessor());
        this.processingStatus().classificationProcessorChange_$eq(timings.getOrDefault("class", new AtomicLong(0L)).longValue() - this.processingStatus().classificationProcessor());
        this.processingStatus().basisOfRecordProcessorChange_$eq(timings.getOrDefault("bor", new AtomicLong(0L)).longValue() - this.processingStatus().basisOfRecordProcessor());
        this.processingStatus().eventProcessorChange_$eq(timings.getOrDefault("event", new AtomicLong(0L)).longValue() - this.processingStatus().eventProcessor());
        this.processingStatus().locationProcessorChange_$eq(timings.getOrDefault("loc", new AtomicLong(0L)).longValue() - this.processingStatus().locationProcessor());
        this.processingStatus().sensitiveProcessorChange_$eq(timings.getOrDefault("sensitive", new AtomicLong(0L)).longValue() - this.processingStatus().sensitiveProcessor());
        this.processingStatus().typeStatusProcessorChange_$eq(timings.getOrDefault("type", new AtomicLong(0L)).longValue() - this.processingStatus().typeStatusProcessor());
        this.processingStatus().iqProcessorChange_$eq(timings.getOrDefault("identification", new AtomicLong(0L)).longValue() - this.processingStatus().iqProcessor());
        this.processingStatus().reProcessorChange_$eq(timings.getOrDefault("reprocessing", new AtomicLong(0L)).longValue() - this.processingStatus().reProcessor());
        this.processingStatus().persistChange_$eq(timings.getOrDefault("persist", new AtomicLong(0L)).longValue() - this.processingStatus().persist());
        this.processingStatus().defaultProcessor_$eq(timings.getOrDefault("default", new AtomicLong(0L)).longValue());
        this.processingStatus().imageProcessor_$eq(timings.getOrDefault("image", new AtomicLong(0L)).longValue());
        this.processingStatus().offlineProcessor_$eq(timings.getOrDefault("offline", new AtomicLong(0L)).longValue());
        this.processingStatus().attributionProcessor_$eq(timings.getOrDefault("attr", new AtomicLong(0L)).longValue());
        this.processingStatus().classificationProcessor_$eq(timings.getOrDefault("class", new AtomicLong(0L)).longValue());
        this.processingStatus().basisOfRecordProcessor_$eq(timings.getOrDefault("bor", new AtomicLong(0L)).longValue());
        this.processingStatus().eventProcessor_$eq(timings.getOrDefault("event", new AtomicLong(0L)).longValue());
        this.processingStatus().locationProcessor_$eq(timings.getOrDefault("loc", new AtomicLong(0L)).longValue());
        this.processingStatus().sensitiveProcessor_$eq(timings.getOrDefault("sensitive", new AtomicLong(0L)).longValue());
        this.processingStatus().typeStatusProcessor_$eq(timings.getOrDefault("type", new AtomicLong(0L)).longValue());
        this.processingStatus().iqProcessor_$eq(timings.getOrDefault("identification", new AtomicLong(0L)).longValue());
        this.processingStatus().reProcessor_$eq(timings.getOrDefault("reprocessing", new AtomicLong(0L)).longValue());
        this.processingStatus().persist_$eq(timings.getOrDefault("persist", new AtomicLong(0L)).longValue());
    }

    private JMX$() {
        MODULE$ = this;
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        this.indexStatus = new IndexStatus();
        this.mbs().registerMBean(this.indexStatus(), new ObjectName("au.org.ala.biocache:type=Indexing"));
        this.processingStatus = new ProcessingStatus();
        this.mbs().registerMBean(this.processingStatus(), new ObjectName("au.org.ala.biocache:type=Processing"));
    }
}

