/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.ConfigModule;
import au.org.ala.biocache.dao.DeletedRecordDAO;
import au.org.ala.biocache.dao.DuplicateDAO;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.dao.OutlierStatsDAO;
import au.org.ala.biocache.dao.ValidationRuleDAO;
import au.org.ala.biocache.index.IndexDAO;
import au.org.ala.biocache.load.LocalMediaStore$;
import au.org.ala.biocache.load.MediaStore;
import au.org.ala.biocache.load.NullMediaStore$;
import au.org.ala.biocache.load.RemoteMediaStore$;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.util.LayersStore;
import au.org.ala.names.search.ALANameSearcher;
import au.org.ala.sds.SensitiveSpeciesFinder;
import au.org.ala.sds.SensitiveSpeciesFinderFactory;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class Config$ {
    public static final Config$ MODULE$;
    private final Logger logger;
    private final ConfigModule au$org$ala$biocache$Config$$configModule;
    private Injector inj;
    private final PersistenceManager persistenceManager;
    private final OccurrenceDAO occurrenceDAO;
    private final OutlierStatsDAO outlierStatsDAO;
    private final DeletedRecordDAO deletedRecordDAO;
    private final DuplicateDAO duplicateDAO;
    private final ValidationRuleDAO validationRuleDAO;
    private final IndexDAO indexDAO;
    private final String remoteMediaStoreUrl;
    private final String mediaStoreType;
    private final String mediaNotFound;
    private final MediaStore mediaStore;
    private final ALANameSearcher nameIndex;
    private final boolean hashImageFileNames;
    private final String solrHome;
    private final int solrConnectionPoolSize;
    private final int solrConnectionMaxPerRoute;
    private final int solrConnectionConnectTimeout;
    private final int solrConnectionRequestTimeout;
    private final int solrConnectionSocketTimeout;
    private final int solrConnectionCacheEntries;
    private final int solrConnectionCacheObjectSize;
    private final int remoteMediaConnectionPoolSize;
    private final int remoteMediaConnectionMaxPerRoute;
    private final String userAgent;
    private final int solrUpdateThreads;
    private final int cassandraUpdateThreads;
    private final int cassandraFetchSize;
    private final int cassandraTimeout;
    private final String volunteerHubUid;
    private final String volunteerDataProviderUid;
    private final String collectoryApiKey;
    private final String mediaStoreApiKey;
    private final String loadFileStore;
    private final String vocabDirectory;
    private final String layersDirectory;
    private final String deletedFileStore;
    private final String[] outlierLayerIDs;
    private final String mediaFileStore;
    private final String mediaBaseUrl;
    private final String excludeSensitiveValuesFor;
    private final String solrCollection;
    private final String allowCollectoryUpdates;
    private final String[] commonNameLanguages;
    private final String extraMiscFields;
    private final String technicalContact;
    private final String irmngDwcArchiveUrl;
    private final boolean obeySDSIsLoadable;
    private final String nationalChecklistIdentifierPattern;
    private final boolean taxonProfileCacheAll;
    private final int taxonProfileCacheSize;
    private final int classificationCacheSize;
    private final int commonNameCacheSize;
    private final int spatialCacheSize;
    private final int attributionCacheSize;
    private final int sensitivityCacheSize;
    private final int locationCacheSize;
    private final int dateFormatCacheSize;
    private final boolean jmxDebugEnabled;
    private final boolean solrIndexMisc;
    private final String schemaFieldTypeCl;
    private final String schemaFieldTypeEl;
    private final boolean schemaMultiValuedLayer;
    private final boolean schemaDocValuesLayer;
    private final boolean schemaIndexedLayer;
    private final boolean schemaStoredLayer;
    private final String schemaFieldTypeMisc;
    private final boolean schemaMultiValuedMisc;
    private final boolean schemaDocValuesMisc;
    private final boolean schemaStoredMisc;
    private String[] fieldsToSampleCached;
    private final List<String> blacklistedMediaUrls;
    private final String speciesGroupsUrl;
    private final String speciesSubgroupsUrl;
    private final String listToolUrl;
    private final String volunteerUrl;
    private final String tmpWorkDir;
    private final String registryUrl;
    private final String persistPointsFile;
    private String flickrUsersUrl;
    private String reindexUrl;
    private String reindexData;
    private String reindexViewDataResourceUrl;
    private String layersServiceUrl;
    private boolean layersServiceSampling;
    private int layerServiceRetries;
    private int layerServiceRetryWait;
    private String biocacheServiceUrl;
    private int solrBatchSize;
    private int solrHardCommitSize;
    private final Set<String> stateProvincePrefixFields;
    private final Set<String> speciesListIndexValues;
    private final boolean loadSpeciesLists;
    private final boolean taxonProfilesEnabled;
    private final String localNodeIp;
    private final String zookeeperAddress;
    private final boolean zookeeperUpdatesEnabled;
    private final int nodeNumber;
    private final int cassandraTokenSplit;
    private final int clusterSize;
    private final String stateProvinceLayerID;
    private final String terrestrialLayerID;
    private final String marineLayerID;
    private final String countriesLayerID;
    private final String localGovLayerID;
    private final boolean gridRefIndexingEnabled;
    private final String defaultCountry;
    private final Properties versionProperties;
    private final List<String> additionalFieldsToIndex;
    private final String sdsUrl;
    private final String sdsLayersUrl;
    private final boolean sdsEnabled;
    private SensitiveSpeciesFinder sdsFinder;
    private final Set<String> sensitiveFields;
    private final String exportIndexAsCsvPath;
    private final String exportIndexAsCsvPathSensitive;
    private final boolean caseSensitiveCassandra;
    private final boolean createColumnCassandra;
    private volatile int bitmap$0;

    static {
        new Config$();
    }

    private String flickrUsersUrl$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.flickrUsersUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("flickr.users.url", "https://auth.ala.org.au/userdetails/external/flickr");
                this.bitmap$0 |= 1;
            }
            return this.flickrUsersUrl;
        }
    }

    private String reindexUrl$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((this.bitmap$0 & 2) == 0) {
                this.reindexUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("reindex.url");
                this.bitmap$0 |= 2;
            }
            return this.reindexUrl;
        }
    }

    private String reindexData$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((this.bitmap$0 & 4) == 0) {
                this.reindexData = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("reindex.data");
                this.bitmap$0 |= 4;
            }
            return this.reindexData;
        }
    }

    private String reindexViewDataResourceUrl$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((this.bitmap$0 & 8) == 0) {
                this.reindexViewDataResourceUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("reindex.data.resource.url");
                this.bitmap$0 |= 8;
            }
            return this.reindexViewDataResourceUrl;
        }
    }

    private String layersServiceUrl$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.layersServiceUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("layers.service.url");
                this.bitmap$0 |= 0x10;
            }
            return this.layersServiceUrl;
        }
    }

    private boolean layersServiceSampling$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.layersServiceSampling = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("layers.service.sampling", "true"))).toBoolean();
                this.bitmap$0 |= 0x20;
            }
            return this.layersServiceSampling;
        }
    }

    private int layerServiceRetries$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.layerServiceRetries = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("layers.service.retries", "10"))).toInt();
                this.bitmap$0 |= 0x40;
            }
            return this.layerServiceRetries;
        }
    }

    private int layerServiceRetryWait$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.layerServiceRetryWait = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("layers.service.retry.wait", "30000"))).toInt();
                this.bitmap$0 |= 0x80;
            }
            return this.layerServiceRetryWait;
        }
    }

    private String biocacheServiceUrl$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.biocacheServiceUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("webservices.root", "https://biocache-ws.ala.org.au/ws");
                this.bitmap$0 |= 0x100;
            }
            return this.biocacheServiceUrl;
        }
    }

    private int solrBatchSize$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.solrBatchSize = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.batch.size", "1000"))).toInt();
                this.bitmap$0 |= 0x200;
            }
            return this.solrBatchSize;
        }
    }

    private int solrHardCommitSize$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.solrHardCommitSize = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.hardcommit.size", "10000"))).toInt();
                this.bitmap$0 |= 0x400;
            }
            return this.solrHardCommitSize;
        }
    }

    /*
     * Loose catch block
     */
    private SensitiveSpeciesFinder sdsFinder$lzycompute() {
        Config$ config$ = this;
        synchronized (config$) {
            if ((this.bitmap$0 & 0x800) == 0) {
                Config$ config$2 = this;
                synchronized (config$2) {
                    SensitiveSpeciesFinder sensitiveSpeciesFinder = this.sdsEnabled() ? SensitiveSpeciesFinderFactory.getSensitiveSpeciesFinder((ALANameSearcher)this.nameIndex()) : null;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 4, 7] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.sdsFinder = sensitiveSpeciesFinder;
                    this.bitmap$0 |= 0x800;
                }
            }
            return this.sdsFinder;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public Logger logger() {
        return this.logger;
    }

    public ConfigModule au$org$ala$biocache$Config$$configModule() {
        return this.au$org$ala$biocache$Config$$configModule;
    }

    public Injector inj() {
        return this.inj;
    }

    public void inj_$eq(Injector x$1) {
        this.inj = x$1;
    }

    public Object getInstance(Class<?> classs) {
        return this.inj().getInstance(classs);
    }

    public PersistenceManager persistenceManager() {
        return this.persistenceManager;
    }

    public OccurrenceDAO occurrenceDAO() {
        return this.occurrenceDAO;
    }

    public OutlierStatsDAO outlierStatsDAO() {
        return this.outlierStatsDAO;
    }

    public DeletedRecordDAO deletedRecordDAO() {
        return this.deletedRecordDAO;
    }

    public DuplicateDAO duplicateDAO() {
        return this.duplicateDAO;
    }

    public ValidationRuleDAO validationRuleDAO() {
        return this.validationRuleDAO;
    }

    public IndexDAO indexDAO() {
        return this.indexDAO;
    }

    public String remoteMediaStoreUrl() {
        return this.remoteMediaStoreUrl;
    }

    public String mediaStoreType() {
        return this.mediaStoreType;
    }

    public String mediaNotFound() {
        return this.mediaNotFound;
    }

    public MediaStore mediaStore() {
        return this.mediaStore;
    }

    public ALANameSearcher nameIndex() {
        return this.nameIndex;
    }

    public boolean hashImageFileNames() {
        return this.hashImageFileNames;
    }

    public String solrHome() {
        return this.solrHome;
    }

    public int solrConnectionPoolSize() {
        return this.solrConnectionPoolSize;
    }

    public int solrConnectionMaxPerRoute() {
        return this.solrConnectionMaxPerRoute;
    }

    public int solrConnectionConnectTimeout() {
        return this.solrConnectionConnectTimeout;
    }

    public int solrConnectionRequestTimeout() {
        return this.solrConnectionRequestTimeout;
    }

    public int solrConnectionSocketTimeout() {
        return this.solrConnectionSocketTimeout;
    }

    public int solrConnectionCacheEntries() {
        return this.solrConnectionCacheEntries;
    }

    public int solrConnectionCacheObjectSize() {
        return this.solrConnectionCacheObjectSize;
    }

    public int remoteMediaConnectionPoolSize() {
        return this.remoteMediaConnectionPoolSize;
    }

    public int remoteMediaConnectionMaxPerRoute() {
        return this.remoteMediaConnectionMaxPerRoute;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public int solrUpdateThreads() {
        return this.solrUpdateThreads;
    }

    public int cassandraUpdateThreads() {
        return this.cassandraUpdateThreads;
    }

    public int cassandraFetchSize() {
        return this.cassandraFetchSize;
    }

    public int cassandraTimeout() {
        return this.cassandraTimeout;
    }

    public String volunteerHubUid() {
        return this.volunteerHubUid;
    }

    public String volunteerDataProviderUid() {
        return this.volunteerDataProviderUid;
    }

    public String collectoryApiKey() {
        return this.collectoryApiKey;
    }

    public String mediaStoreApiKey() {
        return this.mediaStoreApiKey;
    }

    public String loadFileStore() {
        return this.loadFileStore;
    }

    public String vocabDirectory() {
        return this.vocabDirectory;
    }

    public String layersDirectory() {
        return this.layersDirectory;
    }

    public String deletedFileStore() {
        return this.deletedFileStore;
    }

    public String[] outlierLayerIDs() {
        return this.outlierLayerIDs;
    }

    public String mediaFileStore() {
        return this.mediaFileStore;
    }

    public String mediaBaseUrl() {
        return this.mediaBaseUrl;
    }

    public String excludeSensitiveValuesFor() {
        return this.excludeSensitiveValuesFor;
    }

    public String solrCollection() {
        return this.solrCollection;
    }

    public String allowCollectoryUpdates() {
        return this.allowCollectoryUpdates;
    }

    public String[] commonNameLanguages() {
        return this.commonNameLanguages;
    }

    public String extraMiscFields() {
        return this.extraMiscFields;
    }

    public String technicalContact() {
        return this.technicalContact;
    }

    public String irmngDwcArchiveUrl() {
        return this.irmngDwcArchiveUrl;
    }

    public boolean obeySDSIsLoadable() {
        return this.obeySDSIsLoadable;
    }

    public String nationalChecklistIdentifierPattern() {
        return this.nationalChecklistIdentifierPattern;
    }

    public boolean taxonProfileCacheAll() {
        return this.taxonProfileCacheAll;
    }

    public int taxonProfileCacheSize() {
        return this.taxonProfileCacheSize;
    }

    public int classificationCacheSize() {
        return this.classificationCacheSize;
    }

    public int commonNameCacheSize() {
        return this.commonNameCacheSize;
    }

    public int spatialCacheSize() {
        return this.spatialCacheSize;
    }

    public int attributionCacheSize() {
        return this.attributionCacheSize;
    }

    public int sensitivityCacheSize() {
        return this.sensitivityCacheSize;
    }

    public int locationCacheSize() {
        return this.locationCacheSize;
    }

    public int dateFormatCacheSize() {
        return this.dateFormatCacheSize;
    }

    public boolean jmxDebugEnabled() {
        return this.jmxDebugEnabled;
    }

    public boolean solrIndexMisc() {
        return this.solrIndexMisc;
    }

    public String schemaFieldTypeCl() {
        return this.schemaFieldTypeCl;
    }

    public String schemaFieldTypeEl() {
        return this.schemaFieldTypeEl;
    }

    public boolean schemaMultiValuedLayer() {
        return this.schemaMultiValuedLayer;
    }

    public boolean schemaDocValuesLayer() {
        return this.schemaDocValuesLayer;
    }

    public boolean schemaIndexedLayer() {
        return this.schemaIndexedLayer;
    }

    public boolean schemaStoredLayer() {
        return this.schemaStoredLayer;
    }

    public String schemaFieldTypeMisc() {
        return this.schemaFieldTypeMisc;
    }

    public boolean schemaMultiValuedMisc() {
        return this.schemaMultiValuedMisc;
    }

    public boolean schemaDocValuesMisc() {
        return this.schemaDocValuesMisc;
    }

    public boolean schemaStoredMisc() {
        return this.schemaStoredMisc;
    }

    private String[] fieldsToSampleCached() {
        return this.fieldsToSampleCached;
    }

    private void fieldsToSampleCached_$eq(String[] x$1) {
        this.fieldsToSampleCached = x$1;
    }

    public String[] fieldsToSample(boolean refresh) {
        block6: {
            String[] fields;
            ArrayList arrayList;
            String defaultFields;
            String str;
            block8: {
                block7: {
                    if (!refresh && !Predef$.MODULE$.refArrayOps((Object[])this.fieldsToSampleCached()).isEmpty()) break block6;
                    str = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("sample.fields");
                    defaultFields = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("default.sample.fields", "");
                    if (str == null) break block7;
                    String string = str.trim();
                    String string2 = "";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block7;
                    String string3 = str.trim();
                    String string4 = "all";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block8;
                }
                try {
                    arrayList = new LayersStore(this.layersServiceUrl()).getFieldIds();
                }
                catch (Exception exception) {
                    this.logger().error(new StringBuilder().append((Object)"Problem loading layers to intersect: ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
                    arrayList = new ArrayList();
                }
            }
            String string = str;
            String string5 = "none";
            if (!(string != null ? !string.equals(string5) : string5 != null)) {
                this.fieldsToSampleCached_$eq((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
            } else {
                String[] fields2 = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])str.split(",")).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x) {
                        return x.trim();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toArray(ClassTag$.MODULE$.apply(String.class));
                this.logger().info(new StringBuilder().append((Object)"Fields to sample: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])fields2).mkString(",")).toString());
                this.fieldsToSampleCached_$eq(fields2);
            }
            break block6;
            ArrayList dbfields = arrayList;
            this.logger().info(new StringBuilder().append((Object)"Number of fields to sample: ").append((Object)BoxesRunTime.boxToInteger((int)dbfields.size())).toString());
            String[] stringArray = fields = dbfields.isEmpty() ? (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])defaultFields.split(",")).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x) {
                    return x.trim();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toArray(ClassTag$.MODULE$.apply(String.class)) : (String[])Array$.MODULE$.ofDim(dbfields.size(), ClassTag$.MODULE$.apply(String.class));
            if (!dbfields.isEmpty()) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), dbfields.size()).foreach$mVc$sp((Function1)new Serializable(dbfields, fields){
                    public static final long serialVersionUID = 0L;
                    private final ArrayList dbfields$1;
                    private final String[] fields$1;

                    public final void apply(int a) {
                        this.apply$mcVI$sp(a);
                    }

                    public void apply$mcVI$sp(int a) {
                        this.fields$1[a] = (String)this.dbfields$1.get(a);
                    }
                    {
                        this.dbfields$1 = dbfields$1;
                        this.fields$1 = fields$1;
                    }
                });
            }
            this.logger().info(new StringBuilder().append((Object)"Fields to sample: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])fields).mkString(",")).toString());
            this.fieldsToSampleCached_$eq(fields);
        }
        return this.fieldsToSampleCached();
    }

    public boolean fieldsToSample$default$1() {
        return true;
    }

    public List<String> blacklistedMediaUrls() {
        return this.blacklistedMediaUrls;
    }

    public String speciesGroupsUrl() {
        return this.speciesGroupsUrl;
    }

    public String speciesSubgroupsUrl() {
        return this.speciesSubgroupsUrl;
    }

    public String listToolUrl() {
        return this.listToolUrl;
    }

    public String volunteerUrl() {
        return this.volunteerUrl;
    }

    public String tmpWorkDir() {
        return this.tmpWorkDir;
    }

    public String registryUrl() {
        return this.registryUrl;
    }

    public String persistPointsFile() {
        return this.persistPointsFile;
    }

    public String flickrUsersUrl() {
        return (this.bitmap$0 & 1) == 0 ? this.flickrUsersUrl$lzycompute() : this.flickrUsersUrl;
    }

    public String reindexUrl() {
        return (this.bitmap$0 & 2) == 0 ? this.reindexUrl$lzycompute() : this.reindexUrl;
    }

    public String reindexData() {
        return (this.bitmap$0 & 4) == 0 ? this.reindexData$lzycompute() : this.reindexData;
    }

    public String reindexViewDataResourceUrl() {
        return (this.bitmap$0 & 8) == 0 ? this.reindexViewDataResourceUrl$lzycompute() : this.reindexViewDataResourceUrl;
    }

    public String layersServiceUrl() {
        return (this.bitmap$0 & 0x10) == 0 ? this.layersServiceUrl$lzycompute() : this.layersServiceUrl;
    }

    public boolean layersServiceSampling() {
        return (this.bitmap$0 & 0x20) == 0 ? this.layersServiceSampling$lzycompute() : this.layersServiceSampling;
    }

    public int layerServiceRetries() {
        return (this.bitmap$0 & 0x40) == 0 ? this.layerServiceRetries$lzycompute() : this.layerServiceRetries;
    }

    public int layerServiceRetryWait() {
        return (this.bitmap$0 & 0x80) == 0 ? this.layerServiceRetryWait$lzycompute() : this.layerServiceRetryWait;
    }

    public String biocacheServiceUrl() {
        return (this.bitmap$0 & 0x100) == 0 ? this.biocacheServiceUrl$lzycompute() : this.biocacheServiceUrl;
    }

    public int solrBatchSize() {
        return (this.bitmap$0 & 0x200) == 0 ? this.solrBatchSize$lzycompute() : this.solrBatchSize;
    }

    public int solrHardCommitSize() {
        return (this.bitmap$0 & 0x400) == 0 ? this.solrHardCommitSize$lzycompute() : this.solrHardCommitSize;
    }

    public Set<String> stateProvincePrefixFields() {
        return this.stateProvincePrefixFields;
    }

    public Set<String> speciesListIndexValues() {
        return this.speciesListIndexValues;
    }

    public boolean loadSpeciesLists() {
        return this.loadSpeciesLists;
    }

    public boolean taxonProfilesEnabled() {
        return this.taxonProfilesEnabled;
    }

    public String localNodeIp() {
        return this.localNodeIp;
    }

    public String zookeeperAddress() {
        return this.zookeeperAddress;
    }

    public boolean zookeeperUpdatesEnabled() {
        return this.zookeeperUpdatesEnabled;
    }

    public int nodeNumber() {
        return this.nodeNumber;
    }

    public int cassandraTokenSplit() {
        return this.cassandraTokenSplit;
    }

    public int clusterSize() {
        return this.clusterSize;
    }

    public String getProperty(String prop) {
        return this.au$org$ala$biocache$Config$$configModule().properties().getProperty(prop);
    }

    private String getProperty(String prop, String string) {
        return this.au$org$ala$biocache$Config$$configModule().properties().getProperty(prop, string);
    }

    public void outputConfig() {
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(this.au$org$ala$biocache$Config$$configModule().properties().stringPropertyNames().toArray()).sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object x$4, Object x$5) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4.toString())).$less((Object)x$5.toString());
            }
        })).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object name) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)name.toString()).append((Object)" = ").append((Object)Config$.MODULE$.au$org$ala$biocache$Config$$configModule().properties().getProperty(name.toString(), "NOT DEFINED")).toString());
            }
        });
    }

    public String stateProvinceLayerID() {
        return this.stateProvinceLayerID;
    }

    public String terrestrialLayerID() {
        return this.terrestrialLayerID;
    }

    public String marineLayerID() {
        return this.marineLayerID;
    }

    public String countriesLayerID() {
        return this.countriesLayerID;
    }

    public String localGovLayerID() {
        return this.localGovLayerID;
    }

    public boolean gridRefIndexingEnabled() {
        return this.gridRefIndexingEnabled;
    }

    public String defaultCountry() {
        return this.defaultCountry;
    }

    public Properties versionProperties() {
        return this.versionProperties;
    }

    public List<String> additionalFieldsToIndex() {
        return this.additionalFieldsToIndex;
    }

    public String sdsUrl() {
        return this.sdsUrl;
    }

    public String sdsLayersUrl() {
        return this.sdsLayersUrl;
    }

    public boolean sdsEnabled() {
        return this.sdsEnabled;
    }

    public SensitiveSpeciesFinder sdsFinder() {
        return (this.bitmap$0 & 0x800) == 0 ? this.sdsFinder$lzycompute() : this.sdsFinder;
    }

    public Set<String> sensitiveFields() {
        return this.sensitiveFields;
    }

    public String exportIndexAsCsvPath() {
        return this.exportIndexAsCsvPath;
    }

    public String exportIndexAsCsvPathSensitive() {
        return this.exportIndexAsCsvPathSensitive;
    }

    public boolean caseSensitiveCassandra() {
        return this.caseSensitiveCassandra;
    }

    public boolean createColumnCassandra() {
        return this.createColumnCassandra;
    }

    private final void liftedTree1$1(Properties properties$1, Enumeration resources$1) {
        try {
            URL url = (URL)resources$1.nextElement();
            Manifest manifest = new Manifest(url.openStream());
            Object title = manifest.getMainAttributes().get(new Attributes.Name("Implementation-Title"));
            if ("Biocache".equals(title)) {
                Attributes entries = manifest.getMainAttributes();
                JavaConversions$.MODULE$.asScalaSet(entries.entrySet()).foreach((Function1)new Serializable(properties$1){
                    public static final long serialVersionUID = 0L;
                    private final Properties properties$1;

                    public final Object apply(Map.Entry<Object, Object> entry) {
                        return this.properties$1.put(entry.getKey().toString(), entry.getValue().toString());
                    }
                    {
                        this.properties$1 = properties$1;
                    }
                });
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Config$() {
        String configProps;
        String layersUrl;
        List list;
        MediaStore mediaStore;
        String string;
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"Config");
        this.au$org$ala$biocache$Config$$configModule = new ConfigModule();
        this.inj = Guice.createInjector((Module[])new Module[]{this.au$org$ala$biocache$Config$$configModule()});
        this.persistenceManager = (PersistenceManager)this.getInstance(PersistenceManager.class);
        this.occurrenceDAO = (OccurrenceDAO)this.getInstance(OccurrenceDAO.class);
        this.outlierStatsDAO = (OutlierStatsDAO)this.getInstance(OutlierStatsDAO.class);
        this.deletedRecordDAO = (DeletedRecordDAO)this.getInstance(DeletedRecordDAO.class);
        this.duplicateDAO = (DuplicateDAO)this.getInstance(DuplicateDAO.class);
        this.validationRuleDAO = (ValidationRuleDAO)this.getInstance(ValidationRuleDAO.class);
        this.indexDAO = (IndexDAO)this.getInstance(IndexDAO.class);
        this.remoteMediaStoreUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("media.store.url", "");
        this.mediaStoreType = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("media.store.type", "auto");
        this.mediaNotFound = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("media.store.notFound.url", "https://www.ala.org.au/commonui-bs3/img/icon-camera.png");
        String string2 = string = this.mediaStoreType();
        if (!("none" != null ? !"none".equals(string2) : string2 != null)) {
            mediaStore = NullMediaStore$.MODULE$;
        } else {
            String string3 = string;
            if (!("local" != null ? !"local".equals(string3) : string3 != null)) {
                mediaStore = LocalMediaStore$.MODULE$;
            } else {
                String string4 = string;
                if (!("remote" != null ? !"remote".equals(string4) : string4 != null)) {
                    mediaStore = RemoteMediaStore$.MODULE$;
                } else {
                    MediaStore mediaStore2;
                    if (StringUtils.isBlank((CharSequence)this.remoteMediaStoreUrl())) {
                        this.logger().debug("Using local media store");
                        mediaStore2 = LocalMediaStore$.MODULE$;
                    } else {
                        this.logger().debug("Using remote media store");
                        mediaStore2 = RemoteMediaStore$.MODULE$;
                    }
                    mediaStore = mediaStore2;
                }
            }
        }
        this.mediaStore = mediaStore;
        this.nameIndex = (ALANameSearcher)this.getInstance(ALANameSearcher.class);
        this.hashImageFileNames = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("hash.image.filenames", "false"))).toBoolean();
        this.solrHome = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.home", "");
        this.solrConnectionPoolSize = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.connection.pool.size", "50"))).toInt();
        this.solrConnectionMaxPerRoute = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.connection.pool.maxperroute", "50"))).toInt();
        this.solrConnectionConnectTimeout = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.connection.connecttimeout", "30000"))).toInt();
        this.solrConnectionRequestTimeout = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.connection.requesttimeout", "30000"))).toInt();
        this.solrConnectionSocketTimeout = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.connection.sockettimeout", "30000"))).toInt();
        this.solrConnectionCacheEntries = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.connection.cache.entries", "500"))).toInt();
        this.solrConnectionCacheObjectSize = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.connection.cache.object.size", "262144"))).toInt();
        this.remoteMediaConnectionPoolSize = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("mediastore.connection.pool.size", "25"))).toInt();
        this.remoteMediaConnectionMaxPerRoute = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("mediastore.connection.pool.maxperroute", "25"))).toInt();
        this.userAgent = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("biocache.useragent", "Biocache");
        this.solrUpdateThreads = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.update.threads", "4"))).toInt();
        this.cassandraUpdateThreads = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("cassandra.update.threads", "8"))).toInt();
        this.cassandraFetchSize = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("cassandra.fetch.size", "500"))).toInt();
        this.cassandraTimeout = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("cassandra.timeout", "120000"))).toInt();
        this.volunteerHubUid = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("volunteer.hub.uid", "");
        this.volunteerDataProviderUid = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("volunteer.dp.uid", "");
        this.collectoryApiKey = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("registry.api.key", "xxxxxxxxxxxxxxxxx");
        this.mediaStoreApiKey = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("imageservice.api.key", "xxxxxxxxxxxxxxxxx");
        this.loadFileStore = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("load.dir", "/data/biocache-load/");
        this.vocabDirectory = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("vocab.dir", "/data/biocache/vocab/");
        this.layersDirectory = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("layers.dir", "/data/biocache/layers/");
        this.deletedFileStore = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("deleted.file.store", "/data/biocache-delete/");
        this.outlierLayerIDs = (String[])Predef$.MODULE$.refArrayOps((Object[])this.au$org$ala$biocache$Config$$configModule().properties().getProperty("outlier.layers", "el882,el889,el887,el865,el894").split(",")).map((Function1)new anonfun.1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        this.mediaFileStore = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("media.dir", "/data/biocache-media/");
        this.mediaBaseUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("media.url", "https://biocache.ala.org.au/biocache-media");
        this.excludeSensitiveValuesFor = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("exclude.sensitive.values", "");
        this.solrCollection = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.collection", "biocache1");
        this.allowCollectoryUpdates = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("allow.registry.updates", "false");
        String configValue = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("commonname.lang", "");
        this.commonNameLanguages = StringUtils.isNotEmpty((CharSequence)configValue) ? (String[])Predef$.MODULE$.refArrayOps((Object[])configValue.split(",")).map((Function1)new anonfun.2(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        this.extraMiscFields = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("extra.misc.fields", "");
        this.technicalContact = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("technical.contact", "support@ala.org.au");
        this.irmngDwcArchiveUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("irmng.archive.url", "http://www.cmar.csiro.au/datacentre/downloads/IRMNG_DWC.zip");
        this.obeySDSIsLoadable = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("obey.sds.is.loadable", "true"))).toBoolean();
        this.nationalChecklistIdentifierPattern = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("national.checklist.guid.pattern", "biodiversity.org.au");
        this.taxonProfileCacheAll = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("taxon.profile.cache.all", "false"))).toBoolean();
        this.taxonProfileCacheSize = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("taxon.profile.cache.size", "10000"))).toInt();
        this.classificationCacheSize = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("classification.cache.size", "10000"))).toInt();
        this.commonNameCacheSize = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("commonname.cache.size", "10000"))).toInt();
        this.spatialCacheSize = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("spatial.cache.size", "10000"))).toInt();
        this.attributionCacheSize = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("attribution.cache.size", "10000"))).toInt();
        this.sensitivityCacheSize = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("sensitivity.cache.size", "10000"))).toInt();
        this.locationCacheSize = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("location.cache.size", "10000"))).toInt();
        this.dateFormatCacheSize = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("dateformat.cache.size", "10000"))).toInt();
        this.jmxDebugEnabled = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("jmx.debug.enabled", "true"))).toBoolean();
        this.solrIndexMisc = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.index.misc", "false"))).toBoolean();
        this.schemaFieldTypeCl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.index.fieldtype.cl", "string");
        this.schemaFieldTypeEl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.index.fieldtype.el", "tfloat");
        this.schemaMultiValuedLayer = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.index.multivalued.layer", "false"))).toBoolean();
        this.schemaDocValuesLayer = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.index.docvalues.layer", "false"))).toBoolean();
        this.schemaIndexedLayer = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.index.indexed.layer", "true"))).toBoolean();
        this.schemaStoredLayer = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.index.stored.layer", "true"))).toBoolean();
        this.schemaFieldTypeMisc = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.index.fieldtype.misc", "string");
        this.schemaMultiValuedMisc = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.index.multivalued.misc", "false"))).toBoolean();
        this.schemaDocValuesMisc = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.index.docvalues.misc", "false"))).toBoolean();
        this.schemaStoredMisc = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("solr.index.stored.misc", "true"))).toBoolean();
        this.fieldsToSampleCached = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        String blacklistMediaUrlsFile = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("blacklist.media.file", "/data/biocache/config/blacklistMediaUrls.txt");
        if (new File(blacklistMediaUrlsFile).exists()) {
            this.logger().info(new StringBuilder().append((Object)"Using the set of blacklisted media URLs defined in: ").append((Object)blacklistMediaUrlsFile).toString());
            list = Source$.MODULE$.fromFile(new File(blacklistMediaUrlsFile), Codec$.MODULE$.fallbackSystemCodec()).getLines().map((Function1)new anonfun.5()).toList();
        } else {
            this.logger().info("Using the default set of blacklisted media URLs");
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://www.inaturalist.org/photos/", "http://www.flickr.com/photos/", "http://www.facebook.com/photo.php", "https://picasaweb.google.com"}));
        }
        this.blacklistedMediaUrls = list;
        this.speciesGroupsUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("species.groups.url", "");
        this.speciesSubgroupsUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("species.subgroups.url", "https://bie.ala.org.au/subgroups.json");
        this.listToolUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("list.tool.url", "https://lists.ala.org.au");
        this.volunteerUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("volunteer.url", "https://volunteer.ala.org.au");
        this.tmpWorkDir = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("tmp.work.dir", "/tmp");
        this.registryUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("registry.url", "https://collections.ala.org.au/ws");
        this.persistPointsFile = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("persist.points.file", "");
        this.stateProvincePrefixFields = Predef$.MODULE$.refArrayOps((Object[])this.au$org$ala$biocache$Config$$configModule().properties().getProperty("species.list.prefix", "stateProvince").split(",")).toSet();
        this.speciesListIndexValues = Predef$.MODULE$.refArrayOps((Object[])this.au$org$ala$biocache$Config$$configModule().properties().getProperty("species.list.index.keys", "category,status,sourceStatus").split(",")).toSet();
        this.loadSpeciesLists = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("include.species.lists", "false"))).toBoolean();
        this.taxonProfilesEnabled = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("taxon.profiles.enabled", "true"))).toBoolean();
        this.localNodeIp = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("local.node.ip", "127.0.0.1");
        this.zookeeperAddress = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("zookeeper.address", "127.0.0.1:2181");
        this.zookeeperUpdatesEnabled = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("zookeeper.updates.enabled", "false"))).toBoolean();
        this.nodeNumber = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("node.number", "0"))).toInt();
        this.cassandraTokenSplit = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("cassandra.token.split", "1"))).toInt();
        this.clusterSize = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("cluster.size", "1"))).toInt();
        this.stateProvinceLayerID = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("layer.state.province", "");
        this.terrestrialLayerID = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("layer.terrestrial", "");
        this.marineLayerID = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("layer.marine", "");
        this.countriesLayerID = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("layer.countries", "");
        this.localGovLayerID = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("layer.localgov", "");
        this.gridRefIndexingEnabled = BooleanUtils.toBoolean((String)this.au$org$ala$biocache$Config$$configModule().properties().getProperty("gridref.indexing.enabled", "false"));
        this.defaultCountry = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("default.country", "Australia");
        Properties properties = new Properties();
        Enumeration<URL> resources = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            this.liftedTree1$1(properties, resources);
        }
        this.versionProperties = properties;
        List list2 = Predef$.MODULE$.refArrayOps((Object[])this.au$org$ala$biocache$Config$$configModule().properties().getProperty("additional.fields.to.index", "").split(",")).toList();
        if (list2.length() == 1 && ((String)list2.apply(0)).length() == 0) {
            list2 = Nil$.MODULE$;
        }
        this.additionalFieldsToIndex = list2;
        this.sdsUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("sds.url", "https://sds.ala.org.au");
        String string5 = layersUrl = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("sds.layers.url", "");
        String string6 = "";
        this.sdsLayersUrl = !(string5 != null ? !string5.equals(string6) : string6 != null) ? new StringBuilder().append((Object)this.sdsUrl()).append((Object)"/ws/layers").toString() : layersUrl;
        this.sdsEnabled = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("sds.enabled", "true"))).toBoolean();
        String string7 = configProps = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("sensitive.field", "");
        String string8 = "";
        this.sensitiveFields = !(string7 != null ? !string7.equals(string8) : string8 != null) ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"originalSensitiveValues", "originalDecimalLatitude", "originalDecimalLongitude", "originalLocationRemarks", "originalVerbatimLatitude", "originalVerbatimLongitude"})) : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])configProps.split(",")).map((Function1)new anonfun.6(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet();
        this.exportIndexAsCsvPath = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("export.index.as.csv.path", "");
        this.exportIndexAsCsvPathSensitive = this.au$org$ala$biocache$Config$$configModule().properties().getProperty("export.index.as.csv.path.sensitive", "");
        this.caseSensitiveCassandra = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("cassandra.case.sensitive", "true"))).toBoolean();
        this.createColumnCassandra = new StringOps(Predef$.MODULE$.augmentString(this.au$org$ala$biocache$Config$$configModule().properties().getProperty("cassandra.column.create", "true"))).toBoolean();
    }
}

