/*
 * Decompiled with CFR 0.152.
 */
package org.rev6.scf;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.rev6.scf.ScpFile;
import org.rev6.scf.SshException;
import org.rev6.scf.SshTask;

public class ScpDownload
extends SshTask {
    private static final String SCP_DOWNLOAD_COMMAND = "scp -f ";
    private ScpFile scpFile;

    public ScpDownload() {
    }

    public ScpDownload(ScpFile scpFile) {
        this.scpFile = scpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void execute(Session sshSession) throws SshException {
        InputStream in = null;
        OutputStream out = null;
        FileOutputStream fos = null;
        ChannelExec channel = null;
        try {
            try {
                String cmd = SCP_DOWNLOAD_COMMAND + this.scpFile.getRemoteFullPath();
                channel = this.setUpChannel(sshSession, cmd);
                fos = new FileOutputStream(this.scpFile.getLocalFile());
                in = channel.getInputStream();
                out = channel.getOutputStream();
                channel.connect();
                this.sendAck(out);
                long fileSize = this.getFileSizeFromStream(in);
                this.skipFileName(in);
                this.sendAck(out);
                this.writePayloadToFile(in, out, fos, fileSize);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (channel != null) {
                    channel.disconnect();
                }
            }
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    private long getFileSizeFromStream(InputStream in) throws SshException, IOException {
        long filesize = 0L;
        if (this.checkAck(in) != 67) {
            throw new SshException("Scp download from failed. Reason: Initializing  size response returned a status that is not 'C'");
        }
        in.skip(5L);
        while (true) {
            int b;
            if ((b = in.read()) < 0) {
                throw new SshException("Scp download from failed. Reason: reading file size returned a response of less than 0.");
            }
            if (b == 32) break;
            filesize = filesize * 10L + (long)(b - 48);
        }
        return filesize;
    }

    private void skipFileName(InputStream in) throws IOException {
        int b = in.read();
        while (b != 10) {
            b = in.read();
        }
    }

    private void writePayloadToFile(InputStream in, OutputStream out, FileOutputStream fos, long fileSize) throws SshException, IOException {
        int bytesRead;
        byte[] inBuffer = new byte[1024];
        do {
            int readSize;
            if ((bytesRead = in.read(inBuffer, 0, readSize = (long)inBuffer.length < fileSize ? inBuffer.length : (int)fileSize)) < 0) {
                throw new SshException("Scp download from failed.  Reason: Unable to download payload of file.");
            }
            fos.write(inBuffer, 0, bytesRead);
        } while ((fileSize -= (long)bytesRead) != 0L);
    }

    public void setScpFile(ScpFile scpFile) {
        if (scpFile == null) {
            throw new IllegalArgumentException("scpFile can't be null");
        }
        this.scpFile = scpFile;
    }
}

