/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class GeographicOffsetWrapper
implements MathTransform {
    MathTransform delegate;

    public GeographicOffsetWrapper(MathTransform delegate) {
        this.delegate = delegate;
    }

    public int getSourceDimensions() {
        return this.delegate.getSourceDimensions();
    }

    public int getTargetDimensions() {
        return this.delegate.getTargetDimensions();
    }

    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws MismatchedDimensionException, TransformException {
        return this.delegate.transform(ptSrc, ptDst);
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        double[] source = srcPts;
        if (srcPts == dstPts) {
            source = new double[srcPts.length];
            System.arraycopy(srcPts, 0, source, 0, srcPts.length);
        }
        this.delegate.transform(srcPts, srcOff, dstPts, dstOff, numPts);
        int srcDimension = this.delegate.getSourceDimensions();
        int dstDimension = this.delegate.getTargetDimensions();
        double lastSrcLon = source[srcOff];
        double lastDstLon = dstPts[dstOff];
        double offset = 0.0;
        int i = srcOff + srcDimension;
        int j = dstOff + dstDimension;
        for (int ptCount = 1; ptCount < numPts; ++ptCount) {
            double srcLon = source[i];
            double srcDelta = srcLon - lastSrcLon;
            double dstLon = dstPts[j];
            double dstDelta = dstLon - lastDstLon;
            double difference = srcDelta - dstDelta;
            if (difference > 180.0) {
                offset += 360.0;
            } else if (difference < -180.0) {
                offset -= 360.0;
            }
            if (offset != 0.0) {
                int n = j;
                dstPts[n] = dstPts[n] + offset;
            }
            lastDstLon = dstLon;
            lastSrcLon = srcLon;
            i += srcDimension;
            j += dstDimension;
        }
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        this.delegate.transform(srcPts, srcOff, dstPts, dstOff, numPts);
        int dimension = (srcPts.length - srcOff) / numPts;
        double lastSrcLon = srcPts[srcOff];
        double lastDstLon = dstPts[dstOff];
        float offset = 0.0f;
        int i = srcOff + dimension;
        int j = dstOff + dimension;
        for (int ptCount = 0; ptCount < numPts; ++ptCount) {
            double srcLon = srcPts[i];
            double srcDelta = srcLon - lastSrcLon;
            double dstLon = dstPts[j];
            double dstDelta = dstLon - lastDstLon;
            double difference = srcDelta - dstDelta;
            if (difference > 180.0) {
                offset += 360.0f;
            } else if (difference < 180.0) {
                offset -= 360.0f;
            }
            if (offset != 0.0f) {
                int n = j;
                dstPts[n] = dstPts[n] + offset;
            }
            lastDstLon = dstLon;
            lastSrcLon = srcLon;
            i += dimension;
            j += dimension;
        }
    }

    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        this.delegate.transform(srcPts, srcOff, dstPts, dstOff, numPts);
        int dimension = (srcPts.length - srcOff) / numPts;
        double lastSrcLon = srcPts[srcOff];
        double lastDstLon = dstPts[dstOff];
        double offset = 0.0;
        int i = srcOff + dimension;
        int j = dstOff + dimension;
        for (int ptCount = 0; ptCount < numPts; ++ptCount) {
            double srcLon = srcPts[i];
            double srcDelta = srcLon - lastSrcLon;
            double dstLon = dstPts[j];
            double dstDelta = dstLon - lastDstLon;
            double difference = srcDelta - dstDelta;
            if (difference > 180.0) {
                offset += 360.0;
            } else if (difference < 180.0) {
                offset -= 360.0;
            }
            if (offset != 0.0) {
                int n = j;
                dstPts[n] = dstPts[n] + offset;
            }
            lastDstLon = dstLon;
            lastSrcLon = srcLon;
            i += dimension;
            j += dimension;
        }
    }

    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        this.delegate.transform(srcPts, srcOff, dstPts, dstOff, numPts);
        int dimension = (srcPts.length - srcOff) / numPts;
        double lastSrcLon = srcPts[srcOff];
        double lastDstLon = dstPts[dstOff];
        float offset = 0.0f;
        int i = srcOff + dimension;
        int j = dstOff + dimension;
        for (int ptCount = 0; ptCount < numPts; ++ptCount) {
            double srcLon = srcPts[i];
            double srcDelta = srcLon - lastSrcLon;
            double dstLon = dstPts[j];
            double dstDelta = dstLon - lastDstLon;
            double difference = srcDelta - dstDelta;
            if (difference > 180.0) {
                offset += 360.0f;
            } else if (difference < 180.0) {
                offset -= 360.0f;
            }
            if (offset != 0.0f) {
                int n = j;
                dstPts[n] = dstPts[n] + offset;
            }
            lastDstLon = dstLon;
            lastSrcLon = srcLon;
            i += dimension;
            j += dimension;
        }
    }

    public Matrix derivative(DirectPosition point) throws MismatchedDimensionException, TransformException {
        return this.delegate.derivative(point);
    }

    public MathTransform inverse() throws NoninvertibleTransformException {
        MathTransform inverse = this.delegate.inverse();
        if (inverse instanceof GeographicOffsetWrapper) {
            return inverse;
        }
        return new GeographicOffsetWrapper(inverse);
    }

    public boolean isIdentity() {
        return this.delegate.isIdentity();
    }

    public String toWKT() throws UnsupportedOperationException {
        return this.delegate.toWKT();
    }

    public String toString() {
        return "GeographicOffsetWrapper[\n" + this.delegate.toString() + "\n]";
    }
}

