/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.util;

import au.org.ala.sds.model.PlantPestInstance;
import au.org.ala.sds.model.SensitiveTaxon;
import au.org.ala.sds.model.SensitivityInstance;
import au.org.ala.sds.model.SensitivityZone;
import au.org.ala.sds.util.GeoLocationHelper;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PlantPestUtils {
    public static String mapGetOrElse(Map<String, String> map, String key, String defaultValue) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return defaultValue;
    }

    public static String getLocalityFromMapForMessage(Map<String, String> map, List<SensitivityZone> zones) {
        return PlantPestUtils.mapGetOrElse(map, "locality", PlantPestUtils.mapGetOrElse(map, "cl23", zones.get(0).getName()));
    }

    public static String getStateFromMapForMessage(Map<String, String> map, List<SensitivityZone> zones) {
        List<SensitivityZone> states = GeoLocationHelper.filterForZoneType(zones, SensitivityZone.ZoneType.STATE);
        String zoneState = states.size() > 0 ? states.get(0).getName() : "Unknown State";
        return PlantPestUtils.mapGetOrElse(map, "stateProvince", PlantPestUtils.mapGetOrElse(map, "cl927", zoneState));
    }

    public static boolean isInsideZone(SensitiveTaxon st, String categoryId, List<SensitivityZone> zones) {
        for (SensitivityInstance si : st.getInstances()) {
            if (!si.getCategory().getId().equals(categoryId) || !zones.contains(si.getZone())) continue;
            return true;
        }
        return false;
    }

    public static boolean isOutsideZone(SensitiveTaxon st, String categoryId, List<SensitivityZone> zones) {
        for (SensitivityInstance si : st.getInstances()) {
            if (!si.getCategory().getId().equals(categoryId) || !zones.contains(si.getZone())) continue;
            return false;
        }
        return true;
    }

    public static boolean isInStateBasedZone(SensitiveTaxon st, String categoryId, List<SensitivityZone> zones) {
        PlantPestInstance ppi = (PlantPestInstance)PlantPestUtils.getMatchingSensitivityInstance(st, categoryId, zones);
        if (ppi != null) {
            return ppi.getZone().getType() == SensitivityZone.ZoneType.STATE;
        }
        return false;
    }

    public static boolean isInShapeBasedZone(SensitiveTaxon st, String categoryId, List<SensitivityZone> zones) {
        PlantPestInstance ppi = (PlantPestInstance)PlantPestUtils.getMatchingSensitivityInstance(st, categoryId, zones);
        if (ppi != null) {
            return ppi.getZone().getType() == SensitivityZone.ZoneType.QUARANTINE_ZONE;
        }
        return false;
    }

    public static boolean isInZoneDuringPeriod(SensitiveTaxon st, String categoryId, List<SensitivityZone> zones, Date date) {
        PlantPestInstance ppi = (PlantPestInstance)PlantPestUtils.getMatchingSensitivityInstance(st, categoryId, zones);
        if (ppi != null) {
            if (ppi.getFromDate() != null && ppi.getFromDate().getTime() > date.getTime()) {
                return false;
            }
            if (ppi.getToDate() == null) {
                return true;
            }
            if (ppi.getToDate().getTime() >= date.getTime()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInZoneBeforePeriod(SensitiveTaxon st, String categoryId, List<SensitivityZone> zones, Date date) {
        for (SensitivityInstance si : st.getInstances()) {
            if (!si.getCategory().getId().equals(categoryId) || !zones.contains(si.getZone()) || ((PlantPestInstance)si).getFromDate() == null || date.getTime() >= ((PlantPestInstance)si).getFromDate().getTime()) continue;
            return true;
        }
        return false;
    }

    public static boolean isInZoneAfterPeriod(SensitiveTaxon st, String categoryId, List<SensitivityZone> zones, Date date) {
        for (SensitivityInstance si : st.getInstances()) {
            if (!si.getCategory().getId().equals(categoryId) || !zones.contains(si.getZone()) || date.getTime() <= ((PlantPestInstance)si).getToDate().getTime()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAfterPeriod(SensitiveTaxon st, String categoryId, Date date) {
        for (SensitivityInstance si : st.getInstances()) {
            if (!si.getCategory().getId().equals(categoryId) || date.getTime() <= ((PlantPestInstance)si).getToDate().getTime()) continue;
            return true;
        }
        return false;
    }

    public static boolean isANonActionableTransientEvent(SensitiveTaxon st, String categoryId, Date date, List<SensitivityZone> zones) {
        for (SensitivityInstance si : st.getInstances()) {
            List<PlantPestInstance.TransientEvent> events;
            if (!si.getCategory().getId().equals(categoryId) || !(si instanceof PlantPestInstance) || (events = ((PlantPestInstance)si).getTransientEventList()) == null) continue;
            for (PlantPestInstance.TransientEvent te : events) {
                if (!te.getEventDate().equals(date) || !zones.contains(te.getZone())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isExactMatch(Map<String, String> properties, SensitiveTaxon st) {
        String name = null;
        if (properties.containsKey("scientificName")) {
            name = properties.get("scientificName");
        } else if (properties.containsKey("genus")) {
            name = properties.containsKey("specificEpithet") ? properties.get("genus") + " " + properties.get("specificEpithet") : properties.get("genus");
        } else if (properties.containsKey("family")) {
            name = properties.get("family");
        } else if (properties.containsKey("order")) {
            name = properties.get("order");
        }
        return name == null || st.getName().trim().equalsIgnoreCase(name.trim());
    }

    public static String getSensitivityZone(SensitiveTaxon st, String categoryId, List<SensitivityZone> zones) {
        SensitivityInstance si = PlantPestUtils.getMatchingSensitivityInstance(st, categoryId, zones);
        if (si != null) {
            return si.getZone().getName();
        }
        return "?";
    }

    public static Date getSensitivityZoneStartDate(SensitiveTaxon st, String categoryId, List<SensitivityZone> zones) {
        SensitivityInstance si = PlantPestUtils.getMatchingSensitivityInstance(st, categoryId, zones);
        if (si != null) {
            return ((PlantPestInstance)si).getFromDate();
        }
        return null;
    }

    private static SensitivityInstance getMatchingSensitivityInstance(SensitiveTaxon st, String categoryId, List<SensitivityZone> zones) {
        for (SensitivityInstance si : st.getInstances()) {
            if (!si.getCategory().getId().equals(categoryId) || !zones.contains(si.getZone())) continue;
            return si;
        }
        return null;
    }
}

