/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.wrangler.lock.zookeeper;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreV2;
import org.apache.curator.framework.recipes.locks.Lease;
import org.gbif.wrangler.lock.Lock;
import org.gbif.wrangler.lock.LockFactory;
import org.gbif.wrangler.lock.LockingException;

public class ZooKeeperLockFactory
implements LockFactory {
    private static final int DEFAULT_LEASES = 1;
    private final String lockingPath;
    private final CuratorFramework curator;
    private final int maxLeases;

    public ZooKeeperLockFactory(CuratorFramework curator, int maxLeases, String lockingPath) {
        this.curator = (CuratorFramework)Preconditions.checkNotNull((Object)curator, (Object)"curator can't be null");
        Preconditions.checkArgument((curator.getState() == CuratorFrameworkState.STARTED ? 1 : 0) != 0, (Object)"curator has to be started");
        Preconditions.checkArgument((maxLeases > 0 ? 1 : 0) != 0, (Object)"maxLeases has to be greater than zero");
        this.maxLeases = maxLeases;
        this.lockingPath = lockingPath;
    }

    public ZooKeeperLockFactory(CuratorFramework curator, String lockingPath) {
        this(curator, 1, lockingPath);
    }

    @Override
    public void clearLock(String name) {
        try {
            this.curator.delete().forPath(this.lockingPath + name);
        }
        catch (Exception e) {
            throw new LockingException(e);
        }
    }

    @Override
    public Lock makeLock(String name) {
        InterProcessSemaphoreV2 semaphore = new InterProcessSemaphoreV2(this.curator, this.lockingPath + name, this.maxLeases);
        return new ZooKeeperLock(semaphore);
    }

    private static class ZooKeeperLock
    implements Lock {
        private final InterProcessSemaphoreV2 semaphore;
        private Lease lease;

        private ZooKeeperLock(InterProcessSemaphoreV2 semaphore) {
            this.semaphore = semaphore;
        }

        @Override
        public void lock() {
            try {
                this.lease = this.semaphore.acquire();
            }
            catch (Exception e) {
                throw new LockingException(e);
            }
        }

        @Override
        public boolean tryLock() {
            try {
                this.lease = this.semaphore.acquire(1L, TimeUnit.MILLISECONDS);
                return this.lease != null;
            }
            catch (Exception e) {
                throw new LockingException(e);
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) {
            try {
                this.lease = this.semaphore.acquire(time, unit);
                return this.lease != null;
            }
            catch (Exception e) {
                throw new LockingException(e);
            }
        }

        @Override
        public void unlock() {
            try {
                this.semaphore.returnLease(this.lease);
            }
            catch (Exception e) {
                throw new LockingException(e);
            }
        }
    }
}

