/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.fuzzy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.RAMDirectory;
import org.gbif.ecat.fuzzy.FuzzyNameMatch;
import org.gbif.ecat.fuzzy.FuzzyNameMatcher;
import org.gbif.ecat.fuzzy.FuzzyNameMatcherLucene;
import org.gbif.ecat.fuzzy.ScientificNameDistance;
import org.gbif.ecat.fuzzy.StringDistance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuzzyNameMatcherLuceneCompleteName
implements FuzzyNameMatcher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean debug = this.log.isDebugEnabled();
    private Map<Integer, FuzzyNameMatch> fuzzyNames;
    private Directory index;
    private StringDistance distanceAlgorithm = new ScientificNameDistance();
    private IndexSearcher searcher;
    private AtomicLong straightCalls = new AtomicLong(0L);
    private AtomicLong straightHits = new AtomicLong(0L);
    private AtomicLong fuzzyCalls = new AtomicLong(0L);
    private AtomicLong fuzzyHits = new AtomicLong(0L);
    private CountReporter reporterThread;
    private int prefixLength = 1;
    private int topDocs = 100;

    public FuzzyNameMatcherLuceneCompleteName() {
    }

    public FuzzyNameMatcherLuceneCompleteName(Collection<FuzzyNameMatch> names) {
        this.initialize(names);
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public void setPrefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
    }

    public int getTopDocs() {
        return this.topDocs;
    }

    public void setTopDocs(int topDocs) {
        this.topDocs = topDocs;
    }

    @Override
    public void initialize(Collection<FuzzyNameMatch> rawNames) {
        this.log.info("Initializing lucene index");
        this.fuzzyNames = new HashMap<Integer, FuzzyNameMatch>(rawNames.size());
        for (FuzzyNameMatch n : rawNames) {
            if (StringUtils.isBlank((CharSequence)n.name)) continue;
            n.name = this.normalizeName(n.name);
            this.fuzzyNames.put(n.id, n);
        }
        this.buildIndex();
        try {
            this.searcher = new IndexSearcher(this.index);
        }
        catch (CorruptIndexException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.reporterThread = new CountReporter();
        this.reporterThread.start();
        this.log.info("Lucene index initialization complete");
    }

    private String normalizeName(String name) {
        return name.toLowerCase().trim();
    }

    private void buildIndex() {
        try {
            this.index = new RAMDirectory();
            IndexWriter writer = new IndexWriter(this.index, new IndexWriterConfig(FuzzyNameMatcherLucene.LUCENE_VERSION, (Analyzer)new KeywordAnalyzer()));
            for (FuzzyNameMatch fuzzyName : this.fuzzyNames.values()) {
                writer.addDocument(this.createDocument(fuzzyName));
            }
            writer.optimize();
            writer.close();
        }
        catch (CorruptIndexException e) {
            e.printStackTrace();
        }
        catch (LockObtainFailedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Document createDocument(FuzzyNameMatch fuzzy) {
        Document doc = new Document();
        doc.add((Fieldable)new Field("name", fuzzy.name, Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("id", String.valueOf(fuzzy.id), Field.Store.YES, Field.Index.NO));
        return doc;
    }

    private List<FuzzyNameMatch> search(String queryString, float similarity) throws IOException, ParseException {
        ArrayList<FuzzyNameMatch> results = new ArrayList<FuzzyNameMatch>();
        if (queryString.replaceAll("-", "").trim().isEmpty()) {
            this.log.debug("Received empty or illegal queryString [" + queryString + "] returning empty results.");
            return results;
        }
        Term term = new Term("name", queryString);
        TermQuery query = similarity >= 1.0f ? new TermQuery(term) : new FuzzyQuery(term, similarity, this.prefixLength);
        TopDocs topDocs = this.searcher.search((Query)query, this.topDocs);
        int hitCount = topDocs.totalHits;
        if (hitCount > 0) {
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Document doc = this.searcher.doc(scoreDoc.doc);
                FuzzyNameMatch match = this.fuzzyNames.get(Integer.valueOf(doc.get("id")));
                match.similarity = scoreDoc.score;
                results.add(match);
            }
        }
        return results;
    }

    @Override
    public List<FuzzyNameMatch> straightMatch(String name) {
        name = this.normalizeName(name);
        if (this.debug) {
            this.log.debug(">> straightMatch [" + name + "]");
        }
        this.straightCalls.addAndGet(1L);
        try {
            List<FuzzyNameMatch> results = this.search(name, 1.0f);
            this.log.debug("<< straightMatch [" + name + "] - [" + results.size() + "] hits");
            if (!results.isEmpty()) {
                this.straightHits.addAndGet(1L);
            }
            if (this.debug) {
                this.log.debug("<< straightMatch [" + name + "] - [" + results.size() + "] hits");
            }
            return results;
        }
        catch (CorruptIndexException e) {
            this.log.error("CorruptIndexException when doing straight lucene match on " + name, (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("IOException when doing straight lucene match on " + name, (Throwable)e);
        }
        catch (ParseException e) {
            this.log.error("ParseException when doing straight lucene match on " + name, (Throwable)e);
        }
        return new ArrayList<FuzzyNameMatch>();
    }

    @Override
    public List<FuzzyNameMatch> fuzzyMatch(String name, float maxDistance) {
        name = name.toLowerCase();
        if (this.debug) {
            this.log.debug(">> fuzzyMatch [" + name + "] [" + maxDistance + "]");
        }
        this.fuzzyCalls.addAndGet(1L);
        List<Object> innerResults = new ArrayList();
        try {
            innerResults = this.search(name, maxDistance);
        }
        catch (CorruptIndexException e) {
            this.log.error("CorruptIndexException when doing fuzzy lucene match on " + name, (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("IOException when doing fuzzy lucene match on " + name, (Throwable)e);
        }
        catch (ParseException e) {
            this.log.error("ParseException when doing fuzzy lucene match on " + name, (Throwable)e);
        }
        ArrayList<FuzzyNameMatch> results = new ArrayList<FuzzyNameMatch>();
        for (FuzzyNameMatch fuzzyNameMatch : innerResults) {
            float distance = this.distanceAlgorithm.getDistance(name, fuzzyNameMatch.name);
            if (!(distance >= maxDistance)) continue;
            fuzzyNameMatch.similarity = distance;
            results.add(fuzzyNameMatch);
        }
        if (!results.isEmpty()) {
            this.fuzzyHits.addAndGet(1L);
        }
        if (this.debug) {
            this.log.debug("<< fuzzyMatch [" + name + "] [" + maxDistance + "] - [" + results.size() + "] hits");
        }
        return results;
    }

    private class CountReporter
    extends Thread {
        private CountReporter() {
        }

        @Override
        public void run() {
            boolean interrupted = false;
            while (!interrupted) {
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    FuzzyNameMatcherLuceneCompleteName.this.log.info("Reporter thread interrupted, exiting");
                    interrupted = true;
                }
            }
        }
    }
}

