/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.networking.clustering;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class ClusterNodesHash<T> {
    private final HashCalculator hasher;
    private final int replicationFactor;
    private volatile SortedMap<Long, T> ring;
    private volatile HashMap<String, T> nodeMap;

    public ClusterNodesHash(int replicationFactor) {
        this(new HashCalculator(), replicationFactor, new ArrayList());
    }

    public ClusterNodesHash(int replicationFactor, Collection<T> clusterNodes) {
        this(new HashCalculator(), replicationFactor, clusterNodes);
    }

    public ClusterNodesHash(HashCalculator hasher, int replicationFactor, Collection<T> clusterNodes) {
        this.hasher = hasher;
        this.replicationFactor = replicationFactor;
        this.setMembers(clusterNodes);
    }

    public Set<T> setMembers(Collection<T> clusterNodes) {
        HashSet<Object> removedNodes;
        TreeMap<Long, T> newRing = new TreeMap<Long, T>();
        HashMap newNodeMap = new HashMap();
        for (T node : clusterNodes) {
            this.addNode(newRing, newNodeMap, node, this.replicationFactor);
        }
        if (this.ring == null) {
            removedNodes = new HashSet();
        } else {
            removedNodes = new HashSet<T>(this.ring.values());
            removedNodes.removeAll(newRing.values());
        }
        this.ring = newRing;
        this.nodeMap = newNodeMap;
        return removedNodes;
    }

    public T getNodeById(String nodeId) {
        HashMap<String, T> currNodeMap = this.nodeMap;
        return (T)((AbstractMap)currNodeMap).get(nodeId);
    }

    public T getNodeByResponsibility(String objectId) {
        SortedMap<Long, T> currRing = this.ring;
        if (currRing.isEmpty()) {
            return null;
        }
        long hash = this.hasher.hash(objectId);
        if (!currRing.containsKey(hash)) {
            SortedMap<Long, T> tailMap = currRing.tailMap(hash);
            hash = tailMap.isEmpty() ? currRing.firstKey() : tailMap.firstKey();
        }
        return (T)currRing.get(hash);
    }

    private void addNode(SortedMap<Long, T> circle, AbstractMap<String, T> nodeMap, T node, int replicationFactor) {
        for (int i = 0; i < replicationFactor; ++i) {
            circle.put(this.hasher.hash(node.toString() + i), node);
        }
        nodeMap.put(node.toString(), node);
    }

    public static class HashCalculator {
        MessageDigest md;

        public HashCalculator() {
            block2: {
                try {
                    this.md = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError();
                }
            }
        }

        public HashCalculator(String hashName) throws NoSuchAlgorithmException {
            this.md = MessageDigest.getInstance(hashName);
        }

        long hash(String key) {
            this.md.reset();
            this.md.update(key.getBytes());
            byte[] digest = this.md.digest();
            long h = 0L;
            for (int i = 0; i < 4; ++i) {
                h <<= 8;
                h |= (long)(digest[i] & 0xFF);
            }
            return h;
        }
    }
}

