/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.TimeZone;

public class XsDateTimeFormat
extends Format {
    final boolean parseDate;
    final boolean parseTime;

    XsDateTimeFormat(boolean pParseDate, boolean pParseTime) {
        this.parseDate = pParseDate;
        this.parseTime = pParseTime;
    }

    public XsDateTimeFormat() {
        this(true, true);
    }

    private int parseInt(String pString, int pOffset, StringBuffer pDigits) {
        char c;
        int length = pString.length();
        pDigits.setLength(0);
        while (pOffset < length && Character.isDigit(c = pString.charAt(pOffset))) {
            pDigits.append(c);
            ++pOffset;
        }
        return pOffset;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object parseObject(String pString, ParsePosition pParsePosition) {
        int millis;
        int second;
        int minute;
        int hour;
        int mday;
        int month;
        int year;
        StringBuffer digits;
        boolean isMinus;
        int length;
        int offset;
        block27: {
            block35: {
                block40: {
                    block41: {
                        block39: {
                            block37: {
                                block38: {
                                    block36: {
                                        block26: {
                                            block28: {
                                                block33: {
                                                    block34: {
                                                        block32: {
                                                            block30: {
                                                                block31: {
                                                                    block29: {
                                                                        if (pString == null) {
                                                                            throw new NullPointerException("The String argument must not be null.");
                                                                        }
                                                                        if (pParsePosition == null) {
                                                                            throw new NullPointerException("The ParsePosition argument must not be null.");
                                                                        }
                                                                        offset = pParsePosition.getIndex();
                                                                        length = pString.length();
                                                                        isMinus = false;
                                                                        digits = new StringBuffer();
                                                                        if (!this.parseDate) break block28;
                                                                        if (offset < length) {
                                                                            char c = pString.charAt(offset);
                                                                            if (c == '+') {
                                                                                ++offset;
                                                                            } else if (c == '-') {
                                                                                ++offset;
                                                                                isMinus = true;
                                                                            }
                                                                        }
                                                                        offset = this.parseInt(pString, offset, digits);
                                                                        if (digits.length() < 4) {
                                                                            pParsePosition.setErrorIndex(offset);
                                                                            return null;
                                                                        }
                                                                        year = Integer.parseInt(digits.toString());
                                                                        if (offset >= length || pString.charAt(offset) != '-') break block29;
                                                                        ++offset;
                                                                        offset = this.parseInt(pString, offset, digits);
                                                                        if (digits.length() == 2) break block30;
                                                                        break block31;
                                                                    }
                                                                    pParsePosition.setErrorIndex(offset);
                                                                    return null;
                                                                }
                                                                pParsePosition.setErrorIndex(offset);
                                                                return null;
                                                            }
                                                            month = Integer.parseInt(digits.toString());
                                                            if (offset >= length || pString.charAt(offset) != '-') break block32;
                                                            ++offset;
                                                            offset = this.parseInt(pString, offset, digits);
                                                            if (digits.length() == 2) break block33;
                                                            break block34;
                                                        }
                                                        pParsePosition.setErrorIndex(offset);
                                                        return null;
                                                    }
                                                    pParsePosition.setErrorIndex(offset);
                                                    return null;
                                                }
                                                mday = Integer.parseInt(digits.toString());
                                                if (this.parseTime) {
                                                    if (offset < length && pString.charAt(offset) == 'T') {
                                                        ++offset;
                                                        break block26;
                                                    } else {
                                                        pParsePosition.setErrorIndex(offset);
                                                        return null;
                                                    }
                                                }
                                                break block26;
                                            }
                                            mday = 0;
                                            month = 0;
                                            year = 0;
                                        }
                                        if (!this.parseTime) break block35;
                                        offset = this.parseInt(pString, offset, digits);
                                        if (digits.length() != 2) {
                                            pParsePosition.setErrorIndex(offset);
                                            return null;
                                        }
                                        hour = Integer.parseInt(digits.toString());
                                        if (offset >= length || pString.charAt(offset) != ':') break block36;
                                        ++offset;
                                        offset = this.parseInt(pString, offset, digits);
                                        if (digits.length() == 2) break block37;
                                        break block38;
                                    }
                                    pParsePosition.setErrorIndex(offset);
                                    return null;
                                }
                                pParsePosition.setErrorIndex(offset);
                                return null;
                            }
                            minute = Integer.parseInt(digits.toString());
                            if (offset >= length || pString.charAt(offset) != ':') break block39;
                            ++offset;
                            offset = this.parseInt(pString, offset, digits);
                            if (digits.length() == 2) break block40;
                            break block41;
                        }
                        pParsePosition.setErrorIndex(offset);
                        return null;
                    }
                    pParsePosition.setErrorIndex(offset);
                    return null;
                }
                second = Integer.parseInt(digits.toString());
                if (offset < length && pString.charAt(offset) == '.') {
                    ++offset;
                    offset = this.parseInt(pString, offset, digits);
                    if (digits.length() > 0) {
                        millis = Integer.parseInt(digits.toString());
                        if (millis > 999) {
                            pParsePosition.setErrorIndex(offset);
                            return null;
                        }
                        for (int i = digits.length(); i < 3; millis *= 10, ++i) {
                        }
                        break block27;
                    } else {
                        millis = 0;
                    }
                    break block27;
                } else {
                    millis = 0;
                }
                break block27;
            }
            millis = 0;
            second = 0;
            minute = 0;
            hour = 0;
        }
        digits.setLength(0);
        digits.append("GMT");
        if (offset < length) {
            char c = pString.charAt(offset);
            if (c == 'Z') {
                ++offset;
            } else if (c == '+' || c == '-') {
                digits.append(c);
                ++offset;
                for (int i = 0; i < 5; ++offset, ++i) {
                    if (offset >= length) {
                        pParsePosition.setErrorIndex(offset);
                        return null;
                    }
                    c = pString.charAt(offset);
                    if (i != 2 && Character.isDigit(c) || i == 2 && c == ':') {
                        digits.append(c);
                        continue;
                    }
                    pParsePosition.setErrorIndex(offset);
                    return null;
                }
            }
        }
        TimeZone tz = this.parseTime ? TimeZone.getTimeZone(digits.toString()) : TimeZone.getTimeZone("GMT");
        Calendar cal = Calendar.getInstance(tz);
        cal.clear();
        if (this.parseDate) {
            cal.set(1, isMinus ? -year : year);
            cal.set(2, month - 1);
            cal.set(5, mday);
        }
        if (this.parseTime) {
            cal.set(11, hour);
            cal.set(12, minute);
            cal.set(13, second);
            cal.set(14, millis);
        }
        pParsePosition.setIndex(offset);
        return cal;
    }

    private void append(StringBuffer pBuffer, int pNum, int pMinLen) {
        String s = Integer.toString(pNum);
        for (int i = s.length(); i < pMinLen; ++i) {
            pBuffer.append('0');
        }
        pBuffer.append(s);
    }

    @Override
    public StringBuffer format(Object pCalendar, StringBuffer pBuffer, FieldPosition pPos) {
        if (pCalendar == null) {
            throw new NullPointerException("The Calendar argument must not be null.");
        }
        if (pBuffer == null) {
            throw new NullPointerException("The StringBuffer argument must not be null.");
        }
        if (pPos == null) {
            throw new NullPointerException("The FieldPosition argument must not be null.");
        }
        Calendar cal = (Calendar)pCalendar;
        if (this.parseDate) {
            int year = cal.get(1);
            if (year < 0) {
                pBuffer.append('-');
                year = -year;
            }
            this.append(pBuffer, year, 4);
            pBuffer.append('-');
            this.append(pBuffer, cal.get(2) + 1, 2);
            pBuffer.append('-');
            this.append(pBuffer, cal.get(5), 2);
            if (this.parseTime) {
                pBuffer.append('T');
            }
        }
        if (this.parseTime) {
            this.append(pBuffer, cal.get(11), 2);
            pBuffer.append(':');
            this.append(pBuffer, cal.get(12), 2);
            pBuffer.append(':');
            this.append(pBuffer, cal.get(13), 2);
            int millis = cal.get(14);
            if (millis > 0) {
                pBuffer.append('.');
                this.append(pBuffer, millis, 3);
            }
        }
        TimeZone tz = cal.getTimeZone();
        int offset = cal.get(15);
        if (tz.inDaylightTime(cal.getTime())) {
            offset += cal.get(16);
        }
        if (offset == 0) {
            pBuffer.append('Z');
        } else {
            if (offset < 0) {
                pBuffer.append('-');
                offset = -offset;
            } else {
                pBuffer.append('+');
            }
            int minutes = offset / 60000;
            int hours = minutes / 60;
            this.append(pBuffer, hours, 2);
            pBuffer.append(':');
            this.append(pBuffer, minutes -= hours * 60, 2);
        }
        return pBuffer;
    }
}

