/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.http.annotation.Experimental;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.TransientSolrCoreCache;
import org.apache.solr.core.TransientSolrCoreCacheFactory;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SolrCores
implements Observer {
    private static Object modifyLock = new Object();
    private final Map<String, SolrCore> cores = new LinkedHashMap<String, SolrCore>();
    private final Map<String, CoreDescriptor> residentDesciptors = new LinkedHashMap<String, CoreDescriptor>();
    private final CoreContainer container;
    private Set<String> currentlyLoadingCores = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Set<String> pendingCoreOps = new HashSet<String>();
    private static final List<SolrCore> pendingCloses = new ArrayList<SolrCore>();
    private TransientSolrCoreCacheFactory transientCoreCache;
    private TransientSolrCoreCache transientSolrCoreCache = null;

    SolrCores(CoreContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCoreDescriptor(CoreDescriptor p) {
        Object object = modifyLock;
        synchronized (object) {
            if (p.isTransient()) {
                if (this.getTransientCacheHandler() != null) {
                    this.getTransientCacheHandler().addTransientDescriptor(p.getName(), p);
                } else {
                    log.warn("We encountered a core marked as transient, but there is no transient handler defined. This core will be inaccessible");
                }
            } else {
                this.residentDesciptors.put(p.getName(), p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCoreDescriptor(CoreDescriptor p) {
        Object object = modifyLock;
        synchronized (object) {
            if (p.isTransient()) {
                if (this.getTransientCacheHandler() != null) {
                    this.getTransientCacheHandler().removeTransientDescriptor(p.getName());
                }
            } else {
                this.residentDesciptors.remove(p.getName());
            }
        }
    }

    public void load(SolrResourceLoader loader) {
        this.transientCoreCache = TransientSolrCoreCacheFactory.newInstance(loader, this.container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        this.waitForLoadingCoresToFinish(30000L);
        ArrayList<SolrCore> coreList = new ArrayList<SolrCore>();
        TransientSolrCoreCache transientSolrCoreCache = this.getTransientCacheHandler();
        if (transientSolrCoreCache != null) {
            transientSolrCoreCache.close();
        }
        do {
            coreList.clear();
            Object object = modifyLock;
            synchronized (object) {
                coreList.addAll(this.cores.values());
                this.cores.clear();
                if (transientSolrCoreCache != null) {
                    coreList.addAll(transientSolrCoreCache.prepareForShutdown());
                }
                coreList.addAll(pendingCloses);
                pendingCloses.clear();
            }
            ExecutorService coreCloseExecutor = ExecutorUtil.newMDCAwareFixedThreadPool((int)Integer.MAX_VALUE, (ThreadFactory)new DefaultSolrThreadFactory("coreCloseExecutor"));
            try {
                for (SolrCore core : coreList) {
                    coreCloseExecutor.submit(() -> {
                        MDCLoggingContext.setCore(core);
                        try {
                            core.close();
                        }
                        catch (Throwable e) {
                            SolrException.log((Logger)log, (String)"Error shutting down core", (Throwable)e);
                            if (e instanceof Error) {
                                throw (Error)e;
                            }
                        }
                        finally {
                            MDCLoggingContext.clear();
                        }
                        return core;
                    });
                }
            }
            finally {
                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)coreCloseExecutor);
            }
        } while (coreList.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore putCore(CoreDescriptor cd, SolrCore core) {
        Object object = modifyLock;
        synchronized (object) {
            if (cd.isTransient()) {
                if (this.getTransientCacheHandler() != null) {
                    return this.getTransientCacheHandler().addCore(cd.getName(), core);
                }
            } else {
                return this.cores.put(cd.getName(), core);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SolrCore> getCores() {
        ArrayList<SolrCore> lst = new ArrayList<SolrCore>();
        Object object = modifyLock;
        synchronized (object) {
            lst.addAll(this.cores.values());
            return lst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getLoadedCoreNames() {
        TreeSet<String> set = new TreeSet<String>();
        Object object = modifyLock;
        synchronized (object) {
            set.addAll(this.cores.keySet());
            if (this.getTransientCacheHandler() != null) {
                set.addAll(this.getTransientCacheHandler().getLoadedCoreNames());
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Experimental
    List<String> getNamesForCore(SolrCore core) {
        ArrayList<String> lst = new ArrayList<String>();
        Object object = modifyLock;
        synchronized (object) {
            for (Map.Entry<String, SolrCore> entry : this.cores.entrySet()) {
                if (core != entry.getValue()) continue;
                lst.add(entry.getKey());
            }
            if (this.getTransientCacheHandler() != null) {
                lst.addAll(this.getTransientCacheHandler().getNamesForCore(core));
            }
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAllCoreNames() {
        TreeSet<String> set = new TreeSet<String>();
        Object object = modifyLock;
        synchronized (object) {
            set.addAll(this.cores.keySet());
            if (this.getTransientCacheHandler() != null) {
                set.addAll(this.getTransientCacheHandler().getAllCoreNames());
            }
            set.addAll(this.residentDesciptors.keySet());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SolrCore getCore(String name) {
        Object object = modifyLock;
        synchronized (object) {
            return this.cores.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swap(String n0, String n1) {
        Object object = modifyLock;
        synchronized (object) {
            SolrCore c0 = this.cores.get(n0);
            SolrCore c1 = this.cores.get(n1);
            if (c0 == null && (c0 = this.container.getCore(n0)) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n0);
            }
            if (c1 == null && (c1 = this.container.getCore(n1)) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n1);
            }
            CoreDescriptor cd1 = c1.getCoreDescriptor();
            this.addCoreDescriptor(new CoreDescriptor(n1, c0.getCoreDescriptor()));
            this.addCoreDescriptor(new CoreDescriptor(n0, cd1));
            this.cores.put(n0, c1);
            this.cores.put(n1, c0);
            c0.setName(n1);
            c1.setName(n0);
            this.container.getMetricManager().swapRegistries(c0.getCoreMetricManager().getRegistryName(), c1.getCoreMetricManager().getRegistryName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore remove(String name) {
        Object object = modifyLock;
        synchronized (object) {
            SolrCore ret = this.cores.remove(name);
            TransientSolrCoreCache transientHandler = this.getTransientCacheHandler();
            if (ret == null && transientHandler != null) {
                ret = transientHandler.removeCore(name);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SolrCore getCoreFromAnyList(String name, boolean incRefCount) {
        Object object = modifyLock;
        synchronized (object) {
            SolrCore core = this.cores.get(name);
            if (core == null && this.getTransientCacheHandler() != null) {
                core = this.getTransientCacheHandler().getCore(name);
            }
            if (core != null && incRefCount) {
                core.open();
            }
            return core;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLoadedNotPendingClose(String name) {
        Object object = modifyLock;
        synchronized (object) {
            if (this.cores.containsKey(name)) {
                return true;
            }
            if (this.getTransientCacheHandler() != null && this.getTransientCacheHandler().containsCore(name)) {
                for (SolrCore core : pendingCloses) {
                    if (!core.getName().equals(name)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLoaded(String name) {
        Object object = modifyLock;
        synchronized (object) {
            if (this.cores.containsKey(name)) {
                return true;
            }
            if (this.getTransientCacheHandler() != null && this.getTransientCacheHandler().containsCore(name)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoreDescriptor getUnloadedCoreDescriptor(String cname) {
        Object object = modifyLock;
        synchronized (object) {
            CoreDescriptor desc = this.residentDesciptors.get(cname);
            if (desc == null) {
                if (this.getTransientCacheHandler() == null) {
                    return null;
                }
                desc = this.getTransientCacheHandler().getTransientDescriptor(cname);
                if (desc == null) {
                    return null;
                }
            }
            return new CoreDescriptor(cname, desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore waitAddPendingCoreOps(String name) {
        Object object = modifyLock;
        synchronized (object) {
            boolean pending;
            do {
                if (!(pending = pendingCoreOps.contains(name))) {
                    for (SolrCore core : pendingCloses) {
                        if (!core.getName().equals(name)) continue;
                        pending = true;
                        break;
                    }
                }
                if (this.container.isShutDown()) {
                    return null;
                }
                if (!pending) continue;
                try {
                    modifyLock.wait();
                }
                catch (InterruptedException e) {
                    return null;
                }
            } while (pending);
            if (!this.container.isShutDown()) {
                if (!pendingCoreOps.add(name)) {
                    log.warn("Replaced an entry in pendingCoreOps {}, we should not be doing this", (Object)name);
                }
                return this.getCoreFromAnyList(name, false);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromPendingOps(String name) {
        Object object = modifyLock;
        synchronized (object) {
            if (!pendingCoreOps.remove(name)) {
                log.warn("Tried to remove core {} from pendingCoreOps and it wasn't there. ", (Object)name);
            }
            modifyLock.notifyAll();
        }
    }

    protected Object getModifyLock() {
        return modifyLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore getCoreToClose() {
        Object object = modifyLock;
        synchronized (object) {
            for (SolrCore core : pendingCloses) {
                if (pendingCoreOps.contains(core.getName())) continue;
                pendingCoreOps.add(core.getName());
                pendingCloses.remove(core);
                return core;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreDescriptor getCoreDescriptor(String coreName) {
        Object object = modifyLock;
        synchronized (object) {
            if (this.residentDesciptors.containsKey(coreName)) {
                return this.residentDesciptors.get(coreName);
            }
            return this.getTransientCacheHandler().getTransientDescriptor(coreName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CoreDescriptor> getCoreDescriptors() {
        ArrayList cds = Lists.newArrayList();
        Object object = modifyLock;
        synchronized (object) {
            for (String coreName : this.getAllCoreNames()) {
                CoreDescriptor cd = this.getCoreDescriptor(coreName);
                if (cd == null) continue;
                cds.add(cd);
            }
        }
        return cds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCoreAsLoading(CoreDescriptor cd) {
        Object object = modifyLock;
        synchronized (object) {
            this.currentlyLoadingCores.add(cd.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCoreAsNotLoading(CoreDescriptor cd) {
        Object object = modifyLock;
        synchronized (object) {
            this.currentlyLoadingCores.remove(cd.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLoadingCoresToFinish(long timeoutMs) {
        long time = System.nanoTime();
        long timeout = time + TimeUnit.NANOSECONDS.convert(timeoutMs, TimeUnit.MILLISECONDS);
        Object object = modifyLock;
        synchronized (object) {
            while (!this.currentlyLoadingCores.isEmpty()) {
                try {
                    modifyLock.wait(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (System.nanoTime() < timeout) continue;
                log.warn("Timed out waiting for SolrCores to finish loading.");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLoadingCoreToFinish(String core, long timeoutMs) {
        long time = System.nanoTime();
        long timeout = time + TimeUnit.NANOSECONDS.convert(timeoutMs, TimeUnit.MILLISECONDS);
        Object object = modifyLock;
        synchronized (object) {
            while (this.isCoreLoading(core)) {
                try {
                    modifyLock.wait(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (System.nanoTime() < timeout) continue;
                log.warn("Timed out waiting for SolrCore, {},  to finish loading.", (Object)core);
                break;
            }
        }
    }

    public boolean isCoreLoading(String name) {
        return this.currentlyLoadingCores.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        Object object = modifyLock;
        synchronized (object) {
            pendingCloses.add((SolrCore)arg);
            modifyLock.notifyAll();
        }
    }

    public TransientSolrCoreCache getTransientCacheHandler() {
        if (this.transientCoreCache == null) {
            log.error("No transient handler has been defined. Check solr.xml to see if an attempt to provide a custom TransientSolrCoreCacheFactory was done incorrectly since the default should have been used otherwise.");
            return null;
        }
        return this.transientCoreCache.getTransientSolrCoreCache();
    }
}

