/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.collection;

import java.lang.reflect.Array;

public class ArrayUtils {
    public static <T> T[] arrayMerge(T[] ... arrays) {
        int count = 0;
        for (T[] array : arrays) {
            count += array.length;
        }
        Object[] mergedArray = (Object[])Array.newInstance(arrays[0][0].getClass(), count);
        int start = 0;
        for (T[] array : arrays) {
            System.arraycopy(array, 0, mergedArray, start, array.length);
            start += array.length;
        }
        return mergedArray;
    }

    public static byte[] arrayMerge(byte[] ... arrays) {
        int count = 0;
        for (byte[] array : arrays) {
            count += array.length;
        }
        byte[] mergedArray = new byte[count];
        int start = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, mergedArray, start, array.length);
            start += array.length;
        }
        return mergedArray;
    }

    public static byte[] intToByteArray(int value) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFF);
        }
        return b;
    }

    public static int byteArrayToInt(byte[] b) {
        return (b[0] << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }

    private ArrayUtils() {
        throw new UnsupportedOperationException("Can't initialize class");
    }
}

