/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Configuration {
    protected static final Logger logger = Logger.getLogger(Configuration.class);
    private static Configuration instance = null;
    private final Properties config = new Properties();
    private List<String> spatialLayers = null;
    private String speciesUrl;
    private String categoriesUrl;
    private String zoneUrl;
    private String layersServiceUrl;

    private Configuration() throws Exception {
        String configFilePath = System.getProperty("sds.config.file", "/data/sds/config/sds-config.properties");
        logger.info((Object)("Loading the SDS using configuration from " + configFilePath));
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(configFilePath);
        if (inputStream == null) {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("." + configFilePath);
        }
        if (inputStream == null) {
            inputStream = new FileInputStream(configFilePath);
        }
        try {
            if (inputStream != null) {
                logger.info((Object)("Loading config for SDS from " + configFilePath));
                this.config.load(inputStream);
            } else {
                logger.warn((Object)"External config for SDS not found. Using defaults.");
            }
            this.speciesUrl = this.config.getProperty("sds.species.data", "https://sds.ala.org.au/sensitive-species-data.xml");
            this.categoriesUrl = this.config.getProperty("sds.category.data", "https://sds.ala.org.au/sensitivity-categories.xml");
            this.zoneUrl = this.config.getProperty("sds.zone.data", "https://sds.ala.org.au/sensitivity-zones.xml");
            this.layersServiceUrl = this.config.getProperty("layers.service.url", "http://spatial.ala.org.au/layers-service");
            this.spatialLayers = new ArrayList<String>();
            String configList = this.config.getProperty("sds.spatial.layers", "cl932,cl927,cl23,cl937,cl941,cl938,cl939,cl936,cl940,cl963,cl962,cl961,cl960,cl964,cl965,cl22");
            for (String layerId : configList.split(",")) {
                this.spatialLayers.add(layerId.trim());
            }
        }
        catch (IOException e) {
            logger.warn((Object)"External config for SDS not found. Using defaults.");
        }
    }

    public static Configuration getInstance() {
        try {
            if (instance == null) {
                instance = new Configuration();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return instance;
    }

    public static void reset() {
        instance = null;
    }

    public void setZoneUrl(String zoneUrl) {
        this.zoneUrl = zoneUrl;
    }

    public void setCategoriesUrl(String categoriesUrl) {
        this.categoriesUrl = categoriesUrl;
    }

    public void setSpeciesUrl(String speciesUrl) {
        this.speciesUrl = speciesUrl;
    }

    public void setLayersServiceUrl(String layersServiceUrl) {
        this.layersServiceUrl = layersServiceUrl;
    }

    public String get(String field) {
        return this.config.getProperty(field, field);
    }

    public String getFlagRules() {
        return this.config.getProperty("sds.flag.rules", "PBC7,PBC8,PBC9");
    }

    public String getSpeciesUrl() {
        return this.speciesUrl;
    }

    public String getCategoryUrl() {
        return this.categoriesUrl;
    }

    public String getZoneUrl() {
        return this.zoneUrl;
    }

    public boolean isCached() {
        return this.config.getProperty("sds.species.cache", "false").equalsIgnoreCase("true");
    }

    public String getCacheUrl() {
        return this.config.getProperty("sds.cache.data", "/data/sds/data/species-cache.ser");
    }

    public String getLayersServiceUrl() {
        return this.layersServiceUrl;
    }

    public String getNameMatchingIndex() {
        return this.config.getProperty("name.index.dir", "/data/lucene/namematching");
    }

    public String getListToolUrl() {
        return this.config.getProperty("list.tool.url", "https://lists.ala.org.au");
    }

    public List<String> getGeospatialLayers() {
        return this.spatialLayers;
    }

    public void setSpatialLayers(List<String> spatialLayers) {
        this.spatialLayers = spatialLayers;
    }
}

